#ifndef TOFILE_H
#define TOFILE_H

#ifdef __cplusplus
extern "C"
{
#endif

#include <stdint.h>

struct PlxToFileRegistry
{
   const char* fileName;
   int fileType;
   int writeDevice;
   int numSamples;
   int width;
   int bufferSize;
   int bufferOffset;
   int currentReadBuffer;
   int currentWriteBuffer;
   int currentPosition;
   int currentSize;
   int bufferFull[2];
   uint32_t bufferFullCount;
   uint32_t bufferFullReadCount;
   void* bufferPtr;
   int useDouble;
   int rotateFile;
};

void plxSendToFileInfoResponse(int aMsg, int aInstance, void* aBuffer);
void plxSetupToFile(int aInstance, const char* aFileName, unsigned int aWidth, unsigned int aNumSamples,
                    unsigned int aOffset, int aFileType, int aWriteDevice, int aUseDouble);
void plxUpdateToFile(int aInstance, const void* aDataValues);
int plxGetToFileBuffer(int aInstance, void* aDestination);
int plxGetToFileBufferFullCount(int aInstance);
int plxGetNumToFileBlocks(void);
void plxSendToFileBufferFullMsgs(void);
void plxRotateToFile(int aInstance);

#ifdef __cplusplus
}
#endif

#endif
