/*
   Copyright (c) 2017 by Plexim GmbH
   All rights reserved.

   A free license is granted to anyone to use this software for any legal
   non safety-critical purpose, including commercial applications, provided
   that:
   1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
   2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
   SOFTWARE.
 */
#ifndef HIL_FRAMEWORK_H_
#define HIL_FRAMEWORK_H_

#include "plexim/ScopeBuffer.h"
#include <stdint.h>

#ifdef __cplusplus
extern "C"
{
#endif

#pragma pack(push, 4)

struct PlxArmResponse
{
   int msg;
   int mMsgLength;
   int mTransactionId;
   int mLength;
   float mSampleTime;
   int mBufferIndex;
   int mOffset;
   int mNumActiveSignals;
   unsigned short mActiveSignals[1];
};

struct PlxTriggerInfo
{
   int mTransactionId;
   int mLength;
   int mEdge; 
   float mTriggerValue;
   int mTriggerChannel;
   int mDecimation;
   int mTriggerDelay;
   int mNumActiveSignals;
   unsigned short mActiveSignals[1];
};

struct CanReceiveMsg
{
   unsigned char mModule;
   unsigned int mCanId;
   uint8_t mDataLength;
   uint8_t  reserverd1;
   uint8_t  reserverd2;
   uint8_t  reserverd3;
   const char mData[8];
};

struct UdpReceiveMsg
{
   uint16_t mPort;
   uint16_t mDataLength;
   const char mData[1]; // dummy placeholder array of length 1
};

struct PlxModelFunctions
{
   void (*init)(void);
   void (*sync)(void);
   void (*step)(void);
   void (*step1)(void);
   void (*step2)(void);
   void (*terminate)(void);
   void (*initializeScopeTrigger)(void);
   void (*copyTunableParams)(const double*);
};

struct PlxCoreTiming
{
   uint32_t mCore1Tick;
   uint32_t mCore1Period;
   uint32_t mCore2Tick;
   uint32_t mCore2Period;
};

struct PlxNanostepSignal
{
    uint32_t mIsSwitch;
    uint32_t mProbeIndex;
    float mGain;
    uint32_t mMask;
};


void plxStartSimulationModel(double aModelSampleTime, int aFloatSize,
                             int aUseExternalMode, int aNumExtModeSignals,
                             int aNumNanostepExtModeSignals,
                             int aNumTunableParameters,
                             struct PlxTriggerInfo* aTriggerInfo,
                             struct PlxArmResponse* aArmResponse,
                             const char* aModelChecksum,
                             const char* aModelName,
                             struct PlxModelFunctions* aModelFunctions,
                             struct PlxCoreTiming* aCoreTiming,
                             struct PlxNanostepSignal* aNanostepSignals,
                             int aCopyOutputBuffer, int aNumTasksOnCore0,
                             int aMaxPeriodTicks);
                                
void plxSetMaxNumConsecutiveOverruns(int aNumOverruns); 

typedef void (*PlxBackgroundTaskCallback)(void);
void plxRegisterStandaloneBackgroundTask(void);
void plxMulticoreSyncedStep(void);
void plxPostBaseStep(void);
void plxCancelTimingMeasurement(void);
void plxXcpEvent(void);
void plxEnableRcpMode(void);
void plxPostBaseStep(void);
double plxGetSampleTime(void);

extern volatile int scopeArmed;
extern volatile int scopeTriggered;
extern volatile int plxCurrentWriteBuffer;
extern struct ScopeBuffer plxScopeBuffer[];
extern volatile int plxErrorFlag;
extern volatile int plxShutdownFlag;

#pragma pack(pop)

#ifdef __cplusplus
}
#endif

#endif
