/*
   Copyright (c) 2017 by Plexim GmbH
   All rights reserved.

   A free license is granted to anyone to use this software for any legal
   non safety-critical purpose, including commercial applications, provided
   that:
   1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
   2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
   SOFTWARE.
 */

#ifndef NANOSTEP_H_
#define NANOSTEP_H_

#include <stdint.h>

#define NANOSTEP_SIZE 4e-9

#ifdef __cplusplus
extern "C"
{
#endif

typedef struct {
    uint32_t A1_11;
    uint32_t A1_14;
    uint32_t A1_22;
    uint32_t A1_25;
    uint32_t A1_33;
    uint32_t A1_36;

    uint32_t A12_11;
    uint32_t A12_13;
    uint32_t A12_14;
    uint32_t A23_22;
    uint32_t A23_23;
    uint32_t A23_24;
    uint32_t A13_11;
    uint32_t A13_13;
    uint32_t A13_14;

    uint32_t A3_11;
    uint32_t A3_12;
    uint32_t A3_13;
    uint32_t A3_14;
    uint32_t A3_21;
    uint32_t A3_22;
    uint32_t A3_23;
    uint32_t A3_24;

    uint32_t B1_11;
    uint32_t B1_22;
    uint32_t B1_2_22;
    uint32_t B1_33;

    uint32_t B12_11;
    uint32_t B23_22;
    uint32_t B13_13;
    uint32_t B12_2_11;
    uint32_t B23_2_22;

    uint32_t B3_11;
    uint32_t B3_12;
    uint32_t B3_13;
    uint32_t B3_21;
    uint32_t B3_22;
    uint32_t B3_23;

    uint32_t Cx_vec_1;
    uint32_t Cx_vec_2;
    uint32_t Cx_vec_3;

    int switch_indices[24];
    int switch_mask[24];
    int switch_mask_val[24];
    int sw_a_pos_en[6];
    int sw_a_neg_en[6];
    int sw_b_pos_en[6];
    int sw_b_neg_en[6];

    float sampletime;
    int singlephase;
    int useFlexarrayModel;
    int twophase;
    int threephase;
    int psfb;
    int clamp_a[3];
    int ignore_voltage_a[3];
    int clamp_b[3];
    int ignore_voltage_b[3];
    int send_iL_vC;
    int commonrail_a;
    int commonrail_b;
    int totempole;
    int matrix;
    int io_ph2to1;
    int inject_v_ac;
    int enable_computations[15];
    uint32_t alternative_selection;
    int downshift_en[8];
    int assertion_en;
} nanostep_parameters_t;

#define setNanostepPrimaryVoltageOut(aInstance, aPartial, x) \
{ \
   *(plxIoOut.NanostepVoltageOutput + ((aInstance)*2 + (aPartial)*4 + 0)) = (float)(x); \
}

#define setNanostepSecondaryVoltageOut(aInstance, aPartial, x) \
{ \
   *(plxIoOut.NanostepVoltageOutput + ((aInstance)*2 + (aPartial)*4 + 1)) = (float)(x); \
}

#define getNanostepPrimaryCurrent(aInstance, aPartial) \
plxIoIn.NanostepCurrentInput[(aInstance) * 2 + (aPartial) * 4 + 0]

#define getNanostepSecondaryCurrent(aInstance, aPartial) \
    plxIoIn.NanostepCurrentInput[(aInstance) * 2 + (aPartial) * 4 + 1]

#define getNanostepInductorCurrent(aInstance, aPartial) \
    plxIoIn.NanostepILVCInput[(aInstance) * 6 + (aPartial)]

#define getNanostepCapacitorVoltage(aInstance, aPartial) \
    plxIoIn.NanostepILVCInput[(aInstance) * 6 + (aPartial) + 3]
    
int getNanostepNumCurrentInputBeats(void);
int getNanostepNumILVCInputBeats(void);
int getNanostepVoltageOutputSize(void);
int getNanostepCurrentInputSize(void);
int getNanostepILVCInputSize(void);

void setupFullNanostep(int aInstance, nanostep_parameters_t *parameters);
void setupPartialNanostep(int aInstance, int aPartial, nanostep_parameters_t* aParameters);
void resetNanostepSolver(int aInstance);
void disableNanostepSolver(int aInstance);
void enableNanostepSolver(int aInstance);

void plxReconfigureNanostepForFlexarrayModel(int aId, float aStepSize);

int is_nanostep_solver_using_flexarray_model(int aInstance);
int isNanostepSolverActive(int aInstance);

void nanostep_ignore_voltage(int aInstance, int voltage_index);
void nanostep_invert_voltage(int aInstance, int voltage_index);
void plxSetupNanostepDACAbsIL(int aInstance, int aInductorIndex);

uint32_t get_nanostep_overflow_flags(int aInstance);

void setComponentUsingNanostep(int aInstance, int aPartial, char* component);
char* getComponentUsingNanostep(int aInstance, int aPartial);
void calculateNanostepAccumulatorAmplitudeLimit(float aStepSize);

char* getNanostepErrorMessage(uint32_t solver_0_flags, uint32_t solver_1_flags);

#ifdef __cplusplus
}
#endif

#endif /* NANOSTEP_H_ */
