/*
   Copyright (c) 2020 by Plexim GmbH
   All rights reserved.

   A free license is granted to anyone to use this software for any legal
   non safety-critical purpose, including commercial applications, provided
   that:
   1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
   2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
   SOFTWARE.
 */

#ifndef RESOLVERIN_H_
#define RESOLVERIN_H_

#include "plexim/hw_wrapper.h"

typedef enum {
	PLX_EXC_3V2,
	PLX_EXC_6V4,
	PLX_EXC_11V1,
	PLX_EXC_14V3
} PlxExciterVoltage;

typedef enum {
	PLX_EXC_16Bit,
	PLX_EXC_14Bit,
	PLX_EXC_12Bit,
	PLX_EXC_10Bit
} PlxExciterResolution;

typedef enum {
	PLX_EXC_MEASURE_POSITION,
	PLX_EXC_MEASURE_SPEED
} PlxExciterMeasurement;

PlxStatus setupResolverIn(int aModule, 
   PlxExciterMeasurement aMeasurement,
   PlxExciterVoltage aExciterVoltage,
   u16 aExciterFrequency,
   PlxExciterResolution aResolution
);
void plxStartResolverIn();

#define getResolverInPosition0() (*(plxIoIn.RslvInput) * M_PI / 32768)
#define getResolverInPosition1() (*(plxIoIn.RslvInput+2) * M_PI / 32768)
#define getResolverInSpeed0() (*((int16_t*)plxIoIn.RslvInput) * plxResolverSpeedScale0)
#define getResolverInSpeed1() (*((int16_t*)plxIoIn.RslvInput+2) * plxResolverSpeedScale1)
#define getResolverError0() (*(plxIoIn.RslvInput + 1) & 0xff)
#define getResolverError1() (*(plxIoIn.RslvInput + 3) & 0xff)
#define getResolverValid0() (*(plxIoIn.RslvInput + 1) >> 8)
#define getResolverValid1() (*(plxIoIn.RslvInput + 3) >> 8)

#endif

