local FileUtils = { }

FileUtils.Error = ""

FileUtils.PathSep = package.config:sub(1,1)

--
function FileUtils.FullPath(pathList)

  return table.concat(pathList, FileUtils.PathSep)

end

--
function FileUtils.CopyTemplateFile(src, dest, subs)
  local file, msg
  file, msg = io.open(src, "r")
  if not file then
    FileUtils.Error = "Cannot access file %s" % { msg }
    return false
  end
  local content = file:read("*all")
  file:close()

  if subs ~= nil then
    for before, after in pairs(subs) do 
      content = string.gsub( content, before, after)  
    end
  end

  file, msg = io.open(dest, "w")
  if not file then
    FileUtils.Error = "Cannot access file %s" % { msg }
    return false
  end
  file:write(content)
  file:close()
  return true
end

return FileUtils