--[[
  Copyright (c) 2025 by Plexim GmbH
  All rights reserved.

  A free license is granted to anyone to use this software for any legal
  non safety-critical purpose, including commercial applications, provided
  that:
  1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
  2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
--]]

local Overrides = {}

Overrides['NanostepScope'] = {
  DftCodeFunction = function ()
    local block = Target.Coder.CreateTargetBlock('NanostepScope')
    local returnVal = block:getDirectFeedthroughCode()

    if type(returnVal) == 'table' then
      return {
        Include = returnVal.Include,
        InitCode = returnVal.InitCode,
        OutputSignal = {},
        OutputCode = returnVal.OutputCode,
        Declarations = returnVal.Declarations,
        Require = returnVal.Require,
      }
    else -- error
      return returnVal
    end
  end
  
}

Overrides['ModbusServer'] = {
  DftCodeFunction = function ()
    local block = Target.Coder.CreateTargetBlock('ModbusServer')
    local returnVal = block:getDirectFeedthroughCode()

    if type(returnVal) == 'table' then
      local userData = returnVal.UserData
      if not userData then
        userData = {}
      end
      userData.bid = block:getId()
      return {
        Include = returnVal.Include,
        InitCode = returnVal.InitCode,
        OutputSignal = returnVal.OutputSignal,
        OutputCode = returnVal.OutputCode,
        Declarations = returnVal.Declarations,
        Require = returnVal.Require,
        UserData = userData,
      }
    else -- error
      return returnVal
    end
  end,

  NonDftCodeFunction = function ()
    local bid = Block.UserData.bid
    local block = Target.Coder.GetTargetBlock(bid)
    local returnVal = block:getNonDirectFeedthroughCode()

    if type(returnVal) == 'table' then
      return {
        Include = returnVal.Include,
        InitCode = returnVal.InitCode,
        UpdateCode = returnVal.UpdateCode,
        Declarations = returnVal.Declarations,
        Require = returnVal.Require,
      }
    else -- error
      return returnVal
    end
  end
}

Overrides['ModbusClient'] = {
  DftCodeFunction = function ()
    local block = Target.Coder.CreateTargetBlock('ModbusClient')
    local returnVal = block:getDirectFeedthroughCode()

    if type(returnVal) == 'table' then
      local userData = returnVal.UserData
      if not userData then
        userData = {}
      end
      userData.bid = block:getId()
      return {
        Include = returnVal.Include,
        InitCode = returnVal.InitCode,
        OutputSignal = returnVal.OutputSignal,
        OutputCode = returnVal.OutputCode,
        Declarations = returnVal.Declarations,
        Require = returnVal.Require,
        UserData = userData,
      }
    else -- error
      return returnVal
    end
  end,

  NonDftCodeFunction = function ()
    local bid = Block.UserData.bid
    local block = Target.Coder.GetTargetBlock(bid)
    local returnVal = block:getNonDirectFeedthroughCode()
    
    if type(returnVal) == 'table' then
      return {
        Include = returnVal.Include,
        InitCode = returnVal.InitCode,
        UpdateCode = returnVal.UpdateCode,
        Declarations = returnVal.Declarations,
        Require = returnVal.Require,
      }
    else -- error
      return returnVal
    end
  end
}

return Overrides

