local Module = {}

local static = {}

local Utils = require('blocks.BlockUtils')

function Module.getBlock(globals)
  local TripleAndAssertion = require('blocks.block').getBlock(globals)
  local self = TripleAndAssertion
  
  self.isConst0 = {}
  self.canUseFpga = true
  self.channel = {}
  self.polarity = {}
  self.assertionCode = StringList:new()
  self.errorMsg = ""

  local width = #Block.InputSignal[1]

  for idx = 2, 3 do
    if #Block.InputSignal[idx] ~= width then
      return nil, { message = "Gate signals must have the same width.", level = 1 }
    end
  end

  for idx = 1, #Block.InputSignal do
    self.isConst0[idx] = {}
    self.channel[idx] = {}
    self.polarity[idx] = {}
    for s = 1, width do
      local signalValue = Utils.inputSignalToNumber(idx, s, true)
      self.isConst0[idx][s] = signalValue == 0
      if not self.isConst0[idx][s] then
        if Block.InputMetaData[idx] == nil 
          or Block.InputMetaData[idx][s] == nil 
          or Block.InputMetaData[idx][s]['port'] == nil 
          or Block.InputMetaData[idx][s]['polarity'] == nil
        then
          self.canUseFpga = false          
        else
          self.channel[idx][s] = tonumber(Block.InputMetaData[idx][s]['port'])
          self.polarity[idx][s] = tonumber(Block.InputMetaData[idx][s]['polarity'])
        end
      end
    end
  end

  function TripleAndAssertion:generateDirectInput(aCh1, s)
    if not self.isConst0[aCh1][s] and self.channel[aCh1][s] then
      local preprocReg = Target.Coder.getPwmPreprocReg()
      local preproc = preprocReg:getPreprocForDirectCapture(self.channel[aCh1][s])
      if preproc == preprocReg.Result.NO_RESOURCE then
        self.errorMsg = "%sPWM channel %d is connected to too many gate inputs.\n" % { self.errorMsg, self.channel[aCh1][s] }
      end
    end
  end
  

  function TripleAndAssertion:generateTripleAndAssertion(aCh1, aCh2, aCh3, s)
    local preprocReg = Target.Coder.getPwmPreprocReg()
    local assertions = Block.Mask.assertions - 1
    if assertions == 1 and (not self.isConst0[aCh1][s]) 
      and (not self.isConst0[aCh2][s]) and (not self.isConst0[aCh3][s]) then
      local useFpgaPreproc = false
      local preproc
      if self.canUseFpga then
        useFpgaPreproc = true
        preproc = preprocReg:getPreprocForAnd3Assertion(
          self.channel[aCh1][s], self.polarity[aCh1][s],
          self.channel[aCh2][s], self.polarity[aCh2][s],
          self.channel[aCh3][s], self.polarity[aCh3][s])
        if preproc == preprocReg.Result.NO_RESOURCE then
          self.errorMsg = "%sPWM channel %d is connected to too many gate inputs.\n" % { self.errorMsg, self.channel[aCh1][s] }
        end
      end
      if useFpgaPreproc then
        self.assertionCode:append("plxCheckAssertion(%i)" % { preproc })
      end
    end
  end

  function TripleAndAssertion:getAssertionCode()
    if #self.assertionCode > 0 then
      return table.concat(self.assertionCode, "&&")
    else
      return "1"
    end
  end

  function TripleAndAssertion:getDirectFeedthroughCode()
    local OutputSignal = {}
    for s = 1, #Block.InputSignal[1] do
      for idx = 1, 3 do
        TripleAndAssertion:generateDirectInput(idx, s)
      end
      TripleAndAssertion:generateTripleAndAssertion(1, 2, 3, s)
    end
    
    if string.len(TripleAndAssertion.errorMsg) > 0 then
      return nil, { message = TripleAndAssertion.errorMsg, level = 2}
    end
    
    OutputSignal = { TripleAndAssertion:getAssertionCode() }
    return {
      OutputSignal = OutputSignal,
    }
  end

  return TripleAndAssertion

end
return Module