/*
   Copyright (c) 2021 by Plexim GmbH
   All rights reserved.

   A free license is granted to anyone to use this software for any legal
   non safety-critical purpose, including commercial applications, provided
   that:
   1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
   2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
   SOFTWARE.
 */
#ifndef ETHERCAT_H
#define ETHERCAT_H

#include <stdint.h>
#include <stdlib.h>

#define ECAT_PARAM_SHM_DATA_BASE_ADDR ((void*)0x3d020000)
#define ECAT_PARAM_SHM_DATA_SIZE (0x5000)


typedef struct {
   uint16_t mDataType;
   uint16_t mBitLength;
   uint16_t mObjAccess;
} __attribute__((packed)) ECEntryDesc;

typedef struct {
   uint16_t mDataType;
   uint16_t mObjFlags;
} __attribute__((packed)) ECObjDesc;

typedef struct {
   const ECEntryDesc* mEntryDesc;
   const char* mNames;
   const void* mData;
} ECObjectData;

typedef struct {
   uint32_t pPrev; // replacement for 32 bit pointer
   uint32_t pNext; // replacement for 32 bit pointer
   const uint16_t mIndex;
   const ECObjDesc mObjDesc;
   const uint32_t mEntryDesc; // replacement for 32 bit pointer
   uint32_t  mNames; // replacement for 32 bit pointer
   uint32_t  mData; // replacement for 32 bit pointer
   uint32_t  pRead; // replacement for 32 bit pointer
   uint32_t  pWrite; // replacement for 32 bit pointer
   uint16_t mOffset; // replacement for 32 bit pointer
} ECObject;


typedef struct {
   const uint32_t mEntrySize;
   const uint32_t mNamesSize;
   const uint32_t mDataSize;
} __attribute__((packed)) ECObjectSizes;

typedef struct {
   uint32_t mInitialized;
   uint32_t mHwDetected;
   uint32_t mCurrentBufferIdx;
   uint32_t mUpdateFlags[2];
} ECBufferDesc;

extern volatile ECBufferDesc* plxEcInputBufferDesc;
extern volatile ECBufferDesc* plxEcOutputBufferDesc;

void plxSendSetup(const ECObject* aObjectList, const ECObjectData* aDataList, const ECObjectSizes* aSizesList, int aNumObjects,
                  const unsigned char* aEepromData, int aEepromSize);

#define plxEcatInputBuffer(idx) (idx ? ECAT_PARAM_SHM_DATA_BASE_ADDR+0x1000 : ECAT_PARAM_SHM_DATA_BASE_ADDR+0x2000)
#define plxEcatOutputBuffer(idx) (idx ? ECAT_PARAM_SHM_DATA_BASE_ADDR+0x3000 : ECAT_PARAM_SHM_DATA_BASE_ADDR+0x4000)
#endif // ETHERCAT_H
