local Module = {}

local static = {}

local function stringToNumber(aSignal)
  local n = tonumber(aSignal) 
  if n ~= nil then
    return n
  end
  -- test if aSignal is float literal like 0.1f
  if string.sub(aSignal, -1, -1) == "f" then
    return tonumber(string.sub(aSignal, 1, -2))
  end
  return nil
end

function Module.getBlock(globals)
  local CounterAccumulator = require('blocks.block').getBlock(globals)

  function CounterAccumulator:getDirectFeedthroughCode()
    local initCode = StringList:new()
    local outputCode = StringList:new()

    local outputSignal = Block:OutputSignal()
    local TsThermal = Block.Mask.TsThermal;
    local blockSampleTime = Block.SampleTime[1]
    local nThermal = 1
    if (blockSampleTime == 0.0) then
      blockSampleTime = Block.Task.SampleTime[1]
    end
    if TsThermal > 0 then
      nThermal = math.floor(TsThermal / blockSampleTime + 0.5)
    end

    local buffer_on = {}
    local buffer_off = {}
    local buffer_duty = {}
    local buffer_nduty = {}
    local buffer_i_on = {}
    local buffer_i_off = {}
    local buffer_i_duty = {}
    local buffer_i_nduty = {}
    local sampleCount = Block:AddWorkVariable("uint32_t")
    local width = Block.NumOutputSignals[1]
    local i_in = Block.InputSignal[2][1]
    local metaData = Block.InputMetaData[1]
    
    initCode:append("%s = %i;\n" % { sampleCount, nThermal-1 })
    
    for idx = 1, width do
      if metaData == nil or metaData[idx] == nil or metaData[idx]['port'] == nil then
        if stringToNumber(Block.InputSignal[1][idx]) == 0 then
          -- connected to constant zero
          for s = 1, 8 do
            initCode:append("%s = 0;" % { outputSignal[s][idx] })
          end
        else
          return nil, 
          { 
            message = "For thermal simulation, power modules must be connected directly to " ..
                      "PWMCapture blocks.",
            level = 3
          }
        end
      else
        -- initial opening brace
        outputCode:append("{")
        outputCode:append("%s* result_on = &%s;\n" % { Block.OutputType[1][idx], outputSignal[1][idx] })
        outputCode:append("%s* result_off = &%s;\n" % { Block.OutputType[2][idx], outputSignal[2][idx] })
        outputCode:append("%s* result_duty = &%s;\n" % { Block.OutputType[3][idx], outputSignal[3][idx] })
        outputCode:append("%s* result_nduty = &%s;\n" % {Block.OutputType[4][idx], outputSignal[4][idx] })
        outputCode:append("%s* result_i_on = &%s;\n" % {Block.OutputType[5][idx], outputSignal[5][idx] })
        outputCode:append("%s* result_i_off = &%s;\n" % {Block.OutputType[6][idx], outputSignal[6][idx] })
        outputCode:append("%s* result_i_duty = &%s;\n" % {Block.OutputType[7][idx], outputSignal[7][idx] })
        outputCode:append("%s* result_i_nduty = &%s;\n" % {Block.OutputType[8][idx], outputSignal[8][idx] })

        local channel = tonumber(metaData[idx]['port'])
      
        local dutyUpdate = "((i_in > 0)? (%s) : 0)" % { Block.InputSignal[1][idx] }
        local ndutyUpdate = "((i_in > 0)? (1-(%s)) : 0)" % { Block.InputSignal[1][idx] }

        if nThermal > 1 then
          buffer_on[idx] = Block:AddWorkVariable(Block.OutputType[1][idx])
          buffer_off[idx] = Block:AddWorkVariable(Block.OutputType[2][idx])
          buffer_duty[idx] = Block:AddWorkVariable("float")
          buffer_nduty[idx] = Block:AddWorkVariable("float")
          buffer_i_on[idx] = Block:AddWorkVariable("float")
          buffer_i_off[idx] = Block:AddWorkVariable("float")
          buffer_i_duty[idx] = Block:AddWorkVariable("float")
          buffer_i_nduty[idx] = Block:AddWorkVariable("float")

          initCode:append("%s = 0;\n" % { buffer_on[idx] })
          initCode:append("%s = 0;\n" % { buffer_off[idx] })
          initCode:append("%s = 0;\n" % { buffer_duty[idx] })
          initCode:append("%s = 0;\n" % { buffer_nduty[idx] })
          initCode:append("%s = 0;\n" % { buffer_i_on[idx] })
          initCode:append("%s = 0;\n" % { buffer_i_off[idx] })
          initCode:append("%s = 0;\n" % { buffer_i_duty[idx] })
          initCode:append("%s = 0;\n" % { buffer_i_nduty[idx] })

          -- calculate output  
          outputCode:append([=[
            float i_in = %(i_in)s;
            float duty = %(dutyUpdate)s;
            float nduty = %(ndutyUpdate)s;
            uint32_t numRising = plxGetRisingEdges(%(channel)i);
            uint32_t numFalling = plxGetFallingEdges(%(channel)i);
            
            /* update buffers */
            %(buffer_on)s += numRising;
            %(buffer_off)s += numFalling;
            %(buffer_duty)s += duty;
            %(buffer_nduty)s += nduty;
            if (i_in > 0)
            {
               %(buffer_i_on)s += i_in * numRising;
               %(buffer_i_off)s += i_in * numFalling;
               %(buffer_i_duty)s += i_in * duty;
               %(buffer_i_nduty)s += i_in * nduty;
            }
            
            if (%(sampleCount)s == 0)
            {
                /* update outputs */
                *result_on = %(buffer_on)s;
                *result_off = %(buffer_off)s;
                *result_duty = %(buffer_duty)s/%(nThermal)i;
                *result_nduty = %(buffer_nduty)s/%(nThermal)i;
                *result_i_on = %(buffer_on)s > 0 ? %(buffer_i_on)s / %(buffer_on)s : 0;
                *result_i_off = %(buffer_off)s > 0 ? %(buffer_i_off)s / %(buffer_off)s : 0;
                *result_i_duty = %(buffer_duty)s > 0 ? %(buffer_i_duty)s / %(buffer_duty)s : 0;
                *result_i_nduty = %(buffer_nduty)s > 0 ? %(buffer_i_nduty)s / %(buffer_nduty)s : 0;
                
                %(buffer_on)s = 0;
                %(buffer_off)s = 0;
                %(buffer_duty)s = 0;
                %(buffer_nduty)s = 0;
                %(buffer_i_on)s = 0;
                %(buffer_i_off)s = 0;
                %(buffer_i_duty)s = 0;
                %(buffer_i_nduty)s = 0;
            }
          ]=]
          %
          { 
            nThermal = nThermal,
            channel = channel,
            dutyUpdate = dutyUpdate,
            ndutyUpdate = ndutyUpdate,
            sampleCount = sampleCount,
            i_in = i_in,
            buffer_on = buffer_on[idx],
            buffer_off = buffer_off[idx],
            buffer_duty = buffer_duty[idx],
            buffer_nduty = buffer_nduty[idx],
            buffer_i_on = buffer_i_on[idx],
            buffer_i_off = buffer_i_off[idx],
            buffer_i_duty = buffer_i_duty[idx],
            buffer_i_nduty = buffer_i_nduty[idx],
          })
        else
          outputCode:append([=[
            float i_in = %(i_in)s;
            *result_on = plxGetRisingEdges(%(channel)i);
            *result_off = plxGetFallingEdges(%(channel)i);
            *result_duty = %(dutyUpdate)s;
            *result_nduty = %(ndutyUpdate)s;
            *result_i_on = i_in;
            *result_i_off = i_in;
            *result_i_duty = i_in;
            *result_i_nduty = i_in;
          ]=]
          %
          {
            channel = channel,
            dutyUpdate = dutyUpdate,
            ndutyUpdate = ndutyUpdate,
            i_in = i_in
          })
        end
        -- final closing brace
        outputCode:append("}")
      end
    end -- for
    if nThermal > 1 then
      outputCode:append([=[
        if (%(sampleCount)s == 0)
        {
           %(sampleCount)s = %(n_minus_1)i;
        }
        else
        {
           %(sampleCount)s--;
        }
      ]=]
      %
      {
        sampleCount = sampleCount,
        n_minus_1 = nThermal-1,
      })
    end

    return {
      InitCode = initCode,
      OutputCode = outputCode,
    }
  end
  
  return CounterAccumulator
end

return Module
