local Module = {}

function Module.getBlock(globals)
  local EncoderCounter = require('blocks.block').getBlock(globals)

  function EncoderCounter:getDirectFeedthroughCode()
    local Include = StringList:new()
    local InitCode = StringList:new()
    local UpdateCode = StringList:new()
    local OutputSignal = {}
    local Require = ResourceList:new()

    local instance = EncoderCounter:getInstanceNumber()
    local max_counter_value = Block.Mask.max_counter_value
    local counter_mode = Block.Mask.counter_mode
    local direction = Block.Mask.direction
    local counter_reset_type = Block.Mask.counter_reset_type
    local reset_condition = Block.Mask.reset_condition
    local input_type = Block.Mask.input_type
    local index_enable = Block.Mask.has_index
    local input_a = Block.Mask.input_a
    local input_b = Block.Mask.input_b
    local input_i = Block.Mask.input_i
    local input_na = Block.Mask.input_na
    local input_nb = Block.Mask.input_nb
    local input_ni = Block.Mask.input_ni

    Include:append("plexim/EncoderCounter.h")

    if instance > 1 then
      return "A maximum of two Quadrature Encoder Counter blocks can be used in one model."
    end

    Require:add("Encoder counter", instance)
    Require:add("Digital input", input_a)
    Require:add("Digital input", input_b)
    if index_enable == 2 then
      Require:add("Digital input", input_i)
    end
    if input_type == 2 then -- differential
      Require:add("Digital input", input_na)
      Require:add("Digital input", input_nb)
      if index_enable == 2 then
        Require:add("Digital input", input_ni)
      end
    end


    InitCode:append("plxSetupEncoderCounter(%i, %i, %i, %i, %i, %i, %i, %i, %i, %i, %i, %i, %i, %i, %.17ef);\n" 
      % { instance, max_counter_value, counter_mode-1, direction-1, counter_reset_type-1, 
          reset_condition-1, input_type-1, index_enable-1, input_a, input_b, input_i, 
          input_na, input_nb, input_ni, Block.SampleTime[1], 0 })
    OutputSignal[1] = {}
    OutputSignal[1][1] = "plxGetEncoderCounter(%i)" % { instance }
    OutputSignal[2] = {}
    OutputSignal[2][1] = "plxGetEncoderSpeed(%i)" % { instance }
    OutputSignal[3] = {}
    OutputSignal[3][1] = "plxGetEncoderDirection(%i)" % { instance }
    OutputSignal[3][2] = "plxGetEncoderIndex(%i)" % { instance }
    UpdateCode:append("plxLastEncoderCounterValues[%i] = plxGetEncoderCounter(%i);\n" % { instance, instance })

    return {
      Include = Include,
      Require = Require,
      InitCode = InitCode,
      UpdateCode = UpdateCode,
      OutputSignal = OutputSignal,
    }
  end
  
  return EncoderCounter
end  
return Module
