local Module = {}

function Module.getBlock(globals)
  local SpiPeripheral = require('blocks.block').getBlock(globals)

  function SpiPeripheral:getDirectFeedthroughCode()
    local InitCode = StringList:new()
    local OutputSignal = StringList:new()
    local OutputCode = StringList:new()
    local Require = ResourceList:new()

    local moduleId = SpiPeripheral:getInstanceNumber()

    if moduleId > 1 then
      return "A maximum of two SPI blocks (controller or peripheral) can be used in one model."
    end

    -- register the hardware resources
    Require:add("SPI", moduleId + 1)

    local numChannels = Block.Mask.numChannels
    local numWords = Block.Mask.numWords

    -- Setup Config struct
    InitCode:append("{\n")
    InitCode:append("const SPI_CONF conf = {\n")
    InitCode:append(".PERIPHERAL = 1,\n")
    InitCode:append(".CLK_SPC1 = 0,\n")
    InitCode:append(".CLK_SPC2 = 0,\n")
    InitCode:append(".SPIMODE = %i,\n" % { Block.Mask.spiMode-1 })
    InitCode:append(".DataBits = %i,\n" % { Block.Mask.wordSize })
    InitCode:append(".bitOrder = %i,\n" % { Block.Mask.bitOrder-1 })
    InitCode:append(".HS_MODE = 0,\n")
    InitCode:append(".STRMBR = %i,\n" % { numChannels-1 })
    InitCode:append(".CS_POLARITY = 0,\n")
    InitCode:append(".TRGDELAY = 0\n")
    InitCode:append("};\n")

    local numSPIQWords = math.floor((numChannels*numWords+3)/4)
    if Target.Name ~= "PLECS RT Box 1" then
       numSPIQWords = 2*numSPIQWords
    end
    InitCode:append("static uint16_t outputBuffer[%i];\n" % { 2*4*numSPIQWords })

    -- Setup SPI moduleID for Controller Mode with numWords sent words per channel
    InitCode:append("setupSPI(%i, &conf, %.17e, %i, 0, 0, outputBuffer, %i*sizeof(uint16_t), 0);\n" % 
      { moduleId, Block.Mask.fClock, numWords, 4*numSPIQWords })
    InitCode:append("}\n")

    -- Program Inputs in Init Code
    for i = 1, 4 do
       local channel = Block.Mask.inputVec[i]
       if (channel >= 0) then
          -- Input configured to be used for SPI   		
          Require:add("Digital input", channel);
          InitCode:append("setupSPIInput(%i, %i, %i);\n" % { moduleId, i-1, channel })
       end
    end

    local useClockOutput = Block.Mask.useClockOutput
    -- Program CLK output channel
    if useClockOutput == 2 then
       local channel = Block.Mask.clkOutChannel
   
        -- Output configured to be used for SPI   		
        Require:add("Digital output", channel)
       InitCode:append("setupSPIOutput(%i, 0, %i);\n" % { moduleId, channel })
    end

    -- Program CS input channel
    local csChannel = Block.Mask.csInChannel
    Require:add("Digital input", csChannel)
    InitCode:append("setupSPIInput(%i, 5, %i);\n" % { moduleId, csChannel })

    -- Program Clock input channel
    local clkInChannel = Block.Mask.clkInChannel
    Require:add("Digital input", clkInChannel)
    InitCode:append("setupSPIInput(%i, 4, %i);\n" % { moduleId, clkInChannel })

    -- Program digital output channels
    local outid = {1,3,4,5}
    for i = 1, numChannels do
       local channel = Block.Mask.outputVec[i]
   
       if channel >= 0 then
           -- Output configured to be used for SPI   		
           Require:add("Digital output", channel)
          InitCode:append("setupSPIOutput(%i,%i, %i);\n" % { moduleId, outid[i], channel })
       end
    end

    for i = 1, 4 do
       OutputSignal[i] = {}
       for j = 1, Block.NumOutputSignals[i] do
          if i <= numChannels and j <= numWords then 
             OutputSignal[i][j] = "getSPIIn%i(%i)" % { moduleId, (i-1)+(j-1)*numChannels }
          else
             OutputSignal[i][j] = "0"
          end
       end
    end

    OutputSignal[5] = {}
    OutputSignal[5][1] = "getSPIInputState%i()" % { moduleId }

    OutputCode:append("{\n")
    OutputCode:append("int currReadBufferIdx = plxSPICurrentReadBuffer[%i];\n" % { moduleId } )
    OutputCode:append("int newReadBufferIdx = !currReadBufferIdx;\n" % { moduleId } )
    OutputCode:append("plxSPIUpdateFlags[%i][currReadBufferIdx] = 0;\n" % { moduleId } )
    OutputCode:append("if (plxSPIUpdateFlags[%i][newReadBufferIdx]) {\n" % { moduleId } )
    OutputCode:append("   plxSPIRxBufferPtr%i=plxSPIOutputBuffer[%i]+newReadBufferIdx*plxSPIBufLength[%i];\n" % { moduleId, moduleId, moduleId } )
    OutputCode:append("   plxSPICurrentReadBuffer[%i]=newReadBufferIdx;\n" % { moduleId } )
    OutputCode:append("}\n")
    OutputCode:append("}\n")


    return {
      Include = "plexim/SPI.h",
      Require = Require,
      InitCode = InitCode,
      OutputSignal = OutputSignal,
      OutputCode = OutputCode,
      UserData = { bid = SpiPeripheral:getId() }
    }
  end
  
  function SpiPeripheral:getNonDirectFeedthroughCode()
    local UpdateCode = StringList:new()
    local numChannels = Block.Mask.numChannels
    local numWords = Block.Mask.numWords
    local moduleId = SpiPeripheral:getInstanceNumber()

    -- SPI Outgoing Data  	 
    local id = 0;
    for i = 1, numWords do
        for j = 1, numChannels do	
            -- SPI Outgoing Data   		
        UpdateCode:append("setSPIOut%i(%i, %s);\n" % { moduleId, id, Block.InputSignal[j][i] })
          id = id + 1
        end
    end
    UpdateCode:append("plxEnableSpiModule(%i);\n" % { moduleId })

    return {
        UpdateCode = UpdateCode
    }
  end  
  return SpiPeripheral
end  
return Module
