/*
   Copyright (c) 2020 by Plexim GmbH
   All rights reserved.

   A free license is granted to anyone to use this software for any legal
   non safety-critical purpose, including commercial applications, provided
   that:
   1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
   2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
   SOFTWARE.
 */

#ifndef SFP_H_
#define SFP_H_

#include "plexim/hw_wrapper.h"

#ifdef __cplusplus
extern "C"
{
#endif

extern float* plxSfpOutputPtr[];

/** @brief Send value to SFP buffer.
 * 
 * @param p index of SFP port
 * @param n index of SFP output
 * @param x value to set
 */ 
#define plxSetSFPOut(p, n, x) \
{ \
   *(plxSfpOutputPtr[p] + (2*(n) - ((n) & 1))) = x; \
}

extern int plxSfpInitialized[];
extern float* plxSfpInputPtr[];
extern const float* plxSfpInitData[];

/**
 * @brief Returns conversion result of SFP input.
 * 
 * @param p index of SFP port
 * @param n index of SFP input
 */   
#define plxGetSFPIn(p, n) \
   ( plxSfpInitialized[p] ? (*(plxSfpInputPtr[p] + (2*(n) - ((n) & 1)))) : (*(plxSfpInitData[p] + (n))) )

void plxSetupSFPIn(u32 aPort, u32 aNumInputs, const float* aInitData);
void plxSetupSFPOut(u32 aPort, u32 aNumOutputs);

void plxSetupSFPSyncMaster(u32 aUseSFPA, u32 aUseSFPB, u32 aUseSFPC, u32 aUseSFPD,
                           u32 aUseSFPE, u32 aUseSFPF, u32 aUseSFPG, u32 aUseSFPH);
void plxSetupSFPSyncSlave(u32 aMasterChannel, u32 aSyncTime, u32 aSyncStartup);
PLX_BOOL plxCheckSFPInitialization(void);

#ifdef __cplusplus
}
#endif

#endif
