/*
   Copyright (c) 2023 by Plexim GmbH
   All rights reserved.

   A free license is granted to anyone to use this software for any legal
   non safety-critical purpose, including commercial applications, provided
   that:
   1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
   2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
   SOFTWARE.
 */

#ifndef PLX_QEP_IMPL_H_
#define PLX_QEP_IMPL_H_

#include "stm32g4xx_ll_tim.h"
#include "stm32g4xx_ll_gpio.h"
#include "plx_qep_impl_common.h"


__STATIC_INLINE bool PLX_QEP_getAndClearIndexFlag(PLX_QEP_Handle_t aHandle)
{
   PLX_QEP_Obj_t *obj = (PLX_QEP_Obj_t *)aHandle;
   uint32_t flag = LL_TIM_IsActiveFlag_IDX(obj->tim);
   LL_TIM_ClearFlag_IDX(obj->tim);
   return flag;
}

#endif /* PLX_QEP_IMPL_H_ */
