--[[
  Copyright (c) 2021 by Plexim GmbH
  All rights reserved.

  A free license is granted to anyone to use this software for any legal
  non safety-critical purpose, including commercial applications, provided
  that:
  1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
  2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
--]]

local Module = {}
local U = require('common.utils')

local static = {}

function Module.getBlock(globals, cpu)
  local Atan2 = require('common.block').getBlock(globals, cpu)
  if static[cpu] == nil then
    static[cpu] = {
      numInstances = 0,
      finalized = false,
      inputPotentials = {},
    }
  end
  Atan2['instance'] = static[cpu].numInstances
  static[cpu].numInstances = static[cpu].numInstances + 1

  function Atan2:p_getDirectFeedthroughCode(idx)
    local cordicObj = self:makeBlock('cordic', self.cpu)
    self.cordicInstance = cordicObj:createImplicit()
    if idx == nil then
      idx = 1
    end

    local OutputCode = U.CodeLines:new()

    local existingInstance
    for i, potential in pairs(static[self.cpu].inputPotentials) do
      if potential.x == Block.InputSignal[1][idx] and potential.y == Block.InputSignal[2][idx] then
        existingInstance = i
      end
    end
    if existingInstance == nil then
      static[self.cpu].inputPotentials[self.cordicInstance] = {
        x = Block.InputSignal[1][idx],
        y = Block.InputSignal[2][idx],
      }
      OutputCode:append('PLXHAL_ATAN2_update(%d, %s, %s);' %
        {self.cordicInstance, Block.InputSignal[1][idx], Block.InputSignal[2][idx]})
      existingInstance = self.cordicInstance
    end

    return {
      OutputSignal = {
        [1] = {'PLXHAL_ATAN2_getAtan2(%d)' % {existingInstance}},
      },
      OutputCode = OutputCode,
      UserData = {bid = Atan2:getId()}
    }
  end

  function Atan2:finalize(f)
    if static[self.cpu].finalized then
      return
    end

    f.Declarations:append([[
      extern PLX_TRIG_Handle_t TrigHandles[];
      void PLXHAL_ATAN2_update(uint16_t aHandle, float aX, float aY){
        PLX_TRIG_updateAtan2(TrigHandles[aHandle], aX, aY);
      }
      
      float PLXHAL_ATAN2_getAtan2(uint16_t aHandle){
        return PLX_TRIG_getAtan2(TrigHandles[aHandle]);
      }
    ]])

    static[self.cpu].finalized = true
  end

  return Atan2
end

return Module
