--[[
  Copyright (c) 2021 by Plexim GmbH
  All rights reserved.

  A free license is granted to anyone to use this software for any legal
  non safety-critical purpose, including commercial applications, provided
  that:
  1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
  2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
--]]

local U = require('common.utils')

local Module = {}

function Module.getBlock(globals, cpu)
  local Pil = require('common.pil_common').getBlock(globals, cpu)


  function Pil:externalModeSerialAsInt()
    return 2
  end

  function Pil:getTargetSpecificCallbackCode(c)
    -- see if the model contains epwm blocks on the same CPU

    -- see if the model contains pwm blocks
    local pwm_obj = self:getBlockInstance('pwm')

    -- see if the model contains hrtim blocks
    local hrtim_obj = self.getBlockInstance('hrtim')

    -- see if the model contains a powerstage block
    local powerstage_obj = self:getBlockInstance('powerstage')

    local enableActuationCode = ''
    local disableActuationCode = ''
    if powerstage_obj then
      c.Include:append('plx_power.h')
      enableActuationCode = 'PLX_PWR_setPilMode(false);'
      disableActuationCode = 'PLX_PWR_setPilMode(true);'
    else
      for f, _ in pairs(self.forceActuationOffFlags) do
        c.Declarations:append('extern bool %s;' % {f})
        if enableActuationCode == '' then
          enableActuationCode = enableActuationCode..'%s = false;' % {f}
          disableActuationCode = disableActuationCode..'%s = true;' % {f}
        else
          enableActuationCode = enableActuationCode..'\n%s = false;' % {f}
          disableActuationCode = disableActuationCode..'\n%s = true;' % {f}
        end
      end
    end

    c.Include:append('plx_timer.h')
    local stopTimersCode = [[
            PLX_TIM_disableAllClocks();
      #ifdef PLX_HRTIM_AVAILABLE
            PLX_HRTIM_disableClocks();
      #endif
    ]]

    local startTimersCode = [[
            PLX_TIM_enableAllClocks();
      #ifdef PLX_HRTIM_AVAILABLE
            PLX_HRTIM_enableClocks();
      #endif
    ]]

    return {
      enableActuationCode = enableActuationCode,
      disableActuationCode = disableActuationCode,
      stopTimersCode = stopTimersCode,
      startTimersCode = startTimersCode,
    }
  end

  return Pil
end

return Module
