--[[
  Copyright (c) 2021 by Plexim GmbH
  All rights reserved.

  A free license is granted to anyone to use this software for any legal
  non safety-critical purpose, including commercial applications, provided
  that:
  1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
  2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
--]]

local Module = {}
local U = require('common.utils')

local static = {}

function Module.getBlock(globals, cpu)
  local SinCos = require('common.block').getBlock(globals, cpu)
  if static[cpu] == nil then
    static[cpu] = {
      numInstances = 0,
      finalized = false,
      inputPotentials = {},
    }
  end
  SinCos['instance'] = static[cpu].numInstances
  static[cpu].numInstances = static[cpu].numInstances + 1

  function SinCos:p_getDirectFeedthroughCode(idx)
    local cordicObj = self:makeBlock('cordic', self.cpu)
    self.cordicInstance = cordicObj:createImplicit()

    if not idx then
      error([[
        SinCos block getDirectFeedthroughCode(idx) requires an argument,
        the index of the input to the block.]])
    end

    local OutputCode = U.CodeLines:new()

    local existingInstance
    for i, potential in pairs(static[self.cpu].inputPotentials) do
      if potential == Block.InputSignal[1][idx] then
        existingInstance = i
      end
    end
    if existingInstance == nil then
      static[self.cpu].inputPotentials[self.cordicInstance] = Block.InputSignal
         [1][idx]
      OutputCode:append('PLXHAL_SINCOS_update(%d, %s);' %
        {self.cordicInstance, Block.InputSignal[1][idx]})
      existingInstance = self.cordicInstance
    end

    return {
      OutputSignal = {
        [1] = {'PLXHAL_SINCOS_getSin(%d)' % {existingInstance}},
        [2] = {'PLXHAL_SINCOS_getCos(%d)' % {existingInstance}},
      },
      OutputCode = OutputCode,
      UserData = {bid = SinCos:getId()}
    }
  end

  function SinCos:finalize(f)
    if static[self.cpu].finalized then
      return
    end

    f.Declarations:append([[
      extern PLX_TRIG_Handle_t TrigHandles[];
      void PLXHAL_SINCOS_update(uint16_t aHandle, float aAngle){
        PLX_TRIG_updateSinCos(TrigHandles[aHandle], aAngle);
      }

      float PLXHAL_SINCOS_getSin(uint16_t aHandle){
        return PLX_TRIG_getSin(TrigHandles[aHandle]);
      }

      float PLXHAL_SINCOS_getCos(uint16_t aHandle){
        return PLX_TRIG_getCos(TrigHandles[aHandle]);
      }
  ]])

    static[self.cpu].finalized = true
  end

  return SinCos
end

return Module
