local MCU = { }

MCU.adcs = {
  ADC1 = {
    IN1 = {port = 'A', pin = 0},
    IN2 = {port = 'A', pin = 1},
    IN3 = {port = 'A', pin = 2},
    IN4 = {port = 'A', pin = 3},
    IN6 = {port = 'C', pin = 0},
    IN7 = {port = 'C', pin = 1},
    IN8 = {port = 'C', pin = 2},
    IN9 = {port = 'C', pin = 3},
    IN10 = {port = 'F', pin = 2},
    IN14 = {port = 'B', pin = 11},
  },
  ADC2 = {
    IN1 = {port = 'A', pin = 4},
    IN2 = {port = 'A', pin = 5},
    IN3 = {port = 'A', pin = 6},
    IN4 = {port = 'A', pin = 7},
    IN5 = {port = 'C', pin = 4},
    IN6 = {port = 'C', pin = 0},
    IN7 = {port = 'C', pin = 1},
    IN8 = {port = 'C', pin = 2},
    IN9 = {port = 'C', pin = 3},
    IN10 = {port = 'F', pin = 2},
    IN11 = {port = 'C', pin = 5},
    IN12 = {port = 'B', pin = 2},
    IN14 = {port = 'B', pin = 11},
  },
  ADC3 = {
    IN1 = {port = 'B', pin = 1},
    IN2 = {port = 'E', pin = 9},
    IN3 = {port = 'E', pin = 13},
    IN5 = {port = 'B', pin = 13},
    IN6 = {port = 'E', pin = 8},
    IN7 = {port = 'D', pin = 10},
    IN8 = {port = 'D', pin = 11},
    IN9 = {port = 'D', pin = 12},
    IN10 = {port = 'D', pin = 13},
    IN11 = {port = 'D', pin = 14},
    IN12 = {port = 'B', pin = 0},
    IN13 = {port = 'E', pin = 7},
    IN14 = {port = 'E', pin = 10},
    IN15 = {port = 'E', pin = 11},
    IN16 = {port = 'E', pin = 12},
  },
  ADC4 = {
    IN1 = {port = 'E', pin = 14},
    IN2 = {port = 'E', pin = 15},
    IN3 = {port = 'B', pin = 12},
    IN4 = {port = 'B', pin = 14},
    IN5 = {port = 'B', pin = 15},
    IN6 = {port = 'E', pin = 8},
    IN7 = {port = 'D', pin = 10},
    IN8 = {port = 'D', pin = 11},
    IN9 = {port = 'D', pin = 12},
    IN10 = {port = 'D', pin = 13},
    IN11 = {port = 'D', pin = 14},
    IN12 = {port = 'D', pin = 8},
    IN13 = {port = 'D', pin = 9},
  },
}

MCU.opamps = {
  OPAMP1 = {
        gpio_in_n = {A3 = 'IO1', C5 = 'IO0'},
        gpio_in_p = {A1 = 'IO0', A3 = 'IO2', A5 = 'IO3', A7 = 'IO1'},
        gpio_out = {port = 'A', pin = 2},
  },
  OPAMP3 = {
        gpio_in_n = {B2 = 'IO1', B10 = 'IO0'},
        gpio_in_p = {A1 = 'IO2', A5 = 'IO3', B0 = 'IO0', B13 = 'IO1'},
        gpio_out = {port = 'B', pin = 1},
  },
  OPAMP4 = {
        gpio_in_n = {B10 = 'IO0', D8 = 'IO1'},
        gpio_in_p = {A4 = 'IO2', B11 = 'IO3', B13 = 'IO0', D11 = 'IO1'},
        gpio_out = {port = 'B', pin = 12},
  },
  OPAMP2 = {
        gpio_in_n = {A5 = 'IO1', C5 = 'IO0'},
        gpio_in_p = {A7 = 'IO0', B0 = 'IO2', B14 = 'IO3', D14 = 'IO1'},
        gpio_out = {port = 'A', pin = 6},
  },
}

MCU.comps = {
  COMP7 = {
        gpio_in_n = {C0 = 'IO1'},
        gpio_in_p = {C1 = 'IO1'},
        gpio_out = {port = 'C', pin = 2},
  },
  COMP1 = {
        gpio_in_n = {A0 = 'IO1'},
        gpio_in_p = {A1 = 'IO1'},
        gpio_out = {port = 'A', pin = 0},
  },
  COMP2 = {
        gpio_in_n = {A2 = 'IO1'},
        gpio_in_p = {A7 = 'IO1'},
        gpio_out = {port = 'A', pin = 2},
  },
  COMP3 = {
        gpio_in_n = {B12 = 'IO2', D15 = 'IO1'},
        gpio_in_p = {B14 = 'IO1'},
        gpio_out = {port = 'C', pin = 8},
  },
  COMP4 = {
        gpio_in_n = {B2 = 'IO2', E8 = 'IO1'},
        gpio_in_p = {B0 = 'IO1'},
        gpio_out = {port = 'B', pin = 1},
  },
  COMP5 = {
        gpio_in_n = {B10 = 'IO2', D13 = 'IO1'},
        gpio_in_p = {B13 = 'IO1'},
        gpio_out = {port = 'C', pin = 7},
  },
  COMP6 = {
        gpio_in_n = {B15 = 'IO2', D10 = 'IO1'},
        gpio_in_p = {B11 = 'IO1'},
        gpio_out = {port = 'C', pin = 6},
  },
}

MCU.dacs = {
  DAC1 = {
    gpio = {
      [1] = {port = 'A', pin = 4},
      [2] = {port = 'A', pin = 5},
    },
    num_channels = 2,
  },
}

MCU.gpio_af = {
A0 = { TIM2_CH1 = 1,  TIM2_ETR = 1,  TSC_G1_IO1 = 3,  USART2_CTS = 7,  COMP1_OUT = 8,  TIM8_BKIN = 9,  TIM8_ETR = 10},
A1 = { RTC_REFIN = 0,  TIM2_CH2 = 1,  TSC_G1_IO2 = 3,  USART2_DE = 7,  USART2_RTS = 7,  TIM15_CH1N = 9},
A2 = { TIM2_CH3 = 1,  TSC_G1_IO3 = 3,  USART2_TX = 7,  COMP2_OUT = 8,  TIM15_CH1 = 9},
A3 = { TIM2_CH4 = 1,  TSC_G1_IO4 = 3,  USART2_RX = 7,  TIM15_CH2 = 9},
A4 = { TIM3_CH2 = 2,  TSC_G2_IO1 = 3,  SPI1_NSS = 5,  I2S3_WS = 6,  SPI3_NSS = 6,  USART2_CK = 7},
A5 = { TIM2_CH1 = 1,  TIM2_ETR = 1,  TSC_G2_IO2 = 3,  SPI1_SCK = 5},
A6 = { TIM16_CH1 = 1,  TIM3_CH1 = 2,  TSC_G2_IO3 = 3,  TIM8_BKIN = 4,  SPI1_MISO = 5,  TIM1_BKIN = 6,  COMP1_OUT = 8},
A7 = { TIM17_CH1 = 1,  TIM3_CH2 = 2,  TSC_G2_IO4 = 3,  TIM8_CH1N = 4,  SPI1_MOSI = 5,  TIM1_CH1N = 6},
A8 = { RCC_MCO = 0,  I2C3_SCL = 3,  I2C2_SMBA = 4,  I2S2_MCK = 5,  TIM1_CH1 = 6,  USART1_CK = 7,  COMP3_OUT = 8,  TIM4_ETR = 10},
A9 = { I2C3_SMBA = 2,  TSC_G4_IO1 = 3,  I2C2_SCL = 4,  I2S3_MCK = 5,  TIM1_CH2 = 6,  USART1_TX = 7,  COMP5_OUT = 8,  TIM15_BKIN = 9,  TIM2_CH3 = 10},
A10 = { TIM17_BKIN = 1,  TSC_G4_IO2 = 3,  I2C2_SDA = 4,  I2S2_ext_SD = 5,  SPI2_MISO = 5,  TIM1_CH3 = 6,  USART1_RX = 7,  COMP6_OUT = 8,  TIM2_CH4 = 10,  TIM8_BKIN = 11},
A11 = { I2S2_SD = 5,  SPI2_MOSI = 5,  TIM1_CH1N = 6,  USART1_CTS = 7,  COMP1_OUT = 8,  CAN_RX = 9,  TIM4_CH1 = 10,  TIM1_CH4 = 11,  TIM1_BKIN2 = 12},
A12 = { TIM16_CH1 = 1,  I2S_CKIN = 5,  TIM1_CH2N = 6,  USART1_DE = 7,  USART1_RTS = 7,  COMP2_OUT = 8,  CAN_TX = 9,  TIM4_CH2 = 10,  TIM1_ETR = 11},
A13 = { TIM16_CH1N = 1,  TSC_G4_IO3 = 3,  IR_OUT = 5,  USART3_CTS = 7,  TIM4_CH3 = 10},
A14 = { TSC_G4_IO4 = 3,  I2C1_SDA = 4,  TIM8_CH2 = 5,  TIM1_BKIN = 6,  USART2_TX = 7},
A15 = { SYS_JTDI = 0,  TIM2_CH1 = 1,  TIM2_ETR = 1,  TIM8_CH1 = 2,  TSC_SYNC = 3,  I2C1_SCL = 4,  SPI1_NSS = 5,  I2S3_WS = 6,  SPI3_NSS = 6,  USART2_RX = 7,  TIM1_BKIN = 9},
B0 = { TIM3_CH3 = 2,  TSC_G3_IO2 = 3,  TIM8_CH2N = 4,  TIM1_CH2N = 6},
B1 = { TIM3_CH4 = 2,  TSC_G3_IO3 = 3,  TIM8_CH3N = 4,  TIM1_CH3N = 6,  COMP4_OUT = 8},
B2 = { TSC_G3_IO4 = 3},
B3 = { TIM2_CH2 = 1,  TIM4_ETR = 2,  TSC_G5_IO1 = 3,  TIM8_CH1N = 4,  SPI1_SCK = 5,  I2S3_CK = 6,  SPI3_SCK = 6,  USART2_TX = 7,  TIM3_ETR = 10},
B4 = { SYS_NJTRST = 0,  TIM16_CH1 = 1,  TIM3_CH1 = 2,  TSC_G5_IO2 = 3,  TIM8_CH2N = 4,  SPI1_MISO = 5,  I2S3_ext_SD = 6,  SPI3_MISO = 6,  USART2_RX = 7,  TIM17_BKIN = 10},
B5 = { TIM16_BKIN = 1,  TIM3_CH2 = 2,  TIM8_CH3N = 3,  I2C1_SMBA = 4,  SPI1_MOSI = 5,  I2S3_SD = 6,  SPI3_MOSI = 6,  USART2_CK = 7,  I2C3_SDA = 8,  TIM17_CH1 = 10},
B6 = { TIM16_CH1N = 1,  TIM4_CH1 = 2,  TSC_G5_IO3 = 3,  I2C1_SCL = 4,  TIM8_CH1 = 5,  TIM8_ETR = 6,  USART1_TX = 7,  TIM8_BKIN2 = 10},
B7 = { TIM17_CH1N = 1,  TIM4_CH2 = 2,  TSC_G5_IO4 = 3,  I2C1_SDA = 4,  TIM8_BKIN = 5,  USART1_RX = 7,  TIM3_CH4 = 10,  FMC_NL = 12},
B8 = { TIM16_CH1 = 1,  TIM4_CH3 = 2,  TSC_SYNC = 3,  I2C1_SCL = 4,  USART3_RX = 7,  COMP1_OUT = 8,  CAN_RX = 9,  TIM8_CH2 = 10,  TIM1_BKIN = 12},
B9 = { TIM17_CH1 = 1,  TIM4_CH4 = 2,  I2C1_SDA = 4,  IR_OUT = 6,  USART3_TX = 7,  COMP2_OUT = 8,  CAN_TX = 9,  TIM8_CH3 = 10},
B10 = { TIM2_CH3 = 1,  TSC_SYNC = 3,  USART3_TX = 7},
B11 = { TIM2_CH4 = 1,  TSC_G6_IO1 = 3,  USART3_RX = 7},
B12 = { TSC_G6_IO2 = 3,  I2C2_SMBA = 4,  I2S2_WS = 5,  SPI2_NSS = 5,  TIM1_BKIN = 6,  USART3_CK = 7},
B13 = { TSC_G6_IO3 = 3,  I2S2_CK = 5,  SPI2_SCK = 5,  TIM1_CH1N = 6,  USART3_CTS = 7},
B14 = { TIM15_CH1 = 1,  TSC_G6_IO4 = 3,  I2S2_ext_SD = 5,  SPI2_MISO = 5,  TIM1_CH2N = 6,  USART3_DE = 7,  USART3_RTS = 7},
B15 = { RTC_REFIN = 0,  TIM15_CH2 = 1,  TIM15_CH1N = 2,  TIM1_CH3N = 4,  I2S2_SD = 5,  SPI2_MOSI = 5},
C0 = { TIM1_CH1 = 2},
C1 = { TIM1_CH2 = 2},
C2 = { TIM1_CH3 = 2,  COMP7_OUT = 3},
C3 = { TIM1_CH4 = 2,  TIM1_BKIN2 = 6},
C4 = { TIM1_ETR = 2,  USART1_TX = 7},
C5 = { TIM15_BKIN = 2,  TSC_G3_IO1 = 3,  USART1_RX = 7},
C6 = { TIM3_CH1 = 2,  TIM8_CH1 = 4,  I2S2_MCK = 6,  COMP6_OUT = 7},
C7 = { TIM3_CH2 = 2,  TIM8_CH2 = 4,  I2S3_MCK = 6,  COMP5_OUT = 7},
C8 = { TIM3_CH3 = 2,  TIM8_CH3 = 4,  COMP3_OUT = 7},
C9 = { TIM3_CH4 = 2,  I2C3_SDA = 3,  TIM8_CH4 = 4,  I2S_CKIN = 5,  TIM8_BKIN2 = 6},
C10 = { TIM8_CH1N = 4,  UART4_TX = 5,  I2S3_CK = 6,  SPI3_SCK = 6,  USART3_TX = 7},
C11 = { TIM8_CH2N = 4,  UART4_RX = 5,  I2S3_ext_SD = 6,  SPI3_MISO = 6,  USART3_RX = 7},
C12 = { TIM8_CH3N = 4,  UART5_TX = 5,  I2S3_SD = 6,  SPI3_MOSI = 6,  USART3_CK = 7},
C13 = { TIM1_CH1N = 4},
C14 = { },
C15 = { },
D0 = { CAN_RX = 7,  FMC_D2 = 12},
D1 = { TIM8_CH4 = 4,  TIM8_BKIN2 = 6,  CAN_TX = 7,  FMC_D3 = 12},
D2 = { TIM3_ETR = 2,  TIM8_BKIN = 4,  UART5_RX = 5},
D3 = { TIM2_CH1 = 2,  TIM2_ETR = 2,  USART2_CTS = 7,  FMC_CLK = 12},
D4 = { TIM2_CH2 = 2,  USART2_DE = 7,  USART2_RTS = 7,  FMC_NOE = 12},
D5 = { USART2_TX = 7,  FMC_NWE = 12},
D6 = { TIM2_CH4 = 2,  USART2_RX = 7,  FMC_NWAIT = 12},
D7 = { TIM2_CH3 = 2,  USART2_CK = 7,  FMC_NCE2 = 12,  FMC_NE1 = 12},
D8 = { USART3_TX = 7,  FMC_D13 = 12},
D9 = { USART3_RX = 7,  FMC_D14 = 12},
D10 = { USART3_CK = 7,  FMC_D15 = 12},
D11 = { USART3_CTS = 7,  FMC_A16 = 12},
D12 = { TIM4_CH1 = 2,  TSC_G8_IO1 = 3,  USART3_DE = 7,  USART3_RTS = 7,  FMC_A17 = 12},
D13 = { TIM4_CH2 = 2,  TSC_G8_IO2 = 3,  FMC_A18 = 12},
D14 = { TIM4_CH3 = 2,  TSC_G8_IO3 = 3,  FMC_D0 = 12},
D15 = { TIM4_CH4 = 2,  TSC_G8_IO4 = 3,  SPI2_NSS = 6,  FMC_D1 = 12},
E0 = { TIM4_ETR = 2,  TIM16_CH1 = 4,  TIM20_ETR = 6,  USART1_TX = 7,  FMC_NBL0 = 12},
E1 = { TIM17_CH1 = 4,  TIM20_CH4 = 6,  USART1_RX = 7,  FMC_NBL1 = 12},
E2 = { SYS_TRACECK = 0,  TIM3_CH1 = 2,  TSC_G7_IO1 = 3,  SPI4_SCK = 5,  TIM20_CH1 = 6,  FMC_A23 = 12},
E3 = { SYS_TRACED0 = 0,  TIM3_CH2 = 2,  TSC_G7_IO2 = 3,  SPI4_NSS = 5,  TIM20_CH2 = 6,  FMC_A19 = 12},
E4 = { SYS_TRACED1 = 0,  TIM3_CH3 = 2,  TSC_G7_IO3 = 3,  SPI4_NSS = 5,  TIM20_CH1N = 6,  FMC_A20 = 12},
E5 = { SYS_TRACED2 = 0,  TIM3_CH4 = 2,  TSC_G7_IO4 = 3,  SPI4_MISO = 5,  TIM20_CH2N = 6,  FMC_A21 = 12},
E6 = { SYS_TRACED3 = 0,  SPI4_MOSI = 5,  TIM20_CH3N = 6,  FMC_A22 = 12},
E7 = { TIM1_ETR = 2,  FMC_D4 = 12},
E8 = { TIM1_CH1N = 2,  FMC_D5 = 12},
E9 = { TIM1_CH1 = 2,  FMC_D6 = 12},
E10 = { TIM1_CH2N = 2,  FMC_D7 = 12},
E11 = { TIM1_CH2 = 2,  SPI4_NSS = 5,  FMC_D8 = 12},
E12 = { TIM1_CH3N = 2,  SPI4_SCK = 5,  FMC_D9 = 12},
E13 = { TIM1_CH3 = 2,  SPI4_MISO = 5,  FMC_D10 = 12},
E14 = { TIM1_CH4 = 2,  SPI4_MOSI = 5,  TIM1_BKIN2 = 6,  FMC_D11 = 12},
E15 = { TIM1_BKIN = 2,  USART3_RX = 7,  FMC_D12 = 12},
F0 = { I2C2_SDA = 4,  I2S2_WS = 5,  SPI2_NSS = 5,  TIM1_CH3N = 6},
F1 = { I2C2_SCL = 4,  I2S2_CK = 5,  SPI2_SCK = 5},
F2 = { TIM20_CH3 = 2,  FMC_A2 = 12},
F6 = { TIM4_CH4 = 2,  I2C2_SCL = 4,  USART3_DE = 7,  USART3_RTS = 7,  FMC_NIORD = 12},
F9 = { TIM20_BKIN = 2,  TIM15_CH1 = 3,  SPI2_SCK = 5,  FMC_CD = 12},
F10 = { TIM20_BKIN2 = 2,  TIM15_CH2 = 3,  SPI2_SCK = 5,  FMC_INTR = 12},
}

MCU.resourceTable = {
  ADC = {
    'ADC1',
    'ADC2',
    'ADC3',
    'ADC4',
  },
  CAN = {
    'CAN1',
  },
  COMP = {
    'COMP1',
    'COMP2',
    'COMP3',
    'COMP4',
    'COMP5',
    'COMP6',
    'COMP7',
  },
  DAC = {
    'DAC1.1',
    'DAC1.2',
  },
  I2C = {
    'I2C1',
    'I2C2',
    'I2C3',
  },
  I2S = {
    'I2S2',
    'I2S3',
  },
  OPAMP = {
    'OPAMP1',
    'OPAMP2',
    'OPAMP3',
    'OPAMP4',
  },
  SPI = {
    'SPI1',
    'SPI2',
    'SPI3',
    'SPI4',
  },
  TIM = {
    'TIM1',
    'TIM2',
    'TIM3',
    'TIM4',
    'TIM6',
    'TIM7',
    'TIM8',
    'TIM15',
    'TIM16',
    'TIM17',
    'TIM20',
  },
  UART = {
    'UART4',
    'UART5',
    'UART1',
    'UART2',
    'UART3',
  },
  USART = {
    'USART1',
    'USART2',
    'USART3',
  },
}

return MCU