/*
   Copyright (c) 2021 by Plexim GmbH
   All rights reserved.

   A free license is granted to anyone to use this software for any legal
   non safety-critical purpose, including commercial applications, provided
   that:
   1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
   2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
   SOFTWARE.
 */

#ifndef PLX_CANBUS_H_
#define PLX_CANBUS_H_

#include "includes.h"
#include "pil.h"
#include "plx_canbus_impl.h" // implementation specific

extern void PLX_CANBUS_sinit();

extern PLX_CANBUS_Handle_t PLX_CANBUS_init(void *aMemory, const size_t aNumBytes);

extern PLX_CANBUS_TxHeader_t PLX_CANBUS_TxHeader_init(void *aMemory, const size_t aNumBytes);

extern void PLX_CANBUS_configure(PLX_CANBUS_Handle_t aHandle, PLX_CANBUS_Unit_t aUnit, CAN_InitTypeDef *aInitDef);

extern void PLX_CANBUS_start(PLX_CANBUS_Handle_t aHandle);

extern void PLX_CANBUS_setBusOn(PLX_CANBUS_Handle_t aHandle, bool busOn);

extern bool PLX_CANBUS_isBusOn(PLX_CANBUS_Handle_t aHandle, bool aAutoBusOnEnabled);

extern uint8_t PLX_CANBUS_getLastErrorCode(PLX_CANBUS_Handle_t aHandle);

extern bool PLX_CANBUS_isErrorActive(PLX_CANBUS_Handle_t aHandle);

extern uint8_t PLX_CANBUS_getReceiveErrorCounter(PLX_CANBUS_Handle_t aHandle);

extern uint8_t PLX_CANBUS_getTransmitErrorCounter(PLX_CANBUS_Handle_t aHandle);

extern uint8_t PLX_CANBUS_getNodeState(PLX_CANBUS_Handle_t aHandle);

extern CAN_HandleTypeDef* PLX_CANBUS_getHandle(PLX_CANBUS_Handle_t aHandle);

extern void PLX_CANBUS_configureTxHeader(PLX_CANBUS_TxHeader_t aHandle, CAN_TxHeaderTypeDef aTypeDef);

extern void PLX_CANBUS_putMessage(uint16_t aChannel, uint16_t aTxHeaderIndex, uint8_t* aData, uint8_t aWidth);

extern void PLX_CANBUS_initMsgQueue(PLX_CAN_MSG_QUEUE_Handle_t aQueue, void* aMsgBuffer, uint16_t aBufferSize, PLX_CANBUS_Protocol_t aProtocol);

#endif /* PLX_CANBUS_H_ */
