--[[
  Copyright (c) 2023 by Plexim GmbH
  All rights reserved.

  A free license is granted to anyone to use this software for any legal
  non safety-critical purpose, including commercial applications, provided
  that:
  1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
  2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
--]]

local U = require('common.utils')
local debug = require("debug")


local function p_AutoprobeTarget(...)
  local buildRoot, targetName, chip = ...
  local file = io.open(buildRoot .. '/detected_target_device.txt', 'r')

  local expectedChipId

  if file ~= nil then
    local detectedChipName = file:read()
    file:close()
    if not string.find(chip, detectedChipName) then
      if detectedChipName == '0000' then
        detectedChipName = 'unknown device'
      elseif detectedChipName == 'G474' and chip == 'G473xx' then
        return
      elseif detectedChipName == 'G431' and chip == 'G441xx' then
        return
      elseif detectedChipName == 'G474' and chip == 'G483xx' then
        return
      elseif detectedChipName == 'G474' and chip == 'G484xx' then
        return
      else
        detectedChipName = 'STM32' .. detectedChipName .. 'xx'
      end
      local errorMsg = [[
      Detected chip is not consistent with configuration in Coder options:

      • Detected chip: %(detected)s
      • Configured chip: %(configured)s

      Please change the "Chip" under Coder Options->Target->General or connect a different device to your computer. To turn off this error message, unselect the parameter "Autoprobe connected device" under Coder Options --> Target --> General.
      ]] % {
        detected = detectedChipName,
        configured = 'STM32' .. chip
      }
      U.error(errorMsg)
    end
  end
end

local ok, res = xpcall(p_AutoprobeTarget, debug.traceback, ...)

if ok then 
  U.dumpLog()
  return res
else -- there was an error, res will be an error including the stack trace
  error(U.stripTraceOrRethrowError(res), 0) -- must use error to halt execution of build here.
end
