--[[
  Copyright (c) 2021 by Plexim GmbH
  All rights reserved.

  A free license is granted to anyone to use this software for any legal
  non safety-critical purpose, including commercial applications, provided
  that:
  1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
  2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
--]]

local Module = {}
local U = require('common.utils')

local static = {}

function Module.getBlock(globals, cpu)

  local Clock = require('common.block').getBlock(globals, cpu)
  if static[cpu] == nil then
    static[cpu] = {
      numInstances = 0,
      finalized = false,
    }
  end
  Clock["instance"] = static[cpu].numInstances
  static[cpu].numInstances = static[cpu].numInstances + 1

  function Clock:p_getDirectFeedthroughCode()
    U.error("Explicit use of CLOCK via target block not supported.")
  end
  
  function Clock:finalize(f)
    if static[self.cpu].finalized then
      return
    end
    if static[self.cpu].numInstances ~= 1 then
      U.error('There should be only one (implicit) instance of the Clock block.')
    end
    
    local clkInHz
    if Target.Variables.UseIntOsc ~= 1 then
      clkInHz = globals.target.getCleanExtClkHz()
      self:logLine('Using HSE at %f Hz.' % {clkInHz})
    end
    
    local pll_settings = globals.target.getSysClkPllSettings(clkInHz)
    
    local sysClkConfigCode = [[
      __STATIC_INLINE void SystemClock_Config(void)
    {
      %s
    }
    ]]
    f.Declarations:append(sysClkConfigCode % {globals.target.getClockConfigurationCode({
      pll_settings = pll_settings,
    }
    )})
    
    local code = [[
      SystemClock_Config();
      SystemCoreClockUpdate();
      PLX_ASSERT(SystemCoreClock == %(sysClkHz)dL);
    ]] % {
      sysClkHz = globals.target.getSysClock(),
    }
    f.PreInitCode:append(code)

    static[self.cpu].finalized = true  
  end

  return Clock
end

return Module

