--[[
  Copyright (c) 2021 by Plexim GmbH
  All rights reserved.

  A free license is granted to anyone to use this software for any legal
  non safety-critical purpose, including commercial applications, provided
  that:
  1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
  2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
--]]

local Module = {}
local U = require('common.utils')

local static = {}

function Module.getBlock(globals, cpu)

  local Cordic = require('common.block').getBlock(globals, cpu)
  if static[cpu] == nil then
    static[cpu] = {
      numInstances = 0,
      finalized = false,
      inputPotentials = {},
    }
  end
  Cordic["instance"] = static[cpu].numInstances
  static[cpu].numInstances = static[cpu].numInstances + 1

  function Cordic:createImplicit()
    return self.instance
  end

  function Cordic:p_getDirectFeedthroughCode(idx)
    U.error("Explicit use of CORDIC via target block not supported.")
  end

  function Cordic:p_getNonDirectFeedthroughCode()
    U.error("Explicit use of CORDIC via target block not supported.")
  end
    
  function Cordic:finalize(f)
    if static[self.cpu].finalized then
      return
    end
    
    f.Include:append('plx_trig.h')
    f.Declarations:append('PLX_TRIG_Handle_t TrigHandles[%i];' % {static[self.cpu].numInstances})
    f.Declarations:append('PLX_TRIG_Obj_t TrigObj[%i];' % {static[self.cpu].numInstances})
    
    local code = [[
      PLX_TRIG_sinit();
      for (int i = 0; i < %d; i++) {
        TrigHandles[i] = PLX_TRIG_init(&TrigObj[i], sizeof(TrigObj[i]));
      }
    ]]
    f.PreInitCode:append(code % {static[self.cpu].numInstances})    
      
    static[self.cpu].finalized = true   
  end

  return Cordic
end

return Module
