--[[
  Copyright (c) 2021 by Plexim GmbH
  All rights reserved.

  A free license is granted to anyone to use this software for any legal
  non safety-critical purpose, including commercial applications, provided
  that:
  1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
  2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
--]]

local Module = {}
local U = require('common.utils')

local static = {}

local inputType = {
  "UP",
  "DOWN",
  "NO",
}

function Module.getBlock(globals, cpu)

  local Din = require('common.block').getBlock(globals,cpu)
  if static[cpu] == nil then
    static[cpu] = {
      numInstances = 0,
      numChannels = 0,
      instances = {},  
      finalized = false,  
    }
  end
  Din["instance"] = static[cpu].numInstances
  static[cpu].numInstances = static[cpu].numInstances + 1

  function Din:checkMaskParameters()
  end

  function Din:p_getDirectFeedthroughCode()
    local Require = ResourceList:new()
    local InitCode = U.CodeLines:new()
    local OutputSignal = StringList:new()
    
    table.insert(static[self.cpu].instances, self.bid)
    
    self.port = string.char(65+Block.Mask.Port-1)
    self.pins = {}
    self.inputType = inputType[Block.Mask.InputType]
    
    for i = 1, Block.NumOutputSignals[1] do
      self.pins[static[self.cpu].numChannels] = Block.Mask.Pin[i]
      Require:add('P%s'% {self.port}, Block.Mask.Pin[i])  
      OutputSignal:append("PLXHAL_DIO_get(%i)" % {static[self.cpu].numChannels})
      static[self.cpu].numChannels = static[self.cpu].numChannels + 1
      globals.syscfg:addEntry('din', {
        port = self.port,
        pin = Block.Mask.Pin[i],
        pull = self.inputType,
        path = self:getName(),
      })
    end

    return {
      InitCode = InitCode,
      OutputSignal = { OutputSignal },
      Require = Require,
      UserData  = {bid = Din:getId()}
    }  
  end
  
  function Din:finalizeThis(c)
    for ch, pin in pairs(self.pins) do
      c.PreInitCode:append("PLX_DIO_configureIn(DinHandles[%i], PLX_PORT%s, %i, true);" % {ch, self.port, pin})
    end
  end

  function Din:finalize(c)
    if static[self.cpu].finalized then
      return
    end
    
    c.Include:append('plx_dio.h')
    c.Declarations:append('PLX_DIO_Handle_t DinHandles[%i];' % {static[self.cpu].numChannels})
    c.Declarations:append('PLX_DIO_Obj_t DinObj[%i];' % {static[self.cpu].numChannels})
    
    c.Declarations:append('bool PLXHAL_DIO_get(uint16_t aHandle){');
    c.Declarations:append('  return PLX_DIO_get(DinHandles[aHandle]);');
    c.Declarations:append('}');
      
    local code = [[
      for (int i = 0; i < %d; i++) {
        DinHandles[i] = PLX_DIO_init(&DinObj[i], sizeof(DinObj[i]));
      }
    ]]
    c.PreInitCode:append(code % {static[self.cpu].numChannels})
    
    for _, bid in pairs(static[self.cpu].instances) do
        local din = globals.instances[bid]
        if din:getCpu() == self.cpu then
          din:finalizeThis(c)
        end
    end

    static[self.cpu].finalized = true   
  end
  
  return Din
end

return Module
