/*
   Copyright (c) 2023 by Plexim GmbH
   All rights reserved.

   A free license is granted to anyone to use this software for any legal
   non safety-critical purpose, including commercial applications, provided
   that:
   1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
   2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
   SOFTWARE.
 */

#include "plx_gpio.h"

void PLX_GPIO_sinit()
{
   static bool firstCall = true;
   if(firstCall)
   {
      firstCall = false;
#ifdef GPIOA
      __HAL_RCC_GPIOA_CLK_ENABLE();
#endif
#ifdef GPIOB
      __HAL_RCC_GPIOB_CLK_ENABLE();
#endif
#ifdef GPIOC
      __HAL_RCC_GPIOC_CLK_ENABLE();
#endif
#ifdef GPIOD
      __HAL_RCC_GPIOD_CLK_ENABLE();
#endif
#ifdef GPIOE
      __HAL_RCC_GPIOE_CLK_ENABLE();
#endif
#ifdef GPIOF
      __HAL_RCC_GPIOF_CLK_ENABLE();
#endif
#ifdef GPIOG
      __HAL_RCC_GPIOG_CLK_ENABLE();
#endif
#ifdef GPIOH
      __HAL_RCC_GPIOH_CLK_ENABLE();
#endif
#ifdef GPIOI
      __HAL_RCC_GPIOI_CLK_ENABLE();
#endif
#ifdef GPIOJ
      __HAL_RCC_GPIOJ_CLK_ENABLE();
#endif
#ifdef GPIOK
      __HAL_RCC_GPIOK_CLK_ENABLE();
#endif
   }
}

void PLX_GPIO_setGpioConfig(PLX_GPIO_Port_t aPort, LL_GPIO_InitTypeDef *aInitStruct)
{
   LL_GPIO_Init(PLX_GPIO_getBase(aPort), aInitStruct);
}

GPIO_TypeDef *PLX_GPIO_getBase(PLX_GPIO_Port_t aPort)
{
   switch(aPort)
   {
#ifdef GPIOA
   case PLX_PORTA:
      return ((GPIO_TypeDef *) GPIOA_BASE);
#endif
#ifdef GPIOB
   case PLX_PORTB:
      return ((GPIO_TypeDef *) GPIOB_BASE);
#endif
#ifdef GPIOC
   case PLX_PORTC:
      return ((GPIO_TypeDef *) GPIOC_BASE);
#endif
#ifdef GPIOD
   case PLX_PORTD:
      return ((GPIO_TypeDef *) GPIOD_BASE);
#endif
#ifdef GPIOE
   case PLX_PORTE:
      return ((GPIO_TypeDef *) GPIOE_BASE);
#endif
#ifdef GPIOF
   case PLX_PORTF:
      return ((GPIO_TypeDef *) GPIOF_BASE);
#endif
#ifdef  GPIOG
   case PLX_PORTG:
      return ((GPIO_TypeDef *) GPIOG_BASE);
#endif
#ifdef  GPIOH
   case PLX_PORTH:
      return ((GPIO_TypeDef *) GPIOH_BASE);
#endif
#ifdef  GPIOI
   case PLX_PORTI:
      return ((GPIO_TypeDef *) GPIOI_BASE);
#endif

#ifdef  GPIOJ
   case PLX_PORTJ:
      return ((GPIO_TypeDef *) GPIOJ_BASE);
#endif

#ifdef  GPIOK
    case PLX_PORTK:
      return ((GPIO_TypeDef *) GPIOK_BASE);
#endif
   default:
      PLX_ASSERT(0);
  }
  return (GPIO_TypeDef *) 0;
}
