/*
   Copyright (c) 2020 by Plexim GmbH
   All rights reserved.

   A free license is granted to anyone to use this software for any legal
   non safety-critical purpose, including commercial applications, provided
   that:
   1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
   2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
   SOFTWARE.
 */

#ifndef HRTIM_IMPL_H_
#define HRTIM_IMPL_H_

#include "stm32g4xx_hal_hrtim.h"
#include "stm32g4xx_ll_hrtim.h"
#include "stm32g4xx_ll_bus.h"
#include "stm32g4xx_ll_gpio.h"
#include "stm32g4xx_ll_rcc.h"
#include "plx_hrtimer_impl_common.h"

extern PLX_HRTIM_SObj_t* getSObjPtr( void );

__STATIC_INLINE void PLX_HRTIM_setDuty1(PLX_HRTIM_Handle_t aHandle, PLX_HRTIM_Timer_t aTimer, PLX_HRTIM_Channel_t aChannel, float aDuty)
{
   PLX_HRTIM_Obj_t *obj = (PLX_HRTIM_Obj_t *)aHandle;
   uint32_t period = LL_HRTIM_TIM_GetPeriod(obj->instance, obj->timers[aTimer]);
   uint32_t duty = (uint32_t)((float)period * aDuty);
   if(duty < obj->minCmpRegValue[aTimer])
   {
      // Force 0% duty cycle
      LL_HRTIM_TIM_SetCompare1(obj->instance, obj->timers[aTimer], 0);
   }
   else if (duty >= period - obj->minCmpRegValue[aTimer])
   {
      // 100% duty needs special handling for symmetrical carrier
      if (LL_HRTIM_TIM_GetCountingMode(obj->instance, obj->timers[aTimer]) == LL_HRTIM_COUNTING_MODE_UP_DOWN)
      {
         PLX_HRTIM_SObj_t* objPtr = getSObjPtr();
         LL_HRTIM_TIM_SetCompare1(obj->instance, obj->timers[aTimer], period+1);
         LL_HRTIM_ForceUpdate(obj->instance, obj->timers[aTimer]);
         LL_HRTIM_OUT_ForceLevel(obj->instance, objPtr->channelLookup[aChannel], LL_HRTIM_OUT_LEVEL_ACTIVE);
      }
      else
      {
         LL_HRTIM_TIM_SetCompare1(obj->instance, obj->timers[aTimer], period + 1);
      }
   }
   else
   {
      LL_HRTIM_TIM_SetCompare1(obj->instance, obj->timers[aTimer], duty);
   }
}

__STATIC_INLINE void PLX_HRTIM_setDuty2(PLX_HRTIM_Handle_t aHandle, PLX_HRTIM_Timer_t aTimer, PLX_HRTIM_Channel_t aChannel, float aDuty)
{
   PLX_HRTIM_Obj_t *obj = (PLX_HRTIM_Obj_t *)aHandle;
   uint32_t period = LL_HRTIM_TIM_GetPeriod(obj->instance, obj->timers[aTimer]);
   uint32_t duty = (uint32_t)((float)period * aDuty);
   if(duty < obj->minCmpRegValue[aTimer])
   {
      // Force 0% duty cycle
      LL_HRTIM_TIM_SetCompare2(obj->instance, obj->timers[aTimer], 0);
   }
   else if (duty >= period - obj->minCmpRegValue[aTimer])
   {
      // 100% duty needs special handling for symmetrical carrier
      if (LL_HRTIM_TIM_GetCountingMode(obj->instance, obj->timers[aTimer]) == LL_HRTIM_COUNTING_MODE_UP_DOWN)
      {
         PLX_HRTIM_SObj_t* objPtr = getSObjPtr();
         LL_HRTIM_TIM_SetCompare2(obj->instance, obj->timers[aTimer], period + 1);
         LL_HRTIM_ForceUpdate(obj->instance, obj->timers[aTimer]);
         LL_HRTIM_OUT_ForceLevel(obj->instance, objPtr->channelLookup[aChannel], LL_HRTIM_OUT_LEVEL_ACTIVE);
      }
      else
      {
         LL_HRTIM_TIM_SetCompare2(obj->instance, obj->timers[aTimer], period+1);
      }
   }
   else
   {
      LL_HRTIM_TIM_SetCompare2(obj->instance, obj->timers[aTimer], duty);
   }
}

__STATIC_INLINE void PLX_HRTIM_setDuty3(PLX_HRTIM_Handle_t aHandle, PLX_HRTIM_Timer_t aTimer, PLX_HRTIM_Channel_t aChannel, float aDuty)
{
   PLX_HRTIM_Obj_t *obj = (PLX_HRTIM_Obj_t *)aHandle;
   uint32_t period = LL_HRTIM_TIM_GetPeriod(obj->instance, obj->timers[aTimer]);
   uint32_t duty = (uint32_t)((float)period * aDuty);
   if(duty < obj->minCmpRegValue[aTimer])
   {
      // Force 0% duty cycle
      LL_HRTIM_TIM_SetCompare3(obj->instance, obj->timers[aTimer], 0);
   }
   else if (duty >= period - obj->minCmpRegValue[aTimer])
   {
      // 100% duty needs special handling for symmetrical carrier
      if (LL_HRTIM_TIM_GetCountingMode(obj->instance, obj->timers[aTimer]) == LL_HRTIM_COUNTING_MODE_UP_DOWN)
      {
         PLX_HRTIM_SObj_t* objPtr = getSObjPtr();
         LL_HRTIM_TIM_SetCompare3(obj->instance, obj->timers[aTimer], period + 1);
         LL_HRTIM_ForceUpdate(obj->instance, obj->timers[aTimer]);
         LL_HRTIM_OUT_ForceLevel(obj->instance, objPtr->channelLookup[aChannel], LL_HRTIM_OUT_LEVEL_ACTIVE);
      }
      else
      {
         LL_HRTIM_TIM_SetCompare3(obj->instance, obj->timers[aTimer], period+1);
      }
   }
   else
   {
      LL_HRTIM_TIM_SetCompare3(obj->instance, obj->timers[aTimer], duty);
   }
}


#endif /* HRTIM_IMPL_H_ */
