--[[
  Copyright (c) 2021 by Plexim GmbH
  All rights reserved.

  A free license is granted to anyone to use this software for any legal
  non safety-critical purpose, including commercial applications, provided
  that:
  1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
  2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
--]]--

local U = require('common.utils')

local static = {}
local Module = {}

function Module.getBlock(globals, cpu)

  local CanStatus = require('common.block').getBlock(globals, cpu)
  if static[cpu] == nil then
    static[cpu] = {
      numInstances = 0,
      instances = {},
      finalized = false,
    }
  end
  CanStatus["instance"] = static[cpu].numInstances
  static[cpu].numInstances = static[cpu].numInstances + 1

  function CanStatus:checkMaskParameters()
    self.canUnitAsInt = Block.Mask.CanUnit
  end

  function CanStatus:p_getDirectFeedthroughCode()
    local Require = ResourceList:new()
    local InitCode = U.CodeLines:new()

    table.insert(static[self.cpu].instances, self.bid)

    -- see if a CAN object has already been created
    self.canObj = self:getBlockInstanceWithMatchingParameter('can', 'canUnitAsInt')

    if not self.canObj then
      -- cerate new CAN object
      self.canObj = self:makeBlock('can', self.cpu)
      self.canObj:createImplicit(self.canUnitAsInt)
    end
    self.canInstance = self.canObj:getObjIndex()

    local recOutputSignal = StringList:new()
    recOutputSignal = {'PLXHAL_CAN_getReceiveErrorCounter(%i)' % {self.canInstance}}
    
    local tecOutputSignal = StringList:new()
    tecOutputSignal = {'PLXHAL_CAN_getTransmitErrorCounter(%i)' % {self.canInstance}}
    
    local stOutputSignal = StringList:new()
    stOutputSignal = {'PLXHAL_CAN_getNodeState(%i)' % {self.canInstance}}

    return {
      InitCode = InitCode,
      OutputSignal = {recOutputSignal, tecOutputSignal, stOutputSignal},
      Require = Require,
      UserData = {bid = self:getId()}
    }
  end

  function CanStatus:p_getNonDirectFeedthroughCode()
    if not self.canObj:canPortConfigured() then
      U.error('Please add CAN Port component for interface %d.' % {self.canUnitAsInt})
    end
    return {}
  end

  -- No finalize() actions for this block

  return CanStatus
end

return Module
