local MCU = { }

MCU.adcs = {
  ADC1 = {
    IN1 = {port = 'A', pin = 0},
    IN2 = {port = 'A', pin = 1},
    IN3 = {port = 'A', pin = 2},
    IN4 = {port = 'A', pin = 3},
    IN6 = {port = 'C', pin = 0},
    IN7 = {port = 'C', pin = 1},
    IN8 = {port = 'C', pin = 2},
    IN9 = {port = 'C', pin = 3},
    IN11 = {port = 'B', pin = 0},
    IN12 = {port = 'B', pin = 1},
    IN13 = {port = 'B', pin = 13},
  },
  ADC2 = {
    IN1 = {port = 'A', pin = 4},
    IN2 = {port = 'A', pin = 5},
    IN3 = {port = 'A', pin = 6},
    IN4 = {port = 'A', pin = 7},
    IN5 = {port = 'C', pin = 4},
    IN6 = {port = 'C', pin = 0},
    IN7 = {port = 'C', pin = 1},
    IN8 = {port = 'C', pin = 2},
    IN9 = {port = 'C', pin = 3},
    IN11 = {port = 'C', pin = 5},
    IN12 = {port = 'B', pin = 2},
    IN13 = {port = 'B', pin = 12},
    IN14 = {port = 'B', pin = 14},
    IN15 = {port = 'B', pin = 15},
  },
}

MCU.opamps = {
  OPAMP2 = {
        gpio_in_n = {A5 = 'IO1', C5 = 'IO0'},
        gpio_in_p = {A7 = 'IO0', B0 = 'IO2', B14 = 'IO3'},
        gpio_out = {port = 'A', pin = 6},
  },
}

MCU.comps = {
  COMP2 = {
        gpio_in_n = {A2 = 'IO1'},
        gpio_in_p = {A7 = 'IO1'},
        gpio_out = {port = 'A', pin = 2},
  },
  COMP4 = {
        gpio_in_n = {B2 = 'IO1'},
        gpio_in_p = {B0 = 'IO1'},
        gpio_out = {port = 'B', pin = 1},
  },
  COMP6 = {
        gpio_in_n = {B15 = 'IO1'},
        gpio_in_p = {B11 = 'IO1'},
        gpio_out = {port = 'C', pin = 6},
  },
}

MCU.dacs = {
  DAC1 = {
    gpio = {
      [1] = {port = 'A', pin = 4},
      [2] = {port = 'A', pin = 5},
    },
    num_channels = 2,
  },
  DAC2 = {
    gpio = {
      [1] = {port = 'A', pin = 6},
    },
    num_channels = 1,
  },
}

MCU.gpio_af = {
A0 = { TIM2_CH1 = 1,  TIM2_ETR = 1,  TSC_G1_IO1 = 3,  USART2_CTS = 7},
A1 = { TIM2_CH2 = 1,  TSC_G1_IO2 = 3,  USART2_DE = 7,  USART2_RTS = 7,  TIM15_CH1N = 9},
A2 = { TIM2_CH3 = 1,  TSC_G1_IO3 = 3,  USART2_TX = 7,  COMP2_OUT = 8,  TIM15_CH1 = 9},
A3 = { TIM2_CH4 = 1,  TSC_G1_IO4 = 3,  USART2_RX = 7,  TIM15_CH2 = 9},
A4 = { TIM3_CH2 = 2,  TSC_G2_IO1 = 3,  SPI1_NSS = 5,  USART2_CK = 7},
A5 = { TIM2_CH1 = 1,  TIM2_ETR = 1,  TSC_G2_IO2 = 3,  SPI1_SCK = 5},
A6 = { TIM16_CH1 = 1,  TIM3_CH1 = 2,  TSC_G2_IO3 = 3,  SPI1_MISO = 5,  TIM1_BKIN = 6,  OPAMP2_DIG = 13},
A7 = { TIM17_CH1 = 1,  TIM3_CH2 = 2,  TSC_G2_IO4 = 3,  SPI1_MOSI = 5,  TIM1_CH1N = 6},
A8 = { RCC_MCO = 0,  TIM1_CH1 = 6,  USART1_CK = 7,  HRTIM1_CHA1 = 13},
A9 = { TSC_G4_IO1 = 3,  TIM1_CH2 = 6,  USART1_TX = 7,  TIM15_BKIN = 9,  TIM2_CH3 = 10,  HRTIM1_CHA2 = 13},
A10 = { TIM17_BKIN = 1,  TSC_G4_IO2 = 3,  TIM1_CH3 = 6,  USART1_RX = 7,  COMP6_OUT = 8,  TIM2_CH4 = 10,  HRTIM1_CHB1 = 13},
A11 = { TIM1_CH1N = 6,  USART1_CTS = 7,  CAN_RX = 9,  TIM1_CH4 = 11,  TIM1_BKIN2 = 12,  HRTIM1_CHB2 = 13},
A12 = { TIM16_CH1 = 1,  TIM1_CH2N = 6,  USART1_DE = 7,  USART1_RTS = 7,  COMP2_OUT = 8,  CAN_TX = 9,  TIM1_ETR = 11,  HRTIM1_FLT1 = 13},
A13 = { TIM16_CH1N = 1,  TSC_G4_IO3 = 3,  IR_OUT = 5,  USART3_CTS = 7},
A14 = { TSC_G4_IO4 = 3,  I2C1_SDA = 4,  TIM1_BKIN = 6,  USART2_TX = 7},
A15 = { SYS_JTDI = 0,  TIM2_CH1 = 1,  TIM2_ETR = 1,  TSC_SYNC = 3,  I2C1_SCL = 4,  SPI1_NSS = 5,  USART2_RX = 7,  TIM1_BKIN = 9,  HRTIM1_FLT2 = 13},
B0 = { TIM3_CH3 = 2,  TSC_G3_IO2 = 3,  TIM1_CH2N = 6},
B1 = { TIM3_CH4 = 2,  TSC_G3_IO3 = 3,  TIM1_CH3N = 6,  COMP4_OUT = 8,  HRTIM1_SCOUT = 13},
B2 = { TSC_G3_IO4 = 3,  HRTIM1_SCIN = 13},
B3 = { TIM2_CH2 = 1,  TSC_G5_IO1 = 3,  SPI1_SCK = 5,  USART2_TX = 7,  TIM3_ETR = 10,  HRTIM1_SCOUT = 12,  HRTIM1_EEV9 = 13},
B4 = { SYS_NJTRST = 0,  TIM16_CH1 = 1,  TIM3_CH1 = 2,  TSC_G5_IO2 = 3,  SPI1_MISO = 5,  USART2_RX = 7,  TIM17_BKIN = 10,  HRTIM1_EEV7 = 13},
B5 = { TIM16_BKIN = 1,  TIM3_CH2 = 2,  I2C1_SMBA = 4,  SPI1_MOSI = 5,  USART2_CK = 7,  TIM17_CH1 = 10,  HRTIM1_EEV6 = 13},
B6 = { TIM16_CH1N = 1,  TSC_G5_IO3 = 3,  I2C1_SCL = 4,  USART1_TX = 7,  HRTIM1_SCIN = 12,  HRTIM1_EEV4 = 13},
B7 = { TIM17_CH1N = 1,  TSC_G5_IO4 = 3,  I2C1_SDA = 4,  USART1_RX = 7,  TIM3_CH4 = 10,  HRTIM1_EEV3 = 13},
B8 = { TIM16_CH1 = 1,  TSC_SYNC = 3,  I2C1_SCL = 4,  USART3_RX = 7,  CAN_RX = 9,  TIM1_BKIN = 12,  HRTIM1_EEV8 = 13},
B9 = { TIM17_CH1 = 1,  I2C1_SDA = 4,  IR_OUT = 6,  USART3_TX = 7,  COMP2_OUT = 8,  CAN_TX = 9,  HRTIM1_EEV5 = 13},
B10 = { TIM2_CH3 = 1,  TSC_SYNC = 3,  USART3_TX = 7,  HRTIM1_FLT3 = 13},
B11 = { TIM2_CH4 = 1,  TSC_G6_IO1 = 3,  USART3_RX = 7,  HRTIM1_FLT4 = 13},
B12 = { TSC_G6_IO2 = 3,  TIM1_BKIN = 6,  USART3_CK = 7,  HRTIM1_CHC1 = 13},
B13 = { TSC_G6_IO3 = 3,  TIM1_CH1N = 6,  USART3_CTS = 7,  HRTIM1_CHC2 = 13},
B14 = { TIM15_CH1 = 1,  TSC_G6_IO4 = 3,  TIM1_CH2N = 6,  USART3_DE = 7,  USART3_RTS = 7,  HRTIM1_CHD1 = 13},
B15 = { TIM15_CH2 = 1,  TIM15_CH1N = 2,  TIM1_CH3N = 4,  HRTIM1_CHD2 = 13},
C0 = { TIM1_CH1 = 2},
C1 = { TIM1_CH2 = 2},
C2 = { TIM1_CH3 = 2},
C3 = { TIM1_CH4 = 2,  TIM1_BKIN2 = 6},
C4 = { TIM1_ETR = 2,  USART1_TX = 7},
C5 = { TIM15_BKIN = 2,  TSC_G3_IO1 = 3,  USART1_RX = 7},
C6 = { TIM3_CH1 = 2,  HRTIM1_EEV10 = 3,  COMP6_OUT = 7},
C7 = { TIM3_CH2 = 2,  HRTIM1_FLT5 = 3},
C8 = { TIM3_CH3 = 2,  HRTIM1_CHE1 = 3},
C9 = { TIM3_CH4 = 2,  HRTIM1_CHE2 = 3},
C10 = { USART3_TX = 7},
C11 = { HRTIM1_EEV2 = 3,  USART3_RX = 7},
C12 = { HRTIM1_EEV1 = 3,  USART3_CK = 7},
C13 = { TIM1_CH1N = 4},
C14 = { },
C15 = { },
D2 = { TIM3_ETR = 2},
F0 = { TIM1_CH3N = 6},
F1 = { },
}

MCU.resourceTable = {
  ADC = {
    'ADC1',
    'ADC2',
  },
  CAN = {
    'CAN1',
  },
  COMP = {
    'COMP2',
    'COMP4',
    'COMP6',
  },
  DAC = {
    'DAC1.1',
    'DAC1.2',
    'DAC2.1',
  },
  HRTIM = {
    'HRTIM1',
    'HRTIM1.Master',
    'HRTIM1.BMC',
    'HRTIM1.A',
    'HRTIM1.B',
    'HRTIM1.C',
    'HRTIM1.D',
    'HRTIM1.E',
  },
  I2C = {
    'I2C1',
  },
  OPAMP = {
    'OPAMP2',
  },
  SPI = {
    'SPI1',
  },
  TIM = {
    'TIM1',
    'TIM2',
    'TIM3',
    'TIM6',
    'TIM7',
    'TIM15',
    'TIM16',
    'TIM17',
  },
  USART = {
    'USART1',
    'USART2',
    'USART3',
  },
  UART = {
    'UART1',
    'UART2',
    'UART3',
  },
}

return MCU