local MCU = { }

MCU.adcs = {
  ADC1 = {
    IN1 = {port = 'A', pin = 0},
    IN2 = {port = 'A', pin = 1},
    IN3 = {port = 'A', pin = 2},
    IN4 = {port = 'A', pin = 3},
    IN5 = {port = 'B', pin = 14},
    IN6 = {port = 'C', pin = 0},
    IN7 = {port = 'C', pin = 1},
    IN8 = {port = 'C', pin = 2},
    IN9 = {port = 'C', pin = 3},
    IN10 = {port = 'F', pin = 0},
    IN11 = {port = 'B', pin = 12},
    IN12 = {port = 'B', pin = 1},
    IN14 = {port = 'B', pin = 11},
    IN15 = {port = 'B', pin = 0},
  },
  ADC2 = {
    IN1 = {port = 'A', pin = 0},
    IN2 = {port = 'A', pin = 1},
    IN3 = {port = 'A', pin = 6},
    IN4 = {port = 'A', pin = 7},
    IN5 = {port = 'C', pin = 4},
    IN6 = {port = 'C', pin = 0},
    IN7 = {port = 'C', pin = 1},
    IN8 = {port = 'C', pin = 2},
    IN9 = {port = 'C', pin = 3},
    IN10 = {port = 'F', pin = 1},
    IN11 = {port = 'C', pin = 5},
    IN12 = {port = 'B', pin = 2},
    IN13 = {port = 'A', pin = 5},
    IN14 = {port = 'B', pin = 11},
    IN15 = {port = 'B', pin = 15},
    IN17 = {port = 'A', pin = 4},
  },
  ADC3 = {
    IN1 = {port = 'B', pin = 1},
    IN2 = {port = 'E', pin = 9},
    IN3 = {port = 'E', pin = 13},
    IN4 = {port = 'E', pin = 7},
    IN5 = {port = 'B', pin = 13},
    IN6 = {port = 'E', pin = 8},
    IN7 = {port = 'D', pin = 10},
    IN8 = {port = 'D', pin = 11},
    IN9 = {port = 'D', pin = 12},
    IN10 = {port = 'D', pin = 13},
    IN11 = {port = 'D', pin = 14},
    IN12 = {port = 'B', pin = 0},
    IN14 = {port = 'E', pin = 10},
    IN15 = {port = 'E', pin = 11},
    IN16 = {port = 'E', pin = 12},
  },
  ADC4 = {
    IN1 = {port = 'E', pin = 14},
    IN2 = {port = 'E', pin = 15},
    IN3 = {port = 'B', pin = 12},
    IN4 = {port = 'B', pin = 14},
    IN5 = {port = 'B', pin = 15},
    IN6 = {port = 'E', pin = 8},
    IN7 = {port = 'D', pin = 10},
    IN8 = {port = 'D', pin = 11},
    IN9 = {port = 'D', pin = 12},
    IN10 = {port = 'D', pin = 13},
    IN11 = {port = 'D', pin = 14},
    IN12 = {port = 'D', pin = 8},
    IN13 = {port = 'D', pin = 9},
    IN14 = {port = 'E', pin = 10},
    IN15 = {port = 'E', pin = 11},
    IN16 = {port = 'E', pin = 12},
  },
  ADC5 = {
    IN1 = {port = 'A', pin = 8},
    IN2 = {port = 'A', pin = 9},
    IN6 = {port = 'E', pin = 8},
    IN7 = {port = 'D', pin = 10},
    IN8 = {port = 'D', pin = 11},
    IN9 = {port = 'D', pin = 12},
    IN10 = {port = 'D', pin = 13},
    IN11 = {port = 'D', pin = 14},
    IN12 = {port = 'D', pin = 8},
    IN13 = {port = 'D', pin = 9},
    IN14 = {port = 'E', pin = 10},
    IN15 = {port = 'E', pin = 11},
    IN16 = {port = 'E', pin = 12},
  },
}

MCU.opamps = {
  OPAMP5 = {
        gpio_in_n = {A3 = 'IO1', B15 = 'IO0'},
        gpio_in_p = {C3 = 'IO2', B14 = 'IO0', D12 = 'IO1'},
        gpio_out = {port = 'A', pin = 8},
  },
  OPAMP1 = {
        gpio_in_n = {A3 = 'IO0', C5 = 'IO1'},
        gpio_in_p = {A1 = 'IO0', A3 = 'IO1', A7 = 'IO2'},
        gpio_out = {port = 'A', pin = 2},
  },
  OPAMP3 = {
        gpio_in_n = {B2 = 'IO0', B10 = 'IO1'},
        gpio_in_p = {A1 = 'IO2', B0 = 'IO0', B13 = 'IO1'},
        gpio_out = {port = 'B', pin = 1},
  },
  OPAMP6 = {
        gpio_in_n = {A1 = 'IO0', B1 = 'IO1'},
        gpio_in_p = {B12 = 'IO0', B13 = 'IO2', D9 = 'IO1'},
        gpio_out = {port = 'B', pin = 11},
  },
  OPAMP2 = {
        gpio_in_n = {A5 = 'IO0', C5 = 'IO1'},
        gpio_in_p = {A7 = 'IO0', B0 = 'IO2', B14 = 'IO1', D14 = 'IO3'},
        gpio_out = {port = 'A', pin = 6},
  },
  OPAMP4 = {
        gpio_in_n = {B10 = 'IO0', D8 = 'IO1'},
        gpio_in_p = {B11 = 'IO2', B13 = 'IO0', D11 = 'IO1'},
        gpio_out = {port = 'B', pin = 12},
  },
}

MCU.comps = {
  COMP1 = {
        gpio_in_n = {A0 = 'IO2', A4 = 'IO1'},
        gpio_in_p = {A1 = 'IO1', B1 = 'IO2'},
        gpio_out = {port = 'F', pin = 4},
  },
  COMP3 = {
        gpio_in_n = {F1 = 'IO1', C0 = 'IO2'},
        gpio_in_p = {C1 = 'IO2', A0 = 'IO1'},
        gpio_out = {port = 'C', pin = 2},
  },
  COMP2 = {
        gpio_in_n = {A2 = 'IO2', A5 = 'IO1'},
        gpio_in_p = {A3 = 'IO2', A7 = 'IO1'},
        gpio_out = {port = 'A', pin = 2},
  },
  COMP4 = {
        gpio_in_n = {B2 = 'IO2', E8 = 'IO1'},
        gpio_in_p = {B0 = 'IO1', E7 = 'IO2'},
        gpio_out = {port = 'B', pin = 1},
  },
  COMP5 = {
        gpio_in_n = {B10 = 'IO1', D13 = 'IO2'},
        gpio_in_p = {B13 = 'IO1', D12 = 'IO2'},
        gpio_out = {port = 'C', pin = 7},
  },
  COMP6 = {
        gpio_in_n = {B15 = 'IO2', D10 = 'IO1'},
        gpio_in_p = {B11 = 'IO1', D11 = 'IO2'},
        gpio_out = {port = 'C', pin = 6},
  },
  COMP7 = {
        gpio_in_n = {B12 = 'IO2', D15 = 'IO1'},
        gpio_in_p = {B14 = 'IO1', D14 = 'IO2'},
        gpio_out = {port = 'C', pin = 8},
  },
}

MCU.dacs = {
  DAC1 = {
    gpio = {
      [1] = {port = 'A', pin = 4},
      [2] = {port = 'A', pin = 5},
    },
    num_channels = 2,
  },
  DAC2 = {
    gpio = {
      [1] = {port = 'A', pin = 6},
    },
    num_channels = 1,
  },
  DAC3 = {
    num_channels = 2,
  },
  DAC4 = {
    num_channels = 2,
  },
}

MCU.gpio_af = {
A0 = { TIM2_CH1 = 1,  TIM5_CH1 = 2,  USART2_CTS = 7,  USART2_NSS = 7,  COMP1_OUT = 8,  TIM8_BKIN = 9,  TIM8_ETR = 10,  TIM2_ETR = 14},
A1 = { RTC_REFIN = 0,  TIM2_CH2 = 1,  TIM5_CH2 = 2,  USART2_DE = 7,  USART2_RTS = 7,  TIM15_CH1N = 9},
A2 = { TIM2_CH3 = 1,  TIM5_CH3 = 2,  USART2_TX = 7,  COMP2_OUT = 8,  TIM15_CH1 = 9,  QUADSPI1_BK1_NCS = 10,  LPUART1_TX = 12,  UCPD1_FRSTX1 = 14,  UCPD1_FRSTX2 = 14},
A3 = { TIM2_CH4 = 1,  TIM5_CH4 = 2,  SAI1_CK1 = 3,  USART2_RX = 7,  TIM15_CH2 = 9,  QUADSPI1_CLK = 10,  LPUART1_RX = 12,  SAI1_MCLK_A = 13},
A4 = { TIM3_CH2 = 2,  SPI1_NSS = 5,  I2S3_WS = 6,  SPI3_NSS = 6,  USART2_CK = 7,  SAI1_FS_B = 13},
A5 = { TIM2_CH1 = 1,  TIM2_ETR = 2,  SPI1_SCK = 5,  UCPD1_FRSTX1 = 14,  UCPD1_FRSTX2 = 14},
A6 = { TIM16_CH1 = 1,  TIM3_CH1 = 2,  TIM8_BKIN = 4,  SPI1_MISO = 5,  TIM1_BKIN = 6,  COMP1_OUT = 8,  QUADSPI1_BK1_IO3 = 10,  LPUART1_CTS = 12},
A7 = { TIM17_CH1 = 1,  TIM3_CH2 = 2,  TIM8_CH1N = 4,  SPI1_MOSI = 5,  TIM1_CH1N = 6,  COMP2_OUT = 8,  QUADSPI1_BK1_IO2 = 10,  UCPD1_FRSTX1 = 14,  UCPD1_FRSTX2 = 14},
A8 = { RCC_MCO = 0,  I2C3_SCL = 2,  I2C2_SDA = 4,  I2S2_MCK = 5,  TIM1_CH1 = 6,  USART1_CK = 7,  COMP7_OUT = 8,  TIM4_ETR = 10,  FDCAN3_RX = 11,  SAI1_CK2 = 12,  SAI1_SCK_A = 14},
A9 = { I2C3_SMBA = 2,  I2C2_SCL = 4,  I2S3_MCK = 5,  TIM1_CH2 = 6,  USART1_TX = 7,  COMP5_OUT = 8,  TIM15_BKIN = 9,  TIM2_CH3 = 10,  SAI1_FS_A = 14},
A10 = { TIM17_BKIN = 1,  CRS_SYNC = 3,  I2C2_SMBA = 4,  SPI2_MISO = 5,  TIM1_CH3 = 6,  USART1_RX = 7,  COMP6_OUT = 8,  TIM2_CH4 = 10,  TIM8_BKIN = 11,  SAI1_D1 = 12,  SAI1_SD_A = 14},
A11 = { I2S2_SD = 5,  SPI2_MOSI = 5,  TIM1_CH1N = 6,  USART1_CTS = 7,  USART1_NSS = 7,  COMP1_OUT = 8,  FDCAN1_RX = 9,  TIM4_CH1 = 10,  TIM1_CH4 = 11,  TIM1_BKIN2 = 12},
A12 = { TIM16_CH1 = 1,  I2S_CKIN = 5,  TIM1_CH2N = 6,  USART1_DE = 7,  USART1_RTS = 7,  COMP2_OUT = 8,  FDCAN1_TX = 9,  TIM4_CH2 = 10,  TIM1_ETR = 11},
A13 = { TIM16_CH1N = 1,  I2C4_SCL = 3,  I2C1_SCL = 4,  IR_OUT = 5,  USART3_CTS = 7,  USART3_NSS = 7,  TIM4_CH3 = 10,  SAI1_SD_B = 13},
A14 = { LPTIM1_OUT = 1,  I2C4_SMBA = 3,  I2C1_SDA = 4,  TIM8_CH2 = 5,  TIM1_BKIN = 6,  USART2_TX = 7,  SAI1_FS_B = 13},
A15 = { SYS_JTDI = 0,  TIM2_CH1 = 1,  TIM8_CH1 = 2,  I2C1_SCL = 4,  SPI1_NSS = 5,  I2S3_WS = 6,  SPI3_NSS = 6,  USART2_RX = 7,  UART4_DE = 8,  UART4_RTS = 8,  TIM1_BKIN = 9,  FDCAN3_TX = 11,  TIM2_ETR = 14},
B0 = { TIM3_CH3 = 2,  TIM8_CH2N = 4,  TIM1_CH2N = 6,  QUADSPI1_BK1_IO1 = 10,  UCPD1_FRSTX1 = 14,  UCPD1_FRSTX2 = 14},
B1 = { TIM3_CH4 = 2,  TIM8_CH3N = 4,  TIM1_CH3N = 6,  COMP4_OUT = 8,  QUADSPI1_BK1_IO0 = 10,  LPUART1_DE = 12,  LPUART1_RTS = 12},
B2 = { RTC_OUT2 = 0,  LPTIM1_OUT = 1,  TIM5_CH1 = 2,  TIM20_CH1 = 3,  I2C3_SMBA = 4,  QUADSPI1_BK2_IO1 = 10},
B3 = { TIM2_CH2 = 1,  TIM4_ETR = 2,  CRS_SYNC = 3,  TIM8_CH1N = 4,  SPI1_SCK = 5,  I2S3_CK = 6,  SPI3_SCK = 6,  USART2_TX = 7,  TIM3_ETR = 10,  FDCAN3_RX = 11,  SAI1_SCK_B = 14},
B4 = { SYS_JTRST = 0,  TIM16_CH1 = 1,  TIM3_CH1 = 2,  TIM8_CH2N = 4,  SPI1_MISO = 5,  SPI3_MISO = 6,  USART2_RX = 7,  UART5_DE = 8,  UART5_RTS = 8,  TIM17_BKIN = 10,  FDCAN3_TX = 11,  SAI1_MCLK_B = 14},
B5 = { TIM16_BKIN = 1,  TIM3_CH2 = 2,  TIM8_CH3N = 3,  I2C1_SMBA = 4,  SPI1_MOSI = 5,  I2S3_SD = 6,  SPI3_MOSI = 6,  USART2_CK = 7,  I2C3_SDA = 8,  FDCAN2_RX = 9,  TIM17_CH1 = 10,  LPTIM1_IN1 = 11,  SAI1_SD_B = 12,  UART5_CTS = 14},
B6 = { TIM16_CH1N = 1,  TIM4_CH1 = 2,  TIM8_CH1 = 5,  TIM8_ETR = 6,  USART1_TX = 7,  COMP4_OUT = 8,  FDCAN2_TX = 9,  TIM8_BKIN2 = 10,  LPTIM1_ETR = 11,  SAI1_FS_B = 14},
B7 = { TIM17_CH1N = 1,  TIM4_CH2 = 2,  I2C4_SDA = 3,  I2C1_SDA = 4,  TIM8_BKIN = 5,  USART1_RX = 7,  COMP3_OUT = 8,  TIM3_CH4 = 10,  LPTIM1_IN2 = 11,  FMC_NL = 12,  UART4_CTS = 14},
B8 = { TIM16_CH1 = 1,  TIM4_CH3 = 2,  SAI1_CK1 = 3,  I2C1_SCL = 4,  USART3_RX = 7,  COMP1_OUT = 8,  FDCAN1_RX = 9,  TIM8_CH2 = 10,  TIM1_BKIN = 12,  SAI1_MCLK_A = 14},
B9 = { TIM17_CH1 = 1,  TIM4_CH4 = 2,  SAI1_D2 = 3,  I2C1_SDA = 4,  IR_OUT = 6,  USART3_TX = 7,  COMP2_OUT = 8,  FDCAN1_TX = 9,  TIM8_CH3 = 10,  TIM1_CH3N = 12,  SAI1_FS_A = 14},
B10 = { TIM2_CH3 = 1,  USART3_TX = 7,  LPUART1_RX = 8,  QUADSPI1_CLK = 10,  TIM1_BKIN = 12,  SAI1_SCK_A = 14},
B11 = { TIM2_CH4 = 1,  USART3_RX = 7,  LPUART1_TX = 8,  QUADSPI1_BK1_NCS = 10},
B12 = { TIM5_ETR = 2,  I2C2_SMBA = 4,  I2S2_WS = 5,  SPI2_NSS = 5,  TIM1_BKIN = 6,  USART3_CK = 7,  LPUART1_DE = 8,  LPUART1_RTS = 8,  FDCAN2_RX = 9},
B13 = { I2S2_CK = 5,  SPI2_SCK = 5,  TIM1_CH1N = 6,  USART3_CTS = 7,  USART3_NSS = 7,  LPUART1_CTS = 8,  FDCAN2_TX = 9},
B14 = { TIM15_CH1 = 1,  SPI2_MISO = 5,  TIM1_CH2N = 6,  USART3_DE = 7,  USART3_RTS = 7,  COMP4_OUT = 8},
B15 = { RTC_REFIN = 0,  TIM15_CH2 = 1,  TIM15_CH1N = 2,  COMP3_OUT = 3,  TIM1_CH3N = 4,  I2S2_SD = 5,  SPI2_MOSI = 5},
C0 = { LPTIM1_IN1 = 1,  TIM1_CH1 = 2,  LPUART1_RX = 8},
C1 = { LPTIM1_OUT = 1,  TIM1_CH2 = 2,  LPUART1_TX = 8,  QUADSPI1_BK2_IO0 = 10,  SAI1_SD_A = 13},
C2 = { LPTIM1_IN2 = 1,  TIM1_CH3 = 2,  COMP3_OUT = 3,  TIM20_CH2 = 6,  QUADSPI1_BK2_IO1 = 10},
C3 = { LPTIM1_ETR = 1,  TIM1_CH4 = 2,  SAI1_D1 = 3,  TIM1_BKIN2 = 6,  QUADSPI1_BK2_IO2 = 10,  SAI1_SD_A = 13},
C4 = { TIM1_ETR = 2,  I2C2_SCL = 4,  USART1_TX = 7,  QUADSPI1_BK2_IO3 = 10},
C5 = { TIM15_BKIN = 2,  SAI1_D3 = 3,  TIM1_CH4N = 6,  USART1_RX = 7},
C6 = { TIM3_CH1 = 2,  TIM8_CH1 = 4,  I2S2_MCK = 6,  COMP6_OUT = 7,  I2C4_SCL = 8},
C7 = { TIM3_CH2 = 2,  TIM8_CH2 = 4,  I2S3_MCK = 6,  COMP5_OUT = 7,  I2C4_SDA = 8},
C8 = { TIM3_CH3 = 2,  TIM8_CH3 = 4,  TIM20_CH3 = 6,  COMP7_OUT = 7,  I2C3_SCL = 8},
C9 = { TIM3_CH4 = 2,  TIM8_CH4 = 4,  I2S_CKIN = 5,  TIM8_BKIN2 = 6,  I2C3_SDA = 8},
C10 = { TIM8_CH1N = 4,  UART4_TX = 5,  I2S3_CK = 6,  SPI3_SCK = 6,  USART3_TX = 7},
C11 = { TIM8_CH2N = 4,  UART4_RX = 5,  SPI3_MISO = 6,  USART3_RX = 7,  I2C3_SDA = 8},
C12 = { TIM5_CH2 = 1,  TIM8_CH3N = 4,  UART5_TX = 5,  I2S3_SD = 6,  SPI3_MOSI = 6,  USART3_CK = 7,  UCPD1_FRSTX1 = 14,  UCPD1_FRSTX2 = 14},
C13 = { TIM1_BKIN = 2,  TIM1_CH1N = 4,  TIM8_CH4N = 6},
C14 = { },
C15 = { },
D0 = { TIM8_CH4N = 6,  FDCAN1_RX = 9,  FMC_D2 = 12,  FMC_DA2 = 12},
D1 = { TIM8_CH4 = 4,  TIM8_BKIN2 = 6,  FDCAN1_TX = 9,  FMC_D3 = 12,  FMC_DA3 = 12},
D2 = { TIM3_ETR = 2,  TIM8_BKIN = 4,  UART5_RX = 5},
D3 = { TIM2_CH1 = 2,  TIM2_ETR = 2,  USART2_CTS = 7,  USART2_NSS = 7,  QUADSPI1_BK2_NCS = 10,  FMC_CLK = 12},
D4 = { TIM2_CH2 = 2,  USART2_DE = 7,  USART2_RTS = 7,  QUADSPI1_BK2_IO0 = 10,  FMC_NOE = 12},
D5 = { USART2_TX = 7,  QUADSPI1_BK2_IO1 = 10,  FMC_NWE = 12},
D6 = { TIM2_CH4 = 2,  SAI1_D1 = 3,  USART2_RX = 7,  QUADSPI1_BK2_IO2 = 10,  FMC_NWAIT = 12,  SAI1_SD_A = 13},
D7 = { TIM2_CH3 = 2,  USART2_CK = 7,  QUADSPI1_BK2_IO3 = 10,  FMC_NCE = 12,  FMC_NE1 = 12},
D8 = { USART3_TX = 7,  FMC_D13 = 12,  FMC_DA13 = 12},
D9 = { USART3_RX = 7,  FMC_D14 = 12,  FMC_DA14 = 12},
D10 = { USART3_CK = 7,  FMC_D15 = 12,  FMC_DA15 = 12},
D11 = { TIM5_ETR = 1,  I2C4_SMBA = 4,  USART3_CTS = 7,  USART3_NSS = 7,  FMC_A16 = 12},
D12 = { TIM4_CH1 = 2,  USART3_DE = 7,  USART3_RTS = 7,  FMC_A17 = 12},
D13 = { TIM4_CH2 = 2,  FMC_A18 = 12},
D14 = { TIM4_CH3 = 2,  FMC_D0 = 12,  FMC_DA0 = 12},
D15 = { TIM4_CH4 = 2,  SPI2_NSS = 6,  FMC_D1 = 12,  FMC_DA1 = 12},
E0 = { TIM4_ETR = 2,  TIM20_CH4N = 3,  TIM16_CH1 = 4,  TIM20_ETR = 6,  USART1_TX = 7,  FMC_NBL0 = 12},
E1 = { TIM17_CH1 = 4,  TIM20_CH4 = 6,  USART1_RX = 7,  FMC_NBL1 = 12},
E2 = { SYS_TRACECLK = 0,  TIM3_CH1 = 2,  SAI1_CK1 = 3,  SPI4_SCK = 5,  TIM20_CH1 = 6,  FMC_A23 = 12,  SAI1_MCLK_A = 13},
E3 = { SYS_TRACED0 = 0,  TIM3_CH2 = 2,  SPI4_NSS = 5,  TIM20_CH2 = 6,  FMC_A19 = 12,  SAI1_SD_B = 13},
E4 = { SYS_TRACED1 = 0,  TIM3_CH3 = 2,  SAI1_D2 = 3,  SPI4_NSS = 5,  TIM20_CH1N = 6,  FMC_A20 = 12,  SAI1_FS_A = 13},
E5 = { SYS_TRACED2 = 0,  TIM3_CH4 = 2,  SAI1_CK2 = 3,  SPI4_MISO = 5,  TIM20_CH2N = 6,  FMC_A21 = 12,  SAI1_SCK_A = 13},
E6 = { SYS_TRACED3 = 0,  SAI1_D1 = 3,  SPI4_MOSI = 5,  TIM20_CH3N = 6,  FMC_A22 = 12,  SAI1_SD_A = 13},
E7 = { TIM1_ETR = 2,  FMC_D4 = 12,  FMC_DA4 = 12,  SAI1_SD_B = 13},
E8 = { TIM5_CH3 = 1,  TIM1_CH1N = 2,  FMC_D5 = 12,  FMC_DA5 = 12,  SAI1_SCK_B = 13},
E9 = { TIM5_CH4 = 1,  TIM1_CH1 = 2,  FMC_D6 = 12,  FMC_DA6 = 12,  SAI1_FS_B = 13},
E10 = { TIM1_CH2N = 2,  QUADSPI1_CLK = 10,  FMC_D7 = 12,  FMC_DA7 = 12,  SAI1_MCLK_B = 13},
E11 = { TIM1_CH2 = 2,  SPI4_NSS = 5,  QUADSPI1_BK1_NCS = 10,  FMC_D8 = 12,  FMC_DA8 = 12},
E12 = { TIM1_CH3N = 2,  SPI4_SCK = 5,  QUADSPI1_BK1_IO0 = 10,  FMC_D9 = 12,  FMC_DA9 = 12},
E13 = { TIM1_CH3 = 2,  SPI4_MISO = 5,  QUADSPI1_BK1_IO1 = 10,  FMC_D10 = 12,  FMC_DA10 = 12},
E14 = { TIM1_CH4 = 2,  SPI4_MOSI = 5,  TIM1_BKIN2 = 6,  QUADSPI1_BK1_IO2 = 10,  FMC_D11 = 12,  FMC_DA11 = 12},
E15 = { TIM1_BKIN = 2,  TIM1_CH4N = 6,  USART3_RX = 7,  QUADSPI1_BK1_IO3 = 10,  FMC_D12 = 12,  FMC_DA12 = 12},
F0 = { I2C2_SDA = 4,  I2S2_WS = 5,  SPI2_NSS = 5,  TIM1_CH3N = 6},
F1 = { I2S2_CK = 5,  SPI2_SCK = 5},
F2 = { TIM20_CH3 = 2,  I2C2_SMBA = 4,  FMC_A2 = 12},
F3 = { TIM20_CH4 = 2,  I2C3_SCL = 4,  FMC_A3 = 12},
F4 = { COMP1_OUT = 2,  TIM20_CH1N = 3,  I2C3_SDA = 4,  FMC_A4 = 12},
F5 = { TIM20_CH2N = 2,  FMC_A5 = 12},
F6 = { TIM5_ETR = 1,  TIM4_CH4 = 2,  SAI1_SD_B = 3,  I2C2_SCL = 4,  TIM5_CH1 = 6,  USART3_RTS = 7,  QUADSPI1_BK1_IO3 = 10},
F7 = { TIM20_BKIN = 2,  TIM5_CH2 = 6,  QUADSPI1_BK1_IO2 = 10,  FMC_A1 = 12,  SAI1_MCLK_B = 13},
F8 = { TIM20_BKIN2 = 2,  TIM5_CH3 = 6,  QUADSPI1_BK1_IO0 = 10,  FMC_A24 = 12,  SAI1_SCK_B = 13},
F9 = { TIM20_BKIN = 2,  TIM15_CH1 = 3,  SPI2_SCK = 5,  TIM5_CH4 = 6,  QUADSPI1_BK1_IO1 = 10,  FMC_A25 = 12,  SAI1_FS_B = 13},
F10 = { TIM20_BKIN2 = 2,  TIM15_CH2 = 3,  SPI2_SCK = 5,  QUADSPI1_CLK = 10,  FMC_A0 = 12,  SAI1_D3 = 13},
F11 = { TIM20_ETR = 2,  FMC_NE4 = 12},
F12 = { TIM20_CH1 = 2,  FMC_A6 = 12},
F13 = { TIM20_CH2 = 2,  I2C4_SMBA = 4,  FMC_A7 = 12},
F14 = { TIM20_CH3 = 2,  I2C4_SCL = 4,  FMC_A8 = 12},
F15 = { TIM20_CH4 = 2,  I2C4_SDA = 4,  FMC_A9 = 12},
G0 = { TIM20_CH1N = 2,  FMC_A10 = 12},
G1 = { TIM20_CH2N = 2,  FMC_A11 = 12},
G2 = { TIM20_CH3N = 2,  SPI1_SCK = 5,  FMC_A12 = 12},
G3 = { TIM20_BKIN = 2,  I2C4_SCL = 4,  SPI1_MISO = 5,  TIM20_CH4N = 6,  FMC_A13 = 12},
G4 = { TIM20_BKIN2 = 2,  I2C4_SDA = 4,  SPI1_MOSI = 5,  FMC_A14 = 12},
G5 = { TIM20_ETR = 2,  SPI1_NSS = 5,  LPUART1_CTS = 8,  FMC_A15 = 12},
G6 = { TIM20_BKIN = 2,  I2C3_SMBA = 4,  LPUART1_DE = 8,  LPUART1_RTS = 8,  FMC_INT = 12},
G7 = { SAI1_CK1 = 3,  I2C3_SCL = 4,  LPUART1_TX = 8,  FMC_INT = 12,  SAI1_MCLK_A = 13},
G8 = { I2C3_SDA = 4,  LPUART1_RX = 8,  FMC_NE3 = 12},
G9 = { SPI3_SCK = 6,  USART1_TX = 7,  FMC_NCE = 12,  FMC_NE2 = 12,  TIM15_CH1N = 14},
G10 = { RCC_MCO = 0},
}

MCU.resourceTable = {
  ADC = {
    'ADC1',
    'ADC2',
    'ADC3',
    'ADC4',
    'ADC5',
  },
  COMP = {
    'COMP1',
    'COMP2',
    'COMP3',
    'COMP4',
    'COMP5',
    'COMP6',
    'COMP7',
  },
  CORDIC = {
    'CORDIC',
  },
  DAC = {
    'DAC1.1',
    'DAC1.2',
    'DAC2.1',
    'DAC3.1',
    'DAC3.2',
    'DAC4.1',
    'DAC4.2',
  },
  FDCAN = {
    'FDCAN1',
    'FDCAN2',
    'FDCAN3',
  },
  FMAC = {
    'FMAC',
  },
  I2C = {
    'I2C1',
    'I2C2',
    'I2C3',
    'I2C4',
  },
  I2S = {
    'I2S2',
    'I2S3',
  },
  OPAMP = {
    'OPAMP1',
    'OPAMP2',
    'OPAMP3',
    'OPAMP4',
    'OPAMP5',
    'OPAMP6',
  },
  SPI = {
    'SPI1',
    'SPI2',
    'SPI3',
    'SPI4',
  },
  TIM = {
    'TIM1',
    'TIM2',
    'TIM3',
    'TIM4',
    'TIM5',
    'TIM6',
    'TIM7',
    'TIM8',
    'TIM15',
    'TIM16',
    'TIM17',
    'TIM20',
  },
  UART = {
    'UART4',
    'UART5',
    'UART1',
    'UART2',
    'UART3',
  },
  USART = {
    'USART1',
    'USART2',
    'USART3',
  },
}

return MCU