/*
   Copyright (c) 2023 by Plexim GmbH
   All rights reserved.

   A free license is granted to anyone to use this software for any legal
   non safety-critical purpose, including commercial applications, provided
   that:
   1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
   2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
   SOFTWARE.
 */

#ifndef HRTIM_PCC_IMPL_H_
#define HRTIM_PCC_IMPL_H_

#define HRTIM_PCC_MAX_NUM_CHANNELS 3

typedef struct PLX_HRTIM_PCC_OBJ
{
   PLX_DAC_Handle_t dacHandles[HRTIM_PCC_MAX_NUM_CHANNELS];
   uint16_t dacChannels[HRTIM_PCC_MAX_NUM_CHANNELS];
   PLX_HRTIM_Handle_t hrtimHandles[HRTIM_PCC_MAX_NUM_CHANNELS];
   PLX_HRTIM_Timer_t hrtimTimers[HRTIM_PCC_MAX_NUM_CHANNELS];
} PLX_HRTIM_PCC_Obj_t;

typedef PLX_HRTIM_PCC_Obj_t *PLX_HRTIM_PCC_Handle_t;

#endif /* HRTIM_PCC_IMPL_H_ */
