--[[
  Copyright (c) 2021 by Plexim GmbH
  All rights reserved.

  A free license is granted to anyone to use this software for any legal
  non safety-critical purpose, including commercial applications, provided
  that:
  1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
  2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
--]]

local T = require(Target.Variables.TargetName) -- why not Target.Name like other targets?
local U = require('common.utils')
local debug = require('debug')
local ExtTools = require('common.external_tools')

local function p_OnConnectFunction()
  if Target.Variables.EXTERNAL_MODE ~= 1 then
    return {}
  end
  -- only relevant for External Mode over Serial
  local interface
  if Target.Variables.BuildType == 3 then
    interface = Target.Variables.ProgIf
  else
    interface = Target.Variables.DebugIf
  end

  local serialNumber
  if Target.Variables.SpecifySerialNumber == 1 then
    serialNumber = tostring(Target.Variables.SerialNumber)
  end
  
  local gdbPort = ExtTools.getGDBPort()

  local debugServerCmd
  if interface == 1 then
    -- Open OCD
    debugServerCmd = ''
       ..ExtTools.OpenOcd.getBaseCommand()
       ..' -s '..U.shellQuote(Target.Variables.TARGET_ROOT..'/templates/openocd')
       ..' '..T.getNonIntrusiveOpenOcdOptions(serialNumber, gdbPort)
  else
    -- JLink
    debugServerCmd = ''
       ..U.shellQuote(ExtTools.JLink.getGdbServerExe())
       ..' '..T.getNonIntrusiveJLinkOptions(serialNumber, gdbPort)
    
  end
  return {
    ConnectionHelper = {
      Command = debugServerCmd,
      DelayBeforeConnectMs = 500,
      DelayAfterDisconnectMs = 1000,
      WaitForFinishedMs = 1000,
    },
  }
end

local ok, res = xpcall(p_OnConnectFunction, debug.traceback)

if ok then 
  U.dumpLog()
  return res
else -- there was an error, res will be an error including the stack trace
  return U.stripTraceOrRethrowError(res)
end
