--[[
  Copyright (c) 2021 by Plexim GmbH
  All rights reserved.

  A free license is granted to anyone to use this software for any legal
  non safety-critical purpose, including commercial applications, provided
  that:
  1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
  2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
--]]

local Module = {}
local U = require('common.utils')

local static = {}

local outputType = {
  "PUSHPULL",
  "OPENDRAIN"
}

function Module.getBlock(globals, cpu)

  local Dout = require('common.block').getBlock(globals, cpu)
  if static[cpu] == nil then
    static[cpu] = {
      numInstances = 0,
      numChannels = 0,
      instances = {},  
      finalized = false,    
    }
  end
  Dout["instance"] = static[cpu].numInstances
  static[cpu].numInstances = static[cpu].numInstances + 1
  
  function Dout:checkMaskParameters()
  end

  function Dout:createImplicit(params, req)
    table.insert(static[self.cpu].instances, self.bid)
    self.port = params.port
    self.pins = {}
    self.pins[static[self.cpu].numChannels] = params.pin
    self.outputType = params.outputType
    req:add('P%s'% {self.port}, params.pin)
    local handle = static[self.cpu].numChannels
    static[self.cpu].numChannels = static[self.cpu].numChannels + 1
    globals.syscfg:addEntry('dout', {
      port = self.port,
      pin = params.pin,
      outputType = self.outputType,
      path = params.path
    })
    return handle
  end

  function Dout:p_getDirectFeedthroughCode()
    local Require = ResourceList:new()
    local InitCode = U.CodeLines:new()
    local OutputCode = U.CodeLines:new()

    table.insert(static[self.cpu].instances, self.bid)

    self.port = string.char(65+Block.Mask.Port-1)
    self.pins = {}
    self.outputType = outputType[Block.Mask.OutputType]

    for i = 1, #Block.InputSignal[1] do
      self.pins[static[self.cpu].numChannels] = Block.Mask.Pin[i]
      Require:add('P%s'% {self.port}, Block.Mask.Pin[i])  
      OutputCode:append("PLXHAL_DIO_set(%i, %s);" % {static[self.cpu].numChannels, Block.InputSignal[1][i]})
      static[self.cpu].numChannels = static[self.cpu].numChannels + 1
      globals.syscfg:addEntry('dout', {
        port = self.port,
        pin = Block.Mask.Pin[i],
        outputType = self.outputType,
        path = self:getName()
      })
    end

    return {
      InitCode = InitCode,
      OutputCode = OutputCode,
      Require = Require,
      UserData  = {bid = Dout:getId()}
    }
  end
  
  function Dout:finalizeThis(c)
    for ch, pin in pairs(self.pins) do
      c.PreInitCode:append("PLX_DIO_configureOut(DoutHandles[%i], PLX_PORT%s, %i, true);" % {ch, self.port, pin})
    end
  end

  function Dout:finalize(c)
    if static[self.cpu].finalized then
      return
    end
    
    c.Include:append('plx_dio.h')
    c.Declarations:append('PLX_DIO_Handle_t DoutHandles[%i];' % {static[self.cpu].numChannels})
    c.Declarations:append('PLX_DIO_Obj_t DoutObj[%i];' % {static[self.cpu].numChannels})
    
    c.Declarations:append('void PLXHAL_DIO_set(uint16_t aHandle, bool aVal){')
    c.Declarations:append('  PLX_DIO_set(DoutHandles[aHandle], aVal);')
    c.Declarations:append('}')

    local code = [[
      for (int i = 0; i < %d; i++) {
        DoutHandles[i] = PLX_DIO_init(&DoutObj[i], sizeof(DoutObj[i]));
      }
    ]]
    c.PreInitCode:append(code % {static[self.cpu].numChannels})

    for _, bid in pairs(static[self.cpu].instances) do
        local dout = globals.instances[bid]
        if dout:getCpu() == self.cpu then
          dout:finalizeThis(c)
        end
    end

    static[self.cpu].finalized = true  
  end
  
  return Dout
end

return Module

