--[[
  Copyright (c) 2024 by Plexim GmbH
  All rights reserved.

  A free license is granted to anyone to use this software for any legal
  non safety-critical purpose, including commercial applications, provided
  that:
  1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
  2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
--]]

local U = require('common.utils')

local Registry = {
  BlockInstances = {},
  ExternalLibraries = {},
  LinkerFlags = {},
  CompilerFlags = {},
  SystemConfiguration = {},
  ClaimedResources = {},
  PinMap = {},
  UsedCpus = {},
}

local SystemConfig = {}
function SystemConfig:addEntry(category, data)
  if Registry.SystemConfiguration[category] == nil then
    Registry.SystemConfiguration[category] = {}
  end
  table.insert(Registry.SystemConfiguration[category], U.contractLockTable(data))
end

function SystemConfig:setEntry(name, data)
  Registry.SystemConfiguration[name] = data
end

function SystemConfig:get()
  return Registry.SystemConfiguration
end

function SystemConfig:claimResourceIfFree(resource)
  if Registry.ClaimedResources[resource] == nil then
    Registry.ClaimedResources[resource] = true
    return true
  else
    return false
  end
end

Registry.syscfgInterface = SystemConfig

local PinMap = {}
function PinMap:addEntry(pad, data)
  if Registry.PinMap[pad] == nil then
    Registry.PinMap[pad] = {}
    table.insert(Registry.PinMap[pad], data)
  end
end

function PinMap:get()
  return Registry.PinMap
end

function PinMap:delete()
  Registry.PinMap = {}
end

Registry.pinmapInterface = PinMap

return Registry
