local MCU = { }

MCU.adcs = {
  ADC1 = {
    IN1 = {port = 'A', pin = 0},
    IN2 = {port = 'A', pin = 1},
    IN3 = {port = 'A', pin = 2},
    IN4 = {port = 'A', pin = 3},
    IN5 = {port = 'A', pin = 4},
    IN6 = {port = 'C', pin = 0},
    IN7 = {port = 'C', pin = 1},
    IN8 = {port = 'C', pin = 2},
    IN9 = {port = 'C', pin = 3},
    IN10 = {port = 'A', pin = 6},
    IN11 = {port = 'B', pin = 0},
    IN12 = {port = 'B', pin = 1},
    IN13 = {port = 'B', pin = 13},
    IN14 = {port = 'B', pin = 11},
    IN15 = {port = 'A', pin = 7},
  },
}

MCU.opamps = {
  OPAMP2 = {
        gpio_in_n = {A5 = 'IO1', C5 = 'IO0'},
        gpio_in_p = {A7 = 'IO0', B0 = 'IO2', B14 = 'IO3'},
        gpio_out = {port = 'A', pin = 6},
  },
}

MCU.comps = {
  COMP2 = {
        gpio_in_n = {A2 = 'IO1'},
        gpio_in_p = {A7 = 'IO1'},
        gpio_out = {port = 'A', pin = 2},
  },
  COMP4 = {
        gpio_in_n = {B2 = 'IO1'},
        gpio_in_p = {B0 = 'IO1'},
        gpio_out = {port = 'B', pin = 1},
  },
  COMP6 = {
        gpio_in_n = {B15 = 'IO1'},
        gpio_in_p = {B11 = 'IO1'},
        gpio_out = {port = 'C', pin = 6},
  },
}

MCU.dacs = {
  DAC = {
    num_channels = 2,
  },
}

MCU.gpio_af = {
A0 = { TIM2_CH1 = 1,  TIM2_ETR = 1,  TSC_G1_IO1 = 3,  USART2_CTS = 7},
A1 = { RTC_REFIN = 0,  TIM2_CH2 = 1,  TSC_G1_IO2 = 3,  USART2_DE = 7,  USART2_RTS = 7,  TIM15_CH1N = 9},
A2 = { TIM2_CH3 = 1,  TSC_G1_IO3 = 3,  USART2_TX = 7,  COMP2_OUT = 8,  TIM15_CH1 = 9},
A3 = { TIM2_CH4 = 1,  TSC_G1_IO4 = 3,  USART2_RX = 7,  TIM15_CH2 = 9},
A4 = { TSC_G2_IO1 = 3,  I2S3_WS = 6,  SPI3_NSS = 6,  USART2_CK = 7},
A5 = { TIM2_CH1 = 1,  TIM2_ETR = 1,  TSC_G2_IO2 = 3},
A6 = { TIM16_CH1 = 1,  TSC_G2_IO3 = 3,  TIM1_BKIN = 6},
A7 = { TIM17_CH1 = 1,  TSC_G2_IO4 = 3,  TIM1_CH1N = 6},
A8 = { RCC_MCO = 0,  I2C3_SCL = 3,  I2C2_SMBA = 4,  I2S2_MCK = 5,  TIM1_CH1 = 6,  USART1_CK = 7},
A9 = { I2C3_SMBA = 2,  TSC_G4_IO1 = 3,  I2C2_SCL = 4,  I2S3_MCK = 5,  TIM1_CH2 = 6,  USART1_TX = 7,  TIM15_BKIN = 9,  TIM2_CH3 = 10},
A10 = { TIM17_BKIN = 1,  TSC_G4_IO2 = 3,  I2C2_SDA = 4,  I2S2_ext_SD = 5,  SPI2_MISO = 5,  TIM1_CH3 = 6,  USART1_RX = 7,  COMP6_OUT = 8,  TIM2_CH4 = 10},
A11 = { I2S2_SD = 5,  SPI2_MOSI = 5,  TIM1_CH1N = 6,  USART1_CTS = 7,  CAN_RX = 9,  TIM1_CH4 = 11,  TIM1_BKIN2 = 12},
A12 = { TIM16_CH1 = 1,  I2S_CKIN = 5,  TIM1_CH2N = 6,  USART1_DE = 7,  USART1_RTS = 7,  COMP2_OUT = 8,  CAN_TX = 9,  TIM1_ETR = 11},
A13 = { TIM16_CH1N = 1,  TSC_G4_IO3 = 3,  IR_OUT = 5,  USART3_CTS = 7},
A14 = { TSC_G4_IO4 = 3,  I2C1_SDA = 4,  TIM1_BKIN = 6,  USART2_TX = 7},
A15 = { SYS_JTDI = 0,  TIM2_CH1 = 1,  TIM2_ETR = 1,  TSC_SYNC = 3,  I2C1_SCL = 4,  I2S3_WS = 6,  SPI3_NSS = 6,  USART2_RX = 7,  TIM1_BKIN = 9},
B0 = { TSC_G3_IO2 = 3,  TIM1_CH2N = 6},
B1 = { TSC_G3_IO3 = 3,  TIM1_CH3N = 6,  COMP4_OUT = 8},
B2 = { TSC_G3_IO4 = 3},
B3 = { TIM2_CH2 = 1,  TSC_G5_IO1 = 3,  I2S3_CK = 6,  SPI3_SCK = 6,  USART2_TX = 7},
B4 = { SYS_NJTRST = 0,  TIM16_CH1 = 1,  TSC_G5_IO2 = 3,  I2S3_ext_SD = 6,  SPI3_MISO = 6,  USART2_RX = 7,  TIM17_BKIN = 10},
B5 = { TIM16_BKIN = 1,  I2C1_SMBA = 4,  I2S3_SD = 6,  SPI3_MOSI = 6,  USART2_CK = 7,  I2C3_SDA = 8,  TIM17_CH1 = 10},
B6 = { TIM16_CH1N = 1,  TSC_G5_IO3 = 3,  I2C1_SCL = 4,  USART1_TX = 7},
B7 = { TIM17_CH1N = 1,  TSC_G5_IO4 = 3,  I2C1_SDA = 4,  USART1_RX = 7},
B8 = { TIM16_CH1 = 1,  TSC_SYNC = 3,  I2C1_SCL = 4,  USART3_RX = 7,  CAN_RX = 9,  TIM1_BKIN = 12},
B9 = { TIM17_CH1 = 1,  I2C1_SDA = 4,  IR_OUT = 6,  USART3_TX = 7,  COMP2_OUT = 8,  CAN_TX = 9},
B10 = { TIM2_CH3 = 1,  TSC_SYNC = 3,  USART3_TX = 7},
B11 = { TIM2_CH4 = 1,  TSC_G6_IO1 = 3,  USART3_RX = 7},
B12 = { TSC_G6_IO2 = 3,  I2C2_SMBA = 4,  I2S2_WS = 5,  SPI2_NSS = 5,  TIM1_BKIN = 6,  USART3_CK = 7},
B13 = { TSC_G6_IO3 = 3,  I2S2_CK = 5,  SPI2_SCK = 5,  TIM1_CH1N = 6,  USART3_CTS = 7},
B14 = { TIM15_CH1 = 1,  TSC_G6_IO4 = 3,  I2S2_ext_SD = 5,  SPI2_MISO = 5,  TIM1_CH2N = 6,  USART3_DE = 7,  USART3_RTS = 7},
B15 = { RTC_REFIN = 0,  TIM15_CH2 = 1,  TIM15_CH1N = 2,  TIM1_CH3N = 4,  I2S2_SD = 5,  SPI2_MOSI = 5},
C0 = { TIM1_CH1 = 2},
C1 = { TIM1_CH2 = 2},
C2 = { TIM1_CH3 = 2},
C3 = { TIM1_CH4 = 2,  TIM1_BKIN2 = 6},
C4 = { TIM1_ETR = 2,  USART1_TX = 7},
C5 = { TIM15_BKIN = 2,  TSC_G3_IO1 = 3,  USART1_RX = 7},
C6 = { I2S2_MCK = 6,  COMP6_OUT = 7},
C7 = { I2S3_MCK = 6},
C9 = { I2C3_SDA = 3,  I2S_CKIN = 5},
C10 = { I2S3_CK = 6,  SPI3_SCK = 6,  USART3_TX = 7},
C11 = { I2S3_ext_SD = 6,  SPI3_MISO = 6,  USART3_RX = 7},
C12 = { I2S3_SD = 6,  SPI3_MOSI = 6,  USART3_CK = 7},
C13 = { TIM1_CH1N = 4},
C14 = { },
C15 = { },
F0 = { I2C2_SDA = 4,  I2S2_WS = 5,  SPI2_NSS = 5,  TIM1_CH3N = 6},
F1 = { I2C2_SCL = 4,  I2S2_CK = 5,  SPI2_SCK = 5},
}

MCU.resourceTable = {
  ADC = {
    'ADC1',
  },
  CAN = {
    'CAN1',
  },
  COMP = {
    'COMP2',
    'COMP4',
    'COMP6',
  },
  DAC = {
    'DAC.1',
    'DAC.2',
  },
  I2C = {
    'I2C1',
    'I2C2',
    'I2C3',
  },
  I2S = {
    'I2S2',
    'I2S3',
  },
  OPAMP = {
    'OPAMP2',
  },
  SPI = {
    'SPI2',
    'SPI3',
  },
  TIM = {
    'TIM1',
    'TIM2',
    'TIM6',
    'TIM15',
    'TIM16',
    'TIM17',
  },
  USART = {
    'USART1',
    'USART2',
    'USART3',
  },
  UART = {
    'UART1',
    'UART2',
    'UART3',
  },
}

return MCU