let CLB_Inputs = [
	{ name: "CLB_IN0", displayName: "Input 0" },
	{ name: "CLB_IN1", displayName: "Input 1" },
	{ name: "CLB_IN2", displayName: "Input 2" },
	{ name: "CLB_IN3", displayName: "Input 3" },
	{ name: "CLB_IN4", displayName: "Input 4" },
	{ name: "CLB_IN5", displayName: "Input 5" },
	{ name: "CLB_IN6", displayName: "Input 6" },
	{ name: "CLB_IN7", displayName: "Input 7" },
]
let CLB_Outputs = [
	{ name: "CLB_OUT0", displayName: "Output 0" },
	{ name: "CLB_OUT1", displayName: "Output 1" },
	{ name: "CLB_OUT2", displayName: "Output 2" },
	{ name: "CLB_OUT3", displayName: "Output 3" },
	{ name: "CLB_OUT4", displayName: "Output 4" },
	{ name: "CLB_OUT5", displayName: "Output 5" },
	{ name: "CLB_OUT6", displayName: "Output 6" },
	{ name: "CLB_OUT7", displayName: "Output 7" },
]
let CLB_AOCs = [
	{ name: "CLB_AOC0", displayName: "AOC 0" },
	{ name: "CLB_AOC1", displayName: "AOC 1" },
	{ name: "CLB_AOC2", displayName: "AOC 2" },
	{ name: "CLB_AOC3", displayName: "AOC 3" },
	{ name: "CLB_AOC4", displayName: "AOC 4" },
	{ name: "CLB_AOC5", displayName: "AOC 5" },
	{ name: "CLB_AOC6", displayName: "AOC 6" },
	{ name: "CLB_AOC7", displayName: "AOC 7" },
]
let CLB_SWReleaseCtrl = [
	{ name: "CLB_SW_RLS_CTRL0", displayName: "SW RLS CTRL 0" },
	{ name: "CLB_SW_RLS_CTRL1", displayName: "SW RLS CTRL 1" },
	{ name: "CLB_SW_RLS_CTRL2", displayName: "SW RLS CTRL 2" },
	{ name: "CLB_SW_RLS_CTRL3", displayName: "SW RLS CTRL 3" },
	{ name: "CLB_SW_RLS_CTRL4", displayName: "SW RLS CTRL 4" },
	{ name: "CLB_SW_RLS_CTRL5", displayName: "SW RLS CTRL 5" },
	{ name: "CLB_SW_RLS_CTRL6", displayName: "SW RLS CTRL 6" },
	{ name: "CLB_SW_RLS_CTRL7", displayName: "SW RLS CTRL 7" },
]
let CLB_SWGateCtrl = [
	{ name: "CLB_SW_GATE_CTRL0", displayName: "SW GATE CTRL 0" },
	{ name: "CLB_SW_GATE_CTRL1", displayName: "SW GATE CTRL 1" },
	{ name: "CLB_SW_GATE_CTRL2", displayName: "SW GATE CTRL 2" },
	{ name: "CLB_SW_GATE_CTRL3", displayName: "SW GATE CTRL 3" },
	{ name: "CLB_SW_GATE_CTRL4", displayName: "SW GATE CTRL 4" },
	{ name: "CLB_SW_GATE_CTRL5", displayName: "SW GATE CTRL 5" },
	{ name: "CLB_SW_GATE_CTRL6", displayName: "SW GATE CTRL 6" },
	{ name: "CLB_SW_GATE_CTRL7", displayName: "SW GATE CTRL 7" },
]
let CLB_Counters = [
	{ name: "CLB_CTR0", displayName: "Counter 0" },
	{ name: "CLB_CTR1", displayName: "Counter 1" },
	{ name: "CLB_CTR2", displayName: "Counter 2" },
]
let CLB_Register = [
	{ name: "CLB_REG_HLC_R0", displayName: "HLC R0 register" },
	{ name: "CLB_REG_HLC_R1", displayName: "HLC R1 register" },
	{ name: "CLB_REG_HLC_R2", displayName: "HLC R2 register" },
	{ name: "CLB_REG_HLC_R3", displayName: "HLC R3 register" },
	{ name: "CLB_REG_CTR_C0", displayName: "Counter 0 register" },
	{ name: "CLB_REG_CTR_C1", displayName: "Counter 1 register" },
	{ name: "CLB_REG_CTR_C2", displayName: "Counter 2 register" },
]
let CLB_FilterType = [
	{ name: "CLB_FILTER_NONE", displayName: "No filtering" },
	{ name: "CLB_FILTER_RISING_EDGE", displayName: "Rising edge detect" },
	{ name: "CLB_FILTER_FALLING_EDGE", displayName: "Falling edge detect" },
	{ name: "CLB_FILTER_ANY_EDGE", displayName: "Any edge detect" },
]
let CLB_GPInputMux = [
	{ name: "CLB_GP_IN_MUX_EXTERNAL", displayName: "Use external input path" },
	{ name: "CLB_GP_IN_MUX_GP_REG", displayName: "Use CLB_GP_REG bit value as input" },
]
let CLB_LocalInputMux = [
	{ name: "CLB_LOCAL_IN_MUX_GLOBAL_IN", displayName: "Global input mux selection" },
	{ name: "CLB_LOCAL_IN_MUX_EPWM_DCAEVT1", displayName: "EPWMx DCAEVT1" },
	{ name: "CLB_LOCAL_IN_MUX_EPWM_DCAEVT2", displayName: "EPWMx DCAEVT2" },
	{ name: "CLB_LOCAL_IN_MUX_EPWM_DCBEVT1", displayName: "EPWMx DCBEVT1" },
	{ name: "CLB_LOCAL_IN_MUX_EPWM_DCBEVT2", displayName: "EPWMx DCBEVT2" },
	{ name: "CLB_LOCAL_IN_MUX_EPWM_DCAH", displayName: "EPWMx DCAH" },
	{ name: "CLB_LOCAL_IN_MUX_EPWM_DCAL", displayName: "EPWMx DCAL" },
	{ name: "CLB_LOCAL_IN_MUX_EPWM_DCBH", displayName: "EPWMx DCBH" },
	{ name: "CLB_LOCAL_IN_MUX_EPWM_DCBL", displayName: "EPWMx DCBL" },
	{ name: "CLB_LOCAL_IN_MUX_EPWM_OST", displayName: "EPWMx OST" },
	{ name: "CLB_LOCAL_IN_MUX_EPWM_CBC", displayName: "EPWMx CBC" },
	{ name: "CLB_LOCAL_IN_MUX_ECAP_ECAPIN", displayName: "ECAPx ECAPIN" },
	{ name: "CLB_LOCAL_IN_MUX_ECAP_ECAP_OUT", displayName: "ECAPx ECAP_OUT" },
	{ name: "CLB_LOCAL_IN_MUX_ECAP_ECAP_OUT_EN", displayName: "ECAPx ECAP_OUT_EN" },
	{ name: "CLB_LOCAL_IN_MUX_ECAP_CEVT1", displayName: "ECAPx CEVT1" },
	{ name: "CLB_LOCAL_IN_MUX_ECAP_CEVT2", displayName: "ECAPx CEVT2" },
	{ name: "CLB_LOCAL_IN_MUX_ECAP_CEVT3", displayName: "ECAPx CEVT3" },
	{ name: "CLB_LOCAL_IN_MUX_ECAP_CEVT4", displayName: "ECAPx CEVT4" },
	{ name: "CLB_LOCAL_IN_MUX_EQEP_EQEPA", displayName: "EQEPx EQEPA (CLB 1-4)" },
	{ name: "CLB_LOCAL_IN_MUX_FSI_DATA_PKT_RCVD", displayName: "FSI_DATA_PKT_RCVD(CLB 5-6)" },
	{ name: "CLB_LOCAL_IN_MUX_EQEP_EQEPB", displayName: "EQEPx EQEPB (CLB 1-4)" },
	{ name: "CLB_LOCAL_IN_MUX_FSI_ERROR_PKT_RCVD", displayName: "FSI_ERROR_PKT_RCVD(CLB 5-6)" },
	{ name: "CLB_LOCAL_IN_MUX_EQEP_EQEPI", displayName: "EQEPx EQEPI (CLB 1-4)" },
	{ name: "CLB_LOCAL_IN_MUX_FSI_PING_PKT_RCVD", displayName: "FSI_PING_PKT_RCVD(CLB 5-6)" },
	{ name: "CLB_LOCAL_IN_MUX_EQEP_EQEPS", displayName: "EQEPx EQEPS (CLB 1-4)" },
	{ name: "CLB_LOCAL_IN_MUX_CPU2_HALT", displayName: "CPU2.HALT (CLB 5-6)" },
	{ name: "CLB_LOCAL_IN_MUX_CPU1_TBCLKSYNC", displayName: "CPU1.TBCLKSYNC" },
	{ name: "CLB_LOCAL_IN_MUX_CPU2_TBCLKSYNC", displayName: "CPU2.TBCLKSYNC" },
	{ name: "CLB_LOCAL_IN_MUX_CPU1_HALT", displayName: "CPU1.HALT" },
	{ name: "CLB_LOCAL_IN_MUX_SPIPICO_CONTROLLER", displayName: "SPIPICO Controller Output", legacyNames: ["CLB_LOCAL_IN_MUX_SPISIMO_MASTER"]},
	{ name: "CLB_LOCAL_IN_MUX_SPICLK", displayName: "SPI Clock" },
	{ name: "CLB_LOCAL_IN_MUX_SPIPICO_PERIPHERAL", displayName: "SPIPICO Peripheral Input", legacyNames: ["CLB_LOCAL_IN_MUX_SPISIMO_SLAVE"]},
	{ name: "CLB_LOCAL_IN_MUX_SPIPTE", displayName: "SPI PTE", legacyNames: ["CLB_LOCAL_IN_MUX_SPISTE"]},
	{ name: "CLB_LOCAL_IN_MUX_SCI_TX", displayName: "SCI TX" },
	{ name: "CLB_LOCAL_IN_MUX_SPIPOCI_OUT", displayName: "SPIPOCI(OUT)", legacyNames: ["CLB_LOCAL_IN_MUX_SPISOMI_OUT"]},
	{ name: "CLB_LOCAL_IN_MUX_CLB_PSCLK", displayName: "CLB prescaled clock" },
	{ name: "CLB_LOCAL_IN_MUX_EPWM9A", displayName: "EPWM9A (CLB 1-4)" },
	{ name: "CLB_LOCAL_IN_MUX_ECAP5_ECAPIN", displayName: "ECAP5 ECAPIN (CLB 5-6)" },
	{ name: "CLB_LOCAL_IN_MUX_EPWM9A_OE", displayName: "EPWM9A trip output (CLB 1-4)" },
	{ name: "CLB_LOCAL_IN_MUX_ECAP5_ECAP_OUT", displayName: "ECAP5 ECAP_OUT(CLB 5-6)" },
	{ name: "CLB_LOCAL_IN_MUX_EPWM9B", displayName: "EPWM9B (CLB 1-4)" },
	{ name: "CLB_LOCAL_IN_MUX_ECAP5_ECAP_OUT_EN", displayName: "ECAP5 ECAP_OUT_EN(CLB 5-6)" },
	{ name: "CLB_LOCAL_IN_MUX_EPWM9B_OE", displayName: "EPWM9B trip output (CLB 1-4)" },
	{ name: "CLB_LOCAL_IN_MUX_ECAP5_CEVT1", displayName: "ECAP5 CEVT1 (CLB 5-6)" },
	{ name: "CLB_LOCAL_IN_MUX_EPWM10A", displayName: "EPWM10A (CLB 1-4)" },
	{ name: "CLB_LOCAL_IN_MUX_ECAP5_CEVT2", displayName: "ECAP5 CEVT2 (CLB 5-6)" },
	{ name: "CLB_LOCAL_IN_MUX_EPWM10A_OE", displayName: "EPWM10A trip output (CLB 1-4)" },
	{ name: "CLB_LOCAL_IN_MUX_ECAP5_CEVT3", displayName: "ECAP5 CEVT3 (CLB 5-6)" },
	{ name: "CLB_LOCAL_IN_MUX_EPWM10B", displayName: "EPWM10B (CLB 1-4)" },
	{ name: "CLB_LOCAL_IN_MUX_ECAP5_CEVT4", displayName: "ECAP5 CEVT4 (CLB 5-6)" },
	{ name: "CLB_LOCAL_IN_MUX_EPWM10B_OE", displayName: "EPWM10B trip output (CLB 1-4)" },
	{ name: "CLB_LOCAL_IN_MUX_ECAP5_ECAPIN0", displayName: "ECAP5 ECAPIN0 (CLB 5-6)" },
	{ name: "CLB_LOCAL_IN_MUX_EPWM11A", displayName: "EPWM11A (CLB 1-4)" },
	{ name: "CLB_LOCAL_IN_MUX_EQEP5_EQEPA", displayName: "EQEP5 EQEPA (CLB 5)" },
	{ name: "CLB_LOCAL_IN_MUX_EQEP6_EQEPA", displayName: "EQEP6 EQEPA (CLB 6)" },
	{ name: "CLB_LOCAL_IN_MUX_EPWM11A_OE", displayName: "EPWM11A trip output (CLB 1-4)" },
	{ name: "CLB_LOCAL_IN_MUX_EQEP5_EQEPB", displayName: "EQEP5 EQEPB (CLB 5)" },
	{ name: "CLB_LOCAL_IN_MUX_EQEP6_EQEPB", displayName: "EQEP6 EQEPB (CLB 6)" },
	{ name: "CLB_LOCAL_IN_MUX_EPWM11B", displayName: "EPWM11B (CLB 1-4)" },
	{ name: "CLB_LOCAL_IN_MUX_EQEP5_EQEPI", displayName: "EQEP5 EQEPI (CLB 5)" },
	{ name: "CLB_LOCAL_IN_MUX_EQEP6_EQEPI", displayName: "EQEP6 EQEPI (CLB 6)" },
	{ name: "CLB_LOCAL_IN_MUX_EPWM11B_OE", displayName: "EPWM11B trip output (CLB 1-4)" },
	{ name: "CLB_LOCAL_IN_MUX_EQEP5_EQEPS", displayName: "EQEP5 EQEPS (CLB 5)" },
	{ name: "CLB_LOCAL_IN_MUX_EQEP6_EQEPS", displayName: "EQEP6 EQEPS (CLB 6)" },
	{ name: "CLB_LOCAL_IN_MUX_EPWM12A", displayName: "EPWM12A (CLB 1-4)" },
	{ name: "CLB_LOCAL_IN_MUX_EPWM16A", displayName: "EPWM16A (CLB 5-6)" },
	{ name: "CLB_LOCAL_IN_MUX_EPWM12A_OE", displayName: "EPWM12A trip output (CLB 1-4)" },
	{ name: "CLB_LOCAL_IN_MUX_EPWM16A_OE", displayName: "EPWM16A trip output (CLB 5-6)" },
	{ name: "CLB_LOCAL_IN_MUX_EPWM12B", displayName: "EPWM12B (CLB 1-4)" },
	{ name: "CLB_LOCAL_IN_MUX_EPWM16B", displayName: "EPWM16B (CLB 5-6)" },
	{ name: "CLB_LOCAL_IN_MUX_EPWM12B_OE", displayName: "EPWM12B trip output (CLB 1-4)" },
	{ name: "CLB_LOCAL_IN_MUX_EPWM16B_OE", displayName: "EPWM16B trip output (CLB 5-6)" },
	{ name: "CLB_LOCAL_IN_MUX_INPUT1", displayName: "CLBINPUTXBAR INPUT1" },
	{ name: "CLB_LOCAL_IN_MUX_INPUT2", displayName: "CLBINPUTXBAR INPUT2" },
	{ name: "CLB_LOCAL_IN_MUX_INPUT3", displayName: "CLBINPUTXBAR INPUT3" },
	{ name: "CLB_LOCAL_IN_MUX_INPUT4", displayName: "CLBINPUTXBAR INPUT4" },
	{ name: "CLB_LOCAL_IN_MUX_INPUT5", displayName: "CLBINPUTXBAR INPUT5" },
	{ name: "CLB_LOCAL_IN_MUX_INPUT6", displayName: "CLBINPUTXBAR INPUT6" },
	{ name: "CLB_LOCAL_IN_MUX_INPUT7", displayName: "CLBINPUTXBAR INPUT7" },
	{ name: "CLB_LOCAL_IN_MUX_INPUT8", displayName: "CLBINPUTXBAR INPUT8" },
	{ name: "CLB_LOCAL_IN_MUX_INPUT9", displayName: "CLBINPUTXBAR INPUT9" },
	{ name: "CLB_LOCAL_IN_MUX_INPUT10", displayName: "CLBINPUTXBAR INPUT10" },
	{ name: "CLB_LOCAL_IN_MUX_INPUT11", displayName: "CLBINPUTXBAR INPUT11" },
	{ name: "CLB_LOCAL_IN_MUX_INPUT12", displayName: "CLBINPUTXBAR INPUT12" },
	{ name: "CLB_LOCAL_IN_MUX_INPUT13", displayName: "CLBINPUTXBAR INPUT13" },
	{ name: "CLB_LOCAL_IN_MUX_INPUT14", displayName: "CLBINPUTXBAR INPUT14" },
	{ name: "CLB_LOCAL_IN_MUX_INPUT15", displayName: "CLBINPUTXBAR INPUT15" },
	{ name: "CLB_LOCAL_IN_MUX_INPUT16", displayName: "CLBINPUTXBAR INPUT16" },
]
let CLB_GlobalInputMux = [
	{ name: "CLB_GLOBAL_IN_MUX_EPWM1A", displayName: "EPWM1A (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM5A", displayName: "EPWM5A (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM1A_OE", displayName: "EPWM1A trip output (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM5A_OE", displayName: "EPWM5A trip output (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM1B", displayName: "EPWM1B (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM5B", displayName: "EPWM5B (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM1B_OE", displayName: "EPWM1B trip output (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM5B_OE", displayName: "EPWM5B trip output (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM1_CTR_ZERO", displayName: "EPWM1 TBCTR = Zero (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM5_CTR_ZERO", displayName: "EPWM5 TBCTR = Zero (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM1_CTR_PRD", displayName: "EPWM1 TBCTR = TBPRD (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM5_CTR_PRD", displayName: "EPWM5 TBCTR = TBPRD (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM1_CTRDIR", displayName: "EPWM1 CTRDIR (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM5_CTRDIR", displayName: "EPWM5 CTRDIR (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM1_TBCLK", displayName: "EPWM1 TBCLK (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM5_TBCLK", displayName: "EPWM5 TBCLK (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM1_CTR_CMPA", displayName: "EPWM1 TBCTR = CMPA (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM5_CTR_CMPA", displayName: "EPWM5 TBCTR = CMPA (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM1_CTR_CMPB", displayName: "EPWM1 TBCTR = CMPB (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM5_CTR_CMPB", displayName: "EPWM5 TBCTR = CMPB (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM1_CTR_CMPC", displayName: "EPWM1 TBCTR = CMPC (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM5_CTR_CMPC", displayName: "EPWM5 TBCTR = CMPC (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM1_CTR_CMPD", displayName: "EPWM1 TBCTR = CMPD (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM5_CTR_CMPD", displayName: "EPWM5 TBCTR = CMPD (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM1A_AQ", displayName: "EPWM1A AQ submodule output (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM5A_AQ", displayName: "EPWM5A AQ submodule output (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM1B_AQ", displayName: "EPWM1B AQ submodule output (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM5B_AQ", displayName: "EPWM5B AQ submodule output (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM1A_DB", displayName: "EPWM1A DB submodule output (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM5A_DB", displayName: "EPWM5A DB submodule output (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM1B_DB", displayName: "EPWM1B DB submodule output (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM5B_DB", displayName: "EPWM5B DB submodule output (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM2A", displayName: "EPWM2A (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM6A", displayName: "EPWM6A (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM2A_OE", displayName: "EPWM2A trip output (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM6A_OE", displayName: "EPWM6A trip output (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM2B", displayName: "EPWM2B (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM6B", displayName: "EPWM6B (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM2B_OE", displayName: "EPWM2B trip output (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM6B_OE", displayName: "EPWM6B trip output (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM2_CTR_ZERO", displayName: "EPWM2 TBCTR = Zero (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM6_CTR_ZERO", displayName: "EPWM6 TBCTR = Zero (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM2_CTR_PRD", displayName: "EPWM2 TBCTR = TBPRD (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM6_CTR_PRD", displayName: "EPWM6 TBCTR = TBPRD (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM2_CTRDIR", displayName: "EPWM2 CTRDIR (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM6_CTRDIR", displayName: "EPWM6 CTRDIR (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM2_TBCLK", displayName: "EPWM2 TBCLK (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM6_TBCLK", displayName: "EPWM6 TBCLK (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM2_CTR_CMPA", displayName: "EPWM2 TBCTR = CMPA (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM6_CTR_CMPA", displayName: "EPWM6 TBCTR = CMPA (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM2_CTR_CMPB", displayName: "EPWM2 TBCTR = CMPB (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM6_CTR_CMPB", displayName: "EPWM6 TBCTR = CMPB (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM2_CTR_CMPC", displayName: "EPWM2 TBCTR = CMPC (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM6_CTR_CMPC", displayName: "EPWM6 TBCTR = CMPC (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM2_CTR_CMPD", displayName: "EPWM2 TBCTR = CMPD (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM6_CTR_CMPD", displayName: "EPWM6 TBCTR = CMPD (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM2A_AQ", displayName: "EPWM2A AQ submodule output (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM6A_AQ", displayName: "EPWM6A AQ submodule output (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM2B_AQ", displayName: "EPWM2B AQ submodule output (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM6B_AQ", displayName: "EPWM6B AQ submodule output (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM2A_DB", displayName: "EPWM2A DB submodule output (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM6A_DB", displayName: "EPWM6A DB submodule output (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM2B_DB", displayName: "EPWM2B DB submodule output (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM6B_DB", displayName: "EPWM6B DB submodule output (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM3A", displayName: "EPWM3A (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM7A", displayName: "EPWM7A (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM3A_OE", displayName: "EPWM3A trip output (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM7A_OE", displayName: "EPWM7A trip output (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM3B", displayName: "EPWM3B (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM7B", displayName: "EPWM7B (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM3B_OE", displayName: "EPWM3B trip output (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM7B_OE", displayName: "EPWM7B trip output (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM3_CTR_ZERO", displayName: "EPWM3 TBCTR = Zero (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM7_CTR_ZERO", displayName: "EPWM7 TBCTR = Zero (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM3_CTR_PRD", displayName: "EPWM3 TBCTR = TBPRD (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM7_CTR_PRD", displayName: "EPWM7 TBCTR = TBPRD (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM3_CTRDIR", displayName: "EPWM3 CTRDIR (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM7_CTRDIR", displayName: "EPWM7 CTRDIR (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM3_TBCLK", displayName: "EPWM3 TBCLK (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM7_TBCLK", displayName: "EPWM7 TBCLK (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM3_CTR_CMPA", displayName: "EPWM3 TBCTR = CMPA (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM7_CTR_CMPA", displayName: "EPWM7 TBCTR = CMPA (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM3_CTR_CMPB", displayName: "EPWM3 TBCTR = CMPB (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM7_CTR_CMPB", displayName: "EPWM7 TBCTR = CMPB (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM3_CTR_CMPC", displayName: "EPWM3 TBCTR = CMPC (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM7_CTR_CMPC", displayName: "EPWM7 TBCTR = CMPC (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM3_CTR_CMPD", displayName: "EPWM3 TBCTR = CMPD (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM7_CTR_CMPD", displayName: "EPWM7 TBCTR = CMPD (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM3A_AQ", displayName: "EPWM3A AQ submodule output (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM7A_AQ", displayName: "EPWM7A AQ submodule output (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM3B_AQ", displayName: "EPWM3B AQ submodule output (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM7B_AQ", displayName: "EPWM7B AQ submodule output (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM3A_DB", displayName: "EPWM3A DB submodule output (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM7A_DB", displayName: "EPWM7A DB submodule output (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM3B_DB", displayName: "EPWM3B DB submodule output (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM7B_DB", displayName: "EPWM7B DB submodule output (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM4A", displayName: "EPWM4A (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM8A", displayName: "EPWM8A (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM4A_OE", displayName: "EPWM4A trip output (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM8A_OE", displayName: "EPWM8A trip output (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM4B", displayName: "EPWM4B (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM8B", displayName: "EPWM8B (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM4B_OE", displayName: "EPWM4B trip output (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM8B_OE", displayName: "EPWM8B trip output (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM4_CTR_ZERO", displayName: "EPWM4 TBCTR = Zero (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM8_CTR_ZERO", displayName: "EPWM8 TBCTR = Zero (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM4_CTR_PRD", displayName: "EPWM4 TBCTR = TBPRD (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM8_CTR_PRD", displayName: "EPWM8 TBCTR = TBPRD (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM4_CTRDIR", displayName: "EPWM4 CTRDIR (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM8_CTRDIR", displayName: "EPWM8 CTRDIR (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM4_TBCLK", displayName: "EPWM4 TBCLK (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM8_TBCLK", displayName: "EPWM8 TBCLK (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM4_CTR_CMPA", displayName: "EPWM4 TBCTR = CMPA (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM8_CTR_CMPA", displayName: "EPWM8 TBCTR = CMPA (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM4_CTR_CMPB", displayName: "EPWM4 TBCTR = CMPB (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM8_CTR_CMPB", displayName: "EPWM8 TBCTR = CMPB (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM4_CTR_CMPC", displayName: "EPWM4 TBCTR = CMPC (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM8_CTR_CMPC", displayName: "EPWM8 TBCTR = CMPC (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM4_CTR_CMPD", displayName: "EPWM4 TBCTR = CMPD (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM8_CTR_CMPD", displayName: "EPWM8 TBCTR = CMPD (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM4A_AQ", displayName: "EPWM4A AQ submodule output (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM8A_AQ", displayName: "EPWM8A AQ submodule output (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM4B_AQ", displayName: "EPWM4B AQ submodule output (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM8B_AQ", displayName: "EPWM8B AQ submodule output (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM4A_DB", displayName: "EPWM4A DB submodule output (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM8A_DB", displayName: "EPWM8A DB submodule output (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM4B_DB", displayName: "EPWM4B DB submodule output (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_EPWM8B_DB", displayName: "EPWM8B DB submodule output (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB_AUXSIG0", displayName: "CLB X-BAR AUXSIG0" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB_AUXSIG1", displayName: "CLB X-BAR AUXSIG1" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB_AUXSIG2", displayName: "CLB X-BAR AUXSIG2" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB_AUXSIG3", displayName: "CLB X-BAR AUXSIG3" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB_AUXSIG4", displayName: "CLB X-BAR AUXSIG4" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB_AUXSIG5", displayName: "CLB X-BAR AUXSIG5" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB_AUXSIG6", displayName: "CLB X-BAR AUXSIG6" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB_AUXSIG7", displayName: "CLB X-BAR AUXSIG7" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB1_OUT16", displayName: "CLB1 OUT16 (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB5_OUT16", displayName: "CLB5 OUT16 (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB1_OUT17", displayName: "CLB1 OUT17 (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB5_OUT17", displayName: "CLB5 OUT17 (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB1_OUT18", displayName: "CLB1 OUT18 (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB5_OUT18", displayName: "CLB5 OUT18 (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB1_OUT19", displayName: "CLB1 OUT19 (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB5_OUT19", displayName: "CLB5 OUT19 (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB1_OUT20", displayName: "CLB1 OUT20 (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB5_OUT20", displayName: "CLB5 OUT20 (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB1_OUT21", displayName: "CLB1 OUT21 (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB5_OUT21", displayName: "CLB5 OUT21 (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB1_OUT22", displayName: "CLB1 OUT22 (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB5_OUT22", displayName: "CLB5 OUT22 (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB1_OUT23", displayName: "CLB1 OUT23 (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB5_OUT23", displayName: "CLB5 OUT23 (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB2_OUT16", displayName: "CLB2 OUT16 (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB6_OUT16", displayName: "CLB6 OUT16 (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB2_OUT17", displayName: "CLB2 OUT17 (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB6_OUT17", displayName: "CLB6 OUT17 (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB2_OUT18", displayName: "CLB2 OUT18 (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB6_OUT18", displayName: "CLB6 OUT18 (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB2_OUT19", displayName: "CLB2 OUT19 (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB6_OUT19", displayName: "CLB6 OUT19 (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB2_OUT20", displayName: "CLB2 OUT20 (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB6_OUT20", displayName: "CLB6 OUT20 (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB2_OUT21", displayName: "CLB2 OUT21 (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB6_OUT21", displayName: "CLB6 OUT21 (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB2_OUT22", displayName: "CLB2 OUT22 (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB6_OUT22", displayName: "CLB6 OUT22 (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB2_OUT23", displayName: "CLB2 OUT23 (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB6_OUT23", displayName: "CLB6 OUT23 (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB3_OUT16", displayName: "CLB3 OUT16" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB3_OUT17", displayName: "CLB3 OUT17" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB3_OUT18", displayName: "CLB3 OUT18" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB3_OUT19", displayName: "CLB3 OUT19" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB3_OUT20", displayName: "CLB3 OUT20" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB3_OUT21", displayName: "CLB3 OUT21" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB3_OUT22", displayName: "CLB3 OUT22" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB3_OUT23", displayName: "CLB3 OUT23" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB4_OUT16", displayName: "CLB4 OUT16" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB4_OUT17", displayName: "CLB4 OUT17" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB4_OUT18", displayName: "CLB4 OUT18" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB4_OUT19", displayName: "CLB4 OUT19" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB4_OUT20", displayName: "CLB4 OUT20" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB4_OUT21", displayName: "CLB4 OUT21" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB4_OUT22", displayName: "CLB4 OUT22" },
	{ name: "CLB_GLOBAL_IN_MUX_CLB4_OUT23", displayName: "CLB4 OUT23" },
	{ name: "CLB_GLOBAL_IN_MUX_CPU1_ERAD_EVENT0", displayName: "CPU1 ERAD Event 0 (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_CPU2_ERAD_EVENT0", displayName: "CPU2 ERAD Event 0 (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_CPU1_ERAD_EVENT1", displayName: "CPU1 ERAD Event 1 (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_CPU2_ERAD_EVENT1", displayName: "CPU2 ERAD Event 1 (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_CPU1_ERAD_EVENT2", displayName: "CPU1 ERAD Event 2 (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_CPU2_ERAD_EVENT2", displayName: "CPU2 ERAD Event 2 (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_CPU1_ERAD_EVENT3", displayName: "CPU1 ERAD Event 3 (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_CPU2_ERAD_EVENT3", displayName: "CPU2 ERAD Event 3 (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_CPU1_ERAD_EVENT4", displayName: "CPU1 ERAD Event 4 (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_CPU2_ERAD_EVENT4", displayName: "CPU2 ERAD Event 4 (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_CPU1_ERAD_EVENT5", displayName: "CPU1 ERAD Event 5 (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_CPU2_ERAD_EVENT5", displayName: "CPU2 ERAD Event 5 (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_CPU1_ERAD_EVENT6", displayName: "CPU1 ERAD Event 6 (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_CPU2_ERAD_EVENT6", displayName: "CPU2 ERAD Event 6 (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_CPU1_ERAD_EVENT7", displayName: "CPU1 ERAD Event 7 (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_CPU2_ERAD_EVENT7", displayName: "CPU2 ERAD Event 7 (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_FSIRXA_DATA_PACKET_RCVD", displayName: "FSIRXA Data Packet Received (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_FSIRXA_PING_TAG_MATCH2", displayName: "FSIRXA PING TAG Match2 (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_FSIRXA_ERROR_PACKET_RCVD", displayName: "FSIRXA Error Packet Received (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_FSIRXA_DATA_TAG_MATCH2", displayName: "FSIRXA DATA TAG Match2 (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_FSIRXA_PING_PACKET_RCVD", displayName: "FSIRXA PING Packet Received (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_FSIRXA_ERROR_TAG_MATCH2", displayName: "FSIRXA ERROR TAG Match2 (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_FSIRXA_OUTPUT_FRAME_DONE", displayName: "FSIRXA Output Frame Done (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_FSIRXB_PING_TAG_MATCH", displayName: "FSIRXB PING TAG Match (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_FSIRXA_PING_TAG_MATCH1", displayName: "FSIRXA PING TAG Match1 (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_FSIRXB_DATA_TAG_MATCH", displayName: "FSIRXB DATA TAG Match (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_FSIRXA_DATA_TAG_MATCH1", displayName: "FSIRXA DATA TAG Match1 (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_FSIRXB_ERROR_TAG_MATCH", displayName: "FSIRXB ERROR TAG Match (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_FSIRXA_ERROR_TAG_MATCH1", displayName: "FSIRXA ERROR TAG Match1 (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_ECAT_SOF", displayName: "ECAT Start of Frame (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_FSIRXA_RX_TRIG2", displayName: "FSIRXA RX Trig 2 (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_ECAT_EOF", displayName: "ECAT End of Frame (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_SPI1_SPICLK", displayName: "SPI1 SPICLK OUT (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_SPI3_SPICLK", displayName: "SPI3 SPICLK OUT (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_SPI1_SPIPOCI_CONTROLLER", displayName: "SPI1 SPIPOCI Controller IN (CLB 1-4)", legacyNames: ["CLB_GLOBAL_IN_MUX_SPI1_SPISOMI_MASTER"]},
	{ name: "CLB_GLOBAL_IN_MUX_SPI3_SPIPOCI_CONTROLLER", displayName: "SPI3 SPIPOCI Controller IN (CLB 5-6)", legacyNames: ["CLB_GLOBAL_IN_MUX_SPI3_SPISOMI_MASTER"]},
	{ name: "CLB_GLOBAL_IN_MUX_SPI1_SPIPTE", displayName: "SPI1 SPIPTE OUT (CLB 1-4)", legacyNames: ["CLB_GLOBAL_IN_MUX_SPI1_SPISTE"]},
	{ name: "CLB_GLOBAL_IN_MUX_SPI3_SPIPTE", displayName: "SPI3 SPIPTE OUT (CLB 5-6)", legacyNames: ["CLB_GLOBAL_IN_MUX_SPI3_SPISTE"]},
	{ name: "CLB_GLOBAL_IN_MUX_SPI2_SPICLK", displayName: "SPI2 SPICLK OUT (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_SPI4_SPICLK", displayName: "SPI4 SPICLK OUT (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_SPI2_SPIPOCI_CONTROLLER", displayName: "SPI2 SPIPOCI Controller IN (CLB 1-4)", legacyNames: ["CLB_GLOBAL_IN_MUX_SPI2_SPISOMI_MASTER"]},
	{ name: "CLB_GLOBAL_IN_MUX_SPI4_SPIPOCI_CONTROLLER", displayName: "SPI4 SPIPOCI Controller IN (CLB 5-6)", legacyNames: ["CLB_GLOBAL_IN_MUX_SPI4_SPISOMI_MASTER"]},
	{ name: "CLB_GLOBAL_IN_MUX_SPI2_SPIPTE", displayName: "SPI2 SPIPTE OUT (CLB 1-4)", legacyNames: ["CLB_GLOBAL_IN_MUX_SPI2_SPISTE"]},
	{ name: "CLB_GLOBAL_IN_MUX_SPI4_SPIPTE", displayName: "SPI4 SPIPTE OUT (CLB 5-6)", legacyNames: ["CLB_GLOBAL_IN_MUX_SPI4_SPISTE"]},
	{ name: "CLB_GLOBAL_IN_MUX_CPU2_HALT", displayName: "CPU2 HALT (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_ECAT_SYNC0", displayName: "ECAT Sync 0 (CLB 5-6)" },
	{ name: "CLB_GLOBAL_IN_MUX_FSIRXA_RX_TRIG3", displayName: "FSIRXA RX Trig 3 (CLB 1-4)" },
	{ name: "CLB_GLOBAL_IN_MUX_ECAT_SYNC1", displayName: "ECAT Sync 1 (CLB 5-6)" },
]
let CLB_FIFO_SIZE = [
	{ name: "CLB_FIFO_SIZE", displayName: "FIFO SIZE" },
]
let CLB_LOCK_KEY = [
	{ name: "CLB_LOCK_KEY", displayName: "LOCK KEY" },
]
let CLB_LCL_MUX_SEL_MISC_INPUT_SEL = [
	{ name: "CLB_LCL_MUX_SEL_MISC_INPUT_SEL_M", displayName: "LCL MUX SEL MISC INPUT SEL M" },
	{ name: "CLB_LCL_MUX_SEL_MISC_INPUT_SEL_S", displayName: "LCL MUX SEL MISC INPUT SEL S" },
	{ name: "CLB_LCL_MUX_SEL_MISC_INPUT_SEL_BITM", displayName: "LCL MUX SEL MISC INPUT SEL BITM" },
]
let CLB_OUTPUT = [
	{ name: "CLB_OUTPUT_00", displayName: "Mask for CLB OUTPUT ENABLE/DISABLE 0" },
	{ name: "CLB_OUTPUT_01", displayName: "Mask for CLB OUTPUT ENABLE/DISABLE 1" },
	{ name: "CLB_OUTPUT_02", displayName: "Mask for CLB OUTPUT ENABLE/DISABLE 2" },
	{ name: "CLB_OUTPUT_03", displayName: "Mask for CLB OUTPUT ENABLE/DISABLE 3" },
	{ name: "CLB_OUTPUT_04", displayName: "Mask for CLB OUTPUT ENABLE/DISABLE 4" },
	{ name: "CLB_OUTPUT_05", displayName: "Mask for CLB OUTPUT ENABLE/DISABLE 5" },
	{ name: "CLB_OUTPUT_06", displayName: "Mask for CLB OUTPUT ENABLE/DISABLE 6" },
	{ name: "CLB_OUTPUT_07", displayName: "Mask for CLB OUTPUT ENABLE/DISABLE 7" },
	{ name: "CLB_OUTPUT_08", displayName: "Mask for CLB OUTPUT ENABLE/DISABLE 8" },
	{ name: "CLB_OUTPUT_09", displayName: "Mask for CLB OUTPUT ENABLE/DISABLE 9" },
	{ name: "CLB_OUTPUT_10", displayName: "Mask for CLB OUTPUT ENABLE/DISABLE 10" },
	{ name: "CLB_OUTPUT_11", displayName: "Mask for CLB OUTPUT ENABLE/DISABLE 11" },
	{ name: "CLB_OUTPUT_12", displayName: "Mask for CLB OUTPUT ENABLE/DISABLE 12" },
	{ name: "CLB_OUTPUT_13", displayName: "Mask for CLB OUTPUT ENABLE/DISABLE 13" },
	{ name: "CLB_OUTPUT_14", displayName: "Mask for CLB OUTPUT ENABLE/DISABLE 14" },
	{ name: "CLB_OUTPUT_15", displayName: "Mask for CLB OUTPUT ENABLE/DISABLE 15" },
	{ name: "CLB_OUTPUT_16", displayName: "Mask for CLB OUTPUT ENABLE/DISABLE 16" },
	{ name: "CLB_OUTPUT_17", displayName: "Mask for CLB OUTPUT ENABLE/DISABLE 17" },
	{ name: "CLB_OUTPUT_18", displayName: "Mask for CLB OUTPUT ENABLE/DISABLE 18" },
	{ name: "CLB_OUTPUT_19", displayName: "Mask for CLB OUTPUT ENABLE/DISABLE 19" },
	{ name: "CLB_OUTPUT_20", displayName: "Mask for CLB OUTPUT ENABLE/DISABLE 20" },
	{ name: "CLB_OUTPUT_21", displayName: "Mask for CLB OUTPUT ENABLE/DISABLE 21" },
	{ name: "CLB_OUTPUT_22", displayName: "Mask for CLB OUTPUT ENABLE/DISABLE 22" },
	{ name: "CLB_OUTPUT_23", displayName: "Mask for CLB OUTPUT ENABLE/DISABLE 23" },
	{ name: "CLB_OUTPUT_24", displayName: "Mask for CLB OUTPUT ENABLE/DISABLE 24" },
	{ name: "CLB_OUTPUT_25", displayName: "Mask for CLB OUTPUT ENABLE/DISABLE 25" },
	{ name: "CLB_OUTPUT_26", displayName: "Mask for CLB OUTPUT ENABLE/DISABLE 26" },
	{ name: "CLB_OUTPUT_27", displayName: "Mask for CLB OUTPUT ENABLE/DISABLE 27" },
	{ name: "CLB_OUTPUT_28", displayName: "Mask for CLB OUTPUT ENABLE/DISABLE 28" },
	{ name: "CLB_OUTPUT_29", displayName: "Mask for CLB OUTPUT ENABLE/DISABLE 29" },
	{ name: "CLB_OUTPUT_30", displayName: "Mask for CLB OUTPUT ENABLE/DISABLE 30" },
	{ name: "CLB_OUTPUT_31", displayName: "Mask for CLB OUTPUT ENABLE/DISABLE 31" },
]
module.exports = {
	CLB_Inputs: CLB_Inputs,
	CLB_Outputs: CLB_Outputs,
	CLB_AOCs: CLB_AOCs,
	CLB_SWReleaseCtrl: CLB_SWReleaseCtrl,
	CLB_SWGateCtrl: CLB_SWGateCtrl,
	CLB_Counters: CLB_Counters,
	CLB_Register: CLB_Register,
	CLB_FilterType: CLB_FilterType,
	CLB_GPInputMux: CLB_GPInputMux,
	CLB_LocalInputMux: CLB_LocalInputMux,
	CLB_GlobalInputMux: CLB_GlobalInputMux,
	CLB_FIFO_SIZE: CLB_FIFO_SIZE,
	CLB_LOCK_KEY: CLB_LOCK_KEY,
	CLB_LCL_MUX_SEL_MISC_INPUT_SEL: CLB_LCL_MUX_SEL_MISC_INPUT_SEL,
	CLB_OUTPUT: CLB_OUTPUT,
}
