let ECAP_EmulationMode = [
	{ name: "ECAP_EMULATION_STOP", displayName: "TSCTR is stopped on emulation suspension" },
	{ name: "ECAP_EMULATION_RUN_TO_ZERO", displayName: "TSCTR runs until 0 before stopping on emulation suspension" },
	{ name: "ECAP_EMULATION_FREE_RUN", displayName: "TSCTR is not affected by emulation suspension" },
]
let ECAP_CaptureMode = [
	{ name: "ECAP_CONTINUOUS_CAPTURE_MODE", displayName: "eCAP operates in continuous capture mode" },
	{ name: "ECAP_ONE_SHOT_CAPTURE_MODE", displayName: "eCAP operates in one shot capture mode" },
]
let ECAP_Events = [
	{ name: "ECAP_EVENT_1", displayName: "eCAP event 1" },
	{ name: "ECAP_EVENT_2", displayName: "eCAP event 2" },
	{ name: "ECAP_EVENT_3", displayName: "eCAP event 3" },
	{ name: "ECAP_EVENT_4", displayName: "eCAP event 4" },
]
let ECAP_SyncOutMode = [
	{ name: "ECAP_SYNC_OUT_SYNCI", displayName: "sync out on the sync in signal and software force" },
	{ name: "ECAP_SYNC_OUT_COUNTER_PRD", displayName: "sync out on counter equals period" },
	{ name: "ECAP_SYNC_OUT_DISABLED", displayName: "Disable sync out signal" },
]
let ECAP_APWMPolarity = [
	{ name: "ECAP_APWM_ACTIVE_HIGH", displayName: "APWM is active high" },
	{ name: "ECAP_APWM_ACTIVE_LOW", displayName: "APWM is active low" },
]
let ECAP_EventPolarity = [
	{ name: "ECAP_EVNT_RISING_EDGE", displayName: "Rising edge polarity" },
	{ name: "ECAP_EVNT_FALLING_EDGE", displayName: "Falling edge polarity" },
]
let ECAP_InputCaptureSignals = [
	{ name: "ECAP_INPUT_INPUTXBAR1", displayName: "GPIO Input Crossbar output signal-1" },
	{ name: "ECAP_INPUT_INPUTXBAR2", displayName: "GPIO Input Crossbar output signal-2" },
	{ name: "ECAP_INPUT_INPUTXBAR3", displayName: "GPIO Input Crossbar output signal-3" },
	{ name: "ECAP_INPUT_INPUTXBAR4", displayName: "GPIO Input Crossbar output signal-4" },
	{ name: "ECAP_INPUT_INPUTXBAR5", displayName: "GPIO Input Crossbar output signal-5" },
	{ name: "ECAP_INPUT_INPUTXBAR6", displayName: "GPIO Input Crossbar output signal-6" },
	{ name: "ECAP_INPUT_INPUTXBAR7", displayName: "GPIO Input Crossbar output signal-7" },
	{ name: "ECAP_INPUT_INPUTXBAR8", displayName: "GPIO Input Crossbar output signal-8" },
	{ name: "ECAP_INPUT_INPUTXBAR9", displayName: "GPIO Input Crossbar output signal-9" },
	{ name: "ECAP_INPUT_INPUTXBAR10", displayName: "GPIO Input Crossbar output signal-10" },
	{ name: "ECAP_INPUT_INPUTXBAR11", displayName: "GPIO Input Crossbar output signal-11" },
	{ name: "ECAP_INPUT_INPUTXBAR12", displayName: "GPIO Input Crossbar output signal-12" },
	{ name: "ECAP_INPUT_INPUTXBAR13", displayName: "GPIO Input Crossbar output signal-13" },
	{ name: "ECAP_INPUT_INPUTXBAR14", displayName: "GPIO Input Crossbar output signal-14" },
	{ name: "ECAP_INPUT_INPUTXBAR15", displayName: "GPIO Input Crossbar output signal-15" },
	{ name: "ECAP_INPUT_INPUTXBAR16", displayName: "GPIO Input Crossbar output signal-16" },
	{ name: "ECAP_INPUT_ECAP1_CLB1_OUT14", displayName: "CLB1 OUT14 input for ECAP1" },
	{ name: "ECAP_INPUT_ECAP2_CLB1_OUT14", displayName: "CLB1 OUT14 input for ECAP2" },
	{ name: "ECAP_INPUT_ECAP1_CLB1_OUT15", displayName: "CLB1 OUT15 input for ECAP1" },
	{ name: "ECAP_INPUT_ECAP2_CLB1_OUT15", displayName: "CLB1 OUT15 input for ECAP2" },
	{ name: "ECAP_INPUT_ECAP3_CLB2_OUT14", displayName: "CLB2 OUT14 input for ECAP3" },
	{ name: "ECAP_INPUT_ECAP4_CLB2_OUT14", displayName: "CLB2 OUT14 input for ECAP4" },
	{ name: "ECAP_INPUT_ECAP5_CLB2_OUT14", displayName: "CLB2 OUT14 input for ECAP5" },
	{ name: "ECAP_INPUT_ECAP3_CLB2_OUT15", displayName: "CLB2 OUT15 input for ECAP3" },
	{ name: "ECAP_INPUT_ECAP4_CLB2_OUT15", displayName: "CLB2 OUT15 input for ECAP4" },
	{ name: "ECAP_INPUT_ECAP5_CLB2_OUT15", displayName: "CLB2 OUT15 input for ECAP5" },
	{ name: "ECAP_INPUT_ECAP6_CLB3_OUT14", displayName: "CLB3 OUT14 input for ECAP6" },
	{ name: "ECAP_INPUT_ECAP6_CLB3_OUT15", displayName: "CLB3 OUT15 input for ECAP6" },
	{ name: "ECAP_INPUT_ECAP6_CLB4_OUT14", displayName: "CLB4 OUT14 input for ECAP6" },
	{ name: "ECAP_INPUT_ECAP6_CLB4_OUT15", displayName: "CLB4 OUT15 input for ECAP6" },
	{ name: "ECAP_INPUT_ECAP1_CLB5_OUT14", displayName: "CLB5 OUT14 input for ECAP1" },
	{ name: "ECAP_INPUT_ECAP2_CLB5_OUT14", displayName: "CLB5 OUT14 input for ECAP2" },
	{ name: "ECAP_INPUT_ECAP1_CLB5_OUT15", displayName: "CLB5 OUT15 input for ECAP1" },
	{ name: "ECAP_INPUT_ECAP2_CLB5_OUT15", displayName: "CLB5 OUT15 input for ECAP2" },
	{ name: "ECAP_INPUT_ECAP3_CLB6_OUT14", displayName: "CLB6 OUT14 input for ECAP3" },
	{ name: "ECAP_INPUT_ECAP4_CLB6_OUT14", displayName: "CLB6 OUT14 input for ECAP4" },
	{ name: "ECAP_INPUT_ECAP5_CLB6_OUT14", displayName: "CLB6 OUT14 input for ECAP5" },
	{ name: "ECAP_INPUT_ECAP3_CLB6_OUT15", displayName: "CLB6 OUT15 input for ECAP3" },
	{ name: "ECAP_INPUT_ECAP4_CLB6_OUT15", displayName: "CLB6 OUT15 input for ECAP4" },
	{ name: "ECAP_INPUT_ECAP5_CLB6_OUT15", displayName: "CLB6 OUT15 input for ECAP5" },
	{ name: "ECAP_INPUT_OUTPUTXBAR1", displayName: "Output Xbar Output-1" },
	{ name: "ECAP_INPUT_OUTPUTXBAR2", displayName: "Output Xbar Output-2" },
	{ name: "ECAP_INPUT_OUTPUTXBAR3", displayName: "Output Xbar Output-3" },
	{ name: "ECAP_INPUT_OUTPUTXBAR4", displayName: "Output Xbar Output-4" },
	{ name: "ECAP_INPUT_OUTPUTXBAR5", displayName: "Output Xbar Output-5" },
	{ name: "ECAP_INPUT_OUTPUTXBAR6", displayName: "Output Xbar Output-6" },
	{ name: "ECAP_INPUT_OUTPUTXBAR7", displayName: "Output Xbar Output-7" },
	{ name: "ECAP_INPUT_OUTPUTXBAR8", displayName: "Output Xbar Output-8" },
	{ name: "ECAP_INPUT_ADC_E_EVENT4", displayName: "ADCE Event4" },
	{ name: "ECAP_INPUT_ADC_E_EVENT3", displayName: "ADCE Event3" },
	{ name: "ECAP_INPUT_ADC_E_EVENT2", displayName: "ADCE Event2" },
	{ name: "ECAP_INPUT_ADC_E_EVENT1", displayName: "ADCE Event1" },
	{ name: "ECAP_INPUT_ADC_D_EVENT4", displayName: "ADCD Event4" },
	{ name: "ECAP_INPUT_ADC_D_EVENT3", displayName: "ADCD Event3" },
	{ name: "ECAP_INPUT_ADC_D_EVENT2", displayName: "ADCD Event2" },
	{ name: "ECAP_INPUT_ADC_D_EVENT1", displayName: "ADCD Event1" },
	{ name: "ECAP_INPUT_ADC_C_EVENT4", displayName: "ADCC Event4" },
	{ name: "ECAP_INPUT_ADC_C_EVENT3", displayName: "ADCC Event3" },
	{ name: "ECAP_INPUT_ADC_C_EVENT2", displayName: "ADCC Event2" },
	{ name: "ECAP_INPUT_ADC_C_EVENT1", displayName: "ADCC Event1" },
	{ name: "ECAP_INPUT_ADC_B_EVENT4", displayName: "ADCB Event4" },
	{ name: "ECAP_INPUT_ADC_B_EVENT3", displayName: "ADCB Event3" },
	{ name: "ECAP_INPUT_ADC_B_EVENT2", displayName: "ADCB Event2" },
	{ name: "ECAP_INPUT_ADC_B_EVENT1", displayName: "ADCB Event1" },
	{ name: "ECAP_INPUT_ADC_A_EVENT4", displayName: "ADCA Event4" },
	{ name: "ECAP_INPUT_ADC_A_EVENT3", displayName: "ADCA Event3" },
	{ name: "ECAP_INPUT_ADC_A_EVENT2", displayName: "ADCA Event2" },
	{ name: "ECAP_INPUT_ADC_A_EVENT1", displayName: "ADCA Event1" },
	{ name: "ECAP_INPUT_FSIA_RX_MSR_LINE", displayName: "FSIA Rx MSR Line" },
	{ name: "ECAP_INPUT_FSIA_RX_MSR_LINE_RISE", displayName: "FSIA Rx MSR Line Rise" },
	{ name: "ECAP_INPUT_FSIA_RX_MSR_LINE_FALL", displayName: "FSIA Rx MSR Line Fall" },
	{ name: "ECAP_INPUT_FSIB_RX_MSR_LINE", displayName: "FSIB Rx MSR Line" },
	{ name: "ECAP_INPUT_FSIB_RX_MSR_LINE_RISE", displayName: "FSIB Rx MSR Line Rise" },
	{ name: "ECAP_INPUT_FSIB_RX_MSR_LINE_FALL", displayName: "FSIB Rx MSR Line Fall" },
	{ name: "ECAP_INPUT_FSIC_RX_MSR_LINE", displayName: "FSIC Rx MSR Line" },
	{ name: "ECAP_INPUT_FSIC_RX_MSR_LINE_RISE", displayName: "FSIC Rx MSR Line Rise" },
	{ name: "ECAP_INPUT_FSIC_RX_MSR_LINE_FALL", displayName: "FSIC Rx MSR Line Fall" },
	{ name: "ECAP_INPUT_FSID_RX_MSR_LINE", displayName: "FSID Rx MSR Line" },
	{ name: "ECAP_INPUT_FSID_RX_MSR_LINE_RISE", displayName: "FSID Rx MSR Line Rise" },
	{ name: "ECAP_INPUT_FSID_RX_MSR_LINE_FALL", displayName: "FSID Rx MSR Line Fall" },
	{ name: "ECAP_INPUT_SDFM2_FLT1_COMPARE_LOW", displayName: "SDFM-2 Filter-1 Compare Low Trip" },
	{ name: "ECAP_INPUT_SDFM2_FLT2_COMPARE_LOW", displayName: "SDFM-2 Filter-2 Compare Low Trip" },
	{ name: "ECAP_INPUT_SDFM2_FLT3_COMPARE_LOW", displayName: "SDFM-2 Filter-3 Compare Low Trip" },
	{ name: "ECAP_INPUT_SDFM2_FLT4_COMPARE_LOW", displayName: "SDFM-2 Filter-4 Compare Low Trip" },
	{ name: "ECAP_INPUT_SDFM1_FLT1_COMPARE_LOW", displayName: "SDFM-1 Filter-1 Compare Low Trip" },
	{ name: "ECAP_INPUT_SDFM1_FLT2_COMPARE_LOW", displayName: "SDFM-1 Filter-2 Compare Low Trip" },
	{ name: "ECAP_INPUT_SDFM1_FLT3_COMPARE_LOW", displayName: "SDFM-1 Filter-3 Compare Low Trip" },
	{ name: "ECAP_INPUT_SDFM1_FLT4_COMPARE_LOW", displayName: "SDFM-1 Filter-4 Compare Low Trip" },
	{ name: "ECAP_INPUT_SDFM2_FLT1_COMPARE_Z", displayName: "SDFM-2 Filter-1 Compare Z Trip" },
	{ name: "ECAP_INPUT_SDFM2_FLT2_COMPARE_Z", displayName: "SDFM-2 Filter-2 Compare Low Trip" },
	{ name: "ECAP_INPUT_SDFM2_FLT3_COMPARE_Z", displayName: "SDFM-2 Filter-3 Compare Low Trip" },
	{ name: "ECAP_INPUT_SDFM2_FLT4_COMPARE_Z", displayName: "SDFM-2 Filter-4 Compare Low Trip" },
	{ name: "ECAP_INPUT_SDFM1_FLT1_COMPARE_Z", displayName: "SDFM-1 Filter-1 Compare Z Trip" },
	{ name: "ECAP_INPUT_SDFM1_FLT2_COMPARE_Z", displayName: "SDFM-1 Filter-2 Compare Low Trip" },
	{ name: "ECAP_INPUT_SDFM1_FLT3_COMPARE_Z", displayName: "SDFM-1 Filter-3 Compare Low Trip" },
	{ name: "ECAP_INPUT_SDFM1_FLT4_COMPARE_Z", displayName: "SDFM-1 Filter-4 Compare Low Trip" },
	{ name: "ECAP_INPUT_SDFM2_FLT1_COMPARE_HIGH", displayName: "SDFM-2 Filter-1 Compare High Trip" },
	{ name: "ECAP_INPUT_SDFM2_FLT2_COMPARE_HIGH", displayName: "SDFM-2 Filter-2 Compare High Trip" },
	{ name: "ECAP_INPUT_SDFM2_FLT3_COMPARE_HIGH", displayName: "SDFM-2 Filter-3 Compare High Trip" },
	{ name: "ECAP_INPUT_SDFM2_FLT4_COMPARE_HIGH", displayName: "SDFM-2 Filter-4 Compare High Trip" },
	{ name: "ECAP_INPUT_SDFM1_FLT1_COMPARE_HIGH", displayName: "SDFM-1 Filter-1 Compare High Trip" },
	{ name: "ECAP_INPUT_SDFM1_FLT2_COMPARE_HIGH", displayName: "SDFM-1 Filter-2 Compare High Trip" },
	{ name: "ECAP_INPUT_SDFM1_FLT3_COMPARE_HIGH", displayName: "SDFM-1 Filter-3 Compare High Trip" },
	{ name: "ECAP_INPUT_SDFM1_FLT4_COMPARE_HIGH", displayName: "SDFM-1 Filter-4 Compare High Trip" },
	{ name: "ECAP_INPUT_SDFM2_FLT1_COMPARE_HIGH_OR_LOW", displayName: "SDFM-2 Filter-1 Compare High Trip or Low Trip" },
	{ name: "ECAP_INPUT_SDFM2_FLT2_COMPARE_HIGH_OR_LOW", displayName: "SDFM-2 Filter-2 Compare High Trip or Low Trip" },
	{ name: "ECAP_INPUT_SDFM2_FLT3_COMPARE_HIGH_OR_LOW", displayName: "SDFM-2 Filter-3 Compare High Trip or Low Trip" },
	{ name: "ECAP_INPUT_SDFM2_FLT4_COMPARE_HIGH_OR_LOW", displayName: "SDFM-2 Filter-4 Compare High Trip or Low Trip" },
	{ name: "ECAP_INPUT_SDFM1_FLT1_COMPARE_HIGH_OR_LOW", displayName: "SDFM-1 Filter-1 Compare High Trip or Low Trip" },
	{ name: "ECAP_INPUT_SDFM1_FLT2_COMPARE_HIGH_OR_LOW", displayName: "SDFM-1 Filter-2 Compare High Trip or Low Trip" },
	{ name: "ECAP_INPUT_SDFM1_FLT3_COMPARE_HIGH_OR_LOW", displayName: "SDFM-1 Filter-3 Compare High Trip or Low Trip" },
	{ name: "ECAP_INPUT_SDFM1_FLT4_COMPARE_HIGH_OR_LOW", displayName: "SDFM-1 Filter-4 Compare High Trip or Low Trip" },
	{ name: "ECAP_INPUT_ECAP5_ECAP6_DELAY_CLK", displayName: "Delay clock for measurement" },
	{ name: "ECAP_INPUT_ECAP6_ECAP5_DELAY_CLK", displayName: "Delay clock for measurement" },
	{ name: "ECAP_INPUT_ECATSYNC0", displayName: "Ethercat Sync0" },
	{ name: "ECAP_INPUT_ECATSYNC1", displayName: "Ethercat Sync1" },
	{ name: "ECAP_INPUT_CMPSS1_CTRIP_LOW", displayName: "Compare Subsystem-1 Low Trip" },
	{ name: "ECAP_INPUT_CMPSS2_CTRIP_LOW", displayName: "Compare Subsystem-2 Low Trip" },
	{ name: "ECAP_INPUT_CMPSS3_CTRIP_LOW", displayName: "Compare Subsystem-3 Low Trip" },
	{ name: "ECAP_INPUT_CMPSS4_CTRIP_LOW", displayName: "Compare Subsystem-4 Low Trip" },
	{ name: "ECAP_INPUT_CMPSS5_CTRIP_LOW", displayName: "Compare Subsystem-5 Low Trip" },
	{ name: "ECAP_INPUT_CMPSS6_CTRIP_LOW", displayName: "Compare Subsystem-6 Low Trip" },
	{ name: "ECAP_INPUT_CMPSS7_CTRIP_LOW", displayName: "Compare Subsystem-7 Low Trip" },
	{ name: "ECAP_INPUT_CMPSS8_CTRIP_LOW", displayName: "Compare Subsystem-8 Low Trip" },
	{ name: "ECAP_INPUT_CMPSS1_CTRIP_HIGH", displayName: "Compare Subsystem-1 High Trip" },
	{ name: "ECAP_INPUT_CMPSS2_CTRIP_HIGH", displayName: "Compare Subsystem-2 High Trip" },
	{ name: "ECAP_INPUT_CMPSS3_CTRIP_HIGH", displayName: "Compare Subsystem-3 High Trip" },
	{ name: "ECAP_INPUT_CMPSS4_CTRIP_HIGH", displayName: "Compare Subsystem-4 High Trip" },
	{ name: "ECAP_INPUT_CMPSS5_CTRIP_HIGH", displayName: "Compare Subsystem-5 High Trip" },
	{ name: "ECAP_INPUT_CMPSS6_CTRIP_HIGH", displayName: "Compare Subsystem-6 High Trip" },
	{ name: "ECAP_INPUT_CMPSS7_CTRIP_HIGH", displayName: "Compare Subsystem-7 High Trip" },
	{ name: "ECAP_INPUT_CMPSS8_CTRIP_HIGH", displayName: "Compare Subsystem-8 High Trip" },
	{ name: "ECAP_INPUT_GPIO23", displayName: "GPIO23" },
	{ name: "ECAP_INPUT_CMPSS1_CTRIP_HIGH_OR_LOW", displayName: "Compare Subsystem-1 High Trip or Low Trip" },
	{ name: "ECAP_INPUT_CMPSS2_CTRIP_HIGH_OR_LOW", displayName: "Compare Subsystem-1 High Trip or Low Trip" },
	{ name: "ECAP_INPUT_CMPSS3_CTRIP_HIGH_OR_LOW", displayName: "Compare Subsystem-2 High Trip or Low Trip" },
	{ name: "ECAP_INPUT_CMPSS4_CTRIP_HIGH_OR_LOW", displayName: "Compare Subsystem-3 High Trip or Low Trip" },
	{ name: "ECAP_INPUT_CMPSS5_CTRIP_HIGH_OR_LOW", displayName: "Compare Subsystem-4 High Trip or Low Trip" },
	{ name: "ECAP_INPUT_CMPSS6_CTRIP_HIGH_OR_LOW", displayName: "Compare Subsystem-5 High Trip or Low Trip" },
	{ name: "ECAP_INPUT_CMPSS7_CTRIP_HIGH_OR_LOW", displayName: "Compare Subsystem-6 High Trip or Low Trip" },
	{ name: "ECAP_INPUT_CMPSS8_CTRIP_HIGH_OR_LOW", displayName: "Compare Subsystem-7 High Trip or Low Trip" },
	{ name: "ECAP_INPUT_ECAP1_INPUTXBAR7", displayName: "GPIO Input Crossbar output signal-7" },
	{ name: "ECAP_INPUT_ECAP2_INPUTXBAR8", displayName: "GPIO Input Crossbar output signal-8" },
	{ name: "ECAP_INPUT_ECAP3_INPUTXBAR9", displayName: "GPIO Input Crossbar output signal-9" },
	{ name: "ECAP_INPUT_ECAP4_INPUTXBAR10", displayName: "GPIO Input Crossbar output signal-10" },
	{ name: "ECAP_INPUT_ECAP5_INPUTXBAR11", displayName: "GPIO Input Crossbar output signal-11" },
	{ name: "ECAP_INPUT_ECAP6_INPUTXBAR12", displayName: "GPIO Input Crossbar output signal-12" },
	{ name: "ECAP_INPUT_SDFM4_FLT1_COMPARE_LOW", displayName: "SDFM-4 Filter-1 Compare Low Trip" },
	{ name: "ECAP_INPUT_SDFM4_FLT2_COMPARE_LOW", displayName: "SDFM-4 Filter-2 Compare Low Trip" },
	{ name: "ECAP_INPUT_SDFM4_FLT3_COMPARE_LOW", displayName: "SDFM-4 Filter-3 Compare Low Trip" },
	{ name: "ECAP_INPUT_SDFM4_FLT4_COMPARE_LOW", displayName: "SDFM-4 Filter-4 Compare Low Trip" },
	{ name: "ECAP_INPUT_SDFM3_FLT1_COMPARE_LOW", displayName: "SDFM-3 Filter-1 Compare Low Trip" },
	{ name: "ECAP_INPUT_SDFM3_FLT2_COMPARE_LOW", displayName: "SDFM-3 Filter-2 Compare Low Trip" },
	{ name: "ECAP_INPUT_SDFM3_FLT3_COMPARE_LOW", displayName: "SDFM-3 Filter-3 Compare Low Trip" },
	{ name: "ECAP_INPUT_SDFM3_FLT4_COMPARE_LOW", displayName: "SDFM-3 Filter-4 Compare Low Trip" },
	{ name: "ECAP_INPUT_SDFM4_FLT4_COMPARE_Z", displayName: "SDFM-4 Filter-4 Compare Z Trip" },
	{ name: "ECAP_INPUT_SDFM3_FLT4_COMPARE_Z", displayName: "SDFM-3 Filter-4 Compare Z Trip" },
	{ name: "ECAP_INPUT_SDFM4_FLT1_COMPARE_HIGH", displayName: "SDFM-4 Filter-1 Compare High Trip" },
	{ name: "ECAP_INPUT_SDFM4_FLT2_COMPARE_HIGH", displayName: "SDFM-4 Filter-2 Compare High Trip" },
	{ name: "ECAP_INPUT_SDFM4_FLT3_COMPARE_HIGH", displayName: "SDFM-4 Filter-3 Compare High Trip" },
	{ name: "ECAP_INPUT_SDFM4_FLT4_COMPARE_HIGH", displayName: "SDFM-4 Filter-4 Compare High Trip" },
	{ name: "ECAP_INPUT_SDFM3_FLT1_COMPARE_HIGH", displayName: "SDFM-3 Filter-1 Compare High Trip" },
	{ name: "ECAP_INPUT_SDFM3_FLT2_COMPARE_HIGH", displayName: "SDFM-3 Filter-2 Compare High Trip" },
	{ name: "ECAP_INPUT_SDFM3_FLT3_COMPARE_HIGH", displayName: "SDFM-3 Filter-3 Compare High Trip" },
	{ name: "ECAP_INPUT_SDFM3_FLT4_COMPARE_HIGH", displayName: "SDFM-3 Filter-4 Compare High Trip" },
	{ name: "ECAP_INPUT_SDFM4_FLT1_COMPARE_HIGH_OR_LOW", displayName: "SDFM-4 Filter-1 Compare High Trip or Low Trip" },
	{ name: "ECAP_INPUT_SDFM4_FLT2_COMPARE_HIGH_OR_LOW", displayName: "SDFM-4 Filter-2 Compare High Trip or Low Trip" },
	{ name: "ECAP_INPUT_SDFM4_FLT3_COMPARE_HIGH_OR_LOW", displayName: "SDFM-4 Filter-3 Compare High Trip or Low Trip" },
	{ name: "ECAP_INPUT_SDFM4_FLT4_COMPARE_HIGH_OR_LOW", displayName: "SDFM-4 Filter-4 Compare High Trip or Low Trip" },
	{ name: "ECAP_INPUT_SDFM3_FLT1_COMPARE_HIGH_OR_LOW", displayName: "SDFM-3 Filter-1 Compare High Trip or Low Trip" },
	{ name: "ECAP_INPUT_SDFM3_FLT2_COMPARE_HIGH_OR_LOW", displayName: "SDFM-3 Filter-2 Compare High Trip or Low Trip" },
	{ name: "ECAP_INPUT_SDFM3_FLT3_COMPARE_HIGH_OR_LOW", displayName: "SDFM-3 Filter-3 Compare High Trip or Low Trip" },
	{ name: "ECAP_INPUT_SDFM3_FLT4_COMPARE_HIGH_OR_LOW", displayName: "SDFM-3 Filter-4 Compare High Trip or Low Trip" },
	{ name: "ECAP_INPUT_EPWM18_DEL_ACTIVE", displayName: "EPWM-18 Diode Emulation Logic Active" },
	{ name: "ECAP_INPUT_EPWM17_DEL_ACTIVE", displayName: "EPWM-17 Diode Emulation Logic Active" },
	{ name: "ECAP_INPUT_EPWM16_DEL_ACTIVE", displayName: "EPWM-16 Diode Emulation Logic Active" },
	{ name: "ECAP_INPUT_EPWM15_DEL_ACTIVE", displayName: "EPWM-15 Diode Emulation Logic Active" },
	{ name: "ECAP_INPUT_EPWM14_DEL_ACTIVE", displayName: "EPWM-14 Diode Emulation Logic Active" },
	{ name: "ECAP_INPUT_EPWM13_DEL_ACTIVE", displayName: "EPWM-13 Diode Emulation Logic Active" },
	{ name: "ECAP_INPUT_EPWM12_DEL_ACTIVE", displayName: "EPWM-12 Diode Emulation Logic Active" },
	{ name: "ECAP_INPUT_EPWM11_DEL_ACTIVE", displayName: "EPWM-11 Diode Emulation Logic Active" },
	{ name: "ECAP_INPUT_EPWM10_DEL_ACTIVE", displayName: "EPWM-10 Diode Emulation Logic Active" },
	{ name: "ECAP_INPUT_EPWM9_DEL_ACTIVE", displayName: "EPWM-9 Diode Emulation Logic Active" },
	{ name: "ECAP_INPUT_EPWM8_DEL_ACTIVE", displayName: "EPWM-8 Diode Emulation Logic Active" },
	{ name: "ECAP_INPUT_EPWM7_DEL_ACTIVE", displayName: "EPWM-7 Diode Emulation Logic Active" },
	{ name: "ECAP_INPUT_EPWM6_DEL_ACTIVE", displayName: "EPWM-6 Diode Emulation Logic Active" },
	{ name: "ECAP_INPUT_EPWM5_DEL_ACTIVE", displayName: "EPWM-5 Diode Emulation Logic Active" },
	{ name: "ECAP_INPUT_EPWM4_DEL_ACTIVE", displayName: "EPWM-4 Diode Emulation Logic Active" },
	{ name: "ECAP_INPUT_EPWM3_DEL_ACTIVE", displayName: "EPWM-3 Diode Emulation Logic Active" },
	{ name: "ECAP_INPUT_EPWM2_DEL_ACTIVE", displayName: "EPWM-2 Diode Emulation Logic Active" },
	{ name: "ECAP_INPUT_EPWM1_DEL_ACTIVE", displayName: "EPWM-1 Diode Emulation Logic Active" },
	{ name: "ECAP_INPUT_ECAP1_EPG1_DATAOUT49", displayName: "EPG-1 Data Output-49 Connection" },
	{ name: "ECAP_INPUT_ECAP2_EPG1_DATAOUT50", displayName: "EPG-1 Data Output-50 Connection" },
	{ name: "ECAP_INPUT_ECAP3_EPG1_DATAOUT51", displayName: "EPG-1 Data Output-51 Connection" },
	{ name: "ECAP_INPUT_ECAP4_EPG1_DATAOUT52", displayName: "EPG-1 Data Output-52 Connection" },
	{ name: "ECAP_INPUT_ECAP5_EPG1_DATAOUT53", displayName: "EPG-1 Data Output-53 Connection" },
	{ name: "ECAP_INPUT_ECAP6_EPG1_DATAOUT54", displayName: "EPG-1 Data Output-54 Connection" },
]
let ECAP_QualPeriodSelect = [
	{ name: "ECAP_PULSE_WIDTH_FILTER_BYPASS", displayName: "Bypass" },
	{ name: "ECAP_PULSE_WIDTH_FILTER_CYCLE1", displayName: "Pulse width less than 1 cycle" },
	{ name: "ECAP_PULSE_WIDTH_FILTER_CYCLE2", displayName: "Pulse width less than 2 cycles" },
	{ name: "ECAP_PULSE_WIDTH_FILTER_CYCLE3", displayName: "Pulse width less than 3 cycles" },
	{ name: "ECAP_PULSE_WIDTH_FILTER_CYCLE4", displayName: "Pulse width less than 4 cycles" },
	{ name: "ECAP_PULSE_WIDTH_FILTER_CYCLE5", displayName: "Pulse width less than 5 cycles" },
	{ name: "ECAP_PULSE_WIDTH_FILTER_CYCLE6", displayName: "Pulse width less than 6 cycles" },
	{ name: "ECAP_PULSE_WIDTH_FILTER_CYCLE7", displayName: "Pulse width less than 7 cycles" },
	{ name: "ECAP_PULSE_WIDTH_FILTER_CYCLE8", displayName: "Pulse width less than 8 cycles" },
	{ name: "ECAP_PULSE_WIDTH_FILTER_CYCLE9", displayName: "Pulse width less than 9 cycles" },
	{ name: "ECAP_PULSE_WIDTH_FILTER_CYCLE10", displayName: "Pulse width less than 10 cycles" },
	{ name: "ECAP_PULSE_WIDTH_FILTER_CYCLE11", displayName: "Pulse width less than 11 cycles" },
	{ name: "ECAP_PULSE_WIDTH_FILTER_CYCLE12", displayName: "Pulse width less than 12 cycles" },
	{ name: "ECAP_PULSE_WIDTH_FILTER_CYCLE13", displayName: "Pulse width less than 13 cycles" },
	{ name: "ECAP_PULSE_WIDTH_FILTER_CYCLE14", displayName: "Pulse width less than 14 cycles" },
	{ name: "ECAP_PULSE_WIDTH_FILTER_CYCLE15", displayName: "Pulse width less than 15 cycles" },
]
let ECAP_SyncInPulseSource = [
	{ name: "ECAP_SYNC_IN_PULSE_SRC_DISABLE", displayName: "Disable Sync-in" },
	{ name: "ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM1", displayName: "Sync-in source is EPWM1 sync-out signal" },
	{ name: "ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM2", displayName: "Sync-in source is EPWM2 sync-out signal" },
	{ name: "ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM3", displayName: "Sync-in source is EPWM3 sync-out signal" },
	{ name: "ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM4", displayName: "Sync-in source is EPWM4 sync-out signal" },
	{ name: "ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM5", displayName: "Sync-in source is EPWM5 sync-out signal" },
	{ name: "ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM6", displayName: "Sync-in source is EPWM6 sync-out signal" },
	{ name: "ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM7", displayName: "Sync-in source is EPWM7 sync-out signal" },
	{ name: "ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM8", displayName: "Sync-in source is EPWM8 sync-out signal" },
	{ name: "ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM9", displayName: "Sync-in source is EPWM9 sync-out signal" },
	{ name: "ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM10", displayName: "Sync-in source is EPWM10 sync-out signal" },
	{ name: "ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM11", displayName: "Sync-in source is EPWM11 sync-out signal" },
	{ name: "ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM12", displayName: "Sync-in source is EPWM12 sync-out signal" },
	{ name: "ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM13", displayName: "Sync-in source is EPWM13 sync-out signal" },
	{ name: "ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM14", displayName: "Sync-in source is EPWM14 sync-out signal" },
	{ name: "ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM15", displayName: "Sync-in source is EPWM15 sync-out signal" },
	{ name: "ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM16", displayName: "Sync-in source is EPWM16 sync-out signal" },
	{ name: "ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_ECAP1", displayName: "Sync-in source is ECAP1 sync-out signal" },
	{ name: "ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_ECAP2", displayName: "Sync-in source is ECAP2 sync-out signal" },
	{ name: "ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_ECAP3", displayName: "Sync-in source is ECAP3 sync-out signal" },
	{ name: "ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_ECAP4", displayName: "Sync-in source is ECAP4 sync-out signal" },
	{ name: "ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_ECAP5", displayName: "Sync-in source is ECAP5 sync-out signal" },
	{ name: "ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_ECAP6", displayName: "Sync-in source is ECAP6 sync-out signal" },
	{ name: "ECAP_SYNC_IN_PULSE_SRC_INPUTXBAR_OUT5", displayName: "Sync-in source is Input XBAR out5 signal" },
	{ name: "ECAP_SYNC_IN_PULSE_SRC_INPUTXBAR_OUT6", displayName: "Sync-in source is Input XBAR out6 signal" },
	{ name: "ECAP_SYNC_IN_PULSE_SRC_ETHERCAT_SYNC0", displayName: "Sync-in source is Ethercat sync0 signal" },
	{ name: "ECAP_SYNC_IN_PULSE_SRC_ETHERCAT_SYNC1", displayName: "Sync-in source is Ethercat sync1 signal" },
	{ name: "ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM17", displayName: "Sync-in source is EPWM17 sync-out signal" },
	{ name: "ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM18", displayName: "Sync-in source is EPWM18 sync-out signal" },
	{ name: "ECAP_SYNC_IN_PULSE_SRC_FSIRXA_RX_TRIG1", displayName: "Sync-in source is FSI RXA RX signal" },
	{ name: "ECAP_SYNC_IN_PULSE_SRC_FSIRXB_RX_TRIG1", displayName: "Sync-in source is FSI RXB RX signal" },
	{ name: "ECAP_SYNC_IN_PULSE_SRC_FSIRXC_RX_TRIG1", displayName: "Sync-in source is FSI RXC RX signal" },
	{ name: "ECAP_SYNC_IN_PULSE_SRC_FSIRXD_RX_TRIG1", displayName: "Sync-in source is FSI RXD RX signal" },
]
let ECAP_MonitoringTypeSelect = [
	{ name: "ECAP_MUNIT_HIGH_PULSE_WIDTH", displayName: "High Pulse Width" },
	{ name: "ECAP_MUNIT_LOW_PULSE_WIDTH", displayName: "Low Pulse Width" },
	{ name: "ECAP_MUNIT_PERIOD_WIDTH_RISE_RISE", displayName: "Period width from rise to rise" },
	{ name: "ECAP_MUNIT_PERIOD_WIDTH_FALL_FALL", displayName: "Period width from fall to fall" },
	{ name: "ECAP_MUNIT_MONITOR_RISE_EDGE", displayName: "Monitor rise edge" },
	{ name: "ECAP_MUNIT_MONITOR_FALL_EDGE", displayName: "Monitor fall edge" },
]
let ECAP_MunitTripInputSelect = [
	{ name: "ECAP_MUNIT_TRIP_DISABLED", displayName: "Disabled" },
	{ name: "ECAP_MUNIT_TRIP_EPWM_XBARA_OUT0", displayName: "MUNIT trip source is PWMXBAR-A output 0" },
	{ name: "ECAP_MUNIT_TRIP_EPWM_XBARA_OUT1", displayName: "MUNIT trip source is PWMXBAR-A output 1" },
	{ name: "ECAP_MUNIT_TRIP_EPWM_XBARA_OUT2", displayName: "MUNIT trip source is PWMXBAR-A output 2" },
	{ name: "ECAP_MUNIT_TRIP_EPWM_XBARA_OUT3", displayName: "MUNIT trip source is PWMXBAR-A output 3" },
	{ name: "ECAP_MUNIT_TRIP_EPWM_XBARA_OUT4", displayName: "MUNIT trip source is PWMXBAR-A output 4" },
	{ name: "ECAP_MUNIT_TRIP_EPWM_XBARA_OUT5", displayName: "MUNIT trip source is PWMXBAR-A output 5" },
	{ name: "ECAP_MUNIT_TRIP_EPWM_XBARA_OUT6", displayName: "MUNIT trip source is PWMXBAR-A output 6" },
	{ name: "ECAP_MUNIT_TRIP_EPWM_XBARA_OUT7", displayName: "MUNIT trip source is PWMXBAR-A output 7" },
	{ name: "ECAP_MUNIT_TRIP_EPWM_XBARB_OUT0", displayName: "MUNIT trip source is PWMXBAR-B output 0" },
	{ name: "ECAP_MUNIT_TRIP_EPWM_XBARB_OUT1", displayName: "MUNIT trip source is PWMXBAR-B output 1" },
	{ name: "ECAP_MUNIT_TRIP_EPWM_XBARB_OUT2", displayName: "MUNIT trip source is PWMXBAR-B output 2" },
	{ name: "ECAP_MUNIT_TRIP_EPWM_XBARB_OUT3", displayName: "MUNIT trip source is PWMXBAR-B output 3" },
	{ name: "ECAP_MUNIT_TRIP_EPWM_XBARB_OUT4", displayName: "MUNIT trip source is PWMXBAR-B output 4" },
	{ name: "ECAP_MUNIT_TRIP_EPWM_XBARB_OUT5", displayName: "MUNIT trip source is PWMXBAR-B output 5" },
	{ name: "ECAP_MUNIT_TRIP_EPWM_XBARB_OUT6", displayName: "MUNIT trip source is PWMXBAR-B output 6" },
	{ name: "ECAP_MUNIT_TRIP_EPWM_XBARB_OUT7", displayName: "MUNIT trip source is PWMXBAR-B output 7" },
	{ name: "ECAP_MUNIT_TRIP_EPWM1_TRIPOUT", displayName: "MUNIT trip source is EPWM1 trip out signal" },
	{ name: "ECAP_MUNIT_TRIP_EPWM2_TRIPOUT", displayName: "MUNIT trip source is EPWM2 trip out signal" },
	{ name: "ECAP_MUNIT_TRIP_EPWM3_TRIPOUT", displayName: "MUNIT trip source is EPWM3 trip out signal" },
	{ name: "ECAP_MUNIT_TRIP_EPWM4_TRIPOUT", displayName: "MUNIT trip source is EPWM4 trip out signal" },
	{ name: "ECAP_MUNIT_TRIP_EPWM5_TRIPOUT", displayName: "MUNIT trip source is EPWM5 trip out signal" },
	{ name: "ECAP_MUNIT_TRIP_EPWM6_TRIPOUT", displayName: "MUNIT trip source is EPWM6 trip out signal" },
	{ name: "ECAP_MUNIT_TRIP_EPWM7_TRIPOUT", displayName: "MUNIT trip source is EPWM7 trip out signal" },
	{ name: "ECAP_MUNIT_TRIP_EPWM8_TRIPOUT", displayName: "MUNIT trip source is EPWM8 trip out signal" },
	{ name: "ECAP_MUNIT_TRIP_EPWM9_TRIPOUT", displayName: "MUNIT trip source is EPWM9 trip out signal" },
	{ name: "ECAP_MUNIT_TRIP_EPWM10_TRIPOUT", displayName: "MUNIT trip source is EPWM10 trip out signal" },
	{ name: "ECAP_MUNIT_TRIP_EPWM11_TRIPOUT", displayName: "MUNIT trip source is EPWM11 trip out signal" },
	{ name: "ECAP_MUNIT_TRIP_EPWM12_TRIPOUT", displayName: "MUNIT trip source is EPWM12 trip out signal" },
	{ name: "ECAP_MUNIT_TRIP_EPWM13_TRIPOUT", displayName: "MUNIT trip source is EPWM13 trip out signal" },
	{ name: "ECAP_MUNIT_TRIP_EPWM14_TRIPOUT", displayName: "MUNIT trip source is EPWM14 trip out signal" },
	{ name: "ECAP_MUNIT_TRIP_EPWM15_TRIPOUT", displayName: "MUNIT trip source is EPWM15 trip out signal" },
	{ name: "ECAP_MUNIT_TRIP_EPWM16_TRIPOUT", displayName: "MUNIT trip source is EPWM16 trip out signal" },
	{ name: "ECAP_MUNIT_TRIP_EPWM17_TRIPOUT", displayName: "MUNIT trip source is EPWM17 trip out signal" },
	{ name: "ECAP_MUNIT_TRIP_EPWM18_TRIPOUT", displayName: "MUNIT trip source is EPWM18 trip out signal" },
]
let ECAP_MUNIT_STEP = [
	{ name: "ECAP_MUNIT_STEP", displayName: "STEP" },
]
let ECAP_MAX_PRESCALER_VALUE = [
	{ name: "ECAP_MAX_PRESCALER_VALUE", displayName: "Maximum Pre-scaler value" },
]
let ECAP_ISR_SOURCE = [
	{ name: "ECAP_ISR_SOURCE_CAPTURE_EVENT_1", displayName: "Event 1 ISR source" },
	{ name: "ECAP_ISR_SOURCE_CAPTURE_EVENT_2", displayName: "Event 2 ISR source" },
	{ name: "ECAP_ISR_SOURCE_CAPTURE_EVENT_3", displayName: "Event 3 ISR source" },
	{ name: "ECAP_ISR_SOURCE_CAPTURE_EVENT_4", displayName: "Event 4 ISR source" },
	{ name: "ECAP_ISR_SOURCE_COUNTER_OVERFLOW", displayName: "Counter overflow ISR source" },
	{ name: "ECAP_ISR_SOURCE_COUNTER_PERIOD", displayName: "Counter equals period ISR source" },
	{ name: "ECAP_ISR_SOURCE_COUNTER_COMPARE", displayName: "Counter equals compare ISR source" },
	{ name: "ECAP_ISR_SOURCE_MUNIT_1_ERROR_EVT1", displayName: "Monitoring unit 1 error event 1 ISR source" },
	{ name: "ECAP_ISR_SOURCE_MUNIT_1_ERROR_EVT2", displayName: "Monitoring unit 1 error event 2 ISR source" },
	{ name: "ECAP_ISR_SOURCE_MUNIT_2_ERROR_EVT1", displayName: "Monitoring unit 2 error event 1 ISR source" },
	{ name: "ECAP_ISR_SOURCE_MUNIT_2_ERROR_EVT2", displayName: "Monitoring unit 2 error event 2 ISR source" },
]
let ECAP_MONITORING_UNIT = [
	{ name: "ECAP_MONITORING_UNIT_1", displayName: "ECAP Monitoring Unit 1" },
	{ name: "ECAP_MONITORING_UNIT_2", displayName: "ECAP Monitoring Unit 2" },
]
let ECAP_ACTIVE_LOAD = [
	{ name: "ECAP_ACTIVE_LOAD_SYNC_EVT", displayName: "Load on next sync event" },
	{ name: "ECAP_ACTIVE_LOAD_GLDLCSTRB_EVT", displayName: "Load on EPWM GLDLCSTRB event" },
]
module.exports = {
	ECAP_EmulationMode: ECAP_EmulationMode,
	ECAP_CaptureMode: ECAP_CaptureMode,
	ECAP_Events: ECAP_Events,
	ECAP_SyncOutMode: ECAP_SyncOutMode,
	ECAP_APWMPolarity: ECAP_APWMPolarity,
	ECAP_EventPolarity: ECAP_EventPolarity,
	ECAP_InputCaptureSignals: ECAP_InputCaptureSignals,
	ECAP_QualPeriodSelect: ECAP_QualPeriodSelect,
	ECAP_SyncInPulseSource: ECAP_SyncInPulseSource,
	ECAP_MonitoringTypeSelect: ECAP_MonitoringTypeSelect,
	ECAP_MunitTripInputSelect: ECAP_MunitTripInputSelect,
	ECAP_MUNIT_STEP: ECAP_MUNIT_STEP,
	ECAP_MAX_PRESCALER_VALUE: ECAP_MAX_PRESCALER_VALUE,
	ECAP_ISR_SOURCE: ECAP_ISR_SOURCE,
	ECAP_MONITORING_UNIT: ECAP_MONITORING_UNIT,
	ECAP_ACTIVE_LOAD: ECAP_ACTIVE_LOAD,
}
