let ADC_ClkPrescale = [
	{ name: "ADC_CLK_DIV_1_0", displayName: "1.0" },
	{ name: "ADC_CLK_DIV_2_0", displayName: "2.0" },
	{ name: "ADC_CLK_DIV_2_5", displayName: "2.5" },
	{ name: "ADC_CLK_DIV_3_0", displayName: "3.0" },
	{ name: "ADC_CLK_DIV_3_5", displayName: "3.5" },
	{ name: "ADC_CLK_DIV_4_0", displayName: "4.0" },
	{ name: "ADC_CLK_DIV_4_5", displayName: "4.5" },
	{ name: "ADC_CLK_DIV_5_0", displayName: "5.0" },
	{ name: "ADC_CLK_DIV_5_5", displayName: "5.5" },
	{ name: "ADC_CLK_DIV_6_0", displayName: "6.0" },
	{ name: "ADC_CLK_DIV_6_5", displayName: "6.5" },
	{ name: "ADC_CLK_DIV_7_0", displayName: "7.0" },
	{ name: "ADC_CLK_DIV_7_5", displayName: "7.5" },
	{ name: "ADC_CLK_DIV_8_0", displayName: "8.0" },
	{ name: "ADC_CLK_DIV_8_5", displayName: "8.5" },
]
let ADC_Resolution = [
	{ name: "ADC_RESOLUTION_12BIT", displayName: "12-bit conversion resolution" },
	{ name: "ADC_RESOLUTION_16BIT", displayName: "16-bit conversion resolution" },
]
let ADC_SignalMode = [
	{ name: "ADC_MODE_SINGLE_ENDED", displayName: "Sample on single pin with VREFLO" },
	{ name: "ADC_MODE_DIFFERENTIAL", displayName: "Sample on pair of pins" },
]
let ADC_Trigger = [
	{ name: "ADC_TRIGGER_SW_ONLY", displayName: "Software only" },
	{ name: "ADC_TRIGGER_CPU1_TINT0", displayName: "CPU1 Timer 0, TINT0" },
	{ name: "ADC_TRIGGER_CPU1_TINT1", displayName: "CPU1 Timer 1, TINT1" },
	{ name: "ADC_TRIGGER_CPU1_TINT2", displayName: "CPU1 Timer 2, TINT2" },
	{ name: "ADC_TRIGGER_GPIO", displayName: "GPIO, ADCEXTSOC" },
	{ name: "ADC_TRIGGER_EPWM1_SOCA", displayName: "ePWM1, ADCSOCA" },
	{ name: "ADC_TRIGGER_EPWM1_SOCB", displayName: "ePWM1, ADCSOCB" },
	{ name: "ADC_TRIGGER_EPWM2_SOCA", displayName: "ePWM2, ADCSOCA" },
	{ name: "ADC_TRIGGER_EPWM2_SOCB", displayName: "ePWM2, ADCSOCB" },
	{ name: "ADC_TRIGGER_EPWM3_SOCA", displayName: "ePWM3, ADCSOCA" },
	{ name: "ADC_TRIGGER_EPWM3_SOCB", displayName: "ePWM3, ADCSOCB" },
	{ name: "ADC_TRIGGER_EPWM4_SOCA", displayName: "ePWM4, ADCSOCA" },
	{ name: "ADC_TRIGGER_EPWM4_SOCB", displayName: "ePWM4, ADCSOCB" },
	{ name: "ADC_TRIGGER_EPWM5_SOCA", displayName: "ePWM5, ADCSOCA" },
	{ name: "ADC_TRIGGER_EPWM5_SOCB", displayName: "ePWM5, ADCSOCB" },
	{ name: "ADC_TRIGGER_EPWM6_SOCA", displayName: "ePWM6, ADCSOCA" },
	{ name: "ADC_TRIGGER_EPWM6_SOCB", displayName: "ePWM6, ADCSOCB" },
	{ name: "ADC_TRIGGER_EPWM7_SOCA", displayName: "ePWM7, ADCSOCA" },
	{ name: "ADC_TRIGGER_EPWM7_SOCB", displayName: "ePWM7, ADCSOCB" },
	{ name: "ADC_TRIGGER_EPWM8_SOCA", displayName: "ePWM8, ADCSOCA" },
	{ name: "ADC_TRIGGER_EPWM8_SOCB", displayName: "ePWM8, ADCSOCB" },
	{ name: "ADC_TRIGGER_EPWM9_SOCA", displayName: "ePWM9, ADCSOCA" },
	{ name: "ADC_TRIGGER_EPWM9_SOCB", displayName: "ePWM9, ADCSOCB" },
	{ name: "ADC_TRIGGER_EPWM10_SOCA", displayName: "ePWM10, ADCSOCA" },
	{ name: "ADC_TRIGGER_EPWM10_SOCB", displayName: "ePWM10, ADCSOCB" },
	{ name: "ADC_TRIGGER_EPWM11_SOCA", displayName: "ePWM11, ADCSOCA" },
	{ name: "ADC_TRIGGER_EPWM11_SOCB", displayName: "ePWM11, ADCSOCB" },
	{ name: "ADC_TRIGGER_EPWM12_SOCA", displayName: "ePWM12, ADCSOCA" },
	{ name: "ADC_TRIGGER_EPWM12_SOCB", displayName: "ePWM12, ADCSOCB" },
	{ name: "ADC_TRIGGER_REPEATER1", displayName: "Repeater 1" },
	{ name: "ADC_TRIGGER_REPEATER2", displayName: "Repeater 2" },
	{ name: "ADC_TRIGGER_CLB1_OUT27", displayName: "TRIGGER CLB1 OUT27" },
	{ name: "ADC_TRIGGER_CLB2_OUT27", displayName: "TRIGGER CLB2 OUT27" },
	{ name: "ADC_TRIGGER_CLB3_OUT27", displayName: "TRIGGER CLB3 OUT27" },
	{ name: "ADC_TRIGGER_CLB4_OUT27", displayName: "TRIGGER CLB4 OUT27" },
	{ name: "ADC_TRIGGER_CLB5_OUT27", displayName: "TRIGGER CLB5 OUT27" },
	{ name: "ADC_TRIGGER_CLB6_OUT27", displayName: "TRIGGER CLB6 OUT27" },
	{ name: "ADC_TRIGGER_ECAP1", displayName: "eCAP1" },
	{ name: "ADC_TRIGGER_ECAP2", displayName: "eCAP2" },
	{ name: "ADC_TRIGGER_ECAP3", displayName: "eCAP3" },
	{ name: "ADC_TRIGGER_ECAP4", displayName: "eCAP4" },
	{ name: "ADC_TRIGGER_ECAP5", displayName: "eCAP5" },
	{ name: "ADC_TRIGGER_ECAP6", displayName: "eCAP6" },
	{ name: "ADC_TRIGGER_EPWM13_SOCA", displayName: "ePWM13, ADCSOCA" },
	{ name: "ADC_TRIGGER_EPWM13_SOCB", displayName: "ePWM13, ADCSOCB" },
	{ name: "ADC_TRIGGER_EPWM14_SOCA", displayName: "ePWM14, ADCSOCA" },
	{ name: "ADC_TRIGGER_EPWM14_SOCB", displayName: "ePWM14, ADCSOCB" },
	{ name: "ADC_TRIGGER_EPWM15_SOCA", displayName: "ePWM15, ADCSOCA" },
	{ name: "ADC_TRIGGER_EPWM15_SOCB", displayName: "ePWM15, ADCSOCB" },
	{ name: "ADC_TRIGGER_EPWM16_SOCA", displayName: "ePWM16, ADCSOCA" },
	{ name: "ADC_TRIGGER_EPWM16_SOCB", displayName: "ePWM16, ADCSOCB" },
	{ name: "ADC_TRIGGER_EPWM17_SOCA", displayName: "ePWM17, ADCSOCA" },
	{ name: "ADC_TRIGGER_EPWM17_SOCB", displayName: "ePWM17, ADCSOCB" },
	{ name: "ADC_TRIGGER_EPWM18_SOCA", displayName: "ePWM18, ADCSOCA" },
	{ name: "ADC_TRIGGER_EPWM18_SOCB", displayName: "ePWM18, ADCSOCB" },
	{ name: "ADC_TRIGGER_CPU2_TINT0", displayName: "CPU2 Timer 0, TINT0" },
	{ name: "ADC_TRIGGER_CPU2_TINT1", displayName: "CPU2 Timer 1, TINT1" },
	{ name: "ADC_TRIGGER_CPU2_TINT2", displayName: "CPU2 Timer 2, TINT2" },
	{ name: "ADC_TRIGGER_CPU3_TINT0", displayName: "TRIGGER CPU3 TINT0" },
	{ name: "ADC_TRIGGER_CPU3_TINT1", displayName: "TRIGGER CPU3 TINT1" },
	{ name: "ADC_TRIGGER_CPU3_TINT2", displayName: "TRIGGER CPU3 TINT2" },
]
let ADC_Channel = [
	{ name: "ADC_CH_ADCIN0", displayName: "single-ended, ADCIN0" },
	{ name: "ADC_CH_ADCIN1", displayName: "single-ended, ADCIN1" },
	{ name: "ADC_CH_ADCIN2", displayName: "single-ended, ADCIN2" },
	{ name: "ADC_CH_ADCIN3", displayName: "single-ended, ADCIN3" },
	{ name: "ADC_CH_ADCIN4", displayName: "single-ended, ADCIN4" },
	{ name: "ADC_CH_ADCIN5", displayName: "single-ended, ADCIN5" },
	{ name: "ADC_CH_ADCIN6", displayName: "single-ended, ADCIN6" },
	{ name: "ADC_CH_ADCIN7", displayName: "single-ended, ADCIN7" },
	{ name: "ADC_CH_ADCIN8", displayName: "single-ended, ADCIN8" },
	{ name: "ADC_CH_ADCIN9", displayName: "single-ended, ADCIN9" },
	{ name: "ADC_CH_ADCIN10", displayName: "single-ended, ADCIN10" },
	{ name: "ADC_CH_ADCIN11", displayName: "single-ended, ADCIN11" },
	{ name: "ADC_CH_ADCIN12", displayName: "single-ended, ADCIN12" },
	{ name: "ADC_CH_ADCIN13", displayName: "single-ended, ADCIN13" },
	{ name: "ADC_CH_ADCIN14", displayName: "single-ended, ADCIN14" },
	{ name: "ADC_CH_ADCIN15", displayName: "single-ended, ADCIN15" },
	{ name: "ADC_CH_ADCIN16", displayName: "single-ended, ADCIN16" },
	{ name: "ADC_CH_ADCIN17", displayName: "single-ended, ADCIN17" },
	{ name: "ADC_CH_ADCIN18", displayName: "single-ended, ADCIN18" },
	{ name: "ADC_CH_ADCIN19", displayName: "single-ended, ADCIN19" },
	{ name: "ADC_CH_ADCIN20", displayName: "single-ended, ADCIN20" },
	{ name: "ADC_CH_ADCIN21", displayName: "single-ended, ADCIN21" },
	{ name: "ADC_CH_ADCIN22", displayName: "single-ended, ADCIN22" },
	{ name: "ADC_CH_ADCIN23", displayName: "single-ended, ADCIN23" },
	{ name: "ADC_CH_ADCIN24", displayName: "single-ended, ADCIN24" },
	{ name: "ADC_CH_ADCIN25", displayName: "single-ended, ADCIN25" },
	{ name: "ADC_CH_ADCIN26", displayName: "single-ended, ADCIN26" },
	{ name: "ADC_CH_ADCIN27", displayName: "single-ended, ADCIN27" },
	{ name: "ADC_CH_ADCIN28", displayName: "single-ended, ADCIN28" },
	{ name: "ADC_CH_ADCIN29", displayName: "single-ended, ADCIN29" },
	{ name: "ADC_CH_ADCIN30", displayName: "single-ended, ADCIN30" },
	{ name: "ADC_CH_ADCIN31", displayName: "single-ended, ADCIN31" },
	{ name: "ADC_CH_ADCIN0_ADCIN1", displayName: "differential, ADCIN0 and ADCIN1" },
	{ name: "ADC_CH_ADCIN2_ADCIN3", displayName: "differential, ADCIN2 and ADCIN3" },
	{ name: "ADC_CH_ADCIN4_ADCIN5", displayName: "differential, ADCIN4 and ADCIN5" },
	{ name: "ADC_CH_ADCIN6_ADCIN7", displayName: "differential, ADCIN6 and ADCIN7" },
	{ name: "ADC_CH_ADCIN8_ADCIN9", displayName: "differential, ADCIN8 and ADCIN9" },
	{ name: "ADC_CH_ADCIN10_ADCIN11", displayName: "differential, ADCIN10 and ADCIN11" },
	{ name: "ADC_CH_ADCIN12_ADCIN13", displayName: "differential, ADCIN12 and ADCIN13" },
	{ name: "ADC_CH_ADCIN14_ADCIN15", displayName: "differential, ADCIN14 and ADCIN15" },
	{ name: "ADC_CH_ADCIN16_ADCIN17", displayName: "differential, ADCIN16 and ADCIN17" },
	{ name: "ADC_CH_ADCIN18_ADCIN19", displayName: "differential, ADCIN18 and ADCIN19" },
	{ name: "ADC_CH_ADCIN20_ADCIN21", displayName: "differential, ADCIN20 and ADCIN21" },
	{ name: "ADC_CH_ADCIN22_ADCIN23", displayName: "differential, ADCIN22 and ADCIN23" },
	{ name: "ADC_CH_ADCIN24_ADCIN25", displayName: "differential, ADCIN24 and ADCIN25" },
	{ name: "ADC_CH_ADCIN26_ADCIN27", displayName: "differential, ADCIN26 and ADCIN27" },
	{ name: "ADC_CH_ADCIN28_ADCIN29", displayName: "differential, ADCIN28 and ADCIN29" },
	{ name: "ADC_CH_ADCIN30_ADCIN31", displayName: "differential, ADCIN30 and ADCIN31" },
]
let ADC_PulseMode = [
	{ name: "ADC_PULSE_END_OF_ACQ_WIN", displayName: "Occurs at the end of the acquisition window" },
	{ name: "ADC_PULSE_END_OF_CONV", displayName: "Occurs at the end of the conversion" },
]
let ADC_IntNumber = [
	{ name: "ADC_INT_NUMBER1", displayName: "ADCINT1 Interrupt" },
	{ name: "ADC_INT_NUMBER2", displayName: "ADCINT2 Interrupt" },
	{ name: "ADC_INT_NUMBER3", displayName: "ADCINT3 Interrupt" },
	{ name: "ADC_INT_NUMBER4", displayName: "ADCINT4 Interrupt" },
]
let ADC_PPBNumber = [
	{ name: "ADC_PPB_NUMBER1", displayName: "Post-processing block 1" },
	{ name: "ADC_PPB_NUMBER2", displayName: "Post-processing block 2" },
	{ name: "ADC_PPB_NUMBER3", displayName: "Post-processing block 3" },
	{ name: "ADC_PPB_NUMBER4", displayName: "Post-processing block 4" },
]
let ADC_SOCNumber = [
	{ name: "ADC_SOC_NUMBER0", displayName: "SOC/EOC number 0" },
	{ name: "ADC_SOC_NUMBER1", displayName: "SOC/EOC number 1" },
	{ name: "ADC_SOC_NUMBER2", displayName: "SOC/EOC number 2" },
	{ name: "ADC_SOC_NUMBER3", displayName: "SOC/EOC number 3" },
	{ name: "ADC_SOC_NUMBER4", displayName: "SOC/EOC number 4" },
	{ name: "ADC_SOC_NUMBER5", displayName: "SOC/EOC number 5" },
	{ name: "ADC_SOC_NUMBER6", displayName: "SOC/EOC number 6" },
	{ name: "ADC_SOC_NUMBER7", displayName: "SOC/EOC number 7" },
	{ name: "ADC_SOC_NUMBER8", displayName: "SOC/EOC number 8" },
	{ name: "ADC_SOC_NUMBER9", displayName: "SOC/EOC number 9" },
	{ name: "ADC_SOC_NUMBER10", displayName: "SOC/EOC number 10" },
	{ name: "ADC_SOC_NUMBER11", displayName: "SOC/EOC number 11" },
	{ name: "ADC_SOC_NUMBER12", displayName: "SOC/EOC number 12" },
	{ name: "ADC_SOC_NUMBER13", displayName: "SOC/EOC number 13" },
	{ name: "ADC_SOC_NUMBER14", displayName: "SOC/EOC number 14" },
	{ name: "ADC_SOC_NUMBER15", displayName: "SOC/EOC number 15" },
	{ name: "ADC_SOC_NUMBER16", displayName: "SOC/EOC number 16" },
	{ name: "ADC_SOC_NUMBER17", displayName: "SOC/EOC number 17" },
	{ name: "ADC_SOC_NUMBER18", displayName: "SOC/EOC number 18" },
	{ name: "ADC_SOC_NUMBER19", displayName: "SOC/EOC number 19" },
	{ name: "ADC_SOC_NUMBER20", displayName: "SOC/EOC number 20" },
	{ name: "ADC_SOC_NUMBER21", displayName: "SOC/EOC number 21" },
	{ name: "ADC_SOC_NUMBER22", displayName: "SOC/EOC number 22" },
	{ name: "ADC_SOC_NUMBER23", displayName: "SOC/EOC number 23" },
	{ name: "ADC_SOC_NUMBER24", displayName: "SOC/EOC number 24" },
	{ name: "ADC_SOC_NUMBER25", displayName: "SOC/EOC number 25" },
	{ name: "ADC_SOC_NUMBER26", displayName: "SOC/EOC number 26" },
	{ name: "ADC_SOC_NUMBER27", displayName: "SOC/EOC number 27" },
	{ name: "ADC_SOC_NUMBER28", displayName: "SOC/EOC number 28" },
	{ name: "ADC_SOC_NUMBER29", displayName: "SOC/EOC number 29" },
	{ name: "ADC_SOC_NUMBER30", displayName: "SOC/EOC number 30" },
	{ name: "ADC_SOC_NUMBER31", displayName: "SOC/EOC number 31" },
]
let ADC_IntSOCTrigger = [
	{ name: "ADC_INT_SOC_TRIGGER_NONE", displayName: "No ADCINT will trigger the SOC" },
	{ name: "ADC_INT_SOC_TRIGGER_ADCINT1", displayName: "ADCINT1 will trigger the SOC" },
	{ name: "ADC_INT_SOC_TRIGGER_ADCINT2", displayName: "ADCINT2 will trigger the SOC" },
]
let ADC_PriorityMode = [
	{ name: "ADC_PRI_ALL_ROUND_ROBIN", displayName: "Round robin mode is used for all" },
	{ name: "ADC_PRI_SOC0_HIPRI", displayName: "SOC 0 hi pri, others in round robin" },
	{ name: "ADC_PRI_THRU_SOC1_HIPRI", displayName: "SOC 0-1 hi pri, others in round robin" },
	{ name: "ADC_PRI_THRU_SOC2_HIPRI", displayName: "SOC 0-2 hi pri, others in round robin" },
	{ name: "ADC_PRI_THRU_SOC3_HIPRI", displayName: "SOC 0-3 hi pri, others in round robin" },
	{ name: "ADC_PRI_THRU_SOC4_HIPRI", displayName: "SOC 0-4 hi pri, others in round robin" },
	{ name: "ADC_PRI_THRU_SOC5_HIPRI", displayName: "SOC 0-5 hi pri, others in round robin" },
	{ name: "ADC_PRI_THRU_SOC6_HIPRI", displayName: "SOC 0-6 hi pri, others in round robin" },
	{ name: "ADC_PRI_THRU_SOC7_HIPRI", displayName: "SOC 0-7 hi pri, others in round robin" },
	{ name: "ADC_PRI_THRU_SOC8_HIPRI", displayName: "SOC 0-8 hi pri, others in round robin" },
	{ name: "ADC_PRI_THRU_SOC9_HIPRI", displayName: "SOC 0-9 hi pri, others in round robin" },
	{ name: "ADC_PRI_THRU_SOC10_HIPRI", displayName: "SOC 0-10 hi pri, others in round robin" },
	{ name: "ADC_PRI_THRU_SOC11_HIPRI", displayName: "SOC 0-11 hi pri, others in round robin" },
	{ name: "ADC_PRI_THRU_SOC12_HIPRI", displayName: "SOC 0-12 hi pri, others in round robin" },
	{ name: "ADC_PRI_THRU_SOC13_HIPRI", displayName: "SOC 0-13 hi pri, others in round robin" },
	{ name: "ADC_PRI_THRU_SOC14_HIPRI", displayName: "SOC 0-14 hi pri, SOC15 in round robin" },
	{ name: "ADC_PRI_THRU_SOC15_HIPRI", displayName: "SOC 0-15 hi pri, others in round robin" },
	{ name: "ADC_PRI_THRU_SOC16_HIPRI", displayName: "SOC 0-16 hi pri, others in round robin" },
	{ name: "ADC_PRI_THRU_SOC17_HIPRI", displayName: "SOC 0-17 hi pri, others in round robin" },
	{ name: "ADC_PRI_THRU_SOC18_HIPRI", displayName: "SOC 0-18 hi pri, others in round robin" },
	{ name: "ADC_PRI_THRU_SOC19_HIPRI", displayName: "SOC 0-19 hi pri, others in round robin" },
	{ name: "ADC_PRI_THRU_SOC20_HIPRI", displayName: "SOC 0-20 hi pri, others in round robin" },
	{ name: "ADC_PRI_THRU_SOC21_HIPRI", displayName: "SOC 0-21 hi pri, others in round robin" },
	{ name: "ADC_PRI_THRU_SOC22_HIPRI", displayName: "SOC 0-22 hi pri, others in round robin" },
	{ name: "ADC_PRI_THRU_SOC23_HIPRI", displayName: "SOC 0-23 hi pri, others in round robin" },
	{ name: "ADC_PRI_THRU_SOC24_HIPRI", displayName: "SOC 0-24 hi pri, others in round robin" },
	{ name: "ADC_PRI_THRU_SOC25_HIPRI", displayName: "SOC 0-25 hi pri, others in round robin" },
	{ name: "ADC_PRI_THRU_SOC26_HIPRI", displayName: "SOC 0-26 hi pri, others in round robin" },
	{ name: "ADC_PRI_THRU_SOC27_HIPRI", displayName: "SOC 0-27 hi pri, others in round robin" },
	{ name: "ADC_PRI_THRU_SOC28_HIPRI", displayName: "SOC 0-28 hi pri, others in round robin" },
	{ name: "ADC_PRI_THRU_SOC29_HIPRI", displayName: "SOC 0-29 hi pri, others in round robin" },
	{ name: "ADC_PRI_THRU_SOC30_HIPRI", displayName: "SOC 0-30 hi pri, others in round robin" },
	{ name: "ADC_PRI_ALL_HIPRI", displayName: "All priorities based on SOC number" },
]
let ADC_ReferenceMode = [
	{ name: "ADC_REFERENCE_INTERNAL", displayName: "REFERENCE INTERNAL" },
	{ name: "ADC_REFERENCE_EXTERNAL", displayName: "REFERENCE EXTERNAL" },
]
let ADC_ReferenceVoltage = [
	{ name: "ADC_REFERENCE_3_3V", displayName: "REFERENCE 3 3V" },
	{ name: "ADC_REFERENCE_2_5V", displayName: "REFERENCE 2 5V" },
]
let ADC_OSDetectMode = [
	{ name: "ADC_OSDETECT_MODE_DISABLED", displayName: "Open/Shorts detection cir- cuit(O/S DC) is disabled" },
	{ name: "ADC_OSDETECT_MODE_VSSA", displayName: "O/S DC is enabled at zero scale" },
	{ name: "ADC_OSDETECT_MODE_VDDA", displayName: "O/S DC is enabled at full scale" },
	{ name: "ADC_OSDETECT_MODE_5BY12_VDDA", displayName: "O/S DC is enabled at 5/12 scale" },
	{ name: "ADC_OSDETECT_MODE_7BY12_VDDA", displayName: "O/S DC is enabled at 7/12 scale" },
	{ name: "ADC_OSDETECT_MODE_5K_PULLDOWN_TO_VSSA", displayName: "O/S DC is enabled at 5K pulldown to VSSA" },
	{ name: "ADC_OSDETECT_MODE_5K_PULLUP_TO_VDDA", displayName: "O/S DC is enabled at 5K pullup to VDDA" },
	{ name: "ADC_OSDETECT_MODE_7K_PULLDOWN_TO_VSSA", displayName: "O/S DC is enabled at 7K pulldown to VSSA" },
]
let ADC_OffsetTrim = [
	{ name: "ADC_OFFSET_TRIM_COMMON", displayName: "Common Trim register for all ADC modes" },
	{ name: "ADC_OFFSET_TRIM_INDIVIDUAL", displayName: "Individual Trim registers for different ADC modes" },
]
let ADC_ChannelType = [
	{ name: "ADC_CHANNEL_ODD", displayName: "ADC Odd Channel" },
	{ name: "ADC_CHANNEL_EVEN", displayName: "ADC Even Channel" },
]
let ADC_SyncInput = [
	{ name: "ADC_SYNCIN_DISABLE", displayName: "ADC Syncin is disabled" },
	{ name: "ADC_SYNCIN_EPWM1SYNCOUT", displayName: "ADC Syncin is EPWM1SYNCOUT" },
	{ name: "ADC_SYNCIN_EPWM2SYNCOUT", displayName: "ADC Syncin is EPWM2SYNCOUT" },
	{ name: "ADC_SYNCIN_EPWM3SYNCOUT", displayName: "ADC Syncin is EPWM3SYNCOUT" },
	{ name: "ADC_SYNCIN_EPWM4SYNCOUT", displayName: "ADC Syncin is EPWM4SYNCOUT" },
	{ name: "ADC_SYNCIN_EPWM5SYNCOUT", displayName: "ADC Syncin is EPWM5SYNCOUT" },
	{ name: "ADC_SYNCIN_EPWM6SYNCOUT", displayName: "ADC Syncin is EPWM6SYNCOUT" },
	{ name: "ADC_SYNCIN_EPWM7SYNCOUT", displayName: "ADC Syncin is EPWM7SYNCOUT" },
	{ name: "ADC_SYNCIN_EPWM8SYNCOUT", displayName: "ADC Syncin is EPWM8SYNCOUT" },
	{ name: "ADC_SYNCIN_EPWM9SYNCOUT", displayName: "ADC Syncin is EPWM9SYNCOUT" },
	{ name: "ADC_SYNCIN_EPWM10SYNCOUT", displayName: "ADC Syncin is EPWM10SYNCOUT" },
	{ name: "ADC_SYNCIN_EPWM11SYNCOUT", displayName: "ADC Syncin is EPWM11SYNCOUT" },
	{ name: "ADC_SYNCIN_EPWM12SYNCOUT", displayName: "ADC Syncin is EPWM12SYNCOUT" },
	{ name: "ADC_SYNCIN_EPWM13SYNCOUT", displayName: "ADC Syncin is EPWM13SYNCOUT" },
	{ name: "ADC_SYNCIN_EPWM14SYNCOUT", displayName: "ADC Syncin is EPWM14SYNCOUT" },
	{ name: "ADC_SYNCIN_EPWM15SYNCOUT", displayName: "ADC Syncin is EPWM15SYNCOUT" },
	{ name: "ADC_SYNCIN_EPWM16SYNCOUT", displayName: "ADC Syncin is EPWM16SYNCOUT" },
	{ name: "ADC_SYNCIN_EPWM17SYNCOUT", displayName: "ADC Syncin is EPWM17SYNCOUT" },
	{ name: "ADC_SYNCIN_EPWM18SYNCOUT", displayName: "ADC Syncin is EPWM18SYNCOUT" },
	{ name: "ADC_SYNCIN_ECAP1YNCOUT", displayName: "ADC Syncin is ECAP1YNCOUT" },
	{ name: "ADC_SYNCIN_ECAP2SYNCOUT", displayName: "ADC Syncin is ECAP2SYNCOUT" },
	{ name: "ADC_SYNCIN_ECAP3SYNCOUT", displayName: "ADC Syncin is ECAP3SYNCOUT" },
	{ name: "ADC_SYNCIN_ECAP4SYNCOUT", displayName: "ADC Syncin is ECAP4SYNCOUT" },
	{ name: "ADC_SYNCIN_ECAP5SYNCOUT", displayName: "ADC Syncin is ECAP5SYNCOUT" },
	{ name: "ADC_SYNCIN_ECAP6SYNCOUT", displayName: "ADC Syncin is ECAP6SYNCOUT" },
	{ name: "ADC_SYNCIN_INPUTXBAROUTPUT5", displayName: "ADC Syncin is INPUTXBAROUTPUT5" },
	{ name: "ADC_SYNCIN_INPUTXBAROUTPUT6", displayName: "ADC Syncin is INPUTXBAROUTPUT6" },
	{ name: "ADC_SYNCIN_EtherCATSYNC0", displayName: "ADC Syncin is EtherCATSYNC0" },
	{ name: "ADC_SYNCIN_EtherCATSYNC1", displayName: "ADC Syncin is EtherCATSYNC1" },
]
let ADC_PPBIntSrcSelect = [
	{ name: "ADC_PPB_OS_INT_1", displayName: "PCount generates PPB interrupt" },
	{ name: "ADC_PPB_OS_INT_2", displayName: "PCount/Sync generates PPB interrupt" },
]
let ADC_ExtChannel = [
	{ name: "ADC_CH_ADCINX_0", displayName: "ADCINX.0 is converted" },
	{ name: "ADC_CH_ADCINX_1", displayName: "ADCINX.1 is converted" },
	{ name: "ADC_CH_ADCINX_2", displayName: "ADCINX.2 is converted" },
	{ name: "ADC_CH_ADCINX_3", displayName: "ADCINX.3 is converted" },
	{ name: "ADC_CH_ADCINX_4", displayName: "ADCINX.4 is converted" },
	{ name: "ADC_CH_ADCINX_5", displayName: "ADCINX.5 is converted" },
	{ name: "ADC_CH_ADCINX_6", displayName: "ADCINX.6 is converted" },
	{ name: "ADC_CH_ADCINX_7", displayName: "ADCINX.7 is converted" },
	{ name: "ADC_CH_ADCINX_8", displayName: "ADCINX.8 is converted" },
	{ name: "ADC_CH_ADCINX_9", displayName: "ADCINX.9 is converted" },
	{ name: "ADC_CH_ADCINX_10", displayName: "ADCINX.10 is converted" },
	{ name: "ADC_CH_ADCINX_11", displayName: "ADCINX.11 is converted" },
	{ name: "ADC_CH_ADCINX_12", displayName: "ADCINX.12 is converted" },
	{ name: "ADC_CH_ADCINX_13", displayName: "ADCINX.13 is converted" },
	{ name: "ADC_CH_ADCINX_14", displayName: "ADCINX.14 is converted" },
	{ name: "ADC_CH_ADCINX_15", displayName: "ADCINX.15 is converted" },
]
let ADC_IntTrigger = [
	{ name: "ADC_INT_TRIGGER_EOC0", displayName: "SOC/EOC0" },
	{ name: "ADC_INT_TRIGGER_EOC1", displayName: "SOC/EOC1" },
	{ name: "ADC_INT_TRIGGER_EOC2", displayName: "SOC/EOC2" },
	{ name: "ADC_INT_TRIGGER_EOC3", displayName: "SOC/EOC3" },
	{ name: "ADC_INT_TRIGGER_EOC4", displayName: "SOC/EOC4" },
	{ name: "ADC_INT_TRIGGER_EOC5", displayName: "SOC/EOC5" },
	{ name: "ADC_INT_TRIGGER_EOC6", displayName: "SOC/EOC6" },
	{ name: "ADC_INT_TRIGGER_EOC7", displayName: "SOC/EOC7" },
	{ name: "ADC_INT_TRIGGER_EOC8", displayName: "SOC/EOC8" },
	{ name: "ADC_INT_TRIGGER_EOC9", displayName: "SOC/EOC9" },
	{ name: "ADC_INT_TRIGGER_EOC10", displayName: "SOC/EOC10" },
	{ name: "ADC_INT_TRIGGER_EOC11", displayName: "SOC/EOC11" },
	{ name: "ADC_INT_TRIGGER_EOC12", displayName: "SOC/EOC12" },
	{ name: "ADC_INT_TRIGGER_EOC13", displayName: "SOC/EOC13" },
	{ name: "ADC_INT_TRIGGER_EOC14", displayName: "SOC/EOC14" },
	{ name: "ADC_INT_TRIGGER_EOC15", displayName: "SOC/EOC15" },
	{ name: "ADC_INT_TRIGGER_EOC16", displayName: "SOC/EO16" },
	{ name: "ADC_INT_TRIGGER_EOC17", displayName: "SOC/EO17" },
	{ name: "ADC_INT_TRIGGER_EOC18", displayName: "SOC/EO18" },
	{ name: "ADC_INT_TRIGGER_EOC19", displayName: "SOC/EOC19" },
	{ name: "ADC_INT_TRIGGER_EOC20", displayName: "SOC/EOC20" },
	{ name: "ADC_INT_TRIGGER_EOC21", displayName: "SOC/EOC21" },
	{ name: "ADC_INT_TRIGGER_EOC22", displayName: "SOC/EOC22" },
	{ name: "ADC_INT_TRIGGER_EOC23", displayName: "SOC/EOC23" },
	{ name: "ADC_INT_TRIGGER_EOC24", displayName: "SOC/EOC24" },
	{ name: "ADC_INT_TRIGGER_EOC25", displayName: "SOC/EOC25" },
	{ name: "ADC_INT_TRIGGER_EOC26", displayName: "SOC/EOC26" },
	{ name: "ADC_INT_TRIGGER_EOC27", displayName: "SOC/EOC27" },
	{ name: "ADC_INT_TRIGGER_EOC28", displayName: "SOC/EOC28" },
	{ name: "ADC_INT_TRIGGER_EOC29", displayName: "SOC/EOC29" },
	{ name: "ADC_INT_TRIGGER_EOC30", displayName: "SOC/EOC30" },
	{ name: "ADC_INT_TRIGGER_EOC31", displayName: "SOC/EOC31" },
	{ name: "ADC_INT_TRIGGER_OSINT1", displayName: "OSINT1" },
	{ name: "ADC_INT_TRIGGER_OSINT2", displayName: "OSINT2" },
	{ name: "ADC_INT_TRIGGER_OSINT3", displayName: "OSINT3" },
	{ name: "ADC_INT_TRIGGER_OSINT4", displayName: "OSINT4" },
]
let ADC_PPBCompSource = [
	{ name: "ADC_PPB_COMPSOURCE_RESULT", displayName: "PPB compare source is ADCRESULT" },
	{ name: "ADC_PPB_COMPSOURCE_PSUM", displayName: "PPB compare source is PSUM" },
	{ name: "ADC_PPB_COMPSOURCE_SUM", displayName: "PPB compare source is SUM" },
]
let ADC_Select = [
	{ name: "ADC_A", displayName: "Select ADCA instance" },
	{ name: "ADC_B", displayName: "Select ADCB instance" },
	{ name: "ADC_C", displayName: "Select ADCC instance" },
	{ name: "ADC_D", displayName: "Select ADCD instance" },
	{ name: "ADC_E", displayName: "Select ADCE instance" },
]
let ADC_ResultSelect = [
	{ name: "ADC_RESULT0", displayName: "Select ADC Result 0" },
	{ name: "ADC_RESULT1", displayName: "Select ADC Result 1" },
	{ name: "ADC_RESULT2", displayName: "Select ADC Result 2" },
	{ name: "ADC_RESULT3", displayName: "Select ADC Result 3" },
	{ name: "ADC_RESULT4", displayName: "Select ADC Result 4" },
	{ name: "ADC_RESULT5", displayName: "Select ADC Result 5" },
	{ name: "ADC_RESULT6", displayName: "Select ADC Result 6" },
	{ name: "ADC_RESULT7", displayName: "Select ADC Result 7" },
	{ name: "ADC_RESULT8", displayName: "Select ADC Result 8" },
	{ name: "ADC_RESULT9", displayName: "Select ADC Result 9" },
	{ name: "ADC_RESULT10", displayName: "Select ADC Result 10" },
	{ name: "ADC_RESULT11", displayName: "Select ADC Result 11" },
	{ name: "ADC_RESULT12", displayName: "Select ADC Result 12" },
	{ name: "ADC_RESULT13", displayName: "Select ADC Result 13" },
	{ name: "ADC_RESULT14", displayName: "Select ADC Result 14" },
	{ name: "ADC_RESULT15", displayName: "Select ADC Result 15" },
	{ name: "ADC_RESULT16", displayName: "Select ADC Result 16" },
	{ name: "ADC_RESULT17", displayName: "Select ADC Result 17" },
	{ name: "ADC_RESULT18", displayName: "Select ADC Result 18" },
	{ name: "ADC_RESULT19", displayName: "Select ADC Result 19" },
	{ name: "ADC_RESULT20", displayName: "Select ADC Result 20" },
	{ name: "ADC_RESULT21", displayName: "Select ADC Result 21" },
	{ name: "ADC_RESULT22", displayName: "Select ADC Result 22" },
	{ name: "ADC_RESULT23", displayName: "Select ADC Result 23" },
	{ name: "ADC_RESULT24", displayName: "Select ADC Result 24" },
	{ name: "ADC_RESULT25", displayName: "Select ADC Result 25" },
	{ name: "ADC_RESULT26", displayName: "Select ADC Result 26" },
	{ name: "ADC_RESULT27", displayName: "Select ADC Result 27" },
	{ name: "ADC_RESULT28", displayName: "Select ADC Result 28" },
	{ name: "ADC_RESULT29", displayName: "Select ADC Result 29" },
	{ name: "ADC_RESULT30", displayName: "Select ADC Result 30" },
	{ name: "ADC_RESULT31", displayName: "Select ADC Result 31" },
]
let ADC_SafetyCheckerInput = [
	{ name: "ADC_SAFETY_CHECKER_INPUT_DISABLE", displayName: "Safety checker i/p disabled" },
	{ name: "ADC_SAFETY_CHECKER_INPUT_SOCx", displayName: "Safety checker i/p is SOCx" },
	{ name: "ADC_SAFETY_CHECKER_INPUT_PPBx", displayName: "Safety checker i/p is PPBx" },
	{ name: "ADC_SAFETY_CHECKER_INPUT_PPBSUMx", displayName: "Safety checker i/p is PPBSUMx" },
]
let ADC_SafetyCheckInst = [
	{ name: "ADC_SAFETY_CHECK1", displayName: "Safety Check Result 1" },
	{ name: "ADC_SAFETY_CHECK2", displayName: "Safety Check Result 2" },
]
let ADC_SafetyCheckEvent = [
	{ name: "ADC_SAFETY_CHECK_EVENT1", displayName: "Safety Check Event 1" },
	{ name: "ADC_SAFETY_CHECK_EVENT2", displayName: "Safety Check Event 2" },
	{ name: "ADC_SAFETY_CHECK_EVENT3", displayName: "Safety Check Event 3" },
	{ name: "ADC_SAFETY_CHECK_EVENT4", displayName: "Safety Check Event 4" },
]
let ADC_SafetyCheckResult = [
	{ name: "ADC_SAFETY_CHECK_RES1OVF", displayName: "Safety Check Result1 Overflow" },
	{ name: "ADC_SAFETY_CHECK_RES2OVF", displayName: "Safety Check Result2 Overflow" },
	{ name: "ADC_SAFETY_CHECK_OOT", displayName: "Safety Check OOT" },
]
let ADC_Checker = [
	{ name: "ADC_SAFETY_CHECKER1", displayName: "Safety Checker1" },
	{ name: "ADC_SAFETY_CHECKER2", displayName: "Safety Checker2" },
	{ name: "ADC_SAFETY_CHECKER3", displayName: "Safety Checker3" },
	{ name: "ADC_SAFETY_CHECKER4", displayName: "Safety Checker4" },
	{ name: "ADC_SAFETY_CHECKER5", displayName: "Safety Checker5" },
	{ name: "ADC_SAFETY_CHECKER6", displayName: "Safety Checker6" },
	{ name: "ADC_SAFETY_CHECKER7", displayName: "Safety Checker7" },
	{ name: "ADC_SAFETY_CHECKER8", displayName: "Safety Checker8" },
]
let ADC_SafetyCheckFlag = [
	{ name: "ADC_SAFETY_CHECK_OOT_FLG", displayName: "Safety Check Out-of-Tolerance Flag" },
	{ name: "ADC_SAFETY_CHECK_RES1OVF_FLG", displayName: "Safety Check Result1 Overflow Flag" },
	{ name: "ADC_SAFETY_CHECK_RES2OVF_FLG", displayName: "Safety Check Result2 Overflow Flag" },
]
let ADC_RepInstance = [
	{ name: "ADC_REPINST1", displayName: "Select ADC repeater instance 1" },
	{ name: "ADC_REPINST2", displayName: "Select ADC repeater instance 2" },
]
let ADC_RepMode = [
	{ name: "ADC_REPMODE_OVERSAMPLING", displayName: "ADC repeater mode is oversampling" },
	{ name: "ADC_REPMODE_UNDERSAMPLING", displayName: "ADC repeater mode is undersampling" },
]
let ADC_EVT = [
	{ name: "ADC_EVT_TRIPHI", displayName: "Trip High Event" },
	{ name: "ADC_EVT_TRIPLO", displayName: "Trip Low Event" },
	{ name: "ADC_EVT_ZERO", displayName: "Zero Crossing Event" },
]
let ADC_FORCE_SOC = [
	{ name: "ADC_FORCE_SOC0", displayName: "SW trigger ADC SOC 0" },
	{ name: "ADC_FORCE_SOC1", displayName: "SW trigger ADC SOC 1" },
	{ name: "ADC_FORCE_SOC2", displayName: "SW trigger ADC SOC 2" },
	{ name: "ADC_FORCE_SOC3", displayName: "SW trigger ADC SOC 3" },
	{ name: "ADC_FORCE_SOC4", displayName: "SW trigger ADC SOC 4" },
	{ name: "ADC_FORCE_SOC5", displayName: "SW trigger ADC SOC 5" },
	{ name: "ADC_FORCE_SOC6", displayName: "SW trigger ADC SOC 6" },
	{ name: "ADC_FORCE_SOC7", displayName: "SW trigger ADC SOC 7" },
	{ name: "ADC_FORCE_SOC8", displayName: "SW trigger ADC SOC 8" },
	{ name: "ADC_FORCE_SOC9", displayName: "SW trigger ADC SOC 9" },
	{ name: "ADC_FORCE_SOC10", displayName: "SW trigger ADC SOC 10" },
	{ name: "ADC_FORCE_SOC11", displayName: "SW trigger ADC SOC 11" },
	{ name: "ADC_FORCE_SOC12", displayName: "SW trigger ADC SOC 12" },
	{ name: "ADC_FORCE_SOC13", displayName: "SW trigger ADC SOC 13" },
	{ name: "ADC_FORCE_SOC14", displayName: "SW trigger ADC SOC 14" },
	{ name: "ADC_FORCE_SOC15", displayName: "SW trigger ADC SOC 15" },
	{ name: "ADC_FORCE_SOC16", displayName: "SW trigger ADC SOC 16" },
	{ name: "ADC_FORCE_SOC17", displayName: "SW trigger ADC SOC 17" },
	{ name: "ADC_FORCE_SOC18", displayName: "SW trigger ADC SOC 18" },
	{ name: "ADC_FORCE_SOC19", displayName: "SW trigger ADC SOC 19" },
	{ name: "ADC_FORCE_SOC20", displayName: "SW trigger ADC SOC 20" },
	{ name: "ADC_FORCE_SOC21", displayName: "SW trigger ADC SOC 21" },
	{ name: "ADC_FORCE_SOC22", displayName: "SW trigger ADC SOC 22" },
	{ name: "ADC_FORCE_SOC23", displayName: "SW trigger ADC SOC 23" },
	{ name: "ADC_FORCE_SOC24", displayName: "SW trigger ADC SOC 24" },
	{ name: "ADC_FORCE_SOC25", displayName: "SW trigger ADC SOC 25" },
	{ name: "ADC_FORCE_SOC26", displayName: "SW trigger ADC SOC 26" },
	{ name: "ADC_FORCE_SOC27", displayName: "SW trigger ADC SOC 27" },
	{ name: "ADC_FORCE_SOC28", displayName: "SW trigger ADC SOC 28" },
	{ name: "ADC_FORCE_SOC29", displayName: "SW trigger ADC SOC 29" },
	{ name: "ADC_FORCE_SOC30", displayName: "SW trigger ADC SOC 30" },
	{ name: "ADC_FORCE_SOC31", displayName: "SW trigger ADC SOC 31" },
]
let ADC_REPEATER = [
	{ name: "ADC_REPEATER_MODULE_BUSY", displayName: "REPEATER MODULE BUSY" },
	{ name: "ADC_REPEATER_PHASE_OVERFLOW", displayName: "REPEATER PHASE OVERFLOW" },
	{ name: "ADC_REPEATER_TRIGGER_OVERFLOW", displayName: "REPEATER TRIGGER OVERFLOW" },
]
let ADC_REP1CTL = [
	{ name: "ADC_REP1CTL_ACTIVEMODE_S", displayName: "REP1CTL ACTIVEMODE S" },
	{ name: "ADC_REP1CTL_MODULEBUSY_S", displayName: "REP1CTL MODULEBUSY S" },
]
let ADC_REPSTATUS_MASK = [
	{ name: "ADC_REPSTATUS_MASK", displayName: "MASK" },
]
let ADC_SAFECHECK_RESULT = [
	{ name: "ADC_SAFECHECK_RESULT1_READY", displayName: "RESULT1 READY" },
	{ name: "ADC_SAFECHECK_RESULT2_READY", displayName: "RESULT2 READY" },
	{ name: "ADC_SAFECHECK_RESULT_OOT", displayName: "RESULT OOT" },
]
let ADC_SAFECHECK_STATUS_MASK = [
	{ name: "ADC_SAFECHECK_STATUS_MASK", displayName: "MASK" },
]
module.exports = {
	ADC_ClkPrescale: ADC_ClkPrescale,
	ADC_Resolution: ADC_Resolution,
	ADC_SignalMode: ADC_SignalMode,
	ADC_Trigger: ADC_Trigger,
	ADC_Channel: ADC_Channel,
	ADC_PulseMode: ADC_PulseMode,
	ADC_IntNumber: ADC_IntNumber,
	ADC_PPBNumber: ADC_PPBNumber,
	ADC_SOCNumber: ADC_SOCNumber,
	ADC_IntSOCTrigger: ADC_IntSOCTrigger,
	ADC_PriorityMode: ADC_PriorityMode,
	ADC_ReferenceMode: ADC_ReferenceMode,
	ADC_ReferenceVoltage: ADC_ReferenceVoltage,
	ADC_OSDetectMode: ADC_OSDetectMode,
	ADC_OffsetTrim: ADC_OffsetTrim,
	ADC_ChannelType: ADC_ChannelType,
	ADC_SyncInput: ADC_SyncInput,
	ADC_PPBIntSrcSelect: ADC_PPBIntSrcSelect,
	ADC_ExtChannel: ADC_ExtChannel,
	ADC_IntTrigger: ADC_IntTrigger,
	ADC_PPBCompSource: ADC_PPBCompSource,
	ADC_Select: ADC_Select,
	ADC_ResultSelect: ADC_ResultSelect,
	ADC_SafetyCheckerInput: ADC_SafetyCheckerInput,
	ADC_SafetyCheckInst: ADC_SafetyCheckInst,
	ADC_SafetyCheckEvent: ADC_SafetyCheckEvent,
	ADC_SafetyCheckResult: ADC_SafetyCheckResult,
	ADC_Checker: ADC_Checker,
	ADC_SafetyCheckFlag: ADC_SafetyCheckFlag,
	ADC_RepInstance: ADC_RepInstance,
	ADC_RepMode: ADC_RepMode,
	ADC_EVT: ADC_EVT,
	ADC_FORCE_SOC: ADC_FORCE_SOC,
	ADC_REPEATER: ADC_REPEATER,
	ADC_REP1CTL: ADC_REP1CTL,
	ADC_REPSTATUS_MASK: ADC_REPSTATUS_MASK,
	ADC_SAFECHECK_RESULT: ADC_SAFECHECK_RESULT,
	ADC_SAFECHECK_STATUS_MASK: ADC_SAFECHECK_STATUS_MASK,
}
