//###########################################################################
//
// FILE:   xbar.h
//
// TITLE:  C29x X-BAR driver.
//
//###########################################################################
// //
//	Copyright: Copyright (C) Texas Instruments Incorporated
//	All rights reserved not granted herein.
//
//  Redistribution and use in source and binary forms, with or without 
//  modification, are permitted provided that the following conditions 
//  are met:
//
//  Redistributions of source code must retain the above copyright 
//  notice, this list of conditions and the following disclaimer.
//
//  Redistributions in binary form must reproduce the above copyright
//  notice, this list of conditions and the following disclaimer in the 
//  documentation and/or other materials provided with the   
//  distribution.
//
//  Neither the name of Texas Instruments Incorporated nor the names of
//  its contributors may be used to endorse or promote products derived
//  from this software without specific prior written permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
//  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
//  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
//  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
//  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
//  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
//  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
//  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
//  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
//  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
//  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

//###########################################################################

#ifndef XBAR_H
#define XBAR_H

//*****************************************************************************
//
// If building with a C++ compiler, make all of the definitions in this header
// have a C binding.
//
//*****************************************************************************
#ifdef __cplusplus
extern "C"
{
#endif

//*****************************************************************************
//
//! \addtogroup xbar_api XBAR
//! @{
//
//*****************************************************************************

#include <stdbool.h>
#include <stdint.h>
#include "inc/hw_clb_xbar.h"
#include "inc/hw_epwm_xbar.h"
#include "inc/hw_input_xbar.h"
#include "inc/hw_output_xbar.h"
#include "inc/hw_mdl_xbar.h"
#include "inc/hw_icl_xbar.h"
#include "inc/hw_xbar.h"
#include "inc/hw_memmap.h"
#include "inc/hw_types.h"
#include "cpu.h"
#include "debug.h"

//*****************************************************************************
//
// Useful defines used within the driver functions.
// Not intended for use by application code.
//
//*****************************************************************************

#define XBAR_XBARLOCK_OFFSET     OUTPUT_XBAR_O_OUTPUTXBARLOCK
#define XBAR_XBARLOCK_KEY_S      OUTPUT_XBAR_OUTPUTXBARLOCK_KEY_S
#define XBAR_XBARLOCK_LOCK       OUTPUT_XBAR_OUTPUTXBARLOCK_LOCK
#define XBAR_XBAROUTINVERT       OUTPUT_XBAR_O_OUTPUTXBAROUTINVERT

#define XBAR_OUTPUTXBAR_FLAGS_OFFSET    0x1000U

#define XBAR_INPUT_INPUT_M    0x00FFU
#define XBAR_INPUT_REG_M      0xFF00U
#define XBAR_INPUT_REG_S      8U

#define XBAR_INPUT_FLG_REG_1      0x0100U
#define XBAR_INPUT_FLG_REG_2      0x0200U
#define XBAR_INPUT_FLG_REG_3      0x0300U
#define XBAR_INPUT_FLG_REG_4      0x0400U
#define XBAR_INPUT_FLG_REG_5      0x0500U
#define XBAR_INPUT_FLG_REG_6      0x0600U
#define XBAR_INPUT_FLG_REG_7      0x0700U
#define XBAR_INPUT_FLG_REG_8      0x0800U
#define XBAR_INPUT_FLG_REG_9      0x0900U
#define XBAR_INPUT_FLG_REG_10      0x0A00U
#define XBAR_INPUT_FLG_REG_11      0x0B00U
#define XBAR_INPUT_FLG_REG_12      0x0C00U
#define XBAR_INPUT_FLG_REG_13      0x0D00U
#define XBAR_INPUT_FLG_REG_14      0x0E00U
#define XBAR_INPUT_FLG_REG_15      0x0F00U
#define XBAR_INPUT_FLG_REG_16      0x1000U
#define XBAR_INPUT_FLG_REG_17      0x1100U
#define XBAR_INPUT_FLG_REG_18      0x1200U

#define XBAR_NON_GPIO_MIN_CNT            0xFFFDU
#define XBAR_NON_GPIO_MAX_CNT            0xFFFFU

#define XBAR_XBARGSEL_STEP               0x4U

//*****************************************************************************
//
//! The following values define the \e output parameter for
//! XBAR_selectOutputXbarInputSource(), XBAR_selectMindbXbarInputSource(),
//! XBAR_selectIclXbarInputSource() and XBAR_invertOutputSignal().
//
//*****************************************************************************
typedef enum
{
    XBAR_OUTPUT1,   //!< OUTPUT1 of the X-BAR
    XBAR_OUTPUT2,   //!< OUTPUT2 of the X-BAR
    XBAR_OUTPUT3,   //!< OUTPUT3 of the X-BAR
    XBAR_OUTPUT4,   //!< OUTPUT4 of the X-BAR
    XBAR_OUTPUT5,   //!< OUTPUT5 of the X-BAR
    XBAR_OUTPUT6,   //!< OUTPUT6 of the X-BAR
    XBAR_OUTPUT7,   //!< OUTPUT7 of the X-BAR
    XBAR_OUTPUT8,   //!< OUTPUT8 of the X-BAR
    XBAR_OUTPUT9,   //!< OUTPUT9 of the X-BAR
    XBAR_OUTPUT10,   //!< OUTPUT10 of the X-BAR
    XBAR_OUTPUT11,   //!< OUTPUT11 of the X-BAR
    XBAR_OUTPUT12,   //!< OUTPUT12 of the X-BAR
    XBAR_OUTPUT13,   //!< OUTPUT13 of the X-BAR
    XBAR_OUTPUT14,   //!< OUTPUT14 of the X-BAR
    XBAR_OUTPUT15,   //!< OUTPUT15 of the X-BAR
    XBAR_OUTPUT16    //!< OUTPUT16 of the X-BAR
} XBAR_OutputNum;

//*****************************************************************************
//
//! The following values define the \e output parameter for
//! XBAR_selectEpwmXbarInputSource
//
//*****************************************************************************
typedef enum
{
    XBAR_TRIP1,   //!< TRIP1 of the ePWM X-BAR
    XBAR_TRIP2,   //!< TRIP2 of the ePWM X-BAR
    XBAR_TRIP3,   //!< TRIP3 of the ePWM X-BAR
    XBAR_TRIP4,   //!< TRIP4 of the ePWM X-BAR
    XBAR_TRIP5,   //!< TRIP5 of the ePWM X-BAR
    XBAR_TRIP6,   //!< TRIP6 of the ePWM X-BAR
    XBAR_TRIP7,   //!< TRIP7 of the ePWM X-BAR
    XBAR_TRIP8,   //!< TRIP8 of the ePWM X-BAR
    XBAR_TRIP9,   //!< TRIP9 of the ePWM X-BAR
    XBAR_TRIP10,   //!< TRIP10 of the ePWM X-BAR
    XBAR_TRIP11,   //!< TRIP11 of the ePWM X-BAR
    XBAR_TRIP12,   //!< TRIP12 of the ePWM X-BAR
    XBAR_TRIP13,   //!< TRIP13 of the ePWM X-BAR
    XBAR_TRIP14,   //!< TRIP14 of the ePWM X-BAR
    XBAR_TRIP15,   //!< TRIP15 of the ePWM X-BAR
    XBAR_TRIP16    //!< TRIP16 of the ePWM X-BAR
} XBAR_TripNum;

//*****************************************************************************
//
//! The following values define the \e output parameter for
//! XBAR_selectClbXbarInputSource
//
//*****************************************************************************
typedef enum
{
    XBAR_AUXSIG0,   //!< AUXSIG0 of the CLB X-BAR
    XBAR_AUXSIG1,   //!< AUXSIG1 of the CLB X-BAR
    XBAR_AUXSIG2,   //!< AUXSIG2 of the CLB X-BAR
    XBAR_AUXSIG3,   //!< AUXSIG3 of the CLB X-BAR
    XBAR_AUXSIG4,   //!< AUXSIG4 of the CLB X-BAR
    XBAR_AUXSIG5,   //!< AUXSIG5 of the CLB X-BAR
    XBAR_AUXSIG6,   //!< AUXSIG6 of the CLB X-BAR
    XBAR_AUXSIG7,   //!< AUXSIG7 of the CLB X-BAR
} XBAR_AuxSigNum;

//*****************************************************************************
//
//! The following values define the \e input parameter for XBAR_setInputPin()
//! and XBAR_lockInput()
//
//*****************************************************************************
typedef enum
{
	XBAR_INPUT1,			//!< X-BARs, CLBXBAR, OUTPUTXBAR, EPWM TRIP[TZ1,TRIP1], EPWMDEL, ECAP, ERAD, ECAT
	XBAR_INPUT2,			//!< X-BARs, CLBXBAR, OUTPUTXBAR, EPWM TRIP[TZ2,TRIP2], EPWMDEL, ECAP, ERAD, ECAT
	XBAR_INPUT3,			//!< X-BARs, CLBXBAR, OUTPUTXBAR, EPWM TRIP[TZ3,TRIP3], EPWMDEL, ECAP, ERAD, ECAT
	XBAR_INPUT4,			//!< X-BARs, CLBXBAR, OUTPUTXBAR, XINT[XINT1], EPWMDEL, ECAP, ERAD, ECAT
	XBAR_INPUT5,			//!< X-BARs, CLBXBAR, OUTPUTXBAR, XINT[XINT2], EPWMDEL, ECAP, ADCSOC[ADCEXTSOC], SYNCIN[EXTSYNCIN1], ERAD, ECAT
	XBAR_INPUT6,			//!< X-BARs, CLBXBAR, OUTPUTXBAR, XINT[XINT3], EPWM TRIP[TRIP6], EPWMDEL, ECAP, SYNCIN[EXTSYNCIN2], ERAD, ECAT
	XBAR_INPUT7,			//!< X-BARs, CLBXBAR, OUTPUTXBAR, EPWMDEL, ECAP, ERAD, CMPSS[CMPSS1_EXT_FILTIN_H,CMPSS3_EXT_FILTIN_H], ECAT
	XBAR_INPUT8,			//!< X-BARs, CLBXBAR, OUTPUTXBAR, EPWMDEL, ECAP, ERAD, CMPSS[CMPSS1_EXT_FILTIN_L ,CMPSS3_EXT_FILTIN_L], ECAT
	XBAR_INPUT9,			//!< X-BARs, CLBXBAR, OUTPUTXBAR, EPWMDEL, ECAP, ERAD, CMPSS[CMPSS2_EXT_FILTIN_H,CMPSS4_EXT_FILTIN_H], ECAT
	XBAR_INPUT10,			//!< X-BARs, CLBXBAR, OUTPUTXBAR, EPWMDEL, ECAP, ERAD, CMPSS[CMPSS2_EXT_FILTIN_L ,CMPSS4_EXT_FILTIN_L], ECAT
	XBAR_INPUT11,			//!< X-BARs, CLBXBAR, OUTPUTXBAR, EPWMDEL, ECAP, DCCx[CLK1], ERAD, ECAT
	XBAR_INPUT12,			//!< X-BARs, CLBXBAR, OUTPUTXBAR, EPWMDEL, ECAP, DCCx[CLK1], ERAD, ECAT
	XBAR_INPUT13,			//!< X-BARs, CLBXBAR, OUTPUTXBAR, XINT[XINT4], EPWMDEL, ECAP, EPG[EPG1IN1], ERAD, ECAT
	XBAR_INPUT14,			//!< X-BARs, CLBXBAR, OUTPUTXBAR, XINT[XINT5], EPWMDEL, ECAP, EPG[EPG1IN2], ERAD, ECAT
	XBAR_INPUT15,			//!< X-BARs, CLBXBAR, OUTPUTXBAR, EPWMDEL, ECAP, DCCx[CLK1], EPG[EPG1IN3], ERAD, ECAT
	XBAR_INPUT16,			//!< X-BARs, CLBXBAR, OUTPUTXBAR, EPWMDEL, ECAP, DCCx[CLK0], EPG[EPG1IN4], ERAD, ECAT
	XBAR_INPUT17,			//!< X-BARs, CLBXBAR, OUTPUTXBAR, EPWMDEL, CLB
	XBAR_INPUT18,			//!< X-BARs, CLBXBAR, OUTPUTXBAR, EPWMDEL, CLB
	XBAR_INPUT19,			//!< X-BARs, CLBXBAR, OUTPUTXBAR, EPWMDEL, CLB
	XBAR_INPUT20,			//!< X-BARs, CLBXBAR, OUTPUTXBAR, EPWMDEL, CLB
	XBAR_INPUT21,			//!< X-BARs, CLBXBAR, OUTPUTXBAR, EPWMDEL, CLB
	XBAR_INPUT22,			//!< X-BARs, CLBXBAR, OUTPUTXBAR, EPWMDEL, CLB
	XBAR_INPUT23,			//!< X-BARs, CLBXBAR, OUTPUTXBAR, EPWMDEL, CLB
	XBAR_INPUT24,			//!< X-BARs, CLBXBAR, OUTPUTXBAR, EPWMDEL, CLB
	XBAR_INPUT25,			//!< X-BARs, CLBXBAR, OUTPUTXBAR, EPWMDEL, CLB
	XBAR_INPUT26,			//!< X-BARs, CLBXBAR, OUTPUTXBAR, EPWMDEL, CLB
	XBAR_INPUT27,			//!< X-BARs, CLBXBAR, OUTPUTXBAR, EPWMDEL, CLB
	XBAR_INPUT28,			//!< X-BARs, CLBXBAR, OUTPUTXBAR, EPWMDEL, CLB
	XBAR_INPUT29,			//!< X-BARs, CLBXBAR, OUTPUTXBAR, EPWMDEL, CLB
	XBAR_INPUT30,			//!< X-BARs, CLBXBAR, OUTPUTXBAR, EPWMDEL, CLB
	XBAR_INPUT31,			//!< X-BARs, CLBXBAR, OUTPUTXBAR, EPWMDEL, CLB
	XBAR_INPUT32,			//!< X-BARs, CLBXBAR, OUTPUTXBAR, EPWMDEL, CLB
	XBAR_INPUT33,			//!< EQEP[EQEP1A], WADI1[WADI1]
	XBAR_INPUT34,			//!< EQEP[EQEP1B], WADI1[WADI1]
	XBAR_INPUT35,			//!< EQEP[EQEP1I], WADI1[WADI1]
	XBAR_INPUT36,			//!< EQEP[EQEP1S], WADI1[WADI1]
	XBAR_INPUT37,			//!< EQEP[EQEP2A], WADI1[WADI1]
	XBAR_INPUT38,			//!< EQEP[EQEP2B], WADI1[WADI1]
	XBAR_INPUT39,			//!< EQEP[EQEP2I], WADI1[WADI1]
	XBAR_INPUT40,			//!< EQEP[EQEP2S], WADI1[WADI1]
	XBAR_INPUT41,			//!< EQEP[EQEP3A], WADI1[WADI1]
	XBAR_INPUT42,			//!< EQEP[EQEP3B], WADI1[WADI1]
	XBAR_INPUT43,			//!< EQEP[EQEP3I], WADI1[WADI1]
	XBAR_INPUT44,			//!< EQEP[EQEP3S], WADI1[WADI1]
	XBAR_INPUT45,			//!< EQEP[EQEP4A], WADI1[WADI1]
	XBAR_INPUT46,			//!< EQEP[EQEP4B], WADI1[WADI1]
	XBAR_INPUT47,			//!< EQEP[EQEP4I], WADI1[WADI1]
	XBAR_INPUT48,			//!< EQEP[EQEP4S], WADI1[WADI1]
	XBAR_INPUT49,			//!< EQEP[EQEP5A], WADI2[WADI2]
	XBAR_INPUT50,			//!< EQEP[EQEP5B], WADI2[WADI2]
	XBAR_INPUT51,			//!< EQEP[EQEP5I], WADI2[WADI2]
	XBAR_INPUT52,			//!< EQEP[EQEP5S], WADI2[WADI2]
	XBAR_INPUT53,			//!< EQEP[EQEP6A], WADI2[WADI2]
	XBAR_INPUT54,			//!< EQEP[EQEP6B], WADI2[WADI2]
	XBAR_INPUT55,			//!< EQEP[EQEP6I], WADI2[WADI2]
	XBAR_INPUT56,			//!< EQEP[EQEP6S], WADI2[WADI2]
	XBAR_INPUT57,			//!< WADI2[WADI2]
	XBAR_INPUT58,			//!< WADI2[WADI2]
	XBAR_INPUT59,			//!< WADI2[WADI2]
	XBAR_INPUT60,			//!< WADI2[WADI2]
	XBAR_INPUT61,			//!< WADI2[WADI2]
	XBAR_INPUT62,			//!< WADI2[WADI2]
	XBAR_INPUT63,			//!< WADI2[WADI2]
	XBAR_INPUT64			//!< WADI2[WADI2]
} XBAR_InputNum;


#ifndef DOXYGEN_PDF_IGNORE
//*****************************************************************************
//
//! The following values define the inputs to the OUTPUT XBAR using the
//! \e source parameter in XBAR_selectOutputXbarInputSource()
//
// C28X_MIGRATION: XBAR_OutputMuxConfig
//
//*****************************************************************************
typedef enum
{

	//
	//OUTPUTXBAR
	//
	XBAR_OUT_CMPSS1_CTRIPOUTH		 = 0x00,	//!CMPSS1 CTRIPOUTH
	XBAR_OUT_CMPSS1_CTRIPOUTL		 = 0x01,	//!CMPSS1 CTRIPOUTL
	XBAR_OUT_CMPSS2_CTRIPOUTH		 = 0x02,	//!CMPSS2 CTRIPOUTH
	XBAR_OUT_CMPSS2_CTRIPOUTL		 = 0x03,	//!CMPSS2 CTRIPOUTL
	XBAR_OUT_CMPSS3_CTRIPOUTH		 = 0x04,	//!CMPSS3 CTRIPOUTH
	XBAR_OUT_CMPSS3_CTRIPOUTL		 = 0x05,	//!CMPSS3 CTRIPOUTL
	XBAR_OUT_CMPSS4_CTRIPOUTH		 = 0x06,	//!CMPSS4 CTRIPOUTH
	XBAR_OUT_CMPSS4_CTRIPOUTL		 = 0x07,	//!CMPSS4 CTRIPOUTL
	XBAR_OUT_CMPSS5_CTRIPOUTH		 = 0x08,	//!CMPSS5 CTRIPOUTH
	XBAR_OUT_CMPSS5_CTRIPOUTL		 = 0x09,	//!CMPSS5 CTRIPOUTL
	XBAR_OUT_CMPSS6_CTRIPOUTH		 = 0x0A,	//!CMPSS6 CTRIPOUTH
	XBAR_OUT_CMPSS6_CTRIPOUTL		 = 0x0B,	//!CMPSS6 CTRIPOUTL
	XBAR_OUT_CMPSS7_CTRIPOUTH		 = 0x0C,	//!CMPSS7 CTRIPOUTH
	XBAR_OUT_CMPSS7_CTRIPOUTL		 = 0x0D,	//!CMPSS7 CTRIPOUTL
	XBAR_OUT_CMPSS8_CTRIPOUTH		 = 0x0E,	//!CMPSS8 CTRIPOUTH
	XBAR_OUT_CMPSS8_CTRIPOUTL		 = 0x0F,	//!CMPSS8 CTRIPOUTL
	XBAR_OUT_CMPSS9_CTRIPOUTH		 = 0x010,	//!CMPSS9 CTRIPOUTH
	XBAR_OUT_CMPSS9_CTRIPOUTL		 = 0x011,	//!CMPSS9 CTRIPOUTL
	XBAR_OUT_CMPSS10_CTRIPOUTH		 = 0x012,	//!CMPSS10 CTRIPOUTH
	XBAR_OUT_CMPSS10_CTRIPOUTL		 = 0x013,	//!CMPSS10 CTRIPOUTL
	XBAR_OUT_CMPSS11_CTRIPOUTH		 = 0x014,	//!CMPSS11 CTRIPOUTH
	XBAR_OUT_CMPSS11_CTRIPOUTL		 = 0x015,	//!CMPSS11 CTRIPOUTL
	XBAR_OUT_CMPSS12_CTRIPOUTH		 = 0x016,	//!CMPSS12 CTRIPOUTH
	XBAR_OUT_CMPSS12_CTRIPOUTL		 = 0x017,	//!CMPSS12 CTRIPOUTL
	XBAR_OUT_SD1FLT1_COMPH		 = 0x0100,	//!SD1FLT1 COMPH
	XBAR_OUT_SD1FLT1_COMPL		 = 0x0101,	//!SD1FLT1 COMPL
	XBAR_OUT_SD1FLT2_COMPH		 = 0x0102,	//!SD1FLT2 COMPH
	XBAR_OUT_SD1FLT2_COMPL		 = 0x0103,	//!SD1FLT2 COMPL
	XBAR_OUT_SD1FLT3_COMPH		 = 0x0104,	//!SD1FLT3 COMPH
	XBAR_OUT_SD1FLT3_COMPL		 = 0x0105,	//!SD1FLT3 COMPL
	XBAR_OUT_SD1FLT4_COMPH		 = 0x0106,	//!SD1FLT4 COMPH
	XBAR_OUT_SD1FLT4_COMPL		 = 0x0107,	//!SD1FLT4 COMPL
	XBAR_OUT_SD2FLT1_COMPH		 = 0x0108,	//!SD2FLT1 COMPH
	XBAR_OUT_SD2FLT1_COMPL		 = 0x0109,	//!SD2FLT1 COMPL
	XBAR_OUT_SD2FLT2_COMPH		 = 0x010A,	//!SD2FLT2 COMPH
	XBAR_OUT_SD2FLT2_COMPL		 = 0x010B,	//!SD2FLT2 COMPL
	XBAR_OUT_SD2FLT3_COMPH		 = 0x010C,	//!SD2FLT3 COMPH
	XBAR_OUT_SD2FLT3_COMPL		 = 0x010D,	//!SD2FLT3 COMPL
	XBAR_OUT_SD2FLT4_COMPH		 = 0x010E,	//!SD2FLT4 COMPH
	XBAR_OUT_SD2FLT4_COMPL		 = 0x010F,	//!SD2FLT4 COMPL
	XBAR_OUT_SD3FLT1_COMPH		 = 0x0110,	//!SD3FLT1 COMPH
	XBAR_OUT_SD3FLT1_COMPL		 = 0x0111,	//!SD3FLT1 COMPL
	XBAR_OUT_SD3FLT2_COMPH		 = 0x0112,	//!SD3FLT2 COMPH
	XBAR_OUT_SD3FLT2_COMPL		 = 0x0113,	//!SD3FLT2 COMPL
	XBAR_OUT_SD3FLT3_COMPH		 = 0x0114,	//!SD3FLT3 COMPH
	XBAR_OUT_SD3FLT3_COMPL		 = 0x0115,	//!SD3FLT3 COMPL
	XBAR_OUT_SD3FLT4_COMPH		 = 0x0116,	//!SD3FLT4 COMPH
	XBAR_OUT_SD3FLT4_COMPL		 = 0x0117,	//!SD3FLT4 COMPL
	XBAR_OUT_SD4FLT1_COMPH		 = 0x0118,	//!SD4FLT1 COMPH
	XBAR_OUT_SD4FLT1_COMPL		 = 0x0119,	//!SD4FLT1 COMPL
	XBAR_OUT_SD4FLT2_COMPH		 = 0x011A,	//!SD4FLT2 COMPH
	XBAR_OUT_SD4FLT2_COMPL		 = 0x011B,	//!SD4FLT2 COMPL
	XBAR_OUT_SD4FLT3_COMPH		 = 0x011C,	//!SD4FLT3 COMPH
	XBAR_OUT_SD4FLT3_COMPL		 = 0x011D,	//!SD4FLT3 COMPL
	XBAR_OUT_SD4FLT4_COMPH		 = 0x011E,	//!SD4FLT4 COMPH
	XBAR_OUT_SD4FLT4_COMPL		 = 0x011F,	//!SD4FLT4 COMPL
	XBAR_OUT_ADCAEVT1		 = 0x0200,	//!ADCAEVT1
	XBAR_OUT_ADCAEVT2		 = 0x0201,	//!ADCAEVT2
	XBAR_OUT_ADCAEVT3		 = 0x0202,	//!ADCAEVT3
	XBAR_OUT_ADCAEVT4		 = 0x0203,	//!ADCAEVT4
	XBAR_OUT_ADCBEVT1		 = 0x0204,	//!ADCBEVT1
	XBAR_OUT_ADCBEVT2		 = 0x0205,	//!ADCBEVT2
	XBAR_OUT_ADCBEVT3		 = 0x0206,	//!ADCBEVT3
	XBAR_OUT_ADCBEVT4		 = 0x0207,	//!ADCBEVT4
	XBAR_OUT_ADCCEVT1		 = 0x0208,	//!ADCCEVT1
	XBAR_OUT_ADCCEVT2		 = 0x0209,	//!ADCCEVT2
	XBAR_OUT_ADCCEVT3		 = 0x020A,	//!ADCCEVT3
	XBAR_OUT_ADCCEVT4		 = 0x020B,	//!ADCCEVT4
	XBAR_OUT_ADCDEVT1		 = 0x020C,	//!ADCDEVT1
	XBAR_OUT_ADCDEVT2		 = 0x020D,	//!ADCDEVT2
	XBAR_OUT_ADCDEVT3		 = 0x020E,	//!ADCDEVT3
	XBAR_OUT_ADCDEVT4		 = 0x020F,	//!ADCDEVT4
	XBAR_OUT_ADCEEVT1		 = 0x0210,	//!ADCEEVT1
	XBAR_OUT_ADCEEVT2		 = 0x0211,	//!ADCEEVT2
	XBAR_OUT_ADCEEVT3		 = 0x0212,	//!ADCEEVT3
	XBAR_OUT_ADCEEVT4		 = 0x0213,	//!ADCEEVT4
	XBAR_OUT_CPU1_ADCCHECK_EVT1		 = 0x0214,	//!CPU1 ADCCHECKEVT1
	XBAR_OUT_CPU1_ADCCHECK_EVT2		 = 0x0215,	//!CPU1 ADCCHECKEVT2
	XBAR_OUT_CPU1_ADCCHECK_EVT3		 = 0x0216,	//!CPU1 ADCCHECKEVT3
	XBAR_OUT_CPU1_ADCCHECK_EVT4		 = 0x0217,	//!CPU1 ADCCHECKEVT4
	XBAR_OUT_CPU2_ADCCHECK_EVT1		 = 0x0218,	//!CPU2 ADCCHECKEVT1
	XBAR_OUT_CPU2_ADCCHECK_EVT2		 = 0x0219,	//!CPU2 ADCCHECKEVT2
	XBAR_OUT_CPU2_ADCCHECK_EVT3		 = 0x021A,	//!CPU2 ADCCHECKEVT3
	XBAR_OUT_CPU2_ADCCHECK_EVT4		 = 0x021B,	//!CPU2 ADCCHECKEVT4
	XBAR_OUT_CPU3_ADCCHECK_EVT1		 = 0x021C,	//!CPU3 ADCCHECKEVT1
	XBAR_OUT_CPU3_ADCCHECK_EVT2		 = 0x021D,	//!CPU3 ADCCHECKEVT2
	XBAR_OUT_CPU3_ADCCHECK_EVT3		 = 0x021E,	//!CPU3 ADCCHECKEVT3
	XBAR_OUT_CPU3_ADCCHECK_EVT4		 = 0x021F,	//!CPU3 ADCCHECKEVT4
	XBAR_OUT_INPUTXBAR_INPUT1		 = 0x0300,	//!INPUTXBAR INPUT1
	XBAR_OUT_INPUTXBAR_INPUT2		 = 0x0301,	//!INPUTXBAR INPUT2
	XBAR_OUT_INPUTXBAR_INPUT3		 = 0x0302,	//!INPUTXBAR INPUT3
	XBAR_OUT_INPUTXBAR_INPUT4		 = 0x0303,	//!INPUTXBAR INPUT4
	XBAR_OUT_INPUTXBAR_INPUT5		 = 0x0304,	//!INPUTXBAR INPUT5
	XBAR_OUT_INPUTXBAR_INPUT6		 = 0x0305,	//!INPUTXBAR INPUT6
	XBAR_OUT_INPUTXBAR_INPUT7		 = 0x0306,	//!INPUTXBAR INPUT7
	XBAR_OUT_INPUTXBAR_INPUT8		 = 0x0307,	//!INPUTXBAR INPUT8
	XBAR_OUT_EQEP1_INDEX_SYNCOUT		 = 0x0400,
	XBAR_OUT_EQEP1_STROBE_SYNCOUT		 = 0x0401,
	XBAR_OUT_EQEP2_INDEX_SYNCOUT		 = 0x0402,
	XBAR_OUT_EQEP2_STROBE_SYNCOUT		 = 0x0403,
	XBAR_OUT_EQEP3_INDEX_SYNCOUT		 = 0x0404,
	XBAR_OUT_EQEP3_STROBE_SYNCOUT		 = 0x0405,
	XBAR_OUT_EQEP4_INDEX_SYNCOUT		 = 0x0406,
	XBAR_OUT_EQEP4_STROBE_SYNCOUT		 = 0x0407,
	XBAR_OUT_EQEP5_INDEX_SYNCOUT		 = 0x0408,
	XBAR_OUT_EQEP5_STROBE_SYNCOUT		 = 0x0409,
	XBAR_OUT_EQEP6_INDEX_SYNCOUT		 = 0x040A,
	XBAR_OUT_EQEP6_STROBE_SYNCOUT		 = 0x040B,
	XBAR_OUT_FSIA_RX_TRIG1		 = 0x0410,	//!FSIA RX TRIG1
	XBAR_OUT_FSIB_RX_TRIG1		 = 0x0411,	//!FSIB RX TRIG1
	XBAR_OUT_FSIC_RX_TRIG1		 = 0x0412,	//!FSIC RX TRIG1
	XBAR_OUT_FSID_RX_TRIG1		 = 0x0413,	//!FSID RX TRIG1
	XBAR_OUT_FSIA_RX_TRIG2		 = 0x0414,	//!FSIA RX TRIG2
	XBAR_OUT_FSIB_RX_TRIG2		 = 0x0415,	//!FSIB RX TRIG2
	XBAR_OUT_FSIC_RX_TRIG2		 = 0x0416,	//!FSIC RX TRIG2
	XBAR_OUT_FSID_RX_TRIG2		 = 0x0417,	//!FSID RX TRIG2
	XBAR_OUT_FSIA_RX_TRIG3		 = 0x0418,	//!FSIA RX TRIG3
	XBAR_OUT_FSIB_RX_TRIG3		 = 0x0419,	//!FSIB RX TRIG3
	XBAR_OUT_FSIC_RX_TRIG3		 = 0x041A,	//!FSIC RX TRIG3
	XBAR_OUT_FSID_RX_TRIG3		 = 0x041B,	//!FSID RX TRIG3
	XBAR_OUT_XCLKOUT		 = 0x041D,	//!XCLKOUT
	XBAR_OUT_ECATSYNC0		 = 0x041E,	//!ECAT SYNC0
	XBAR_OUT_ECATSYNC1		 = 0x041F,	//!ECAT SYNC1
	XBAR_OUT_ECAP1_OUT		 = 0x0500,	//!ECAP1 OUT
	XBAR_OUT_ECAP2_OUT		 = 0x0501,	//!ECAP2 OUT
	XBAR_OUT_ECAP3_OUT		 = 0x0502,	//!ECAP3 OUT
	XBAR_OUT_ECAP4_OUT		 = 0x0503,	//!ECAP4 OUT
	XBAR_OUT_ECAP5_OUT		 = 0x0504,	//!ECAP5 OUT
	XBAR_OUT_ECAP6_OUT		 = 0x0505,	//!ECAP6 OUT
	XBAR_OUT_ECAP1_TRIPOUT		 = 0x0508,	//!ECAP1 TRIPOUT
	XBAR_OUT_ECAP2_TRIPOUT		 = 0x0509,	//!ECAP2 TRIPOUT
	XBAR_OUT_ECAP3_TRIPOUT		 = 0x050A,	//!ECAP3 TRIPOUT
	XBAR_OUT_ECAP4_TRIPOUT		 = 0x050B,	//!ECAP4 TRIPOUT
	XBAR_OUT_ECAP5_TRIPOUT		 = 0x050C,	//!ECAP5 TRIPOUT
	XBAR_OUT_ECAP6_TRIPOUT		 = 0x050D,	//!ECAP6 TRIPOUT
	XBAR_OUT_ADCSOCA		 = 0x0510,	//!ADCSOCA
	XBAR_OUT_ADCSOCB		 = 0x0511,	//!ADCSOCB
	XBAR_OUT_ESM_GEN_EVENT		 = 0x0512,	//!ESM GEN EVENT
	XBAR_OUT_EXTSYNCOUT		 = 0x0513,	//!EXTSYNCOUT
	XBAR_OUT_EPG1_OUT0		 = 0x0514,	//!EPG1OUT0
	XBAR_OUT_EPG1_OUT1		 = 0x0515,	//!EPG1 OUT1
	XBAR_OUT_EPG1_OUT2		 = 0x0516,	//!EPG1 OUT2
	XBAR_OUT_EPG1_OUT3		 = 0x0517,	//!EPG1 OUT3
	XBAR_OUT_WADI1OUT0		 = 0x0518,	//!WADI1OUT0
	XBAR_OUT_WADI1OUT1		 = 0x0519,	//!WADI1OUT1
	XBAR_OUT_WADI1OUT2		 = 0x051A,	//!WADI1OUT2
	XBAR_OUT_WADI1OUT3		 = 0x051B,	//!WADI1OUT3
	XBAR_OUT_WADI1OUT4		 = 0x051C,	//!WADI1OUT4
	XBAR_OUT_WADI1OUT5		 = 0x051D,	//!WADI1OUT5
	XBAR_OUT_WADI1OUT6		 = 0x051E,	//!WADI1OUT6
	XBAR_OUT_WADI1OUT7		 = 0x051F,	//!WADI1OUT7
	XBAR_OUT_MCANA_FEVT0		 = 0x0600,	//!MCANA FEVT0
	XBAR_OUT_MCANA_FEVT1		 = 0x0601,	//!MCANA FEVT1
	XBAR_OUT_MCANA_FEVT2		 = 0x0602,	//!MCANA FEVT2
	XBAR_OUT_MCANB_FEVT0		 = 0x0603,	//!MCANB FEVT0
	XBAR_OUT_MCANB_FEVT1		 = 0x0604,	//!MCANB FEVT1
	XBAR_OUT_MCANB_FEVT2		 = 0x0605,	//!MCANB FEVT2
	XBAR_OUT_MCANC_FEVT0		 = 0x0606,	//!MCANC FEVT0
	XBAR_OUT_MCANC_FEVT1		 = 0x0607,	//!MCANC FEVT1
	XBAR_OUT_MCANC_FEVT2		 = 0x0608,	//!MCANC FEVT2
	XBAR_OUT_MCAND_FEVT0		 = 0x0609,	//!MCAND FEVT0
	XBAR_OUT_MCAND_FEVT1		 = 0x060A,	//!MCAND FEVT1
	XBAR_OUT_MCAND_FEVT2		 = 0x060B,	//!MCAND FEVT2
	XBAR_OUT_MCANE_FEVT0		 = 0x060C,	//!MCANE FEVT0
	XBAR_OUT_MCANE_FEVT1		 = 0x060D,	//!MCANE FEVT1
	XBAR_OUT_MCANE_FEVT2		 = 0x060E,	//!MCANE FEVT2
	XBAR_OUT_MCANF_FEVT0		 = 0x060F,	//!MCANF FEVT0
	XBAR_OUT_MCANF_FEVT1		 = 0x0610,	//!MCANF FEVT1
	XBAR_OUT_MCANF_FEVT2		 = 0x0611,	//!MCANF FEVT2
	XBAR_OUT_WADI2OUT0		 = 0x0618,	//!WADI2OUT0
	XBAR_OUT_WADI2OUT1		 = 0x0619,	//!WADI2OUT1
	XBAR_OUT_WADI2OUT2		 = 0x061A,	//!WADI2OUT2
	XBAR_OUT_WADI2OUT3		 = 0x061B,	//!WADI2OUT3
	XBAR_OUT_WADI2OUT4		 = 0x061C,	//!WADI2OUT4
	XBAR_OUT_WADI2OUT5		 = 0x061D,	//!WADI2OUT5
	XBAR_OUT_WADI2OUT6		 = 0x061E,	//!WADI2OUT6
	XBAR_OUT_WADI2OUT7		 = 0x061F,	//!WADI2OUT7
	XBAR_OUT_CLB1_OUT0		 = 0x0700,	//!CLB1 OUT0
	XBAR_OUT_CLB1_OUT1		 = 0x0701,	//!CLB1 OUT1
	XBAR_OUT_CLB1_OUT2		 = 0x0702,	//!CLB1 OUT2
	XBAR_OUT_CLB1_OUT3		 = 0x0703,	//!CLB1 OUT3
	XBAR_OUT_CLB1_OUT4		 = 0x0704,	//!CLB1 OUT4
	XBAR_OUT_CLB1_OUT5		 = 0x0705,	//!CLB1 OUT5
	XBAR_OUT_CLB1_OUT6		 = 0x0706,	//!CLB1 OUT6
	XBAR_OUT_CLB1_OUT7		 = 0x0707,	//!CLB1 OUT7
	XBAR_OUT_CLB2_OUT0		 = 0x0708,	//!CLB2 OUT0
	XBAR_OUT_CLB2_OUT1		 = 0x0709,	//!CLB2 OUT1
	XBAR_OUT_CLB2_OUT2		 = 0x070A,	//!CLB2 OUT2
	XBAR_OUT_CLB2_OUT3		 = 0x070B,	//!CLB2 OUT3
	XBAR_OUT_CLB2_OUT4		 = 0x070C,	//!CLB2 OUT4
	XBAR_OUT_CLB2_OUT5		 = 0x070D,	//!CLB2 OUT5
	XBAR_OUT_CLB2_OUT6		 = 0x070E,	//!CLB2 OUT6
	XBAR_OUT_CLB2_OUT7		 = 0x070F,	//!CLB2 OUT7
	XBAR_OUT_CLB3_OUT0		 = 0x0710,	//!CLB3 OUT0
	XBAR_OUT_CLB3_OUT1		 = 0x0711,	//!CLB3 OUT1
	XBAR_OUT_CLB3_OUT2		 = 0x0712,	//!CLB3 OUT2
	XBAR_OUT_CLB3_OUT3		 = 0x0713,	//!CLB3 OUT3
	XBAR_OUT_CLB3_OUT4		 = 0x0714,	//!CLB3 OUT4
	XBAR_OUT_CLB3_OUT5		 = 0x0715,	//!CLB3 OUT5
	XBAR_OUT_CLB3_OUT6		 = 0x0716,	//!CLB3 OUT6
	XBAR_OUT_CLB3_OUT7		 = 0x0717,	//!CLB3 OUT7
	XBAR_OUT_CLB4_OUT0		 = 0x0718,	//!CLB4 OUT0
	XBAR_OUT_CLB4_OUT1		 = 0x0719,	//!CLB4 OUT1
	XBAR_OUT_CLB4_OUT2		 = 0x071A,	//!CLB4 OUT2
	XBAR_OUT_CLB4_OUT3		 = 0x071B,	//!CLB4 OUT3
	XBAR_OUT_CLB4_OUT4		 = 0x071C,	//!CLB4 OUT4
	XBAR_OUT_CLB4_OUT5		 = 0x071D,	//!CLB4 OUT5
	XBAR_OUT_CLB4_OUT6		 = 0x071E,	//!CLB4 OUT6
	XBAR_OUT_CLB4_OUT7		 = 0x071F,	//!CLB4 OUT7
	XBAR_OUT_CLB5_OUT0		 = 0x0800,	//!CLB5 OUT0
	XBAR_OUT_CLB5_OUT1		 = 0x0801,	//!CLB5 OUT1
	XBAR_OUT_CLB5_OUT2		 = 0x0802,	//!CLB5 OUT2
	XBAR_OUT_CLB5_OUT3		 = 0x0803,	//!CLB5 OUT3
	XBAR_OUT_CLB5_OUT4		 = 0x0804,	//!CLB5 OUT4
	XBAR_OUT_CLB5_OUT5		 = 0x0805,	//!CLB5 OUT5
	XBAR_OUT_CLB5_OUT6		 = 0x0806,	//!CLB5 OUT6
	XBAR_OUT_CLB5_OUT7		 = 0x0807,	//!CLB5 OUT7
	XBAR_OUT_CLB6_OUT0		 = 0x0808,	//!CLB6 OUT0
	XBAR_OUT_CLB6_OUT1		 = 0x0809,	//!CLB6 OUT1
	XBAR_OUT_CLB6_OUT2		 = 0x080A,	//!CLB6 OUT2
	XBAR_OUT_CLB6_OUT3		 = 0x080B,	//!CLB6 OUT3
	XBAR_OUT_CLB6_OUT4		 = 0x080C,	//!CLB6 OUT4
	XBAR_OUT_CLB6_OUT5		 = 0x080D,	//!CLB6 OUT5
	XBAR_OUT_CLB6_OUT6		 = 0x080E,	//!CLB6 OUT6
	XBAR_OUT_CLB6_OUT7		 = 0x080F,	//!CLB6 OUT7
	XBAR_OUT_CLBXBAR1		 = 0x0900,	//!CLBXBAR1
	XBAR_OUT_CLBXBAR2		 = 0x0901,	//!CLBXBAR2
	XBAR_OUT_CLBXBAR3		 = 0x0902,	//!CLBXBAR3
	XBAR_OUT_CLBXBAR4		 = 0x0903,	//!CLBXBAR4
	XBAR_OUT_CLBXBAR5		 = 0x0904,	//!CLBXBAR5
	XBAR_OUT_CLBXBAR6		 = 0x0905,	//!CLBXBAR6
	XBAR_OUT_CLBXBAR7		 = 0x0906,	//!CLBXBAR7
	XBAR_OUT_CLBXBAR8		 = 0x0907,	//!CLBXBAR8
	XBAR_OUT_ADCA_EXTMUXSEL0		 = 0x0908,	//!ADCA EXTMUXSEL0
	XBAR_OUT_ADCA_EXTMUXSEL1		 = 0x0909,	//!ADCA EXTMUXSEL1
	XBAR_OUT_ADCA_EXTMUXSEL2		 = 0x090A,	//!ADCA EXTMUXSEL2
	XBAR_OUT_ADCA_EXTMUXSEL3		 = 0x090B,	//!ADCA EXTMUXSEL3
	XBAR_OUT_ADCB_EXTMUXSEL0		 = 0x090C,	//!ADCB EXTMUXSEL0
	XBAR_OUT_ADCB_EXTMUXSEL1		 = 0x090D,	//!ADCB EXTMUXSEL1
	XBAR_OUT_ADCB_EXTMUXSEL2		 = 0x090E,	//!ADCB EXTMUXSEL2
	XBAR_OUT_ADCB_EXTMUXSEL3		 = 0x090F,	//!ADCB EXTMUXSEL3
	XBAR_OUT_ADCC_EXTMUXSEL0		 = 0x0910,	//!ADCC EXTMUXSEL0
	XBAR_OUT_ADCC_EXTMUXSEL1		 = 0x0911,	//!ADCC EXTMUXSEL1
	XBAR_OUT_ADCC_EXTMUXSEL2		 = 0x0912,	//!ADCC EXTMUXSEL2
	XBAR_OUT_ADCC_EXTMUXSEL3		 = 0x0913,	//!ADCC EXTMUXSEL3
	XBAR_OUT_ADCD_EXTMUXSEL0		 = 0x0914,	//!ADCD EXTMUXSEL0
	XBAR_OUT_ADCD_EXTMUXSEL1		 = 0x0915,	//!ADCD EXTMUXSEL1
	XBAR_OUT_ADCD_EXTMUXSEL2		 = 0x0916,	//!ADCD EXTMUXSEL2
	XBAR_OUT_ADCD_EXTMUXSEL3		 = 0x0917,	//!ADCD EXTMUXSEL3
	XBAR_OUT_ADCE_EXTMUXSEL0		 = 0x0918,	//!ADCE EXTMUXSEL0
	XBAR_OUT_ADCE_EXTMUXSEL1		 = 0x0919,	//!ADCE EXTMUXSEL1
	XBAR_OUT_ADCE_EXTMUXSEL2		 = 0x091A,	//!ADCE EXTMUXSEL2
	XBAR_OUT_ADCE_EXTMUXSEL3		 = 0x091B	//!ADCE EXTMUXSEL3
} XBAR_OutputXbarInputSource;


//*****************************************************************************
//
//! The following values define the \e source parameter for
//! XBAR_selectEpwmXbarInputSource().
//
// C28X_MIGRATION: XBAR_EPWMMuxConfig
//
//*****************************************************************************
typedef enum
{
	XBAR_EPWM_CMPSS1_CTRIPH		 = 0x00,	//!CMPSS1 CTRIPH
	XBAR_EPWM_CMPSS1_CTRIPL		 = 0x01,	//!CMPSS1 CTRIPL
	XBAR_EPWM_CMPSS2_CTRIPH		 = 0x02,	//!CMPSS2 CTRIPH
	XBAR_EPWM_CMPSS2_CTRIPL		 = 0x03,	//!CMPSS2 CTRIPL
	XBAR_EPWM_CMPSS3_CTRIPH		 = 0x04,	//!CMPSS3 CTRIPH
	XBAR_EPWM_CMPSS3_CTRIPL		 = 0x05,	//!CMPSS3 CTRIPL
	XBAR_EPWM_CMPSS4_CTRIPH		 = 0x06,	//!CMPSS4 CTRIPH
	XBAR_EPWM_CMPSS4_CTRIPL		 = 0x07,	//!CMPSS4 CTRIPL
	XBAR_EPWM_CMPSS5_CTRIPH		 = 0x08,	//!CMPSS5 CTRIPH
	XBAR_EPWM_CMPSS5_CTRIPL		 = 0x09,	//!CMPSS5 CTRIPL
	XBAR_EPWM_CMPSS6_CTRIPH		 = 0x0A,	//!CMPSS6 CTRIPH
	XBAR_EPWM_CMPSS6_CTRIPL		 = 0x0B,	//!CMPSS6 CTRIPL
	XBAR_EPWM_CMPSS7_CTRIPH		 = 0x0C,	//!CMPSS7 CTRIPH
	XBAR_EPWM_CMPSS7_CTRIPL		 = 0x0D,	//!CMPSS7 CTRIPL
	XBAR_EPWM_CMPSS8_CTRIPH		 = 0x0E,	//!CMPSS8 CTRIPH
	XBAR_EPWM_CMPSS8_CTRIPL		 = 0x0F,	//!CMPSS8 CTRIPL
	XBAR_EPWM_CMPSS9_CTRIPH		 = 0x010,	//!CMPSS9 CTRIPH
	XBAR_EPWM_CMPSS9_CTRIPL		 = 0x011,	//!CMPSS9 CTRIPL
	XBAR_EPWM_CMPSS10_CTRIPH		 = 0x012,	//!CMPSS10 CTRIPH
	XBAR_EPWM_CMPSS10_CTRIPL		 = 0x013,	//!CMPSS10 CTRIPL
	XBAR_EPWM_CMPSS11_CTRIPH		 = 0x014,	//!CMPSS11 CTRIPH
	XBAR_EPWM_CMPSS11_CTRIPL		 = 0x015,	//!CMPSS11 CTRIPL
	XBAR_EPWM_CMPSS12_CTRIPH		 = 0x016,	//!CMPSS12 CTRIPH
	XBAR_EPWM_CMPSS12_CTRIPL		 = 0x017,	//!CMPSS12 CTRIPL
	XBAR_EPWM_SD1FLT1_COMPH		 = 0x0100,	//!SD1FLT1 COMPH
	XBAR_EPWM_SD1FLT1_COMPL		 = 0x0101,	//!SD1FLT1 COMPL
	XBAR_EPWM_SD1FLT2_COMPH		 = 0x0102,	//!SD1FLT2 COMPH
	XBAR_EPWM_SD1FLT2_COMPL		 = 0x0103,	//!SD1FLT2 COMPL
	XBAR_EPWM_SD1FLT3_COMPH		 = 0x0104,	//!SD1FLT3 COMPH
	XBAR_EPWM_SD1FLT3_COMPL		 = 0x0105,	//!SD1FLT3 COMPL
	XBAR_EPWM_SD1FLT4_COMPH		 = 0x0106,	//!SD1FLT4 COMPH
	XBAR_EPWM_SD1FLT4_COMPL		 = 0x0107,	//!SD1FLT4 COMPL
	XBAR_EPWM_SD2FLT1_COMPH		 = 0x0108,	//!SD2FLT1 COMPH
	XBAR_EPWM_SD2FLT1_COMPL		 = 0x0109,	//!SD2FLT1 COMPL
	XBAR_EPWM_SD2FLT2_COMPH		 = 0x010A,	//!SD2FLT2 COMPH
	XBAR_EPWM_SD2FLT2_COMPL		 = 0x010B,	//!SD2FLT2 COMPL
	XBAR_EPWM_SD2FLT3_COMPH		 = 0x010C,	//!SD2FLT3 COMPH
	XBAR_EPWM_SD2FLT3_COMPL		 = 0x010D,	//!SD2FLT3 COMPL
	XBAR_EPWM_SD2FLT4_COMPH		 = 0x010E,	//!SD2FLT4 COMPH
	XBAR_EPWM_SD2FLT4_COMPL		 = 0x010F,	//!SD2FLT4 COMPL
	XBAR_EPWM_SD3FLT1_COMPH		 = 0x0110,	//!SD3FLT1 COMPH
	XBAR_EPWM_SD3FLT1_COMPL		 = 0x0111,	//!SD3FLT1 COMPL
	XBAR_EPWM_SD3FLT2_COMPH		 = 0x0112,	//!SD3FLT2 COMPH
	XBAR_EPWM_SD3FLT2_COMPL		 = 0x0113,	//!SD3FLT2 COMPL
	XBAR_EPWM_SD3FLT3_COMPH		 = 0x0114,	//!SD3FLT3 COMPH
	XBAR_EPWM_SD3FLT3_COMPL		 = 0x0115,	//!SD3FLT3 COMPL
	XBAR_EPWM_SD3FLT4_COMPH		 = 0x0116,	//!SD3FLT4 COMPH
	XBAR_EPWM_SD3FLT4_COMPL		 = 0x0117,	//!SD3FLT4 COMPL
	XBAR_EPWM_SD4FLT1_COMPH		 = 0x0118,	//!SD4FLT1 COMPH
	XBAR_EPWM_SD4FLT1_COMPL		 = 0x0119,	//!SD4FLT1 COMPL
	XBAR_EPWM_SD4FLT2_COMPH		 = 0x011A,	//!SD4FLT2 COMPH
	XBAR_EPWM_SD4FLT2_COMPL		 = 0x011B,	//!SD4FLT2 COMPL
	XBAR_EPWM_SD4FLT3_COMPH		 = 0x011C,	//!SD4FLT3 COMPH
	XBAR_EPWM_SD4FLT3_COMPL		 = 0x011D,	//!SD4FLT3 COMPL
	XBAR_EPWM_SD4FLT4_COMPH		 = 0x011E,	//!SD4FLT4 COMPH
	XBAR_EPWM_SD4FLT4_COMPL		 = 0x011F,	//!SD4FLT4 COMPL
	XBAR_EPWM_ADCAEVT1		 = 0x0200,	//!ADCAEVT1
	XBAR_EPWM_ADCAEVT2		 = 0x0201,	//!ADCAEVT2
	XBAR_EPWM_ADCAEVT3		 = 0x0202,	//!ADCAEVT3
	XBAR_EPWM_ADCAEVT4		 = 0x0203,	//!ADCAEVT4
	XBAR_EPWM_ADCBEVT1		 = 0x0204,	//!ADCBEVT1
	XBAR_EPWM_ADCBEVT2		 = 0x0205,	//!ADCBEVT2
	XBAR_EPWM_ADCBEVT3		 = 0x0206,	//!ADCBEVT3
	XBAR_EPWM_ADCBEVT4		 = 0x0207,	//!ADCBEVT4
	XBAR_EPWM_ADCCEVT1		 = 0x0208,	//!ADCCEVT1
	XBAR_EPWM_ADCCEVT2		 = 0x0209,	//!ADCCEVT2
	XBAR_EPWM_ADCCEVT3		 = 0x020A,	//!ADCCEVT3
	XBAR_EPWM_ADCCEVT4		 = 0x020B,	//!ADCCEVT4
	XBAR_EPWM_ADCDEVT1		 = 0x020C,	//!ADCDEVT1
	XBAR_EPWM_ADCDEVT2		 = 0x020D,	//!ADCDEVT2
	XBAR_EPWM_ADCDEVT3		 = 0x020E,	//!ADCDEVT3
	XBAR_EPWM_ADCDEVT4		 = 0x020F,	//!ADCDEVT4
	XBAR_EPWM_ADCEEVT1		 = 0x0210,	//!ADCEEVT1
	XBAR_EPWM_ADCEEVT2		 = 0x0211,	//!ADCEEVT2
	XBAR_EPWM_ADCEEVT3		 = 0x0212,	//!ADCEEVT3
	XBAR_EPWM_ADCEEVT4		 = 0x0213,	//!ADCEEVT4
	XBAR_EPWM_CPU1_ADCCHECK_EVT1		 = 0x0214,	//!CPU1 ADCCHECKEVT1
	XBAR_EPWM_CPU1_ADCCHECK_EVT2		 = 0x0215,	//!CPU1 ADCCHECKEVT2
	XBAR_EPWM_CPU1_ADCCHECK_EVT3		 = 0x0216,	//!CPU1 ADCCHECKEVT3
	XBAR_EPWM_CPU1_ADCCHECK_EVT4		 = 0x0217,	//!CPU1 ADCCHECKEVT4
	XBAR_EPWM_CPU2_ADCCHECK_EVT1		 = 0x0218,	//!CPU2 ADCCHECKEVT1
	XBAR_EPWM_CPU2_ADCCHECK_EVT2		 = 0x0219,	//!CPU2 ADCCHECKEVT2
	XBAR_EPWM_CPU2_ADCCHECK_EVT3		 = 0x021A,	//!CPU2 ADCCHECKEVT3
	XBAR_EPWM_CPU2_ADCCHECK_EVT4		 = 0x021B,	//!CPU2 ADCCHECKEVT4
	XBAR_EPWM_CPU3_ADCCHECK_EVT1		 = 0x021C,	//!CPU3 ADCCHECKEVT1
	XBAR_EPWM_CPU3_ADCCHECK_EVT2		 = 0x021D,	//!CPU3 ADCCHECKEVT2
	XBAR_EPWM_CPU3_ADCCHECK_EVT3		 = 0x021E,	//!CPU3 ADCCHECKEVT3
	XBAR_EPWM_CPU3_ADCCHECK_EVT4		 = 0x021F,	//!CPU3 ADCCHECKEVT4
	XBAR_EPWM_INPUTXBAR_INPUT1		 = 0x0300,	//!INPUTXBAR INPUT1
	XBAR_EPWM_INPUTXBAR_INPUT2		 = 0x0301,	//!INPUTXBAR INPUT2
	XBAR_EPWM_INPUTXBAR_INPUT3		 = 0x0302,	//!INPUTXBAR INPUT3
	XBAR_EPWM_INPUTXBAR_INPUT4		 = 0x0303,	//!INPUTXBAR INPUT4
	XBAR_EPWM_INPUTXBAR_INPUT5		 = 0x0304,	//!INPUTXBAR INPUT5
	XBAR_EPWM_INPUTXBAR_INPUT6		 = 0x0305,	//!INPUTXBAR INPUT6
	XBAR_EPWM_INPUTXBAR_INPUT7		 = 0x0306,	//!INPUTXBAR INPUT7
	XBAR_EPWM_INPUTXBAR_INPUT8		 = 0x0307,	//!INPUTXBAR INPUT8
	XBAR_EPWM_INPUTXBAR_INPUT9		 = 0x0308,	//!INPUTXBAR INPUT9
	XBAR_EPWM_INPUTXBAR_INPUT10		 = 0x0309,	//!INPUTXBAR INPUT10
	XBAR_EPWM_INPUTXBAR_INPUT11		 = 0x030A,	//!INPUTXBAR INPUT11
	XBAR_EPWM_INPUTXBAR_INPUT12		 = 0x030B,	//!INPUTXBAR INPUT12
	XBAR_EPWM_INPUTXBAR_INPUT13		 = 0x030C,	//!INPUTXBAR INPUT13
	XBAR_EPWM_INPUTXBAR_INPUT14		 = 0x030D,	//!INPUTXBAR INPUT14
	XBAR_EPWM_INPUTXBAR_INPUT15		 = 0x030E,	//!INPUTXBAR INPUT15
	XBAR_EPWM_INPUTXBAR_INPUT16		 = 0x030F,	//!INPUTXBAR INPUT16
	XBAR_EPWM_INPUTXBAR_INPUT17		 = 0x0310,	//!INPUTXBAR INPUT17
	XBAR_EPWM_INPUTXBAR_INPUT18		 = 0x0311,	//!INPUTXBAR INPUT18
	XBAR_EPWM_INPUTXBAR_INPUT19		 = 0x0312,	//!INPUTXBAR INPUT19
	XBAR_EPWM_INPUTXBAR_INPUT20		 = 0x0313,	//!INPUTXBAR INPUT20
	XBAR_EPWM_INPUTXBAR_INPUT21		 = 0x0314,	//!INPUTXBAR INPUT21
	XBAR_EPWM_INPUTXBAR_INPUT22		 = 0x0315,	//!INPUTXBAR INPUT22
	XBAR_EPWM_INPUTXBAR_INPUT23		 = 0x0316,	//!INPUTXBAR INPUT23
	XBAR_EPWM_INPUTXBAR_INPUT24		 = 0x0317,	//!INPUTXBAR INPUT24
	XBAR_EPWM_INPUTXBAR_INPUT25		 = 0x0318,	//!INPUTXBAR INPUT25
	XBAR_EPWM_INPUTXBAR_INPUT26		 = 0x0319,	//!INPUTXBAR INPUT26
	XBAR_EPWM_INPUTXBAR_INPUT27		 = 0x031A,	//!INPUTXBAR INPUT27
	XBAR_EPWM_INPUTXBAR_INPUT28		 = 0x031B,	//!INPUTXBAR INPUT28
	XBAR_EPWM_INPUTXBAR_INPUT29		 = 0x031C,	//!INPUTXBAR INPUT29
	XBAR_EPWM_INPUTXBAR_INPUT30		 = 0x031D,	//!INPUTXBAR INPUT30
	XBAR_EPWM_INPUTXBAR_INPUT31		 = 0x031E,	//!INPUTXBAR INPUT31
	XBAR_EPWM_INPUTXBAR_INPUT32		 = 0x031F,	//!INPUTXBAR INPUT32
	XBAR_EPWM_CLB1_OUT4		 = 0x0400,	//!CLB1 OUT4
	XBAR_EPWM_CLB1_OUT5		 = 0x0401,	//!CLB1 OUT5
	XBAR_EPWM_CLB2_OUT4		 = 0x0402,	//!CLB2 OUT4
	XBAR_EPWM_CLB2_OUT5		 = 0x0403,	//!CLB2 OUT5
	XBAR_EPWM_CLB3_OUT4		 = 0x0404,	//!CLB3 OUT4
	XBAR_EPWM_CLB3_OUT5		 = 0x0405,	//!CLB3 OUT5
	XBAR_EPWM_CLB4_OUT4		 = 0x0406,	//!CLB4 OUT4
	XBAR_EPWM_CLB4_OUT5		 = 0x0407,	//!CLB4 OUT5
	XBAR_EPWM_CLB5_OUT4		 = 0x0408,	//!CLB5 OUT4
	XBAR_EPWM_CLB5_OUT5		 = 0x0409,	//!CLB5 OUT5
	XBAR_EPWM_CLB6_OUT4		 = 0x040A,	//!CLB6 OUT4
	XBAR_EPWM_CLB6_OUT5		 = 0x040B,	//!CLB6 OUT5
	XBAR_EPWM_FSIA_RX_TRIG1		 = 0x0410,	//!FSIA RX TRIG1
	XBAR_EPWM_FSIB_RX_TRIG1		 = 0x0411,	//!FSIB RX TRIG1
	XBAR_EPWM_FSIC_RX_TRIG1		 = 0x0412,	//!FSIC RX TRIG1
	XBAR_EPWM_FSID_RX_TRIG1		 = 0x0413,	//!FSID RX TRIG1
	XBAR_EPWM_ECAT_SYNC0		 = 0x041E,	//!ECAT SYNC0
	XBAR_EPWM_ECAT_SYNC1		 = 0x041F,	//!ECAT SYNC1
	XBAR_EPWM_ECAP1_OUT		 = 0x0500,	//!ECAP1 OUT
	XBAR_EPWM_ECAP2_OUT		 = 0x0501,	//!ECAP2 OUT
	XBAR_EPWM_ECAP3_OUT		 = 0x0502,	//!ECAP3 OUT
	XBAR_EPWM_ECAP4_OUT		 = 0x0503,	//!ECAP4 OUT
	XBAR_EPWM_ECAP5_OUT		 = 0x0504,	//!ECAP5 OUT
	XBAR_EPWM_ECAP6_OUT		 = 0x0505,	//!ECAP6 OUT
	XBAR_EPWM_ECAP1_TRIPOUT		 = 0x0508,	//!ECAP1 TRIPOUT
	XBAR_EPWM_ECAP2_TRIPOUT		 = 0x0509,	//!ECAP2 TRIPOUT
	XBAR_EPWM_ECAP3_TRIPOUT		 = 0x050A,	//!ECAP3 TRIPOUT
	XBAR_EPWM_ECAP4_TRIPOUT		 = 0x050B,	//!ECAP4 TRIPOUT
	XBAR_EPWM_ECAP5_TRIPOUT		 = 0x050C,	//!ECAP5 TRIPOUT
	XBAR_EPWM_ECAP6_TRIPOUT		 = 0x050D,	//!ECAP6 TRIPOUT
	XBAR_EPWM_ADCSOCA		 = 0x0510,	//!ADCSOCA
	XBAR_EPWM_ADCSOCB		 = 0x0511,	//!ADCSOCB
	XBAR_EPWM_ESM_GEN_EVENT		 = 0x0512,	//!ESM GEN EVENT
	XBAR_EPWM_EXTSYNCOUT		 = 0x0513,	//!EXTSYNCOUT
	XBAR_EPWM_WADI1_ERROR_BUS_O_0		 = 0x0514,	//!WADI1 ERROR BUS O 0
	XBAR_EPWM_WADI1_ERROR_BUS_O_1		 = 0x0515,	//!WADI1 ERROR BUS O 1
	XBAR_EPWM_WADI1_ERROR_BUS_O_2		 = 0x0516,	//!WADI1 ERROR BUS O 2
	XBAR_EPWM_WADI1_ERROR_BUS_O_3		 = 0x0517,	//!WADI1 ERROR BUS O 3
	XBAR_EPWM_WADI1_ERROR_BUS_O_4		 = 0x0518,	//!WADI1 ERROR BUS O 4
	XBAR_EPWM_WADI1_ERROR_BUS_O_5		 = 0x0519,	//!WADI1 ERROR BUS O 5
	XBAR_EPWM_WADI1_ERROR_BUS_O_6		 = 0x051A,	//!WADI1 ERROR BUS O 6
	XBAR_EPWM_WADI1_ERROR_BUS_O_7		 = 0x051B,	//!WADI1 ERROR BUS O 7
	XBAR_EPWM_WADI1_ERROR_BUS_O_8		 = 0x051C,	//!WADI1 ERROR BUS O 8
	XBAR_EPWM_WADI1_ERROR_BUS_O_9		 = 0x051D,	//!WADI1 ERROR BUS O 9
	XBAR_EPWM_WADI1_ERROR_BUS_O_10		 = 0x051E,	//!WADI1 ERROR BUS O 10
	XBAR_EPWM_WADI1_ERROR_BUS_O_11		 = 0x051F,	//!WADI1 ERROR BUS O 11
	XBAR_EPWM_MCANA_FEVT0		 = 0x0600,	//!MCANA FEVT0
	XBAR_EPWM_MCANA_FEVT1		 = 0x0601,	//!MCANA FEVT1
	XBAR_EPWM_MCANA_FEVT2		 = 0x0602,	//!MCANA FEVT2
	XBAR_EPWM_MCANB_FEVT0		 = 0x0603,	//!MCANB FEVT0
	XBAR_EPWM_MCANB_FEVT1		 = 0x0604,	//!MCANB FEVT1
	XBAR_EPWM_MCANB_FEVT2		 = 0x0605,	//!MCANB FEVT2
	XBAR_EPWM_MCANC_FEVT0		 = 0x0606,	//!MCANC FEVT0
	XBAR_EPWM_MCANC_FEVT1		 = 0x0607,	//!MCANC FEVT1
	XBAR_EPWM_MCANC_FEVT2		 = 0x0608,	//!MCANC FEVT2
	XBAR_EPWM_MCAND_FEVT0		 = 0x0609,	//!MCAND FEVT0
	XBAR_EPWM_MCAND_FEVT1		 = 0x060A,	//!MCAND FEVT1
	XBAR_EPWM_MCAND_FEVT2		 = 0x060B,	//!MCAND FEVT2
	XBAR_EPWM_MCANE_FEVT0		 = 0x060C,	//!MCANE FEVT0
	XBAR_EPWM_MCANE_FEVT1		 = 0x060D,	//!MCANE FEVT1
	XBAR_EPWM_MCANE_FEVT2		 = 0x060E,	//!MCANE FEVT2
	XBAR_EPWM_MCANF_FEVT0		 = 0x060F,	//!MCANF FEVT0
	XBAR_EPWM_MCANF_FEVT1		 = 0x0610,	//!MCANF FEVT1
	XBAR_EPWM_MCANF_FEVT2		 = 0x0611,	//!MCANF FEVT2
	XBAR_EPWM_WADI2_ERROR_BUS_O_0		 = 0x0614,	//!WADI2 ERROR BUS O 0
	XBAR_EPWM_WADI2_ERROR_BUS_O_1		 = 0x0615,	//!WADI2 ERROR BUS O 1
	XBAR_EPWM_WADI2_ERROR_BUS_O_2		 = 0x0616,	//!WADI2 ERROR BUS O 2
	XBAR_EPWM_WADI2_ERROR_BUS_O_3		 = 0x0617,	//!WADI2 ERROR BUS O 3
	XBAR_EPWM_WADI2_ERROR_BUS_O_4		 = 0x0618,	//!WADI2 ERROR BUS O 4
	XBAR_EPWM_WADI2_ERROR_BUS_O_5		 = 0x0619,	//!WADI2 ERROR BUS O 5
	XBAR_EPWM_WADI2_ERROR_BUS_O_6		 = 0x061A,	//!WADI2 ERROR BUS O 6
	XBAR_EPWM_WADI2_ERROR_BUS_O_7		 = 0x061B,	//!WADI2 ERROR BUS O 7
	XBAR_EPWM_WADI2_ERROR_BUS_O_8		 = 0x061C,	//!WADI2 ERROR BUS O 8
	XBAR_EPWM_WADI2_ERROR_BUS_O_9		 = 0x061D,	//!WADI2 ERROR BUS O 9
	XBAR_EPWM_WADI2_ERROR_BUS_O_10		 = 0x061E,	//!WADI2 ERROR BUS O 10
	XBAR_EPWM_WADI2_ERROR_BUS_O_11		 = 0x061F,	//!WADI2 ERROR BUS O 11
	XBAR_EPWM_EPWM1_TRIPOUT		 = 0x0700,	//!EPWM1 TRIPOUT
	XBAR_EPWM_EPWM2_TRIPOUT		 = 0x0701,	//!EPWM2 TRIPOUT
	XBAR_EPWM_EPWM3_TRIPOUT		 = 0x0702,	//!EPWM3 TRIPOUT
	XBAR_EPWM_EPWM4_TRIPOUT		 = 0x0703,	//!EPWM4 TRIPOUT
	XBAR_EPWM_EPWM5_TRIPOUT		 = 0x0704,	//!EPWM5 TRIPOUT
	XBAR_EPWM_EPWM6_TRIPOUT		 = 0x0705,	//!EPWM6 TRIPOUT
	XBAR_EPWM_EPWM7_TRIPOUT		 = 0x0706,	//!EPWM7 TRIPOUT
	XBAR_EPWM_EPWM8_TRIPOUT		 = 0x0707,	//!EPWM8 TRIPOUT
	XBAR_EPWM_EPWM9_TRIPOUT		 = 0x0708,	//!EPWM9 TRIPOUT
	XBAR_EPWM_EPWM10_TRIPOUT		 = 0x0709,	//!EPWM10 TRIPOUT
	XBAR_EPWM_EPWM11_TRIPOUT		 = 0x070A,	//!EPWM11 TRIPOUT
	XBAR_EPWM_EPWM12_TRIPOUT		 = 0x070B,	//!EPWM12 TRIPOUT
	XBAR_EPWM_EPWM13_TRIPOUT		 = 0x070C,	//!EPWM13 TRIPOUT
	XBAR_EPWM_EPWM14_TRIPOUT		 = 0x070D,	//!EPWM14 TRIPOUT
	XBAR_EPWM_EPWM15_TRIPOUT		 = 0x070E,	//!EPWM15 TRIPOUT
	XBAR_EPWM_EPWM16_TRIPOUT		 = 0x070F,	//!EPWM16 TRIPOUT
	XBAR_EPWM_EPWM17_TRIPOUT		 = 0x0710,	//!EPWM17 TRIPOUT
	XBAR_EPWM_EPWM18_TRIPOUT		 = 0x0711,	//!EPWM18 TRIPOUT
	XBAR_EPWM_EPWM1_DE_DEMONTRIP		 = 0x0800,	//!EPWM1 DE DEMONTRIP
	XBAR_EPWM_EPWM2_DE_DEMONTRIP		 = 0x0801,	//!EPWM2 DE DEMONTRIP
	XBAR_EPWM_EPWM3_DE_DEMONTRIP		 = 0x0802,	//!EPWM3 DE DEMONTRIP
	XBAR_EPWM_EPWM4_DE_DEMONTRIP		 = 0x0803,	//!EPWM4 DE DEMONTRIP
	XBAR_EPWM_EPWM5_DE_DEMONTRIP		 = 0x0804,	//!EPWM5 DE DEMONTRIP
	XBAR_EPWM_EPWM6_DE_DEMONTRIP		 = 0x0805,	//!EPWM6 DE DEMONTRIP
	XBAR_EPWM_EPWM7_DE_DEMONTRIP		 = 0x0806,	//!EPWM7 DE DEMONTRIP
	XBAR_EPWM_EPWM8_DE_DEMONTRIP		 = 0x0807,	//!EPWM8 DE DEMONTRIP
	XBAR_EPWM_EPWM9_DE_DEMONTRIP		 = 0x0808,	//!EPWM9 DE DEMONTRIP
	XBAR_EPWM_EPWM10_DE_DEMONTRIP		 = 0x0809,	//!EPWM10 DE DEMONTRIP
	XBAR_EPWM_EPWM11_DE_DEMONTRIP		 = 0x080A,	//!EPWM11 DE DEMONTRIP
	XBAR_EPWM_EPWM12_DE_DEMONTRIP		 = 0x080B,	//!EPWM12 DE DEMONTRIP
	XBAR_EPWM_EPWM13_DE_DEMONTRIP		 = 0x080C,	//!EPWM13 DE DEMONTRIP
	XBAR_EPWM_EPWM14_DE_DEMONTRIP		 = 0x080D,	//!EPWM14 DE DEMONTRIP
	XBAR_EPWM_EPWM15_DE_DEMONTRIP		 = 0x080E,	//!EPWM15 DE DEMONTRIP
	XBAR_EPWM_EPWM16_DE_DEMONTRIP		 = 0x080F,	//!EPWM16 DE DEMONTRIP
	XBAR_EPWM_EPWM17_DE_DEMONTRIP		 = 0x0810,	//!EPWM17 DE DEMONTRIP
	XBAR_EPWM_EPWM18_DE_DEMONTRIP		 = 0x0811,	//!EPWM18 DE DEMONTRIP
	XBAR_EPWM_EPWM1_DE_ACTIVE		 = 0x0900,	//!EPWM1 DE ACTIVE
	XBAR_EPWM_EPWM2_DE_ACTIVE		 = 0x0901,	//!EPWM2 DE ACTIVE
	XBAR_EPWM_EPWM3_DE_ACTIVE		 = 0x0902,	//!EPWM3 DE ACTIVE
	XBAR_EPWM_EPWM4_DE_ACTIVE		 = 0x0903,	//!EPWM4 DE ACTIVE
	XBAR_EPWM_EPWM5_DE_ACTIVE		 = 0x0904,	//!EPWM5 DE ACTIVE
	XBAR_EPWM_EPWM6_DE_ACTIVE		 = 0x0905,	//!EPWM6 DE ACTIVE
	XBAR_EPWM_EPWM7_DE_ACTIVE		 = 0x0906,	//!EPWM7 DE ACTIVE
	XBAR_EPWM_EPWM8_DE_ACTIVE		 = 0x0907,	//!EPWM8 DE ACTIVE
	XBAR_EPWM_EPWM9_DE_ACTIVE		 = 0x0908,	//!EPWM9 DE ACTIVE
	XBAR_EPWM_EPWM10_DE_ACTIVE		 = 0x0909,	//!EPWM10 DE ACTIVE
	XBAR_EPWM_EPWM11_DE_ACTIVE		 = 0x090A,	//!EPWM11 DE ACTIVE
	XBAR_EPWM_EPWM12_DE_ACTIVE		 = 0x090B,	//!EPWM12 DE ACTIVE
	XBAR_EPWM_EPWM13_DE_ACTIVE		 = 0x090C,	//!EPWM13 DE ACTIVE
	XBAR_EPWM_EPWM14_DE_ACTIVE		 = 0x090D,	//!EPWM14 DE ACTIVE
	XBAR_EPWM_EPWM15_DE_ACTIVE		 = 0x090E,	//!EPWM15 DE ACTIVE
	XBAR_EPWM_EPWM16_DE_ACTIVE		 = 0x090F,	//!EPWM16 DE ACTIVE
	XBAR_EPWM_EPWM17_DE_ACTIVE		 = 0x0910,	//!EPWM17 DE ACTIVE
	XBAR_EPWM_EPWM18_DE_ACTIVE		 = 0x0911	//!EPWM18 DE ACTIVE
} XBAR_EpwmXbarInputSource;


//*****************************************************************************
//
//! The following values define the \e source parameter for
//! XBAR_selectClbXbarInputSource().
//
// C28X_MIGRATION: XBAR_CLBMuxConfig
//
//*****************************************************************************
typedef enum
{
	XBAR_CLB_CMPSS1_CTRIPH		 = 0x00,	//!CMPSS1 CTRIPH
	XBAR_CLB_CMPSS1_CTRIPL		 = 0x01,	//!CMPSS1 CTRIPL
	XBAR_CLB_CMPSS2_CTRIPH		 = 0x02,	//!CMPSS2 CTRIPH
	XBAR_CLB_CMPSS2_CTRIPL		 = 0x03,	//!CMPSS2 CTRIPL
	XBAR_CLB_CMPSS3_CTRIPH		 = 0x04,	//!CMPSS3 CTRIPH
	XBAR_CLB_CMPSS3_CTRIPL		 = 0x05,	//!CMPSS3 CTRIPL
	XBAR_CLB_CMPSS4_CTRIPH		 = 0x06,	//!CMPSS4 CTRIPH
	XBAR_CLB_CMPSS4_CTRIPL		 = 0x07,	//!CMPSS4 CTRIPL
	XBAR_CLB_CMPSS5_CTRIPH		 = 0x08,	//!CMPSS5 CTRIPH
	XBAR_CLB_CMPSS5_CTRIPL		 = 0x09,	//!CMPSS5 CTRIPL
	XBAR_CLB_CMPSS6_CTRIPH		 = 0x0A,	//!CMPSS6 CTRIPH
	XBAR_CLB_CMPSS6_CTRIPL		 = 0x0B,	//!CMPSS6 CTRIPL
	XBAR_CLB_CMPSS7_CTRIPH		 = 0x0C,	//!CMPSS7 CTRIPH
	XBAR_CLB_CMPSS7_CTRIPL		 = 0x0D,	//!CMPSS7 CTRIPL
	XBAR_CLB_CMPSS8_CTRIPH		 = 0x0E,	//!CMPSS8 CTRIPH
	XBAR_CLB_CMPSS8_CTRIPL		 = 0x0F,	//!CMPSS8 CTRIPL
	XBAR_CLB_CMPSS9_CTRIPH		 = 0x010,	//!CMPSS9 CTRIPH
	XBAR_CLB_CMPSS9_CTRIPL		 = 0x011,	//!CMPSS9 CTRIPL
	XBAR_CLB_CMPSS10_CTRIPH		 = 0x012,	//!CMPSS10 CTRIPH
	XBAR_CLB_CMPSS10_CTRIPL		 = 0x013,	//!CMPSS10 CTRIPL
	XBAR_CLB_CMPSS11_CTRIPH		 = 0x014,	//!CMPSS11 CTRIPH
	XBAR_CLB_CMPSS11_CTRIPL		 = 0x015,	//!CMPSS11 CTRIPL
	XBAR_CLB_CMPSS12_CTRIPH		 = 0x016,	//!CMPSS12 CTRIPH
	XBAR_CLB_CMPSS12_CTRIPL		 = 0x017,	//!CMPSS12 CTRIPL
	XBAR_CLB_SD1FLT1_COMPH		 = 0x0100,	//!SD1FLT1 COMPH
	XBAR_CLB_SD1FLT1_COMPL		 = 0x0101,	//!SD1FLT1 COMPL
	XBAR_CLB_SD1FLT2_COMPH		 = 0x0102,	//!SD1FLT2 COMPH
	XBAR_CLB_SD1FLT2_COMPL		 = 0x0103,	//!SD1FLT2 COMPL
	XBAR_CLB_SD1FLT3_COMPH		 = 0x0104,	//!SD1FLT3 COMPH
	XBAR_CLB_SD1FLT3_COMPL		 = 0x0105,	//!SD1FLT3 COMPL
	XBAR_CLB_SD1FLT4_COMPH		 = 0x0106,	//!SD1FLT4 COMPH
	XBAR_CLB_SD1FLT4_COMPL		 = 0x0107,	//!SD1FLT4 COMPL
	XBAR_CLB_SD2FLT1_COMPH		 = 0x0108,	//!SD2FLT1 COMPH
	XBAR_CLB_SD2FLT1_COMPL		 = 0x0109,	//!SD2FLT1 COMPL
	XBAR_CLB_SD2FLT2_COMPH		 = 0x010A,	//!SD2FLT2 COMPH
	XBAR_CLB_SD2FLT2_COMPL		 = 0x010B,	//!SD2FLT2 COMPL
	XBAR_CLB_SD2FLT3_COMPH		 = 0x010C,	//!SD2FLT3 COMPH
	XBAR_CLB_SD2FLT3_COMPL		 = 0x010D,	//!SD2FLT3 COMPL
	XBAR_CLB_SD2FLT4_COMPH		 = 0x010E,	//!SD2FLT4 COMPH
	XBAR_CLB_SD2FLT4_COMPL		 = 0x010F,	//!SD2FLT4 COMPL
	XBAR_CLB_SD3FLT1_COMPH		 = 0x0110,	//!SD3FLT1 COMPH
	XBAR_CLB_SD3FLT1_COMPL		 = 0x0111,	//!SD3FLT1 COMPL
	XBAR_CLB_SD3FLT2_COMPH		 = 0x0112,	//!SD3FLT2 COMPH
	XBAR_CLB_SD3FLT2_COMPL		 = 0x0113,	//!SD3FLT2 COMPL
	XBAR_CLB_SD3FLT3_COMPH		 = 0x0114,	//!SD3FLT3 COMPH
	XBAR_CLB_SD3FLT3_COMPL		 = 0x0115,	//!SD3FLT3 COMPL
	XBAR_CLB_SD3FLT4_COMPH		 = 0x0116,	//!SD3FLT4 COMPH
	XBAR_CLB_SD3FLT4_COMPL		 = 0x0117,	//!SD3FLT4 COMPL
	XBAR_CLB_SD4FLT1_COMPH		 = 0x0118,	//!SD4FLT1 COMPH
	XBAR_CLB_SD4FLT1_COMPL		 = 0x0119,	//!SD4FLT1 COMPL
	XBAR_CLB_SD4FLT2_COMPH		 = 0x011A,	//!SD4FLT2 COMPH
	XBAR_CLB_SD4FLT2_COMPL		 = 0x011B,	//!SD4FLT2 COMPL
	XBAR_CLB_SD4FLT3_COMPH		 = 0x011C,	//!SD4FLT3 COMPH
	XBAR_CLB_SD4FLT3_COMPL		 = 0x011D,	//!SD4FLT3 COMPL
	XBAR_CLB_SD4FLT4_COMPH		 = 0x011E,	//!SD4FLT4 COMPH
	XBAR_CLB_SD4FLT4_COMPL		 = 0x011F,	//!SD4FLT4 COMPL
	XBAR_CLB_ADCAEVT1		 = 0x0200,	//!ADCAEVT1
	XBAR_CLB_ADCAEVT2		 = 0x0201,	//!ADCAEVT2
	XBAR_CLB_ADCAEVT3		 = 0x0202,	//!ADCAEVT3
	XBAR_CLB_ADCAEVT4		 = 0x0203,	//!ADCAEVT4
	XBAR_CLB_ADCBEVT1		 = 0x0204,	//!ADCBEVT1
	XBAR_CLB_ADCBEVT2		 = 0x0205,	//!ADCBEVT2
	XBAR_CLB_ADCBEVT3		 = 0x0206,	//!ADCBEVT3
	XBAR_CLB_ADCBEVT4		 = 0x0207,	//!ADCBEVT4
	XBAR_CLB_ADCCEVT1		 = 0x0208,	//!ADCCEVT1
	XBAR_CLB_ADCCEVT2		 = 0x0209,	//!ADCCEVT2
	XBAR_CLB_ADCCEVT3		 = 0x020A,	//!ADCCEVT3
	XBAR_CLB_ADCCEVT4		 = 0x020B,	//!ADCCEVT4
	XBAR_CLB_ADCDEVT1		 = 0x020C,	//!ADCDEVT1
	XBAR_CLB_ADCDEVT2		 = 0x020D,	//!ADCDEVT2
	XBAR_CLB_ADCDEVT3		 = 0x020E,	//!ADCDEVT3
	XBAR_CLB_ADCDEVT4		 = 0x020F,	//!ADCDEVT4
	XBAR_CLB_ADCEEVT1		 = 0x0210,	//!ADCEEVT1
	XBAR_CLB_ADCEEVT2		 = 0x0211,	//!ADCEEVT2
	XBAR_CLB_ADCEEVT3		 = 0x0212,	//!ADCEEVT3
	XBAR_CLB_ADCEEVT4		 = 0x0213,	//!ADCEEVT4
	XBAR_CLB_CPU1_ADCCHECK_EVT1		 = 0x0214,	//!CPU1 ADCCHECKEVT1
	XBAR_CLB_CPU1_ADCCHECK_EVT2		 = 0x0215,	//!CPU1 ADCCHECKEVT2
	XBAR_CLB_CPU1_ADCCHECK_EVT3		 = 0x0216,	//!CPU1 ADCCHECKEVT3
	XBAR_CLB_CPU1_ADCCHECK_EVT4		 = 0x0217,	//!CPU1 ADCCHECKEVT4
	XBAR_CLB_CPU2_ADCCHECK_EVT1		 = 0x0218,	//!CPU2 ADCCHECKEVT1
	XBAR_CLB_CPU2_ADCCHECK_EVT2		 = 0x0219,	//!CPU2 ADCCHECKEVT2
	XBAR_CLB_CPU2_ADCCHECK_EVT3		 = 0x021A,	//!CPU2 ADCCHECKEVT3
	XBAR_CLB_CPU2_ADCCHECK_EVT4		 = 0x021B,	//!CPU2 ADCCHECKEVT4
	XBAR_CLB_CPU3_ADCCHECK_EVT1		 = 0x021C,	//!CPU3 ADCCHECKEVT1
	XBAR_CLB_CPU3_ADCCHECK_EVT2		 = 0x021D,	//!CPU3 ADCCHECKEVT2
	XBAR_CLB_CPU3_ADCCHECK_EVT3		 = 0x021E,	//!CPU3 ADCCHECKEVT3
	XBAR_CLB_CPU3_ADCCHECK_EVT4		 = 0x021F,	//!CPU3 ADCCHECKEVT4
	XBAR_CLB_INPUTXBAR_INPUT1		 = 0x0300,	//!INPUTXBAR INPUT1
	XBAR_CLB_INPUTXBAR_INPUT2		 = 0x0301,	//!INPUTXBAR INPUT2
	XBAR_CLB_INPUTXBAR_INPUT3		 = 0x0302,	//!INPUTXBAR INPUT3
	XBAR_CLB_INPUTXBAR_INPUT4		 = 0x0303,	//!INPUTXBAR INPUT4
	XBAR_CLB_INPUTXBAR_INPUT5		 = 0x0304,	//!INPUTXBAR INPUT5
	XBAR_CLB_INPUTXBAR_INPUT6		 = 0x0305,	//!INPUTXBAR INPUT6
	XBAR_CLB_INPUTXBAR_INPUT7		 = 0x0306,	//!INPUTXBAR INPUT7
	XBAR_CLB_INPUTXBAR_INPUT8		 = 0x0307,	//!INPUTXBAR INPUT8
	XBAR_CLB_INPUTXBAR_INPUT9		 = 0x0308,	//!INPUTXBAR INPUT9
	XBAR_CLB_INPUTXBAR_INPUT10		 = 0x0309,	//!INPUTXBAR INPUT10
	XBAR_CLB_INPUTXBAR_INPUT11		 = 0x030A,	//!INPUTXBAR INPUT11
	XBAR_CLB_INPUTXBAR_INPUT12		 = 0x030B,	//!INPUTXBAR INPUT12
	XBAR_CLB_INPUTXBAR_INPUT13		 = 0x030C,	//!INPUTXBAR INPUT13
	XBAR_CLB_INPUTXBAR_INPUT14		 = 0x030D,	//!INPUTXBAR INPUT14
	XBAR_CLB_INPUTXBAR_INPUT15		 = 0x030E,	//!INPUTXBAR INPUT15
	XBAR_CLB_INPUTXBAR_INPUT16		 = 0x030F,	//!INPUTXBAR INPUT16
	XBAR_CLB_INPUTXBAR_INPUT17		 = 0x0310,	//!INPUTXBAR INPUT17
	XBAR_CLB_INPUTXBAR_INPUT18		 = 0x0311,	//!INPUTXBAR INPUT18
	XBAR_CLB_INPUTXBAR_INPUT19		 = 0x0312,	//!INPUTXBAR INPUT19
	XBAR_CLB_INPUTXBAR_INPUT20		 = 0x0313,	//!INPUTXBAR INPUT20
	XBAR_CLB_INPUTXBAR_INPUT21		 = 0x0314,	//!INPUTXBAR INPUT21
	XBAR_CLB_INPUTXBAR_INPUT22		 = 0x0315,	//!INPUTXBAR INPUT22
	XBAR_CLB_INPUTXBAR_INPUT23		 = 0x0316,	//!INPUTXBAR INPUT23
	XBAR_CLB_INPUTXBAR_INPUT24		 = 0x0317,	//!INPUTXBAR INPUT24
	XBAR_CLB_INPUTXBAR_INPUT25		 = 0x0318,	//!INPUTXBAR INPUT25
	XBAR_CLB_INPUTXBAR_INPUT26		 = 0x0319,	//!INPUTXBAR INPUT26
	XBAR_CLB_INPUTXBAR_INPUT27		 = 0x031A,	//!INPUTXBAR INPUT27
	XBAR_CLB_INPUTXBAR_INPUT28		 = 0x031B,	//!INPUTXBAR INPUT28
	XBAR_CLB_INPUTXBAR_INPUT29		 = 0x031C,	//!INPUTXBAR INPUT29
	XBAR_CLB_INPUTXBAR_INPUT30		 = 0x031D,	//!INPUTXBAR INPUT30
	XBAR_CLB_INPUTXBAR_INPUT31		 = 0x031E,	//!INPUTXBAR INPUT31
	XBAR_CLB_INPUTXBAR_INPUT32		 = 0x031F,	//!INPUTXBAR INPUT32
	XBAR_CLB_CLB1_OUT4		 = 0x0400,	//!CLB1 OUT4
	XBAR_CLB_CLB1_OUT5		 = 0x0401,	//!CLB1 OUT5
	XBAR_CLB_CLB2_OUT4		 = 0x0402,	//!CLB2 OUT4
	XBAR_CLB_CLB2_OUT5		 = 0x0403,	//!CLB2 OUT5
	XBAR_CLB_CLB3_OUT4		 = 0x0404,	//!CLB3 OUT4
	XBAR_CLB_CLB3_OUT5		 = 0x0405,	//!CLB3 OUT5
	XBAR_CLB_CLB4_OUT4		 = 0x0406,	//!CLB4 OUT4
	XBAR_CLB_CLB4_OUT5		 = 0x0407,	//!CLB4 OUT5
	XBAR_CLB_CLB5_OUT4		 = 0x0408,	//!CLB5 OUT4
	XBAR_CLB_CLB5_OUT5		 = 0x0409,	//!CLB5 OUT5
	XBAR_CLB_CLB6_OUT4		 = 0x040A,	//!CLB6 OUT4
	XBAR_CLB_CLB6_OUT5		 = 0x040B,	//!CLB6 OUT5
	XBAR_CLB_FSIA_RX_TRIG1		 = 0x0410,	//!FSIA RX TRIG1
	XBAR_CLB_FSIB_RX_TRIG1		 = 0x0411,	//!FSIB RX TRIG1
	XBAR_CLB_FSIC_RX_TRIG1		 = 0x0412,	//!FSIC RX TRIG1
	XBAR_CLB_FSID_RX_TRIG1		 = 0x0413,	//!FSID RX TRIG1
	XBAR_CLB_FSIA_RX_TRIG2		 = 0x0414,	//!FSIA RX TRIG2
	XBAR_CLB_FSIB_RX_TRIG2		 = 0x0415,	//!FSIB RX TRIG2
	XBAR_CLB_FSIC_RX_TRIG2		 = 0x0416,	//!FSIC RX TRIG2
	XBAR_CLB_FSID_RX_TRIG2		 = 0x0417,	//!FSID RX TRIG2
	XBAR_CLB_FSIA_RX_TRIG3		 = 0x0418,	//!FSIA RX TRIG3
	XBAR_CLB_FSIB_RX_TRIG3		 = 0x0419,	//!FSIB RX TRIG3
	XBAR_CLB_FSIC_RX_TRIG3		 = 0x041A,	//!FSIC RX TRIG3
	XBAR_CLB_FSID_RX_TRIG3		 = 0x041B,	//!FSID RX TRIG3
	XBAR_CLB_ECAT_SYNC0		 = 0x041E,	//!ECAT SYNC0
	XBAR_CLB_ECAT_SYNC1		 = 0x041F,	//!ECAT SYNC1
	XBAR_CLB_ECAP1_OUT		 = 0x0500,	//!ECAP1 OUT
	XBAR_CLB_ECAP2_OUT		 = 0x0501,	//!ECAP2 OUT
	XBAR_CLB_ECAP3_OUT		 = 0x0502,	//!ECAP3 OUT
	XBAR_CLB_ECAP4_OUT		 = 0x0503,	//!ECAP4 OUT
	XBAR_CLB_ECAP5_OUT		 = 0x0504,	//!ECAP5 OUT
	XBAR_CLB_ECAP6_OUT		 = 0x0505,	//!ECAP6 OUT
	XBAR_CLB_ECAP1_TRIPOUT		 = 0x0508,	//!ECAP1 TRIPOUT
	XBAR_CLB_ECAP2_TRIPOUT		 = 0x0509,	//!ECAP2 TRIPOUT
	XBAR_CLB_ECAP3_TRIPOUT		 = 0x050A,	//!ECAP3 TRIPOUT
	XBAR_CLB_ECAP4_TRIPOUT		 = 0x050B,	//!ECAP4 TRIPOUT
	XBAR_CLB_ECAP5_TRIPOUT		 = 0x050C,	//!ECAP5 TRIPOUT
	XBAR_CLB_ECAP6_TRIPOUT		 = 0x050D,	//!ECAP6 TRIPOUT
	XBAR_CLB_ADCSOCA		 = 0x0510,	//!ADCSOCA
	XBAR_CLB_ADCSOCB		 = 0x0511,	//!ADCSOCB
	XBAR_CLB_ESM_GEN_EVENT		 = 0x0512,	//!ESM GEN EVENT
	XBAR_CLB_EXTSYNCOUT		 = 0x0513,	//!EXTSYNCOUT
	XBAR_CLB_MCANA_FEVT0		 = 0x0600,	//!MCANA FEVT0
	XBAR_CLB_MCANA_FEVT1		 = 0x0601,	//!MCANA FEVT1
	XBAR_CLB_MCANA_FEVT2		 = 0x0602,	//!MCANA FEVT2
	XBAR_CLB_MCANB_FEVT0		 = 0x0603,	//!MCANB FEVT0
	XBAR_CLB_MCANB_FEVT1		 = 0x0604,	//!MCANB FEVT1
	XBAR_CLB_MCANB_FEVT2		 = 0x0605,	//!MCANB FEVT2
	XBAR_CLB_MCANC_FEVT0		 = 0x0606,	//!MCANC FEVT0
	XBAR_CLB_MCANC_FEVT1		 = 0x0607,	//!MCANC FEVT1
	XBAR_CLB_MCANC_FEVT2		 = 0x0608,	//!MCANC FEVT2
	XBAR_CLB_MCAND_FEVT0		 = 0x0609,	//!MCAND FEVT0
	XBAR_CLB_MCAND_FEVT1		 = 0x060A,	//!MCAND FEVT1
	XBAR_CLB_MCAND_FEVT2		 = 0x060B,	//!MCAND FEVT2
	XBAR_CLB_MCANE_FEVT0		 = 0x060C,	//!MCANE FEVT0
	XBAR_CLB_MCANE_FEVT1		 = 0x060D,	//!MCANE FEVT1
	XBAR_CLB_MCANE_FEVT2		 = 0x060E,	//!MCANE FEVT2
	XBAR_CLB_MCANF_FEVT0		 = 0x060F,	//!MCANF FEVT0
	XBAR_CLB_MCANF_FEVT1		 = 0x0610,	//!MCANF FEVT1
	XBAR_CLB_MCANF_FEVT2		 = 0x0611,	//!MCANF FEVT2
	XBAR_CLB_CPU1_ERADEVT8		 = 0x0614,	//!CPU1 ERADEVT8
	XBAR_CLB_CPU1_ERADEVT9		 = 0x0615,	//!CPU1 ERADEVT9
	XBAR_CLB_CPU1_ERADEVT10		 = 0x0616,	//!CPU1 ERADEVT10
	XBAR_CLB_CPU1_ERADEVT11		 = 0x0617,	//!CPU1 ERADEVT11
	XBAR_CLB_CPU2_ERADEVT8		 = 0x0618,	//!CPU2 ERADEVT8
	XBAR_CLB_CPU2_ERADEVT9		 = 0x0619,	//!CPU2 ERADEVT9
	XBAR_CLB_CPU2_ERADEVT10		 = 0x061A,	//!CPU2 ERADEVT10
	XBAR_CLB_CPU2_ERADEVT11		 = 0x061B,	//!CPU2 ERADEVT11
	XBAR_CLB_CPU3_ERADEVT8		 = 0x061C,	//!CPU3 ERADEVT8
	XBAR_CLB_CPU3_ERADEVT9		 = 0x061D,	//!CPU3 ERADEVT9
	XBAR_CLB_CPU3_ERADEVT10		 = 0x061E,	//!CPU3 ERADEVT10
	XBAR_CLB_CPU3_ERADEVT11		 = 0x061F,	//!CPU3 ERADEVT11
	XBAR_CLB_WADI1OUT0		 = 0x0700,	//!WADI1OUT0
	XBAR_CLB_WADI1OUT1		 = 0x0701,	//!WADI1OUT1
	XBAR_CLB_WADI1OUT2		 = 0x0702,	//!WADI1OUT2
	XBAR_CLB_WADI1OUT3		 = 0x0703,	//!WADI1OUT3
	XBAR_CLB_WADI1OUT4		 = 0x0704,	//!WADI1OUT4
	XBAR_CLB_WADI1OUT5		 = 0x0705,	//!WADI1OUT5
	XBAR_CLB_WADI1OUT6		 = 0x0706,	//!WADI1OUT6
	XBAR_CLB_WADI1OUT7		 = 0x0707,	//!WADI1OUT7
	XBAR_CLB_WADI2OUT0		 = 0x0708,	//!WADI2OUT0
	XBAR_CLB_WADI2OUT1		 = 0x0709,	//!WADI2OUT1
	XBAR_CLB_WADI2OUT2		 = 0x070A,	//!WADI2OUT2
	XBAR_CLB_WADI2OUT3		 = 0x070B,	//!WADI2OUT3
	XBAR_CLB_WADI2OUT4		 = 0x070C,	//!WADI2OUT4
	XBAR_CLB_WADI2OUT5		 = 0x070D,	//!WADI2OUT5
	XBAR_CLB_WADI2OUT6		 = 0x070E,	//!WADI2OUT6
	XBAR_CLB_WADI2OUT7		 = 0x070F	//!WADI2OUT7
} XBAR_ClbXbarInputSource;


//*****************************************************************************
//
//! The following values define the \e source parameter for
//! XBAR_selectMindbXbarInputSource().
//
// C28X_MIGRATION: XBAR_InputSignal
//
//*****************************************************************************
typedef enum
{
	XBAR_MINDB_EPWM1A_DB_NO_HR		 = 0x00,	//!EPWM1A DB NO HR
	XBAR_MINDB_EPWM2A_DB_NO_HR		 = 0x01,	//!EPWM2A DB NO HR
	XBAR_MINDB_EPWM3A_DB_NO_HR		 = 0x02,	//!EPWM3A DB NO HR
	XBAR_MINDB_EPWM4A_DB_NO_HR		 = 0x03,	//!EPWM4A DB NO HR
	XBAR_MINDB_EPWM5A_DB_NO_HR		 = 0x04,	//!EPWM5A DB NO HR
	XBAR_MINDB_EPWM6A_DB_NO_HR		 = 0x05,	//!EPWM6A DB NO HR
	XBAR_MINDB_EPWM7A_DB_NO_HR		 = 0x06,	//!EPWM7A DB NO HR
	XBAR_MINDB_EPWM8A_DB_NO_HR		 = 0x07,	//!EPWM8A DB NO HR
	XBAR_MINDB_EPWM9A_DB_NO_HR		 = 0x08,	//!EPWM9A DB NO HR
	XBAR_MINDB_EPWM10A_DB_NO_HR		 = 0x09,	//!EPWM10A DB NO HR
	XBAR_MINDB_EPWM11A_DB_NO_HR		 = 0x0A,	//!EPWM11A DB NO HR
	XBAR_MINDB_EPWM12A_DB_NO_HR		 = 0x0B,	//!EPWM12A DB NO HR
	XBAR_MINDB_EPWM13A_DB_NO_HR		 = 0x0C,	//!EPWM13A DB NO HR
	XBAR_MINDB_EPWM14A_DB_NO_HR		 = 0x0D,	//!EPWM14A DB NO HR
	XBAR_MINDB_EPWM15A_DB_NO_HR		 = 0x0E,	//!EPWM15A DB NO HR
	XBAR_MINDB_EPWM16A_DB_NO_HR		 = 0x0F,	//!EPWM16A DB NO HR
	XBAR_MINDB_EPWM17A_DB_NO_HR		 = 0x010,	//!EPWM17A DB NO HR
	XBAR_MINDB_EPWM18A_DB_NO_HR		 = 0x011,	//!EPWM18A DB NO HR
	XBAR_MINDB_EPWM1B_DB_NO_HR		 = 0x0100,	//!EPWM1B DB NO HR
	XBAR_MINDB_EPWM2B_DB_NO_HR		 = 0x0101,	//!EPWM2B DB NO HR
	XBAR_MINDB_EPWM3B_DB_NO_HR		 = 0x0102,	//!EPWM3B DB NO HR
	XBAR_MINDB_EPWM4B_DB_NO_HR		 = 0x0103,	//!EPWM4B DB NO HR
	XBAR_MINDB_EPWM5B_DB_NO_HR		 = 0x0104,	//!EPWM5B DB NO HR
	XBAR_MINDB_EPWM6B_DB_NO_HR		 = 0x0105,	//!EPWM6B DB NO HR
	XBAR_MINDB_EPWM7B_DB_NO_HR		 = 0x0106,	//!EPWM7B DB NO HR
	XBAR_MINDB_EPWM8B_DB_NO_HR		 = 0x0107,	//!EPWM8B DB NO HR
	XBAR_MINDB_EPWM9B_DB_NO_HR		 = 0x0108,	//!EPWM9B DB NO HR
	XBAR_MINDB_EPWM10B_DB_NO_HR		 = 0x0109,	//!EPWM10B DB NO HR
	XBAR_MINDB_EPWM11B_DB_NO_HR		 = 0x010A,	//!EPWM11B DB NO HR
	XBAR_MINDB_EPWM12B_DB_NO_HR		 = 0x010B,	//!EPWM12B DB NO HR
	XBAR_MINDB_EPWM13B_DB_NO_HR		 = 0x010C,	//!EPWM13B DB NO HR
	XBAR_MINDB_EPWM14B_DB_NO_HR		 = 0x010D,	//!EPWM14B DB NO HR
	XBAR_MINDB_EPWM15B_DB_NO_HR		 = 0x010E,	//!EPWM15B DB NO HR
	XBAR_MINDB_EPWM16B_DB_NO_HR		 = 0x010F,	//!EPWM16B DB NO HR
	XBAR_MINDB_EPWM17B_DB_NO_HR		 = 0x0110,	//!EPWM17B DB NO HR
	XBAR_MINDB_EPWM18B_DB_NO_HR		 = 0x0111,	//!EPWM18B DB NO HR
	XBAR_MINDB_CLB1_OUT4		 = 0x0200,	//!CLB1 OUT4
	XBAR_MINDB_CLB1_OUT5		 = 0x0201,	//!CLB1 OUT5
	XBAR_MINDB_CLB2_OUT4		 = 0x0202,	//!CLB2 OUT4
	XBAR_MINDB_CLB2_OUT5		 = 0x0203,	//!CLB2 OUT5
	XBAR_MINDB_CLB3_OUT4		 = 0x0204,	//!CLB3 OUT4
	XBAR_MINDB_CLB3_OUT5		 = 0x0205,	//!CLB3 OUT5
	XBAR_MINDB_CLB4_OUT4		 = 0x0206,	//!CLB4 OUT4
	XBAR_MINDB_CLB4_OUT5		 = 0x0207,	//!CLB4 OUT5
	XBAR_MINDB_CLB5_OUT4		 = 0x0208,	//!CLB5 OUT4
	XBAR_MINDB_CLB5_OUT5		 = 0x0209,	//!CLB5 OUT5
	XBAR_MINDB_CLB6_OUT4		 = 0x020A,	//!CLB6 OUT4
	XBAR_MINDB_CLB6_OUT5		 = 0x020B	//!CLB6 OUT5
} XBAR_MindbXbarInputSource;


//*****************************************************************************
//
//! The following values define the \e source parameter for
//! XBAR_selectIclXbarInputSource().
//
// C28X_MIGRATION: XBAR_InputSignal
//
//*****************************************************************************
typedef enum
{
	XBAR_ICL_EPWM1A_MINDB		 = 0x00,	//!EPWM1A MINDB
	XBAR_ICL_EPWM2A_MINDB		 = 0x01,	//!EPWM2A MINDB
	XBAR_ICL_EPWM3A_MINDB		 = 0x02,	//!EPWM3A MINDB
	XBAR_ICL_EPWM4A_MINDB		 = 0x03,	//!EPWM4A MINDB
	XBAR_ICL_EPWM5A_MINDB		 = 0x04,	//!EPWM5A MINDB
	XBAR_ICL_EPWM6A_MINDB		 = 0x05,	//!EPWM6A MINDB
	XBAR_ICL_EPWM7A_MINDB		 = 0x06,	//!EPWM7A MINDB
	XBAR_ICL_EPWM8A_MINDB		 = 0x07,	//!EPWM8A MINDB
	XBAR_ICL_EPWM9A_MINDB		 = 0x08,	//!EPWM9A MINDB
	XBAR_ICL_EPWM10A_MINDB		 = 0x09,	//!EPWM10A MINDB
	XBAR_ICL_EPWM11A_MINDB		 = 0x0A,	//!EPWM11A MINDB
	XBAR_ICL_EPWM12A_MINDB		 = 0x0B,	//!EPWM12A MINDB
	XBAR_ICL_EPWM13A_MINDB		 = 0x0C,	//!EPWM13A MINDB
	XBAR_ICL_EPWM14A_MINDB		 = 0x0D,	//!EPWM14A MINDB
	XBAR_ICL_EPWM15A_MINDB		 = 0x0E,	//!EPWM15A MINDB
	XBAR_ICL_EPWM16A_MINDB		 = 0x0F,	//!EPWM16A MINDB
	XBAR_ICL_EPWM17A_MINDB		 = 0x010,	//!EPWM17A MINDB
	XBAR_ICL_EPWM18A_MINDB		 = 0x011,	//!EPWM18A MINDB
	XBAR_ICL_EPWM1B_MINDB		 = 0x0100,	//!EPWM1B MINDB
	XBAR_ICL_EPWM2B_MINDB		 = 0x0101,	//!EPWM2B MINDB
	XBAR_ICL_EPWM3B_MINDB		 = 0x0102,	//!EPWM3B MINDB
	XBAR_ICL_EPWM4B_MINDB		 = 0x0103,	//!EPWM4B MINDB
	XBAR_ICL_EPWM5B_MINDB		 = 0x0104,	//!EPWM5B MINDB
	XBAR_ICL_EPWM6B_MINDB		 = 0x0105,	//!EPWM6B MINDB
	XBAR_ICL_EPWM7B_MINDB		 = 0x0106,	//!EPWM7B MINDB
	XBAR_ICL_EPWM8B_MINDB		 = 0x0107,	//!EPWM8B MINDB
	XBAR_ICL_EPWM9B_MINDB		 = 0x0108,	//!EPWM9B MINDB
	XBAR_ICL_EPWM10B_MINDB		 = 0x0109,	//!EPWM10B MINDB
	XBAR_ICL_EPWM11B_MINDB		 = 0x010A,	//!EPWM11B MINDB
	XBAR_ICL_EPWM12B_MINDB		 = 0x010B,	//!EPWM12B MINDB
	XBAR_ICL_EPWM13B_MINDB		 = 0x010C,	//!EPWM13B MINDB
	XBAR_ICL_EPWM14B_MINDB		 = 0x010D,	//!EPWM14B MINDB
	XBAR_ICL_EPWM15B_MINDB		 = 0x010E,	//!EPWM15B MINDB
	XBAR_ICL_EPWM16B_MINDB		 = 0x010F,	//!EPWM16B MINDB
	XBAR_ICL_EPWM17B_MINDB		 = 0x0110,	//!EPWM17B MINDB
	XBAR_ICL_EPWM18B_MINDB		 = 0x0111,	//!EPWM18B MINDB
	XBAR_ICL_CLB1_OUT4		 = 0x0200,	//!CLB1 OUT4
	XBAR_ICL_CLB1_OUT5		 = 0x0201,	//!CLB1 OUT5
	XBAR_ICL_CLB2_OUT4		 = 0x0202,	//!CLB2 OUT4
	XBAR_ICL_CLB2_OUT5		 = 0x0203,	//!CLB2 OUT5
	XBAR_ICL_CLB3_OUT4		 = 0x0204,	//!CLB3 OUT4
	XBAR_ICL_CLB3_OUT5		 = 0x0205,	//!CLB3 OUT5
	XBAR_ICL_CLB4_OUT4		 = 0x0206,	//!CLB4 OUT4
	XBAR_ICL_CLB4_OUT5		 = 0x0207,	//!CLB4 OUT5
	XBAR_ICL_CLB5_OUT4		 = 0x0208,	//!CLB5 OUT4
	XBAR_ICL_CLB5_OUT5		 = 0x0209,	//!CLB5 OUT5
	XBAR_ICL_CLB6_OUT4		 = 0x020A,	//!CLB6 OUT4
	XBAR_ICL_CLB6_OUT5		 = 0x020B	//!CLB6 OUT5
} XBAR_IclXbarInputSource;


//*****************************************************************************
//
//! The following values define the \e inputFlag parameter for
//! XBAR_getInputFlagStatus() and XBAR_clearInputFlag().
//
//*****************************************************************************
typedef enum
{
    XBAR_INPUT_FLG_CMPSS1_CTRIPL  = 0x0100U,
    XBAR_INPUT_FLG_CMPSS1_CTRIPH  = 0x0101U,
    XBAR_INPUT_FLG_CMPSS2_CTRIPL  = 0x0102U,
    XBAR_INPUT_FLG_CMPSS2_CTRIPH  = 0x0103U,
    XBAR_INPUT_FLG_CMPSS3_CTRIPL  = 0x0104U,
    XBAR_INPUT_FLG_CMPSS3_CTRIPH  = 0x0105U,
    XBAR_INPUT_FLG_CMPSS4_CTRIPL  = 0x0106U,
    XBAR_INPUT_FLG_CMPSS4_CTRIPH  = 0x0107U,
    XBAR_INPUT_FLG_CMPSS5_CTRIPL  = 0x0108U,
    XBAR_INPUT_FLG_CMPSS5_CTRIPH  = 0x0109U,
    XBAR_INPUT_FLG_CMPSS6_CTRIPL  = 0x010AU,
    XBAR_INPUT_FLG_CMPSS6_CTRIPH  = 0x010BU,
    XBAR_INPUT_FLG_CMPSS7_CTRIPL  = 0x010CU,
    XBAR_INPUT_FLG_CMPSS7_CTRIPH  = 0x010DU,
    XBAR_INPUT_FLG_CMPSS8_CTRIPL  = 0x010EU,
    XBAR_INPUT_FLG_CMPSS8_CTRIPH  = 0x010FU,
    XBAR_INPUT_FLG_CMPSS9_CTRIPH  = 0x0110U,
    XBAR_INPUT_FLG_CMPSS9_CTRIPL  = 0x0111U,
    XBAR_INPUT_FLG_CMPSS10_CTRIPH  = 0x0112U,
    XBAR_INPUT_FLG_CMPSS10_CTRIPL  = 0x0113U,
    XBAR_INPUT_FLG_CMPSS11_CTRIPH  = 0x0114U,
    XBAR_INPUT_FLG_CMPSS11_CTRIPL  = 0x0115U,
    XBAR_INPUT_FLG_CMPSS12_CTRIPH  = 0x0116U,
    XBAR_INPUT_FLG_CMPSS12_CTRIPL  = 0x0117U,
    XBAR_INPUT_FLG_CMPSS1_CTRIPOUTL  = 0x0200U,
    XBAR_INPUT_FLG_CMPSS1_CTRIPOUTH  = 0x0201U,
    XBAR_INPUT_FLG_CMPSS2_CTRIPOUTL  = 0x0202U,
    XBAR_INPUT_FLG_CMPSS2_CTRIPOUTH  = 0x0203U,
    XBAR_INPUT_FLG_CMPSS3_CTRIPOUTL  = 0x0204U,
    XBAR_INPUT_FLG_CMPSS3_CTRIPOUTH  = 0x0205U,
    XBAR_INPUT_FLG_CMPSS4_CTRIPOUTL  = 0x0206U,
    XBAR_INPUT_FLG_CMPSS4_CTRIPOUTH  = 0x0207U,
    XBAR_INPUT_FLG_CMPSS5_CTRIPOUTL  = 0x0208U,
    XBAR_INPUT_FLG_CMPSS5_CTRIPOUTH  = 0x0209U,
    XBAR_INPUT_FLG_CMPSS6_CTRIPOUTL  = 0x020AU,
    XBAR_INPUT_FLG_CMPSS6_CTRIPOUTH  = 0x020BU,
    XBAR_INPUT_FLG_CMPSS7_CTRIPOUTL  = 0x020CU,
    XBAR_INPUT_FLG_CMPSS7_CTRIPOUTH  = 0x020DU,
    XBAR_INPUT_FLG_CMPSS8_CTRIPOUTL  = 0x020EU,
    XBAR_INPUT_FLG_CMPSS8_CTRIPOUTH  = 0x020FU,
    XBAR_INPUT_FLG_CMPSS9_CTRIPOUTH  = 0x0210U,
    XBAR_INPUT_FLG_CMPSS9_CTRIPOUTL  = 0x0211U,
    XBAR_INPUT_FLG_CMPSS10_CTRIPOUTH  = 0x0212U,
    XBAR_INPUT_FLG_CMPSS10_CTRIPOUTL  = 0x0213U,
    XBAR_INPUT_FLG_CMPSS11_CTRIPOUTH  = 0x0214U,
    XBAR_INPUT_FLG_CMPSS11_CTRIPOUTL  = 0x0215U,
    XBAR_INPUT_FLG_CMPSS12_CTRIPOUTH  = 0x0216U,
    XBAR_INPUT_FLG_CMPSS12_CTRIPOUTL  = 0x0217U,
    XBAR_INPUT_FLG_SD1FLT1_COMPL  = 0x0300U,
    XBAR_INPUT_FLG_SD1FLT1_COMPH  = 0x0301U,
    XBAR_INPUT_FLG_SD1FLT2_COMPL  = 0x0302U,
    XBAR_INPUT_FLG_SD1FLT2_COMPH  = 0x0303U,
    XBAR_INPUT_FLG_SD1FLT3_COMPL  = 0x0304U,
    XBAR_INPUT_FLG_SD1FLT3_COMPH  = 0x0305U,
    XBAR_INPUT_FLG_SD1FLT4_COMPL  = 0x0306U,
    XBAR_INPUT_FLG_SD1FLT4_COMPH  = 0x0307U,
    XBAR_INPUT_FLG_SD2FLT1_COMPL  = 0x0308U,
    XBAR_INPUT_FLG_SD2FLT1_COMPH  = 0x0309U,
    XBAR_INPUT_FLG_SD2FLT2_COMPL  = 0x030AU,
    XBAR_INPUT_FLG_SD2FLT2_COMPH  = 0x030BU,
    XBAR_INPUT_FLG_SD2FLT3_COMPL  = 0x030CU,
    XBAR_INPUT_FLG_SD2FLT3_COMPH  = 0x030DU,
    XBAR_INPUT_FLG_SD2FLT4_COMPL  = 0x030EU,
    XBAR_INPUT_FLG_SD2FLT4_COMPH  = 0x030FU,
    XBAR_INPUT_FLG_SD3FLT1_COMPH  = 0x0310U,
    XBAR_INPUT_FLG_SD3FLT1_COMPL  = 0x0311U,
    XBAR_INPUT_FLG_SD3FLT2_COMPH  = 0x0312U,
    XBAR_INPUT_FLG_SD3FLT2_COMPL  = 0x0313U,
    XBAR_INPUT_FLG_SD3FLT3_COMPH  = 0x0314U,
    XBAR_INPUT_FLG_SD3FLT3_COMPL  = 0x0315U,
    XBAR_INPUT_FLG_SD3FLT4_COMPH  = 0x0316U,
    XBAR_INPUT_FLG_SD3FLT4_COMPL  = 0x0317U,
    XBAR_INPUT_FLG_SD4FLT1_COMPH  = 0x0318U,
    XBAR_INPUT_FLG_SD4FLT1_COMPL  = 0x0319U,
    XBAR_INPUT_FLG_SD4FLT2_COMPH  = 0x031AU,
    XBAR_INPUT_FLG_SD4FLT2_COMPL  = 0x031BU,
    XBAR_INPUT_FLG_SD4FLT3_COMPH  = 0x031CU,
    XBAR_INPUT_FLG_SD4FLT3_COMPL  = 0x031DU,
    XBAR_INPUT_FLG_SD4FLT4_COMPH  = 0x031EU,
    XBAR_INPUT_FLG_SD4FLT4_COMPL  = 0x031FU,
    XBAR_INPUT_FLG_INPUT1  = 0x0400U,
    XBAR_INPUT_FLG_INPUT2  = 0x0401U,
    XBAR_INPUT_FLG_INPUT3  = 0x0402U,
    XBAR_INPUT_FLG_INPUT4  = 0x0403U,
    XBAR_INPUT_FLG_INPUT5  = 0x0404U,
    XBAR_INPUT_FLG_INPUT6  = 0x0405U,
    XBAR_INPUT_FLG_INPUT7  = 0x0406U,
    XBAR_INPUT_FLG_INPUT8  = 0x0407U,
    XBAR_INPUT_FLG_INPUT9  = 0x0408U,
    XBAR_INPUT_FLG_INPUT10  = 0x0409U,
    XBAR_INPUT_FLG_INPUT11  = 0x040AU,
    XBAR_INPUT_FLG_INPUT12  = 0x040BU,
    XBAR_INPUT_FLG_INPUT13  = 0x040CU,
    XBAR_INPUT_FLG_INPUT14  = 0x040DU,
    XBAR_INPUT_FLG_INPUT15  = 0x040EU,
    XBAR_INPUT_FLG_INPUT16  = 0x040FU,
    XBAR_INPUT_FLG_INPUT17  = 0x0410U,
    XBAR_INPUT_FLG_INPUT18  = 0x0411U,
    XBAR_INPUT_FLG_INPUT19  = 0x0412U,
    XBAR_INPUT_FLG_INPUT20  = 0x0413U,
    XBAR_INPUT_FLG_INPUT21  = 0x0414U,
    XBAR_INPUT_FLG_INPUT22  = 0x0415U,
    XBAR_INPUT_FLG_INPUT23  = 0x0416U,
    XBAR_INPUT_FLG_INPUT24  = 0x0417U,
    XBAR_INPUT_FLG_INPUT25  = 0x0418U,
    XBAR_INPUT_FLG_INPUT26  = 0x0419U,
    XBAR_INPUT_FLG_INPUT27  = 0x041AU,
    XBAR_INPUT_FLG_INPUT28  = 0x041BU,
    XBAR_INPUT_FLG_INPUT29  = 0x041CU,
    XBAR_INPUT_FLG_INPUT30  = 0x041DU,
    XBAR_INPUT_FLG_INPUT31  = 0x041EU,
    XBAR_INPUT_FLG_INPUT32  = 0x041FU,
    XBAR_INPUT_FLG_ADCAEVT1  = 0x0500U,
    XBAR_INPUT_FLG_ADCAEVT2  = 0x0501U,
    XBAR_INPUT_FLG_ADCAEVT3  = 0x0502U,
    XBAR_INPUT_FLG_ADCAEVT4  = 0x0503U,
    XBAR_INPUT_FLG_ADCBEVT1  = 0x0504U,
    XBAR_INPUT_FLG_ADCBEVT2  = 0x0505U,
    XBAR_INPUT_FLG_ADCBEVT3  = 0x0506U,
    XBAR_INPUT_FLG_ADCBEVT4  = 0x0507U,
    XBAR_INPUT_FLG_ADCCEVT1  = 0x0508U,
    XBAR_INPUT_FLG_ADCCEVT2  = 0x0509U,
    XBAR_INPUT_FLG_ADCCEVT3  = 0x050AU,
    XBAR_INPUT_FLG_ADCCEVT4  = 0x050BU,
    XBAR_INPUT_FLG_ADCDEVT1  = 0x050CU,
    XBAR_INPUT_FLG_ADCDEVT2  = 0x050DU,
    XBAR_INPUT_FLG_ADCDEVT3  = 0x050EU,
    XBAR_INPUT_FLG_ADCDEVT4  = 0x050FU,
    XBAR_INPUT_FLG_ADCEEVT1  = 0x0510U,
    XBAR_INPUT_FLG_ADCEEVT2  = 0x0511U,
    XBAR_INPUT_FLG_ADCEEVT3  = 0x0512U,
    XBAR_INPUT_FLG_ADCEEVT4  = 0x0513U,
    XBAR_INPUT_FLG_CPU1_ADCCHECKEVT1  = 0x0514U,
    XBAR_INPUT_FLG_CPU1_ADCCHECKEVT2  = 0x0515U,
    XBAR_INPUT_FLG_CPU1_ADCCHECKEVT3  = 0x0516U,
    XBAR_INPUT_FLG_CPU1_ADCCHECKEVT4  = 0x0517U,
    XBAR_INPUT_FLG_CPU2_ADCCHECKEVT1  = 0x0518U,
    XBAR_INPUT_FLG_CPU2_ADCCHECKEVT2  = 0x0519U,
    XBAR_INPUT_FLG_CPU2_ADCCHECKEVT3  = 0x051AU,
    XBAR_INPUT_FLG_CPU2_ADCCHECKEVT4  = 0x051BU,
    XBAR_INPUT_FLG_CPU3_ADCCHECKEVT1  = 0x051CU,
    XBAR_INPUT_FLG_CPU3_ADCCHECKEVT2  = 0x051DU,
    XBAR_INPUT_FLG_CPU3_ADCCHECKEVT3  = 0x051EU,
    XBAR_INPUT_FLG_CPU3_ADCCHECKEVT4  = 0x051FU,
    XBAR_INPUT_FLG_CLB1_OUT4  = 0x0600U,
    XBAR_INPUT_FLG_CLB1_OUT5  = 0x0601U,
    XBAR_INPUT_FLG_CLB2_OUT4  = 0x0602U,
    XBAR_INPUT_FLG_CLB2_OUT5  = 0x0603U,
    XBAR_INPUT_FLG_CLB3_OUT4  = 0x0604U,
    XBAR_INPUT_FLG_CLB3_OUT5  = 0x0605U,
    XBAR_INPUT_FLG_CLB4_OUT4  = 0x0606U,
    XBAR_INPUT_FLG_CLB4_OUT5  = 0x0607U,
    XBAR_INPUT_FLG_CLB5_OUT4  = 0x0608U,
    XBAR_INPUT_FLG_CLB5_OUT5  = 0x0609U,
    XBAR_INPUT_FLG_CLB6_OUT4  = 0x060AU,
    XBAR_INPUT_FLG_CLB6_OUT5  = 0x060BU,
    XBAR_INPUT_FLG_FSIA_RX_TRIG1  = 0x0610U,
    XBAR_INPUT_FLG_FSIB_RX_TRIG1  = 0x0611U,
    XBAR_INPUT_FLG_FSIC_RX_TRIG1  = 0x0612U,
    XBAR_INPUT_FLG_FSID_RX_TRIG1  = 0x0613U,
    XBAR_INPUT_FLG_WADI1OUT0  = 0x0616U,
    XBAR_INPUT_FLG_WADI1OUT1  = 0x0617U,
    XBAR_INPUT_FLG_WADI1OUT2  = 0x0618U,
    XBAR_INPUT_FLG_WADI1OUT3  = 0x0619U,
    XBAR_INPUT_FLG_WADI1OUT4  = 0x061AU,
    XBAR_INPUT_FLG_WADI1OUT5  = 0x061BU,
    XBAR_INPUT_FLG_WADI1OUT6  = 0x061CU,
    XBAR_INPUT_FLG_WADI1OUT7  = 0x061DU,
    XBAR_INPUT_FLG_ECATSYNC0  = 0x061EU,
    XBAR_INPUT_FLG_ECATSYNC1  = 0x061FU,
    XBAR_INPUT_FLG_ECAP1_OUT  = 0x0700U,
    XBAR_INPUT_FLG_ECAP2_OUT  = 0x0701U,
    XBAR_INPUT_FLG_ECAP3_OUT  = 0x0702U,
    XBAR_INPUT_FLG_ECAP4_OUT  = 0x0703U,
    XBAR_INPUT_FLG_ECAP5_OUT  = 0x0704U,
    XBAR_INPUT_FLG_ECAP6_OUT  = 0x0705U,
    XBAR_INPUT_FLG_ECAP1_TRIPOUT  = 0x0708U,
    XBAR_INPUT_FLG_ECAP2_TRIPOUT  = 0x0709U,
    XBAR_INPUT_FLG_ECAP3_TRIPOUT  = 0x070AU,
    XBAR_INPUT_FLG_ECAP4_TRIPOUT  = 0x070BU,
    XBAR_INPUT_FLG_ECAP5_TRIPOUT  = 0x070CU,
    XBAR_INPUT_FLG_ECAP6_TRIPOUT  = 0x070DU,
    XBAR_INPUT_FLG_ADCSOCA  = 0x0710U,
    XBAR_INPUT_FLG_ADCSOCB  = 0x0711U,
    XBAR_INPUT_FLG_ESMGENEVT  = 0x0712U,
    XBAR_INPUT_FLG_EXTSYNCOUT  = 0x0713U,
    XBAR_INPUT_FLG_WADI2OUT0  = 0x0718U,
    XBAR_INPUT_FLG_WADI2OUT1  = 0x0719U,
    XBAR_INPUT_FLG_WADI2OUT2  = 0x071AU,
    XBAR_INPUT_FLG_WADI2OUT3  = 0x071BU,
    XBAR_INPUT_FLG_WADI2OUT4  = 0x071CU,
    XBAR_INPUT_FLG_WADI2OUT5  = 0x071DU,
    XBAR_INPUT_FLG_WADI2OUT6  = 0x071EU,
    XBAR_INPUT_FLG_WADI2OUT7  = 0x071FU,
    XBAR_INPUT_FLG_EPWM1_TRIPOUT  = 0x0800U,
    XBAR_INPUT_FLG_EPWM2_TRIPOUT  = 0x0801U,
    XBAR_INPUT_FLG_EPWM3_TRIPOUT  = 0x0802U,
    XBAR_INPUT_FLG_EPWM4_TRIPOUT  = 0x0803U,
    XBAR_INPUT_FLG_EPWM5_TRIPOUT  = 0x0804U,
    XBAR_INPUT_FLG_EPWM6_TRIPOUT  = 0x0805U,
    XBAR_INPUT_FLG_EPWM7_TRIPOUT  = 0x0806U,
    XBAR_INPUT_FLG_EPWM8_TRIPOUT  = 0x0807U,
    XBAR_INPUT_FLG_EPWM9_TRIPOUT  = 0x0808U,
    XBAR_INPUT_FLG_EPWM10_TRIPOUT  = 0x0809U,
    XBAR_INPUT_FLG_EPWM11_TRIPOUT  = 0x080AU,
    XBAR_INPUT_FLG_EPWM12_TRIPOUT  = 0x080BU,
    XBAR_INPUT_FLG_EPWM13_TRIPOUT  = 0x080CU,
    XBAR_INPUT_FLG_EPWM14_TRIPOUT  = 0x080DU,
    XBAR_INPUT_FLG_EPWM15_TRIPOUT  = 0x080EU,
    XBAR_INPUT_FLG_EPWM16_TRIPOUT  = 0x080FU,
    XBAR_INPUT_FLG_EPWM17_TRIPOUT  = 0x0810U,
    XBAR_INPUT_FLG_EPWM18_TRIPOUT  = 0x0811U,
    XBAR_INPUT_FLG_EPWM1_DEL_TRIP  = 0x0900U,
    XBAR_INPUT_FLG_EPWM2_DEL_TRIP  = 0x0901U,
    XBAR_INPUT_FLG_EPWM3_DEL_TRIP  = 0x0902U,
    XBAR_INPUT_FLG_EPWM4_DEL_TRIP  = 0x0903U,
    XBAR_INPUT_FLG_EPWM5_DEL_TRIP  = 0x0904U,
    XBAR_INPUT_FLG_EPWM6_DEL_TRIP  = 0x0905U,
    XBAR_INPUT_FLG_EPWM7_DEL_TRIP  = 0x0906U,
    XBAR_INPUT_FLG_EPWM8_DEL_TRIP  = 0x0907U,
    XBAR_INPUT_FLG_EPWM9_DEL_TRIP  = 0x0908U,
    XBAR_INPUT_FLG_EPWM10_DEL_TRIP  = 0x0909U,
    XBAR_INPUT_FLG_EPWM11_DEL_TRIP  = 0x090AU,
    XBAR_INPUT_FLG_EPWM12_DEL_TRIP  = 0x090BU,
    XBAR_INPUT_FLG_EPWM13_DEL_TRIP  = 0x090CU,
    XBAR_INPUT_FLG_EPWM14_DEL_TRIP  = 0x090DU,
    XBAR_INPUT_FLG_EPWM15_DEL_TRIP  = 0x090EU,
    XBAR_INPUT_FLG_EPWM16_DEL_TRIP  = 0x090FU,
    XBAR_INPUT_FLG_EPWM17_DEL_TRIP  = 0x0910U,
    XBAR_INPUT_FLG_EPWM18_DEL_TRIP  = 0x0911U,
    XBAR_INPUT_FLG_EPWM1_DEL_ACTIVE  = 0x0A00U,
    XBAR_INPUT_FLG_EPWM2_DEL_ACTIVE  = 0x0A01U,
    XBAR_INPUT_FLG_EPWM3_DEL_ACTIVE  = 0x0A02U,
    XBAR_INPUT_FLG_EPWM4_DEL_ACTIVE  = 0x0A03U,
    XBAR_INPUT_FLG_EPWM5_DEL_ACTIVE  = 0x0A04U,
    XBAR_INPUT_FLG_EPWM6_DEL_ACTIVE  = 0x0A05U,
    XBAR_INPUT_FLG_EPWM7_DEL_ACTIVE  = 0x0A06U,
    XBAR_INPUT_FLG_EPWM8_DEL_ACTIVE  = 0x0A07U,
    XBAR_INPUT_FLG_EPWM9_DEL_ACTIVE  = 0x0A08U,
    XBAR_INPUT_FLG_EPWM10_DEL_ACTIVE  = 0x0A09U,
    XBAR_INPUT_FLG_EPWM11_DEL_ACTIVE  = 0x0A0AU,
    XBAR_INPUT_FLG_EPWM12_DEL_ACTIVE  = 0x0A0BU,
    XBAR_INPUT_FLG_EPWM13_DEL_ACTIVE  = 0x0A0CU,
    XBAR_INPUT_FLG_EPWM14_DEL_ACTIVE  = 0x0A0DU,
    XBAR_INPUT_FLG_EPWM15_DEL_ACTIVE  = 0x0A0EU,
    XBAR_INPUT_FLG_EPWM16_DEL_ACTIVE  = 0x0A0FU,
    XBAR_INPUT_FLG_EPWM17_DEL_ACTIVE  = 0x0A10U,
    XBAR_INPUT_FLG_EPWM18_DEL_ACTIVE  = 0x0A11U,
    XBAR_INPUT_FLG_EPWM1_A0_SCLK  = 0x0B00U,
    XBAR_INPUT_FLG_EPWM1_B0_SCLK  = 0x0B01U,
    XBAR_INPUT_FLG_EPWM2_A0_SCLK  = 0x0B02U,
    XBAR_INPUT_FLG_EPWM2_B0_SCLK  = 0x0B03U,
    XBAR_INPUT_FLG_EPWM3_A0_SCLK  = 0x0B04U,
    XBAR_INPUT_FLG_EPWM3_B0_SCLK  = 0x0B05U,
    XBAR_INPUT_FLG_EPWM4_A0_SCLK  = 0x0B06U,
    XBAR_INPUT_FLG_EPWM4_B0_SCLK  = 0x0B07U,
    XBAR_INPUT_FLG_EPWM5_A0_SCLK  = 0x0B08U,
    XBAR_INPUT_FLG_EPWM5_B0_SCLK  = 0x0B09U,
    XBAR_INPUT_FLG_EPWM6_A0_SCLK  = 0x0B0AU,
    XBAR_INPUT_FLG_EPWM6_B0_SCLK  = 0x0B0BU,
    XBAR_INPUT_FLG_EPWM7_A0_SCLK  = 0x0B0CU,
    XBAR_INPUT_FLG_EPWM7_B0_SCLK  = 0x0B0DU,
    XBAR_INPUT_FLG_EPWM8_A0_SCLK  = 0x0B0EU,
    XBAR_INPUT_FLG_EPWM8_B0_SCLK  = 0x0B0FU,
    XBAR_INPUT_FLG_EPWM9_A0_SCLK  = 0x0B10U,
    XBAR_INPUT_FLG_EPWM9_B0_SCLK  = 0x0B11U,
    XBAR_INPUT_FLG_EPWM10_A0_SCLK  = 0x0B12U,
    XBAR_INPUT_FLG_EPWM10_B0_SCLK  = 0x0B13U,
    XBAR_INPUT_FLG_EPWM11_A0_SCLK  = 0x0B14U,
    XBAR_INPUT_FLG_EPWM11_B0_SCLK  = 0x0B15U,
    XBAR_INPUT_FLG_EPWM12_A0_SCLK  = 0x0B16U,
    XBAR_INPUT_FLG_EPWM12_B0_SCLK  = 0x0B17U,
    XBAR_INPUT_FLG_EPWM13_A0_SCLK  = 0x0B18U,
    XBAR_INPUT_FLG_EPWM13_B0_SCLK  = 0x0B19U,
    XBAR_INPUT_FLG_EPWM14_A0_SCLK  = 0x0B1AU,
    XBAR_INPUT_FLG_EPWM14_B0_SCLK  = 0x0B1BU,
    XBAR_INPUT_FLG_EPWM15_A0_SCLK  = 0x0B1CU,
    XBAR_INPUT_FLG_EPWM15_B0_SCLK  = 0x0B1DU,
    XBAR_INPUT_FLG_EPWM16_A0_SCLK  = 0x0B1EU,
    XBAR_INPUT_FLG_EPWM16_B0_SCLK  = 0x0B1FU,
    XBAR_INPUT_FLG_EPWM17_A0_SCLK  = 0x0C00U,
    XBAR_INPUT_FLG_EPWM17_B0_SCLK  = 0x0C01U,
    XBAR_INPUT_FLG_EPWM18_A0_SCLK  = 0x0C02U,
    XBAR_INPUT_FLG_EPWM18_B0_SCLK  = 0x0C03U,
    XBAR_INPUT_FLG_MDL1_OUTA  = 0x0D00U,
    XBAR_INPUT_FLG_MDL1_OUTB  = 0x0D01U,
    XBAR_INPUT_FLG_MDL2_OUTA  = 0x0D02U,
    XBAR_INPUT_FLG_MDL2_OUTB  = 0x0D03U,
    XBAR_INPUT_FLG_MDL3_OUTA  = 0x0D04U,
    XBAR_INPUT_FLG_MDL3_OUTB  = 0x0D05U,
    XBAR_INPUT_FLG_MDL4_OUTA  = 0x0D06U,
    XBAR_INPUT_FLG_MDL4_OUTB  = 0x0D07U,
    XBAR_INPUT_FLG_MDL5_OUTA  = 0x0D08U,
    XBAR_INPUT_FLG_MDL5_OUTB  = 0x0D09U,
    XBAR_INPUT_FLG_MDL6_OUTA  = 0x0D0AU,
    XBAR_INPUT_FLG_MDL6_OUTB  = 0x0D0BU,
    XBAR_INPUT_FLG_MDL7_OUTA  = 0x0D0CU,
    XBAR_INPUT_FLG_MDL7_OUTB  = 0x0D0DU,
    XBAR_INPUT_FLG_MDL8_OUTA  = 0x0D0EU,
    XBAR_INPUT_FLG_MDL8_OUTB  = 0x0D0FU,
    XBAR_INPUT_FLG_MDL9_OUTA  = 0x0D10U,
    XBAR_INPUT_FLG_MDL9_OUTB  = 0x0D11U,
    XBAR_INPUT_FLG_MDL10_OUTA  = 0x0D12U,
    XBAR_INPUT_FLG_MDL10_OUTB  = 0x0D13U,
    XBAR_INPUT_FLG_MDL11_OUTA  = 0x0D14U,
    XBAR_INPUT_FLG_MDL11_OUTB  = 0x0D15U,
    XBAR_INPUT_FLG_MDL12_OUTA  = 0x0D16U,
    XBAR_INPUT_FLG_MDL12_OUTB  = 0x0D17U,
    XBAR_INPUT_FLG_MDL13_OUTA  = 0x0D18U,
    XBAR_INPUT_FLG_MDL13_OUTB  = 0x0D19U,
    XBAR_INPUT_FLG_MDL14_OUTA  = 0x0D1AU,
    XBAR_INPUT_FLG_MDL14_OUTB  = 0x0D1BU,
    XBAR_INPUT_FLG_MDL15_OUTA  = 0x0D1CU,
    XBAR_INPUT_FLG_MDL15_OUTB  = 0x0D1DU,
    XBAR_INPUT_FLG_MDL16_OUTA  = 0x0D1EU,
    XBAR_INPUT_FLG_MDL16_OUTB  = 0x0D1FU,
    XBAR_INPUT_FLG_MDL17_OUTA  = 0x0E00U,
    XBAR_INPUT_FLG_MDL17_OUTB  = 0x0E01U,
    XBAR_INPUT_FLG_MDL18_OUTA  = 0x0E02U,
    XBAR_INPUT_FLG_MDL18_OUTB  = 0x0E03U,
    XBAR_INPUT_FLG_CLB1_OUT0  = 0x0F00U,
    XBAR_INPUT_FLG_CLB1_OUT1  = 0x0F01U,
    XBAR_INPUT_FLG_CLB1_OUT2  = 0x0F02U,
    XBAR_INPUT_FLG_CLB1_OUT3  = 0x0F03U,
    XBAR_INPUT_FLG_CLB1_OUT6  = 0x0F04U,
    XBAR_INPUT_FLG_CLB1_OUT7  = 0x0F05U,
    XBAR_INPUT_FLG_CLB2_OUT0  = 0x0F06U,
    XBAR_INPUT_FLG_CLB2_OUT1  = 0x0F07U,
    XBAR_INPUT_FLG_CLB2_OUT2  = 0x0F08U,
    XBAR_INPUT_FLG_CLB2_OUT3  = 0x0F09U,
    XBAR_INPUT_FLG_CLB2_OUT6  = 0x0F0AU,
    XBAR_INPUT_FLG_CLB2_OUT7  = 0x0F0BU,
    XBAR_INPUT_FLG_CLB3_OUT0  = 0x0F0CU,
    XBAR_INPUT_FLG_CLB3_OUT1  = 0x0F0DU,
    XBAR_INPUT_FLG_CLB3_OUT2  = 0x0F0EU,
    XBAR_INPUT_FLG_CLB3_OUT3  = 0x0F0FU,
    XBAR_INPUT_FLG_CLB3_OUT6  = 0x0F10U,
    XBAR_INPUT_FLG_CLB3_OUT7  = 0x0F11U,
    XBAR_INPUT_FLG_CLB4_OUT0  = 0x0F12U,
    XBAR_INPUT_FLG_CLB4_OUT1  = 0x0F13U,
    XBAR_INPUT_FLG_CLB4_OUT2  = 0x0F14U,
    XBAR_INPUT_FLG_CLB4_OUT3  = 0x0F15U,
    XBAR_INPUT_FLG_CLB4_OUT6  = 0x0F16U,
    XBAR_INPUT_FLG_CLB4_OUT7  = 0x0F17U,
    XBAR_INPUT_FLG_CLB5_OUT0  = 0x0F18U,
    XBAR_INPUT_FLG_CLB5_OUT1  = 0x0F19U,
    XBAR_INPUT_FLG_CLB5_OUT2  = 0x0F1AU,
    XBAR_INPUT_FLG_CLB5_OUT3  = 0x0F1BU,
    XBAR_INPUT_FLG_CLB5_OUT6  = 0x0F1CU,
    XBAR_INPUT_FLG_CLB5_OUT7  = 0x0F1DU,
    XBAR_INPUT_FLG_CLB6_OUT0  = 0x0F1EU,
    XBAR_INPUT_FLG_CLB6_OUT1  = 0x0F1FU,
    XBAR_INPUT_FLG_CLB6_OUT2  = 0x1000U,
    XBAR_INPUT_FLG_CLB6_OUT3  = 0x1001U,
    XBAR_INPUT_FLG_CLB6_OUT6  = 0x1002U,
    XBAR_INPUT_FLG_CLB6_OUT7  = 0x1003U,
    XBAR_INPUT_FLG_ADCA_EXTMUXSEL0  = 0x1004U,
    XBAR_INPUT_FLG_ADCA_EXTMUXSEL1  = 0x1005U,
    XBAR_INPUT_FLG_ADCA_EXTMUXSEL2  = 0x1006U,
    XBAR_INPUT_FLG_ADCA_EXTMUXSEL3  = 0x1007U,
    XBAR_INPUT_FLG_ADCB_EXTMUXSEL0  = 0x1008U,
    XBAR_INPUT_FLG_ADCB_EXTMUXSEL1  = 0x1009U,
    XBAR_INPUT_FLG_ADCB_EXTMUXSEL2  = 0x100AU,
    XBAR_INPUT_FLG_ADCB_EXTMUXSEL3  = 0x100BU,
    XBAR_INPUT_FLG_ADCC_EXTMUXSEL0  = 0x100CU,
    XBAR_INPUT_FLG_ADCC_EXTMUXSEL1  = 0x100DU,
    XBAR_INPUT_FLG_ADCC_EXTMUXSEL2  = 0x100EU,
    XBAR_INPUT_FLG_ADCC_EXTMUXSEL3  = 0x100FU,
    XBAR_INPUT_FLG_ADCD_EXTMUXSEL0  = 0x1010U,
    XBAR_INPUT_FLG_ADCD_EXTMUXSEL1  = 0x1011U,
    XBAR_INPUT_FLG_ADCD_EXTMUXSEL2  = 0x1012U,
    XBAR_INPUT_FLG_ADCD_EXTMUXSEL3  = 0x1013U,
    XBAR_INPUT_FLG_ADCE_EXTMUXSEL0  = 0x1014U,
    XBAR_INPUT_FLG_ADCE_EXTMUXSEL1  = 0x1015U,
    XBAR_INPUT_FLG_ADCE_EXTMUXSEL2  = 0x1016U,
    XBAR_INPUT_FLG_ADCE_EXTMUXSEL3  = 0x1017U,
    XBAR_INPUT_FLG_EPG1_EPGOUT0  = 0x101CU,
    XBAR_INPUT_FLG_EPG1_EPGOUT1  = 0x101DU,
    XBAR_INPUT_FLG_EPG1_EPGOUT2  = 0x101EU,
    XBAR_INPUT_FLG_EPG1_EPGOUT3  = 0x101FU,
    XBAR_INPUT_FLG_MCANA_FEVT0  = 0x1100U,
    XBAR_INPUT_FLG_MCANA_FEVT1  = 0x1101U,
    XBAR_INPUT_FLG_MCANA_FEVT2  = 0x1102U,
    XBAR_INPUT_FLG_MCANB_FEVT0  = 0x1103U,
    XBAR_INPUT_FLG_MCANB_FEVT1  = 0x1104U,
    XBAR_INPUT_FLG_MCANB_FEVT2  = 0x1105U,
    XBAR_INPUT_FLG_MCANC_FEVT0  = 0x1106U,
    XBAR_INPUT_FLG_MCANC_FEVT1  = 0x1107U,
    XBAR_INPUT_FLG_MCANC_FEVT2  = 0x1108U,
    XBAR_INPUT_FLG_MCAND_FEVT0  = 0x1109U,
    XBAR_INPUT_FLG_MCAND_FEVT1  = 0x110AU,
    XBAR_INPUT_FLG_MCAND_FEVT2  = 0x110BU,
    XBAR_INPUT_FLG_MCANE_FEVT0  = 0x110CU,
    XBAR_INPUT_FLG_MCANE_FEVT1  = 0x110DU,
    XBAR_INPUT_FLG_MCANE_FEVT2  = 0x110EU,
    XBAR_INPUT_FLG_MCANF_FEVT0  = 0x110FU,
    XBAR_INPUT_FLG_MCANF_FEVT1  = 0x1110U,
    XBAR_INPUT_FLG_MCANF_FEVT2  = 0x1111U,
    XBAR_INPUT_FLG_FSIRXA_TRIG_2  = 0x1200U,
    XBAR_INPUT_FLG_FSIRXA_TRIG_3  = 0x1201U,
    XBAR_INPUT_FLG_FSIRXB_TRIG_2  = 0x1202U,
    XBAR_INPUT_FLG_FSIRXB_TRIG_3  = 0x1203U,
    XBAR_INPUT_FLG_FSIRXC_TRIG_2  = 0x1204U,
    XBAR_INPUT_FLG_FSIRXC_TRIG_3  = 0x1205U,
    XBAR_INPUT_FLG_FSIRXD_TRIG_2  = 0x1206U,
    XBAR_INPUT_FLG_FSIRXD_TRIG_3  = 0x1207U,
    XBAR_INPUT_FLG_CPU1ERADEVT8  = 0x1208U,
    XBAR_INPUT_FLG_CPU1ERADEVT9  = 0x1209U,
    XBAR_INPUT_FLG_CPU1ERADEVT10  = 0x120AU,
    XBAR_INPUT_FLG_CPU1ERADEVT11  = 0x120BU,
    XBAR_INPUT_FLG_CPU2ERADEVT8  = 0x120CU,
    XBAR_INPUT_FLG_CPU2ERADEVT9  = 0x120DU,
    XBAR_INPUT_FLG_CPU2ERADEVT10  = 0x120EU,
    XBAR_INPUT_FLG_CPU2ERADEVT11  = 0x120FU,
    XBAR_INPUT_FLG_CPU3ERADEVT8  = 0x1210U,
    XBAR_INPUT_FLG_CPU3ERADEVT9  = 0x1211U,
    XBAR_INPUT_FLG_CPU3ERADEVT10  = 0x1212U,
    XBAR_INPUT_FLG_CPU3ERADEVT11  = 0x1213U
} XBAR_InputFlag;
#endif

//*****************************************************************************
//
//! The following values define the \e length parameter for
//! XBAR_selectOutputStretchLength().
//
//*****************************************************************************
typedef enum
{
    XBAR_OUTPUT_STRETCH_16SYSCLK  = 0U,
    XBAR_OUTPUT_STRETCH_32SYSCLK  = 1U
}XBAR_OutputStretchLength;

//*****************************************************************************
//
// Prototypes for the APIs.
//
//*****************************************************************************
//*****************************************************************************
//
//! \internal
//! Checks a X-BAR base address.
//!
//! \param base is the base address of the X-BAR.
//!
//! This function determines if a X-BAR base address is valid.
//!
//! \return Returns \b true if the base address is valid and \b false
//! otherwise.
//
//*****************************************************************************
#ifdef DEBUG
__attribute__((always_inline))
static inline bool
XBAR_isBaseValid(uint32_t base)
{
    return(
           (base == INPUTXBAR_BASE) ||
           (base == EPWMXBAR_BASE) ||
           (base == CLBXBAR_BASE) ||
           (base == OUTPUTXBAR_BASE) ||
           (base == MDLXBAR_BASE) ||
           (base == ICLXBAR_BASE)
          );
}
#endif

//*****************************************************************************
//
//! \internal
//! Checks a X-BAR FLAGS base address.
//!
//! \param base is the base address of the X-BAR FLAGS registers.
//!
//! This function determines if a X-BAR FLAGS base address is valid.
//!
//! \return Returns \b true if the base address is valid and \b false
//! otherwise.
//
//*****************************************************************************
#ifdef DEBUG
__attribute__((always_inline))
static inline bool
XBAR_FLAGS_isBaseValid(uint32_t base)
{
    return(
           ((base & BASE_ADDR_MASK) == OUTPUTXBAR1_FLAGS_BASE_FRAME(0U)) ||
           ((base & BASE_ADDR_MASK) == OUTPUTXBAR2_FLAGS_BASE_FRAME(0U)) ||
           ((base & BASE_ADDR_MASK) == OUTPUTXBAR3_FLAGS_BASE_FRAME(0U)) ||
           ((base & BASE_ADDR_MASK) == OUTPUTXBAR4_FLAGS_BASE_FRAME(0U)) ||
           ((base & BASE_ADDR_MASK) == OUTPUTXBAR5_FLAGS_BASE_FRAME(0U)) ||
           ((base & BASE_ADDR_MASK) == OUTPUTXBAR6_FLAGS_BASE_FRAME(0U)) ||
           ((base & BASE_ADDR_MASK) == OUTPUTXBAR7_FLAGS_BASE_FRAME(0U)) ||
           ((base & BASE_ADDR_MASK) == OUTPUTXBAR8_FLAGS_BASE_FRAME(0U)) ||
           ((base & BASE_ADDR_MASK) == OUTPUTXBAR9_FLAGS_BASE_FRAME(0U)) ||
           ((base & BASE_ADDR_MASK) == OUTPUTXBAR10_FLAGS_BASE_FRAME(0U)) ||
           ((base & BASE_ADDR_MASK) == OUTPUTXBAR11_FLAGS_BASE_FRAME(0U)) ||
           ((base & BASE_ADDR_MASK) == OUTPUTXBAR12_FLAGS_BASE_FRAME(0U)) ||
           ((base & BASE_ADDR_MASK) == OUTPUTXBAR13_FLAGS_BASE_FRAME(0U)) ||
           ((base & BASE_ADDR_MASK) == OUTPUTXBAR14_FLAGS_BASE_FRAME(0U)) ||
           ((base & BASE_ADDR_MASK) == OUTPUTXBAR15_FLAGS_BASE_FRAME(0U)) ||
           ((base & BASE_ADDR_MASK) == OUTPUTXBAR16_FLAGS_BASE_FRAME(0U))
          );
}
#endif

//*****************************************************************************
//
//! \internal
//! Checks that a pin number is valid for a INPUTXBAR input.
//!
//! Note that this function reflects the highest possible GPIO number of a
//! device on its biggest package. Check the datasheet to see what the actual
//! range of valid pin numbers is for a specific package.
//!
//! \return None.
//
//*****************************************************************************
#ifdef DEBUG
__attribute__((always_inline))
static inline bool
XBAR_isGPIOPinValid(uint32_t pin)
{
    return(
            (pin <= 105U) || (pin == 127U)    || // GPIO
            ((pin >= 219U) && (pin <= 223U)) || // GPIO
            ((pin >= 160U) && (pin <= 213U)) || // AIO
            ((pin >= 224U) && (pin <= 249U))  // AGPIO
          );
}
#endif

//*****************************************************************************
//
//! Sets the GPIO / non-GPIO pin for an Input X-BAR input.
//!
//! \param base specifies the X-BAR base address.
//! \param input is the X-BAR input being configured.
//! \param pin is the identifying number of the pin.
//!
//! The \e base parameter can take base address INPUTXBAR_BASE
//!
//! This function configures which GPIO is assigned to an Input X-BAR input.
//! The \e input parameter is a value in the form of a define \b XBAR_INPUTy
//! where y is a the input number for the Input X-BAR.
//!
//! The pin is specified by its numerical value. For example, GPIO34 is
//! specified by passing 34 as \e pin.
//!
//! For the other non - GPIO values:
//! 0xFFFD: '1' will be driven to the destination
//! 0xFFFE: '1' will be driven to the destination
//! 0xFFFF: '0' will be driven to the destination
//! \note Pin value greater than the available number of GPIO pins on a
//! device (except 0xFFFF) will cause the destination to be driven '1'.
//!
//! \return None.
//
//*****************************************************************************
__attribute__((section(".text.link2.XBAR_setInputPin")))
__attribute__((always_inline))
static inline void
XBAR_setInputPin(uint32_t base, XBAR_InputNum input, uint16_t pin)
{
    //
    // Check the argument.
    //
    ASSERT(base == INPUTXBAR_BASE);
    ASSERT(XBAR_isGPIOPinValid(pin) ||
          ((pin >= XBAR_NON_GPIO_MIN_CNT) && (pin <= XBAR_NON_GPIO_MAX_CNT)));

    //
    // Write the requested pin to the appropriate input select register.
    //
    HWREGH(base + INPUT_XBAR_O_INPUTSELECT((uint32_t)input)) = pin;
}

//*****************************************************************************
//
//! Locks an input to the Input X-BAR.
//!
//! \param base specifies the X-BAR base address.
//! \param input is an input to the Input X-BAR.
//!
//! This function locks the specific input on the Input X-BAR.
//!
//! The \e base parameter can take base address INPUTXBAR_BASE
//!
//! \return None.
//
//*****************************************************************************
__attribute__((section(".text.link2.XBAR_lockInput")))
__attribute__((always_inline))
static inline void
XBAR_lockInput(uint32_t base, XBAR_InputNum input)
{
    //
    // Check the arguments.
    //
    ASSERT(base == INPUTXBAR_BASE);

    //
    // lock the input in the INPUTSELECTLOCK register.
    //
    if((uint16_t)input < 32U)
    {
        HWREG(base + INPUT_XBAR_O_INPUTSELECTLOCK1) |= 1UL << (uint16_t)input;
    }
    else
    {
        HWREG(base + INPUT_XBAR_O_INPUTSELECTLOCK2) |= 1UL <<
                                                    ((uint16_t)input - 32U);
    }
}

//*****************************************************************************
//
//! Returns the status of the X-BAR output signal
//!
//! \param base specifies the X-BAR base address.
//! \param output is the X-BAR output whose flags are being accessed.
//! The valid inputs are XBAR_OUTPUTy where y is from 1 to 16.
//!
//! The \e base parameter can take base address OUTPUTXBAR_BASE.
//! The base address for OUTPUTXBARx FLAGS is calculated using the
//! \e output number specified.
//!
//! \return Returns \b true if the output signal is in high state.
//! If the output signal is in low state, it will return \b false.
//
//*****************************************************************************
__attribute__((always_inline))
static inline bool
XBAR_getOutputSignalStatus(uint32_t base, XBAR_OutputNum output)
{
    //
    // Check the arguments.
    //
    ASSERT(base == OUTPUTXBAR_BASE);

    uint32_t flagsBase;
    flagsBase = OUTPUTXBAR1_FLAGS_BASE + ((uint32_t)output *
                                                 XBAR_OUTPUTXBAR_FLAGS_OFFSET);

    ASSERT(XBAR_FLAGS_isBaseValid(flagsBase));

    //
    // Get the status of the Output X-BAR output signal.
    //
    return(HWREGB(flagsBase + OUTPUT_XBAR_O_OUTPUTXBARSTATUS) != 0U);
}

//*****************************************************************************
//
//! Returns the status of the output latch
//!
//! \param base specifies the X-BAR base address.
//! \param output is the X-BAR output whose flags are being accessed.
//! The valid inputs are XBAR_OUTPUTy where y is from 1 to 16.
//!
//! The \e base parameter can take base address OUTPUTXBAR_BASE.
//! The base address for OUTPUTXBARx FLAGS is calculated using the
//! \e output number specified.
//!
//! \return Returns \b true if there is a latched event.
//! If not, it will return \b false.
//
//*****************************************************************************
__attribute__((always_inline))
static inline bool
XBAR_getOutputLatchStatus(uint32_t base, XBAR_OutputNum output)
{
    //
    // Check the arguments.
    //
    ASSERT(base == OUTPUTXBAR_BASE);

    uint32_t flagsBase;
    flagsBase = OUTPUTXBAR1_FLAGS_BASE + ((uint32_t)output *
                                                 XBAR_OUTPUTXBAR_FLAGS_OFFSET);

    ASSERT(XBAR_FLAGS_isBaseValid(flagsBase));

    //
    // Get the status of the Output X-BAR output latch flag.
    //
    return(HWREGB(flagsBase + OUTPUT_XBAR_O_OUTPUTXBARFLAG) != 0U);
}

//*****************************************************************************
//
//! Clears the output latch for the specified output X-BAR.
//!
//! \param base specifies the X-BAR base address.
//! \param output is the X-BAR output whose flags are being accessed.
//! The valid inputs are XBAR_OUTPUTy where y is from 1 to 16.
//!
//! The \e base parameter can take base address OUTPUTXBAR_BASE.
//! The base address for OUTPUTXBARx FLAGS is calculated using the
//! \e output number specified.
//!
//! This function clears the Output X-BAR output latch flag.
//!
//! \return None.
//
//*****************************************************************************
__attribute__((always_inline))
static inline void
XBAR_clearOutputLatch(uint32_t base, XBAR_OutputNum output)
{
    //
    // Check the arguments.
    //
    ASSERT(base == OUTPUTXBAR_BASE);

    uint32_t flagsBase;
    flagsBase = OUTPUTXBAR1_FLAGS_BASE + ((uint32_t)output *
                                                 XBAR_OUTPUTXBAR_FLAGS_OFFSET);

    ASSERT(XBAR_FLAGS_isBaseValid(flagsBase));

    //
    // Set the bit that clears the corresponding OUTPUT FLAG.
    //
    HWREGB(flagsBase + OUTPUT_XBAR_O_OUTPUTXBARFLAGCLEAR) =
                                        OUTPUT_XBAR_OUTPUTXBARFLAGCLEAR_FLG;
}

//*****************************************************************************
//
//! Forces the output latch for the specified output X-BAR.
//!
//! \param base specifies the X-BAR base address.
//! \param output is the X-BAR output whose flags are being accessed.
//! The valid inputs are XBAR_OUTPUTy where y is from 1 to 16.
//!
//! The \e base parameter can take base addresses of OUTPUTXBAR_BASE.
//! The base address for OUTPUTXBARx FLAGS is calculated using the
//! \e output number specified.
//!
//! This function forces the respective Output X-BAR output signal latched
//! flag.
//!
//! \return None.
//
//*****************************************************************************
__attribute__((always_inline))
static inline void
XBAR_forceOutputLatch(uint32_t base, XBAR_OutputNum output)
{
    //
    // Check the arguments.
    //
    ASSERT(base == OUTPUTXBAR_BASE);

    uint32_t flagsBase;
    flagsBase = OUTPUTXBAR1_FLAGS_BASE + ((uint32_t)output *
                                                 XBAR_OUTPUTXBAR_FLAGS_OFFSET);

    ASSERT(XBAR_FLAGS_isBaseValid(flagsBase));

    //
    // Set the bit that forces the corresponding OUTPUTLATCH bit.
    //
    HWREGB(flagsBase + OUTPUT_XBAR_O_OUTPUTXBARFLAGFORCE) =
                                    OUTPUT_XBAR_OUTPUTXBARFLAGFORCE_FLG;
}

//*****************************************************************************
//
//! Configures the polarity of an X-BAR output before latch.
//!
//! \param base specifies the X-BAR base address.
//! \param output is the X-BAR output being configured.
//! The valid inputs are XBAR_OUTPUTy where y is from 1 to 16.
//! \param invert is a flag that determines whether the output is active-high
//! or active-low.
//!
//! The \e base parameter can take base address OUTPUTXBAR_BASE.
//!
//! This function inverts the Output X-BAR signal before the latch if the \e
//! invert parameter is \b true. If \e invert is \b false, the signal will be
//! passed as is. The \e output parameter is a value \b XBAR_OUTPUTy where y
//! is the output number between 1 and 16 inclusive.
//!
//! \return None.
//
//*****************************************************************************
__attribute__((section(".text.link2.XBAR_invertOutputSignalBeforeLatch")))
__attribute__((always_inline))
static inline void
XBAR_invertOutputSignalBeforeLatch(uint32_t base, XBAR_OutputNum output,
                                    bool invert)
{
    //
    // Check the arguments.
    //
    ASSERT(base == OUTPUTXBAR_BASE);

    //
    // Set or clear the polarity setting bit based on the invert parameter.
    //
    if(invert)
    {
        HWREGH(base + OUTPUT_XBAR_O_OUTPUTXBARFLAGINVERT) |=
                0x1U << ((uint16_t)output);
    }
    else
    {
        HWREGH(base + OUTPUT_XBAR_O_OUTPUTXBARFLAGINVERT) &=
                ~(0x1U << ((uint16_t)output));
    }
}

//*****************************************************************************
//
//! Enables or disables the output latch to drive the selected output.
//!
//! \param base specifies the X-BAR base address.
//! \param output is the X-BAR output being configured.
//! The valid inputs are XBAR_OUTPUTy where y is from 1 to 16.
//! \param enable is a flag that determines whether or not the latch is
//! selected to drive the X-BAR output.
//!
//! The \e base parameter can take base address OUTPUTXBAR_BASE
//!
//! This function sets the Output X-BAR output signal latch mode. If the
//! \e enable parameter is \b true, the latched event is selected for the
//! output specified by \e output .
//!
//! \return None.
//
//*****************************************************************************
__attribute__((section(".text.link2.XBAR_setOutputLatchMode")))
__attribute__((always_inline))
static inline void
XBAR_setOutputLatchMode(uint32_t base, XBAR_OutputNum output, bool enable)
{
    //
    // Check the arguments.
    //
    ASSERT(base == OUTPUTXBAR_BASE);

    //
    // Set or clear the latch setting bit based on the enable parameter.
    //
    if(enable)
    {
        HWREGH(base + OUTPUT_XBAR_O_OUTPUTXBAROUTLATCH) |=
               0x1U << ((uint16_t)output);
    }
    else
    {
        HWREGH(base + OUTPUT_XBAR_O_OUTPUTXBAROUTLATCH) &=
               ~(0x1U << ((uint16_t)output));
    }
}

//*****************************************************************************
//
//! Selects the Output signal stretched pulse version.
//!
//! \param base specifies the X-BAR base address.
//! \param output is the X-BAR output being configured.
//! The valid inputs are XBAR_OUTPUTy where y is from 1 to 16.
//! \param selectStretched is a flag that determines whether or not to select
//! the Strected Pulse version for the X-BAR output.
//!
//! The \e base parameter can take base address OUTPUTXBAR_BASE
//!
//! This function selects the Output signal stretched pulse version. If the
//! \e selectStretched parameter is \b true, the stretched pulse version is
//! selected as output for the \e output else the Non-stretched signal is
//! selected as output.
//!
//! \return None.
//
//*****************************************************************************
__attribute__((section(".text.link2.XBAR_selectOutputStretchSource")))
__attribute__((always_inline))
static inline void
XBAR_selectOutputStretchSource(uint32_t base, XBAR_OutputNum output,
                         bool selectStretched)
{
    //
    // Check the arguments.
    //
    ASSERT(base == OUTPUTXBAR_BASE);

    //
    // Set or clear the stretched pulse selection bit based on the
    // selectStretched parameter.
    //
    if(selectStretched)
    {
        HWREGH(base + OUTPUT_XBAR_O_OUTPUTXBAROUTSTRETCH) |=
               0x1U << ((uint16_t)output);
    }
    else
    {
        HWREGH(base + OUTPUT_XBAR_O_OUTPUTXBAROUTSTRETCH) &=
               ~(0x1U << ((uint16_t)output));
    }
}

//*****************************************************************************
//
//! Selects the length of the Stretched Output signal.
//!
//! \param base specifies the X-BAR base address.
//! \param output is the X-BAR output being configured.
//! The valid inputs are XBAR_OUTPUTy where y is from 1 to 16.
//! \param length is the length of the stretched pulse for the X-BAR output.
//!
//! The \e base parameter can take base address OUTPUTXBAR_BASE
//!
//! This function selects the length of the Output signal stretched pulse.
//! \e length parameter can take one of the values defined in the enum
//! XBAR_OutputStretchLength. A 16 or 32 SYSCLK stretch can be selected.
//!
//! \return None.
//
//*****************************************************************************
__attribute__((section(".text.link2.XBAR_selectOutputStretchLength")))
__attribute__((always_inline))
static inline void
XBAR_selectOutputStretchLength(uint32_t base, XBAR_OutputNum output,
                               XBAR_OutputStretchLength length)
{
    //
    // Check the arguments.
    //
    ASSERT(base == OUTPUTXBAR_BASE);

    //
    // Set or clear the length select bit based on the length parameter.
    //
    if(length == XBAR_OUTPUT_STRETCH_32SYSCLK)
    {
        HWREGH(base + OUTPUT_XBAR_O_OUTPUTXBAROUTLENGTH) |=
               0x1U << ((uint16_t)output);
    }
    else
    {
        HWREGH(base + OUTPUT_XBAR_O_OUTPUTXBAROUTLENGTH) &=
               ~(0x1U << ((uint16_t)output));
    }
}


//*****************************************************************************
//
//! Configures the polarity of an X-BAR output.
//!
//! \param base specifies the X-BAR base address.
//! \param output is the X-BAR output being configured.
//! The valid inputs are XBAR_OUTPUTy where y is from 1 to 16.
//! \param invert is a flag that determines whether the output is active-high
//! or active-low.
//!
//! The \e base parameter can take base addresses OUTPUTXBAR_BASE or
//! EPWMXBAR_BASE or CLBXBAR_BASE or MDLXBAR_BASE or ICLXBAR_BASE.
//!
//! This function inverts the Output X-BAR signal if the \e invert parameter is
//! \b true. If \e invert is \b false, the signal will be passed as is. The
//! \e output parameter is a value \b XBAR_OUTPUTy where y is the output
//! number between 1 and 16 inclusive.
//!
//! \return None.
//
//*****************************************************************************
__attribute__((section(".text.link2.XBAR_invertOutputSignal")))
__attribute__((always_inline))
static inline void
XBAR_invertOutputSignal(uint32_t base, XBAR_OutputNum output, bool invert)
{
    //
    // Check the arguments.
    //
    ASSERT(XBAR_isBaseValid(base));

    //
    // Set or clear the polarity setting bit based on the invert parameter.
    //
    if(invert)
    {
        HWREGH(base + XBAR_XBAROUTINVERT) |= 0x1U << ((uint16_t)output);
    }
    else
    {
        HWREGH(base + XBAR_XBAROUTINVERT) &= ~(0x1U << ((uint16_t)output));
    }
}

//*****************************************************************************
//
//! Locks the configuration of OUTPUT or CLB or PWM or MINDB or ICL X-BAR.
//!
//! \param base specifies the X-BAR base address.
//!
//! This function locks the configuration for the respective XBAR. Once the
//! configuration is locked, writes to the below registers for the XBAR is
//! blocked. For example, for OUTPUTXBAR, the registers affected are
//!        - OUTPUTXBAR Gx SEL
//!        - OUTPUTXBAR.Invert
//!
//! The \e base parameter can take base addresses OUTPUTXBAR_BASE or
//! EPWMXBAR_BASE or CLBXBAR_BASE or MDLXBAR_BASE or ICLXBAR_BASE.
//!
//! \return None.
//
// C28X_MIGRATION: XBAR_lockOutput
// C28X_MIGRATION: XBAR_lockEPWM
//
//*****************************************************************************
__attribute__((section(".text.link2.XBAR_lockConfiguration")))
__attribute__((always_inline))
static inline void
XBAR_lockConfiguration(uint32_t base)
{
    //
    // Check the arguments.
    //
    ASSERT(XBAR_isBaseValid(base));

    //
    // Lock the Output X-BAR with the LOCK register.
    // Write key 0x5A5A to the KEY bits and 1 to LOCK bit.
    //

    HWREG(base + XBAR_XBARLOCK_OFFSET) =
         ((uint32_t)0x5A5A << XBAR_XBARLOCK_KEY_S) |
         (uint32_t)XBAR_XBARLOCK_LOCK;
}

//*****************************************************************************
//
//! Selects the input to the Output X-BAR that determines the signal passed to
//! an output.
//!
//! \param base is the base address of the Output X-BAR.
//! \param output is the X-BAR output being configured.
//! \param source is the input source to the X-BAR output.
//!
//! This function selects an input to affect the Output X-BAR output. To
//! select multiple inputs, the function can be called multiple times with the
//! respective inputs. The X-BAR output would be an OR of the selected inputs.
//! The \e output parameter is a value \b XBAR_OUTPUTy where y is a output
//! number between 1 and 16 inclusive.
//!
//! \return None.
//
// C28X_MIGRATION: XBAR_setOutputMuxConfig
//
//*****************************************************************************
__attribute__((section(".text.link2.XBAR_selectOutputXbarInputSource")))
extern void
XBAR_selectOutputXbarInputSource(uint32_t base, XBAR_OutputNum output,
                           XBAR_OutputXbarInputSource source);

//*****************************************************************************
//
//! Deselects an input to the Output X-BAR
//!
//! \param base is the base address of the Output X-BAR.
//! \param output is the X-BAR output being configured.
//! \param source is the input source to the X-BAR output.
//!
//! This function deselects an input to not affect the Output X-BAR output. To
//! deselect multiple inputs, the function can be called multiple times with
//! the respective inputs. The X-BAR output would be an OR of only the selected
//! inputs. The \e output parameter is a value \b XBAR_OUTPUTy where y is a
//! output number between 1 and 16 inclusive.
//!
//! \return None.
//
//*****************************************************************************
__attribute__((section(".text.link2.XBAR_deselectOutputXbarInputSource")))
extern void
XBAR_deselectOutputXbarInputSource(uint32_t base, XBAR_OutputNum output,
                           XBAR_OutputXbarInputSource source);

//*****************************************************************************
//
//! Clears all the input source selection for the Output X-BAR output
//!
//! \param base is the base address of the Output X-BAR.
//! \param output is the X-BAR output.
//!
//! This function clears all the input source selections made for the specified
//! Output X-BAR output. The \e output parameter is a value \b XBAR_OUTPUTy
//! where y is a output number between 1 and 16 inclusive.
//!
//! \return None.
//
//*****************************************************************************
__attribute__((section(".text.link2.XBAR_clearOutputXbarSourceSelection")))
extern void
XBAR_clearOutputXbarSourceSelection(uint32_t base, XBAR_OutputNum output);

//*****************************************************************************
//
//! Selects the input to the EPWM X-BAR that determines the signal passed to
//! an output.
//!
//! \param trip is the EPWM X-BAR output(trip) being configured.
//! \param source is the input source to the X-BAR output.
//!
//! This function selects an input to affect the EPWM X-BAR output. To
//! select multiple inputs, the function can be called multiple times with the
//! respective inputs. The X-BAR output would be an OR of the selected inputs.
//! The \e output parameter is a value \b XBAR_TRIPy where y is a output
//! number between 1 and 16 inclusive.
//!
//! \return None.
//
// C28X_MIGRATION: XBAR_setEPWMMuxConfig
//
//*****************************************************************************
__attribute__((section(".text.link2.XBAR_selectEpwmXbarInputSource")))
extern void
XBAR_selectEpwmXbarInputSource(XBAR_TripNum trip,
                           XBAR_EpwmXbarInputSource source);

//*****************************************************************************
//
//! Deselects an input to the EPWM X-BAR
//!
//! \param trip is the EPWM X-BAR output(trip) being configured.
//! \param source is the input source to the X-BAR output.
//!
//! This function deselects an input to not affect the EPWM X-BAR output. To
//! deselect multiple inputs, the function can be called multiple times with
//! the respective inputs. The X-BAR output would be an OR of only the selected
//! inputs. The \e output parameter is a value \b XBAR_TRIPy where y is a
//! output number between 1 and 16 inclusive.
//!
//! \return None.
//
//*****************************************************************************
__attribute__((section(".text.link2.XBAR_deselectEpwmXbarInputSource")))
extern void
XBAR_deselectEpwmXbarInputSource(XBAR_TripNum trip,
                           XBAR_EpwmXbarInputSource source);

//*****************************************************************************
//
//! Clears all the input source selection for the EPWM X-BAR output
//!
//! \param output is the EPWM X-BAR output(trip).
//!
//! This function clears all the input source selections made for the specified
//! EPWM X-BAR output. The \e output parameter is a value \b XBAR_TRIPy where
//! y is a output number between 1 and 16 inclusive.
//!
//! \return None.
//
//*****************************************************************************
__attribute__((section(".text.link2.XBAR_clearEpwmXbarSourceSelection")))
extern void
XBAR_clearEpwmXbarSourceSelection(XBAR_TripNum trip);

//*****************************************************************************
//
//! Selects the input to the CLB X-BAR that determines the signal passed to
//! an output.
//!
//! \param auxSignal is the CLB X-BAR output(auxsig) being configured.
//! \param source is the input source to the X-BAR output.
//!
//! This function selects an input to affect the LCB X-BAR output. To
//! select multiple inputs, the function can be called multiple times with the
//! respective inputs. The X-BAR output would be an OR of the selected inputs.
//! The \e output parameter is a value \b XBAR_AUXSIGy where y is a output
//! number between 1 and 8 inclusive.
//!
//! \return None.
//
// C28X_MIGRATION: XBAR_setCLBMuxConfig
//
//*****************************************************************************
__attribute__((section(".text.link2.XBAR_selectClbXbarInputSource")))
extern void
XBAR_selectClbXbarInputSource(XBAR_AuxSigNum auxSignal,
                           XBAR_ClbXbarInputSource source);

//*****************************************************************************
//
//! Deselects an input to the CLB X-BAR
//!
//! \param auxSignal is the CLB X-BAR output(auxsig) being configured.
//! \param source is the input source to the X-BAR output.
//!
//! This function deselects an input to not affect the CLB X-BAR output. To
//! deselect multiple inputs, the function can be called multiple times with
//! the respective inputs. The X-BAR output would be an OR of only the selected
//! inputs. The \e output parameter is a value \b XBAR_AUXSIGy where y is a
//! output number between 1 and 8 inclusive.
//!
//! \return None.
//
//*****************************************************************************
__attribute__((section(".text.link2.XBAR_deselectClbXbarInputSource")))
extern void
XBAR_deselectClbXbarInputSource(XBAR_AuxSigNum auxSignal,
                           XBAR_ClbXbarInputSource source);

//*****************************************************************************
//
//! Clears all the input source selection for the CLB X-BAR output
//!
//! \param output is the CLB X-BAR output(auxsig).
//!
//! This function clears all the input source selections made for the specified
//! CLB X-BAR output. The \e output parameter is a value \b XBAR_AUXSIGy where
//! y is a output number between 1 and 8 inclusive.
//!
//! \return None.
//
//*****************************************************************************
__attribute__((section(".text.link2.XBAR_clearClbXbarSourceSelection")))
extern void
XBAR_clearClbXbarSourceSelection(XBAR_AuxSigNum auxSignal);

//*****************************************************************************
//
//! Selects the input to the MINDB X-BAR that determines the signal passed to
//! an output.
//!
//! \param output is the MINDB X-BAR output being configured.
//! \param source is the input source to the X-BAR output.
//!
//! This function selects an input to affect the MINDB X-BAR output. To
//! select multiple inputs, the function can be called multiple times with the
//! respective inputs. The X-BAR output would be an OR of the selected inputs.
//! The \e output parameter is a value \b XBAR_OUTPUTy where y is an output
//! number between 1 and 16 inclusive.
//!
//! \return None.
//
// C28X_MIGRATION: XBAR_setInputSignal
//
//*****************************************************************************
__attribute__((section(".text.link2.XBAR_selectMindbXbarInputSource")))
extern void
XBAR_selectMindbXbarInputSource(XBAR_OutputNum output,
                           XBAR_MindbXbarInputSource source);

//*****************************************************************************
//
//! Deselects an input to the MINDB X-BAR
//!
//! \param output is the MINDB X-BAR output being configured.
//! \param source is the input source to the X-BAR output.
//!
//! This function deselects an input to affect the MINDB X-BAR output. To
//! deselect multiple inputs, the function can be called multiple times with
//! the respective inputs. The X-BAR output would be an OR of only the selected
//! inputs. The \e output parameter is a value \b XBAR_OUTPUTy where y is an
//! output number between 1 and 16 inclusive.
//!
//! \return None.
//
//*****************************************************************************
__attribute__((section(".text.link2.XBAR_deselectMindbXbarInputSource")))
extern void
XBAR_deselectMindbXbarInputSource(XBAR_OutputNum output,
                           XBAR_MindbXbarInputSource source);

//*****************************************************************************
//
//! Clears all the input source selection for the MINDB X-BAR output
//!
//! \param output is the MINDB X-BAR output.
//!
//! This function clears all the input source selections made for the specified
//! MINDB X-BAR output. The \e output parameter is a value \b XBAR_OUTPUTy
//! where y is a output number between 1 and 16 inclusive.
//!
//! \return None.
//
//*****************************************************************************
__attribute__((section(".text.link2.XBAR_clearMindbXbarSourceSelection")))
extern void
XBAR_clearMindbXbarSourceSelection(XBAR_OutputNum output);

//*****************************************************************************
//
//! Selects the input to the ICL X-BAR that determines the signal passed to
//! an output.
//!
//! \param output is the ICL X-BAR output being configured.
//! \param source is the input source to the X-BAR output.
//!
//! This function selects an input to affect the ICL X-BAR output. To
//! select multiple inputs, the function can be called multiple times with the
//! respective inputs. The X-BAR output would be an OR of the selected inputs.
//! The \e output parameter is a value \b XBAR_OUTPUTy where y is a output
//! number between 1 and 16 inclusive.
//!
//! \return None.
//
// C28X_MIGRATION: XBAR_setInputSignal
//
//*****************************************************************************
__attribute__((section(".text.link2.XBAR_selectIclXbarInputSource")))
extern void
XBAR_selectIclXbarInputSource(XBAR_OutputNum output,
                           XBAR_IclXbarInputSource source);

//*****************************************************************************
//
//! Deselects an input to the ICL X-BAR
//!
//! \param output is the ICL X-BAR output being configured.
//! \param source is the input source to the X-BAR output.
//!
//! This function deselects an input to not affect the ICL X-BAR output. To
//! deselect multiple inputs, the function can be called multiple times with
//! the respective inputs. The X-BAR output would be an OR of only the selected
//! inputs. The \e output parameter is a value \b XBAR_OUTPUTy where y is a
//! output number between 1 and 16 inclusive.
//!
//! \return None.
//
//*****************************************************************************
__attribute__((section(".text.link2.XBAR_deselectIclXbarInputSource")))
extern void
XBAR_deselectIclXbarInputSource(XBAR_OutputNum output,
                           XBAR_IclXbarInputSource source);

//*****************************************************************************
//
//! Clears all the input source selection for the ICL X-BAR output
//!
//! \param output is the ICL X-BAR output.
//!
//! This function clears all the input source selections made for the specified
//! ICL X-BAR output. The \e output parameter is a value \b XBAR_OUTPUTy where
//! y is a output number between 1 and 16 inclusive.
//!
//! \return None.
//
//*****************************************************************************
__attribute__((section(".text.link2.XBAR_clearIclXbarSourceSelection")))
extern void
XBAR_clearIclXbarSourceSelection(XBAR_OutputNum output);

//*****************************************************************************
//
//! Returns the status of the input latch.
//!
//! \param inputFlag is the X-BAR input latch being checked. Values are in the
//! format of /b XBAR_INPUT_FLG_XXXX where "XXXX" is name of the signal.
//!
//! \return Returns \b true if the X-BAR input corresponding to the
//! \e inputFlag has been triggered. If not, it will return \b false.
//
//*****************************************************************************
extern bool
XBAR_getInputFlagStatus(XBAR_InputFlag inputFlag);

//*****************************************************************************
//
//! Clears the input latch for the specified input latch.
//!
//! \param inputFlag is the X-BAR input latch being cleared.
//!
//! This function clears the Input X-BAR input latch. The input latch to be
//! cleared is specified by the \e inputFlag parameter.
//!
//! \return None.
//
//*****************************************************************************
extern void
XBAR_clearInputFlag(XBAR_InputFlag inputFlag);


//*****************************************************************************
//
// Close the Doxygen group.
//! @}
//
//*****************************************************************************

//*****************************************************************************
//
// Mark the end of the C bindings section for C++ compilers.
//
//*****************************************************************************
#ifdef __cplusplus
}
#endif

#endif // XBAR_H
