local P = {}

function P.getPinSettings(pin)
  local pin_map = {
      GPIO_0_GPIO0                    =  0x00060000,
      GPIO_0_EPWM1_A                  =  0x00060001,
      GPIO_0_OUTPUTXBAR7              =  0x00060003,
      GPIO_0_SCIA_RX                  =  0x00060005,
      GPIO_0_I2CA_SDA                 =  0x00060006,
      GPIO_0_SPIA_PTE                 =  0x00060007,
      GPIO_0_FSIRXA_CLK               =  0x00060009,
      GPIO_0_MCANA_RX                 =  0x0006000A,
      GPIO_0_CLB_OUTPUTXBAR8          =  0x0006000B,
      GPIO_0_EQEP1_INDEX              =  0x0006000D,
      GPIO_0_EPWM3_A                  =  0x0006000F,

      GPIO_1_GPIO1                    =  0x00060200,
      GPIO_1_EPWM1_B                  =  0x00060201,
      GPIO_1_SCIA_TX                  =  0x00060205,
      GPIO_1_I2CA_SCL                 =  0x00060206,
      GPIO_1_SPIA_POCI                =  0x00060207,
      GPIO_1_EQEP1_STROBE             =  0x00060209,
      GPIO_1_MCANA_TX                 =  0x0006020A,
      GPIO_1_CLB_OUTPUTXBAR7          =  0x0006020B,
      GPIO_1_EPWM10_B                 =  0x0006020D,
      GPIO_1_EPWM3_B                  =  0x0006020F,

      GPIO_2_GPIO2                    =  0x00060400,
      GPIO_2_EPWM2_A                  =  0x00060401,
      GPIO_2_OUTPUTXBAR1              =  0x00060405,
      GPIO_2_PMBUSA_SDA               =  0x00060406,
      GPIO_2_SPIA_PICO                =  0x00060407,
      GPIO_2_SCIA_TX                  =  0x00060409,
      GPIO_2_FSIRXA_D1                =  0x0006040A,
      GPIO_2_I2CB_SDA                 =  0x0006040B,
      GPIO_2_EPWM10_A                 =  0x0006040D,
      GPIO_2_MCANB_TX                 =  0x0006040E,
      GPIO_2_EPWM4_A                  =  0x0006040F,

      GPIO_3_GPIO3                    =  0x00060600,
      GPIO_3_EPWM2_B                  =  0x00060601,
      GPIO_3_OUTPUTXBAR2              =  0x00060602,
      GPIO_3_PMBUSA_SCL               =  0x00060606,
      GPIO_3_SPIA_CLK                 =  0x00060607,
      GPIO_3_SCIA_RX                  =  0x00060609,
      GPIO_3_FSIRXA_D0                =  0x0006060A,
      GPIO_3_I2CB_SCL                 =  0x0006060B,
      GPIO_3_MCANB_RX                 =  0x0006060E,
      GPIO_3_EPWM4_B                  =  0x0006060F,

      GPIO_4_GPIO4                    =  0x00060800,
      GPIO_4_EPWM3_A                  =  0x00060801,
      GPIO_4_I2CA_SCL                 =  0x00060802,
      GPIO_4_MCANA_TX                 =  0x00060803,
      GPIO_4_OUTPUTXBAR3              =  0x00060805,
      GPIO_4_SPIB_CLK                 =  0x00060807,
      GPIO_4_EQEP2_STROBE             =  0x00060809,
      GPIO_4_FSIRXA_CLK               =  0x0006080A,
      GPIO_4_CLB_OUTPUTXBAR6          =  0x0006080B,
      GPIO_4_EPWM11_B                 =  0x0006080D,
      GPIO_4_SPIA_POCI                =  0x0006080E,
      GPIO_4_EPWM1_A                  =  0x0006080F,

      GPIO_5_GPIO5                    =  0x00060A00,
      GPIO_5_EPWM3_B                  =  0x00060A01,
      GPIO_5_I2CA_SDA                 =  0x00060A02,
      GPIO_5_OUTPUTXBAR3              =  0x00060A03,
      GPIO_5_MCANA_RX                 =  0x00060A05,
      GPIO_5_SPIA_PTE                 =  0x00060A07,
      GPIO_5_FSITXA_D1                =  0x00060A09,
      GPIO_5_CLB_OUTPUTXBAR5          =  0x00060A0A,
      GPIO_5_SCIA_RX                  =  0x00060A0B,
      GPIO_5_EPWM1_B                  =  0x00060A0F,

      GPIO_6_GPIO6                    =  0x00060C00,
      GPIO_6_EPWM4_A                  =  0x00060C01,
      GPIO_6_OUTPUTXBAR4              =  0x00060C02,
      GPIO_6_SYNCOUT                  =  0x00060C03,
      GPIO_6_EQEP1_A                  =  0x00060C05,
      GPIO_6_SPIB_POCI                =  0x00060C07,
      GPIO_6_FSITXA_D0                =  0x00060C09,
      GPIO_6_FSITXA_D1                =  0x00060C0B,
      GPIO_6_CLB_OUTPUTXBAR8          =  0x00060C0E,
      GPIO_6_EPWM2_A                  =  0x00060C0F,

      GPIO_7_GPIO7                    =  0x00060E00,
      GPIO_7_EPWM4_B                  =  0x00060E01,
      GPIO_7_EPWM2_A                  =  0x00060E02,
      GPIO_7_OUTPUTXBAR5              =  0x00060E03,
      GPIO_7_EQEP1_B                  =  0x00060E05,
      GPIO_7_SPIB_PICO                =  0x00060E07,
      GPIO_7_FSITXA_CLK               =  0x00060E09,
      GPIO_7_CLB_OUTPUTXBAR2          =  0x00060E0A,
      GPIO_7_SCIA_TX                  =  0x00060E0B,
      GPIO_7_MCANA_TX                 =  0x00060E0E,
      GPIO_7_EPWM2_B                  =  0x00060E0F,

      GPIO_8_GPIO8                    =  0x00061000,
      GPIO_8_EPWM5_A                  =  0x00061001,
      GPIO_8_ADCSOCAO                 =  0x00061003,
      GPIO_8_EQEP1_STROBE             =  0x00061005,
      GPIO_8_SCIA_TX                  =  0x00061006,
      GPIO_8_SPIA_PICO                =  0x00061007,
      GPIO_8_I2CA_SCL                 =  0x00061009,
      GPIO_8_FSITXA_D1                =  0x0006100A,
      GPIO_8_CLB_OUTPUTXBAR5          =  0x0006100B,
      GPIO_8_EPWM11_A                 =  0x0006100D,

      GPIO_9_GPIO9                    =  0x00061200,
      GPIO_9_EPWM5_B                  =  0x00061201,
      GPIO_9_SCIB_TX                  =  0x00061202,
      GPIO_9_OUTPUTXBAR6              =  0x00061203,
      GPIO_9_EQEP1_INDEX              =  0x00061205,
      GPIO_9_SCIA_RX                  =  0x00061206,
      GPIO_9_SPIA_CLK                 =  0x00061207,
      GPIO_9_I2CA_SCL                 =  0x00061209,
      GPIO_9_FSITXA_D0                =  0x0006120A,
      GPIO_9_LINA_RX                  =  0x0006120B,
      GPIO_9_PMBUSA_SCL               =  0x0006120D,
      GPIO_9_I2CB_SCL                 =  0x0006120E,
      GPIO_9_EQEP3_B                  =  0x0006120F,

      GPIO_10_GPIO10                  =  0x00061400,
      GPIO_10_EPWM6_A                 =  0x00061401,
      GPIO_10_ADCSOCBO                =  0x00061403,
      GPIO_10_EQEP1_A                 =  0x00061405,
      GPIO_10_SCIB_TX                 =  0x00061406,
      GPIO_10_SPIA_POCI               =  0x00061407,
      GPIO_10_I2CA_SDA                =  0x00061409,
      GPIO_10_FSITXA_CLK              =  0x0006140A,
      GPIO_10_LINA_TX                 =  0x0006140B,
      GPIO_10_EQEP3_STROBE            =  0x0006140D,
      GPIO_10_CLB_OUTPUTXBAR4         =  0x0006140F,

      GPIO_11_GPIO11                  =  0x00061600,
      GPIO_11_EPWM6_B                 =  0x00061601,
      GPIO_11_MCANA_RX                =  0x00061602,
      GPIO_11_OUTPUTXBAR7             =  0x00061603,
      GPIO_11_EQEP1_B                 =  0x00061605,
      GPIO_11_SCIB_RX                 =  0x00061606,
      GPIO_11_SPIA_PTE                =  0x00061607,
      GPIO_11_FSIRXA_D1               =  0x00061609,
      GPIO_11_LINA_RX                 =  0x0006160A,
      GPIO_11_EQEP2_A                 =  0x0006160B,
      GPIO_11_SPIA_PICO               =  0x0006160D,
      GPIO_11_EQEP3_INDEX             =  0x0006160F,

      GPIO_12_GPIO12                  =  0x00061800,
      GPIO_12_EPWM7_A                 =  0x00061801,
      GPIO_12_MCANA_RX                =  0x00061803,
      GPIO_12_EQEP1_STROBE            =  0x00061805,
      GPIO_12_SCIB_TX                 =  0x00061806,
      GPIO_12_PMBUSA_CTL              =  0x00061807,
      GPIO_12_FSIRXA_D0               =  0x00061809,
      GPIO_12_LINA_TX                 =  0x0006180A,
      GPIO_12_SPIA_CLK                =  0x0006180B,

      GPIO_13_GPIO13                  =  0x00061A00,
      GPIO_13_EPWM7_B                 =  0x00061A01,
      GPIO_13_MCANA_TX                =  0x00061A03,
      GPIO_13_EQEP1_INDEX             =  0x00061A05,
      GPIO_13_SCIB_RX                 =  0x00061A06,
      GPIO_13_PMBUSA_ALERT            =  0x00061A07,
      GPIO_13_FSIRXA_CLK              =  0x00061A09,
      GPIO_13_LINA_RX                 =  0x00061A0A,
      GPIO_13_SPIA_POCI               =  0x00061A0B,

      GPIO_14_GPIO14                  =  0x00061C00,
      GPIO_14_EPWM8_A                 =  0x00061C01,
      GPIO_14_SCIB_TX                 =  0x00061C02,
      GPIO_14_I2CB_SDA                =  0x00061C05,
      GPIO_14_OUTPUTXBAR3             =  0x00061C06,
      GPIO_14_PMBUSA_SDA              =  0x00061C07,
      GPIO_14_SPIB_CLK                =  0x00061C09,
      GPIO_14_EQEP2_A                 =  0x00061C0A,
      GPIO_14_LINA_TX                 =  0x00061C0B,
      GPIO_14_EPWM3_A                 =  0x00061C0D,
      GPIO_14_CLB_OUTPUTXBAR7         =  0x00061C0E,

      GPIO_15_GPIO15                  =  0x00061E00,
      GPIO_15_EPWM8_B                 =  0x00061E01,
      GPIO_15_SCIB_RX                 =  0x00061E02,
      GPIO_15_I2CB_SCL                =  0x00061E05,
      GPIO_15_OUTPUTXBAR4             =  0x00061E06,
      GPIO_15_PMBUSA_SCL              =  0x00061E07,
      GPIO_15_SPIB_PTE                =  0x00061E09,
      GPIO_15_EQEP2_B                 =  0x00061E0A,
      GPIO_15_LINA_RX                 =  0x00061E0B,
      GPIO_15_EPWM3_B                 =  0x00061E0D,
      GPIO_15_CLB_OUTPUTXBAR6         =  0x00061E0E,

      GPIO_16_GPIO16                  =  0x00080000,
      GPIO_16_SPIA_PICO               =  0x00080001,
      GPIO_16_OUTPUTXBAR7             =  0x00080003,
      GPIO_16_EPWM9_A                 =  0x00080005,
      GPIO_16_SCIA_TX                 =  0x00080006,
      GPIO_16_EQEP1_STROBE            =  0x00080009,
      GPIO_16_PMBUSA_SCL              =  0x0008000A,
      GPIO_16_XCLKOUT                 =  0x0008000B,
      GPIO_16_EQEP2_B                 =  0x0008000D,
      GPIO_16_SPIB_POCI               =  0x0008000E,
      GPIO_16_EQEP3_STROBE            =  0x0008000F,

      GPIO_17_GPIO17                  =  0x00080200,
      GPIO_17_SPIA_POCI               =  0x00080201,
      GPIO_17_OUTPUTXBAR8             =  0x00080203,
      GPIO_17_EPWM9_B                 =  0x00080205,
      GPIO_17_SCIA_RX                 =  0x00080206,
      GPIO_17_EQEP1_INDEX             =  0x00080209,
      GPIO_17_PMBUSA_SDA              =  0x0008020A,
      GPIO_17_MCANA_TX                =  0x0008020B,
      GPIO_17_EPWM6_A                 =  0x0008020E,

      GPIO_18_GPIO18                  =  0x00080400,
      GPIO_18_SPIA_CLK                =  0x00080401,
      GPIO_18_SCIB_TX                 =  0x00080402,
      GPIO_18_MCANB_RX                =  0x00080403,
      GPIO_18_EPWM6_A                 =  0x00080405,
      GPIO_18_I2CA_SCL                =  0x00080406,
      GPIO_18_EQEP2_A                 =  0x00080409,
      GPIO_18_PMBUSA_CTL              =  0x0008040A,
      GPIO_18_XCLKOUT                 =  0x0008040B,
      GPIO_18_LINA_TX                 =  0x0008040D,
      GPIO_18_EQEP3_INDEX             =  0x0008040F,

      GPIO_19_GPIO19                  =  0x00080600,
      GPIO_19_SPIA_PTE                =  0x00080601,
      GPIO_19_SCIB_RX                 =  0x00080602,
      GPIO_19_MCANB_TX                =  0x00080603,
      GPIO_19_EPWM6_B                 =  0x00080605,
      GPIO_19_I2CA_SDA                =  0x00080606,
      GPIO_19_EQEP2_B                 =  0x00080609,
      GPIO_19_PMBUSA_ALERT            =  0x0008060A,
      GPIO_19_CLB_OUTPUTXBAR1         =  0x0008060B,
      GPIO_19_LINA_RX                 =  0x0008060D,

      GPIO_20_GPIO20                  =  0x00080800,
      GPIO_20_EQEP1_A                 =  0x00080801,
      GPIO_20_EPWM12_A                =  0x00080805,
      GPIO_20_SPIB_PICO               =  0x00080806,
      GPIO_20_MCANA_TX                =  0x00080809,
      GPIO_20_ADCE_EXTMUXSEL0         =  0x0008080A,
      GPIO_20_I2CA_SCL                =  0x0008080B,
      GPIO_20_SCIC_TX                 =  0x0008080F,

      GPIO_21_GPIO21                  =  0x00080A00,
      GPIO_21_EQEP1_B                 =  0x00080A01,
      GPIO_21_EPWM12_B                =  0x00080A05,
      GPIO_21_SPIB_POCI               =  0x00080A06,
      GPIO_21_MCANA_RX                =  0x00080A09,
      GPIO_21_ADCE_EXTMUXSEL1         =  0x00080A0A,
      GPIO_21_I2CA_SDA                =  0x00080A0B,
      GPIO_21_SCIC_RX                 =  0x00080A0F,

      GPIO_22_GPIO22                  =  0x00080C00,
      GPIO_22_EQEP1_STROBE            =  0x00080C01,
      GPIO_22_SCIB_TX                 =  0x00080C03,
      GPIO_22_SPIB_CLK                =  0x00080C06,
      GPIO_22_LINA_TX                 =  0x00080C09,
      GPIO_22_CLB_OUTPUTXBAR1         =  0x00080C0A,
      GPIO_22_EPWM4_A                 =  0x00080C0E,
      GPIO_22_EQEP3_A                 =  0x00080C0F,

      GPIO_23_GPIO23                  =  0x00080E00,
      GPIO_23_EQEP1_INDEX             =  0x00080E01,
      GPIO_23_SCIB_RX                 =  0x00080E03,
      GPIO_23_SPIB_PTE                =  0x00080E06,
      GPIO_23_LINA_RX                 =  0x00080E09,
      GPIO_23_CLB_OUTPUTXBAR3         =  0x00080E0A,
      GPIO_23_EPWM12_A                =  0x00080E0D,
      GPIO_23_EPWM4_B                 =  0x00080E0E,

      GPIO_24_GPIO24                  =  0x00081000,
      GPIO_24_OUTPUTXBAR1             =  0x00081001,
      GPIO_24_EQEP2_A                 =  0x00081002,
      GPIO_24_SPIA_PTE                =  0x00081003,
      GPIO_24_EPWM8_A                 =  0x00081005,
      GPIO_24_SPIB_PICO               =  0x00081006,
      GPIO_24_LINA_TX                 =  0x00081009,
      GPIO_24_PMBUSA_SCL              =  0x0008100A,
      GPIO_24_SCIA_TX                 =  0x0008100B,
      GPIO_24_ERRORSTS                =  0x0008100D,
      GPIO_24_EPWM9_A                 =  0x0008100E,

      GPIO_25_GPIO25                  =  0x00081200,
      GPIO_25_OUTPUTXBAR2             =  0x00081201,
      GPIO_25_EQEP2_B                 =  0x00081202,
      GPIO_25_EQEP1_A                 =  0x00081205,
      GPIO_25_SPIB_POCI               =  0x00081206,
      GPIO_25_FSITXA_D1               =  0x00081209,
      GPIO_25_PMBUSA_SDA              =  0x0008120A,
      GPIO_25_SCIA_RX                 =  0x0008120B,
      GPIO_25_EQEP3_A                 =  0x0008120D,

      GPIO_26_GPIO26                  =  0x00081400,
      GPIO_26_OUTPUTXBAR3             =  0x00081401,
      GPIO_26_EQEP2_INDEX             =  0x00081402,
      GPIO_26_SPIB_CLK                =  0x00081406,
      GPIO_26_FSITXA_D0               =  0x00081409,
      GPIO_26_PMBUSA_CTL              =  0x0008140A,
      GPIO_26_I2CA_SDA                =  0x0008140B,
      GPIO_26_EQEP3_B                 =  0x0008140D,

      GPIO_27_GPIO27                  =  0x00081600,
      GPIO_27_OUTPUTXBAR4             =  0x00081601,
      GPIO_27_EQEP2_STROBE            =  0x00081602,
      GPIO_27_SPIB_PTE                =  0x00081606,
      GPIO_27_FSITXA_CLK              =  0x00081609,
      GPIO_27_PMBUSA_ALERT            =  0x0008160A,
      GPIO_27_I2CA_SCL                =  0x0008160B,
      GPIO_27_EQEP3_STROBE            =  0x0008160D,

      GPIO_28_GPIO28                  =  0x00081800,
      GPIO_28_SCIA_RX                 =  0x00081801,
      GPIO_28_EPWM7_A                 =  0x00081803,
      GPIO_28_OUTPUTXBAR5             =  0x00081805,
      GPIO_28_EQEP1_A                 =  0x00081806,
      GPIO_28_EQEP2_STROBE            =  0x00081809,
      GPIO_28_LINA_TX                 =  0x0008180A,
      GPIO_28_SPIB_CLK                =  0x0008180B,
      GPIO_28_ERRORSTS                =  0x0008180D,
      GPIO_28_I2CB_SDA                =  0x0008180E,

      GPIO_29_GPIO29                  =  0x00081A00,
      GPIO_29_SCIA_TX                 =  0x00081A01,
      GPIO_29_EPWM7_B                 =  0x00081A03,
      GPIO_29_OUTPUTXBAR6             =  0x00081A05,
      GPIO_29_EQEP1_B                 =  0x00081A06,
      GPIO_29_EQEP2_INDEX             =  0x00081A09,
      GPIO_29_LINA_RX                 =  0x00081A0A,
      GPIO_29_SPIB_PTE                =  0x00081A0B,
      GPIO_29_ERRORSTS                =  0x00081A0D,
      GPIO_29_I2CB_SCL                =  0x00081A0E,

      GPIO_30_GPIO30                  =  0x00081C00,
      GPIO_30_SPIB_PICO               =  0x00081C03,
      GPIO_30_OUTPUTXBAR7             =  0x00081C05,
      GPIO_30_EQEP1_STROBE            =  0x00081C06,
      GPIO_30_FSIRXA_CLK              =  0x00081C09,
      GPIO_30_MCANA_RX                =  0x00081C0A,
      GPIO_30_EPWM1_A                 =  0x00081C0B,
      GPIO_30_EQEP3_INDEX             =  0x00081C0D,

      GPIO_31_GPIO31                  =  0x00081E00,
      GPIO_31_SPIB_POCI               =  0x00081E03,
      GPIO_31_OUTPUTXBAR8             =  0x00081E05,
      GPIO_31_EQEP1_INDEX             =  0x00081E06,
      GPIO_31_FSIRXA_D1               =  0x00081E09,
      GPIO_31_MCANA_TX                =  0x00081E0A,
      GPIO_31_EPWM1_B                 =  0x00081E0B,

      GPIO_32_GPIO32                  =  0x00460000,
      GPIO_32_I2CA_SDA                =  0x00460001,
      GPIO_32_EQEP1_INDEX             =  0x00460002,
      GPIO_32_SPIB_CLK                =  0x00460003,
      GPIO_32_EPWM8_B                 =  0x00460005,
      GPIO_32_LINA_TX                 =  0x00460006,
      GPIO_32_FSIRXA_D0               =  0x00460009,
      GPIO_32_MCANB_TX                =  0x0046000A,
      GPIO_32_PMBUSA_SDA              =  0x0046000B,
      GPIO_32_ADCSOCBO                =  0x0046000D,

      GPIO_33_GPIO33                  =  0x00460200,
      GPIO_33_I2CA_SCL                =  0x00460201,
      GPIO_33_SPIB_PTE                =  0x00460203,
      GPIO_33_OUTPUTXBAR4             =  0x00460205,
      GPIO_33_LINA_RX                 =  0x00460206,
      GPIO_33_FSIRXA_CLK              =  0x00460209,
      GPIO_33_MCANB_RX                =  0x0046020A,
      GPIO_33_EQEP2_B                 =  0x0046020B,
      GPIO_33_ADCSOCAO                =  0x0046020D,
      GPIO_33_SCIC_RX                 =  0x0046020F,

      GPIO_34_GPIO34                  =  0x00460400,
      GPIO_34_OUTPUTXBAR1             =  0x00460401,
      GPIO_34_PMBUSA_SDA              =  0x00460406,
      GPIO_34_I2CB_SDA                =  0x0046040E,

      GPIO_35_GPIO35                  =  0x00460600,
      GPIO_35_SCIA_RX                 =  0x00460601,
      GPIO_35_SPIA_POCI               =  0x00460602,
      GPIO_35_I2CA_SDA                =  0x00460603,
      GPIO_35_MCANB_RX                =  0x00460605,
      GPIO_35_PMBUSA_SCL              =  0x00460606,
      GPIO_35_LINA_RX                 =  0x00460607,
      GPIO_35_EQEP1_A                 =  0x00460609,
      GPIO_35_PMBUSA_CTL              =  0x0046060A,
      GPIO_35_EPWM5_B                 =  0x0046060B,
      GPIO_35_TDI                     =  0x0046060F,

      GPIO_37_GPIO37                  =  0x00460A00,
      GPIO_37_OUTPUTXBAR2             =  0x00460A01,
      GPIO_37_SPIA_PTE                =  0x00460A02,
      GPIO_37_I2CA_SCL                =  0x00460A03,
      GPIO_37_SCIA_TX                 =  0x00460A05,
      GPIO_37_MCANB_TX                =  0x00460A06,
      GPIO_37_LINA_TX                 =  0x00460A07,
      GPIO_37_EQEP1_B                 =  0x00460A09,
      GPIO_37_PMBUSA_ALERT            =  0x00460A0A,
      GPIO_37_EPWM5_A                 =  0x00460A0B,
      GPIO_37_TDO                     =  0x00460A0F,

      GPIO_40_GPIO40                  =  0x00461000,
      GPIO_40_SPIB_PICO               =  0x00461001,
      GPIO_40_EPWM2_B                 =  0x00461005,
      GPIO_40_PMBUSA_SDA              =  0x00461006,
      GPIO_40_FSIRXA_D0               =  0x00461007,
      GPIO_40_SCIB_TX                 =  0x00461009,
      GPIO_40_EQEP1_A                 =  0x0046100A,
      GPIO_40_LINA_TX                 =  0x0046100B,
      GPIO_40_CLB_OUTPUTXBAR4         =  0x0046100E,
      GPIO_40_EQEP3_STROBE            =  0x0046100F,

      GPIO_41_GPIO41                  =  0x00461200,
      GPIO_41_EPWM7_A                 =  0x00461201,
      GPIO_41_EPWM2_A                 =  0x00461205,
      GPIO_41_PMBUSA_SCL              =  0x00461206,
      GPIO_41_FSIRXA_D1               =  0x00461207,
      GPIO_41_SCIB_RX                 =  0x00461209,
      GPIO_41_EQEP1_B                 =  0x0046120A,
      GPIO_41_LINA_RX                 =  0x0046120B,
      GPIO_41_EPWM12_B                =  0x0046120D,
      GPIO_41_SPIB_POCI               =  0x0046120E,

      GPIO_42_GPIO42                  =  0x00461400,
      GPIO_42_LINA_RX                 =  0x00461402,
      GPIO_42_OUTPUTXBAR5             =  0x00461403,
      GPIO_42_PMBUSA_CTL              =  0x00461405,
      GPIO_42_I2CA_SDA                =  0x00461406,
      GPIO_42_SCIC_RX                 =  0x00461407,
      GPIO_42_EQEP1_STROBE            =  0x0046140A,
      GPIO_42_CLB_OUTPUTXBAR3         =  0x0046140B,

      GPIO_43_GPIO43                  =  0x00461600,
      GPIO_43_OUTPUTXBAR6             =  0x00461603,
      GPIO_43_PMBUSA_ALERT            =  0x00461605,
      GPIO_43_I2CA_SCL                =  0x00461606,
      GPIO_43_SCIC_TX                 =  0x00461607,
      GPIO_43_EQEP1_INDEX             =  0x0046160A,
      GPIO_43_CLB_OUTPUTXBAR4         =  0x0046160B,

      GPIO_44_GPIO44                  =  0x00461800,
      GPIO_44_OUTPUTXBAR7             =  0x00461803,
      GPIO_44_EQEP1_A                 =  0x00461805,
      GPIO_44_PMBUSA_SDA              =  0x00461806,
      GPIO_44_FSITXA_CLK              =  0x00461807,
      GPIO_44_PMBUSA_CTL              =  0x00461809,
      GPIO_44_CLB_OUTPUTXBAR3         =  0x0046180A,
      GPIO_44_FSIRXA_D0               =  0x0046180B,
      GPIO_44_LINA_TX                 =  0x0046180E,

      GPIO_45_GPIO45                  =  0x00461A00,
      GPIO_45_OUTPUTXBAR8             =  0x00461A03,
      GPIO_45_FSITXA_D0               =  0x00461A07,
      GPIO_45_PMBUSA_ALERT            =  0x00461A09,
      GPIO_45_CLB_OUTPUTXBAR4         =  0x00461A0A,

      GPIO_46_GPIO46                  =  0x00461C00,
      GPIO_46_LINA_TX                 =  0x00461C03,
      GPIO_46_MCANA_TX                =  0x00461C05,
      GPIO_46_FSITXA_D1               =  0x00461C07,
      GPIO_46_PMBUSA_SDA              =  0x00461C09,

      GPIO_47_GPIO47                  =  0x00461E00,
      GPIO_47_LINA_RX                 =  0x00461E03,
      GPIO_47_MCANA_RX                =  0x00461E05,
      GPIO_47_CLB_OUTPUTXBAR2         =  0x00461E07,
      GPIO_47_PMBUSA_SCL              =  0x00461E09,

      GPIO_48_GPIO48                  =  0x00480000,
      GPIO_48_OUTPUTXBAR3             =  0x00480001,
      GPIO_48_MCANA_TX                =  0x00480005,
      GPIO_48_SCIA_TX                 =  0x00480006,
      GPIO_48_PMBUSA_SDA              =  0x00480009,

      GPIO_49_GPIO49                  =  0x00480200,
      GPIO_49_OUTPUTXBAR4             =  0x00480201,
      GPIO_49_MCANA_RX                =  0x00480205,
      GPIO_49_SCIA_RX                 =  0x00480206,
      GPIO_49_LINA_RX                 =  0x00480209,
      GPIO_49_FSITXA_D0               =  0x0048020E,

      GPIO_50_GPIO50                  =  0x00480400,
      GPIO_50_EQEP1_A                 =  0x00480401,
      GPIO_50_MCANA_TX                =  0x00480405,
      GPIO_50_SPIB_PICO               =  0x00480406,
      GPIO_50_I2CB_SDA                =  0x00480409,
      GPIO_50_FSITXA_D1               =  0x0048040E,

      GPIO_51_GPIO51                  =  0x00480600,
      GPIO_51_EQEP1_B                 =  0x00480601,
      GPIO_51_MCANA_RX                =  0x00480605,
      GPIO_51_SPIB_POCI               =  0x00480606,
      GPIO_51_I2CB_SCL                =  0x00480609,
      GPIO_51_FSITXA_CLK              =  0x0048060E,

      GPIO_52_GPIO52                  =  0x00480800,
      GPIO_52_EQEP1_STROBE            =  0x00480801,
      GPIO_52_CLB_OUTPUTXBAR5         =  0x00480805,
      GPIO_52_SPIB_CLK                =  0x00480806,
      GPIO_52_SYNCOUT                 =  0x00480809,
      GPIO_52_FSIRXA_D0               =  0x0048080E,

      GPIO_53_GPIO53                  =  0x00480A00,
      GPIO_53_EQEP1_INDEX             =  0x00480A01,
      GPIO_53_CLB_OUTPUTXBAR6         =  0x00480A05,
      GPIO_53_SPIB_PTE                =  0x00480A06,
      GPIO_53_ADCSOCAO                =  0x00480A09,
      GPIO_53_MCANB_RX                =  0x00480A0A,
      GPIO_53_FSIRXA_D1               =  0x00480A0E,

      GPIO_54_GPIO54                  =  0x00480C00,
      GPIO_54_SPIA_PICO               =  0x00480C01,
      GPIO_54_EQEP2_A                 =  0x00480C05,
      GPIO_54_OUTPUTXBAR2             =  0x00480C06,
      GPIO_54_ADCSOCBO                =  0x00480C09,
      GPIO_54_LINA_TX                 =  0x00480C0A,
      GPIO_54_FSIRXA_CLK              =  0x00480C0E,

      GPIO_55_GPIO55                  =  0x00480E00,
      GPIO_55_SPIA_POCI               =  0x00480E01,
      GPIO_55_EQEP2_B                 =  0x00480E05,
      GPIO_55_OUTPUTXBAR3             =  0x00480E06,
      GPIO_55_ERRORSTS                =  0x00480E09,
      GPIO_55_LINA_RX                 =  0x00480E0A,

      GPIO_56_GPIO56                  =  0x00481000,
      GPIO_56_SPIA_CLK                =  0x00481001,
      GPIO_56_CLB_OUTPUTXBAR7         =  0x00481002,
      GPIO_56_MCANA_TX                =  0x00481003,
      GPIO_56_EQEP2_STROBE            =  0x00481005,
      GPIO_56_SCIB_TX                 =  0x00481006,
      GPIO_56_SPIB_PICO               =  0x00481009,
      GPIO_56_I2CA_SDA                =  0x0048100A,
      GPIO_56_EQEP1_A                 =  0x0048100B,
      GPIO_56_FSIRXA_D1               =  0x0048100E,

      GPIO_57_GPIO57                  =  0x00481200,
      GPIO_57_SPIA_PTE                =  0x00481201,
      GPIO_57_CLB_OUTPUTXBAR8         =  0x00481202,
      GPIO_57_MCANA_RX                =  0x00481203,
      GPIO_57_EQEP2_INDEX             =  0x00481205,
      GPIO_57_SCIB_RX                 =  0x00481206,
      GPIO_57_SPIB_POCI               =  0x00481209,
      GPIO_57_I2CA_SCL                =  0x0048120A,
      GPIO_57_EQEP1_B                 =  0x0048120B,
      GPIO_57_FSIRXA_CLK              =  0x0048120E,

      GPIO_58_GPIO58                  =  0x00481400,
      GPIO_58_OUTPUTXBAR1             =  0x00481405,
      GPIO_58_SPIB_CLK                =  0x00481406,
      GPIO_58_LINA_TX                 =  0x00481409,
      GPIO_58_MCANB_TX                =  0x0048140A,
      GPIO_58_EQEP1_STROBE            =  0x0048140B,
      GPIO_58_FSIRXA_D0               =  0x0048140E,

      GPIO_59_GPIO59                  =  0x00481600,
      GPIO_59_OUTPUTXBAR2             =  0x00481605,
      GPIO_59_SPIB_PTE                =  0x00481606,
      GPIO_59_LINA_RX                 =  0x00481609,
      GPIO_59_MCANB_RX                =  0x0048160A,
      GPIO_59_EQEP1_INDEX             =  0x0048160B,

      GPIO_60_GPIO60                  =  0x00481800,
      GPIO_60_EPWM12_B                =  0x00481801,
      GPIO_60_MCANA_TX                =  0x00481803,
      GPIO_60_OUTPUTXBAR3             =  0x00481805,
      GPIO_60_SPIB_PICO               =  0x00481806,

      GPIO_61_GPIO61                  =  0x00481A00,
      GPIO_61_MCANA_RX                =  0x00481A03,
      GPIO_61_OUTPUTXBAR4             =  0x00481A05,
      GPIO_61_SPIB_POCI               =  0x00481A06,
      GPIO_61_MCANB_RX                =  0x00481A0E,

      GPIO_62_GPIO62                  =  0x00481C00,
      GPIO_62_EPWM10_A                =  0x00481C01,
      GPIO_62_OUTPUTXBAR3             =  0x00481C02,
      GPIO_62_MCANA_TX                =  0x00481C05,
      GPIO_62_SCIA_TX                 =  0x00481C06,
      GPIO_62_PMBUSA_SDA              =  0x00481C09,

      GPIO_63_GPIO63                  =  0x00481E00,
      GPIO_63_EPWM10_B                =  0x00481E01,
      GPIO_63_OUTPUTXBAR4             =  0x00481E02,
      GPIO_63_MCANA_RX                =  0x00481E05,
      GPIO_63_SCIA_RX                 =  0x00481E06,
      GPIO_63_LINA_RX                 =  0x00481E09,

      GPIO_64_GPIO64                  =  0x00860000,
      GPIO_64_SCIA_RX                 =  0x00860001,
      GPIO_64_EPWM11_A                =  0x00860002,
      GPIO_64_EPWM7_A                 =  0x00860003,
      GPIO_64_OUTPUTXBAR5             =  0x00860005,
      GPIO_64_EQEP1_A                 =  0x00860006,
      GPIO_64_EQEP2_STROBE            =  0x00860009,
      GPIO_64_LINA_TX                 =  0x0086000A,
      GPIO_64_SPIB_CLK                =  0x0086000B,
      GPIO_64_ERRORSTS                =  0x0086000D,
      GPIO_64_I2CB_SDA                =  0x0086000E,

      GPIO_65_GPIO65                  =  0x00860200,
      GPIO_65_EQEP1_A                 =  0x00860201,
      GPIO_65_EPWM11_B                =  0x00860202,
      GPIO_65_SPIB_PICO               =  0x00860206,
      GPIO_65_MCANA_TX                =  0x00860209,
      GPIO_65_I2CA_SCL                =  0x0086020B,

      GPIO_66_GPIO66                  =  0x00860400,
      GPIO_66_EQEP1_B                 =  0x00860401,
      GPIO_66_EPWM12_A                =  0x00860402,
      GPIO_66_SPIB_POCI               =  0x00860406,
      GPIO_66_MCANA_RX                =  0x00860409,
      GPIO_66_I2CA_SDA                =  0x0086040B,

      GPIO_67_GPIO67                  =  0x00860600,
      GPIO_67_EPWM7_B                 =  0x00860601,
      GPIO_67_EPWM12_B                =  0x00860602,
      GPIO_67_MCANA_TX                =  0x00860603,
      GPIO_67_EQEP1_INDEX             =  0x00860605,
      GPIO_67_SCIB_RX                 =  0x00860606,
      GPIO_67_PMBUSA_ALERT            =  0x00860607,
      GPIO_67_FSIRXA_CLK              =  0x00860609,
      GPIO_67_LINA_RX                 =  0x0086060A,
      GPIO_67_SPIA_POCI               =  0x0086060B,
      GPIO_67_SCIC_RX                 =  0x0086060F,

      GPIO_68_GPIO68                  =  0x00860800,
      GPIO_68_EPWM7_A                 =  0x00860801,
      GPIO_68_EPWM3_A                 =  0x00860802,
      GPIO_68_MCANA_RX                =  0x00860803,
      GPIO_68_EQEP1_STROBE            =  0x00860805,
      GPIO_68_SCIB_TX                 =  0x00860806,
      GPIO_68_PMBUSA_CTL              =  0x00860807,
      GPIO_68_FSIRXA_D0               =  0x00860809,
      GPIO_68_LINA_TX                 =  0x0086080A,
      GPIO_68_SPIA_CLK                =  0x0086080B,
      GPIO_68_SCIC_TX                 =  0x0086080F,

      GPIO_69_GPIO69                  =  0x00860A00,
      GPIO_69_EPWM6_B                 =  0x00860A01,
      GPIO_69_EPWM3_B                 =  0x00860A02,
      GPIO_69_OUTPUTXBAR7             =  0x00860A03,
      GPIO_69_EQEP1_B                 =  0x00860A05,
      GPIO_69_SCIB_RX                 =  0x00860A06,
      GPIO_69_SPIA_PTE                =  0x00860A07,
      GPIO_69_FSIRXA_D1               =  0x00860A09,
      GPIO_69_LINA_RX                 =  0x00860A0A,
      GPIO_69_EQEP2_A                 =  0x00860A0B,
      GPIO_69_SPIA_PICO               =  0x00860A0D,
      GPIO_69_EQEP3_INDEX             =  0x00860A0F,

      GPIO_70_GPIO70                  =  0x00860C00,
      GPIO_70_I2CA_SCL                =  0x00860C01,
      GPIO_70_SPIB_PTE                =  0x00860C03,
      GPIO_70_OUTPUTXBAR4             =  0x00860C05,
      GPIO_70_LINA_RX                 =  0x00860C06,
      GPIO_70_FSIRXA_CLK              =  0x00860C09,
      GPIO_70_MCANA_RX                =  0x00860C0A,
      GPIO_70_EQEP2_B                 =  0x00860C0B,
      GPIO_70_ADCSOCAO                =  0x00860C0D,
      GPIO_70_EQEP3_A                 =  0x00860C0F,

      GPIO_71_GPIO71                  =  0x00860E00,
      GPIO_71_SPIA_PICO               =  0x00860E01,
      GPIO_71_EPWM4_B                 =  0x00860E02,
      GPIO_71_OUTPUTXBAR7             =  0x00860E03,
      GPIO_71_EPWM9_A                 =  0x00860E05,
      GPIO_71_SCIA_TX                 =  0x00860E06,
      GPIO_71_EQEP1_STROBE            =  0x00860E09,
      GPIO_71_PMBUSA_SCL              =  0x00860E0A,
      GPIO_71_XCLKOUT                 =  0x00860E0B,
      GPIO_71_EQEP2_INDEX             =  0x00860E0D,
      GPIO_71_SPIB_POCI               =  0x00860E0E,
      GPIO_71_EQEP3_STROBE            =  0x00860E0F,

      GPIO_72_GPIO72                  =  0x00861000,
      GPIO_72_SPIA_POCI               =  0x00861001,
      GPIO_72_EPWM5_A                 =  0x00861002,
      GPIO_72_OUTPUTXBAR8             =  0x00861003,
      GPIO_72_EPWM9_B                 =  0x00861005,
      GPIO_72_SCIA_RX                 =  0x00861006,
      GPIO_72_EQEP1_INDEX             =  0x00861009,
      GPIO_72_PMBUSA_SDA              =  0x0086100A,
      GPIO_72_MCANA_TX                =  0x0086100B,
      GPIO_72_EPWM6_A                 =  0x0086100E,
      GPIO_72_EQEP3_B                 =  0x0086100F,

      GPIO_73_GPIO73                  =  0x00861200,
      GPIO_73_OUTPUTXBAR1             =  0x00861201,
      GPIO_73_EPWM5_B                 =  0x00861202,
      GPIO_73_SPIA_PTE                =  0x00861203,
      GPIO_73_EPWM8_A                 =  0x00861205,
      GPIO_73_SPIB_PICO               =  0x00861206,
      GPIO_73_LINA_TX                 =  0x00861209,
      GPIO_73_PMBUSA_SCL              =  0x0086120A,
      GPIO_73_SCIA_TX                 =  0x0086120B,
      GPIO_73_ERRORSTS                =  0x0086120D,
      GPIO_73_EPWM9_A                 =  0x0086120E,

      GPIO_74_GPIO74                  =  0x00861400,
      GPIO_74_EPWM2_B                 =  0x00861401,
      GPIO_74_ADCSOCAO                =  0x00861403,
      GPIO_74_MCANA_TX                =  0x00861405,
      GPIO_74_SPIA_POCI               =  0x00861406,
      GPIO_74_EQEP1_B                 =  0x0086140B,

      GPIO_75_GPIO75                  =  0x00861600,
      GPIO_75_EPWM1_B                 =  0x00861601,
      GPIO_75_LINA_RX                 =  0x00861603,
      GPIO_75_EPWM6_A                 =  0x00861605,
      GPIO_75_SPIA_CLK                =  0x00861606,
      GPIO_75_EQEP1_STROBE            =  0x0086160B,
      GPIO_75_SCIC_RX                 =  0x0086160E,

      GPIO_76_GPIO76                  =  0x00861800,
      GPIO_76_EPWM4_A                 =  0x00861801,
      GPIO_76_OUTPUTXBAR2             =  0x00861805,
      GPIO_76_SPIA_PTE                =  0x00861806,
      GPIO_76_MCANA_RX                =  0x0086180A,
      GPIO_76_EQEP1_INDEX             =  0x0086180B,

      GPIO_77_GPIO77                  =  0x00861A00,
      GPIO_77_EPWM1_A                 =  0x00861A01,
      GPIO_77_OUTPUTXBAR3             =  0x00861A05,
      GPIO_77_SPIA_PICO               =  0x00861A06,
      GPIO_77_MCANA_TX                =  0x00861A0A,
      GPIO_77_EQEP1_A                 =  0x00861A0B,
      GPIO_77_SCIC_TX                 =  0x00861A0E,

      GPIO_78_GPIO78                  =  0x00861C00,
      GPIO_78_EPWM8_A                 =  0x00861C02,
      GPIO_78_EPWM3_A                 =  0x00861C03,
      GPIO_78_OUTPUTXBAR1             =  0x00861C05,
      GPIO_78_EPWM2_B                 =  0x00861C06,
      GPIO_78_FSITXA_CLK              =  0x00861C09,

      GPIO_79_GPIO79                  =  0x00861E00,
      GPIO_79_EPWM8_B                 =  0x00861E02,
      GPIO_79_EPWM3_B                 =  0x00861E03,
      GPIO_79_MCANA_RX                =  0x00861E05,
      GPIO_79_EPWM2_A                 =  0x00861E06,
      GPIO_79_I2CA_SDA                =  0x00861E07,
      GPIO_79_PMBUSA_SCL              =  0x00861E09,

      GPIO_80_GPIO80                  =  0x00880000,
      GPIO_80_EPWM1_A                 =  0x00880001,
      GPIO_80_OUTPUTXBAR7             =  0x00880003,
      GPIO_80_SCIA_RX                 =  0x00880005,
      GPIO_80_I2CB_SDA                =  0x00880006,
      GPIO_80_SPIA_PTE                =  0x00880007,
      GPIO_80_FSITXA_D0               =  0x00880009,
      GPIO_80_MCANA_RX                =  0x0088000A,
      GPIO_80_CLB_OUTPUTXBAR8         =  0x0088000B,
      GPIO_80_EQEP1_INDEX             =  0x0088000D,
      GPIO_80_EPWM3_A                 =  0x0088000F,

      GPIO_81_GPIO81                  =  0x00880200,
      GPIO_81_EPWM1_B                 =  0x00880201,
      GPIO_81_OUTPUTXBAR6             =  0x00880202,
      GPIO_81_SCIC_RX                 =  0x00880203,
      GPIO_81_SPIB_CLK                =  0x00880205,
      GPIO_81_I2CB_SCL                =  0x00880206,
      GPIO_81_FSITXA_D1               =  0x00880209,
      GPIO_81_MCANA_TX                =  0x0088020A,
      GPIO_81_EQEP3_INDEX             =  0x0088020B,

      GPIO_208_GPIO208                =  0x01880000,

      GPIO_209_GPIO209                =  0x01880200,

      GPIO_210_GPIO210                =  0x01880400,

      GPIO_211_GPIO211                =  0x01880600,
      GPIO_211_EPWM10_A               =  0x01880601,
      GPIO_211_EQEP3_A                =  0x01880605,

      GPIO_212_GPIO212                =  0x01880800,
      GPIO_212_EPWM10_B               =  0x01880801,
      GPIO_212_EQEP3_B                =  0x01880805,

      GPIO_213_GPIO213                =  0x01880A00,
      GPIO_213_EPWM11_A               =  0x01880A01,
      GPIO_213_EQEP3_STROBE           =  0x01880A05,

      GPIO_214_GPIO214                =  0x01880C00,
      GPIO_214_EPWM11_B               =  0x01880C01,
      GPIO_214_EQEP3_INDEX            =  0x01880C05,

      GPIO_215_GPIO215                =  0x01880E00,
      GPIO_215_EPWM7_B                =  0x01880E01,
      GPIO_215_EQEP2_A                =  0x01880E05,

      GPIO_224_GPIO224                =  0x01C60000,
      GPIO_224_EPWM11_B               =  0x01C60001,
      GPIO_224_OUTPUTXBAR3            =  0x01C60005,
      GPIO_224_SPIA_PICO              =  0x01C60006,
      GPIO_224_EPWM1_A                =  0x01C60009,
      GPIO_224_MCANA_TX               =  0x01C6000A,
      GPIO_224_EQEP1_A                =  0x01C6000B,
      GPIO_224_ADCE_EXTMUXSEL3        =  0x01C6000D,
      GPIO_224_SCIC_TX                =  0x01C6000E,

      GPIO_225_GPIO225                =  0x01C60200,

      GPIO_226_GPIO226                =  0x01C60400,
      GPIO_226_EPWM10_B               =  0x01C60401,
      GPIO_226_LINA_RX                =  0x01C60403,
      GPIO_226_EPWM6_A                =  0x01C60405,
      GPIO_226_SPIA_CLK               =  0x01C60406,
      GPIO_226_EPWM1_B                =  0x01C60409,
      GPIO_226_EQEP1_STROBE           =  0x01C6040B,
      GPIO_226_ADCE_EXTMUXSEL1        =  0x01C6040D,
      GPIO_226_SCIC_RX                =  0x01C6040E,

      GPIO_227_GPIO227                =  0x01C60600,
      GPIO_227_I2CB_SCL               =  0x01C60601,
      GPIO_227_EPWM3_A                =  0x01C60603,
      GPIO_227_OUTPUTXBAR1            =  0x01C60605,
      GPIO_227_EPWM2_B                =  0x01C60606,

      GPIO_228_GPIO228                =  0x01C60800,
      GPIO_228_EPWM10_A               =  0x01C60801,
      GPIO_228_ADCSOCAO               =  0x01C60803,
      GPIO_228_MCANA_TX               =  0x01C60805,
      GPIO_228_SPIA_POCI              =  0x01C60806,
      GPIO_228_EPWM2_B                =  0x01C60809,
      GPIO_228_EQEP1_B                =  0x01C6080B,
      GPIO_228_ADCE_EXTMUXSEL0        =  0x01C6080D,

      GPIO_229_GPIO229                =  0x01C60A00,

      GPIO_230_GPIO230                =  0x01C60C00,
      GPIO_230_I2CB_SDA               =  0x01C60C01,
      GPIO_230_EPWM3_B                =  0x01C60C03,
      GPIO_230_MCANA_RX               =  0x01C60C05,
      GPIO_230_EPWM2_A                =  0x01C60C06,
      GPIO_230_I2CA_SDA               =  0x01C60C07,
      GPIO_230_PMBUSA_SCL             =  0x01C60C09,

      GPIO_231_GPIO231                =  0x01C60E00,

      GPIO_232_GPIO232                =  0x01C61000,

      GPIO_233_GPIO233                =  0x01C61200,

      GPIO_234_GPIO234                =  0x01C61400,

      GPIO_235_GPIO235                =  0x01C61600,

      GPIO_236_GPIO236                =  0x01C61800,
      GPIO_236_EPWM7_A                =  0x01C61801,
      GPIO_236_EQEP1_INDEX            =  0x01C61805,
      GPIO_236_EPWM12_A               =  0x01C61809,

      GPIO_237_GPIO237                =  0x01C61A00,

      GPIO_238_GPIO238                =  0x01C61C00,

      GPIO_239_GPIO239                =  0x01C61E00,

      GPIO_240_GPIO240                =  0x01C80000,

      GPIO_241_GPIO241                =  0x01C80200,

      GPIO_242_GPIO242                =  0x01C80400,
      GPIO_242_EPWM11_A               =  0x01C80401,
      GPIO_242_OUTPUTXBAR2            =  0x01C80405,
      GPIO_242_SPIA_PTE               =  0x01C80406,
      GPIO_242_EPWM4_A                =  0x01C80409,
      GPIO_242_MCANA_RX               =  0x01C8040A,
      GPIO_242_EQEP1_INDEX            =  0x01C8040B,
      GPIO_242_ADCE_EXTMUXSEL2        =  0x01C8040D,

      GPIO_244_GPIO244                =  0x01C80800,

      GPIO_245_GPIO245                =  0x01C80A00,

      GPIO_247_GPIO247                =  0x01C80E00,
      GPIO_247_EPWM12_B               =  0x01C80E01,

      GPIO_248_GPIO248                =  0x01C81000,

      GPIO_249_GPIO249                =  0x01C81200,

      GPIO_251_GPIO251                =  0x01C81600,

      GPIO_252_GPIO252                =  0x01C81800,

      GPIO_253_GPIO253                =  0x01C81A00,
      GPIO_253_EPWM12_A               =  0x01C81A01,
    }
    return pin_map[pin]
end

return P
