#   Copyright (c) 2025 by Plexim GmbH
#   All rights reserved.
#
#   A free license is granted to anyone to use this software for any legal
#   non safety-critical purpose, including commercial applications, provided
#   that:
#   1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
#   2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.
#
#   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
#   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
#   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
#   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
#   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
#   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
#   SOFTWARE.

include |>BASE_NAME<||>CPU_POSTFIX<|_sources.mk

TSP_VERSION=|>TSP_VERSION<|
TARGET_ROOT=|>SRC_ROOT<|
TOOLS_PATH=|>C29_CG_PATH<|
BIN_DIR=|>BIN_DIR<|
OUT_NAME=|>BASE_NAME<|
MAKEFILE=|>BASE_NAME<||>CPU_POSTFIX<|.mk
LINKFILE=|>BASE_NAME<||>CPU_POSTFIX<|.lkf
INSTALL_DIR=|>INSTALL_DIR<|
BASE_NAME=|>BASE_NAME<|
CPU_POSTFIX=|>CPU_POSTFIX<|
CCXML_FILE=|>CCXML_FILE<|
FLASH_EXE_PATH=|>FLASH_EXE_PATH<|
CORE_POST_FIX=|>CORE_POST_FIX>|
CPU_NUM=|>CPU_NUM<|
CORE_FLASH_OPT=|>CORE_FLASH_OPT<|
CPU2_DIR=|>CPU2_BIN_DIR<|
NUM_CPUS=|>NUM_CPUS<|
COCKPIT_PATH=|>COCKPIT_PATH<|
# must come last followed by empty line
CLAGS_DISABLED=|>CFLAGS<|

|>SHARED_MAKE_FUNCTIONS<|
##############################################################

C_SOURCE_FILES=\
$(BASE_NAME)_hal.c \
$(BASE_NAME)_main.c\
ain_type5.c\
bitfield_structs.c\
csv.c\
dac_type2.c\
device.c\
dio_29h85x.c\
dispatcher_29h85x.c\
ecap_type3.c\
epwm_type4.c\
mcan_type0.c\
power.c\
sdfm.c\
spi_type2.c \
stack_monitor.c\
qep.c\
uart.c\

GENERATED_HEADERS=

ASM_SOURCE_FILES=\
codestartbranch.asm

CGT_EXE_PATH=$(TOOLS_PATH)/bin
CGT_LIB_PATH=$(TOOLS_PATH)/lib
CGT_INC_PATH=$(TOOLS_PATH)/include

BIN_DIR_OS=$(call FixPath,$(BIN_DIR))

# compiler / assembler (note: -DCPU1 creates issues!)
C_OPTIONS=\
-D_PLEXIM_\
-DBASE_NAME=$(BASE_NAME)\
-DEXTERNAL_MODE=1\
-D_FLASH\
-DDEBUG\
-ffast-math\
-g\
-Qunused-arguments\
-MMD\
-MP\
-c\
-O1\
-I"$(TARGET_ROOT)/inc_impl"\
-I"$(TARGET_ROOT)/app_cpu1"\
-I"$(TARGET_ROOT)/../pil29"\
-I"$(TARGET_ROOT)/../inc"\
-I"$(TARGET_ROOT)/../shrd"\
-I"$(TARGET_ROOT)/ti"\
-I"$(TARGET_ROOT)/ti/driverlib"\
-I"$(TARGET_ROOT)/ti/bitfields"\
-I"$(TOOLS_PATH)/include"\
$(CFLAGS)

L_OPTIONS=

C_OBJFILES=$(patsubst %.c, $(BIN_DIR)/%.o, $(C_SOURCE_FILES)) \
  $(patsubst %.c, $(BIN_DIR)/%.o, $(SOURCE_FILES))

ASM_OBJFILES=$(patsubst %.asm, $(BIN_DIR)/%.o, $(ASM_SOURCE_FILES))

OBJFILES=$(C_OBJFILES) $(ASM_OBJFILES)

DEPENDFILES=$(patsubst %.c, $(BIN_DIR)/%.d, $(C_SOURCE_FILES))

L_DEPENDENCIES=\
	$(LINKFILE) \
	$(call EscapeSpaces,$(TARGET_ROOT))/../pil29/pil_c29.lib \
	$(call EscapeSpaces,$(TARGET_ROOT))/ti/driverlib/driverlib.lib

# make all variables available to sub-makes
export

# Top level 
##########################################################################
all: $(MAKEFILE).uptodate
ifneq ($(wildcard $(BIN_DIR_OS)),  $(BIN_DIR_OS))
	"$(MAKE)" -f $(MAKEFILE) clean
endif
	"$(MAKE)" -f $(MAKEFILE) $(BIN_DIR)/$(OUT_NAME).elf
	
# Download
##########################################################################rm C
$(BIN_DIR)/$(BASE_NAME).ccxml:	$(call EscapeSpaces,$(CCXML_FILE)) $(MAKEFILE)
							$(call CopyFile,$(CCXML_FILE),$(BIN_DIR)/$(BASE_NAME).ccxml)

ifneq ($(and $(FLASH_EXE_PATH),$(CCXML_FILE)),)
download: $(BIN_DIR)/$(OUT_NAME).out $(BIN_DIR)/$(BASE_NAME).ccxml
	"$(FLASH_EXE_PATH)" flash --flash --config=$(call FixPath,$(BIN_DIR)/$(BASE_NAME).ccxml) $(call FixPath,$(BIN_DIR)/$(OUT_NAME).out) -u
else
download:
	@echo "Download not configured."
endif
 
# Linker
##########################################################################
$(BIN_DIR)/$(OUT_NAME).elf:  $(BIN_DIR)/$(OUT_NAME).out
						$(call CopyFile,$(BIN_DIR)/$(OUT_NAME).out,$(INSTALL_DIR)/$(OUT_NAME).elf)


$(BIN_DIR)/$(OUT_NAME).out:  $(BIN_DIR)/$(OUT_NAME)_unsigned.out
						"$(CGT_EXE_PATH)/c29objcopy" --remove-section=cert -O binary $(BIN_DIR)/$(OUT_NAME)_unsigned.out $(BIN_DIR)/$(OUT_NAME)_unsigned.bin
						"$(COCKPIT_PATH)/plx-binutil" gen-ti-cert $(BIN_DIR)/$(OUT_NAME)_unsigned.bin  $(BIN_DIR)/C29-cert-pad.bin --load-addr 0x10001000
						"$(CGT_EXE_PATH)/c29objcopy" --update-section cert=$(BIN_DIR)/C29-cert-pad.bin $(BIN_DIR)/$(OUT_NAME)_unsigned.out $(BIN_DIR)/$(OUT_NAME).out

$(BIN_DIR)/$(OUT_NAME)_unsigned.out:  $(OBJFILES) $(L_DEPENDENCIES)
						"$(CGT_EXE_PATH)/c29clang" $(L_OPTIONS) @"$(LINKFILE)" $(OBJFILES)

# Generated dependencies
##########################################################################
#-include ($(DEPENDFILES)) -- disabled due to CGT bug: https://sir.ext.ti.com/jira/browse/EXT_EP-9771

# Force clean when makefile changes
##########################################################################
$(MAKEFILE).uptodate: $(MAKEFILE)
	"$(MAKE)" -f $(MAKEFILE) clean
	$(call TouchFile,$(MAKEFILE).uptodate)

# Explicit rules (we must use explicit rules to allow spaces in $(TARGET_ROOT))
##########################################################################
$(BIN_DIR)/ain_type5.o:	$(call EscapeSpaces,$(TARGET_ROOT))/../shrd/ain_type5.c
						"$(CGT_EXE_PATH)/c29clang" $(C_OPTIONS) -MF"$(BIN_DIR)/$(@F:.o=.d_raw)" -MT"$(BIN_DIR)/$(@F)" -o"$(BIN_DIR)/$(@F)" "$<"

$(BIN_DIR)/bitfield_structs.o:	$(call EscapeSpaces,$(TARGET_ROOT))/ti/bitfields/bitfield_structs.c
						"$(CGT_EXE_PATH)/c29clang" $(C_OPTIONS) -MF"$(BIN_DIR)/$(@F:.o=.d_raw)" -MT"$(BIN_DIR)/$(@F)" -o"$(BIN_DIR)/$(@F)" "$<"

$(BIN_DIR)/codestartbranch.o:	$(call EscapeSpaces,$(TARGET_ROOT))/ti/codestartbranch.asm
						"$(CGT_EXE_PATH)/c29clang" $(C_OPTIONS) -MF"$(BIN_DIR)/$(@F:.o=.d_raw)" -MT"$(BIN_DIR)/$(@F)" -o"$(BIN_DIR)/$(@F)" "$<"

$(BIN_DIR)/csv.o:	$(call EscapeSpaces,$(TARGET_ROOT))/../shrd/csv.c
						"$(CGT_EXE_PATH)/c29clang" $(C_OPTIONS) -MF"$(BIN_DIR)/$(@F:.o=.d_raw)" -MT"$(BIN_DIR)/$(@F)" -o"$(BIN_DIR)/$(@F)" "$<"

$(BIN_DIR)/dac_type2.o:	$(call EscapeSpaces,$(TARGET_ROOT))/../shrd/dac_type2.c
						"$(CGT_EXE_PATH)/c29clang" $(C_OPTIONS) -MF"$(BIN_DIR)/$(@F:.o=.d_raw)" -MT"$(BIN_DIR)/$(@F)" -o"$(BIN_DIR)/$(@F)" "$<"

$(BIN_DIR)/device.o:	$(call EscapeSpaces,$(TARGET_ROOT))/ti/device.c
						"$(CGT_EXE_PATH)/c29clang" $(C_OPTIONS) -MF"$(BIN_DIR)/$(@F:.o=.d_raw)" -MT"$(BIN_DIR)/$(@F)" -o"$(BIN_DIR)/$(@F)" "$<"

$(BIN_DIR)/dio_29h85x.o:	$(call EscapeSpaces,$(TARGET_ROOT))/src/dio_29h85x.c
						"$(CGT_EXE_PATH)/c29clang" $(C_OPTIONS) -MF"$(BIN_DIR)/$(@F:.o=.d_raw)" -MT"$(BIN_DIR)/$(@F)" -o"$(BIN_DIR)/$(@F)" "$<"

$(BIN_DIR)/dispatcher_29h85x.o:	$(call EscapeSpaces,$(TARGET_ROOT))/src/dispatcher_29h85x.c
						"$(CGT_EXE_PATH)/c29clang" $(C_OPTIONS) -MF"$(BIN_DIR)/$(@F:.o=.d_raw)" -MT"$(BIN_DIR)/$(@F)" -o"$(BIN_DIR)/$(@F)" "$<"

$(BIN_DIR)/ecap_type3.o:	$(call EscapeSpaces,$(TARGET_ROOT))/../shrd/ecap_type3.c
						"$(CGT_EXE_PATH)/c29clang" $(C_OPTIONS) -MF"$(BIN_DIR)/$(@F:.o=.d_raw)" -MT"$(BIN_DIR)/$(@F)" -o"$(BIN_DIR)/$(@F)" "$<"

$(BIN_DIR)/epwm_type4.o:	$(call EscapeSpaces,$(TARGET_ROOT))/../shrd/epwm_type4.c
						"$(CGT_EXE_PATH)/c29clang" $(C_OPTIONS) -MF"$(BIN_DIR)/$(@F:.o=.d_raw)" -MT"$(BIN_DIR)/$(@F)" -o"$(BIN_DIR)/$(@F)" "$<"

$(BIN_DIR)/mcan_type0.o:	$(call EscapeSpaces,$(TARGET_ROOT))/../shrd/mcan_type0.c
						"$(CGT_EXE_PATH)/c29clang" $(C_OPTIONS) -MF"$(BIN_DIR)/$(@F:.o=.d_raw)" -MT"$(BIN_DIR)/$(@F)" -o"$(BIN_DIR)/$(@F)" "$<"

$(BIN_DIR)/power.o:	$(call EscapeSpaces,$(TARGET_ROOT))/../shrd/power.c
						"$(CGT_EXE_PATH)/c29clang" $(C_OPTIONS) -MF"$(BIN_DIR)/$(@F:.o=.d_raw)" -MT"$(BIN_DIR)/$(@F)" -o"$(BIN_DIR)/$(@F)" "$<"

$(BIN_DIR)/qep.o:	$(call EscapeSpaces,$(TARGET_ROOT))/../shrd/qep.c
						"$(CGT_EXE_PATH)/c29clang" $(C_OPTIONS) -MF"$(BIN_DIR)/$(@F:.o=.d_raw)" -MT"$(BIN_DIR)/$(@F)" -o"$(BIN_DIR)/$(@F)" "$<"

$(BIN_DIR)/sdfm.o:	$(call EscapeSpaces,$(TARGET_ROOT))/../shrd/sdfm.c
						"$(CGT_EXE_PATH)/c29clang" $(C_OPTIONS) -MF"$(BIN_DIR)/$(@F:.o=.d_raw)" -MT"$(BIN_DIR)/$(@F)" -o"$(BIN_DIR)/$(@F)" "$<"

$(BIN_DIR)/spi_type2.o:	$(call EscapeSpaces,$(TARGET_ROOT))/../shrd/spi_type2.c
						"$(CGT_EXE_PATH)/c29clang" $(C_OPTIONS) -MF"$(BIN_DIR)/$(@F:.o=.d_raw)" -MT"$(BIN_DIR)/$(@F)" -o"$(BIN_DIR)/$(@F)" "$<"

$(BIN_DIR)/stack_monitor.o:	$(call EscapeSpaces,$(TARGET_ROOT))/../shrd/stack_monitor.c
						"$(CGT_EXE_PATH)/c29clang" $(C_OPTIONS) -MF"$(BIN_DIR)/$(@F:.o=.d_raw)" -MT"$(BIN_DIR)/$(@F)" -o"$(BIN_DIR)/$(@F)" "$<"

$(BIN_DIR)/uart.o:	$(call EscapeSpaces,$(TARGET_ROOT))/../shrd/uart.c
						"$(CGT_EXE_PATH)/c29clang" $(C_OPTIONS) -MF"$(BIN_DIR)/$(@F:.o=.d_raw)" -MT"$(BIN_DIR)/$(@F)" -o"$(BIN_DIR)/$(@F)" "$<"

# Implicit Rules for generated files
##########################################################################
$(BIN_DIR)/%.o:		%.c	$(GENERATED_HEADERS) $(MAKEFILE)
						"$(CGT_EXE_PATH)/c29clang" $(C_OPTIONS) -MF"$(BIN_DIR)/$*.d_raw" -MT"$(BIN_DIR)/$*.o" -o"$(BIN_DIR)/$(@F)" "$<"

$(BIN_DIR)/%.o:		%.cla	$(MAKEFILE)
						"$(CGT_EXE_PATH)/c29clang" $(C_OPTIONS) -MF"$(BIN_DIR)/$*.d_raw" -MT"$(BIN_DIR)/$*.o" -o"$(BIN_DIR)/$(@F)" "$<"

##########################################################################

clean:
ifeq ($(wildcard $(BIN_DIR_OS)),  $(BIN_DIR_OS))
	$(call ClearDir,$(BIN_DIR_OS))
else
	mkdir $(BIN_DIR_OS)
endif
