/*
   Copyright (c) 2014-2022 by Plexim GmbH
   All rights reserved.

   A free license is granted to anyone to use this software for any legal
   non safety-critical purpose, including commercial applications, provided
   that:
   1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
   2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
   SOFTWARE.
 */

#ifndef PLX_PWM_IMPL_H_
#define PLX_PWM_IMPL_H_

// LOADAMODE and LOADBMODE bits
#define CC_CTR_ZERO      0x0
#define CC_CTR_PRD       0x1
#define CC_CTR_ZERO_PRD  0x2
#define CC_LD_DISABLE    0x3

// CTRMODE bits
#define TB_COUNT_UP      0x0
#define TB_COUNT_DOWN    0x1
#define TB_COUNT_UPDOWN  0x2
#define TB_FREEZE        0x3

// PHSEN bit
#define TB_DISABLE  0x0
#define TB_ENABLE   0x1

// PRDLD bit
#define TB_SHADOW     0x0
#define TB_IMMEDIATE  0x1

// PHSDIR bit
#define TB_DOWN   0x0
#define TB_UP     0x1

// SHDWAMODE and SHDWBMODE bits
#define CC_SHADOW     0x0
#define CC_IMMEDIATE  0x1

#define AQ_NO_ACTION  0x0
#define AQ_CLEAR      0x1
#define AQ_SET        0x2
#define AQ_TOGGLE     0x3

// HSPCLKDIV and CLKDIV bits
#define TB_DIV1   0x0
#define TB_DIV2   0x1
#define TB_DIV4   0x2

// OUT MODE bits
#define DB_DISABLE      0x0
#define DBB_ENABLE      0x1
#define DBA_ENABLE      0x2
#define DB_FULL_ENABLE  0x3

// IN MODE bits
#define DBA_ALL          0x0
#define DBB_RED_DBA_FED  0x1
#define DBA_RED_DBB_FED  0x2
#define DBB_ALL          0x3

// TZA and TZB bits
#define TZ_HIZ       0x0
#define TZ_FORCE_HI  0x1
#define TZ_FORCE_LO  0x2
#define TZ_NO_CHANGE 0x3

// POLSEL bits
#define DB_ACTV_HI   0x0
#define DB_ACTV_LOC  0x1
#define DB_ACTV_HIC  0x2
#define DB_ACTV_LO   0x3

// INTSEL bits
#define ET_DCAEVT1SOC   0x0
#define ET_CTR_ZERO     0x1
#define ET_CTR_PRD      0x2
#define ET_CTR_PRDZERO  0x3
#define ET_CTRU_CMPA    0x4
#define ET_CTRD_CMPA    0x5
#define ET_CTRU_CMPB    0x6
#define ET_CTRD_CMPB    0x7

#include "hwbf_epwm.h"

typedef enum PLX_PWM_UNIT {
  PLX_PWM_EPWM_NONE = 0,
  PLX_PWM_EPWM1,
  PLX_PWM_EPWM2,
  PLX_PWM_EPWM3,
  PLX_PWM_EPWM4,
  PLX_PWM_EPWM5,
  PLX_PWM_EPWM6,
  PLX_PWM_EPWM7,
  PLX_PWM_EPWM8,
  PLX_PWM_EPWM9,
  PLX_PWM_EPWM10,
  PLX_PWM_EPWM11,
  PLX_PWM_EPWM12,
  PLX_PWM_EPWM13,
  PLX_PWM_EPWM14,
  PLX_PWM_EPWM15,
  PLX_PWM_EPWM16,
  PLX_PWM_EPWM17,
  PLX_PWM_EPWM18,
  PLX_PWM_EPWM_MAX_PLUS_ONE
} PLX_PWM_Unit_t;

typedef struct PLX_PWM_REG_PARAMS {
  uint16_t TBPRD;
  union EPWM_TBPHS_REG TBPHS;
  union EPWM_TBCTL_REG TBCTL;
  union EPWM_CMPCTL_REG CMPCTL;
  union EPWM_AQCTLA_REG AQCTLA;
  union EPWM_DBCTL_REG DBCTL;
  union EPWM_DBFED_REG DBFED;
  union EPWM_DBRED_REG DBRED;
  union EPWM_TZCTL_REG TZCTL;
  union EPWM_ETSEL_REG ETSEL;
  union EPWM_TZSEL_REG TZSEL;
  union EPWM_ETSOCPS_REG ETSOCPS;
} PLX_PWM_RegParams_t;

#include "epwm_type4.h"

#endif /* PLX_PWM_IMPL_H_ */
