/*
   Copyright (c) 2019-2025 by Plexim GmbH
   All rights reserved.

   A free license is granted to anyone to use this software for any legal
   non safety-critical purpose, including commercial applications, provided
   that:
   1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
   2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
   SOFTWARE.
 */

// clang-format off: |>G_SUBS<|
#include "includes.h"

#include "plx_dispatcher.h"

#include "driverlib.h"

#ifndef _FLASH
|>FLASH_FLAG<|
#endif

void |>BASE_NAME<|_initialize();

|>TSP_VER_DEF<|
#ifdef TSP_VER
#if (TSP_VER != THIS_TSP_VER)
#error TSP Version mismatch.
#endif
#endif

int main(void){
    DISINT;
    Interrupt_disableGlobal();
    
    |>STACK_MON<|
    |>BASE_NAME<|_initialize();

    // TODO: need to understand this
    // some of that may need to move
	  Interrupt_setThreshold(0);
    Interrupt_setGroupMask(0xFF);
    Interrupt_setRTINTSPWarning(15, 0);

    // enable interrupts
    ENINT;
    Interrupt_enableGlobal();

    // go!
    DISPR_start(); // will not return

    PLX_ASSERT(0); // should never get here
}
// clang-format on
