#   Copyright (c) 2021 by Plexim GmbH
#   All rights reserved.
#
#   A free license is granted to anyone to use this software for any legal
#   non safety-critical purpose, including commercial applications, provided
#   that:
#   1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
#   2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.
#
#   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
#   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
#   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
#   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
#   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
#   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
#   SOFTWARE.

include |>BASE_NAME<||>CPU_POSTFIX<|_sources.mk

INSTALL_DIR=|>INSTALL_DIR<|
MAKEFILE=|>BASE_NAME<||>CPU_POSTFIX<|.mk
HFILE=|>BASE_NAME<||>CPU_POSTFIX<|.h
BASE_NAME=|>BASE_NAME<|
HAS_CLA=|>HAS_CLA<|
CPU_POSTFIX=|>CPU_POSTFIX<|

|>SHARED_MAKE_FUNCTIONS<|
##############################################################

SOURCE_FILES += $(BASE_NAME)$(CPU_POSTFIX)_hal.c
HFILES=$(BASE_NAME)$(CPU_POSTFIX).h

ifneq ($(CPU_POSTFIX),)
HFILES += $(BASE_NAME)_CPU_common.h
endif

CLA_FILES=
ifeq ($(HAS_CLA),TRUE)
CLA_FILES += $(BASE_NAME)$(CPU_POSTFIX)_cla.cla
endif

INSTALL_FILES=\
  $(patsubst %.h, "$(INSTALL_DIR)/%.h", $(HFILES)) \
  $(patsubst %.c, "$(INSTALL_DIR)/%.c", $(SOURCE_FILES))\
  $(patsubst %.cla, "$(INSTALL_DIR)/%.cla", $(CLA_FILES))

INSTALL_DIR_ESC=$(call EscapeSpaces,$(INSTALL_DIR))

# make all variables available to sub-makes
export

##########################################################################
all:
	"$(MAKE)" -f $(MAKEFILE) $(INSTALL_FILES)

##########################################################################

$(INSTALL_DIR_ESC)/%.c:		%.c
							$(call CopyFile,$*.c,$@)

$(INSTALL_DIR_ESC)/%.cla:	%.cla
							$(call CopyFile,$*.cla,$@)

$(INSTALL_DIR_ESC)/%.h:		%.h
							$(call CopyFile,$*.h,$@)

# no action for download
download:
	
