local P = {}

function P.getPinSettings(pin)
	local pin_map = {
      GPIO_0_GPIO0                    =  0x00060000,
      GPIO_0_EPWM1_A                  =  0x00060001,
      GPIO_0_CLB_OUTPUTXBAR1          =  0x00060005,
      GPIO_0_I2CA_SDA                 =  0x00060006,
      GPIO_0_EMIF1_A13                =  0x00060009,
      GPIO_0_ESC_GPI0                 =  0x0006000A,
      GPIO_0_FSITXA_D0                =  0x0006000D,

      GPIO_1_GPIO1                    =  0x00060200,
      GPIO_1_EPWM1_B                  =  0x00060201,
      GPIO_1_CLB_OUTPUTXBAR2          =  0x00060205,
      GPIO_1_I2CA_SCL                 =  0x00060206,
      GPIO_1_EMIF1_A14                =  0x00060209,
      GPIO_1_ESC_GPI1                 =  0x0006020A,
      GPIO_1_FSITXA_D1                =  0x0006020D,

      GPIO_2_GPIO2                    =  0x00060400,
      GPIO_2_EPWM2_A                  =  0x00060401,
      GPIO_2_OUTPUTXBAR1              =  0x00060405,
      GPIO_2_I2CB_SDA                 =  0x00060406,
      GPIO_2_UARTA_TX                 =  0x00060407,
      GPIO_2_EMIF1_A15                =  0x00060409,
      GPIO_2_ESC_GPI2                 =  0x0006040A,
      GPIO_2_FSITXA_CLK               =  0x0006040D,

      GPIO_3_GPIO3                    =  0x00060600,
      GPIO_3_EPWM2_B                  =  0x00060601,
      GPIO_3_OUTPUTXBAR2              =  0x00060602,
      GPIO_3_I2CB_SCL                 =  0x00060606,
      GPIO_3_UARTA_RX                 =  0x00060607,
      GPIO_3_ESC_GPI3                 =  0x0006060A,
      GPIO_3_FSIRXA_D0                =  0x0006060D,

      GPIO_4_GPIO4                    =  0x00060800,
      GPIO_4_EPWM3_A                  =  0x00060801,
      GPIO_4_OUTPUTXBAR3              =  0x00060805,
      GPIO_4_CANA_TX                  =  0x00060806,
      GPIO_4_MCANA_TX                 =  0x00060809,
      GPIO_4_ESC_GPI4                 =  0x0006080A,
      GPIO_4_FSIRXA_D1                =  0x0006080D,

      GPIO_5_GPIO5                    =  0x00060A00,
      GPIO_5_EPWM3_B                  =  0x00060A01,
      GPIO_5_OUTPUTXBAR3              =  0x00060A03,
      GPIO_5_CLB_OUTPUTXBAR3          =  0x00060A05,
      GPIO_5_CANA_RX                  =  0x00060A06,
      GPIO_5_MCANA_RX                 =  0x00060A09,
      GPIO_5_ESC_GPI5                 =  0x00060A0A,
      GPIO_5_FSIRXA_CLK               =  0x00060A0D,

      GPIO_6_GPIO6                    =  0x00060C00,
      GPIO_6_EPWM4_A                  =  0x00060C01,
      GPIO_6_OUTPUTXBAR4              =  0x00060C02,
      GPIO_6_EXTSYNCOUT               =  0x00060C03,
      GPIO_6_EQEP3_A                  =  0x00060C05,
      GPIO_6_MCANB_TX                 =  0x00060C06,
      GPIO_6_LINA_TX                  =  0x00060C07,
      GPIO_6_EMIF1_DQM0               =  0x00060C09,
      GPIO_6_ESC_GPI6                 =  0x00060C0A,
      GPIO_6_FSITXB_D0                =  0x00060C0D,

      GPIO_7_GPIO7                    =  0x00060E00,
      GPIO_7_EPWM4_B                  =  0x00060E01,
      GPIO_7_OUTPUTXBAR5              =  0x00060E03,
      GPIO_7_EQEP3_B                  =  0x00060E05,
      GPIO_7_MCANB_RX                 =  0x00060E06,
      GPIO_7_LINA_RX                  =  0x00060E07,
      GPIO_7_EMIF1_DQM1               =  0x00060E09,
      GPIO_7_ESC_GPI7                 =  0x00060E0A,
      GPIO_7_FSITXB_D1                =  0x00060E0D,

      GPIO_8_GPIO8                    =  0x00061000,
      GPIO_8_EPWM5_A                  =  0x00061001,
      GPIO_8_EMIF1_RAS                =  0x00061002,
      GPIO_8_ADCSOCAO                 =  0x00061003,
      GPIO_8_EQEP3_STROBE             =  0x00061005,
      GPIO_8_SCIA_TX                  =  0x00061006,
      GPIO_8_CLB_OUTPUTXBAR4          =  0x00061007,
      GPIO_8_MCANA_TX                 =  0x00061009,
      GPIO_8_ESC_GPO0                 =  0x0006100A,
      GPIO_8_FSITXB_CLK               =  0x0006100D,
      GPIO_8_FSITXA_D1                =  0x0006100E,
      GPIO_8_FSIRXA_D0                =  0x0006100F,

      GPIO_9_GPIO9                    =  0x00061200,
      GPIO_9_EPWM5_B                  =  0x00061201,
      GPIO_9_SCIB_TX                  =  0x00061202,
      GPIO_9_OUTPUTXBAR6              =  0x00061203,
      GPIO_9_EQEP3_INDEX              =  0x00061205,
      GPIO_9_SCIA_RX                  =  0x00061206,
      GPIO_9_ESC_GPO1                 =  0x0006120A,
      GPIO_9_FSIRXB_D0                =  0x0006120D,
      GPIO_9_FSITXA_D0                =  0x0006120E,
      GPIO_9_FSIRXA_CLK               =  0x0006120F,

      GPIO_10_GPIO10                  =  0x00061400,
      GPIO_10_EPWM6_A                 =  0x00061401,
      GPIO_10_EMIF1_CAS               =  0x00061402,
      GPIO_10_ADCSOCBO                =  0x00061403,
      GPIO_10_EQEP1_A                 =  0x00061405,
      GPIO_10_SCIB_TX                 =  0x00061406,
      GPIO_10_SD4_C1                  =  0x00061407,
      GPIO_10_MCANA_RX                =  0x00061409,
      GPIO_10_CLB_OUTPUTXBAR5         =  0x0006140A,
      GPIO_10_ESC_TX0_DATA0           =  0x0006140B,
      GPIO_10_FSIRXB_D1               =  0x0006140D,
      GPIO_10_FSITXA_CLK              =  0x0006140E,
      GPIO_10_FSIRXA_D1               =  0x0006140F,

      GPIO_11_GPIO11                  =  0x00061600,
      GPIO_11_EPWM6_B                 =  0x00061601,
      GPIO_11_SCIB_RX                 =  0x00061602,
      GPIO_11_OUTPUTXBAR7             =  0x00061603,
      GPIO_11_EQEP1_B                 =  0x00061605,
      GPIO_11_SD4_D1                  =  0x00061607,
      GPIO_11_ESC_GPO3                =  0x0006160A,
      GPIO_11_ESC_TX0_DATA1           =  0x0006160B,
      GPIO_11_FSIRXB_CLK              =  0x0006160D,
      GPIO_11_FSIRXA_D1               =  0x0006160E,
      GPIO_11_PMBUSA_ALERT            =  0x0006160F,

      GPIO_12_GPIO12                  =  0x00061800,
      GPIO_12_EPWM7_A                 =  0x00061801,
      GPIO_12_CLB_OUTPUTXBAR6         =  0x00061802,
      GPIO_12_ADCSOCAO                =  0x00061803,
      GPIO_12_EQEP1_STROBE            =  0x00061805,
      GPIO_12_SCIA_TX                 =  0x00061806,
      GPIO_12_SD4_C2                  =  0x00061807,
      GPIO_12_EMIF1_A1                =  0x00061809,
      GPIO_12_ESC_GPO4                =  0x0006180A,
      GPIO_12_ESC_TX0_DATA2           =  0x0006180B,
      GPIO_12_FSIRXC_D0               =  0x0006180D,
      GPIO_12_FSIRXA_D0               =  0x0006180E,
      GPIO_12_PMBUSA_CTL              =  0x0006180F,

      GPIO_13_GPIO13                  =  0x00061A00,
      GPIO_13_EPWM7_B                 =  0x00061A01,
      GPIO_13_CLB_OUTPUTXBAR7         =  0x00061A02,
      GPIO_13_EQEP5_STROBE            =  0x00061A03,
      GPIO_13_EQEP1_INDEX             =  0x00061A05,
      GPIO_13_SCIA_RX                 =  0x00061A06,
      GPIO_13_SD4_D2                  =  0x00061A07,
      GPIO_13_EMIF1_CS0N              =  0x00061A09,
      GPIO_13_ESC_GPO5                =  0x00061A0A,
      GPIO_13_ESC_TX0_DATA3           =  0x00061A0B,
      GPIO_13_FSIRXC_D1               =  0x00061A0D,
      GPIO_13_FSIRXA_CLK              =  0x00061A0E,
      GPIO_13_PMBUSA_SDA              =  0x00061A0F,

      GPIO_14_GPIO14                  =  0x00061C00,
      GPIO_14_EPWM8_A                 =  0x00061C01,
      GPIO_14_SCIB_TX                 =  0x00061C02,
      GPIO_14_EQEP5_INDEX             =  0x00061C03,
      GPIO_14_LINA_TX                 =  0x00061C05,
      GPIO_14_OUTPUTXBAR3             =  0x00061C06,
      GPIO_14_OUTPUTXBAR8             =  0x00061C07,
      GPIO_14_ESC_GPO6                =  0x00061C0A,
      GPIO_14_ESC_PHY1_LINKSTATUS     =  0x00061C0B,
      GPIO_14_FSIRXC_CLK              =  0x00061C0D,
      GPIO_14_EMIF1_D17               =  0x00061C0E,
      GPIO_14_PMBUSA_SCL              =  0x00061C0F,

      GPIO_15_GPIO15                  =  0x00061E00,
      GPIO_15_EPWM8_B                 =  0x00061E01,
      GPIO_15_SCIB_RX                 =  0x00061E02,
      GPIO_15_LINA_RX                 =  0x00061E05,
      GPIO_15_OUTPUTXBAR4             =  0x00061E06,
      GPIO_15_CLB_OUTPUTXBAR8         =  0x00061E07,
      GPIO_15_ESC_GPO7                =  0x00061E0A,
      GPIO_15_EQEP5_A                 =  0x00061E0B,
      GPIO_15_FSIRXD_D0               =  0x00061E0D,
      GPIO_15_EMIF1_DQM2              =  0x00061E0F,

      GPIO_16_GPIO16                  =  0x00080000,
      GPIO_16_SPIA_PICO               =  0x00080001,
      GPIO_16_OUTPUTXBAR7             =  0x00080003,
      GPIO_16_EPWM9_A                 =  0x00080005,
      GPIO_16_SD1_D1                  =  0x00080007,
      GPIO_16_EQEP5_B                 =  0x0008000B,
      GPIO_16_FSIRXD_D1               =  0x0008000D,
      GPIO_16_ESC_RX1_CLK             =  0x0008000F,

      GPIO_17_GPIO17                  =  0x00080200,
      GPIO_17_SPIA_POCI               =  0x00080201,
      GPIO_17_OUTPUTXBAR8             =  0x00080203,
      GPIO_17_EPWM9_B                 =  0x00080205,
      GPIO_17_SD1_C1                  =  0x00080207,
      GPIO_17_EQEP5_STROBE            =  0x0008020B,
      GPIO_17_FSIRXD_CLK              =  0x0008020D,
      GPIO_17_ESC_RX1_DV              =  0x0008020F,

      GPIO_18_GPIO18                  =  0x00080400,
      GPIO_18_SPIA_CLK                =  0x00080401,
      GPIO_18_SCIB_TX                 =  0x00080402,
      GPIO_18_CANA_RX                 =  0x00080403,
      GPIO_18_EPWM10_A                =  0x00080405,
      GPIO_18_SD1_D2                  =  0x00080407,
      GPIO_18_MCANA_RX                =  0x00080409,
      GPIO_18_EMIF1_CS2N              =  0x0008040A,
      GPIO_18_EQEP5_INDEX             =  0x0008040B,
      GPIO_18_ESC_RX1_ERR             =  0x0008040F,

      GPIO_19_GPIO19                  =  0x00080600,
      GPIO_19_SPIA_PTE                =  0x00080601,
      GPIO_19_SCIB_RX                 =  0x00080602,
      GPIO_19_CANA_TX                 =  0x00080603,
      GPIO_19_EPWM10_B                =  0x00080605,
      GPIO_19_SD1_C2                  =  0x00080607,
      GPIO_19_MCANA_TX                =  0x00080609,
      GPIO_19_EMIF1_CS3N              =  0x0008060A,
      GPIO_19_ESC_TX1_DATA3           =  0x0008060F,

      GPIO_20_GPIO20                  =  0x00080800,
      GPIO_20_EQEP1_A                 =  0x00080801,
      GPIO_20_EPWM11_A                =  0x00080805,
      GPIO_20_SD1_D3                  =  0x00080807,
      GPIO_20_MCANB_TX                =  0x00080809,
      GPIO_20_EMIF1_BA0               =  0x0008080A,
      GPIO_20_SPIC_PICO               =  0x0008080E,
      GPIO_20_ESC_TX1_DATA2           =  0x0008080F,

      GPIO_21_GPIO21                  =  0x00080A00,
      GPIO_21_EQEP1_B                 =  0x00080A01,
      GPIO_21_EPWM11_B                =  0x00080A05,
      GPIO_21_SD1_C3                  =  0x00080A07,
      GPIO_21_MCANB_RX                =  0x00080A09,
      GPIO_21_EMIF1_BA1               =  0x00080A0A,
      GPIO_21_SPIC_POCI               =  0x00080A0E,
      GPIO_21_ESC_TX1_DATA1           =  0x00080A0F,

      GPIO_22_GPIO22                  =  0x00080C00,
      GPIO_22_EQEP1_STROBE            =  0x00080C01,
      GPIO_22_SCIB_TX                 =  0x00080C03,
      GPIO_22_EPWM12_A                =  0x00080C05,
      GPIO_22_SPIB_CLK                =  0x00080C06,
      GPIO_22_SD1_D4                  =  0x00080C07,
      GPIO_22_MCANA_TX                =  0x00080C09,
      GPIO_22_EMIF1_RAS               =  0x00080C0A,
      GPIO_22_SPIC_CLK                =  0x00080C0E,
      GPIO_22_ESC_TX1_DATA0           =  0x00080C0F,

      GPIO_23_GPIO23                  =  0x00080E00,
      GPIO_23_EQEP1_INDEX             =  0x00080E01,
      GPIO_23_SCIB_RX                 =  0x00080E03,
      GPIO_23_EPWM12_B                =  0x00080E05,
      GPIO_23_SPIB_PTE                =  0x00080E06,
      GPIO_23_SD1_C4                  =  0x00080E07,
      GPIO_23_MCANA_RX                =  0x00080E09,
      GPIO_23_EMIF1_CAS               =  0x00080E0A,
      GPIO_23_SPIC_PTE                =  0x00080E0E,
      GPIO_23_ESC_PHY_RESETN          =  0x00080E0F,

      GPIO_24_GPIO24                  =  0x00081000,
      GPIO_24_OUTPUTXBAR1             =  0x00081001,
      GPIO_24_EQEP2_A                 =  0x00081002,
      GPIO_24_LINB_TX                 =  0x00081005,
      GPIO_24_SPIB_PICO               =  0x00081006,
      GPIO_24_SD2_D1                  =  0x00081007,
      GPIO_24_PMBUSA_SCL              =  0x00081009,
      GPIO_24_EMIF1_DQM0              =  0x0008100A,
      GPIO_24_EPWM13_A                =  0x0008100D,
      GPIO_24_ESC_RX0_DATA1           =  0x0008100E,
      GPIO_24_ESC_RX0_CLK             =  0x0008100F,

      GPIO_25_GPIO25                  =  0x00081200,
      GPIO_25_OUTPUTXBAR2             =  0x00081201,
      GPIO_25_EQEP2_B                 =  0x00081202,
      GPIO_25_LINB_RX                 =  0x00081205,
      GPIO_25_SPIB_POCI               =  0x00081206,
      GPIO_25_SD2_C1                  =  0x00081207,
      GPIO_25_PMBUSA_SDA              =  0x00081209,
      GPIO_25_EMIF1_DQM1              =  0x0008120A,
      GPIO_25_EQEP5_B                 =  0x0008120B,
      GPIO_25_EPWM13_B                =  0x0008120D,
      GPIO_25_FSITXA_D1               =  0x0008120E,
      GPIO_25_ESC_RX0_DV              =  0x0008120F,

      GPIO_26_GPIO26                  =  0x00081400,
      GPIO_26_OUTPUTXBAR3             =  0x00081401,
      GPIO_26_EQEP2_INDEX             =  0x00081402,
      GPIO_26_SPIB_CLK                =  0x00081406,
      GPIO_26_SD2_D2                  =  0x00081407,
      GPIO_26_PMBUSA_ALERT            =  0x00081409,
      GPIO_26_EMIF1_DQM2              =  0x0008140A,
      GPIO_26_ESC_MDIO_CLK            =  0x0008140B,
      GPIO_26_EPWM14_A                =  0x0008140D,
      GPIO_26_FSITXA_D0               =  0x0008140E,
      GPIO_26_ESC_RX0_ERR             =  0x0008140F,

      GPIO_27_GPIO27                  =  0x00081600,
      GPIO_27_OUTPUTXBAR4             =  0x00081601,
      GPIO_27_EQEP2_STROBE            =  0x00081602,
      GPIO_27_SPIB_PTE                =  0x00081606,
      GPIO_27_SD2_C2                  =  0x00081607,
      GPIO_27_PMBUSA_CTL              =  0x00081609,
      GPIO_27_EMIF1_DQM3              =  0x0008160A,
      GPIO_27_ESC_MDIO_DATA           =  0x0008160B,
      GPIO_27_EPWM14_B                =  0x0008160D,
      GPIO_27_FSITXA_CLK              =  0x0008160E,
      GPIO_27_ESC_RX0_DATA0           =  0x0008160F,

      GPIO_28_GPIO28                  =  0x00081800,
      GPIO_28_SCIA_RX                 =  0x00081801,
      GPIO_28_EMIF1_CS4N              =  0x00081802,
      GPIO_28_UARTA_RX                =  0x00081803,
      GPIO_28_OUTPUTXBAR5             =  0x00081805,
      GPIO_28_EQEP3_A                 =  0x00081806,
      GPIO_28_SD2_D3                  =  0x00081807,
      GPIO_28_EMIF1_CS2N              =  0x00081809,
      GPIO_28_EPWM15_A                =  0x0008180D,
      GPIO_28_ESC_RX0_DATA1           =  0x0008180F,

      GPIO_29_GPIO29                  =  0x00081A00,
      GPIO_29_SCIA_TX                 =  0x00081A01,
      GPIO_29_EMIF1_SDCKE             =  0x00081A02,
      GPIO_29_UARTA_TX                =  0x00081A03,
      GPIO_29_OUTPUTXBAR6             =  0x00081A05,
      GPIO_29_EQEP3_B                 =  0x00081A06,
      GPIO_29_SD2_C3                  =  0x00081A07,
      GPIO_29_EMIF1_CS3N              =  0x00081A09,
      GPIO_29_ESC_LATCH0              =  0x00081A0A,
      GPIO_29_ESC_I2C_SDA             =  0x00081A0B,
      GPIO_29_EPWM15_B                =  0x00081A0D,
      GPIO_29_ESC_SYNC0               =  0x00081A0E,
      GPIO_29_ESC_RX0_DATA2           =  0x00081A0F,

      GPIO_30_GPIO30                  =  0x00081C00,
      GPIO_30_CANA_RX                 =  0x00081C01,
      GPIO_30_EMIF1_CLK               =  0x00081C02,
      GPIO_30_MCANA_RX                =  0x00081C03,
      GPIO_30_OUTPUTXBAR7             =  0x00081C05,
      GPIO_30_EQEP3_STROBE            =  0x00081C06,
      GPIO_30_SD2_D4                  =  0x00081C07,
      GPIO_30_EMIF1_CS4N              =  0x00081C09,
      GPIO_30_ESC_LATCH1              =  0x00081C0A,
      GPIO_30_ESC_I2C_SCL             =  0x00081C0B,
      GPIO_30_EPWM16_A                =  0x00081C0D,
      GPIO_30_ESC_SYNC1               =  0x00081C0E,
      GPIO_30_SPID_PICO               =  0x00081C0F,

      GPIO_31_GPIO31                  =  0x00081E00,
      GPIO_31_CANA_TX                 =  0x00081E01,
      GPIO_31_EMIF1_WEN               =  0x00081E02,
      GPIO_31_MCANA_TX                =  0x00081E03,
      GPIO_31_OUTPUTXBAR8             =  0x00081E05,
      GPIO_31_EQEP3_INDEX             =  0x00081E06,
      GPIO_31_SD2_C4                  =  0x00081E07,
      GPIO_31_EMIF1_RNW               =  0x00081E09,
      GPIO_31_I2CA_SDA                =  0x00081E0A,
      GPIO_31_EPWM16_B                =  0x00081E0D,
      GPIO_31_SPID_POCI               =  0x00081E0F,

      GPIO_32_GPIO32                  =  0x00460000,
      GPIO_32_I2CA_SDA                =  0x00460001,
      GPIO_32_EMIF1_CS0N              =  0x00460002,
      GPIO_32_SPIA_PICO               =  0x00460003,
      GPIO_32_EQEP4_A                 =  0x00460005,
      GPIO_32_LINB_TX                 =  0x00460006,
      GPIO_32_CLB_OUTPUTXBAR1         =  0x00460007,
      GPIO_32_EMIF1_OEN               =  0x00460009,
      GPIO_32_I2CA_SCL                =  0x0046000A,
      GPIO_32_SPID_CLK                =  0x0046000F,

      GPIO_33_GPIO33                  =  0x00460200,
      GPIO_33_I2CA_SCL                =  0x00460201,
      GPIO_33_EMIF1_RNW               =  0x00460202,
      GPIO_33_SPIA_POCI               =  0x00460203,
      GPIO_33_EQEP4_B                 =  0x00460205,
      GPIO_33_CLB_OUTPUTXBAR2         =  0x00460207,
      GPIO_33_EMIF1_BA0               =  0x00460209,
      GPIO_33_ESC_LED_ERR             =  0x0046020B,
      GPIO_33_SPID_PTE                =  0x0046020F,

      GPIO_34_GPIO34                  =  0x00460400,
      GPIO_34_OUTPUTXBAR1             =  0x00460401,
      GPIO_34_EMIF1_CS2N              =  0x00460402,
      GPIO_34_SPIA_CLK                =  0x00460403,
      GPIO_34_EQEP4_STROBE            =  0x00460405,
      GPIO_34_I2CB_SDA                =  0x00460406,
      GPIO_34_CLB_OUTPUTXBAR3         =  0x00460407,
      GPIO_34_EMIF1_BA1               =  0x00460409,
      GPIO_34_ESC_LATCH0              =  0x0046040A,
      GPIO_34_EPWM18_A                =  0x0046040B,
      GPIO_34_SCIA_TX                 =  0x0046040D,
      GPIO_34_ESC_SYNC0               =  0x0046040E,

      GPIO_35_GPIO35                  =  0x00460600,
      GPIO_35_SCIA_RX                 =  0x00460601,
      GPIO_35_EMIF1_CS3N              =  0x00460602,
      GPIO_35_SPIA_PTE                =  0x00460603,
      GPIO_35_EQEP4_INDEX             =  0x00460605,
      GPIO_35_I2CB_SCL                =  0x00460606,
      GPIO_35_CLB_OUTPUTXBAR4         =  0x00460607,
      GPIO_35_EMIF1_A0                =  0x00460609,
      GPIO_35_ESC_LATCH1              =  0x0046060A,
      GPIO_35_EPWM18_B                =  0x0046060B,
      GPIO_35_ESC_SYNC1               =  0x0046060E,

      GPIO_36_GPIO36                  =  0x00460800,
      GPIO_36_SCIA_TX                 =  0x00460801,
      GPIO_36_EMIF1_WAIT              =  0x00460802,
      GPIO_36_CANA_RX                 =  0x00460806,
      GPIO_36_CLB_OUTPUTXBAR5         =  0x00460807,
      GPIO_36_EMIF1_A1                =  0x00460809,
      GPIO_36_MCANA_RX                =  0x0046080A,
      GPIO_36_SD1_D1                  =  0x0046080D,
      GPIO_36_EMIF1_WEN               =  0x0046080E,

      GPIO_37_GPIO37                  =  0x00460A00,
      GPIO_37_OUTPUTXBAR2             =  0x00460A01,
      GPIO_37_EMIF1_OEN               =  0x00460A02,
      GPIO_37_EPWM18_A                =  0x00460A03,
      GPIO_37_CANA_TX                 =  0x00460A06,
      GPIO_37_CLB_OUTPUTXBAR6         =  0x00460A07,
      GPIO_37_EMIF1_A2                =  0x00460A09,
      GPIO_37_MCANA_TX                =  0x00460A0A,
      GPIO_37_SD1_D2                  =  0x00460A0D,
      GPIO_37_EMIF1_D24               =  0x00460A0E,

      GPIO_38_GPIO38                  =  0x00460C00,
      GPIO_38_EMIF1_A0                =  0x00460C02,
      GPIO_38_EPWM18_B                =  0x00460C03,
      GPIO_38_UARTA_TX                =  0x00460C05,
      GPIO_38_SCIB_TX                 =  0x00460C06,
      GPIO_38_CLB_OUTPUTXBAR7         =  0x00460C07,
      GPIO_38_EMIF1_A3                =  0x00460C09,
      GPIO_38_SD1_D3                  =  0x00460C0D,
      GPIO_38_EMIF1_CS2N              =  0x00460C0E,

      GPIO_39_GPIO39                  =  0x00460E00,
      GPIO_39_EMIF1_A1                =  0x00460E02,
      GPIO_39_UARTA_RX                =  0x00460E05,
      GPIO_39_SCIB_RX                 =  0x00460E06,
      GPIO_39_CLB_OUTPUTXBAR8         =  0x00460E07,
      GPIO_39_EMIF1_A4                =  0x00460E09,
      GPIO_39_ESC_MDIO_DATA           =  0x00460E0A,
      GPIO_39_ESC_LED_RUN             =  0x00460E0B,
      GPIO_39_SD1_D4                  =  0x00460E0D,
      GPIO_39_FSIRXD_CLK              =  0x00460E0E,

      GPIO_40_GPIO40                  =  0x00461000,
      GPIO_40_EMIF1_A2                =  0x00461002,
      GPIO_40_EPWM13_A                =  0x00461003,
      GPIO_40_MCANB_RX                =  0x00461005,
      GPIO_40_I2CB_SDA                =  0x00461006,
      GPIO_40_SD4_C3                  =  0x00461007,
      GPIO_40_ESC_GPO2                =  0x00461009,
      GPIO_40_CLB_OUTPUTXBAR1         =  0x0046100A,
      GPIO_40_SD2_C1                  =  0x0046100D,
      GPIO_40_ESC_I2C_SDA             =  0x0046100E,

      GPIO_41_GPIO41                  =  0x00461200,
      GPIO_41_EMIF1_A3                =  0x00461202,
      GPIO_41_EPWM13_B                =  0x00461203,
      GPIO_41_MCANB_TX                =  0x00461205,
      GPIO_41_I2CB_SCL                =  0x00461206,
      GPIO_41_SD4_D3                  =  0x00461207,
      GPIO_41_CLB_OUTPUTXBAR2         =  0x0046120A,
      GPIO_41_SD2_D1                  =  0x0046120D,
      GPIO_41_ESC_I2C_SCL             =  0x0046120E,
      GPIO_41_FSIRXD_CLK              =  0x0046120F,

      GPIO_42_GPIO42                  =  0x00461400,
      GPIO_42_EPWM14_A                =  0x00461403,
      GPIO_42_EQEP4_A                 =  0x00461405,
      GPIO_42_I2CA_SDA                =  0x00461406,
      GPIO_42_SD4_C4                  =  0x00461407,
      GPIO_42_CLB_OUTPUTXBAR5         =  0x0046140A,
      GPIO_42_UARTA_TX                =  0x0046140B,
      GPIO_42_FSIRXD_D0               =  0x0046140E,
      GPIO_42_SCIA_TX                 =  0x0046140F,

      GPIO_43_GPIO43                  =  0x00461600,
      GPIO_43_EPWM14_B                =  0x00461603,
      GPIO_43_EQEP4_B                 =  0x00461605,
      GPIO_43_I2CA_SCL                =  0x00461606,
      GPIO_43_SD4_D4                  =  0x00461607,
      GPIO_43_CLB_OUTPUTXBAR6         =  0x0046160A,
      GPIO_43_UARTA_RX                =  0x0046160B,
      GPIO_43_FSIRXD_D1               =  0x0046160E,
      GPIO_43_SCIA_RX                 =  0x0046160F,

      GPIO_44_GPIO44                  =  0x00461800,
      GPIO_44_SPID_POCI               =  0x00461801,
      GPIO_44_EMIF1_A4                =  0x00461802,
      GPIO_44_MCANB_RX                =  0x00461803,
      GPIO_44_SD3_C4                  =  0x00461806,
      GPIO_44_UARTB_TX                =  0x00461807,
      GPIO_44_CLB_OUTPUTXBAR6         =  0x0046180A,
      GPIO_44_FSIRXD_CLK              =  0x0046180D,
      GPIO_44_ESC_TX1_CLK             =  0x0046180E,

      GPIO_45_GPIO45                  =  0x00461A00,
      GPIO_45_SPID_PTE                =  0x00461A01,
      GPIO_45_EMIF1_A5                =  0x00461A02,
      GPIO_45_MCANB_TX                =  0x00461A03,
      GPIO_45_SD3_D4                  =  0x00461A06,
      GPIO_45_UARTB_RX                =  0x00461A07,
      GPIO_45_CLB_OUTPUTXBAR7         =  0x00461A0A,
      GPIO_45_ESC_TX1_ENA             =  0x00461A0E,

      GPIO_46_GPIO46                  =  0x00461C00,
      GPIO_46_EPWM4_A                 =  0x00461C01,
      GPIO_46_EMIF1_A6                =  0x00461C02,
      GPIO_46_EPWM14_A                =  0x00461C03,
      GPIO_46_SCIA_RX                 =  0x00461C06,
      GPIO_46_SD3_C4                  =  0x00461C07,
      GPIO_46_ESC_MDIO_CLK            =  0x00461C0E,

      GPIO_47_GPIO47                  =  0x00461E00,
      GPIO_47_EPWM4_B                 =  0x00461E01,
      GPIO_47_EMIF1_A7                =  0x00461E02,
      GPIO_47_EPWM14_B                =  0x00461E03,
      GPIO_47_SCIA_TX                 =  0x00461E06,
      GPIO_47_SD4_C3                  =  0x00461E07,
      GPIO_47_ESC_MDIO_DATA           =  0x00461E0E,

      GPIO_48_GPIO48                  =  0x00480000,
      GPIO_48_OUTPUTXBAR3             =  0x00480001,
      GPIO_48_EMIF1_A8                =  0x00480002,
      GPIO_48_SCIA_TX                 =  0x00480006,
      GPIO_48_SD1_D1                  =  0x00480007,
      GPIO_48_SD2_C2                  =  0x0048000D,
      GPIO_48_ESC_PHY_CLK             =  0x0048000E,

      GPIO_49_GPIO49                  =  0x00480200,
      GPIO_49_OUTPUTXBAR4             =  0x00480201,
      GPIO_49_EMIF1_A9                =  0x00480202,
      GPIO_49_SCIA_RX                 =  0x00480206,
      GPIO_49_SD1_C1                  =  0x00480207,
      GPIO_49_EMIF1_A5                =  0x00480209,
      GPIO_49_SD2_D1                  =  0x0048020D,
      GPIO_49_FSITXA_D0               =  0x0048020E,

      GPIO_50_GPIO50                  =  0x00480400,
      GPIO_50_EQEP1_A                 =  0x00480401,
      GPIO_50_EMIF1_A10               =  0x00480402,
      GPIO_50_EPWM15_A                =  0x00480403,
      GPIO_50_SPIC_PICO               =  0x00480406,
      GPIO_50_SD1_D2                  =  0x00480407,
      GPIO_50_EMIF1_A6                =  0x00480409,
      GPIO_50_ESC_LATCH0              =  0x0048040B,
      GPIO_50_SD2_D2                  =  0x0048040D,
      GPIO_50_FSITXA_D1               =  0x0048040E,

      GPIO_51_GPIO51                  =  0x00480600,
      GPIO_51_EQEP1_B                 =  0x00480601,
      GPIO_51_EMIF1_A11               =  0x00480602,
      GPIO_51_EPWM15_B                =  0x00480603,
      GPIO_51_SPIC_POCI               =  0x00480606,
      GPIO_51_SD1_C2                  =  0x00480607,
      GPIO_51_EMIF1_A7                =  0x00480609,
      GPIO_51_ESC_LATCH1              =  0x0048060B,
      GPIO_51_SD2_D3                  =  0x0048060D,
      GPIO_51_FSITXA_CLK              =  0x0048060E,

      GPIO_52_GPIO52                  =  0x00480800,
      GPIO_52_EQEP1_STROBE            =  0x00480801,
      GPIO_52_EMIF1_A12               =  0x00480802,
      GPIO_52_EPWM16_A                =  0x00480803,
      GPIO_52_SPIC_CLK                =  0x00480806,
      GPIO_52_SD1_D3                  =  0x00480807,
      GPIO_52_EMIF1_A8                =  0x00480809,
      GPIO_52_ESC_MDIO_CLK            =  0x0048080B,
      GPIO_52_SD2_D4                  =  0x0048080D,
      GPIO_52_FSIRXA_D0               =  0x0048080E,

      GPIO_53_GPIO53                  =  0x00480A00,
      GPIO_53_EQEP1_INDEX             =  0x00480A01,
      GPIO_53_EMIF1_D31               =  0x00480A02,
      GPIO_53_SPIC_PTE                =  0x00480A06,
      GPIO_53_SD1_C3                  =  0x00480A07,
      GPIO_53_EMIF1_A9                =  0x00480A09,
      GPIO_53_ESC_MDIO_DATA           =  0x00480A0B,
      GPIO_53_SD1_C1                  =  0x00480A0D,
      GPIO_53_FSIRXA_D1               =  0x00480A0E,

      GPIO_54_GPIO54                  =  0x00480C00,
      GPIO_54_SPIA_PICO               =  0x00480C01,
      GPIO_54_EMIF1_D30               =  0x00480C02,
      GPIO_54_EQEP2_A                 =  0x00480C05,
      GPIO_54_SCIB_TX                 =  0x00480C06,
      GPIO_54_SD1_D4                  =  0x00480C07,
      GPIO_54_EMIF1_A10               =  0x00480C09,
      GPIO_54_ESC_PHY_CLK             =  0x00480C0B,
      GPIO_54_SD1_C2                  =  0x00480C0D,
      GPIO_54_FSIRXA_CLK              =  0x00480C0E,

      GPIO_55_GPIO55                  =  0x00480E00,
      GPIO_55_SPIA_POCI               =  0x00480E01,
      GPIO_55_EMIF1_D29               =  0x00480E02,
      GPIO_55_EPWM16_B                =  0x00480E03,
      GPIO_55_EQEP2_B                 =  0x00480E05,
      GPIO_55_SCIB_RX                 =  0x00480E06,
      GPIO_55_SD1_C4                  =  0x00480E07,
      GPIO_55_EMIF1_D0                =  0x00480E09,
      GPIO_55_ESC_PHY0_LINKSTATUS     =  0x00480E0B,
      GPIO_55_SD1_C3                  =  0x00480E0D,
      GPIO_55_FSITXB_D0               =  0x00480E0E,

      GPIO_56_GPIO56                  =  0x00481000,
      GPIO_56_SPIA_CLK                =  0x00481001,
      GPIO_56_EMIF1_D28               =  0x00481002,
      GPIO_56_EPWM17_A                =  0x00481003,
      GPIO_56_EQEP2_STROBE            =  0x00481005,
      GPIO_56_SD2_D1                  =  0x00481007,
      GPIO_56_EMIF1_D1                =  0x00481009,
      GPIO_56_I2CA_SDA                =  0x0048100A,
      GPIO_56_ESC_TX0_ENA             =  0x0048100B,
      GPIO_56_SD1_C4                  =  0x0048100D,
      GPIO_56_FSITXB_CLK              =  0x0048100E,

      GPIO_57_GPIO57                  =  0x00481200,
      GPIO_57_SPIA_PTE                =  0x00481201,
      GPIO_57_EMIF1_D27               =  0x00481202,
      GPIO_57_EPWM17_B                =  0x00481203,
      GPIO_57_EQEP2_INDEX             =  0x00481205,
      GPIO_57_SD2_C1                  =  0x00481207,
      GPIO_57_EMIF1_D2                =  0x00481209,
      GPIO_57_I2CA_SCL                =  0x0048120A,
      GPIO_57_ESC_TX0_CLK             =  0x0048120B,
      GPIO_57_SD3_D3                  =  0x0048120D,
      GPIO_57_FSITXB_D1               =  0x0048120E,

      GPIO_58_GPIO58                  =  0x00481400,
      GPIO_58_SPIA_PICO               =  0x00481401,
      GPIO_58_EMIF1_D26               =  0x00481402,
      GPIO_58_EPWM8_A                 =  0x00481403,
      GPIO_58_OUTPUTXBAR1             =  0x00481405,
      GPIO_58_SPIB_CLK                =  0x00481406,
      GPIO_58_SD2_D2                  =  0x00481407,
      GPIO_58_EMIF1_D3                =  0x00481409,
      GPIO_58_ESC_LED_LINK0_ACTIVE    =  0x0048140A,
      GPIO_58_CANA_RX                 =  0x0048140B,
      GPIO_58_SD2_C2                  =  0x0048140D,
      GPIO_58_FSIRXB_D0               =  0x0048140E,

      GPIO_59_GPIO59                  =  0x00481600,
      GPIO_59_EPWM5_A                 =  0x00481601,
      GPIO_59_EMIF1_D25               =  0x00481602,
      GPIO_59_EPWM8_B                 =  0x00481603,
      GPIO_59_OUTPUTXBAR2             =  0x00481605,
      GPIO_59_SPIB_PTE                =  0x00481606,
      GPIO_59_SD2_C2                  =  0x00481607,
      GPIO_59_EMIF1_D4                =  0x00481609,
      GPIO_59_ESC_LED_LINK1_ACTIVE    =  0x0048160A,
      GPIO_59_CANA_TX                 =  0x0048160B,
      GPIO_59_SD2_C3                  =  0x0048160D,
      GPIO_59_FSIRXB_D1               =  0x0048160E,
      GPIO_59_SPIA_POCI               =  0x0048160F,

      GPIO_60_GPIO60                  =  0x00481800,
      GPIO_60_EPWM3_B                 =  0x00481801,
      GPIO_60_EMIF1_D24               =  0x00481802,
      GPIO_60_ESC_LATCH0              =  0x00481803,
      GPIO_60_OUTPUTXBAR3             =  0x00481805,
      GPIO_60_SPIB_PICO               =  0x00481806,
      GPIO_60_SD2_D3                  =  0x00481807,
      GPIO_60_EMIF1_D5                =  0x00481809,
      GPIO_60_ESC_LED_ERR             =  0x0048180A,
      GPIO_60_SD2_C4                  =  0x0048180D,
      GPIO_60_FSIRXB_CLK              =  0x0048180E,
      GPIO_60_SPIA_CLK                =  0x0048180F,

      GPIO_61_GPIO61                  =  0x00481A00,
      GPIO_61_EPWM17_B                =  0x00481A01,
      GPIO_61_EMIF1_D23               =  0x00481A02,
      GPIO_61_ESC_LATCH1              =  0x00481A03,
      GPIO_61_OUTPUTXBAR4             =  0x00481A05,
      GPIO_61_SPIB_POCI               =  0x00481A06,
      GPIO_61_SD2_C3                  =  0x00481A07,
      GPIO_61_EMIF1_D6                =  0x00481A09,
      GPIO_61_ESC_LED_RUN             =  0x00481A0A,
      GPIO_61_CANA_RX                 =  0x00481A0E,
      GPIO_61_SPIA_PTE                =  0x00481A0F,

      GPIO_62_GPIO62                  =  0x00481C00,
      GPIO_62_SCIA_RX                 =  0x00481C01,
      GPIO_62_EMIF1_D22               =  0x00481C02,
      GPIO_62_ESC_MDIO_CLK            =  0x00481C03,
      GPIO_62_EQEP3_A                 =  0x00481C05,
      GPIO_62_CANA_RX                 =  0x00481C06,
      GPIO_62_SD2_D4                  =  0x00481C07,
      GPIO_62_EMIF1_D7                =  0x00481C09,
      GPIO_62_ESC_LED_STATE_RUN       =  0x00481C0A,
      GPIO_62_CANA_TX                 =  0x00481C0E,

      GPIO_63_GPIO63                  =  0x00481E00,
      GPIO_63_SCIA_TX                 =  0x00481E01,
      GPIO_63_EMIF1_D21               =  0x00481E02,
      GPIO_63_EPWM9_A                 =  0x00481E03,
      GPIO_63_EQEP3_B                 =  0x00481E05,
      GPIO_63_CANA_TX                 =  0x00481E06,
      GPIO_63_SD2_C4                  =  0x00481E07,
      GPIO_63_EMIF1_RNW               =  0x00481E09,
      GPIO_63_EMIF1_BA0               =  0x00481E0A,
      GPIO_63_SD1_D1                  =  0x00481E0D,
      GPIO_63_ESC_RX1_DATA0           =  0x00481E0E,
      GPIO_63_SPIB_PICO               =  0x00481E0F,

      GPIO_64_GPIO64                  =  0x00860000,
      GPIO_64_EMIF1_D20               =  0x00860002,
      GPIO_64_EPWM9_B                 =  0x00860003,
      GPIO_64_EQEP3_STROBE            =  0x00860005,
      GPIO_64_SCIA_RX                 =  0x00860006,
      GPIO_64_EMIF1_WAIT              =  0x00860009,
      GPIO_64_EMIF1_BA1               =  0x0086000A,
      GPIO_64_SD1_C1                  =  0x0086000D,
      GPIO_64_ESC_RX1_DATA1           =  0x0086000E,
      GPIO_64_SPIB_POCI               =  0x0086000F,

      GPIO_65_GPIO65                  =  0x00860200,
      GPIO_65_EMIF1_D19               =  0x00860202,
      GPIO_65_EPWM10_A                =  0x00860203,
      GPIO_65_EQEP3_INDEX             =  0x00860205,
      GPIO_65_SCIA_TX                 =  0x00860206,
      GPIO_65_EMIF1_WEN               =  0x00860209,
      GPIO_65_FSITXB_CLK              =  0x0086020B,
      GPIO_65_SD1_D2                  =  0x0086020D,
      GPIO_65_ESC_RX1_DATA2           =  0x0086020E,
      GPIO_65_SPIB_CLK                =  0x0086020F,

      GPIO_66_GPIO66                  =  0x00860400,
      GPIO_66_EQEP6_B                 =  0x00860401,
      GPIO_66_EMIF1_D18               =  0x00860402,
      GPIO_66_EPWM10_B                =  0x00860403,
      GPIO_66_I2CB_SDA                =  0x00860406,
      GPIO_66_EMIF1_OEN               =  0x00860409,
      GPIO_66_FSITXB_D1               =  0x0086040B,
      GPIO_66_SD1_C2                  =  0x0086040D,
      GPIO_66_ESC_RX1_DATA3           =  0x0086040E,
      GPIO_66_SPIB_PTE                =  0x0086040F,

      GPIO_67_GPIO67                  =  0x00860600,
      GPIO_67_EMIF1_D17               =  0x00860602,
      GPIO_67_EPWM17_A                =  0x00860603,
      GPIO_67_LINB_TX                 =  0x00860605,
      GPIO_67_ESC_I2C_SDA             =  0x0086060B,
      GPIO_67_SD1_D3                  =  0x0086060D,

      GPIO_68_GPIO68                  =  0x00860800,
      GPIO_68_EMIF1_D16               =  0x00860802,
      GPIO_68_EPWM17_B                =  0x00860803,
      GPIO_68_LINB_RX                 =  0x00860805,
      GPIO_68_ESC_I2C_SCL             =  0x0086080B,
      GPIO_68_SD1_C3                  =  0x0086080D,
      GPIO_68_ESC_PHY1_LINKSTATUS     =  0x0086080E,

      GPIO_69_GPIO69                  =  0x00860A00,
      GPIO_69_EMIF1_D15               =  0x00860A02,
      GPIO_69_EPWM11_A                =  0x00860A03,
      GPIO_69_I2CB_SCL                =  0x00860A06,
      GPIO_69_FSITXB_D0               =  0x00860A0B,
      GPIO_69_SD1_D4                  =  0x00860A0D,
      GPIO_69_ESC_RX1_CLK             =  0x00860A0E,
      GPIO_69_SPIC_PICO               =  0x00860A0F,

      GPIO_70_GPIO70                  =  0x00860C00,
      GPIO_70_EMIF1_D14               =  0x00860C02,
      GPIO_70_EPWM11_B                =  0x00860C03,
      GPIO_70_CANA_RX                 =  0x00860C05,
      GPIO_70_SCIB_TX                 =  0x00860C06,
      GPIO_70_UARTB_TX                =  0x00860C07,
      GPIO_70_MCANA_RX                =  0x00860C09,
      GPIO_70_FSIRXB_D0               =  0x00860C0B,
      GPIO_70_SD1_C4                  =  0x00860C0D,
      GPIO_70_ESC_RX1_DV              =  0x00860C0E,
      GPIO_70_SPIC_POCI               =  0x00860C0F,

      GPIO_71_GPIO71                  =  0x00860E00,
      GPIO_71_EMIF1_D13               =  0x00860E02,
      GPIO_71_EPWM12_A                =  0x00860E03,
      GPIO_71_CANA_TX                 =  0x00860E05,
      GPIO_71_SCIB_RX                 =  0x00860E06,
      GPIO_71_UARTB_RX                =  0x00860E07,
      GPIO_71_MCANA_TX                =  0x00860E09,
      GPIO_71_SD3_D1                  =  0x00860E0D,
      GPIO_71_ESC_RX1_ERR             =  0x00860E0E,
      GPIO_71_SPIC_CLK                =  0x00860E0F,

      GPIO_72_GPIO72                  =  0x00861000,
      GPIO_72_EQEP6_STROBE            =  0x00861001,
      GPIO_72_EMIF1_D12               =  0x00861002,
      GPIO_72_EPWM12_B                =  0x00861003,
      GPIO_72_OUTPUTXBAR8             =  0x00861005,
      GPIO_72_UARTA_TX                =  0x00861006,
      GPIO_72_MCANB_RX                =  0x00861009,
      GPIO_72_SD3_C1                  =  0x0086100D,
      GPIO_72_ESC_TX1_DATA3           =  0x0086100E,
      GPIO_72_SPIC_PTE                =  0x0086100F,

      GPIO_73_GPIO73                  =  0x00861200,
      GPIO_73_EQEP6_INDEX             =  0x00861201,
      GPIO_73_EMIF1_D11               =  0x00861202,
      GPIO_73_XCLKOUT                 =  0x00861203,
      GPIO_73_OUTPUTXBAR6             =  0x00861205,
      GPIO_73_UARTA_RX                =  0x00861206,
      GPIO_73_EPWM5_B                 =  0x00861207,
      GPIO_73_MCANB_TX                =  0x00861209,
      GPIO_73_SD4_D4                  =  0x0086120A,
      GPIO_73_SD2_D2                  =  0x0086120D,
      GPIO_73_ESC_TX1_DATA2           =  0x0086120E,

      GPIO_74_GPIO74                  =  0x00861400,
      GPIO_74_EPWM8_A                 =  0x00861401,
      GPIO_74_EMIF1_D10               =  0x00861402,
      GPIO_74_EQEP5_A                 =  0x00861406,
      GPIO_74_MCANA_TX                =  0x00861409,
      GPIO_74_SD1_D4                  =  0x0086140A,
      GPIO_74_SD2_C2                  =  0x0086140D,
      GPIO_74_ESC_TX1_DATA1           =  0x0086140E,

      GPIO_75_GPIO75                  =  0x00861600,
      GPIO_75_EPWM8_B                 =  0x00861601,
      GPIO_75_EMIF1_D9                =  0x00861602,
      GPIO_75_EQEP5_B                 =  0x00861606,
      GPIO_75_SPID_CLK                =  0x00861607,
      GPIO_75_MCANA_RX                =  0x00861609,
      GPIO_75_CLB_OUTPUTXBAR8         =  0x0086160A,
      GPIO_75_SD2_D3                  =  0x0086160D,
      GPIO_75_ESC_TX1_DATA0           =  0x0086160E,

      GPIO_76_GPIO76                  =  0x00861800,
      GPIO_76_EPWM9_A                 =  0x00861801,
      GPIO_76_EMIF1_D8                =  0x00861802,
      GPIO_76_EQEP5_STROBE            =  0x00861806,
      GPIO_76_SD3_C1                  =  0x00861807,
      GPIO_76_SD4_D4                  =  0x0086180A,
      GPIO_76_SD2_C3                  =  0x0086180D,
      GPIO_76_ESC_PHY_RESETN          =  0x0086180E,

      GPIO_77_GPIO77                  =  0x00861A00,
      GPIO_77_EPWM9_B                 =  0x00861A01,
      GPIO_77_EMIF1_D7                =  0x00861A02,
      GPIO_77_EQEP5_INDEX             =  0x00861A06,
      GPIO_77_SD3_D1                  =  0x00861A07,
      GPIO_77_SD1_D4                  =  0x00861A0A,
      GPIO_77_SD2_D4                  =  0x00861A0D,
      GPIO_77_ESC_RX0_CLK             =  0x00861A0E,

      GPIO_78_GPIO78                  =  0x00861C00,
      GPIO_78_EPWM10_A                =  0x00861C01,
      GPIO_78_EMIF1_D6                =  0x00861C02,
      GPIO_78_EQEP2_A                 =  0x00861C06,
      GPIO_78_SD3_C2                  =  0x00861C07,
      GPIO_78_SD4_D4                  =  0x00861C0A,
      GPIO_78_SD2_C4                  =  0x00861C0D,
      GPIO_78_ESC_RX0_DV              =  0x00861C0E,

      GPIO_79_GPIO79                  =  0x00861E00,
      GPIO_79_EPWM10_B                =  0x00861E01,
      GPIO_79_EMIF1_D5                =  0x00861E02,
      GPIO_79_ERRORSTS                =  0x00861E05,
      GPIO_79_EQEP2_B                 =  0x00861E06,
      GPIO_79_SD3_D2                  =  0x00861E07,
      GPIO_79_SD2_D1                  =  0x00861E0D,
      GPIO_79_ESC_RX0_ERR             =  0x00861E0E,

      GPIO_80_GPIO80                  =  0x00880000,
      GPIO_80_EPWM11_A                =  0x00880001,
      GPIO_80_EMIF1_D4                =  0x00880002,
      GPIO_80_ERRORSTS                =  0x00880005,
      GPIO_80_EQEP2_STROBE            =  0x00880006,
      GPIO_80_SD3_C3                  =  0x00880007,
      GPIO_80_SD1_D4                  =  0x0088000A,
      GPIO_80_SD2_C1                  =  0x0088000D,
      GPIO_80_ESC_RX0_DATA0           =  0x0088000E,

      GPIO_81_GPIO81                  =  0x00880200,
      GPIO_81_EPWM11_B                =  0x00880201,
      GPIO_81_EMIF1_D3                =  0x00880202,
      GPIO_81_EQEP2_INDEX             =  0x00880206,
      GPIO_81_SD3_D3                  =  0x00880207,
      GPIO_81_ESC_RX0_DATA1           =  0x0088020E,

      GPIO_82_GPIO82                  =  0x00880400,
      GPIO_82_EPWM12_A                =  0x00880401,
      GPIO_82_EMIF1_D2                =  0x00880402,
      GPIO_82_SD3_C2                  =  0x0088040D,
      GPIO_82_ESC_RX0_DATA2           =  0x0088040E,

      GPIO_83_GPIO83                  =  0x00880600,
      GPIO_83_EPWM12_B                =  0x00880601,
      GPIO_83_EMIF1_D1                =  0x00880602,
      GPIO_83_SD3_D2                  =  0x0088060D,
      GPIO_83_ESC_RX0_DATA3           =  0x0088060E,

      GPIO_84_GPIO84                  =  0x00880800,
      GPIO_84_EPWM12_B                =  0x00880801,
      GPIO_84_EMIF1_D1                =  0x00880802,
      GPIO_84_EMIF1_CS4N              =  0x00880803,
      GPIO_84_SCIA_TX                 =  0x00880805,
      GPIO_84_EQEP6_A                 =  0x00880806,
      GPIO_84_SD3_D2                  =  0x00880809,
      GPIO_84_UARTA_TX                =  0x0088080B,
      GPIO_84_SD3_C2                  =  0x0088080D,
      GPIO_84_ESC_TX0_ENA             =  0x0088080E,
      GPIO_84_ESC_RX0_DATA3           =  0x0088080F,

      GPIO_85_GPIO85                  =  0x00880A00,
      GPIO_85_EPWM13_A                =  0x00880A01,
      GPIO_85_EMIF1_D0                =  0x00880A02,
      GPIO_85_SCIA_RX                 =  0x00880A05,
      GPIO_85_EQEP6_B                 =  0x00880A06,
      GPIO_85_SD3_D1                  =  0x00880A07,
      GPIO_85_UARTA_RX                =  0x00880A0B,
      GPIO_85_SD3_D3                  =  0x00880A0D,
      GPIO_85_ESC_TX0_CLK             =  0x00880A0E,
      GPIO_85_EMIF1_DQM2              =  0x00880A0F,

      GPIO_86_GPIO86                  =  0x00880C00,
      GPIO_86_EPWM13_B                =  0x00880C01,
      GPIO_86_EMIF1_A13               =  0x00880C02,
      GPIO_86_EMIF1_CAS               =  0x00880C03,
      GPIO_86_SCIB_TX                 =  0x00880C05,
      GPIO_86_EQEP6_STROBE            =  0x00880C06,
      GPIO_86_SD3_C3                  =  0x00880C0D,
      GPIO_86_ESC_PHY0_LINKSTATUS     =  0x00880C0E,

      GPIO_87_GPIO87                  =  0x00880E00,
      GPIO_87_EPWM14_A                =  0x00880E01,
      GPIO_87_EMIF1_A14               =  0x00880E02,
      GPIO_87_EMIF1_RAS               =  0x00880E03,
      GPIO_87_SCIB_RX                 =  0x00880E05,
      GPIO_87_EQEP6_INDEX             =  0x00880E06,
      GPIO_87_EMIF1_DQM3              =  0x00880E09,
      GPIO_87_SD3_D4                  =  0x00880E0D,
      GPIO_87_ESC_TX0_DATA0           =  0x00880E0E,

      GPIO_88_GPIO88                  =  0x00881000,
      GPIO_88_EPWM14_B                =  0x00881001,
      GPIO_88_EMIF1_A15               =  0x00881002,
      GPIO_88_EMIF1_DQM0              =  0x00881003,
      GPIO_88_EMIF1_DQM1              =  0x00881009,
      GPIO_88_SD3_C4                  =  0x0088100D,
      GPIO_88_ESC_TX0_DATA1           =  0x0088100E,

      GPIO_89_GPIO89                  =  0x00881200,
      GPIO_89_EPWM15_A                =  0x00881201,
      GPIO_89_EMIF1_A16               =  0x00881202,
      GPIO_89_EMIF1_DQM1              =  0x00881203,
      GPIO_89_SD1_D3                  =  0x00881207,
      GPIO_89_EMIF1_CAS               =  0x00881209,
      GPIO_89_SD4_D1                  =  0x0088120D,
      GPIO_89_ESC_TX0_DATA2           =  0x0088120E,
      GPIO_89_SPID_PTE                =  0x0088120F,

      GPIO_90_GPIO90                  =  0x00881400,
      GPIO_90_EPWM15_B                =  0x00881401,
      GPIO_90_EMIF1_A17               =  0x00881402,
      GPIO_90_EMIF1_DQM2              =  0x00881403,
      GPIO_90_SD1_C3                  =  0x00881407,
      GPIO_90_EMIF1_RAS               =  0x00881409,
      GPIO_90_SD4_C1                  =  0x0088140D,
      GPIO_90_ESC_TX0_DATA3           =  0x0088140E,
      GPIO_90_SPID_CLK                =  0x0088140F,

      GPIO_91_GPIO91                  =  0x00881600,
      GPIO_91_EPWM16_A                =  0x00881601,
      GPIO_91_EMIF1_A18               =  0x00881602,
      GPIO_91_EMIF1_DQM3              =  0x00881603,
      GPIO_91_I2CA_SDA                =  0x00881606,
      GPIO_91_SD4_D2                  =  0x00881607,
      GPIO_91_EMIF1_DQM2              =  0x00881609,
      GPIO_91_PMBUSA_SCL              =  0x0088160A,
      GPIO_91_CLB_OUTPUTXBAR1         =  0x0088160E,
      GPIO_91_SPID_PICO               =  0x0088160F,

      GPIO_92_GPIO92                  =  0x00881800,
      GPIO_92_EPWM16_B                =  0x00881801,
      GPIO_92_EMIF1_A19               =  0x00881802,
      GPIO_92_EMIF1_BA1               =  0x00881803,
      GPIO_92_I2CA_SCL                =  0x00881806,
      GPIO_92_SD4_C2                  =  0x00881807,
      GPIO_92_EMIF1_DQM0              =  0x00881809,
      GPIO_92_PMBUSA_SDA              =  0x0088180A,
      GPIO_92_FSIRXD_CLK              =  0x0088180B,
      GPIO_92_CLB_OUTPUTXBAR2         =  0x0088180E,
      GPIO_92_SPID_POCI               =  0x0088180F,

      GPIO_93_GPIO93                  =  0x00881A00,
      GPIO_93_EPWM17_A                =  0x00881A01,
      GPIO_93_EMIF1_BA0               =  0x00881A03,
      GPIO_93_SD4_D3                  =  0x00881A07,
      GPIO_93_PMBUSA_ALERT            =  0x00881A0A,
      GPIO_93_ESC_TX1_CLK             =  0x00881A0B,
      GPIO_93_CLB_OUTPUTXBAR3         =  0x00881A0E,
      GPIO_93_SPID_CLK                =  0x00881A0F,

      GPIO_94_GPIO94                  =  0x00881C00,
      GPIO_94_EPWM17_B                =  0x00881C01,
      GPIO_94_SD4_C3                  =  0x00881C07,
      GPIO_94_EMIF1_BA1               =  0x00881C09,
      GPIO_94_PMBUSA_CTL              =  0x00881C0A,
      GPIO_94_ESC_TX1_ENA             =  0x00881C0B,
      GPIO_94_CLB_OUTPUTXBAR4         =  0x00881C0E,
      GPIO_94_SPID_PTE                =  0x00881C0F,

      GPIO_95_GPIO95                  =  0x00881E00,
      GPIO_95_EPWM18_A                =  0x00881E01,
      GPIO_95_EQEP4_A                 =  0x00881E02,
      GPIO_95_SD1_D1                  =  0x00881E06,
      GPIO_95_ESC_GPO10               =  0x00881E0A,
      GPIO_95_CLB_OUTPUTXBAR5         =  0x00881E0E,

      GPIO_96_GPIO96                  =  0x00C60000,
      GPIO_96_EPWM18_B                =  0x00C60001,
      GPIO_96_EQEP4_B                 =  0x00C60002,
      GPIO_96_EQEP1_A                 =  0x00C60005,
      GPIO_96_SD1_C1                  =  0x00C60006,
      GPIO_96_ESC_GPO11               =  0x00C6000A,
      GPIO_96_CLB_OUTPUTXBAR6         =  0x00C6000E,

      GPIO_97_GPIO97                  =  0x00C60200,
      GPIO_97_EQEP4_STROBE            =  0x00C60202,
      GPIO_97_EQEP1_B                 =  0x00C60205,
      GPIO_97_SD1_D2                  =  0x00C60206,
      GPIO_97_ESC_GPI17               =  0x00C6020A,
      GPIO_97_CLB_OUTPUTXBAR7         =  0x00C6020E,

      GPIO_98_GPIO98                  =  0x00C60400,
      GPIO_98_EQEP4_INDEX             =  0x00C60402,
      GPIO_98_EQEP1_STROBE            =  0x00C60405,
      GPIO_98_SD1_C2                  =  0x00C60406,
      GPIO_98_ESC_GPI18               =  0x00C6040A,
      GPIO_98_CLB_OUTPUTXBAR8         =  0x00C6040E,

      GPIO_99_GPIO99                  =  0x00C60600,
      GPIO_99_EMIF1_DQM3              =  0x00C60602,
      GPIO_99_EPWM8_A                 =  0x00C60603,
      GPIO_99_EQEP1_INDEX             =  0x00C60605,
      GPIO_99_SD4_D4                  =  0x00C60607,
      GPIO_99_ESC_GPI21               =  0x00C6060A,
      GPIO_99_EMIF1_D17               =  0x00C6060E,

      GPIO_100_GPIO100                =  0x00C60800,
      GPIO_100_SPIA_PICO              =  0x00C60801,
      GPIO_100_EMIF1_BA1              =  0x00C60802,
      GPIO_100_EPWM9_A                =  0x00C60803,
      GPIO_100_EQEP2_A                =  0x00C60805,
      GPIO_100_SPIC_PICO              =  0x00C60806,
      GPIO_100_SD4_C4                 =  0x00C60807,
      GPIO_100_SD1_D1                 =  0x00C60809,
      GPIO_100_ESC_GPI0               =  0x00C6080A,
      GPIO_100_FSIRXD_D1              =  0x00C6080B,
      GPIO_100_FSITXA_D0              =  0x00C6080D,
      GPIO_100_EMIF1_D24              =  0x00C6080E,

      GPIO_101_GPIO101                =  0x00C60A00,
      GPIO_101_EPWM18_A               =  0x00C60A01,
      GPIO_101_EQEP2_B                =  0x00C60A05,
      GPIO_101_SPIC_POCI              =  0x00C60A06,
      GPIO_101_ESC_GPI1               =  0x00C60A0A,
      GPIO_101_EMIF1_A5               =  0x00C60A0B,
      GPIO_101_FSITXA_D1              =  0x00C60A0D,

      GPIO_102_GPIO102                =  0x00C60C00,
      GPIO_102_EPWM18_B               =  0x00C60C01,
      GPIO_102_EQEP2_STROBE           =  0x00C60C05,
      GPIO_102_SPIC_CLK               =  0x00C60C06,
      GPIO_102_ESC_GPI2               =  0x00C60C0A,
      GPIO_102_EMIF1_A6               =  0x00C60C0B,
      GPIO_102_FSITXA_CLK             =  0x00C60C0D,

      GPIO_103_GPIO103                =  0x00C60E00,
      GPIO_103_EMIF1_BA0              =  0x00C60E02,
      GPIO_103_EPWM8_B                =  0x00C60E03,
      GPIO_103_EQEP2_INDEX            =  0x00C60E05,
      GPIO_103_SPIC_PTE               =  0x00C60E06,
      GPIO_103_SD4_C4                 =  0x00C60E07,
      GPIO_103_ESC_GPI3               =  0x00C60E0A,
      GPIO_103_FSIRXA_D0              =  0x00C60E0D,

      GPIO_104_GPIO104                =  0x00C61000,
      GPIO_104_I2CA_SDA               =  0x00C61001,
      GPIO_104_EPWM18_A               =  0x00C61002,
      GPIO_104_EQEP3_A                =  0x00C61005,
      GPIO_104_SD3_D1                 =  0x00C61006,
      GPIO_104_ESC_GPI4               =  0x00C6100A,
      GPIO_104_FSIRXA_D1              =  0x00C6100D,
      GPIO_104_ESC_SYNC0              =  0x00C6100E,

      GPIO_105_GPIO105                =  0x00C61200,
      GPIO_105_I2CA_SCL               =  0x00C61201,
      GPIO_105_EPWM18_B               =  0x00C61202,
      GPIO_105_EQEP3_B                =  0x00C61205,
      GPIO_105_SD3_C1                 =  0x00C61206,
      GPIO_105_ESC_GPI5               =  0x00C6120A,
      GPIO_105_FSIRXA_CLK             =  0x00C6120D,
      GPIO_105_ESC_SYNC1              =  0x00C6120E,

      GPIO_106_GPIO106                =  0x00C61400,
      GPIO_106_EPWM16_A               =  0x00C61401,
      GPIO_106_EMIF1_A10              =  0x00C61402,
      GPIO_106_EQEP3_STROBE           =  0x00C61405,
      GPIO_106_SD3_D2                 =  0x00C61406,
      GPIO_106_ESC_GPI6               =  0x00C6140A,
      GPIO_106_FSITXB_D0              =  0x00C6140D,

      GPIO_107_GPIO107                =  0x00C61600,
      GPIO_107_EPWM16_B               =  0x00C61601,
      GPIO_107_EQEP3_INDEX            =  0x00C61605,
      GPIO_107_SD3_C2                 =  0x00C61606,
      GPIO_107_ESC_GPI7               =  0x00C6160A,
      GPIO_107_FSITXB_D1              =  0x00C6160D,

      GPIO_108_GPIO108                =  0x00C61800,
      GPIO_108_EPWM17_A               =  0x00C61801,
      GPIO_108_EMIF1_A12              =  0x00C61802,
      GPIO_108_EQEP5_A                =  0x00C61805,
      GPIO_108_SD3_D3                 =  0x00C61806,
      GPIO_108_ESC_GPI8               =  0x00C6180A,
      GPIO_108_FSITXB_CLK             =  0x00C6180D,

      GPIO_109_GPIO109                =  0x00C61A00,
      GPIO_109_EPWM17_B               =  0x00C61A01,
      GPIO_109_EMIF1_A11              =  0x00C61A02,
      GPIO_109_EQEP5_B                =  0x00C61A05,
      GPIO_109_SD3_C3                 =  0x00C61A06,
      GPIO_109_ESC_GPI9               =  0x00C61A0A,

      GPIO_110_GPIO110                =  0x00C61C00,
      GPIO_110_EMIF1_D31              =  0x00C61C01,
      GPIO_110_EQEP5_STROBE           =  0x00C61C05,
      GPIO_110_SD3_D4                 =  0x00C61C06,
      GPIO_110_ESC_GPI10              =  0x00C61C0A,
      GPIO_110_FSIRXB_D0              =  0x00C61C0D,

      GPIO_111_GPIO111                =  0x00C61E00,
      GPIO_111_EMIF1_D30              =  0x00C61E01,
      GPIO_111_EQEP5_INDEX            =  0x00C61E05,
      GPIO_111_SD3_C4                 =  0x00C61E06,
      GPIO_111_ESC_GPI11              =  0x00C61E0A,
      GPIO_111_FSIRXB_D1              =  0x00C61E0D,

      GPIO_112_GPIO112                =  0x00C80000,
      GPIO_112_EMIF1_D29              =  0x00C80001,
      GPIO_112_SD1_D3                 =  0x00C80007,
      GPIO_112_ESC_GPI12              =  0x00C8000A,
      GPIO_112_FSIRXB_CLK             =  0x00C8000D,

      GPIO_113_GPIO113                =  0x00C80200,
      GPIO_113_EMIF1_D28              =  0x00C80201,
      GPIO_113_SD1_C3                 =  0x00C80207,
      GPIO_113_ESC_GPI13              =  0x00C8020A,

      GPIO_114_GPIO114                =  0x00C80400,
      GPIO_114_EMIF1_D27              =  0x00C80401,
      GPIO_114_SD1_D4                 =  0x00C80407,
      GPIO_114_ESC_GPI14              =  0x00C8040A,

      GPIO_115_GPIO115                =  0x00C80600,
      GPIO_115_EMIF1_D26              =  0x00C80601,
      GPIO_115_OUTPUTXBAR5            =  0x00C80605,
      GPIO_115_SD1_C4                 =  0x00C80607,
      GPIO_115_ESC_GPI15              =  0x00C8060A,
      GPIO_115_FSIRXC_D0              =  0x00C8060D,

      GPIO_116_GPIO116                =  0x00C80800,
      GPIO_116_OUTPUTXBAR6            =  0x00C80805,
      GPIO_116_ESC_GPI16              =  0x00C8080A,
      GPIO_116_FSIRXC_D1              =  0x00C8080D,

      GPIO_117_GPIO117                =  0x00C80A00,
      GPIO_117_ESC_GPI17              =  0x00C80A0A,
      GPIO_117_FSIRXC_CLK             =  0x00C80A0D,

      GPIO_118_GPIO118                =  0x00C80C00,
      GPIO_118_ESC_GPI18              =  0x00C80C0A,
      GPIO_118_FSIRXD_D0              =  0x00C80C0D,

      GPIO_119_GPIO119                =  0x00C80E00,
      GPIO_119_EMIF1_D25              =  0x00C80E01,
      GPIO_119_MCANB_TX               =  0x00C80E05,
      GPIO_119_ESC_GPI19              =  0x00C80E0A,
      GPIO_119_FSIRXD_D1              =  0x00C80E0D,

      GPIO_120_GPIO120                =  0x00C81000,
      GPIO_120_EMIF1_D24              =  0x00C81001,
      GPIO_120_MCANB_RX               =  0x00C81005,
      GPIO_120_ESC_GPI20              =  0x00C8100A,
      GPIO_120_FSIRXD_CLK             =  0x00C8100D,

      GPIO_121_GPIO121                =  0x00C81200,
      GPIO_121_ESC_GPI21              =  0x00C8120A,

      GPIO_122_GPIO122                =  0x00C81400,
      GPIO_122_EMIF1_D23              =  0x00C81401,
      GPIO_122_SPIC_PICO              =  0x00C81406,
      GPIO_122_SD1_D1                 =  0x00C81407,
      GPIO_122_ESC_GPI22              =  0x00C8140A,

      GPIO_123_GPIO123                =  0x00C81600,
      GPIO_123_EMIF1_D22              =  0x00C81601,
      GPIO_123_SPIC_POCI              =  0x00C81606,
      GPIO_123_SD1_C1                 =  0x00C81607,
      GPIO_123_ESC_GPI23              =  0x00C8160A,

      GPIO_124_GPIO124                =  0x00C81800,
      GPIO_124_EMIF1_D21              =  0x00C81801,
      GPIO_124_SPIC_CLK               =  0x00C81806,
      GPIO_124_SD1_D2                 =  0x00C81807,
      GPIO_124_ESC_GPI24              =  0x00C8180A,

      GPIO_125_GPIO125                =  0x00C81A00,
      GPIO_125_EMIF1_D20              =  0x00C81A01,
      GPIO_125_SPIC_PTE               =  0x00C81A06,
      GPIO_125_SD1_C2                 =  0x00C81A07,
      GPIO_125_ESC_GPI25              =  0x00C81A0A,
      GPIO_125_ESC_LATCH0             =  0x00C81A0E,

      GPIO_126_GPIO126                =  0x00C81C00,
      GPIO_126_EMIF1_D19              =  0x00C81C01,
      GPIO_126_SPID_PICO              =  0x00C81C06,
      GPIO_126_SD1_D3                 =  0x00C81C07,
      GPIO_126_ESC_GPI26              =  0x00C81C0A,
      GPIO_126_ESC_LATCH1             =  0x00C81C0E,

      GPIO_127_GPIO127                =  0x00C81E00,
      GPIO_127_EMIF1_D18              =  0x00C81E01,
      GPIO_127_SPID_POCI              =  0x00C81E06,
      GPIO_127_SD1_C3                 =  0x00C81E07,
      GPIO_127_ESC_GPI27              =  0x00C81E0A,
      GPIO_127_ESC_SYNC0              =  0x00C81E0E,

      GPIO_128_GPIO128                =  0x01060000,
      GPIO_128_EMIF1_D17              =  0x01060001,
      GPIO_128_SPID_CLK               =  0x01060006,
      GPIO_128_SD1_D4                 =  0x01060007,
      GPIO_128_ESC_GPI28              =  0x0106000A,
      GPIO_128_ESC_SYNC1              =  0x0106000E,

      GPIO_129_GPIO129                =  0x01060200,
      GPIO_129_EMIF1_D16              =  0x01060201,
      GPIO_129_SPID_PTE               =  0x01060206,
      GPIO_129_SD1_C4                 =  0x01060207,
      GPIO_129_ESC_GPI29              =  0x0106020A,
      GPIO_129_ESC_TX1_ENA            =  0x0106020E,

      GPIO_130_GPIO130                =  0x01060400,
      GPIO_130_EPWM13_A               =  0x01060401,
      GPIO_130_SD2_D1                 =  0x01060407,
      GPIO_130_ESC_GPI30              =  0x0106040A,
      GPIO_130_ESC_TX1_CLK            =  0x0106040E,

      GPIO_131_GPIO131                =  0x01060600,
      GPIO_131_EPWM13_B               =  0x01060601,
      GPIO_131_SD2_C1                 =  0x01060607,
      GPIO_131_ESC_GPI31              =  0x0106060A,
      GPIO_131_ESC_TX1_DATA0          =  0x0106060E,

      GPIO_132_GPIO132                =  0x01060800,
      GPIO_132_EPWM14_A               =  0x01060801,
      GPIO_132_SD2_D2                 =  0x01060807,
      GPIO_132_ESC_GPO0               =  0x0106080A,
      GPIO_132_ESC_TX1_DATA1          =  0x0106080E,

      GPIO_133_GPIO133                =  0x01060A00,
      GPIO_133_EMIF1_A11              =  0x01060A01,
      GPIO_133_EPWM9_A                =  0x01060A02,
      GPIO_133_SD2_C2                 =  0x01060A07,
      GPIO_133_ESC_LED_STATE_RUN      =  0x01060A0B,

      GPIO_134_GPIO134                =  0x01060C00,
      GPIO_134_EPWM14_B               =  0x01060C01,
      GPIO_134_SD2_D3                 =  0x01060C07,
      GPIO_134_ESC_GPO1               =  0x01060C0A,
      GPIO_134_SD2_C1                 =  0x01060C0D,
      GPIO_134_ESC_TX1_DATA2          =  0x01060C0E,

      GPIO_135_GPIO135                =  0x01060E00,
      GPIO_135_SCIA_TX                =  0x01060E06,
      GPIO_135_SD2_C3                 =  0x01060E07,
      GPIO_135_ESC_GPO2               =  0x01060E0A,
      GPIO_135_SD2_C1                 =  0x01060E0B,
      GPIO_135_ESC_TX1_DATA3          =  0x01060E0E,

      GPIO_136_GPIO136                =  0x01061000,
      GPIO_136_SCIA_RX                =  0x01061006,
      GPIO_136_SD2_D4                 =  0x01061007,
      GPIO_136_ESC_GPO3               =  0x0106100A,
      GPIO_136_ESC_RX1_DV             =  0x0106100E,

      GPIO_137_GPIO137                =  0x01061200,
      GPIO_137_SCIB_TX                =  0x01061206,
      GPIO_137_SD2_C4                 =  0x01061207,
      GPIO_137_ESC_GPO4               =  0x0106120A,
      GPIO_137_ESC_RX1_CLK            =  0x0106120E,

      GPIO_138_GPIO138                =  0x01061400,
      GPIO_138_SCIB_RX                =  0x01061406,
      GPIO_138_ESC_GPO5               =  0x0106140A,
      GPIO_138_ESC_RX1_ERR            =  0x0106140E,

      GPIO_139_GPIO139                =  0x01061600,
      GPIO_139_SCIA_TX                =  0x01061606,
      GPIO_139_ESC_GPO6               =  0x0106160A,
      GPIO_139_ESC_RX1_DATA0          =  0x0106160E,

      GPIO_140_GPIO140                =  0x01061800,
      GPIO_140_SCIA_RX                =  0x01061806,
      GPIO_140_ESC_GPO7               =  0x0106180A,
      GPIO_140_ESC_RX1_DATA1          =  0x0106180E,

      GPIO_141_GPIO141                =  0x01061A00,
      GPIO_141_EPWM15_A               =  0x01061A01,
      GPIO_141_SCIB_TX                =  0x01061A06,
      GPIO_141_ESC_GPO8               =  0x01061A0A,
      GPIO_141_ESC_RX1_DATA2          =  0x01061A0E,

      GPIO_142_GPIO142                =  0x01061C00,
      GPIO_142_EPWM15_B               =  0x01061C01,
      GPIO_142_SCIB_RX                =  0x01061C06,
      GPIO_142_ESC_GPO9               =  0x01061C0A,
      GPIO_142_ESC_RX1_DATA3          =  0x01061C0E,

      GPIO_143_GPIO143                =  0x01061E00,
      GPIO_143_ESC_GPO10              =  0x01061E0A,
      GPIO_143_ESC_LED_LINK0_ACTIVE   =  0x01061E0E,

      GPIO_144_GPIO144                =  0x01080000,
      GPIO_144_ESC_GPO11              =  0x0108000A,
      GPIO_144_ESC_LED_LINK1_ACTIVE   =  0x0108000E,

      GPIO_145_GPIO145                =  0x01080200,
      GPIO_145_EPWM1_A                =  0x01080201,
      GPIO_145_MCANB_TX               =  0x01080206,
      GPIO_145_ESC_GPO12              =  0x0108020A,
      GPIO_145_ESC_LED_ERR            =  0x0108020E,

      GPIO_146_GPIO146                =  0x01080400,
      GPIO_146_EPWM1_B                =  0x01080401,
      GPIO_146_MCANB_RX               =  0x01080406,
      GPIO_146_ESC_GPO13              =  0x0108040A,
      GPIO_146_ESC_LED_RUN            =  0x0108040E,

      GPIO_147_GPIO147                =  0x01080600,
      GPIO_147_EPWM2_A                =  0x01080601,
      GPIO_147_EQEP5_A                =  0x01080606,
      GPIO_147_ESC_GPO14              =  0x0108060A,
      GPIO_147_ESC_LED_STATE_RUN      =  0x0108060E,

      GPIO_148_GPIO148                =  0x01080800,
      GPIO_148_EPWM2_B                =  0x01080801,
      GPIO_148_EQEP5_B                =  0x01080806,
      GPIO_148_ESC_GPO15              =  0x0108080A,
      GPIO_148_ESC_PHY0_LINKSTATUS    =  0x0108080E,

      GPIO_149_GPIO149                =  0x01080A00,
      GPIO_149_EPWM3_A                =  0x01080A01,
      GPIO_149_EQEP5_STROBE           =  0x01080A06,
      GPIO_149_ESC_GPO16              =  0x01080A0A,
      GPIO_149_ESC_PHY1_LINKSTATUS    =  0x01080A0E,

      GPIO_150_GPIO150                =  0x01080C00,
      GPIO_150_EPWM3_B                =  0x01080C01,
      GPIO_150_EQEP5_INDEX            =  0x01080C06,
      GPIO_150_ESC_GPO17              =  0x01080C0A,
      GPIO_150_ESC_I2C_SDA            =  0x01080C0E,

      GPIO_151_GPIO151                =  0x01080E00,
      GPIO_151_EPWM4_A                =  0x01080E01,
      GPIO_151_PMBUSA_SCL             =  0x01080E06,
      GPIO_151_ESC_GPO18              =  0x01080E0A,
      GPIO_151_FSITXA_D0              =  0x01080E0D,
      GPIO_151_ESC_I2C_SCL            =  0x01080E0E,

      GPIO_152_GPIO152                =  0x01081000,
      GPIO_152_EPWM4_B                =  0x01081001,
      GPIO_152_PMBUSA_SDA             =  0x01081006,
      GPIO_152_ESC_GPO19              =  0x0108100A,
      GPIO_152_FSITXA_D1              =  0x0108100D,
      GPIO_152_ESC_MDIO_CLK           =  0x0108100E,

      GPIO_153_GPIO153                =  0x01081200,
      GPIO_153_EPWM5_A                =  0x01081201,
      GPIO_153_PMBUSA_ALERT           =  0x01081206,
      GPIO_153_ESC_GPO20              =  0x0108120A,
      GPIO_153_FSITXA_CLK             =  0x0108120D,
      GPIO_153_ESC_MDIO_DATA          =  0x0108120E,

      GPIO_154_GPIO154                =  0x01081400,
      GPIO_154_EPWM5_B                =  0x01081401,
      GPIO_154_PMBUSA_CTL             =  0x01081406,
      GPIO_154_ESC_GPO21              =  0x0108140A,
      GPIO_154_FSIRXA_D0              =  0x0108140D,
      GPIO_154_ESC_PHY_CLK            =  0x0108140E,

      GPIO_155_GPIO155                =  0x01081600,
      GPIO_155_EPWM6_A                =  0x01081601,
      GPIO_155_ESC_GPO22              =  0x0108160A,
      GPIO_155_FSIRXA_D1              =  0x0108160D,
      GPIO_155_ESC_PHY_RESETN         =  0x0108160E,

      GPIO_156_GPIO156                =  0x01081800,
      GPIO_156_EPWM6_B                =  0x01081801,
      GPIO_156_ESC_GPO23              =  0x0108180A,
      GPIO_156_FSIRXA_CLK             =  0x0108180D,
      GPIO_156_ESC_TX0_ENA            =  0x0108180E,

      GPIO_157_GPIO157                =  0x01081A00,
      GPIO_157_EPWM7_A                =  0x01081A01,
      GPIO_157_ESC_GPO24              =  0x01081A0A,
      GPIO_157_FSITXB_D0              =  0x01081A0D,
      GPIO_157_ESC_TX0_CLK            =  0x01081A0E,

      GPIO_158_GPIO158                =  0x01081C00,
      GPIO_158_EPWM7_B                =  0x01081C01,
      GPIO_158_ESC_GPO25              =  0x01081C0A,
      GPIO_158_FSITXB_D1              =  0x01081C0D,
      GPIO_158_ESC_TX0_DATA0          =  0x01081C0E,

      GPIO_159_GPIO159                =  0x01081E00,
      GPIO_159_EPWM8_A                =  0x01081E01,
      GPIO_159_ESC_GPO26              =  0x01081E0A,
      GPIO_159_FSITXB_CLK             =  0x01081E0D,
      GPIO_159_ESC_TX0_DATA1          =  0x01081E0E,

      GPIO_160_GPIO160                =  0x01460000,
      GPIO_160_EPWM8_B                =  0x01460001,
      GPIO_160_ESC_GPO27              =  0x0146000A,
      GPIO_160_FSIRXB_D0              =  0x0146000D,
      GPIO_160_ESC_TX0_DATA2          =  0x0146000E,

      GPIO_161_GPIO161                =  0x01460200,
      GPIO_161_EPWM9_A                =  0x01460201,
      GPIO_161_ESC_GPO28              =  0x0146020A,
      GPIO_161_FSIRXB_D1              =  0x0146020D,
      GPIO_161_ESC_TX0_DATA3          =  0x0146020E,

      GPIO_162_GPIO162                =  0x01460400,
      GPIO_162_EPWM9_B                =  0x01460401,
      GPIO_162_ESC_GPO29              =  0x0146040A,
      GPIO_162_FSIRXB_CLK             =  0x0146040D,
      GPIO_162_ESC_RX0_DV             =  0x0146040E,

      GPIO_163_GPIO163                =  0x01460600,
      GPIO_163_EPWM10_A               =  0x01460601,
      GPIO_163_ESC_GPO30              =  0x0146060A,
      GPIO_163_FSIRXC_D0              =  0x0146060D,
      GPIO_163_ESC_RX0_CLK            =  0x0146060E,

      GPIO_164_GPIO164                =  0x01460800,
      GPIO_164_EPWM10_B               =  0x01460801,
      GPIO_164_ESC_GPO31              =  0x0146080A,
      GPIO_164_FSIRXC_D1              =  0x0146080D,
      GPIO_164_ESC_RX0_ERR            =  0x0146080E,

      GPIO_165_GPIO165                =  0x01460A00,
      GPIO_165_EPWM11_A               =  0x01460A01,
      GPIO_165_FSIRXC_CLK             =  0x01460A0D,
      GPIO_165_ESC_RX0_DATA0          =  0x01460A0E,

      GPIO_166_GPIO166                =  0x01460C00,
      GPIO_166_EPWM11_B               =  0x01460C01,
      GPIO_166_FSIRXD_D0              =  0x01460C0D,
      GPIO_166_ESC_RX0_DATA1          =  0x01460C0E,

      GPIO_167_GPIO167                =  0x01460E00,
      GPIO_167_EPWM12_A               =  0x01460E01,
      GPIO_167_FSIRXD_D1              =  0x01460E0D,
      GPIO_167_ESC_RX0_DATA2          =  0x01460E0E,

      GPIO_168_GPIO168                =  0x01461000,
      GPIO_168_EPWM12_B               =  0x01461001,
      GPIO_168_FSIRXD_CLK             =  0x0146100D,
      GPIO_168_ESC_RX0_DATA3          =  0x0146100E,

      GPIO_169_GPIO169                =  0x01461200,

      GPIO_170_GPIO170                =  0x01461400,

      GPIO_171_GPIO171                =  0x01461600,

      GPIO_172_GPIO172                =  0x01461800,

      GPIO_173_GPIO173                =  0x01461A00,

      GPIO_174_GPIO174                =  0x01461C00,

      GPIO_175_GPIO175                =  0x01461E00,

      GPIO_176_GPIO176                =  0x01480000,

      GPIO_177_GPIO177                =  0x01480200,

      GPIO_178_GPIO178                =  0x01480400,

      GPIO_179_GPIO179                =  0x01480600,

      GPIO_180_GPIO180                =  0x01480800,

      GPIO_181_GPIO181                =  0x01480A00,

      GPIO_182_GPIO182                =  0x01480C00,

      GPIO_183_GPIO183                =  0x01480E00,

      GPIO_184_GPIO184                =  0x01481000,

      GPIO_185_GPIO185                =  0x01481200,

      GPIO_186_GPIO186                =  0x01481400,

      GPIO_187_GPIO187                =  0x01481600,

      GPIO_188_GPIO188                =  0x01481800,

      GPIO_189_GPIO189                =  0x01481A00,

      GPIO_190_GPIO190                =  0x01481C00,

      GPIO_191_GPIO191                =  0x01481E00,

      GPIO_192_GPIO192                =  0x01860000,

      GPIO_193_GPIO193                =  0x01860200,

      GPIO_194_GPIO194                =  0x01860400,

      GPIO_195_GPIO195                =  0x01860600,

      GPIO_196_GPIO196                =  0x01860800,

      GPIO_197_GPIO197                =  0x01860A00,

      GPIO_198_GPIO198                =  0x01860C00,
      GPIO_198_EQEP1_A                =  0x01860C01,
      GPIO_198_EPWM9_B                =  0x01860C02,
      GPIO_198_SPIA_PICO              =  0x01860C03,
      GPIO_198_ESC_PDI_UC_IRQ         =  0x01860C0E,

      GPIO_199_GPIO199                =  0x01860E00,
      GPIO_199_EQEP1_STROBE           =  0x01860E01,
      GPIO_199_EPWM17_A               =  0x01860E02,
      GPIO_199_SCIB_TX                =  0x01860E03,
      GPIO_199_EPWM12_A               =  0x01860E05,
      GPIO_199_SPIB_CLK               =  0x01860E06,
      GPIO_199_SD1_D4                 =  0x01860E07,
      GPIO_199_MCANA_TX               =  0x01860E09,
      GPIO_199_EMIF1_RAS              =  0x01860E0A,
      GPIO_199_SPIC_CLK               =  0x01860E0E,

      GPIO_200_GPIO200                =  0x01861000,
      GPIO_200_EQEP1_INDEX            =  0x01861001,
      GPIO_200_EPWM17_B               =  0x01861002,
      GPIO_200_SCIB_RX                =  0x01861003,
      GPIO_200_EPWM12_B               =  0x01861005,
      GPIO_200_SPIB_PTE               =  0x01861006,
      GPIO_200_SD1_C4                 =  0x01861007,
      GPIO_200_MCANA_RX               =  0x01861009,
      GPIO_200_EMIF1_CAS              =  0x0186100A,
      GPIO_200_ESC_TX1_DATA1          =  0x0186100B,
      GPIO_200_SPIC_PTE               =  0x0186100E,

      GPIO_201_GPIO201                =  0x01861200,
      GPIO_201_OUTPUTXBAR1            =  0x01861201,
      GPIO_201_EQEP2_A                =  0x01861202,
      GPIO_201_EPWM18_A               =  0x01861203,
      GPIO_201_LINB_TX                =  0x01861205,
      GPIO_201_SPIB_PICO              =  0x01861206,
      GPIO_201_SD2_D1                 =  0x01861207,
      GPIO_201_PMBUSA_SCL             =  0x01861209,
      GPIO_201_EMIF1_DQM0             =  0x0186120A,
      GPIO_201_ESC_TX1_DATA2          =  0x0186120B,
      GPIO_201_EPWM13_A               =  0x0186120D,

      GPIO_202_GPIO202                =  0x01861400,
      GPIO_202_OUTPUTXBAR2            =  0x01861401,
      GPIO_202_EQEP2_B                =  0x01861402,
      GPIO_202_EPWM18_B               =  0x01861403,
      GPIO_202_LINB_RX                =  0x01861405,
      GPIO_202_SPIB_POCI              =  0x01861406,
      GPIO_202_SD2_C1                 =  0x01861407,
      GPIO_202_PMBUSA_SDA             =  0x01861409,
      GPIO_202_EMIF1_DQM1             =  0x0186140A,
      GPIO_202_ESC_TX1_DATA3          =  0x0186140B,
      GPIO_202_EPWM13_B               =  0x0186140D,
      GPIO_202_FSITXA_D1              =  0x0186140E,

      GPIO_203_GPIO203                =  0x01861600,
      GPIO_203_OUTPUTXBAR3            =  0x01861601,
      GPIO_203_EQEP2_INDEX            =  0x01861602,
      GPIO_203_SPIA_POCI              =  0x01861603,
      GPIO_203_SPIB_CLK               =  0x01861606,
      GPIO_203_SD3_D1                 =  0x01861607,
      GPIO_203_PMBUSA_ALERT           =  0x01861609,
      GPIO_203_EMIF1_DQM2             =  0x0186160A,
      GPIO_203_ESC_MDIO_CLK           =  0x0186160B,
      GPIO_203_EPWM14_A               =  0x0186160D,
      GPIO_203_FSITXA_D0              =  0x0186160E,
      GPIO_203_EPWM8_B                =  0x0186160F,

      GPIO_204_GPIO204                =  0x01861800,
      GPIO_204_OUTPUTXBAR4            =  0x01861801,
      GPIO_204_EQEP2_STROBE           =  0x01861802,
      GPIO_204_SPIA_CLK               =  0x01861803,
      GPIO_204_SPIB_PTE               =  0x01861806,
      GPIO_204_SD2_C2                 =  0x01861807,
      GPIO_204_PMBUSA_CTL             =  0x01861809,
      GPIO_204_EMIF1_DQM3             =  0x0186180A,
      GPIO_204_ESC_MDIO_DATA          =  0x0186180B,
      GPIO_204_EPWM14_B               =  0x0186180D,
      GPIO_204_FSITXA_CLK             =  0x0186180E,
      GPIO_204_SD1_D3                 =  0x0186180F,

      GPIO_205_GPIO205                =  0x01861A00,
      GPIO_205_EQEP1_INDEX            =  0x01861A01,
      GPIO_205_EPWM10_A               =  0x01861A02,
      GPIO_205_SPIA_PTE               =  0x01861A03,
      GPIO_205_OUTPUTXBAR1            =  0x01861A0B,
      GPIO_205_SD1_C3                 =  0x01861A0F,

      GPIO_206_GPIO206                =  0x01861C00,
      GPIO_206_EMIF1_A11              =  0x01861C01,
      GPIO_206_EPWM10_B               =  0x01861C02,
      GPIO_206_EMIF1_WEN              =  0x01861C03,
      GPIO_206_OUTPUTXBAR2            =  0x01861C0B,
      GPIO_206_ESC_PHY_CLK            =  0x01861C0E,
      GPIO_206_ESC_LED_STATE_RUN      =  0x01861C0F,

      GPIO_207_GPIO207                =  0x01861E00,
      GPIO_207_EQEP2_A                =  0x01861E01,
      GPIO_207_EPWM11_A               =  0x01861E02,
      GPIO_207_EXTSYNCOUT             =  0x01861E03,
      GPIO_207_CANA_TX                =  0x01861E05,
      GPIO_207_SD4_D1                 =  0x01861E06,
      GPIO_207_SCIA_RX                =  0x01861E07,
      GPIO_207_LINA_RX                =  0x01861E09,
      GPIO_207_I2CB_SCL               =  0x01861E0A,
      GPIO_207_OUTPUTXBAR3            =  0x01861E0B,
      GPIO_207_ESC_RX1_CLK            =  0x01861E0E,
      GPIO_207_PMBUSA_ALERT           =  0x01861E0F,

      GPIO_208_GPIO208                =  0x01880000,
      GPIO_208_EQEP2_B                =  0x01880001,
      GPIO_208_EPWM11_B               =  0x01880002,
      GPIO_208_EMIF1_D13              =  0x01880003,
      GPIO_208_SPIB_PICO              =  0x01880005,
      GPIO_208_SD4_C1                 =  0x01880006,
      GPIO_208_SCIA_TX                =  0x01880007,
      GPIO_208_OUTPUTXBAR4            =  0x0188000B,
      GPIO_208_ESC_RX1_DV             =  0x0188000E,
      GPIO_208_PMBUSA_CTL             =  0x0188000F,

      GPIO_209_GPIO209                =  0x01880200,
      GPIO_209_EQEP2_STROBE           =  0x01880201,
      GPIO_209_EPWM12_A               =  0x01880202,
      GPIO_209_EMIF1_D14              =  0x01880203,
      GPIO_209_SPIB_POCI              =  0x01880205,
      GPIO_209_SD4_D2                 =  0x01880206,
      GPIO_209_EPWM12_B               =  0x01880207,
      GPIO_209_LINB_RX                =  0x0188020A,
      GPIO_209_OUTPUTXBAR5            =  0x0188020B,
      GPIO_209_ESC_RX1_ERR            =  0x0188020E,
      GPIO_209_PMBUSA_SDA             =  0x0188020F,

      GPIO_210_GPIO210                =  0x01880400,
      GPIO_210_EQEP2_INDEX            =  0x01880401,
      GPIO_210_EPWM12_B               =  0x01880402,
      GPIO_210_EMIF1_D15              =  0x01880403,
      GPIO_210_SD4_C2                 =  0x01880406,
      GPIO_210_LINB_TX                =  0x0188040A,
      GPIO_210_OUTPUTXBAR6            =  0x0188040B,
      GPIO_210_ESC_RX0_DATA2          =  0x0188040E,
      GPIO_210_PMBUSA_SCL             =  0x0188040F,

      GPIO_211_GPIO211                =  0x01880600,
      GPIO_211_EQEP6_A                =  0x01880601,
      GPIO_211_EPWM14_A               =  0x01880602,
      GPIO_211_SD4_D3                 =  0x01880606,
      GPIO_211_OUTPUTXBAR7            =  0x0188060B,
      GPIO_211_ESC_LED_LINK0_ACTIVE   =  0x0188060E,

      GPIO_212_GPIO212                =  0x01880800,
      GPIO_212_EQEP6_B                =  0x01880801,
      GPIO_212_EPWM14_B               =  0x01880802,
      GPIO_212_SD4_C3                 =  0x01880806,
      GPIO_212_ESC_LED_LINK1_ACTIVE   =  0x0188080E,

      GPIO_213_GPIO213                =  0x01880A00,
      GPIO_213_EQEP6_STROBE           =  0x01880A01,
      GPIO_213_EPWM8_A                =  0x01880A02,
      GPIO_213_SD4_D4                 =  0x01880A06,
      GPIO_213_LINB_TX                =  0x01880A0A,
      GPIO_213_ESC_LED_ERR            =  0x01880A0E,

      GPIO_214_GPIO214                =  0x01880C00,
      GPIO_214_CANA_RX                =  0x01880C01,
      GPIO_214_EMIF1_CLK              =  0x01880C02,
      GPIO_214_MCANA_RX               =  0x01880C03,
      GPIO_214_OUTPUTXBAR7            =  0x01880C05,
      GPIO_214_EQEP3_STROBE           =  0x01880C06,
      GPIO_214_SD2_D4                 =  0x01880C07,
      GPIO_214_EMIF1_CS4N             =  0x01880C09,
      GPIO_214_ESC_LATCH1             =  0x01880C0A,
      GPIO_214_ESC_I2C_SCL            =  0x01880C0B,
      GPIO_214_EPWM16_A               =  0x01880C0D,
      GPIO_214_ESC_SYNC1              =  0x01880C0E,
      GPIO_214_SPID_PICO              =  0x01880C0F,

      GPIO_215_GPIO215                =  0x01880E00,
      GPIO_215_SCIA_RX                =  0x01880E01,
      GPIO_215_EMIF1_CS4N             =  0x01880E02,
      GPIO_215_CANA_RX                =  0x01880E03,
      GPIO_215_OUTPUTXBAR5            =  0x01880E05,
      GPIO_215_EQEP3_A                =  0x01880E06,
      GPIO_215_SD2_D3                 =  0x01880E07,
      GPIO_215_EMIF1_CS2N             =  0x01880E09,
      GPIO_215_I2CB_SDA               =  0x01880E0A,
      GPIO_215_SPIC_POCI              =  0x01880E0B,
      GPIO_215_EPWM15_A               =  0x01880E0D,
      GPIO_215_LINA_TX                =  0x01880E0E,
      GPIO_215_EMIF1_D12              =  0x01880E0F,

      GPIO_216_GPIO216                =  0x01881000,
      GPIO_216_SCIA_TX                =  0x01881001,
      GPIO_216_EMIF1_SDCKE            =  0x01881002,
      GPIO_216_SPID_CLK               =  0x01881003,
      GPIO_216_OUTPUTXBAR6            =  0x01881005,
      GPIO_216_EQEP3_B                =  0x01881006,
      GPIO_216_SD2_C3                 =  0x01881007,
      GPIO_216_EMIF1_CS3N             =  0x01881009,
      GPIO_216_ESC_LATCH0             =  0x0188100A,
      GPIO_216_ESC_I2C_SDA            =  0x0188100B,
      GPIO_216_EPWM15_B               =  0x0188100D,
      GPIO_216_ESC_SYNC0              =  0x0188100E,
      GPIO_216_EMIF1_D13              =  0x0188100F,

      GPIO_217_GPIO217                =  0x01881200,
      GPIO_217_CANA_TX                =  0x01881201,
      GPIO_217_EMIF1_WEN              =  0x01881202,
      GPIO_217_MCANA_TX               =  0x01881203,
      GPIO_217_OUTPUTXBAR8            =  0x01881205,
      GPIO_217_EQEP3_INDEX            =  0x01881206,
      GPIO_217_SD2_C4                 =  0x01881207,
      GPIO_217_EMIF1_RNW              =  0x01881209,
      GPIO_217_I2CA_SDA               =  0x0188120A,
      GPIO_217_SPID_PTE               =  0x0188120B,
      GPIO_217_EPWM16_B               =  0x0188120D,
      GPIO_217_LINB_TX                =  0x0188120E,
      GPIO_217_SPID_POCI              =  0x0188120F,

      GPIO_218_GPIO218                =  0x01881400,
      GPIO_218_I2CA_SDA               =  0x01881401,
      GPIO_218_EMIF1_CS0N             =  0x01881402,
      GPIO_218_SPIA_PICO              =  0x01881403,
      GPIO_218_EQEP4_A                =  0x01881405,
      GPIO_218_LINB_TX                =  0x01881406,
      GPIO_218_CLB_OUTPUTXBAR1        =  0x01881407,
      GPIO_218_EMIF1_OEN              =  0x01881409,
      GPIO_218_I2CA_SCL               =  0x0188140A,
      GPIO_218_SPID_CLK               =  0x0188140F,

      GPIO_219_GPIO219                =  0x01881600,
      GPIO_219_EQEP6_INDEX            =  0x01881601,
      GPIO_219_EPWM8_B                =  0x01881602,
      GPIO_219_SD4_C4                 =  0x01881606,
      GPIO_219_ESC_LED_RUN            =  0x0188160E,

      GPIO_220_GPIO220                =  0x01881800,
      GPIO_220_EPWM6_A                =  0x01881802,
      GPIO_220_SPID_POCI              =  0x01881803,
      GPIO_220_OUTPUTXBAR2            =  0x01881805,
      GPIO_220_SCIB_TX                =  0x01881806,
      GPIO_220_MCANA_TX               =  0x01881807,
      GPIO_220_PMBUSA_ALERT           =  0x0188180F,

      GPIO_221_GPIO221                =  0x01881A00,
      GPIO_221_EPWM6_B                =  0x01881A02,
      GPIO_221_SPID_PTE               =  0x01881A03,
      GPIO_221_OUTPUTXBAR3            =  0x01881A05,
      GPIO_221_SCIB_RX                =  0x01881A06,
      GPIO_221_MCANA_RX               =  0x01881A07,
      GPIO_221_PMBUSA_CTL             =  0x01881A0F,

      GPIO_222_GPIO222                =  0x01881C00,
      GPIO_222_TDI                    =  0x01881C01,
      GPIO_222_EPWM7_A                =  0x01881C02,
      GPIO_222_SPIA_PICO              =  0x01881C03,
      GPIO_222_OUTPUTXBAR4            =  0x01881C05,
      GPIO_222_SCIA_RX                =  0x01881C06,
      GPIO_222_UARTB_TX               =  0x01881C07,
      GPIO_222_I2CA_SDA               =  0x01881C09,
      GPIO_222_SPIC_CLK               =  0x01881C0A,
      GPIO_222_ESC_PDI_UC_IRQ         =  0x01881C0E,
      GPIO_222_PMBUSA_SDA             =  0x01881C0F,

      GPIO_223_GPIO223                =  0x01881E00,
      GPIO_223_TDO                    =  0x01881E01,
      GPIO_223_EPWM7_B                =  0x01881E02,
      GPIO_223_EMIF1_A11              =  0x01881E03,
      GPIO_223_OUTPUTXBAR5            =  0x01881E05,
      GPIO_223_SCIA_TX                =  0x01881E06,
      GPIO_223_UARTB_RX               =  0x01881E07,
      GPIO_223_I2CA_SCL               =  0x01881E09,
      GPIO_223_SPIC_PTE               =  0x01881E0A,
      GPIO_223_PMBUSA_SCL             =  0x01881E0F,

      GPIO_224_GPIO224                =  0x01C60000,
      GPIO_224_ERRORSTS               =  0x01C60001,
      GPIO_224_EMIF1_SDCKE            =  0x01C60002,
      GPIO_224_XCLKOUT                =  0x01C60003,
      GPIO_224_OUTPUTXBAR1            =  0x01C60005,
      GPIO_224_SD2_C1                 =  0x01C6000D,
      GPIO_224_ESC_PDI_UC_IRQ         =  0x01C6000E,

      GPIO_225_GPIO225                =  0x01C60200,

      GPIO_226_GPIO226                =  0x01C60400,

      GPIO_227_GPIO227                =  0x01C60600,

      GPIO_228_GPIO228                =  0x01C60800,

      GPIO_229_GPIO229                =  0x01C60A00,

      GPIO_230_GPIO230                =  0x01C60C00,

      GPIO_231_GPIO231                =  0x01C60E00,

      GPIO_232_GPIO232                =  0x01C61000,

      GPIO_233_GPIO233                =  0x01C61200,

      GPIO_234_GPIO234                =  0x01C61400,

      GPIO_235_GPIO235                =  0x01C61600,

      GPIO_236_GPIO236                =  0x01C61800,

      GPIO_237_GPIO237                =  0x01C61A00,

      GPIO_238_GPIO238                =  0x01C61C00,

      GPIO_239_GPIO239                =  0x01C61E00,

      GPIO_240_GPIO240                =  0x01C80000,

      GPIO_241_GPIO241                =  0x01C80200,

      GPIO_242_GPIO242                =  0x01C80400,
    }
    return pin_map[pin]
end

return P
