/*
   Copyright (c) 2021 by Plexim GmbH
   All rights reserved.

   A free license is granted to anyone to use this software for any legal
   non safety-critical purpose, including commercial applications, provided
   that:
   1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
   2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
   SOFTWARE.
 */

MEMORY
{
   BEGIN            : origin = 0x000000, length = 0x000002
   BOOT_RSVD        : origin = 0x000002, length = 0x0001AF     /* Part of M0, BOOT rom will use this for stack */
   RAMM0            : origin = 0x0001B2, length = 0x00024E     // start on even boundary
   RAMM1            : origin = 0x000400, length = 0x000400     /* on-chip RAM block M1 */

   RAMLS	           : origin = 0x008000, length = 0x004F00
//   RAMLS0         : origin = 0x008000, length = 0x000800
//   RAMLS1         : origin = 0x008800, length = 0x000800
//   RAMLS2         : origin = 0x009000, length = 0x000800
//   RAMLS3         : origin = 0x009800, length = 0x000800
//   RAMLS4         : origin = 0x00A000, length = 0x000800
//   RAMLS5         : origin = 0x00A800, length = 0x000800
//   RAMLS6         : origin = 0x00B000, length = 0x000800
//   RAMLS7         : origin = 0x00B800, length = 0x000800
//   RAMD0          : origin = 0x00C000, length = 0x000800
//   RAMD1          : origin = 0x00C800, length = 0x000800
   RAMD1_RSVD       : origin = 0x00CF00, length = 0x000100  // JTAG communication buffer

  //RAMGS RAM used for Program for "ram_lnk"
   // PRAMGS0 is assigned to CPU2
   PRAMGS           : origin = 0x00E000, length = 0x000F000


   CMTOCPURAM       : origin = 0x038000, length = 0x000800
   CPUTOCMRAM       : origin = 0x039000, length = 0x000800

   CPU1TOCPU2RAM    : origin = 0x03A000, length = 0x00077F
   SCOPE_FLAG_CPU1  : origin = 0x03A77F, length = 0x000001
   CPU1TOCPU2LINK   : origin = 0x03A780, length = 0x000080

   CPU2TOCPU1RAM    : origin = 0x03B000, length = 0x00077F
   SCOPE_FLAG_CPU2  : origin = 0x03B77F, length = 0x000001
   CPU2TOCPU1LINK   : origin = 0x03B780, length = 0x000080

   CANA_MSG_RAM     : origin = 0x049000, length = 0x000800
   CANB_MSG_RAM     : origin = 0x04B000, length = 0x000800


   RESET            : origin = 0x3FFFC0, length = 0x000002
}

SECTIONS
{
   scope            : > RAMLS, ALIGN(2)
   scopeflag_local	: > SCOPE_FLAG_CPU1
   scopeflag_remote	: > SCOPE_FLAG_CPU2

   cpu1to2_link_mem : > CPU1TOCPU2LINK
   cpu2to1_link_mem : > CPU2TOCPU1LINK
   step             : > PRAMGS
   dispatch         : > PRAMGS

   codestart        : > BEGIN
   .cinit           : > PRAMGS
   .text            : > PRAMGS
   .switch          : > PRAMGS

   .stack           : > RAMM1 | RAMLS

#if defined(__TI_EABI__)
   .init_array      : > PRAMGS
   .const           : > PRAMGS
   .bss             : > RAMLS
   .bss:output      : > RAMLS
   .bss:cio         : > RAMLS
   .data            : > RAMLS
   .sysmem          : > RAMLS
#else
   .pinit           : > PRAMGS
   .econst          : > PRAMGS
   .cio         	  : > PRAMGS
   .ebss            : > RAMLS
   .esysmem         : > RAMLS
#endif

   GROUP: > PRAMGS
   {
      ramfuncs
      .TI.ramfunc
   }

   .reset              : > RESET, TYPE = DSECT

   MSGRAM_CPU1_TO_CPU2 : > CPU1TOCPU2RAM, type=NOINIT
   MSGRAM_CPU2_TO_CPU1 : > CPU2TOCPU1RAM, type=NOINIT
   MSGRAM_CPU_TO_CM    : > CPUTOCMRAM, type=NOINIT
   MSGRAM_CM_TO_CPU    : > CMTOCPURAM, type=NOINIT
}
