#ifndef PLX_AIN_IMPL_H_
#define PLX_AIN_IMPL_H_

#include "f28p55x_adc.h"
#include "f28p55x_adc_defines.h"

#define PLX_AIN_NUM_CHANNELS 16

typedef enum PLX_AIN_UNIT {
  PLX_AIN_ADC_A = 0,
  PLX_AIN_ADC_B,
  PLX_AIN_ADC_C,
  PLX_AIN_ADC_D,
  PLX_AIN_ADC_E,
} PLX_AIN_Unit_t;

#include "ain_type5.h"

inline void PLX_AIN_setDefaultAdcParams(PLX_AIN_AdcParams_t *aParams, float aVref, bool sigmodeDifferential)
{
    aParams->ADCCTL1.bit.INTPULSEPOS = 1; // set pulse positions to late
    // max allowable ADC clock is 75 MHz (min 5 MHz)
    if(PLX_AIN_SysClkHz <= 75000000L){
        aParams->ADCCTL2.bit.PRESCALE = 0; //set ADCCLK divider to /1.0
    } else {
        aParams->ADCCTL2.bit.PRESCALE = 2; //set ADCCLK divider to /2.0
    }

  aParams->ADCSOCPRICTL.bit.SOCPRIORITY = 0;  // round-robin - no high
                                              // priority channels
  aParams->ADCINTSEL1N2.bit.INT1SEL = 0;

  aParams->vref = aVref;
}

#endif /* PLX_AIN_IMPL_H_ */
