/*
   Copyright (c) 2021-2023 by Plexim GmbH
   All rights reserved.

   A free license is granted to anyone to use this software for any legal
   non safety-critical purpose, including commercial applications, provided
   that:
   1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
   2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
   SOFTWARE.
 */

#ifndef _INCLUDES_H_
#define _INCLUDES_H_

#if !defined(_PLEXIM_) || !defined(__CPU3__)
#error Incorrect project settings!
#endif

#define TARGET_29h85x

#include <stddef.h>
#include <stdint.h>
#include <stdbool.h>

#include "driverlib.h"
#include "bitfield_structs.h"

#include "plx_hal.h"

// this chip does not have EALLOW protection
#define EALLOW
#define EDIS

#define THIS_TSP_VER 0x0202

#define PLX_ASSERT(x) do {\
   if(!(x)){\
      __asm(" EMUSTOP0");\
      for(;;);\
   }\
} while(0)

// this must mirror the CPU1 setting
#define PARALLEL_COM_BUF_ADDR 0x200E0000
#define PARALLEL_COM_BUF_LEN  0x100

#endif // _INCLUDES_H_