--entry_point="code_start"


/* Specify the system memory map */

MEMORY
{
    SRAM_LDAx : o=0x200E0200, l=0x1E000 // first 0x200 bytes reserved for serial-over-jtag
    SRAM_LPAx : o=0x20100000, l=0x10000
    SRAM_CPAx : o=0x20110000, l=0x10000

    // CDA RAM
    CPU1TOCPU2RAM    : origin = 0x20120000, length = 0x0006FE
    SCOPE_FLAG_CPU1  : origin = 0x201206FE, length = 0x000002
    CPU1TOCPU2LINK   : origin = 0x20120700, length = 0x000100

    CPU2TOCPU1RAM    : origin = 0x20120800, length = 0x0006FE
    SCOPE_FLAG_CPU2  : origin = 0x20120EFE, length = 0x000002
    CPU2TOCPU1LINK   : origin = 0x20120F00, length = 0x000100

    //SRAM_CDAx : o=0x20121000, l=0x2F000

    CERT      : o=0x10000000, l=0x001000
    FLASH_RP0 : o=0x10001000, l=0x0FF000

    CPU3_CERT : o=0x10400000, l=0x1000
    CPU3_FLASH_RP0 : o=0x10401000, l=0xFF000 // full size minus certificate    
}


/* Specify the sections allocation into memory */

SECTIONS
{
    cpu3cert       : {} > CPU3_CERT,       palign(8)
    cpu3app        : {} > CPU3_FLASH_RP0,  palign(8)

    cpu1to2_ram : {CPU1TOCPU2RAM_BASE = .;} > CPU1TOCPU2RAM, TYPE = NOLOAD
    cpu2to1_ram : {CPU2TOCPU1RAM_BASE = .;} > CPU2TOCPU1RAM, TYPE = NOLOAD

    scopeflag_local  : {} > SCOPE_FLAG_CPU1
    scopeflag_remote : {} > SCOPE_FLAG_CPU2

    cpu1to2_link_mem : {} > CPU1TOCPU2LINK, TYPE = NOLOAD
    cpu2to1_link_mem : {} > CPU2TOCPU1LINK, TYPE = NOLOAD

    codestart     : {} > 0x10001000,    palign(8)
    cert          : {} > CERT,          palign(8)

    .text         : {} > FLASH_RP0,     palign(8)
    .binit        : {} > FLASH_RP0,     palign(8)
    .cinit        : {} > FLASH_RP0,     palign(8)
    .const        : {} > FLASH_RP0,     palign(8)
    .rodata       : {} > FLASH_RP0,     palign(8)
    .init_array   : {} > FLASH_RP0,     palign(8)

    .TI.ramfunc   : {} LOAD=FLASH_RP0, RUN=SRAM_LPAx, table(BINIT), palign(8)
    .ramfuncs     : {} LOAD=FLASH_RP0, RUN=SRAM_LPAx, table(BINIT), palign(8)

    .data         : {} > SRAM_LDAx
    .bss          : {} > SRAM_LDAx
    .stack        : {} > SRAM_LDAx
    .sysmem       : {} > SRAM_LDAx
    .cio          : {} > SRAM_LDAx
}