--[[
  Copyright (c) 2021-2025 by Plexim GmbH
  All rights reserved.

  A free license is granted to anyone to use this software for any legal
  non safety-critical purpose, including commercial applications, provided
  that:
  1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
  2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
--]]

local U = require('common.utils')
local CLA = {}

-- Control Law Accelerator, aka CLA
-- this harness allows super users to write handcode for the CLA
function CLA.generateClaCode(filename, recipe)
  local file, e = io.open(filename, 'w')
  if file == nil then
    error(e)
  end
  io.output(file)

  io.write([[
  /*
  * CLA code file
  * Generated with                 : PLECS %(PLECS_VER)s
  * Generated on                   : %(DATE)s
  */
  ]] % {
    PLECS_VER = Target.Variables.PLECS_VERSION,
    DATE = tostring(os.date()),
  })

  io.write('\n')
  io.write(recipe.ClaDeclarations:concat())
  
  io.write('\n')
  io.write(recipe.ClaCode:concat())

  io.close(file)

  Plecs:Beautify(filename)
end

return CLA
