--[[
  Copyright (c) 2021 by Plexim GmbH
  All rights reserved.

  A free license is granted to anyone to use this software for any legal
  non safety-critical purpose, including commercial applications, provided
  that:
  1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
  2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
--]]

local U = require('common.utils')

local static = {}
local Module = {}

function Module.getBlock(globals, cpu)
  local CpuLoad = require('common.block').getBlock(globals, cpu)
  if not static[cpu] then
    static[cpu] = {
      numInstances = 0,
      instances = {},
      finalized = false,
    }
  end
  CpuLoad.instance = static[cpu].numInstances
  static[cpu].numInstances = static[cpu].numInstances + 1

  function CpuLoad:p_getDirectFeedthroughCode()
    local Require = ResourceList:new()

    -- there can only be one cpu load block per CPU
    if self.cpu == 0 then
      Require:add('Base Task Load')
    elseif self.cpu == 1 then
      Require:add('Base Task Load CPU2')
    end

    local OutputSignal1 = StringList:new()
    OutputSignal1:append('PLXHAL_DISPR_getTask0LoadInPercent()')

    local OutputSignal2 = StringList:new()
    OutputSignal2:append('PLXHAL_DISPR_getTimeStamp0()')
    OutputSignal2:append('PLXHAL_DISPR_getTimeStampB()')
    OutputSignal2:append('PLXHAL_DISPR_getTimeStampD()')
    OutputSignal2:append('PLXHAL_DISPR_getTimeStampP()')

    return {
      Require = Require,
      OutputSignal = {OutputSignal1, OutputSignal2},
      UserData = {bid = self:getId()}
    }
  end

  function CpuLoad:p_getNonDirectFeedthroughCode()
    return {}
  end

  function CpuLoad:finalize(f)
    if static[self.cpu].finalized then
      return
    end

    f.Declarations:append([[
      uint32_t PLXHAL_DISPR_getTimeStamp0(){
        return DISPR_getTimeStamp0();
      }

      uint32_t PLXHAL_DISPR_getTimeStamp1(){
        return DISPR_getTimeStamp1();
      }

      uint32_t PLXHAL_DISPR_getTimeStamp2(){
        return DISPR_getTimeStamp2();
      }

      uint32_t PLXHAL_DISPR_getTimeStamp3(){
        return DISPR_getTimeStamp3();
      }

      uint32_t PLXHAL_DISPR_getTimeStampB(){
        return DISPR_getTimeStampB();
      }

      uint32_t PLXHAL_DISPR_getTimeStampD(){
        return DISPR_getTimeStampD();
      }

      uint32_t PLXHAL_DISPR_getTimeStampP(){
        return DISPR_getTimeStampP();
      }

      float PLXHAL_DISPR_getTask0LoadInPercent(){
        return DISPR_getTask0LoadInPercent();
      }
    ]])

    static[self.cpu].finalized = true
  end

  return CpuLoad
end

return Module
