local P = {}

function P.getPinSettings(pin)
	local pin_map = {
      GPIO_0_GPIO0                    = 0x00060000,
      GPIO_0_EPWM1A                   = 0x00060001,
      GPIO_0_I2CA_SDA                 = 0x00060006,
      GPIO_0_CM_I2CA_SDA              = 0x00060009,
      GPIO_0_ESC_GPI0                 = 0x0006000A,
      GPIO_0_FSITXA_D0                = 0x0006000D,

      GPIO_1_GPIO1                    = 0x00060200,
      GPIO_1_EPWM1B                   = 0x00060201,
      GPIO_1_MFSRB                    = 0x00060203,
      GPIO_1_I2CA_SCL                 = 0x00060206,
      GPIO_1_CM_I2CA_SCL              = 0x00060209,
      GPIO_1_ESC_GPI1                 = 0x0006020A,
      GPIO_1_FSITXA_D1                = 0x0006020D,

      GPIO_2_GPIO2                    = 0x00060400,
      GPIO_2_EPWM2A                   = 0x00060401,
      GPIO_2_OUTPUTXBAR1              = 0x00060405,
      GPIO_2_I2CB_SDA                 = 0x00060406,
      GPIO_2_ESC_GPI2                 = 0x0006040A,
      GPIO_2_FSITXA_CLK               = 0x0006040D,

      GPIO_3_GPIO3                    = 0x00060600,
      GPIO_3_EPWM2B                   = 0x00060601,
      GPIO_3_OUTPUTXBAR2              = 0x00060602,
      GPIO_3_MCLKRB                   = 0x00060603,
      GPIO_3_I2CB_SCL                 = 0x00060606,
      GPIO_3_ESC_GPI3                 = 0x0006060A,
      GPIO_3_FSIRXA_D0                = 0x0006060D,

      GPIO_4_GPIO4                    = 0x00060800,
      GPIO_4_EPWM3A                   = 0x00060801,
      GPIO_4_OUTPUTXBAR3              = 0x00060805,
      GPIO_4_CANA_TX                  = 0x00060806,
      GPIO_4_MCAN_TX                  = 0x00060809,
      GPIO_4_ESC_GPI4                 = 0x0006080A,
      GPIO_4_FSIRXA_D1                = 0x0006080D,

      GPIO_5_GPIO5                    = 0x00060A00,
      GPIO_5_EPWM3B                   = 0x00060A01,
      GPIO_5_MFSRA                    = 0x00060A02,
      GPIO_5_OUTPUTXBAR3              = 0x00060A03,
      GPIO_5_CANA_RX                  = 0x00060A06,
      GPIO_5_MCAN_RX                  = 0x00060A09,
      GPIO_5_ESC_GPI5                 = 0x00060A0A,
      GPIO_5_FSIRXA_CLK               = 0x00060A0D,

      GPIO_6_GPIO6                    = 0x00060C00,
      GPIO_6_EPWM4A                   = 0x00060C01,
      GPIO_6_OUTPUTXBAR4              = 0x00060C02,
      GPIO_6_EXTSYNCOUT               = 0x00060C03,
      GPIO_6_EQEP3_A                  = 0x00060C05,
      GPIO_6_CANB_TX                  = 0x00060C06,
      GPIO_6_ESC_GPI6                 = 0x00060C0A,
      GPIO_6_FSITXB_D0                = 0x00060C0D,

      GPIO_7_GPIO7                    = 0x00060E00,
      GPIO_7_EPWM4B                   = 0x00060E01,
      GPIO_7_MCLKRA                   = 0x00060E02,
      GPIO_7_OUTPUTXBAR5              = 0x00060E03,
      GPIO_7_EQEP3_B                  = 0x00060E05,
      GPIO_7_CANB_RX                  = 0x00060E06,
      GPIO_7_ESC_GPI7                 = 0x00060E0A,
      GPIO_7_FSITXB_D1                = 0x00060E0D,

      GPIO_8_GPIO8                    = 0x00061000,
      GPIO_8_EPWM5A                   = 0x00061001,
      GPIO_8_CANB_TX                  = 0x00061002,
      GPIO_8_ADCSOCAO                 = 0x00061003,
      GPIO_8_EQEP3_STROBE             = 0x00061005,
      GPIO_8_SCIA_TX                  = 0x00061006,
      GPIO_8_MCAN_TX                  = 0x00061009,
      GPIO_8_ESC_GPO0                 = 0x0006100A,
      GPIO_8_FSITXB_CLK               = 0x0006100D,
      GPIO_8_FSITXA_D1                = 0x0006100E,
      GPIO_8_FSIRXA_D0                = 0x0006100F,

      GPIO_9_GPIO9                    = 0x00061200,
      GPIO_9_EPWM5B                   = 0x00061201,
      GPIO_9_SCIB_TX                  = 0x00061202,
      GPIO_9_OUTPUTXBAR6              = 0x00061203,
      GPIO_9_EQEP3_INDEX              = 0x00061205,
      GPIO_9_SCIA_RX                  = 0x00061206,
      GPIO_9_ESC_GPO1                 = 0x0006120A,
      GPIO_9_FSIRXB_D0                = 0x0006120D,
      GPIO_9_FSITXA_D0                = 0x0006120E,
      GPIO_9_FSIRXA_CLK               = 0x0006120F,

      GPIO_10_GPIO10                  = 0x00061400,
      GPIO_10_EPWM6A                  = 0x00061401,
      GPIO_10_CANB_RX                 = 0x00061402,
      GPIO_10_ADCSOCBO                = 0x00061403,
      GPIO_10_EQEP1_A                 = 0x00061405,
      GPIO_10_SCIB_TX                 = 0x00061406,
      GPIO_10_MCAN_RX                 = 0x00061409,
      GPIO_10_ESC_GPO2                = 0x0006140A,
      GPIO_10_FSIRXB_D1               = 0x0006140D,
      GPIO_10_FSITXA_CLK              = 0x0006140E,
      GPIO_10_FSIRXA_D1               = 0x0006140F,

      GPIO_11_GPIO11                  = 0x00061600,
      GPIO_11_EPWM6B                  = 0x00061601,
      GPIO_11_SCIB_RX                 = 0x00061602,
      GPIO_11_OUTPUTXBAR7             = 0x00061603,
      GPIO_11_EQEP1_B                 = 0x00061605,
      GPIO_11_ESC_GPO3                = 0x0006160A,
      GPIO_11_FSIRXB_CLK              = 0x0006160D,
      GPIO_11_FSIRXA_D1               = 0x0006160E,

      GPIO_12_GPIO12                  = 0x00061800,
      GPIO_12_EPWM7A                  = 0x00061801,
      GPIO_12_CANB_TX                 = 0x00061802,
      GPIO_12_MDXB                    = 0x00061803,
      GPIO_12_EQEP1_STROBE            = 0x00061805,
      GPIO_12_SCIC_TX                 = 0x00061806,
      GPIO_12_ESC_GPO4                = 0x0006180A,
      GPIO_12_FSIRXC_D0               = 0x0006180D,
      GPIO_12_FSIRXA_D0               = 0x0006180E,

      GPIO_13_GPIO13                  = 0x00061A00,
      GPIO_13_EPWM7B                  = 0x00061A01,
      GPIO_13_CANB_RX                 = 0x00061A02,
      GPIO_13_MDRB                    = 0x00061A03,
      GPIO_13_EQEP1_INDEX             = 0x00061A05,
      GPIO_13_SCIC_RX                 = 0x00061A06,
      GPIO_13_ESC_GPO5                = 0x00061A0A,
      GPIO_13_FSIRXC_D1               = 0x00061A0D,
      GPIO_13_FSIRXA_CLK              = 0x00061A0E,

      GPIO_14_GPIO14                  = 0x00061C00,
      GPIO_14_EPWM8A                  = 0x00061C01,
      GPIO_14_SCIB_TX                 = 0x00061C02,
      GPIO_14_MCLKXB                  = 0x00061C03,
      GPIO_14_OUTPUTXBAR3             = 0x00061C06,
      GPIO_14_ESC_GPO6                = 0x00061C0A,
      GPIO_14_FSIRXC_CLK              = 0x00061C0D,

      GPIO_15_GPIO15                  = 0x00061E00,
      GPIO_15_EPWM8B                  = 0x00061E01,
      GPIO_15_SCIB_RX                 = 0x00061E02,
      GPIO_15_MFSXB                   = 0x00061E03,
      GPIO_15_OUTPUTXBAR4             = 0x00061E06,
      GPIO_15_ESC_GPO7                = 0x00061E0A,
      GPIO_15_FSIRXD_D0               = 0x00061E0D,

      GPIO_16_GPIO16                  = 0x00080000,
      GPIO_16_SPIA_SIMO               = 0x00080001,
      GPIO_16_CANB_TX                 = 0x00080002,
      GPIO_16_OUTPUTXBAR7             = 0x00080003,
      GPIO_16_EPWM9A                  = 0x00080005,
      GPIO_16_SD1_D1                  = 0x00080007,
      GPIO_16_SSIA_TX                 = 0x0008000B,
      GPIO_16_FSIRXD_D1               = 0x0008000D,

      GPIO_17_GPIO17                  = 0x00080200,
      GPIO_17_SPIA_SOMI               = 0x00080201,
      GPIO_17_CANB_RX                 = 0x00080202,
      GPIO_17_OUTPUTXBAR8             = 0x00080203,
      GPIO_17_EPWM9B                  = 0x00080205,
      GPIO_17_SD1_C1                  = 0x00080207,
      GPIO_17_SSIA_RX                 = 0x0008020B,
      GPIO_17_FSIRXD_CLK              = 0x0008020D,

      GPIO_18_GPIO18                  = 0x00080400,
      GPIO_18_SPIA_CLK                = 0x00080401,
      GPIO_18_SCIB_TX                 = 0x00080402,
      GPIO_18_CANA_RX                 = 0x00080403,
      GPIO_18_EPWM10A                 = 0x00080405,
      GPIO_18_SD1_D2                  = 0x00080407,
      GPIO_18_MCAN_RX                 = 0x00080409,
      GPIO_18_EMIF1_CS2N              = 0x0008040A,
      GPIO_18_SSIA_CLK                = 0x0008040B,
      GPIO_18_FSIRXE_D0               = 0x0008040D,

      GPIO_19_GPIO19                  = 0x00080600,
      GPIO_19_SPIA_STEN               = 0x00080601,
      GPIO_19_SCIB_RX                 = 0x00080602,
      GPIO_19_CANA_TX                 = 0x00080603,
      GPIO_19_EPWM10B                 = 0x00080605,
      GPIO_19_SD1_C2                  = 0x00080607,
      GPIO_19_MCAN_TX                 = 0x00080609,
      GPIO_19_EMIF1_CS3N              = 0x0008060A,
      GPIO_19_SSIA_FSS                = 0x0008060B,
      GPIO_19_FSIRXE_D1               = 0x0008060D,

      GPIO_20_GPIO20                  = 0x00080800,
      GPIO_20_EQEP1_A                 = 0x00080801,
      GPIO_20_MDXA                    = 0x00080802,
      GPIO_20_CANB_TX                 = 0x00080803,
      GPIO_20_EPWM11A                 = 0x00080805,
      GPIO_20_SD1_D3                  = 0x00080807,
      GPIO_20_EMIF1_BA0               = 0x0008080A,
      GPIO_20_TRACE_DATA0             = 0x0008080B,
      GPIO_20_FSIRXE_CLK              = 0x0008080D,
      GPIO_20_SPIC_SIMO               = 0x0008080E,

      GPIO_21_GPIO21                  = 0x00080A00,
      GPIO_21_EQEP1_B                 = 0x00080A01,
      GPIO_21_MDRA                    = 0x00080A02,
      GPIO_21_CANB_RX                 = 0x00080A03,
      GPIO_21_EPWM11B                 = 0x00080A05,
      GPIO_21_SD1_C3                  = 0x00080A07,
      GPIO_21_EMIF1_BA1               = 0x00080A0A,
      GPIO_21_TRACE_DATA1             = 0x00080A0B,
      GPIO_21_FSIRXF_D0               = 0x00080A0D,
      GPIO_21_SPIC_SOMI               = 0x00080A0E,

      GPIO_22_GPIO22                  = 0x00080C00,
      GPIO_22_EQEP1_STROBE            = 0x00080C01,
      GPIO_22_MCLKXA                  = 0x00080C02,
      GPIO_22_SCIB_TX                 = 0x00080C03,
      GPIO_22_EPWM12A                 = 0x00080C05,
      GPIO_22_SPIB_CLK                = 0x00080C06,
      GPIO_22_SD1_D4                  = 0x00080C07,
      GPIO_22_MCAN_TX                 = 0x00080C09,
      GPIO_22_EMIF1_RAS               = 0x00080C0A,
      GPIO_22_TRACE_DATA2             = 0x00080C0B,
      GPIO_22_FSIRXF_D1               = 0x00080C0D,
      GPIO_22_SPIC_CLK                = 0x00080C0E,

      GPIO_23_GPIO23                  = 0x00080E00,
      GPIO_23_EQEP1_INDEX             = 0x00080E01,
      GPIO_23_MFSXA                   = 0x00080E02,
      GPIO_23_SCIB_RX                 = 0x00080E03,
      GPIO_23_EPWM12B                 = 0x00080E05,
      GPIO_23_SPIB_STEN               = 0x00080E06,
      GPIO_23_SD1_C4                  = 0x00080E07,
      GPIO_23_MCAN_RX                 = 0x00080E09,
      GPIO_23_EMIF1_CAS               = 0x00080E0A,
      GPIO_23_TRACE_DATA3             = 0x00080E0B,
      GPIO_23_FSIRXF_CLK              = 0x00080E0D,
      GPIO_23_SPIC_STEN               = 0x00080E0E,

      GPIO_24_GPIO24                  = 0x00081000,
      GPIO_24_OUTPUTXBAR1             = 0x00081001,
      GPIO_24_EQEP2_A                 = 0x00081002,
      GPIO_24_MDXB                    = 0x00081003,
      GPIO_24_SPIB_SIMO               = 0x00081006,
      GPIO_24_SD2_D1                  = 0x00081007,
      GPIO_24_PMBUSA_SCL              = 0x00081009,
      GPIO_24_EMIF1_DQM0              = 0x0008100A,
      GPIO_24_TRACE_CLK               = 0x0008100B,
      GPIO_24_EPWM13A                 = 0x0008100D,
      GPIO_24_FSIRXG_D0               = 0x0008100F,

      GPIO_25_GPIO25                  = 0x00081200,
      GPIO_25_OUTPUTXBAR2             = 0x00081201,
      GPIO_25_EQEP2_B                 = 0x00081202,
      GPIO_25_MDRB                    = 0x00081203,
      GPIO_25_SPIB_SOMI               = 0x00081206,
      GPIO_25_SD2_C1                  = 0x00081207,
      GPIO_25_PMBUSA_SDA              = 0x00081209,
      GPIO_25_EMIF1_DQM1              = 0x0008120A,
      GPIO_25_TRACE_SWO               = 0x0008120B,
      GPIO_25_EPWM13B                 = 0x0008120D,
      GPIO_25_FSITXA_D1               = 0x0008120E,
      GPIO_25_FSIRXG_D1               = 0x0008120F,

      GPIO_26_GPIO26                  = 0x00081400,
      GPIO_26_OUTPUTXBAR3             = 0x00081401,
      GPIO_26_EQEP2_INDEX             = 0x00081402,
      GPIO_26_MCLKXB                  = 0x00081403,
      GPIO_26_SPIB_CLK                = 0x00081406,
      GPIO_26_SD2_D2                  = 0x00081407,
      GPIO_26_PMBUSA_ALERT            = 0x00081409,
      GPIO_26_EMIF1_DQM2              = 0x0008140A,
      GPIO_26_ESC_MDIO_CLK            = 0x0008140B,
      GPIO_26_EPWM14A                 = 0x0008140D,
      GPIO_26_FSITXA_D0               = 0x0008140E,
      GPIO_26_FSIRXG_CLK              = 0x0008140F,

      GPIO_27_GPIO27                  = 0x00081600,
      GPIO_27_OUTPUTXBAR4             = 0x00081601,
      GPIO_27_EQEP2_STROBE            = 0x00081602,
      GPIO_27_MFSXB                   = 0x00081603,
      GPIO_27_SPIB_STEN               = 0x00081606,
      GPIO_27_SD2_C2                  = 0x00081607,
      GPIO_27_PMBUSA_CTL              = 0x00081609,
      GPIO_27_EMIF1_DQM3              = 0x0008160A,
      GPIO_27_ESC_MDIO_DATA           = 0x0008160B,
      GPIO_27_EPWM14B                 = 0x0008160D,
      GPIO_27_FSITXA_CLK              = 0x0008160E,
      GPIO_27_FSIRXH_D0               = 0x0008160F,

      GPIO_28_GPIO28                  = 0x00081800,
      GPIO_28_SCIA_RX                 = 0x00081801,
      GPIO_28_EMIF1_CS4N              = 0x00081802,
      GPIO_28_OUTPUTXBAR5             = 0x00081805,
      GPIO_28_EQEP3_A                 = 0x00081806,
      GPIO_28_SD2_D3                  = 0x00081807,
      GPIO_28_EMIF1_CS2N              = 0x00081809,
      GPIO_28_EPWM15A                 = 0x0008180D,
      GPIO_28_FSIRXH_D1               = 0x0008180F,

      GPIO_29_GPIO29                  = 0x00081A00,
      GPIO_29_SCIA_TX                 = 0x00081A01,
      GPIO_29_EMIF1_SDCKE             = 0x00081A02,
      GPIO_29_OUTPUTXBAR6             = 0x00081A05,
      GPIO_29_EQEP3_B                 = 0x00081A06,
      GPIO_29_SD2_C3                  = 0x00081A07,
      GPIO_29_EMIF1_CS3N              = 0x00081A09,
      GPIO_29_ESC_LATCH0              = 0x00081A0A,
      GPIO_29_ESC_I2C_SDA             = 0x00081A0B,
      GPIO_29_EPWM15B                 = 0x00081A0D,
      GPIO_29_ESC_SYNC0               = 0x00081A0E,
      GPIO_29_FSIRXH_CLK              = 0x00081A0F,

      GPIO_30_GPIO30                  = 0x00081C00,
      GPIO_30_CANA_RX                 = 0x00081C01,
      GPIO_30_EMIF1_CLK               = 0x00081C02,
      GPIO_30_MCAN_RX                 = 0x00081C03,
      GPIO_30_OUTPUTXBAR7             = 0x00081C05,
      GPIO_30_EQEP3_STROBE            = 0x00081C06,
      GPIO_30_SD2_D4                  = 0x00081C07,
      GPIO_30_EMIF1_CS4N              = 0x00081C09,
      GPIO_30_ESC_LATCH1              = 0x00081C0A,
      GPIO_30_ESC_I2C_SCL             = 0x00081C0B,
      GPIO_30_EPWM16A                 = 0x00081C0D,
      GPIO_30_ESC_SYNC1               = 0x00081C0E,
      GPIO_30_SPID_SIMO               = 0x00081C0F,

      GPIO_31_GPIO31                  = 0x00081E00,
      GPIO_31_CANA_TX                 = 0x00081E01,
      GPIO_31_EMIF1_WEN               = 0x00081E02,
      GPIO_31_MCAN_TX                 = 0x00081E03,
      GPIO_31_OUTPUTXBAR8             = 0x00081E05,
      GPIO_31_EQEP3_INDEX             = 0x00081E06,
      GPIO_31_SD2_C4                  = 0x00081E07,
      GPIO_31_EMIF1_RNW               = 0x00081E09,
      GPIO_31_I2CA_SDA                = 0x00081E0A,
      GPIO_31_CM_I2CA_SDA             = 0x00081E0B,
      GPIO_31_EPWM16B                 = 0x00081E0D,
      GPIO_31_SPID_SOMI               = 0x00081E0F,

      GPIO_32_GPIO32                  = 0x00460000,
      GPIO_32_I2CA_SDA                = 0x00460001,
      GPIO_32_EMIF1_CS0N              = 0x00460002,
      GPIO_32_SPIA_SIMO               = 0x00460003,
      GPIO_32_CLB_OUTPUTXBAR1         = 0x00460007,
      GPIO_32_EMIF1_OEN               = 0x00460009,
      GPIO_32_I2CA_SCL                = 0x0046000A,
      GPIO_32_CM_I2CA_SCL             = 0x0046000B,
      GPIO_32_SPID_CLK                = 0x0046000F,

      GPIO_33_GPIO33                  = 0x00460200,
      GPIO_33_I2CA_SCL                = 0x00460201,
      GPIO_33_EMIF1_RNW               = 0x00460202,
      GPIO_33_SPIA_SOMI               = 0x00460203,
      GPIO_33_CLB_OUTPUTXBAR2         = 0x00460207,
      GPIO_33_EMIF1_BA0               = 0x00460209,
      GPIO_33_SPID_STEN               = 0x0046020F,

      GPIO_34_GPIO34                  = 0x00460400,
      GPIO_34_OUTPUTXBAR1             = 0x00460401,
      GPIO_34_EMIF1_CS2N              = 0x00460402,
      GPIO_34_SPIA_CLK                = 0x00460403,
      GPIO_34_I2CB_SDA                = 0x00460406,
      GPIO_34_CLB_OUTPUTXBAR3         = 0x00460407,
      GPIO_34_EMIF1_BA1               = 0x00460409,
      GPIO_34_ESC_LATCH0              = 0x0046040A,
      GPIO_34_ENET_MII_CRS            = 0x0046040B,
      GPIO_34_SCIA_TX                 = 0x0046040D,
      GPIO_34_ESC_SYNC0               = 0x0046040E,

      GPIO_35_GPIO35                  = 0x00460600,
      GPIO_35_SCIA_RX                 = 0x00460601,
      GPIO_35_EMIF1_CS3N              = 0x00460602,
      GPIO_35_SPIA_STEN               = 0x00460603,
      GPIO_35_I2CB_SCL                = 0x00460606,
      GPIO_35_CLB_OUTPUTXBAR4         = 0x00460607,
      GPIO_35_EMIF1_A0                = 0x00460609,
      GPIO_35_ESC_LATCH1              = 0x0046060A,
      GPIO_35_ENET_MII_COL            = 0x0046060B,
      GPIO_35_ESC_SYNC1               = 0x0046060E,

      GPIO_36_GPIO36                  = 0x00460800,
      GPIO_36_SCIA_TX                 = 0x00460801,
      GPIO_36_EMIF1_WAIT              = 0x00460802,
      GPIO_36_CANA_RX                 = 0x00460806,
      GPIO_36_CLB_OUTPUTXBAR5         = 0x00460807,
      GPIO_36_EMIF1_A1                = 0x00460809,
      GPIO_36_MCAN_RX                 = 0x0046080A,
      GPIO_36_SD1_D1                  = 0x0046080D,

      GPIO_37_GPIO37                  = 0x00460A00,
      GPIO_37_OUTPUTXBAR2             = 0x00460A01,
      GPIO_37_EMIF1_OEN               = 0x00460A02,
      GPIO_37_CANA_TX                 = 0x00460A06,
      GPIO_37_CLB_OUTPUTXBAR6         = 0x00460A07,
      GPIO_37_EMIF1_A2                = 0x00460A09,
      GPIO_37_MCAN_TX                 = 0x00460A0A,
      GPIO_37_SD1_D2                  = 0x00460A0D,

      GPIO_38_GPIO38                  = 0x00460C00,
      GPIO_38_EMIF1_A0                = 0x00460C02,
      GPIO_38_SCIC_TX                 = 0x00460C05,
      GPIO_38_CANB_TX                 = 0x00460C06,
      GPIO_38_CLB_OUTPUTXBAR7         = 0x00460C07,
      GPIO_38_EMIF1_A3                = 0x00460C09,
      GPIO_38_ENET_MII_RX_DV          = 0x00460C0A,
      GPIO_38_ENET_MII_CRS            = 0x00460C0B,
      GPIO_38_SD1_D3                  = 0x00460C0D,

      GPIO_39_GPIO39                  = 0x00460E00,
      GPIO_39_EMIF1_A1                = 0x00460E02,
      GPIO_39_SCIC_RX                 = 0x00460E05,
      GPIO_39_CANB_RX                 = 0x00460E06,
      GPIO_39_CLB_OUTPUTXBAR8         = 0x00460E07,
      GPIO_39_EMIF1_A4                = 0x00460E09,
      GPIO_39_ENET_MII_RX_ERR         = 0x00460E0A,
      GPIO_39_ENET_MII_COL            = 0x00460E0B,
      GPIO_39_SD1_D4                  = 0x00460E0D,

      GPIO_40_GPIO40                  = 0x00461000,
      GPIO_40_EMIF1_A2                = 0x00461002,
      GPIO_40_I2CB_SDA                = 0x00461006,
      GPIO_40_ENET_MII_CRS            = 0x0046100B,
      GPIO_40_ESC_I2C_SDA             = 0x0046100E,

      GPIO_41_GPIO41                  = 0x00461200,
      GPIO_41_EMIF1_A3                = 0x00461202,
      GPIO_41_I2CB_SCL                = 0x00461206,
      GPIO_41_ENET_REVMII_MDIO_RST    = 0x0046120A,
      GPIO_41_ENET_MII_COL            = 0x0046120B,
      GPIO_41_ESC_I2C_SCL             = 0x0046120E,

      GPIO_42_GPIO42                  = 0x00461400,
      GPIO_42_I2CA_SDA                = 0x00461406,
      GPIO_42_ENET_MDIO_CLK           = 0x0046140A,
      GPIO_42_UARTA_TX                = 0x0046140B,
      GPIO_42_SCIA_TX                 = 0x0046140F,

      GPIO_43_GPIO43                  = 0x00461600,
      GPIO_43_I2CA_SCL                = 0x00461606,
      GPIO_43_ENET_MDIO_DATA          = 0x0046160A,
      GPIO_43_UARTA_RX                = 0x0046160B,
      GPIO_43_SCIA_RX                 = 0x0046160F,

      GPIO_44_GPIO44                  = 0x00461800,
      GPIO_44_EMIF1_A4                = 0x00461802,
      GPIO_44_ENET_MII_TX_CLK         = 0x0046180B,
      GPIO_44_ESC_TX1_CLK             = 0x0046180E,

      GPIO_45_GPIO45                  = 0x00461A00,
      GPIO_45_EMIF1_A5                = 0x00461A02,
      GPIO_45_ENET_MII_TX_EN          = 0x00461A0B,
      GPIO_45_ESC_TX1_ENA             = 0x00461A0E,

      GPIO_46_GPIO46                  = 0x00461C00,
      GPIO_46_EMIF1_A6                = 0x00461C02,
      GPIO_46_SCID_RX                 = 0x00461C06,
      GPIO_46_ENET_MII_TX_ERR         = 0x00461C0B,
      GPIO_46_ESC_MDIO_CLK            = 0x00461C0E,

      GPIO_47_GPIO47                  = 0x00461E00,
      GPIO_47_EMIF1_A7                = 0x00461E02,
      GPIO_47_SCID_TX                 = 0x00461E06,
      GPIO_47_ENET_PPS0               = 0x00461E0B,
      GPIO_47_ESC_MDIO_DATA           = 0x00461E0E,

      GPIO_48_GPIO48                  = 0x00480000,
      GPIO_48_OUTPUTXBAR3             = 0x00480001,
      GPIO_48_EMIF1_A8                = 0x00480002,
      GPIO_48_SCIA_TX                 = 0x00480006,
      GPIO_48_SD1_D1                  = 0x00480007,
      GPIO_48_ENET_PPS1               = 0x0048000B,
      GPIO_48_ESC_PHY_CLK             = 0x0048000E,

      GPIO_49_GPIO49                  = 0x00480200,
      GPIO_49_OUTPUTXBAR4             = 0x00480201,
      GPIO_49_EMIF1_A9                = 0x00480202,
      GPIO_49_SCIA_RX                 = 0x00480206,
      GPIO_49_SD1_C1                  = 0x00480207,
      GPIO_49_EMIF1_A5                = 0x00480209,
      GPIO_49_ENET_MII_RX_CLK         = 0x0048020B,
      GPIO_49_SD2_D1                  = 0x0048020D,
      GPIO_49_FSITXA_D0               = 0x0048020E,

      GPIO_50_GPIO50                  = 0x00480400,
      GPIO_50_EQEP1_A                 = 0x00480401,
      GPIO_50_EMIF1_A10               = 0x00480402,
      GPIO_50_SPIC_SIMO               = 0x00480406,
      GPIO_50_SD1_D2                  = 0x00480407,
      GPIO_50_EMIF1_A6                = 0x00480409,
      GPIO_50_ENET_MII_RX_DV          = 0x0048040B,
      GPIO_50_SD2_D2                  = 0x0048040D,
      GPIO_50_FSITXA_D1               = 0x0048040E,

      GPIO_51_GPIO51                  = 0x00480600,
      GPIO_51_EQEP1_B                 = 0x00480601,
      GPIO_51_EMIF1_A11               = 0x00480602,
      GPIO_51_SPIC_SOMI               = 0x00480606,
      GPIO_51_SD1_C2                  = 0x00480607,
      GPIO_51_EMIF1_A7                = 0x00480609,
      GPIO_51_ENET_MII_RX_ERR         = 0x0048060B,
      GPIO_51_SD2_D3                  = 0x0048060D,
      GPIO_51_FSITXA_CLK              = 0x0048060E,

      GPIO_52_GPIO52                  = 0x00480800,
      GPIO_52_EQEP1_STROBE            = 0x00480801,
      GPIO_52_EMIF1_A12               = 0x00480802,
      GPIO_52_SPIC_CLK                = 0x00480806,
      GPIO_52_SD1_D3                  = 0x00480807,
      GPIO_52_EMIF1_A8                = 0x00480809,
      GPIO_52_ENET_MII_RX_DATA0       = 0x0048080B,
      GPIO_52_SD2_D4                  = 0x0048080D,
      GPIO_52_FSIRXA_D0               = 0x0048080E,

      GPIO_53_GPIO53                  = 0x00480A00,
      GPIO_53_EQEP1_INDEX             = 0x00480A01,
      GPIO_53_EMIF1_D31               = 0x00480A02,
      GPIO_53_EMIF2_D15               = 0x00480A03,
      GPIO_53_SPIC_STEN               = 0x00480A06,
      GPIO_53_SD1_C3                  = 0x00480A07,
      GPIO_53_EMIF1_A9                = 0x00480A09,
      GPIO_53_ENET_MII_RX_DATA1       = 0x00480A0B,
      GPIO_53_SD1_C1                  = 0x00480A0D,
      GPIO_53_FSIRXA_D1               = 0x00480A0E,

      GPIO_54_GPIO54                  = 0x00480C00,
      GPIO_54_SPIA_SIMO               = 0x00480C01,
      GPIO_54_EMIF1_D30               = 0x00480C02,
      GPIO_54_EMIF2_D14               = 0x00480C03,
      GPIO_54_EQEP2_A                 = 0x00480C05,
      GPIO_54_SCIB_TX                 = 0x00480C06,
      GPIO_54_SD1_D4                  = 0x00480C07,
      GPIO_54_EMIF1_A10               = 0x00480C09,
      GPIO_54_ENET_MII_RX_DATA2       = 0x00480C0B,
      GPIO_54_SD1_C2                  = 0x00480C0D,
      GPIO_54_FSIRXA_CLK              = 0x00480C0E,
      GPIO_54_SSIA_TX                 = 0x00480C0F,

      GPIO_55_GPIO55                  = 0x00480E00,
      GPIO_55_SPIA_SOMI               = 0x00480E01,
      GPIO_55_EMIF1_D29               = 0x00480E02,
      GPIO_55_EMIF2_D13               = 0x00480E03,
      GPIO_55_EQEP2_B                 = 0x00480E05,
      GPIO_55_SCIB_RX                 = 0x00480E06,
      GPIO_55_SD1_C4                  = 0x00480E07,
      GPIO_55_EMIF1_D0                = 0x00480E09,
      GPIO_55_ENET_MII_RX_DATA3       = 0x00480E0B,
      GPIO_55_SD1_C3                  = 0x00480E0D,
      GPIO_55_FSITXB_D0               = 0x00480E0E,
      GPIO_55_SSIA_RX                 = 0x00480E0F,

      GPIO_56_GPIO56                  = 0x00481000,
      GPIO_56_SPIA_CLK                = 0x00481001,
      GPIO_56_EMIF1_D28               = 0x00481002,
      GPIO_56_EMIF2_D12               = 0x00481003,
      GPIO_56_EQEP2_STROBE            = 0x00481005,
      GPIO_56_SCIC_TX                 = 0x00481006,
      GPIO_56_SD2_D1                  = 0x00481007,
      GPIO_56_EMIF1_D1                = 0x00481009,
      GPIO_56_I2CA_SDA                = 0x0048100A,
      GPIO_56_ENET_MII_TX_EN          = 0x0048100B,
      GPIO_56_SD1_C4                  = 0x0048100D,
      GPIO_56_FSITXB_CLK              = 0x0048100E,
      GPIO_56_SSIA_CLK                = 0x0048100F,

      GPIO_57_GPIO57                  = 0x00481200,
      GPIO_57_SPIA_STEN               = 0x00481201,
      GPIO_57_EMIF1_D27               = 0x00481202,
      GPIO_57_EMIF2_D11               = 0x00481203,
      GPIO_57_EQEP2_INDEX             = 0x00481205,
      GPIO_57_SCIC_RX                 = 0x00481206,
      GPIO_57_SD2_C1                  = 0x00481207,
      GPIO_57_EMIF1_D2                = 0x00481209,
      GPIO_57_I2CA_SCL                = 0x0048120A,
      GPIO_57_ENET_MII_TX_ERR         = 0x0048120B,
      GPIO_57_FSITXB_D1               = 0x0048120E,
      GPIO_57_SSIA_FSS                = 0x0048120F,

      GPIO_58_GPIO58                  = 0x00481400,
      GPIO_58_MCLKRA                  = 0x00481401,
      GPIO_58_EMIF1_D26               = 0x00481402,
      GPIO_58_EMIF2_D10               = 0x00481403,
      GPIO_58_OUTPUTXBAR1             = 0x00481405,
      GPIO_58_SPIB_CLK                = 0x00481406,
      GPIO_58_SD2_D2                  = 0x00481407,
      GPIO_58_EMIF1_D3                = 0x00481409,
      GPIO_58_ESC_LED_LINK0_ACTIVE    = 0x0048140A,
      GPIO_58_ENET_MII_TX_CLK         = 0x0048140B,
      GPIO_58_SD2_C2                  = 0x0048140D,
      GPIO_58_FSIRXB_D0               = 0x0048140E,
      GPIO_58_SPIA_SIMO               = 0x0048140F,

      GPIO_59_GPIO59                  = 0x00481600,
      GPIO_59_MFSRA                   = 0x00481601,
      GPIO_59_EMIF1_D25               = 0x00481602,
      GPIO_59_EMIF2_D9                = 0x00481603,
      GPIO_59_OUTPUTXBAR2             = 0x00481605,
      GPIO_59_SPIB_STEN               = 0x00481606,
      GPIO_59_SD2_C2                  = 0x00481607,
      GPIO_59_EMIF1_D4                = 0x00481609,
      GPIO_59_ESC_LED_LINK1_ACTIVE    = 0x0048160A,
      GPIO_59_ENET_MII_TX_DATA0       = 0x0048160B,
      GPIO_59_SD2_C3                  = 0x0048160D,
      GPIO_59_FSIRXB_D1               = 0x0048160E,
      GPIO_59_SPIA_SOMI               = 0x0048160F,

      GPIO_60_GPIO60                  = 0x00481800,
      GPIO_60_MCLKRB                  = 0x00481801,
      GPIO_60_EMIF1_D24               = 0x00481802,
      GPIO_60_EMIF2_D8                = 0x00481803,
      GPIO_60_OUTPUTXBAR3             = 0x00481805,
      GPIO_60_SPIB_SIMO               = 0x00481806,
      GPIO_60_SD2_D3                  = 0x00481807,
      GPIO_60_EMIF1_D5                = 0x00481809,
      GPIO_60_ESC_LED_ERR             = 0x0048180A,
      GPIO_60_ENET_MII_TX_DATA1       = 0x0048180B,
      GPIO_60_SD2_C4                  = 0x0048180D,
      GPIO_60_FSIRXB_CLK              = 0x0048180E,
      GPIO_60_SPIA_CLK                = 0x0048180F,

      GPIO_61_GPIO61                  = 0x00481A00,
      GPIO_61_MFSRB                   = 0x00481A01,
      GPIO_61_EMIF1_D23               = 0x00481A02,
      GPIO_61_EMIF2_D7                = 0x00481A03,
      GPIO_61_OUTPUTXBAR4             = 0x00481A05,
      GPIO_61_SPIB_SOMI               = 0x00481A06,
      GPIO_61_SD2_C3                  = 0x00481A07,
      GPIO_61_EMIF1_D6                = 0x00481A09,
      GPIO_61_ESC_LED_RUN             = 0x00481A0A,
      GPIO_61_ENET_MII_TX_DATA2       = 0x00481A0B,
      GPIO_61_CANA_RX                 = 0x00481A0E,
      GPIO_61_SPIA_STEN               = 0x00481A0F,

      GPIO_62_GPIO62                  = 0x00481C00,
      GPIO_62_SCIC_RX                 = 0x00481C01,
      GPIO_62_EMIF1_D22               = 0x00481C02,
      GPIO_62_EMIF2_D6                = 0x00481C03,
      GPIO_62_EQEP3_A                 = 0x00481C05,
      GPIO_62_CANA_RX                 = 0x00481C06,
      GPIO_62_SD2_D4                  = 0x00481C07,
      GPIO_62_EMIF1_D7                = 0x00481C09,
      GPIO_62_ESC_LED_STATE_RUN       = 0x00481C0A,
      GPIO_62_ENET_MII_TX_DATA3       = 0x00481C0B,
      GPIO_62_CANA_TX                 = 0x00481C0E,

      GPIO_63_GPIO63                  = 0x00481E00,
      GPIO_63_SCIC_TX                 = 0x00481E01,
      GPIO_63_EMIF1_D21               = 0x00481E02,
      GPIO_63_EMIF2_D5                = 0x00481E03,
      GPIO_63_EQEP3_B                 = 0x00481E05,
      GPIO_63_CANA_TX                 = 0x00481E06,
      GPIO_63_SD2_C4                  = 0x00481E07,
      GPIO_63_SSIA_TX                 = 0x00481E09,
      GPIO_63_ENET_MII_RX_DATA0       = 0x00481E0B,
      GPIO_63_SD1_D1                  = 0x00481E0D,
      GPIO_63_ESC_RX1_DATA0           = 0x00481E0E,
      GPIO_63_SPIB_SIMO               = 0x00481E0F,

      GPIO_64_GPIO64                  = 0x00860000,
      GPIO_64_EMIF1_D20               = 0x00860002,
      GPIO_64_EMIF2_D4                = 0x00860003,
      GPIO_64_EQEP3_STROBE            = 0x00860005,
      GPIO_64_SCIA_RX                 = 0x00860006,
      GPIO_64_SSIA_RX                 = 0x00860009,
      GPIO_64_ENET_MII_RX_DV          = 0x0086000A,
      GPIO_64_ENET_MII_RX_DATA1       = 0x0086000B,
      GPIO_64_SD1_C1                  = 0x0086000D,
      GPIO_64_ESC_RX1_DATA1           = 0x0086000E,
      GPIO_64_SPIB_SOMI               = 0x0086000F,

      GPIO_65_GPIO65                  = 0x00860200,
      GPIO_65_EMIF1_D19               = 0x00860202,
      GPIO_65_EMIF2_D3                = 0x00860203,
      GPIO_65_EQEP3_INDEX             = 0x00860205,
      GPIO_65_SCIA_TX                 = 0x00860206,
      GPIO_65_SSIA_CLK                = 0x00860209,
      GPIO_65_ENET_MII_RX_ERR         = 0x0086020A,
      GPIO_65_ENET_MII_RX_DATA2       = 0x0086020B,
      GPIO_65_SD1_D2                  = 0x0086020D,
      GPIO_65_ESC_RX1_DATA2           = 0x0086020E,
      GPIO_65_SPIB_CLK                = 0x0086020F,

      GPIO_66_GPIO66                  = 0x00860400,
      GPIO_66_EMIF1_D18               = 0x00860402,
      GPIO_66_EMIF2_D2                = 0x00860403,
      GPIO_66_I2CB_SDA                = 0x00860406,
      GPIO_66_SSIA_FSS                = 0x00860409,
      GPIO_66_ENET_MII_RX_DATA0       = 0x0086040A,
      GPIO_66_ENET_MII_RX_DATA3       = 0x0086040B,
      GPIO_66_SD1_C2                  = 0x0086040D,
      GPIO_66_ESC_RX1_DATA3           = 0x0086040E,
      GPIO_66_SPIB_STEN               = 0x0086040F,

      GPIO_67_GPIO67                  = 0x00860600,
      GPIO_67_EMIF1_D17               = 0x00860602,
      GPIO_67_EMIF2_D1                = 0x00860603,
      GPIO_67_ENET_MII_RX_CLK         = 0x0086060A,
      GPIO_67_ENET_REVMII_MDIO_RST    = 0x0086060B,
      GPIO_67_SD1_D3                  = 0x0086060D,

      GPIO_68_GPIO68                  = 0x00860800,
      GPIO_68_EMIF1_D16               = 0x00860802,
      GPIO_68_EMIF2_D0                = 0x00860803,
      GPIO_68_ENET_MII_INTR           = 0x0086080B,
      GPIO_68_SD1_C3                  = 0x0086080D,
      GPIO_68_ESC_PHY1_LINKSTATUS     = 0x0086080E,

      GPIO_69_GPIO69                  = 0x00860A00,
      GPIO_69_EMIF1_D15               = 0x00860A02,
      GPIO_69_I2CB_SCL                = 0x00860A06,
      GPIO_69_ENET_MII_TX_EN          = 0x00860A0A,
      GPIO_69_ENET_MII_RX_CLK         = 0x00860A0B,
      GPIO_69_SD1_D4                  = 0x00860A0D,
      GPIO_69_ESC_RX1_CLK             = 0x00860A0E,
      GPIO_69_SPIC_SIMO               = 0x00860A0F,

      GPIO_70_GPIO70                  = 0x00860C00,
      GPIO_70_EMIF1_D14               = 0x00860C02,
      GPIO_70_CANA_RX                 = 0x00860C05,
      GPIO_70_SCIB_TX                 = 0x00860C06,
      GPIO_70_MCAN_RX                 = 0x00860C09,
      GPIO_70_ENET_MII_RX_DV          = 0x00860C0B,
      GPIO_70_SD1_C4                  = 0x00860C0D,
      GPIO_70_ESC_RX1_DV              = 0x00860C0E,
      GPIO_70_SPIC_SOMI               = 0x00860C0F,

      GPIO_71_GPIO71                  = 0x00860E00,
      GPIO_71_EMIF1_D13               = 0x00860E02,
      GPIO_71_CANA_TX                 = 0x00860E05,
      GPIO_71_SCIB_RX                 = 0x00860E06,
      GPIO_71_MCAN_TX                 = 0x00860E09,
      GPIO_71_ENET_MII_RX_DATA0       = 0x00860E0A,
      GPIO_71_ENET_MII_RX_ERR         = 0x00860E0B,
      GPIO_71_ESC_RX1_ERR             = 0x00860E0E,
      GPIO_71_SPIC_CLK                = 0x00860E0F,

      GPIO_72_GPIO72                  = 0x00861000,
      GPIO_72_EMIF1_D12               = 0x00861002,
      GPIO_72_CANB_TX                 = 0x00861005,
      GPIO_72_SCIC_TX                 = 0x00861006,
      GPIO_72_ENET_MII_RX_DATA1       = 0x0086100A,
      GPIO_72_ENET_MII_TX_DATA3       = 0x0086100B,
      GPIO_72_ESC_TX1_DATA3           = 0x0086100E,
      GPIO_72_SPIC_STEN               = 0x0086100F,

      GPIO_73_GPIO73                  = 0x00861200,
      GPIO_73_EMIF1_D11               = 0x00861202,
      GPIO_73_XCLKOUT                 = 0x00861203,
      GPIO_73_CANB_RX                 = 0x00861205,
      GPIO_73_SCIC_RX                 = 0x00861206,
      GPIO_73_ENET_RMII_CLK           = 0x0086120A,
      GPIO_73_ENET_MII_TX_DATA2       = 0x0086120B,
      GPIO_73_SD2_D2                  = 0x0086120D,
      GPIO_73_ESC_TX1_DATA2           = 0x0086120E,

      GPIO_74_GPIO74                  = 0x00861400,
      GPIO_74_EMIF1_D10               = 0x00861402,
      GPIO_74_MCAN_TX                 = 0x00861409,
      GPIO_74_ENET_MII_TX_DATA1       = 0x0086140B,
      GPIO_74_SD2_C2                  = 0x0086140D,
      GPIO_74_ESC_TX1_DATA1           = 0x0086140E,

      GPIO_75_GPIO75                  = 0x00861600,
      GPIO_75_EMIF1_D9                = 0x00861602,
      GPIO_75_MCAN_RX                 = 0x00861609,
      GPIO_75_ENET_MII_TX_DATA0       = 0x0086160B,
      GPIO_75_SD2_D3                  = 0x0086160D,
      GPIO_75_ESC_TX1_DATA0           = 0x0086160E,

      GPIO_76_GPIO76                  = 0x00861800,
      GPIO_76_EMIF1_D8                = 0x00861802,
      GPIO_76_SCID_TX                 = 0x00861806,
      GPIO_76_ENET_MII_RX_ERR         = 0x0086180A,
      GPIO_76_SD2_C3                  = 0x0086180D,
      GPIO_76_ESC_PHY_RESETN          = 0x0086180E,

      GPIO_77_GPIO77                  = 0x00861A00,
      GPIO_77_EMIF1_D7                = 0x00861A02,
      GPIO_77_SCID_RX                 = 0x00861A06,
      GPIO_77_SD2_D4                  = 0x00861A0D,
      GPIO_77_ESC_RX0_CLK             = 0x00861A0E,

      GPIO_78_GPIO78                  = 0x00861C00,
      GPIO_78_EMIF1_D6                = 0x00861C02,
      GPIO_78_EQEP2_A                 = 0x00861C06,
      GPIO_78_SD2_C4                  = 0x00861C0D,
      GPIO_78_ESC_RX0_DV              = 0x00861C0E,

      GPIO_79_GPIO79                  = 0x00861E00,
      GPIO_79_EMIF1_D5                = 0x00861E02,
      GPIO_79_EQEP2_B                 = 0x00861E06,
      GPIO_79_SD2_D1                  = 0x00861E0D,
      GPIO_79_ESC_RX0_ERR             = 0x00861E0E,

      GPIO_80_GPIO80                  = 0x00880000,
      GPIO_80_EMIF1_D4                = 0x00880002,
      GPIO_80_EQEP2_STROBE            = 0x00880006,
      GPIO_80_SD2_C1                  = 0x0088000D,
      GPIO_80_ESC_RX0_DATA0           = 0x0088000E,

      GPIO_81_GPIO81                  = 0x00880200,
      GPIO_81_EMIF1_D3                = 0x00880202,
      GPIO_81_EQEP2_INDEX             = 0x00880206,
      GPIO_81_ESC_RX0_DATA1           = 0x0088020E,

      GPIO_82_GPIO82                  = 0x00880400,
      GPIO_82_EMIF1_D2                = 0x00880402,
      GPIO_82_ESC_RX0_DATA2           = 0x0088040E,

      GPIO_83_GPIO83                  = 0x00880600,
      GPIO_83_EMIF1_D1                = 0x00880602,
      GPIO_83_ESC_RX0_DATA3           = 0x0088060E,

      GPIO_84_GPIO84                  = 0x00880800,
      GPIO_84_SCIA_TX                 = 0x00880805,
      GPIO_84_MDXB                    = 0x00880806,
      GPIO_84_UARTA_TX                = 0x0088080B,
      GPIO_84_ESC_TX0_ENA             = 0x0088080E,
      GPIO_84_MDXA                    = 0x0088080F,

      GPIO_85_GPIO85                  = 0x00880A00,
      GPIO_85_EMIF1_D0                = 0x00880A02,
      GPIO_85_SCIA_RX                 = 0x00880A05,
      GPIO_85_MDRB                    = 0x00880A06,
      GPIO_85_UARTA_RX                = 0x00880A0B,
      GPIO_85_ESC_TX0_CLK             = 0x00880A0E,
      GPIO_85_MDRA                    = 0x00880A0F,

      GPIO_86_GPIO86                  = 0x00880C00,
      GPIO_86_EMIF1_A13               = 0x00880C02,
      GPIO_86_EMIF1_CAS               = 0x00880C03,
      GPIO_86_SCIB_TX                 = 0x00880C05,
      GPIO_86_MCLKXB                  = 0x00880C06,
      GPIO_86_ESC_PHY0_LINKSTATUS     = 0x00880C0E,
      GPIO_86_MCLKXA                  = 0x00880C0F,

      GPIO_87_GPIO87                  = 0x00880E00,
      GPIO_87_EMIF1_A14               = 0x00880E02,
      GPIO_87_EMIF1_RAS               = 0x00880E03,
      GPIO_87_SCIB_RX                 = 0x00880E05,
      GPIO_87_MFSXB                   = 0x00880E06,
      GPIO_87_EMIF1_DQM3              = 0x00880E09,
      GPIO_87_ESC_TX0_DATA0           = 0x00880E0E,
      GPIO_87_MFSXA                   = 0x00880E0F,

      GPIO_88_GPIO88                  = 0x00881000,
      GPIO_88_EMIF1_A15               = 0x00881002,
      GPIO_88_EMIF1_DQM0              = 0x00881003,
      GPIO_88_EMIF1_DQM1              = 0x00881009,
      GPIO_88_ESC_TX0_DATA1           = 0x0088100E,

      GPIO_89_GPIO89                  = 0x00881200,
      GPIO_89_EMIF1_A16               = 0x00881202,
      GPIO_89_EMIF1_DQM1              = 0x00881203,
      GPIO_89_SCIC_TX                 = 0x00881206,
      GPIO_89_EMIF1_CAS               = 0x00881209,
      GPIO_89_ESC_TX0_DATA2           = 0x0088120E,

      GPIO_90_GPIO90                  = 0x00881400,
      GPIO_90_EMIF1_A17               = 0x00881402,
      GPIO_90_EMIF1_DQM2              = 0x00881403,
      GPIO_90_SCIC_RX                 = 0x00881406,
      GPIO_90_EMIF1_RAS               = 0x00881409,
      GPIO_90_ESC_TX0_DATA3           = 0x0088140E,

      GPIO_91_GPIO91                  = 0x00881600,
      GPIO_91_EMIF1_A18               = 0x00881602,
      GPIO_91_EMIF1_DQM3              = 0x00881603,
      GPIO_91_I2CA_SDA                = 0x00881606,
      GPIO_91_EMIF1_DQM2              = 0x00881609,
      GPIO_91_PMBUSA_SCL              = 0x0088160A,
      GPIO_91_SSIA_TX                 = 0x0088160B,
      GPIO_91_FSIRXF_D0               = 0x0088160D,
      GPIO_91_CLB_OUTPUTXBAR1         = 0x0088160E,
      GPIO_91_SPID_SIMO               = 0x0088160F,

      GPIO_92_GPIO92                  = 0x00881800,
      GPIO_92_EMIF1_A19               = 0x00881802,
      GPIO_92_EMIF1_BA1               = 0x00881803,
      GPIO_92_I2CA_SCL                = 0x00881806,
      GPIO_92_EMIF1_DQM0              = 0x00881809,
      GPIO_92_PMBUSA_SDA              = 0x0088180A,
      GPIO_92_SSIA_RX                 = 0x0088180B,
      GPIO_92_FSIRXF_D1               = 0x0088180D,
      GPIO_92_CLB_OUTPUTXBAR2         = 0x0088180E,
      GPIO_92_SPID_SOMI               = 0x0088180F,

      GPIO_93_GPIO93                  = 0x00881A00,
      GPIO_93_EMIF1_BA0               = 0x00881A03,
      GPIO_93_SCID_TX                 = 0x00881A06,
      GPIO_93_PMBUSA_ALERT            = 0x00881A0A,
      GPIO_93_SSIA_CLK                = 0x00881A0B,
      GPIO_93_FSIRXF_CLK              = 0x00881A0D,
      GPIO_93_CLB_OUTPUTXBAR3         = 0x00881A0E,
      GPIO_93_SPID_CLK                = 0x00881A0F,

      GPIO_94_GPIO94                  = 0x00881C00,
      GPIO_94_SCID_RX                 = 0x00881C06,
      GPIO_94_EMIF1_BA1               = 0x00881C09,
      GPIO_94_PMBUSA_CTL              = 0x00881C0A,
      GPIO_94_SSIA_FSS                = 0x00881C0B,
      GPIO_94_FSIRXG_D0               = 0x00881C0D,
      GPIO_94_CLB_OUTPUTXBAR4         = 0x00881C0E,
      GPIO_94_SPID_STEN               = 0x00881C0F,

      GPIO_95_GPIO95                  = 0x00881E00,
      GPIO_95_EMIF2_A12               = 0x00881E03,
      GPIO_95_FSIRXG_D1               = 0x00881E0D,
      GPIO_95_CLB_OUTPUTXBAR5         = 0x00881E0E,

      GPIO_96_GPIO96                  = 0x00C60000,
      GPIO_96_EMIF2_DQM1              = 0x00C60003,
      GPIO_96_EQEP1_A                 = 0x00C60005,
      GPIO_96_FSIRXG_CLK              = 0x00C6000D,
      GPIO_96_CLB_OUTPUTXBAR6         = 0x00C6000E,

      GPIO_97_GPIO97                  = 0x00C60200,
      GPIO_97_EMIF2_DQM0              = 0x00C60203,
      GPIO_97_EQEP1_B                 = 0x00C60205,
      GPIO_97_FSIRXH_D0               = 0x00C6020D,
      GPIO_97_CLB_OUTPUTXBAR7         = 0x00C6020E,

      GPIO_98_GPIO98                  = 0x00C60400,
      GPIO_98_EMIF2_A0                = 0x00C60403,
      GPIO_98_EQEP1_STROBE            = 0x00C60405,
      GPIO_98_FSIRXH_D1               = 0x00C6040D,
      GPIO_98_CLB_OUTPUTXBAR8         = 0x00C6040E,

      GPIO_99_GPIO99                  = 0x00C60600,
      GPIO_99_EMIF2_A1                = 0x00C60603,
      GPIO_99_EQEP1_INDEX             = 0x00C60605,
      GPIO_99_FSIRXH_CLK              = 0x00C6060D,

      GPIO_100_GPIO100                = 0x00C60800,
      GPIO_100_EMIF2_A2               = 0x00C60803,
      GPIO_100_EQEP2_A                = 0x00C60805,
      GPIO_100_SPIC_SIMO              = 0x00C60806,
      GPIO_100_ESC_GPI0               = 0x00C6080A,
      GPIO_100_FSITXA_D0              = 0x00C6080D,

      GPIO_101_GPIO101                = 0x00C60A00,
      GPIO_101_EMIF2_A3               = 0x00C60A03,
      GPIO_101_EQEP2_B                = 0x00C60A05,
      GPIO_101_SPIC_SOMI              = 0x00C60A06,
      GPIO_101_ESC_GPI1               = 0x00C60A0A,
      GPIO_101_FSITXA_D1              = 0x00C60A0D,

      GPIO_102_GPIO102                = 0x00C60C00,
      GPIO_102_EMIF2_A4               = 0x00C60C03,
      GPIO_102_EQEP2_STROBE           = 0x00C60C05,
      GPIO_102_SPIC_CLK               = 0x00C60C06,
      GPIO_102_ESC_GPI2               = 0x00C60C0A,
      GPIO_102_FSITXA_CLK             = 0x00C60C0D,

      GPIO_103_GPIO103                = 0x00C60E00,
      GPIO_103_EMIF2_A5               = 0x00C60E03,
      GPIO_103_EQEP2_INDEX            = 0x00C60E05,
      GPIO_103_SPIC_STEN              = 0x00C60E06,
      GPIO_103_ESC_GPI3               = 0x00C60E0A,
      GPIO_103_FSIRXA_D0              = 0x00C60E0D,

      GPIO_104_GPIO104                = 0x00C61000,
      GPIO_104_I2CA_SDA               = 0x00C61001,
      GPIO_104_EMIF2_A6               = 0x00C61003,
      GPIO_104_EQEP3_A                = 0x00C61005,
      GPIO_104_SCID_TX                = 0x00C61006,
      GPIO_104_ESC_GPI4               = 0x00C6100A,
      GPIO_104_CM_I2CA_SDA            = 0x00C6100B,
      GPIO_104_FSIRXA_D1              = 0x00C6100D,

      GPIO_105_GPIO105                = 0x00C61200,
      GPIO_105_I2CA_SCL               = 0x00C61201,
      GPIO_105_EMIF2_A7               = 0x00C61203,
      GPIO_105_EQEP3_B                = 0x00C61205,
      GPIO_105_SCID_RX                = 0x00C61206,
      GPIO_105_ESC_GPI5               = 0x00C6120A,
      GPIO_105_CM_I2CA_SCL            = 0x00C6120B,
      GPIO_105_FSIRXA_CLK             = 0x00C6120D,
      GPIO_105_ENET_MDIO_CLK          = 0x00C6120E,

      GPIO_106_GPIO106                = 0x00C61400,
      GPIO_106_EMIF2_A8               = 0x00C61403,
      GPIO_106_EQEP3_STROBE           = 0x00C61405,
      GPIO_106_SCIC_TX                = 0x00C61406,
      GPIO_106_ESC_GPI6               = 0x00C6140A,
      GPIO_106_FSITXB_D0              = 0x00C6140D,
      GPIO_106_ENET_MDIO_DATA         = 0x00C6140E,

      GPIO_107_GPIO107                = 0x00C61600,
      GPIO_107_EMIF2_A9               = 0x00C61603,
      GPIO_107_EQEP3_INDEX            = 0x00C61605,
      GPIO_107_SCIC_RX                = 0x00C61606,
      GPIO_107_ESC_GPI7               = 0x00C6160A,
      GPIO_107_FSITXB_D1              = 0x00C6160D,
      GPIO_107_ENET_REVMII_MDIO_RST   = 0x00C6160E,

      GPIO_108_GPIO108                = 0x00C61800,
      GPIO_108_EMIF2_A10              = 0x00C61803,
      GPIO_108_ESC_GPI8               = 0x00C6180A,
      GPIO_108_FSITXB_CLK             = 0x00C6180D,
      GPIO_108_ENET_MII_INTR          = 0x00C6180E,

      GPIO_109_GPIO109                = 0x00C61A00,
      GPIO_109_EMIF2_A11              = 0x00C61A03,
      GPIO_109_ESC_GPI9               = 0x00C61A0A,
      GPIO_109_ENET_MII_CRS           = 0x00C61A0E,

      GPIO_110_GPIO110                = 0x00C61C00,
      GPIO_110_EMIF2_WAIT             = 0x00C61C03,
      GPIO_110_ESC_GPI10              = 0x00C61C0A,
      GPIO_110_FSIRXB_D0              = 0x00C61C0D,
      GPIO_110_ENET_MII_COL           = 0x00C61C0E,

      GPIO_111_GPIO111                = 0x00C61E00,
      GPIO_111_EMIF2_BA0              = 0x00C61E03,
      GPIO_111_ESC_GPI11              = 0x00C61E0A,
      GPIO_111_FSIRXB_D1              = 0x00C61E0D,
      GPIO_111_ENET_MII_RX_CLK        = 0x00C61E0E,

      GPIO_112_GPIO112                = 0x00C80000,
      GPIO_112_EMIF2_BA1              = 0x00C80003,
      GPIO_112_ESC_GPI12              = 0x00C8000A,
      GPIO_112_FSIRXB_CLK             = 0x00C8000D,
      GPIO_112_ENET_MII_RX_DV         = 0x00C8000E,

      GPIO_113_GPIO113                = 0x00C80200,
      GPIO_113_EMIF2_CAS              = 0x00C80203,
      GPIO_113_ESC_GPI13              = 0x00C8020A,
      GPIO_113_ENET_MII_RX_ERR        = 0x00C8020E,

      GPIO_114_GPIO114                = 0x00C80400,
      GPIO_114_EMIF2_RAS              = 0x00C80403,
      GPIO_114_ESC_GPI14              = 0x00C8040A,
      GPIO_114_ENET_MII_RX_DATA0      = 0x00C8040E,

      GPIO_115_GPIO115                = 0x00C80600,
      GPIO_115_EMIF2_CS0N             = 0x00C80603,
      GPIO_115_OUTPUTXBAR5            = 0x00C80605,
      GPIO_115_ESC_GPI15              = 0x00C8060A,
      GPIO_115_FSIRXC_D0              = 0x00C8060D,
      GPIO_115_ENET_MII_RX_DATA1      = 0x00C8060E,

      GPIO_116_GPIO116                = 0x00C80800,
      GPIO_116_EMIF2_CS2N             = 0x00C80803,
      GPIO_116_OUTPUTXBAR6            = 0x00C80805,
      GPIO_116_ESC_GPI16              = 0x00C8080A,
      GPIO_116_FSIRXC_D1              = 0x00C8080D,
      GPIO_116_ENET_MII_RX_DATA2      = 0x00C8080E,

      GPIO_117_GPIO117                = 0x00C80A00,
      GPIO_117_EMIF2_SDCKE            = 0x00C80A03,
      GPIO_117_ESC_GPI17              = 0x00C80A0A,
      GPIO_117_FSIRXC_CLK             = 0x00C80A0D,
      GPIO_117_ENET_MII_RX_DATA3      = 0x00C80A0E,

      GPIO_118_GPIO118                = 0x00C80C00,
      GPIO_118_EMIF2_CLK              = 0x00C80C03,
      GPIO_118_ESC_GPI18              = 0x00C80C0A,
      GPIO_118_FSIRXD_D0              = 0x00C80C0D,
      GPIO_118_ENET_MII_TX_EN         = 0x00C80C0E,

      GPIO_119_GPIO119                = 0x00C80E00,
      GPIO_119_EMIF2_RNW              = 0x00C80E03,
      GPIO_119_ESC_GPI19              = 0x00C80E0A,
      GPIO_119_FSIRXD_D1              = 0x00C80E0D,
      GPIO_119_ENET_MII_TX_ERR        = 0x00C80E0E,

      GPIO_120_GPIO120                = 0x00C81000,
      GPIO_120_EMIF2_WEN              = 0x00C81003,
      GPIO_120_ESC_GPI20              = 0x00C8100A,
      GPIO_120_FSIRXD_CLK             = 0x00C8100D,
      GPIO_120_ENET_MII_TX_CLK        = 0x00C8100E,

      GPIO_121_GPIO121                = 0x00C81200,
      GPIO_121_EMIF2_OEN              = 0x00C81203,
      GPIO_121_ESC_GPI21              = 0x00C8120A,
      GPIO_121_FSIRXE_D0              = 0x00C8120D,
      GPIO_121_ENET_MII_TX_DATA0      = 0x00C8120E,

      GPIO_122_GPIO122                = 0x00C81400,
      GPIO_122_EMIF2_D15              = 0x00C81403,
      GPIO_122_SPIC_SIMO              = 0x00C81406,
      GPIO_122_SD1_D1                 = 0x00C81407,
      GPIO_122_ESC_GPI22              = 0x00C8140A,
      GPIO_122_ENET_MII_TX_DATA1      = 0x00C8140E,

      GPIO_123_GPIO123                = 0x00C81600,
      GPIO_123_EMIF2_D14              = 0x00C81603,
      GPIO_123_SPIC_SOMI              = 0x00C81606,
      GPIO_123_SD1_C1                 = 0x00C81607,
      GPIO_123_ESC_GPI23              = 0x00C8160A,
      GPIO_123_ENET_MII_TX_DATA2      = 0x00C8160E,

      GPIO_124_GPIO124                = 0x00C81800,
      GPIO_124_EMIF2_D13              = 0x00C81803,
      GPIO_124_SPIC_CLK               = 0x00C81806,
      GPIO_124_SD1_D2                 = 0x00C81807,
      GPIO_124_ESC_GPI24              = 0x00C8180A,
      GPIO_124_ENET_MII_TX_DATA3      = 0x00C8180E,

      GPIO_125_GPIO125                = 0x00C81A00,
      GPIO_125_EMIF2_D12              = 0x00C81A03,
      GPIO_125_SPIC_STEN              = 0x00C81A06,
      GPIO_125_SD1_C2                 = 0x00C81A07,
      GPIO_125_ESC_GPI25              = 0x00C81A0A,
      GPIO_125_FSIRXE_D1              = 0x00C81A0D,
      GPIO_125_ESC_LATCH0             = 0x00C81A0E,

      GPIO_126_GPIO126                = 0x00C81C00,
      GPIO_126_EMIF2_D11              = 0x00C81C03,
      GPIO_126_SD1_D3                 = 0x00C81C07,
      GPIO_126_ESC_GPI26              = 0x00C81C0A,
      GPIO_126_FSIRXE_CLK             = 0x00C81C0D,
      GPIO_126_ESC_LATCH1             = 0x00C81C0E,

      GPIO_127_GPIO127                = 0x00C81E00,
      GPIO_127_EMIF2_D10              = 0x00C81E03,
      GPIO_127_SD1_C3                 = 0x00C81E07,
      GPIO_127_ESC_GPI27              = 0x00C81E0A,
      GPIO_127_ESC_SYNC0              = 0x00C81E0E,

      GPIO_128_GPIO128                = 0x01060000,
      GPIO_128_EMIF2_D9               = 0x01060003,
      GPIO_128_SD1_D4                 = 0x01060007,
      GPIO_128_ESC_GPI28              = 0x0106000A,
      GPIO_128_ESC_SYNC1              = 0x0106000E,

      GPIO_129_GPIO129                = 0x01060200,
      GPIO_129_EMIF2_D8               = 0x01060203,
      GPIO_129_SD1_C4                 = 0x01060207,
      GPIO_129_ESC_GPI29              = 0x0106020A,
      GPIO_129_ESC_TX1_ENA            = 0x0106020E,

      GPIO_130_GPIO130                = 0x01060400,
      GPIO_130_EMIF2_D7               = 0x01060403,
      GPIO_130_SD2_D1                 = 0x01060407,
      GPIO_130_ESC_GPI30              = 0x0106040A,
      GPIO_130_ESC_TX1_CLK            = 0x0106040E,

      GPIO_131_GPIO131                = 0x01060600,
      GPIO_131_EMIF2_D6               = 0x01060603,
      GPIO_131_SD2_C1                 = 0x01060607,
      GPIO_131_ESC_GPI31              = 0x0106060A,
      GPIO_131_ESC_TX1_DATA0          = 0x0106060E,

      GPIO_132_GPIO132                = 0x01060800,
      GPIO_132_EMIF2_D5               = 0x01060803,
      GPIO_132_SD2_D2                 = 0x01060807,
      GPIO_132_ESC_GPO0               = 0x0106080A,
      GPIO_132_ESC_TX1_DATA1          = 0x0106080E,

      GPIO_133_GPIO133                = 0x01060A00,
      GPIO_133_SD2_C2                 = 0x01060A07,

      GPIO_134_GPIO134                = 0x01060C00,
      GPIO_134_EMIF2_D4               = 0x01060C03,
      GPIO_134_SD2_D3                 = 0x01060C07,
      GPIO_134_ESC_GPO1               = 0x01060C0A,
      GPIO_134_ESC_TX1_DATA2          = 0x01060C0E,

      GPIO_135_GPIO135                = 0x01060E00,
      GPIO_135_EMIF2_D3               = 0x01060E03,
      GPIO_135_SCIA_TX                = 0x01060E06,
      GPIO_135_SD2_C3                 = 0x01060E07,
      GPIO_135_ESC_GPO2               = 0x01060E0A,
      GPIO_135_ESC_TX1_DATA3          = 0x01060E0E,

      GPIO_136_GPIO136                = 0x01061000,
      GPIO_136_EMIF2_D2               = 0x01061003,
      GPIO_136_SCIA_RX                = 0x01061006,
      GPIO_136_SD2_D4                 = 0x01061007,
      GPIO_136_ESC_GPO3               = 0x0106100A,
      GPIO_136_ESC_RX1_DV             = 0x0106100E,

      GPIO_137_GPIO137                = 0x01061200,
      GPIO_137_EPWM13A                = 0x01061201,
      GPIO_137_EMIF2_D1               = 0x01061203,
      GPIO_137_SCIB_TX                = 0x01061206,
      GPIO_137_SD2_C4                 = 0x01061207,
      GPIO_137_ESC_GPO4               = 0x0106120A,
      GPIO_137_ESC_RX1_CLK            = 0x0106120E,

      GPIO_138_GPIO138                = 0x01061400,
      GPIO_138_EPWM13B                = 0x01061401,
      GPIO_138_EMIF2_D0               = 0x01061403,
      GPIO_138_SCIB_RX                = 0x01061406,
      GPIO_138_ESC_GPO5               = 0x0106140A,
      GPIO_138_ESC_RX1_ERR            = 0x0106140E,

      GPIO_139_GPIO139                = 0x01061600,
      GPIO_139_EPWM14A                = 0x01061601,
      GPIO_139_SCIC_RX                = 0x01061606,
      GPIO_139_ESC_GPO6               = 0x0106160A,
      GPIO_139_ESC_RX1_DATA0          = 0x0106160E,

      GPIO_140_GPIO140                = 0x01061800,
      GPIO_140_EPWM14B                = 0x01061801,
      GPIO_140_SCIC_TX                = 0x01061806,
      GPIO_140_ESC_GPO7               = 0x0106180A,
      GPIO_140_ESC_RX1_DATA1          = 0x0106180E,

      GPIO_141_GPIO141                = 0x01061A00,
      GPIO_141_EPWM15A                = 0x01061A01,
      GPIO_141_SCID_RX                = 0x01061A06,
      GPIO_141_ESC_GPO8               = 0x01061A0A,
      GPIO_141_ESC_RX1_DATA2          = 0x01061A0E,

      GPIO_142_GPIO142                = 0x01061C00,
      GPIO_142_EPWM15B                = 0x01061C01,
      GPIO_142_SCID_TX                = 0x01061C06,
      GPIO_142_ESC_GPO9               = 0x01061C0A,
      GPIO_142_ESC_RX1_DATA3          = 0x01061C0E,

      GPIO_143_GPIO143                = 0x01061E00,
      GPIO_143_EPWM16A                = 0x01061E01,
      GPIO_143_ESC_GPO10              = 0x01061E0A,
      GPIO_143_ESC_LED_LINK0_ACTIVE   = 0x01061E0E,

      GPIO_144_GPIO144                = 0x01080000,
      GPIO_144_EPWM16B                = 0x01080001,
      GPIO_144_ESC_GPO11              = 0x0108000A,
      GPIO_144_ESC_LED_LINK1_ACTIVE   = 0x0108000E,

      GPIO_145_GPIO145                = 0x01080200,
      GPIO_145_EPWM1A                 = 0x01080201,
      GPIO_145_ESC_GPO12              = 0x0108020A,
      GPIO_145_ESC_LED_ERR            = 0x0108020E,

      GPIO_146_GPIO146                = 0x01080400,
      GPIO_146_EPWM1B                 = 0x01080401,
      GPIO_146_ESC_GPO13              = 0x0108040A,
      GPIO_146_ESC_LED_RUN            = 0x0108040E,

      GPIO_147_GPIO147                = 0x01080600,
      GPIO_147_EPWM2A                 = 0x01080601,
      GPIO_147_ESC_GPO14              = 0x0108060A,
      GPIO_147_ESC_LED_STATE_RUN      = 0x0108060E,

      GPIO_148_GPIO148                = 0x01080800,
      GPIO_148_EPWM2B                 = 0x01080801,
      GPIO_148_ESC_GPO15              = 0x0108080A,
      GPIO_148_ESC_PHY0_LINKSTATUS    = 0x0108080E,

      GPIO_149_GPIO149                = 0x01080A00,
      GPIO_149_EPWM3A                 = 0x01080A01,
      GPIO_149_ESC_GPO16              = 0x01080A0A,
      GPIO_149_ESC_PHY1_LINKSTATUS    = 0x01080A0E,

      GPIO_150_GPIO150                = 0x01080C00,
      GPIO_150_EPWM3B                 = 0x01080C01,
      GPIO_150_ESC_GPO17              = 0x01080C0A,
      GPIO_150_ESC_I2C_SDA            = 0x01080C0E,

      GPIO_151_GPIO151                = 0x01080E00,
      GPIO_151_EPWM4A                 = 0x01080E01,
      GPIO_151_ESC_GPO18              = 0x01080E0A,
      GPIO_151_ESC_I2C_SCL            = 0x01080E0E,

      GPIO_152_GPIO152                = 0x01081000,
      GPIO_152_EPWM4B                 = 0x01081001,
      GPIO_152_ESC_GPO19              = 0x0108100A,
      GPIO_152_ESC_MDIO_CLK           = 0x0108100E,

      GPIO_153_GPIO153                = 0x01081200,
      GPIO_153_EPWM5A                 = 0x01081201,
      GPIO_153_ESC_GPO20              = 0x0108120A,
      GPIO_153_ESC_MDIO_DATA          = 0x0108120E,

      GPIO_154_GPIO154                = 0x01081400,
      GPIO_154_EPWM5B                 = 0x01081401,
      GPIO_154_ESC_GPO21              = 0x0108140A,
      GPIO_154_ESC_PHY_CLK            = 0x0108140E,

      GPIO_155_GPIO155                = 0x01081600,
      GPIO_155_EPWM6A                 = 0x01081601,
      GPIO_155_ESC_GPO22              = 0x0108160A,
      GPIO_155_ESC_PHY_RESETN         = 0x0108160E,

      GPIO_156_GPIO156                = 0x01081800,
      GPIO_156_EPWM6B                 = 0x01081801,
      GPIO_156_ESC_GPO23              = 0x0108180A,
      GPIO_156_ESC_TX0_ENA            = 0x0108180E,

      GPIO_157_GPIO157                = 0x01081A00,
      GPIO_157_EPWM7A                 = 0x01081A01,
      GPIO_157_ESC_GPO24              = 0x01081A0A,
      GPIO_157_ESC_TX0_CLK            = 0x01081A0E,

      GPIO_158_GPIO158                = 0x01081C00,
      GPIO_158_EPWM7B                 = 0x01081C01,
      GPIO_158_ESC_GPO25              = 0x01081C0A,
      GPIO_158_ESC_TX0_DATA0          = 0x01081C0E,

      GPIO_159_GPIO159                = 0x01081E00,
      GPIO_159_EPWM8A                 = 0x01081E01,
      GPIO_159_ESC_GPO26              = 0x01081E0A,
      GPIO_159_ESC_TX0_DATA1          = 0x01081E0E,

      GPIO_160_GPIO160                = 0x01460000,
      GPIO_160_EPWM8B                 = 0x01460001,
      GPIO_160_ESC_GPO27              = 0x0146000A,
      GPIO_160_ESC_TX0_DATA2          = 0x0146000E,

      GPIO_161_GPIO161                = 0x01460200,
      GPIO_161_EPWM9A                 = 0x01460201,
      GPIO_161_ESC_GPO28              = 0x0146020A,
      GPIO_161_ESC_TX0_DATA3          = 0x0146020E,

      GPIO_162_GPIO162                = 0x01460400,
      GPIO_162_EPWM9B                 = 0x01460401,
      GPIO_162_ESC_GPO29              = 0x0146040A,
      GPIO_162_ESC_RX0_DV             = 0x0146040E,

      GPIO_163_GPIO163                = 0x01460600,
      GPIO_163_EPWM10A                = 0x01460601,
      GPIO_163_ESC_GPO30              = 0x0146060A,
      GPIO_163_ESC_RX0_CLK            = 0x0146060E,

      GPIO_164_GPIO164                = 0x01460800,
      GPIO_164_EPWM10B                = 0x01460801,
      GPIO_164_ESC_GPO31              = 0x0146080A,
      GPIO_164_ESC_RX0_ERR            = 0x0146080E,

      GPIO_165_GPIO165                = 0x01460A00,
      GPIO_165_EPWM11A                = 0x01460A01,
      GPIO_165_MDXA                   = 0x01460A0A,
      GPIO_165_ESC_RX0_DATA0          = 0x01460A0E,

      GPIO_166_GPIO166                = 0x01460C00,
      GPIO_166_EPWM11B                = 0x01460C01,
      GPIO_166_MDRA                   = 0x01460C0A,
      GPIO_166_ESC_RX0_DATA1          = 0x01460C0E,

      GPIO_167_GPIO167                = 0x01460E00,
      GPIO_167_EPWM12A                = 0x01460E01,
      GPIO_167_MCLKXA                 = 0x01460E0A,
      GPIO_167_ESC_RX0_DATA2          = 0x01460E0E,

      GPIO_168_GPIO168                = 0x01461000,
      GPIO_168_EPWM12B                = 0x01461001,
      GPIO_168_MFSXA                  = 0x0146100A,
      GPIO_168_ESC_RX0_DATA3          = 0x0146100E,
	}
	return pin_map[pin]
end

return P
