local P = {}

function P.getPinSettings(pin)
  local pin_map = {
      GPIO_0_GPIO0                    = 0x000C0000,
      GPIO_0_EPWM1_A                  = 0x000C0001,
      GPIO_0_EMIF1_A13                = 0x000C0002,
      GPIO_0_EMIF1_D0                 = 0x000C0003,
      GPIO_0_MCAND_TX                 = 0x000C0005,
      GPIO_0_I2CA_SDA                 = 0x000C0006,
      GPIO_0_UARTE_TX                 = 0x000C0007,
      GPIO_0_OUTPUTXBAR9              = 0x000C0009,
      GPIO_0_ESC_TX0_DATA0            = 0x000C000A,
      GPIO_0_ESC_GPI0                 = 0x000C000B,
      GPIO_0_FSITXA_D0                = 0x000C000D,
      
      GPIO_1_GPIO1                    = 0x000C0200,
      GPIO_1_EPWM1_B                  = 0x000C0201,
      GPIO_1_EMIF1_A14                = 0x000C0202,
      GPIO_1_EMIF1_D3                 = 0x000C0203,
      GPIO_1_MCAND_RX                 = 0x000C0205,
      GPIO_1_I2CA_SCL                 = 0x000C0206,
      GPIO_1_UARTE_RX                 = 0x000C0207,
      GPIO_1_OUTPUTXBAR10             = 0x000C0209,
      GPIO_1_ESC_TX1_DATA0            = 0x000C020A,
      GPIO_1_ESC_GPI1                 = 0x000C020B,
      GPIO_1_FSITXA_D1                = 0x000C020D,
      
      GPIO_2_GPIO2                    = 0x000C0400,
      GPIO_2_EPWM2_A                  = 0x000C0401,
      GPIO_2_EMIF1_A15                = 0x000C0402,
      GPIO_2_EMIF1_D4                 = 0x000C0403,
      GPIO_2_UARTA_TX                 = 0x000C0405,
      GPIO_2_I2CB_SDA                 = 0x000C0406,
      GPIO_2_MCANF_TX                 = 0x000C0407,
      GPIO_2_OUTPUTXBAR1              = 0x000C0409,
      GPIO_2_ESC_RX1_ERR              = 0x000C040A,
      GPIO_2_ESC_GPI2                 = 0x000C040B,
      GPIO_2_FSITXA_CLK               = 0x000C040D,
      
      GPIO_3_GPIO3                    = 0x000C0600,
      GPIO_3_EPWM2_B                  = 0x000C0601,
      GPIO_3_EMIF1_A16                = 0x000C0602,
      GPIO_3_EMIF1_D5                 = 0x000C0603,
      GPIO_3_UARTA_RX                 = 0x000C0605,
      GPIO_3_I2CB_SCL                 = 0x000C0606,
      GPIO_3_MCANF_RX                 = 0x000C0607,
      GPIO_3_OUTPUTXBAR2              = 0x000C0609,
      GPIO_3_ESC_GPI3                 = 0x000C060B,
      GPIO_3_FSIRXA_D0                = 0x000C060D,
      
      GPIO_4_GPIO4                    = 0x000C0800,
      GPIO_4_EPWM3_A                  = 0x000C0801,
      GPIO_4_EMIF1_A17                = 0x000C0802,
      GPIO_4_EMIF1_D9                 = 0x000C0803,
      GPIO_4_MCANC_TX                 = 0x000C0805,
      GPIO_4_UARTF_TX                 = 0x000C0807,
      GPIO_4_OUTPUTXBAR3              = 0x000C0809,
      GPIO_4_ESC_GPI4                 = 0x000C080B,
      GPIO_4_FSIRXA_D1                = 0x000C080D,
      GPIO_4_ERRORSTS                 = 0x000C080F,
      
      GPIO_5_GPIO5                    = 0x000C0A00,
      GPIO_5_EPWM3_B                  = 0x000C0A01,
      GPIO_5_EMIF1_A18                = 0x000C0A02,
      GPIO_5_EMIF1_D10                = 0x000C0A03,
      GPIO_5_MCANC_RX                 = 0x000C0A05,
      GPIO_5_UARTF_RX                 = 0x000C0A07,
      GPIO_5_OUTPUTXBAR11             = 0x000C0A09,
      GPIO_5_OUTPUTXBAR3              = 0x000C0A0A,
      GPIO_5_ESC_GPI5                 = 0x000C0A0B,
      GPIO_5_FSIRXA_CLK               = 0x000C0A0D,
      
      GPIO_6_GPIO6                    = 0x000C0C00,
      GPIO_6_EPWM4_A                  = 0x000C0C01,
      GPIO_6_EMIF1_DQM0               = 0x000C0C02,
      GPIO_6_EMIF1_CLK                = 0x000C0C03,
      GPIO_6_MCANB_TX                 = 0x000C0C05,
      GPIO_6_LINA_TX                  = 0x000C0C06,
      GPIO_6_OUTPUTXBAR4              = 0x000C0C09,
      GPIO_6_SYNCOUT                  = 0x000C0C0A,
      GPIO_6_ESC_GPI6                 = 0x000C0C0B,
      GPIO_6_FSITXB_D0                = 0x000C0C0D,
      
      GPIO_7_GPIO7                    = 0x000C0E00,
      GPIO_7_EPWM4_B                  = 0x000C0E01,
      GPIO_7_EMIF1_DQM1               = 0x000C0E02,
      GPIO_7_EMIF1_CAS                = 0x000C0E03,
      GPIO_7_MCANB_RX                 = 0x000C0E05,
      GPIO_7_LINA_RX                  = 0x000C0E06,
      GPIO_7_OUTPUTXBAR5              = 0x000C0E09,
      GPIO_7_ESC_GPI7                 = 0x000C0E0B,
      GPIO_7_FSITXB_D1                = 0x000C0E0D,
      
      GPIO_8_GPIO8                    = 0x000C1000,
      GPIO_8_EPWM5_A                  = 0x000C1001,
      GPIO_8_EMIF1_RAS                = 0x000C1002,
      GPIO_8_EPWM4_B                  = 0x000C1003,
      GPIO_8_MCANC_TX                 = 0x000C1005,
      GPIO_8_SPIE_PICO                = 0x000C1006,
      GPIO_8_UARTD_TX                 = 0x000C1007,
      GPIO_8_OUTPUTXBAR12             = 0x000C1009,
      GPIO_8_ADCSOCAO                 = 0x000C100A,
      GPIO_8_ESC_GPO0                 = 0x000C100B,
      GPIO_8_FSITXB_CLK               = 0x000C100D,
      GPIO_8_FSITXA_D1                = 0x000C100E,
      GPIO_8_FSIRXA_D0                = 0x000C100F,
      
      GPIO_9_GPIO9                    = 0x000C1200,
      GPIO_9_EPWM5_B                  = 0x000C1201,
      GPIO_9_EMIF1_D11                = 0x000C1202,
      GPIO_9_SPIE_POCI                = 0x000C1206,
      GPIO_9_UARTD_RX                 = 0x000C1207,
      GPIO_9_OUTPUTXBAR6              = 0x000C1209,
      GPIO_9_ESC_TX0_CLK              = 0x000C120A,
      GPIO_9_ESC_GPO1                 = 0x000C120B,
      GPIO_9_FSIRXB_D0                = 0x000C120D,
      GPIO_9_FSITXA_D0                = 0x000C120E,
      GPIO_9_FSIRXA_CLK               = 0x000C120F,
      
      GPIO_10_GPIO10                  = 0x000C1400,
      GPIO_10_EPWM8_A                 = 0x000C1401,
      GPIO_10_PMBUSA_SCL              = 0x000C1402,
      GPIO_10_ADCSOCBO                = 0x000C1403,
      GPIO_10_MCANC_RX                = 0x000C1405,
      GPIO_10_UARTC_TX                = 0x000C1406,
      GPIO_10_I2CA_SCL                = 0x000C1407,
      GPIO_10_SENT2                   = 0x000C1409,
      GPIO_10_ESC_GPI19               = 0x000C140D,
      GPIO_10_ADCA_EXTMUXSEL2         = 0x000C140E,
      GPIO_10_OUTPUTXBAR13            = 0x000C140F,
      
      GPIO_11_GPIO11                  = 0x000C1600,
      GPIO_11_EPWM6_B                 = 0x000C1601,
      GPIO_11_EMIF1_D15               = 0x000C1602,
      GPIO_11_EPWM7_B                 = 0x000C1603,
      GPIO_11_SPIE_PTE                = 0x000C1606,
      GPIO_11_SD4_D1                  = 0x000C1607,
      GPIO_11_PMBUSA_ALERT            = 0x000C1609,
      GPIO_11_ESC_TX0_DATA1           = 0x000C160A,
      GPIO_11_ESC_GPO3                = 0x000C160B,
      GPIO_11_FSIRXB_CLK              = 0x000C160D,
      GPIO_11_FSIRXA_D1               = 0x000C160E,
      GPIO_11_OUTPUTXBAR7             = 0x000C160F,
      
      GPIO_12_GPIO12                  = 0x000C1800,
      GPIO_12_EPWM7_A                 = 0x000C1801,
      GPIO_12_EMIF1_A1                = 0x000C1802,
      GPIO_12_ADCSOCAO                = 0x000C1803,
      GPIO_12_SPIE_CLK                = 0x000C1806,
      GPIO_12_SD4_C2                  = 0x000C1807,
      GPIO_12_PMBUSA_CTL              = 0x000C1809,
      GPIO_12_ESC_TX0_DATA2           = 0x000C180A,
      GPIO_12_ESC_GPO4                = 0x000C180B,
      GPIO_12_FSIRXC_D0               = 0x000C180D,
      GPIO_12_FSIRXA_D0               = 0x000C180E,
      GPIO_12_OUTPUTXBAR14            = 0x000C180F,
      
      GPIO_13_GPIO13                  = 0x000C1A00,
      GPIO_13_EPWM7_B                 = 0x000C1A01,
      GPIO_13_EMIF1_CS0N              = 0x000C1A02,
      GPIO_13_EMIF1_D9                = 0x000C1A03,
      GPIO_13_UARTC_RX                = 0x000C1A06,
      GPIO_13_SD4_D2                  = 0x000C1A07,
      GPIO_13_PMBUSA_SDA              = 0x000C1A09,
      GPIO_13_ESC_TX0_DATA3           = 0x000C1A0A,
      GPIO_13_ESC_GPO5                = 0x000C1A0B,
      GPIO_13_FSIRXC_D1               = 0x000C1A0D,
      GPIO_13_FSIRXA_CLK              = 0x000C1A0E,
      GPIO_13_OUTPUTXBAR15            = 0x000C1A0F,
      
      GPIO_14_GPIO14                  = 0x000C1C00,
      GPIO_14_EPWM6_A                 = 0x000C1C01,
      GPIO_14_EMIF1_D17               = 0x000C1C02,
      GPIO_14_EPWM18_A                = 0x000C1C03,
      GPIO_14_EMIF1_D13               = 0x000C1C05,
      GPIO_14_LINA_TX                 = 0x000C1C06,
      GPIO_14_OUTPUTXBAR3             = 0x000C1C07,
      GPIO_14_PMBUSA_SCL              = 0x000C1C09,
      GPIO_14_ESC_PHY1_LINKSTATUS     = 0x000C1C0A,
      GPIO_14_ESC_GPO6                = 0x000C1C0B,
      GPIO_14_FSIRXC_CLK              = 0x000C1C0D,
      GPIO_14_SD4_C1                  = 0x000C1C0E,
      GPIO_14_OUTPUTXBAR8             = 0x000C1C0F,
      
      GPIO_15_GPIO15                  = 0x000C1E00,
      GPIO_15_EPWM8_B                 = 0x000C1E01,
      GPIO_15_PMBUSA_CTL              = 0x000C1E03,
      GPIO_15_I2CA_SDA                = 0x000C1E05,
      GPIO_15_LINA_RX                 = 0x000C1E06,
      GPIO_15_OUTPUTXBAR4             = 0x000C1E07,
      GPIO_15_SENT1                   = 0x000C1E09,
      GPIO_15_ESC_GPO7                = 0x000C1E0A,
      GPIO_15_ESC_GPI20               = 0x000C1E0D,
      GPIO_15_ADCA_EXTMUXSEL3         = 0x000C1E0E,
      GPIO_15_OUTPUTXBAR16            = 0x000C1E0F,
      
      GPIO_16_GPIO16                  = 0x00100000,
      GPIO_16_EPWM9_A                 = 0x00100001,
      GPIO_16_EMIF1_D29               = 0x00100002,
      GPIO_16_EMIF1_BA0               = 0x00100003,
      GPIO_16_SPIA_PICO               = 0x00100005,
      GPIO_16_MCAND_TX                = 0x00100007,
      GPIO_16_ESC_RX1_CLK             = 0x0010000A,
      GPIO_16_SD1_D1                  = 0x0010000B,
      GPIO_16_FSIRXD_D1               = 0x0010000D,
      GPIO_16_FSIRXC_CLK              = 0x0010000E,
      GPIO_16_OUTPUTXBAR7             = 0x0010000F,
      
      GPIO_17_GPIO17                  = 0x00100200,
      GPIO_17_EPWM9_B                 = 0x00100201,
      GPIO_17_EMIF1_DQM3              = 0x00100202,
      GPIO_17_EMIF1_BA1               = 0x00100203,
      GPIO_17_SPIA_POCI               = 0x00100205,
      GPIO_17_MCAND_RX                = 0x00100207,
      GPIO_17_ESC_RX1_DV              = 0x0010020A,
      GPIO_17_SD1_C1                  = 0x0010020B,
      GPIO_17_FSIRXD_CLK              = 0x0010020D,
      GPIO_17_UARTC_TX                = 0x0010020E,
      GPIO_17_OUTPUTXBAR8             = 0x0010020F,
      
      GPIO_18_GPIO18                  = 0x00100400,
      GPIO_18_EPWM15_A                = 0x00100401,
      GPIO_18_PMBUSA_ALERT            = 0x00100403,
      GPIO_18_I2CA_SCL                = 0x00100405,
      GPIO_18_UARTC_RX                = 0x00100406,
      GPIO_18_SENT4                   = 0x00100409,
      GPIO_18_ESC_GPI21               = 0x0010040D,
      GPIO_18_ADCB_EXTMUXSEL0         = 0x0010040E,
      
      GPIO_19_GPIO19                  = 0x00100600,
      GPIO_19_EPWM10_B                = 0x00100601,
      GPIO_19_EMIF1_CS3N              = 0x00100602,
      GPIO_19_ADCSOCBO                = 0x00100603,
      GPIO_19_SPIA_PTE                = 0x00100605,
      GPIO_19_UARTE_RX                = 0x00100606,
      GPIO_19_MCANC_TX                = 0x00100607,
      GPIO_19_PMBUSA_ALERT            = 0x00100609,
      GPIO_19_ESC_TX1_DATA3           = 0x0010060A,
      GPIO_19_SD1_C2                  = 0x0010060B,
      
      GPIO_20_GPIO20                  = 0x00100800,
      GPIO_20_EPWM11_A                = 0x00100801,
      GPIO_20_EMIF1_BA0               = 0x00100802,
      GPIO_20_EMIF1_DQM2              = 0x00100803,
      GPIO_20_SPIC_PICO               = 0x00100806,
      GPIO_20_MCANB_RX                = 0x00100807,
      GPIO_20_ESC_TX1_DATA2           = 0x0010080A,
      GPIO_20_SD1_D3                  = 0x0010080B,
      
      GPIO_21_GPIO21                  = 0x00100A00,
      GPIO_21_EPWM11_B                = 0x00100A01,
      GPIO_21_EMIF1_BA1               = 0x00100A02,
      GPIO_21_SPIC_POCI               = 0x00100A06,
      GPIO_21_MCANB_TX                = 0x00100A07,
      GPIO_21_ESC_TX1_DATA1           = 0x00100A0A,
      GPIO_21_SD1_C3                  = 0x00100A0B,
      
      GPIO_22_GPIO22                  = 0x00100C00,
      GPIO_22_EPWM12_A                = 0x00100C01,
      GPIO_22_PMBUSA_SDA              = 0x00100C03,
      GPIO_22_I2CB_SDA                = 0x00100C05,
      GPIO_22_UARTB_TX                = 0x00100C06,
      GPIO_22_MCANC_TX                = 0x00100C07,
      GPIO_22_SENT5                   = 0x00100C09,
      GPIO_22_ESC_GPO2                = 0x00100C0A,
      GPIO_22_ESC_GPI22               = 0x00100C0D,
      GPIO_22_ADCB_EXTMUXSEL1         = 0x00100C0E,
      
      GPIO_23_GPIO23                  = 0x00100E00,
      GPIO_23_EPWM12_B                = 0x00100E01,
      GPIO_23_PMBUSA_SCL              = 0x00100E03,
      GPIO_23_I2CB_SCL                = 0x00100E05,
      GPIO_23_UARTB_RX                = 0x00100E06,
      GPIO_23_MCANC_RX                = 0x00100E07,
      GPIO_23_SENT6                   = 0x00100E09,
      GPIO_23_ESC_PHY_RESETN          = 0x00100E0A,
      GPIO_23_ESC_GPI23               = 0x00100E0D,
      GPIO_23_ADCC_EXTMUXSEL0         = 0x00100E0E,
      
      GPIO_24_GPIO24                  = 0x00101000,
      GPIO_24_EPWM13_A                = 0x00101001,
      GPIO_24_EMIF1_DQM0              = 0x00101002,
      GPIO_24_SPIB_PICO               = 0x00101005,
      GPIO_24_LINB_TX                 = 0x00101006,
      GPIO_24_MCANE_TX                = 0x00101007,
      GPIO_24_ESC_RX0_CLK             = 0x0010100A,
      GPIO_24_SD2_D1                  = 0x0010100B,
      GPIO_24_ESC_GPI24               = 0x0010100D,
      GPIO_24_EPWM2_A                 = 0x0010100E,
      GPIO_24_OUTPUTXBAR1             = 0x0010100F,
      
      GPIO_25_GPIO25                  = 0x00101200,
      GPIO_25_EPWM13_B                = 0x00101201,
      GPIO_25_EMIF1_DQM1              = 0x00101202,
      GPIO_25_SPIB_POCI               = 0x00101205,
      GPIO_25_LINB_RX                 = 0x00101206,
      GPIO_25_MCANE_RX                = 0x00101207,
      GPIO_25_PMBUSA_SDA              = 0x00101209,
      GPIO_25_ESC_RX0_DV              = 0x0010120A,
      GPIO_25_SD2_C1                  = 0x0010120B,
      GPIO_25_FSITXA_D1               = 0x0010120D,
      GPIO_25_EPWM2_B                 = 0x0010120E,
      GPIO_25_OUTPUTXBAR2             = 0x0010120F,
      
      GPIO_26_GPIO26                  = 0x00101400,
      GPIO_26_EPWM14_A                = 0x00101401,
      GPIO_26_EMIF1_DQM2              = 0x00101402,
      GPIO_26_SPIB_CLK                = 0x00101405,
      GPIO_26_UARTE_TX                = 0x00101406,
      GPIO_26_MCANE_TX                = 0x00101407,
      GPIO_26_PMBUSA_CTL              = 0x00101409,
      GPIO_26_ESC_RX0_ERR             = 0x0010140A,
      GPIO_26_SD2_D2                  = 0x0010140B,
      GPIO_26_FSITXA_D0               = 0x0010140D,
      GPIO_26_ESC_MDIO_CLK            = 0x0010140E,
      GPIO_26_OUTPUTXBAR3             = 0x0010140F,
      
      GPIO_27_GPIO27                  = 0x00101600,
      GPIO_27_EPWM14_B                = 0x00101601,
      GPIO_27_EMIF1_DQM3              = 0x00101602,
      GPIO_27_SPIB_PTE                = 0x00101605,
      GPIO_27_UARTA_TX                = 0x00101606,
      GPIO_27_EPWM4_A                 = 0x00101609,
      GPIO_27_ESC_RX0_DATA0           = 0x0010160A,
      GPIO_27_SD2_C2                  = 0x0010160B,
      GPIO_27_FSITXA_CLK              = 0x0010160D,
      GPIO_27_ESC_MDIO_DATA           = 0x0010160E,
      GPIO_27_OUTPUTXBAR4             = 0x0010160F,
      
      GPIO_28_GPIO28                  = 0x00101800,
      GPIO_28_EPWM15_A                = 0x00101801,
      GPIO_28_EMIF1_CS4N              = 0x00101802,
      GPIO_28_EMIF1_CS2N              = 0x00101803,
      GPIO_28_UARTA_RX                = 0x00101806,
      GPIO_28_EPWM4_B                 = 0x00101809,
      GPIO_28_ESC_RX0_DATA1           = 0x0010180A,
      GPIO_28_SD2_D3                  = 0x0010180B,
      GPIO_28_OUTPUTXBAR5             = 0x0010180F,
      
      GPIO_29_GPIO29                  = 0x00101A00,
      GPIO_29_EPWM15_B                = 0x00101A01,
      GPIO_29_PMBUSA_SDA              = 0x00101A02,
      GPIO_29_UARTE_RX                = 0x00101A06,
      GPIO_29_I2CA_SDA                = 0x00101A07,
      GPIO_29_SENT3                   = 0x00101A09,
      GPIO_29_ESC_LATCH0              = 0x00101A0A,
      GPIO_29_ESC_I2C_SDA             = 0x00101A0D,
      GPIO_29_ADCC_EXTMUXSEL1         = 0x00101A0E,
      GPIO_29_OUTPUTXBAR6             = 0x00101A0F,
      
      GPIO_30_GPIO30                  = 0x00101C00,
      GPIO_30_EPWM16_A                = 0x00101C01,
      GPIO_30_EMIF1_CLK               = 0x00101C02,
      GPIO_30_EMIF1_CS4N              = 0x00101C03,
      GPIO_30_MCANC_RX                = 0x00101C05,
      GPIO_30_SPID_PICO               = 0x00101C06,
      GPIO_30_EMIF1_A12               = 0x00101C07,
      GPIO_30_ESC_LATCH1              = 0x00101C0A,
      GPIO_30_SD2_D4                  = 0x00101C0B,
      GPIO_30_ESC_I2C_SCL             = 0x00101C0D,
      GPIO_30_ESC_SYNC1               = 0x00101C0E,
      GPIO_30_OUTPUTXBAR7             = 0x00101C0F,
      
      GPIO_31_GPIO31                  = 0x00101E00,
      GPIO_31_EPWM16_B                = 0x00101E01,
      GPIO_31_EMIF1_WEN               = 0x00101E02,
      GPIO_31_EMIF1_RNW               = 0x00101E03,
      GPIO_31_MCANC_TX                = 0x00101E05,
      GPIO_31_SPID_POCI               = 0x00101E06,
      GPIO_31_I2CA_SDA                = 0x00101E07,
      GPIO_31_ESC_RX1_DATA0           = 0x00101E0A,
      GPIO_31_SD2_C4                  = 0x00101E0B,
      GPIO_31_FSITXD_D0               = 0x00101E0D,
      GPIO_31_OUTPUTXBAR8             = 0x00101E0F,
      
      GPIO_32_GPIO32                  = 0x008C0000,
      GPIO_32_EMIF1_CS0N              = 0x008C0002,
      GPIO_32_EMIF1_OEN               = 0x008C0003,
      GPIO_32_SPIA_PICO               = 0x008C0005,
      GPIO_32_SPID_CLK                = 0x008C0006,
      GPIO_32_I2CA_SDA                = 0x008C0007,
      GPIO_32_OUTPUTXBAR9             = 0x008C0009,
      GPIO_32_ESC_RX0_DATA0           = 0x008C000A,
      
      GPIO_33_GPIO33                  = 0x008C0200,
      GPIO_33_EMIF1_RNW               = 0x008C0202,
      GPIO_33_EMIF1_BA0               = 0x008C0203,
      GPIO_33_SPIA_POCI               = 0x008C0205,
      GPIO_33_SPID_PTE                = 0x008C0206,
      GPIO_33_I2CA_SCL                = 0x008C0207,
      GPIO_33_OUTPUTXBAR10            = 0x008C0209,
      GPIO_33_ESC_LED_ERR             = 0x008C020A,
      
      GPIO_34_GPIO34                  = 0x008C0400,
      GPIO_34_EPWM18_A                = 0x008C0401,
      GPIO_34_EMIF1_CS2N              = 0x008C0402,
      GPIO_34_EMIF1_BA1               = 0x008C0403,
      GPIO_34_SPIA_CLK                = 0x008C0405,
      GPIO_34_UARTF_TX                = 0x008C0406,
      GPIO_34_I2CB_SDA                = 0x008C0407,
      GPIO_34_OUTPUTXBAR11            = 0x008C0409,
      GPIO_34_ESC_LATCH0              = 0x008C040A,
      GPIO_34_EPWM3_B                 = 0x008C040D,
      GPIO_34_ESC_SYNC0               = 0x008C040E,
      GPIO_34_OUTPUTXBAR1             = 0x008C040F,
      
      GPIO_35_GPIO35                  = 0x008C0600,
      GPIO_35_EPWM18_B                = 0x008C0601,
      GPIO_35_EMIF1_CS3N              = 0x008C0602,
      GPIO_35_EMIF1_A0                = 0x008C0603,
      GPIO_35_SPIA_PTE                = 0x008C0605,
      GPIO_35_UARTF_RX                = 0x008C0606,
      GPIO_35_I2CB_SCL                = 0x008C0607,
      GPIO_35_OUTPUTXBAR12            = 0x008C0609,
      GPIO_35_ESC_LATCH1              = 0x008C060A,
      GPIO_35_ESC_SYNC1               = 0x008C060E,
      
      GPIO_36_GPIO36                  = 0x008C0800,
      GPIO_36_EMIF1_WAIT              = 0x008C0802,
      GPIO_36_EMIF1_A1                = 0x008C0803,
      GPIO_36_UARTC_TX                = 0x008C0805,
      GPIO_36_MCANC_RX                = 0x008C0806,
      GPIO_36_OUTPUTXBAR13            = 0x008C0809,
      GPIO_36_SD1_D1                  = 0x008C080B,
      GPIO_36_EMIF1_WEN               = 0x008C080E,
      
      GPIO_37_GPIO37                  = 0x008C0A00,
      GPIO_37_EPWM18_A                = 0x008C0A01,
      GPIO_37_EMIF1_OEN               = 0x008C0A02,
      GPIO_37_EMIF1_A2                = 0x008C0A03,
      GPIO_37_UARTC_RX                = 0x008C0A05,
      GPIO_37_MCANC_TX                = 0x008C0A06,
      GPIO_37_OUTPUTXBAR14            = 0x008C0A09,
      GPIO_37_ESC_RX1_DATA1           = 0x008C0A0A,
      GPIO_37_SD1_D2                  = 0x008C0A0B,
      GPIO_37_EMIF1_D24               = 0x008C0A0E,
      GPIO_37_OUTPUTXBAR2             = 0x008C0A0F,
      
      GPIO_38_GPIO38                  = 0x008C0C00,
      GPIO_38_EPWM18_B                = 0x008C0C01,
      GPIO_38_EMIF1_A0                = 0x008C0C02,
      GPIO_38_EMIF1_A3                = 0x008C0C03,
      GPIO_38_UARTA_TX                = 0x008C0C05,
      GPIO_38_SPIE_PICO               = 0x008C0C06,
      GPIO_38_OUTPUTXBAR15            = 0x008C0C09,
      GPIO_38_ESC_RX0_DATA1           = 0x008C0C0A,
      GPIO_38_SD1_D3                  = 0x008C0C0B,
      GPIO_38_FSITXD_D1               = 0x008C0C0D,
      GPIO_38_EMIF1_CS2N              = 0x008C0C0E,
      
      GPIO_39_GPIO39                  = 0x008C0E00,
      GPIO_39_EMIF1_A1                = 0x008C0E02,
      GPIO_39_EMIF1_A4                = 0x008C0E03,
      GPIO_39_UARTA_RX                = 0x008C0E05,
      GPIO_39_OUTPUTXBAR16            = 0x008C0E09,
      GPIO_39_ESC_MDIO_DATA           = 0x008C0E0A,
      GPIO_39_SD1_D4                  = 0x008C0E0B,
      GPIO_39_FSIRXD_CLK              = 0x008C0E0D,
      GPIO_39_ESC_LED_RUN             = 0x008C0E0F,
      
      GPIO_40_GPIO40                  = 0x008C1000,
      GPIO_40_EPWM13_A                = 0x008C1001,
      GPIO_40_EMIF1_A2                = 0x008C1002,
      GPIO_40_MCANB_RX                = 0x008C1005,
      GPIO_40_I2CB_SDA                = 0x008C1006,
      GPIO_40_OUTPUTXBAR9             = 0x008C1009,
      GPIO_40_ESC_GPO2                = 0x008C100A,
      GPIO_40_SD4_C3                  = 0x008C100B,
      GPIO_40_EPWM1_A                 = 0x008C100E,
      GPIO_40_SD2_C1                  = 0x008C100F,
      
      GPIO_41_GPIO41                  = 0x008C1200,
      GPIO_41_EPWM13_B                = 0x008C1201,
      GPIO_41_EMIF1_A3                = 0x008C1202,
      GPIO_41_EPWM18_A                = 0x008C1203,
      GPIO_41_MCANB_TX                = 0x008C1205,
      GPIO_41_SPIE_POCI               = 0x008C1206,
      GPIO_41_I2CB_SCL                = 0x008C1207,
      GPIO_41_OUTPUTXBAR10            = 0x008C1209,
      GPIO_41_ESC_RX0_DATA2           = 0x008C120A,
      GPIO_41_SD4_D3                  = 0x008C120B,
      GPIO_41_FSIRXD_CLK              = 0x008C120D,
      GPIO_41_EPWM1_B                 = 0x008C120E,
      GPIO_41_SD2_D1                  = 0x008C120F,
      
      GPIO_42_GPIO42                  = 0x008C1400,
      GPIO_42_EPWM14_A                = 0x008C1401,
      GPIO_42_EMIF1_A2                = 0x008C1402,
      GPIO_42_EMIF1_A13               = 0x008C1403,
      GPIO_42_UARTA_TX                = 0x008C1405,
      GPIO_42_SPIE_CLK                = 0x008C1406,
      GPIO_42_I2CA_SDA                = 0x008C1407,
      GPIO_42_OUTPUTXBAR13            = 0x008C1409,
      GPIO_42_SD4_C3                  = 0x008C140A,
      GPIO_42_SD4_C4                  = 0x008C140B,
      GPIO_42_FSIRXD_D0               = 0x008C140D,
      GPIO_42_ADCE_EXTMUXSEL2         = 0x008C140E,
      
      GPIO_43_GPIO43                  = 0x008C1600,
      GPIO_43_EPWM14_B                = 0x008C1601,
      GPIO_43_EMIF1_A4                = 0x008C1602,
      GPIO_43_EMIF1_D13               = 0x008C1603,
      GPIO_43_UARTA_RX                = 0x008C1605,
      GPIO_43_SPIE_PTE                = 0x008C1606,
      GPIO_43_I2CA_SCL                = 0x008C1607,
      GPIO_43_OUTPUTXBAR14            = 0x008C1609,
      GPIO_43_SD4_D4                  = 0x008C160B,
      GPIO_43_FSIRXD_D1               = 0x008C160D,
      GPIO_43_ADCE_EXTMUXSEL3         = 0x008C160E,
      
      GPIO_44_GPIO44                  = 0x008C1800,
      GPIO_44_EMIF1_A4                = 0x008C1802,
      GPIO_44_SPID_POCI               = 0x008C1805,
      GPIO_44_MCANB_RX                = 0x008C1806,
      GPIO_44_UARTB_TX                = 0x008C1807,
      GPIO_44_OUTPUTXBAR14            = 0x008C1809,
      GPIO_44_ESC_TX1_CLK             = 0x008C180A,
      GPIO_44_SD3_C4                  = 0x008C180B,
      GPIO_44_FSIRXD_CLK              = 0x008C180D,
      
      GPIO_45_GPIO45                  = 0x008C1A00,
      GPIO_45_EMIF1_A5                = 0x008C1A02,
      GPIO_45_SPID_PTE                = 0x008C1A05,
      GPIO_45_MCANB_TX                = 0x008C1A06,
      GPIO_45_UARTB_RX                = 0x008C1A07,
      GPIO_45_OUTPUTXBAR15            = 0x008C1A09,
      GPIO_45_ESC_TX1_ENA             = 0x008C1A0A,
      GPIO_45_SD3_D4                  = 0x008C1A0B,
      GPIO_45_FSIRXD_D0               = 0x008C1A0D,
      
      GPIO_46_GPIO46                  = 0x008C1C00,
      GPIO_46_EPWM4_A                 = 0x008C1C01,
      GPIO_46_EMIF1_A6                = 0x008C1C02,
      GPIO_46_EPWM14_A                = 0x008C1C03,
      GPIO_46_UARTC_TX                = 0x008C1C05,
      GPIO_46_MCANE_TX                = 0x008C1C07,
      GPIO_46_ESC_MDIO_CLK            = 0x008C1C0A,
      GPIO_46_SD3_C4                  = 0x008C1C0B,
      
      GPIO_47_GPIO47                  = 0x008C1E00,
      GPIO_47_EPWM4_B                 = 0x008C1E01,
      GPIO_47_EMIF1_A7                = 0x008C1E02,
      GPIO_47_EPWM14_B                = 0x008C1E03,
      GPIO_47_UARTC_RX                = 0x008C1E05,
      GPIO_47_MCANE_RX                = 0x008C1E07,
      GPIO_47_ESC_MDIO_DATA           = 0x008C1E0A,
      GPIO_47_SD4_C3                  = 0x008C1E0B,
      
      GPIO_48_GPIO48                  = 0x00900000,
      GPIO_48_EMIF1_A8                = 0x00900002,
      GPIO_48_UARTD_TX                = 0x00900005,
      GPIO_48_OUTPUTXBAR3             = 0x00900009,
      GPIO_48_ESC_PHY_CLK             = 0x0090000A,
      GPIO_48_SD1_D1                  = 0x0090000B,
      GPIO_48_EPWM3_A                 = 0x0090000D,
      GPIO_48_SD2_C2                  = 0x0090000F,
      
      GPIO_49_GPIO49                  = 0x00900200,
      GPIO_49_EMIF1_A9                = 0x00900202,
      GPIO_49_EMIF1_A5                = 0x00900203,
      GPIO_49_UARTD_RX                = 0x00900205,
      GPIO_49_OUTPUTXBAR4             = 0x00900209,
      GPIO_49_ESC_TX1_DATA2           = 0x0090020A,
      GPIO_49_SD1_C1                  = 0x0090020B,
      GPIO_49_FSITXA_D0               = 0x0090020D,
      GPIO_49_SD2_D1                  = 0x0090020F,
      
      GPIO_50_GPIO50                  = 0x00900400,
      GPIO_50_EPWM15_A                = 0x00900401,
      GPIO_50_EMIF1_A10               = 0x00900402,
      GPIO_50_EMIF1_A6                = 0x00900403,
      GPIO_50_SPIC_PICO               = 0x00900406,
      GPIO_50_MCANF_TX                = 0x00900407,
      GPIO_50_ESC_TX1_DATA1           = 0x0090040A,
      GPIO_50_SD1_D2                  = 0x0090040B,
      GPIO_50_FSITXA_D1               = 0x0090040D,
      GPIO_50_ESC_GPI25               = 0x0090040E,
      GPIO_50_SD2_D2                  = 0x0090040F,
      
      GPIO_51_GPIO51                  = 0x00900600,
      GPIO_51_EPWM15_B                = 0x00900601,
      GPIO_51_EMIF1_A11               = 0x00900602,
      GPIO_51_EMIF1_A7                = 0x00900603,
      GPIO_51_SPIC_POCI               = 0x00900606,
      GPIO_51_MCANF_RX                = 0x00900607,
      GPIO_51_ESC_TX1_CLK             = 0x0090060A,
      GPIO_51_SD1_C2                  = 0x0090060B,
      GPIO_51_FSITXA_CLK              = 0x0090060D,
      GPIO_51_ESC_GPI26               = 0x0090060E,
      GPIO_51_SD2_D3                  = 0x0090060F,
      
      GPIO_52_GPIO52                  = 0x00900800,
      GPIO_52_EPWM16_A                = 0x00900801,
      GPIO_52_EMIF1_A12               = 0x00900802,
      GPIO_52_EMIF1_A8                = 0x00900803,
      GPIO_52_UARTD_TX                = 0x00900805,
      GPIO_52_SPIC_CLK                = 0x00900806,
      GPIO_52_ESC_TX1_ENA             = 0x0090080A,
      GPIO_52_SD1_D3                  = 0x0090080B,
      GPIO_52_FSIRXA_D0               = 0x0090080D,
      GPIO_52_SD2_D4                  = 0x0090080F,
      
      GPIO_53_GPIO53                  = 0x00900A00,
      GPIO_53_EPWM16_B                = 0x00900A01,
      GPIO_53_EMIF1_D31               = 0x00900A02,
      GPIO_53_EMIF1_A9                = 0x00900A03,
      GPIO_53_UARTD_RX                = 0x00900A05,
      GPIO_53_SPIC_PTE                = 0x00900A06,
      GPIO_53_ESC_PHY0_LINKSTATUS     = 0x00900A0A,
      GPIO_53_SD1_C3                  = 0x00900A0B,
      GPIO_53_FSIRXA_D1               = 0x00900A0D,
      GPIO_53_ESC_GPI28               = 0x00900A0E,
      GPIO_53_SD1_C1                  = 0x00900A0F,
      
      GPIO_54_GPIO54                  = 0x00900C00,
      GPIO_54_EMIF1_D30               = 0x00900C02,
      GPIO_54_EMIF1_A10               = 0x00900C03,
      GPIO_54_SPIA_PICO               = 0x00900C05,
      GPIO_54_ESC_PHY_CLK             = 0x00900C0A,
      GPIO_54_SD1_D4                  = 0x00900C0B,
      GPIO_54_FSIRXA_CLK              = 0x00900C0D,
      GPIO_54_ESC_GPI29               = 0x00900C0E,
      GPIO_54_SD1_C2                  = 0x00900C0F,
      
      GPIO_55_GPIO55                  = 0x00900E00,
      GPIO_55_EPWM16_B                = 0x00900E01,
      GPIO_55_EMIF1_D29               = 0x00900E02,
      GPIO_55_EMIF1_D0                = 0x00900E03,
      GPIO_55_SPIA_POCI               = 0x00900E05,
      GPIO_55_EMIF1_WAIT              = 0x00900E06,
      GPIO_55_ESC_PHY0_LINKSTATUS     = 0x00900E0A,
      GPIO_55_SD1_C4                  = 0x00900E0B,
      GPIO_55_FSITXB_D0               = 0x00900E0D,
      GPIO_55_SD1_C3                  = 0x00900E0F,
      
      GPIO_56_GPIO56                  = 0x00901000,
      GPIO_56_EPWM17_A                = 0x00901001,
      GPIO_56_EMIF1_D28               = 0x00901002,
      GPIO_56_EMIF1_D1                = 0x00901003,
      GPIO_56_SPIA_CLK                = 0x00901005,
      GPIO_56_MCAND_TX                = 0x00901006,
      GPIO_56_I2CA_SDA                = 0x00901007,
      GPIO_56_ESC_PDI_UC_IRQ          = 0x0090100A,
      GPIO_56_SD2_D1                  = 0x0090100B,
      GPIO_56_FSITXB_CLK              = 0x0090100D,
      GPIO_56_ESC_GPI30               = 0x0090100E,
      GPIO_56_SD1_C4                  = 0x0090100F,
      
      GPIO_57_GPIO57                  = 0x00901200,
      GPIO_57_EPWM17_B                = 0x00901201,
      GPIO_57_EMIF1_D27               = 0x00901202,
      GPIO_57_EMIF1_D2                = 0x00901203,
      GPIO_57_SPIA_PTE                = 0x00901205,
      GPIO_57_MCAND_RX                = 0x00901206,
      GPIO_57_I2CA_SCL                = 0x00901207,
      GPIO_57_ESC_MDIO_DATA           = 0x0090120A,
      GPIO_57_SD2_C1                  = 0x0090120B,
      GPIO_57_FSITXB_D1               = 0x0090120D,
      GPIO_57_ESC_GPI31               = 0x0090120E,
      GPIO_57_SD3_D3                  = 0x0090120F,
      
      GPIO_58_GPIO58                  = 0x00901400,
      GPIO_58_EPWM13_A                = 0x00901401,
      GPIO_58_EMIF1_D26               = 0x00901402,
      GPIO_58_EPWM8_A                 = 0x00901403,
      GPIO_58_SPIA_PICO               = 0x00901405,
      GPIO_58_MCANC_RX                = 0x00901407,
      GPIO_58_SENT1                   = 0x00901409,
      GPIO_58_ESC_LED_LINK0_ACTIVE    = 0x0090140A,
      GPIO_58_SD2_D2                  = 0x0090140B,
      GPIO_58_FSIRXB_D0               = 0x0090140D,
      GPIO_58_ESC_TX0_DATA3           = 0x0090140E,
      GPIO_58_SD2_C2                  = 0x0090140F,
      
      GPIO_59_GPIO59                  = 0x00901600,
      GPIO_59_EPWM5_A                 = 0x00901601,
      GPIO_59_EMIF1_D25               = 0x00901602,
      GPIO_59_EPWM8_B                 = 0x00901603,
      GPIO_59_SPIA_POCI               = 0x00901605,
      GPIO_59_MCANC_TX                = 0x00901607,
      GPIO_59_SENT2                   = 0x00901609,
      GPIO_59_ESC_LED_LINK1_ACTIVE    = 0x0090160A,
      GPIO_59_SD2_C2                  = 0x0090160B,
      GPIO_59_FSIRXB_D1               = 0x0090160D,
      GPIO_59_ESC_TX0_ENA             = 0x0090160E,
      GPIO_59_SD2_C3                  = 0x0090160F,
      
      GPIO_60_GPIO60                  = 0x00901800,
      GPIO_60_EPWM3_B                 = 0x00901801,
      GPIO_60_EMIF1_D24               = 0x00901802,
      GPIO_60_EMIF1_D0                = 0x00901803,
      GPIO_60_SPIA_CLK                = 0x00901805,
      GPIO_60_OUTPUTXBAR3             = 0x00901806,
      GPIO_60_SENT3                   = 0x00901809,
      GPIO_60_ESC_LED_ERR             = 0x0090180A,
      GPIO_60_ESC_LATCH0              = 0x0090180B,
      GPIO_60_FSIRXB_CLK              = 0x0090180D,
      GPIO_60_SD2_C4                  = 0x0090180F,
      
      GPIO_61_GPIO61                  = 0x00901A00,
      GPIO_61_EPWM17_B                = 0x00901A01,
      GPIO_61_EMIF1_D23               = 0x00901A02,
      GPIO_61_EMIF1_D6                = 0x00901A03,
      GPIO_61_SPIA_PTE                = 0x00901A05,
      GPIO_61_MCANC_RX                = 0x00901A07,
      GPIO_61_OUTPUTXBAR4             = 0x00901A09,
      GPIO_61_ESC_LED_RUN             = 0x00901A0A,
      GPIO_61_SD2_C3                  = 0x00901A0B,
      GPIO_61_FSITXD_CLK              = 0x00901A0D,
      GPIO_61_ESC_LATCH1              = 0x00901A0E,
      
      GPIO_62_GPIO62                  = 0x00901C00,
      GPIO_62_EPWM17_A                = 0x00901C01,
      GPIO_62_EMIF1_D22               = 0x00901C02,
      GPIO_62_EMIF1_D7                = 0x00901C03,
      GPIO_62_MCANC_RX                = 0x00901C06,
      GPIO_62_MCANC_TX                = 0x00901C07,
      GPIO_62_SENT4                   = 0x00901C09,
      GPIO_62_ESC_LED_STATE_RUN       = 0x00901C0A,
      GPIO_62_SD2_D4                  = 0x00901C0B,
      GPIO_62_FSITXD_D0               = 0x00901C0D,
      GPIO_62_ESC_MDIO_CLK            = 0x00901C0E,
      
      GPIO_63_GPIO63                  = 0x00901E00,
      GPIO_63_EPWM9_A                 = 0x00901E01,
      GPIO_63_EMIF1_D21               = 0x00901E02,
      GPIO_63_EMIF1_RNW               = 0x00901E03,
      GPIO_63_SPIB_PICO               = 0x00901E05,
      GPIO_63_MCANC_TX                = 0x00901E06,
      GPIO_63_SENT5                   = 0x00901E09,
      GPIO_63_ESC_RX1_DATA0           = 0x00901E0A,
      GPIO_63_SD1_D1                  = 0x00901E0B,
      GPIO_63_FSITXD_D1               = 0x00901E0D,
      GPIO_63_ADCD_EXTMUXSEL0         = 0x00901E0E,
      GPIO_63_SD2_C4                  = 0x00901E0F,
      
      GPIO_64_GPIO64                  = 0x010C0000,
      GPIO_64_EPWM9_B                 = 0x010C0001,
      GPIO_64_EMIF1_D20               = 0x010C0002,
      GPIO_64_EMIF1_WAIT              = 0x010C0003,
      GPIO_64_SPIB_POCI               = 0x010C0005,
      GPIO_64_MCANA_TX                = 0x010C0006,
      GPIO_64_UARTF_TX                = 0x010C0007,
      GPIO_64_SENT6                   = 0x010C0009,
      GPIO_64_ESC_RX1_DATA1           = 0x010C000A,
      GPIO_64_SD1_C1                  = 0x010C000B,
      GPIO_64_FSITXD_CLK              = 0x010C000D,
      GPIO_64_ADCD_EXTMUXSEL1         = 0x010C000E,
      
      GPIO_65_GPIO65                  = 0x010C0200,
      GPIO_65_EPWM10_A                = 0x010C0201,
      GPIO_65_EMIF1_D19               = 0x010C0202,
      GPIO_65_EMIF1_WEN               = 0x010C0203,
      GPIO_65_SPIB_CLK                = 0x010C0205,
      GPIO_65_MCANA_RX                = 0x010C0206,
      GPIO_65_UARTF_RX                = 0x010C0207,
      GPIO_65_ESC_RX1_DATA2           = 0x010C020A,
      GPIO_65_SD1_D2                  = 0x010C020B,
      GPIO_65_FSITXB_CLK              = 0x010C020D,
      GPIO_65_ADCD_EXTMUXSEL2         = 0x010C020E,
      GPIO_65_ESC_GPI13               = 0x010C020F,
      
      GPIO_66_GPIO66                  = 0x010C0400,
      GPIO_66_EPWM10_B                = 0x010C0401,
      GPIO_66_EMIF1_D18               = 0x010C0402,
      GPIO_66_EMIF1_OEN               = 0x010C0403,
      GPIO_66_SPIB_PTE                = 0x010C0405,
      GPIO_66_I2CB_SDA                = 0x010C0406,
      GPIO_66_ESC_RX1_DATA3           = 0x010C040A,
      GPIO_66_SD1_C2                  = 0x010C040B,
      GPIO_66_FSITXB_D1               = 0x010C040D,
      GPIO_66_ADCD_EXTMUXSEL3         = 0x010C040E,
      GPIO_66_ESC_GPI14               = 0x010C040F,
      
      GPIO_67_GPIO67                  = 0x010C0600,
      GPIO_67_EPWM17_A                = 0x010C0601,
      GPIO_67_EMIF1_D17               = 0x010C0602,
      GPIO_67_LINB_TX                 = 0x010C0605,
      GPIO_67_MCAND_TX                = 0x010C0606,
      GPIO_67_SD1_D3                  = 0x010C060B,
      GPIO_67_FSITXB_CLK              = 0x010C060D,
      
      GPIO_68_GPIO68                  = 0x010C0800,
      GPIO_68_EPWM17_B                = 0x010C0801,
      GPIO_68_EMIF1_D16               = 0x010C0802,
      GPIO_68_EMIF1_D4                = 0x010C0803,
      GPIO_68_LINB_RX                 = 0x010C0805,
      GPIO_68_MCAND_RX                = 0x010C0806,
      GPIO_68_EMIF1_D13               = 0x010C0807,
      GPIO_68_ESC_PHY1_LINKSTATUS     = 0x010C080A,
      GPIO_68_SD1_C3                  = 0x010C080B,
      GPIO_68_FSIRXB_D1               = 0x010C080D,
      GPIO_68_ESC_GPI15               = 0x010C080F,
      
      GPIO_69_GPIO69                  = 0x010C0A00,
      GPIO_69_EPWM11_A                = 0x010C0A01,
      GPIO_69_EMIF1_D15               = 0x010C0A02,
      GPIO_69_SPIC_PICO               = 0x010C0A05,
      GPIO_69_I2CB_SCL                = 0x010C0A06,
      GPIO_69_ESC_RX1_CLK             = 0x010C0A0A,
      GPIO_69_SD1_D4                  = 0x010C0A0B,
      GPIO_69_FSITXB_D0               = 0x010C0A0D,
      
      GPIO_70_GPIO70                  = 0x010C0C00,
      GPIO_70_EPWM11_B                = 0x010C0C01,
      GPIO_70_EMIF1_D14               = 0x010C0C02,
      GPIO_70_SPIC_POCI               = 0x010C0C05,
      GPIO_70_MCANC_RX                = 0x010C0C06,
      GPIO_70_UARTB_TX                = 0x010C0C07,
      GPIO_70_ESC_RX1_DV              = 0x010C0C0A,
      GPIO_70_SD1_C4                  = 0x010C0C0B,
      GPIO_70_FSIRXB_D0               = 0x010C0C0D,
      GPIO_70_ESC_GPI16               = 0x010C0C0F,
      
      GPIO_71_GPIO71                  = 0x010C0E00,
      GPIO_71_EPWM12_A                = 0x010C0E01,
      GPIO_71_EPWM11_A                = 0x010C0E02,
      GPIO_71_EMIF1_D5                = 0x010C0E03,
      GPIO_71_SPIC_CLK                = 0x010C0E05,
      GPIO_71_MCANC_TX                = 0x010C0E06,
      GPIO_71_UARTB_RX                = 0x010C0E07,
      GPIO_71_EMIF1_D13               = 0x010C0E09,
      GPIO_71_ESC_RX1_ERR             = 0x010C0E0A,
      GPIO_71_SD3_D1                  = 0x010C0E0B,
      GPIO_71_FSITXC_CLK              = 0x010C0E0D,
      GPIO_71_FSITXB_D0               = 0x010C0E0E,
      
      GPIO_72_GPIO72                  = 0x010C1000,
      GPIO_72_EPWM12_B                = 0x010C1001,
      GPIO_72_EMIF1_D12               = 0x010C1002,
      GPIO_72_SPIC_PTE                = 0x010C1005,
      GPIO_72_MCANB_RX                = 0x010C1006,
      GPIO_72_UARTA_TX                = 0x010C1007,
      GPIO_72_OUTPUTXBAR8             = 0x010C1009,
      GPIO_72_ESC_TX1_DATA3           = 0x010C100A,
      GPIO_72_SD3_D2                  = 0x010C100B,
      GPIO_72_FSITXC_D0               = 0x010C100D,
      GPIO_72_SD3_C1                  = 0x010C100E,
      
      GPIO_73_GPIO73                  = 0x010C1200,
      GPIO_73_EPWM5_B                 = 0x010C1201,
      GPIO_73_EMIF1_D11               = 0x010C1202,
      GPIO_73_XCLKOUT                 = 0x010C1203,
      GPIO_73_MCANB_TX                = 0x010C1206,
      GPIO_73_UARTA_RX                = 0x010C1207,
      GPIO_73_OUTPUTXBAR6             = 0x010C1209,
      GPIO_73_ESC_TX1_DATA2           = 0x010C120A,
      GPIO_73_SD4_D4                  = 0x010C120B,
      GPIO_73_FSITXC_CLK              = 0x010C120D,
      GPIO_73_SD2_D2                  = 0x010C120E,
      
      GPIO_74_GPIO74                  = 0x010C1400,
      GPIO_74_EPWM8_A                 = 0x010C1401,
      GPIO_74_EMIF1_D10               = 0x010C1402,
      GPIO_74_MCANC_TX                = 0x010C1406,
      GPIO_74_ESC_TX1_DATA1           = 0x010C140A,
      GPIO_74_SD1_D4                  = 0x010C140B,
      GPIO_74_FSITXA_D0               = 0x010C140D,
      GPIO_74_SD2_C2                  = 0x010C140E,
      
      GPIO_75_GPIO75                  = 0x010C1600,
      GPIO_75_EPWM8_B                 = 0x010C1601,
      GPIO_75_EMIF1_D9                = 0x010C1602,
      GPIO_75_SPID_CLK                = 0x010C1605,
      GPIO_75_MCANC_RX                = 0x010C1606,
      GPIO_75_OUTPUTXBAR16            = 0x010C1609,
      GPIO_75_ESC_TX1_DATA0           = 0x010C160A,
      GPIO_75_SD2_D3                  = 0x010C160E,
      
      GPIO_76_GPIO76                  = 0x010C1800,
      GPIO_76_EPWM9_A                 = 0x010C1801,
      GPIO_76_EMIF1_D8                = 0x010C1802,
      GPIO_76_UARTD_TX                = 0x010C1805,
      GPIO_76_MCANE_TX                = 0x010C1807,
      GPIO_76_SD4_D4                  = 0x010C1809,
      GPIO_76_ESC_PHY_RESETN          = 0x010C180A,
      GPIO_76_SD3_C1                  = 0x010C180B,
      GPIO_76_FSIRXC_D0               = 0x010C180D,
      GPIO_76_SD2_C3                  = 0x010C180E,
      GPIO_76_ESC_GPI17               = 0x010C180F,
      
      GPIO_77_GPIO77                  = 0x010C1A00,
      GPIO_77_EPWM9_B                 = 0x010C1A01,
      GPIO_77_EMIF1_D7                = 0x010C1A02,
      GPIO_77_UARTD_RX                = 0x010C1A05,
      GPIO_77_MCANE_RX                = 0x010C1A07,
      GPIO_77_SD1_D4                  = 0x010C1A09,
      GPIO_77_ESC_RX0_CLK             = 0x010C1A0A,
      GPIO_77_SD3_D1                  = 0x010C1A0B,
      GPIO_77_FSITXB_D0               = 0x010C1A0D,
      GPIO_77_SD2_D4                  = 0x010C1A0E,
      
      GPIO_78_GPIO78                  = 0x010C1C00,
      GPIO_78_EPWM10_A                = 0x010C1C01,
      GPIO_78_EMIF1_D6                = 0x010C1C02,
      GPIO_78_EPWM11_A                = 0x010C1C03,
      GPIO_78_MCANF_TX                = 0x010C1C07,
      GPIO_78_SD4_D4                  = 0x010C1C09,
      GPIO_78_ESC_RX0_DV              = 0x010C1C0A,
      GPIO_78_SD3_C2                  = 0x010C1C0B,
      GPIO_78_FSITXC_D1               = 0x010C1C0D,
      GPIO_78_SD2_C4                  = 0x010C1C0E,
      GPIO_78_ESC_GPI18               = 0x010C1C0F,
      
      GPIO_79_GPIO79                  = 0x010C1E00,
      GPIO_79_EPWM10_B                = 0x010C1E01,
      GPIO_79_EMIF1_D5                = 0x010C1E02,
      GPIO_79_ERRORSTS                = 0x010C1E05,
      GPIO_79_ESC_RX0_ERR             = 0x010C1E0A,
      GPIO_79_SD3_D2                  = 0x010C1E0B,
      GPIO_79_FSITXC_D0               = 0x010C1E0D,
      GPIO_79_SD2_D1                  = 0x010C1E0E,
      
      GPIO_80_GPIO80                  = 0x01100000,
      GPIO_80_EPWM11_A                = 0x01100001,
      GPIO_80_EMIF1_D4                = 0x01100002,
      GPIO_80_ERRORSTS                = 0x01100005,
      GPIO_80_SD1_D4                  = 0x01100009,
      GPIO_80_ESC_RX0_DATA0           = 0x0110000A,
      GPIO_80_SD3_C3                  = 0x0110000B,
      GPIO_80_SD2_C1                  = 0x0110000E,
      
      GPIO_81_GPIO81                  = 0x01100200,
      GPIO_81_EPWM11_B                = 0x01100201,
      GPIO_81_EMIF1_D3                = 0x01100202,
      GPIO_81_ESC_RX0_DATA1           = 0x0110020A,
      GPIO_81_SD3_D3                  = 0x0110020B,
      
      GPIO_82_GPIO82                  = 0x01100400,
      GPIO_82_EPWM12_A                = 0x01100401,
      GPIO_82_EMIF1_D2                = 0x01100402,
      GPIO_82_ESC_RX0_DATA2           = 0x0110040A,
      GPIO_82_SD3_C2                  = 0x0110040B,
      
      GPIO_83_GPIO83                  = 0x01100600,
      GPIO_83_EPWM12_B                = 0x01100601,
      GPIO_83_EMIF1_D1                = 0x01100602,
      GPIO_83_ESC_RX0_DATA3           = 0x0110060A,
      GPIO_83_SD3_D2                  = 0x0110060B,
      
      GPIO_84_GPIO84                  = 0x01100800,
      GPIO_84_EPWM12_B                = 0x01100801,
      GPIO_84_EMIF1_D1                = 0x01100802,
      GPIO_84_EMIF1_CS4N              = 0x01100803,
      GPIO_84_SPIC_PICO               = 0x01100805,
      GPIO_84_UARTA_TX                = 0x01100806,
      GPIO_84_MCANF_RX                = 0x01100807,
      GPIO_84_ESC_TX0_ENA             = 0x0110080A,
      GPIO_84_SD3_C2                  = 0x0110080B,
      GPIO_84_FSITXC_D1               = 0x0110080D,
      GPIO_84_ESC_RX0_DATA3           = 0x0110080E,
      GPIO_84_ESC_GPO24               = 0x0110080F,
      
      GPIO_85_GPIO85                  = 0x01100A00,
      GPIO_85_EPWM13_A                = 0x01100A01,
      GPIO_85_EMIF1_D0                = 0x01100A02,
      GPIO_85_UARTA_RX                = 0x01100A06,
      GPIO_85_EMIF1_DQM2              = 0x01100A09,
      GPIO_85_ESC_TX0_CLK             = 0x01100A0A,
      GPIO_85_SD3_D3                  = 0x01100A0B,
      
      GPIO_86_GPIO86                  = 0x01100C00,
      GPIO_86_EPWM13_B                = 0x01100C01,
      GPIO_86_EMIF1_A13               = 0x01100C02,
      GPIO_86_EMIF1_CAS               = 0x01100C03,
      GPIO_86_UARTD_TX                = 0x01100C06,
      GPIO_86_ESC_PHY0_LINKSTATUS     = 0x01100C0A,
      GPIO_86_SD3_C3                  = 0x01100C0B,
      
      GPIO_87_GPIO87                  = 0x01100E00,
      GPIO_87_EPWM14_A                = 0x01100E01,
      GPIO_87_EMIF1_A14               = 0x01100E02,
      GPIO_87_EMIF1_RAS               = 0x01100E03,
      GPIO_87_UARTD_RX                = 0x01100E06,
      GPIO_87_EMIF1_DQM3              = 0x01100E09,
      GPIO_87_ESC_TX0_DATA0           = 0x01100E0A,
      GPIO_87_SD3_D4                  = 0x01100E0B,
      
      GPIO_88_GPIO88                  = 0x01101000,
      GPIO_88_EPWM14_B                = 0x01101001,
      GPIO_88_EMIF1_A15               = 0x01101002,
      GPIO_88_EMIF1_DQM0              = 0x01101003,
      GPIO_88_EMIF1_DQM1              = 0x01101009,
      GPIO_88_ESC_TX0_DATA1           = 0x0110100A,
      GPIO_88_SD3_C4                  = 0x0110100B,
      
      GPIO_89_GPIO89                  = 0x01101200,
      GPIO_89_EPWM15_A                = 0x01101201,
      GPIO_89_EMIF1_A16               = 0x01101202,
      GPIO_89_EMIF1_DQM1              = 0x01101203,
      GPIO_89_SPID_PTE                = 0x01101205,
      GPIO_89_EMIF1_CAS               = 0x01101209,
      GPIO_89_ESC_TX0_DATA2           = 0x0110120A,
      GPIO_89_SD1_D3                  = 0x0110120B,
      GPIO_89_SD4_D1                  = 0x0110120E,
      
      GPIO_90_GPIO90                  = 0x01101400,
      GPIO_90_EPWM15_B                = 0x01101401,
      GPIO_90_EMIF1_A17               = 0x01101402,
      GPIO_90_EMIF1_DQM2              = 0x01101403,
      GPIO_90_SPID_CLK                = 0x01101405,
      GPIO_90_EMIF1_RAS               = 0x01101409,
      GPIO_90_ESC_TX0_DATA3           = 0x0110140A,
      GPIO_90_SD1_C3                  = 0x0110140B,
      GPIO_90_SD4_C1                  = 0x0110140E,
      
      GPIO_91_GPIO91                  = 0x01101600,
      GPIO_91_EPWM16_A                = 0x01101601,
      GPIO_91_EMIF1_A18               = 0x01101602,
      GPIO_91_EMIF1_DQM3              = 0x01101603,
      GPIO_91_SPID_PICO               = 0x01101605,
      GPIO_91_I2CA_SDA                = 0x01101606,
      GPIO_91_MCAND_TX                = 0x01101607,
      GPIO_91_EMIF1_DQM2              = 0x01101609,
      GPIO_91_SD4_D2                  = 0x0110160B,
      GPIO_91_OUTPUTXBAR9             = 0x0110160E,
      
      GPIO_92_GPIO92                  = 0x01101800,
      GPIO_92_EPWM16_B                = 0x01101801,
      GPIO_92_EMIF1_A19               = 0x01101802,
      GPIO_92_EMIF1_BA1               = 0x01101803,
      GPIO_92_SPID_POCI               = 0x01101805,
      GPIO_92_I2CA_SCL                = 0x01101806,
      GPIO_92_MCAND_RX                = 0x01101807,
      GPIO_92_EMIF1_DQM0              = 0x01101809,
      GPIO_92_FSIRXD_CLK              = 0x0110180A,
      GPIO_92_SD4_C2                  = 0x0110180B,
      GPIO_92_OUTPUTXBAR10            = 0x0110180E,
      
      GPIO_93_GPIO93                  = 0x01101A00,
      GPIO_93_EPWM17_A                = 0x01101A01,
      GPIO_93_EMIF1_A20               = 0x01101A02,
      GPIO_93_EMIF1_BA0               = 0x01101A03,
      GPIO_93_SPID_CLK                = 0x01101A05,
      GPIO_93_ESC_TX1_CLK             = 0x01101A0A,
      GPIO_93_SD4_D3                  = 0x01101A0B,
      GPIO_93_OUTPUTXBAR11            = 0x01101A0E,
      
      GPIO_94_GPIO94                  = 0x01101C00,
      GPIO_94_EPWM17_B                = 0x01101C01,
      GPIO_94_EMIF1_A21               = 0x01101C02,
      GPIO_94_SPID_PTE                = 0x01101C05,
      GPIO_94_EMIF1_BA1               = 0x01101C09,
      GPIO_94_ESC_TX1_ENA             = 0x01101C0A,
      GPIO_94_SD4_C3                  = 0x01101C0B,
      GPIO_94_OUTPUTXBAR12            = 0x01101C0E,
      
      GPIO_95_GPIO95                  = 0x01101E00,
      GPIO_95_EPWM18_A                = 0x01101E01,
      GPIO_95_ESC_GPO10               = 0x01101E0A,
      GPIO_95_SD1_D1                  = 0x01101E0B,
      GPIO_95_OUTPUTXBAR13            = 0x01101E0E,
      
      GPIO_96_GPIO96                  = 0x018C0000,
      GPIO_96_EPWM18_B                = 0x018C0001,
      GPIO_96_ESC_GPO11               = 0x018C000A,
      GPIO_96_SD1_C1                  = 0x018C000B,
      GPIO_96_OUTPUTXBAR14            = 0x018C000E,
      
      GPIO_97_GPIO97                  = 0x018C0200,
      GPIO_97_ESC_GPI17               = 0x018C020A,
      GPIO_97_SD1_D2                  = 0x018C020B,
      GPIO_97_OUTPUTXBAR15            = 0x018C020E,
      
      GPIO_98_GPIO98                  = 0x018C0400,
      GPIO_98_ESC_GPI18               = 0x018C040A,
      GPIO_98_SD1_C2                  = 0x018C040B,
      GPIO_98_OUTPUTXBAR16            = 0x018C040E,
      
      GPIO_99_GPIO99                  = 0x018C0600,
      GPIO_99_EPWM8_A                 = 0x018C0601,
      GPIO_99_EMIF1_DQM3              = 0x018C0602,
      GPIO_99_EMIF1_D17               = 0x018C0603,
      GPIO_99_ESC_GPI21               = 0x018C060A,
      GPIO_99_SD4_D4                  = 0x018C060B,
      
      GPIO_100_GPIO100                = 0x018C0800,
      GPIO_100_EPWM9_A                = 0x018C0801,
      GPIO_100_EMIF1_BA1              = 0x018C0802,
      GPIO_100_EMIF1_D24              = 0x018C0803,
      GPIO_100_SPIC_PICO              = 0x018C0805,
      GPIO_100_SPIA_PICO              = 0x018C0806,
      GPIO_100_SD1_D1                 = 0x018C0809,
      GPIO_100_ESC_GPI0               = 0x018C080A,
      GPIO_100_SD4_C4                 = 0x018C080B,
      GPIO_100_FSITXA_D0              = 0x018C080D,
      GPIO_100_FSIRXD_D1              = 0x018C080E,
      
      GPIO_101_GPIO101                = 0x018C0A00,
      GPIO_101_EPWM18_A               = 0x018C0A01,
      GPIO_101_EMIF1_A5               = 0x018C0A02,
      GPIO_101_SPIC_POCI              = 0x018C0A05,
      GPIO_101_ESC_GPI1               = 0x018C0A0A,
      GPIO_101_FSITXA_D1              = 0x018C0A0D,
      
      GPIO_103_GPIO103                = 0x018C0E00,
      GPIO_103_EPWM8_B                = 0x018C0E01,
      GPIO_103_EMIF1_BA0              = 0x018C0E02,
      GPIO_103_EMIF1_D3               = 0x018C0E03,
      GPIO_103_SPIC_PTE               = 0x018C0E05,
      GPIO_103_ESC_GPI3               = 0x018C0E0A,
      GPIO_103_SD4_C4                 = 0x018C0E0B,
      GPIO_103_FSIRXA_D0              = 0x018C0E0D,
      GPIO_103_ESC_GPO25              = 0x018C0E0F,
      
      GPIO_105_GPIO105                = 0x018C1200,
      GPIO_105_EPWM18_B               = 0x018C1201,
      GPIO_105_I2CA_SCL               = 0x018C1205,
      GPIO_105_ESC_GPI5               = 0x018C120A,
      GPIO_105_SD3_C1                 = 0x018C120B,
      GPIO_105_FSIRXA_CLK             = 0x018C120D,
      
      GPIO_127_GPIO127                = 0x01901E00,
      GPIO_127_EPWM18_A               = 0x01901E01,
      GPIO_127_EMIF1_D18              = 0x01901E02,
      GPIO_127_EMIF1_A11              = 0x01901E03,
      GPIO_127_SPID_POCI              = 0x01901E05,
      GPIO_127_ESC_GPI27              = 0x01901E0A,
      GPIO_127_SD1_C3                 = 0x01901E0B,
      GPIO_127_FSIRXC_D1              = 0x01901E0D,
      GPIO_127_ESC_SYNC0              = 0x01901E0E,
      GPIO_127_ESC_GPO26              = 0x01901E0F,
      
      GPIO_219_GPIO219                = 0x03101600,
      GPIO_219_ERRORSTS               = 0x03101601,
      GPIO_219_EMIF1_A19              = 0x03101602,
      GPIO_219_EPWM18_B               = 0x03101603,
      GPIO_219_OUTPUTXBAR1            = 0x03101609,
      GPIO_219_XCLKOUT                = 0x0310160A,
      GPIO_219_SD2_C1                 = 0x0310160B,
      GPIO_219_ESC_GPI8               = 0x0310160D,
      GPIO_219_ESC_TX0_ENA            = 0x0310160E,
      GPIO_219_ESC_GPO27              = 0x0310160F,
      
      GPIO_220_GPIO220                = 0x03101800,
      GPIO_220_EPWM6_A                = 0x03101801,
      GPIO_220_EMIF1_A20              = 0x03101802,
      GPIO_220_SPID_POCI              = 0x03101805,
      GPIO_220_MCANC_TX               = 0x03101806,
      GPIO_220_OUTPUTXBAR2            = 0x03101809,
      GPIO_220_SD3_D3                 = 0x0310180B,
      GPIO_220_ESC_GPI9               = 0x0310180D,
      GPIO_220_ESC_GPO28              = 0x0310180F,
      
      GPIO_221_GPIO221                = 0x03101A00,
      GPIO_221_EPWM6_B                = 0x03101A01,
      GPIO_221_EMIF1_A21              = 0x03101A02,
      GPIO_221_EMIF1_CAS              = 0x03101A03,
      GPIO_221_SPID_PTE               = 0x03101A05,
      GPIO_221_MCANC_RX               = 0x03101A06,
      GPIO_221_OUTPUTXBAR3            = 0x03101A09,
      GPIO_221_SD3_C3                 = 0x03101A0B,
      GPIO_221_ESC_GPI10              = 0x03101A0D,
      GPIO_221_ESC_GPO29              = 0x03101A0F,
      
      GPIO_222_GPIO222                = 0x03101C00,
      GPIO_222_TDI                    = 0x03101C01,
      GPIO_222_EPWM7_A                = 0x03101C02,
      GPIO_222_SPID_PICO              = 0x03101C05,
      GPIO_222_UARTB_TX               = 0x03101C06,
      GPIO_222_I2CB_SCL               = 0x03101C07,
      GPIO_222_OUTPUTXBAR4            = 0x03101C09,
      GPIO_222_SPIC_CLK               = 0x03101C0A,
      GPIO_222_SD3_D4                 = 0x03101C0B,
      GPIO_222_ESC_GPI11              = 0x03101C0D,
      GPIO_222_ESC_GPO30              = 0x03101C0F,
      
      GPIO_223_GPIO223                = 0x03101E00,
      GPIO_223_TDO                    = 0x03101E01,
      GPIO_223_EPWM7_B                = 0x03101E02,
      GPIO_223_SPID_CLK               = 0x03101E05,
      GPIO_223_UARTB_RX               = 0x03101E06,
      GPIO_223_I2CB_SDA               = 0x03101E07,
      GPIO_223_OUTPUTXBAR5            = 0x03101E09,
      GPIO_223_SPIC_PTE               = 0x03101E0A,
      GPIO_223_SD3_C4                 = 0x03101E0B,
      GPIO_223_ESC_GPI12              = 0x03101E0D,
      GPIO_223_ESC_GPO31              = 0x03101E0F,
      
      GPIO_160_AIO160                 = 0x028C0000,
      GPIO_160_SD3_C2                 = 0x028C000B,
      
      GPIO_161_AIO161                 = 0x028C0200,
      GPIO_161_SD3_D2                 = 0x028C020B,
      
      GPIO_162_AIO162                 = 0x028C0400,
      GPIO_162_SD2_C2                 = 0x028C040B,
      
      GPIO_163_AIO163                 = 0x028C0600,
      GPIO_163_SD2_D2                 = 0x028C060B,
      
      GPIO_164_AIO164                 = 0x028C0800,
      GPIO_164_SD2_C3                 = 0x028C080B,
      
      GPIO_165_AIO165                 = 0x028C0A00,
      GPIO_165_SD2_D3                 = 0x028C0A0B,
      
      GPIO_224_GPIO224                = 0x038C0000,
      GPIO_224_EPWM12_A               = 0x038C0001,
      GPIO_224_EPWM12_B               = 0x038C0002,
      GPIO_224_SPIB_POCI              = 0x038C0005,
      GPIO_224_MCAND_RX               = 0x038C0006,
      GPIO_224_OUTPUTXBAR5            = 0x038C0009,
      GPIO_224_SD4_D2                 = 0x038C000B,
      GPIO_224_ADCA_EXTMUXSEL0        = 0x038C000E,
      GPIO_224_ESC_GPO8               = 0x038C000F,
      
      GPIO_225_GPIO225                = 0x038C0200,
      GPIO_225_EPWM11_B               = 0x038C0201,
      GPIO_225_SPIB_PICO              = 0x038C0205,
      GPIO_225_I2CB_SDA               = 0x038C0206,
      GPIO_225_UARTF_TX               = 0x038C0207,
      GPIO_225_OUTPUTXBAR4            = 0x038C0209,
      GPIO_225_SD4_C1                 = 0x038C020B,
      GPIO_225_ADCA_EXTMUXSEL1        = 0x038C020E,
      GPIO_225_ESC_GPO9               = 0x038C020F,
      
      GPIO_226_GPIO226                = 0x038C0400,
      GPIO_226_EPWM10_A               = 0x038C0401,
      GPIO_226_SPIA_PTE               = 0x038C0405,
      GPIO_226_MCAND_TX               = 0x038C0406,
      GPIO_226_UARTF_RX               = 0x038C0407,
      GPIO_226_OUTPUTXBAR1            = 0x038C0409,
      GPIO_226_SD1_C3                 = 0x038C040A,
      GPIO_226_SD1_D3                 = 0x038C040B,
      GPIO_226_ADCA_EXTMUXSEL2        = 0x038C040E,
      GPIO_226_ESC_GPO10              = 0x038C040F,
      
      GPIO_227_GPIO227                = 0x038C0600,
      GPIO_227_EPWM14_B               = 0x038C0601,
      GPIO_227_SPIA_CLK               = 0x038C0605,
      GPIO_227_OUTPUTXBAR4            = 0x038C0609,
      GPIO_227_SD2_C2                 = 0x038C060B,
      GPIO_227_ADCA_EXTMUXSEL3        = 0x038C060E,
      
      GPIO_228_GPIO228                = 0x038C0800,
      GPIO_228_EPWM18_A               = 0x038C0801,
      GPIO_228_EPWM13_A               = 0x038C0802,
      GPIO_228_SPIB_POCI              = 0x038C0805,
      GPIO_228_LINB_TX                = 0x038C0806,
      GPIO_228_OUTPUTXBAR1            = 0x038C0809,
      GPIO_228_SENT4                  = 0x038C080A,
      GPIO_228_SD2_D1                 = 0x038C080B,
      
      GPIO_229_GPIO229                = 0x038C0A00,
      GPIO_229_EPWM17_B               = 0x038C0A01,
      GPIO_229_EPWM12_B               = 0x038C0A02,
      GPIO_229_SPIB_PICO              = 0x038C0A05,
      GPIO_229_MCANA_RX               = 0x038C0A06,
      GPIO_229_SENT3                  = 0x038C0A0A,
      GPIO_229_SD1_C4                 = 0x038C0A0B,
      
      GPIO_166_AIO166                 = 0x028C0C00,
      GPIO_166_SD4_C1                 = 0x028C0C0B,
      
      GPIO_167_AIO167                 = 0x028C0E00,
      GPIO_167_SD4_D1                 = 0x028C0E0B,
      
      GPIO_168_AIO168                 = 0x028C1000,
      GPIO_168_SD3_C3                 = 0x028C100B,
      
      GPIO_169_AIO169                 = 0x028C1200,
      GPIO_169_SD3_D3                 = 0x028C120B,
      
      GPIO_170_AIO170                 = 0x028C1400,
      GPIO_170_SD3_C4                 = 0x028C140B,
      
      GPIO_171_AIO171                 = 0x028C1600,
      GPIO_171_SD3_D4                 = 0x028C160B,
      
      GPIO_172_AIO172                 = 0x028C1800,
      GPIO_172_SD1_C1                 = 0x028C180B,
      
      GPIO_173_AIO173                 = 0x028C1A00,
      GPIO_173_SD1_D1                 = 0x028C1A0B,
      
      GPIO_174_AIO174                 = 0x028C1C00,
      GPIO_174_SD2_C4                 = 0x028C1C0B,
      
      GPIO_175_AIO175                 = 0x028C1E00,
      GPIO_175_SD2_D4                 = 0x028C1E0B,
      
      GPIO_230_GPIO230                = 0x038C0C00,
      GPIO_230_EPWM11_A               = 0x038C0C01,
      GPIO_230_SYNCOUT                = 0x038C0C03,
      GPIO_230_I2CB_SCL               = 0x038C0C06,
      GPIO_230_OUTPUTXBAR3            = 0x038C0C09,
      GPIO_230_SD4_D1                 = 0x038C0C0B,
      GPIO_230_ADCB_EXTMUXSEL0        = 0x038C0C0E,
      
      GPIO_231_GPIO231                = 0x038C0E00,
      GPIO_231_EPWM10_B               = 0x038C0E01,
      GPIO_231_SPIA_PICO              = 0x038C0E05,
      GPIO_231_MCAND_RX               = 0x038C0E06,
      GPIO_231_OUTPUTXBAR2            = 0x038C0E09,
      GPIO_231_SD1_C3                 = 0x038C0E0B,
      GPIO_231_ADCB_EXTMUXSEL1        = 0x038C0E0E,
      
      GPIO_232_GPIO232                = 0x038C1000,
      GPIO_232_EPWM14_A               = 0x038C1001,
      GPIO_232_EPWM8_B                = 0x038C1002,
      GPIO_232_SPIA_POCI              = 0x038C1005,
      GPIO_232_OUTPUTXBAR3            = 0x038C1009,
      GPIO_232_SENT6                  = 0x038C100A,
      GPIO_232_SD3_D1                 = 0x038C100B,
      GPIO_232_ESC_PHY0_LINKSTATUS    = 0x038C100D,
      GPIO_232_ADCB_EXTMUXSEL2        = 0x038C100E,
      GPIO_232_ESC_GPO11              = 0x038C100F,
      
      GPIO_233_GPIO233                = 0x038C1200,
      GPIO_233_EPWM18_B               = 0x038C1201,
      GPIO_233_EPWM13_B               = 0x038C1202,
      GPIO_233_LINB_RX                = 0x038C1206,
      GPIO_233_OUTPUTXBAR2            = 0x038C1209,
      GPIO_233_SENT5                  = 0x038C120A,
      GPIO_233_SD2_C1                 = 0x038C120B,
      GPIO_233_ESC_PHY1_LINKSTATUS    = 0x038C120D,
      GPIO_233_ADCB_EXTMUXSEL3        = 0x038C120E,
      GPIO_233_ESC_GPO12              = 0x038C120F,
      
      GPIO_234_GPIO234                = 0x038C1400,
      GPIO_234_EPWM17_A               = 0x038C1401,
      GPIO_234_EPWM12_A               = 0x038C1402,
      GPIO_234_SPIB_PTE               = 0x038C1405,
      GPIO_234_MCANA_TX               = 0x038C1406,
      GPIO_234_SENT2                  = 0x038C140A,
      GPIO_234_SD1_D4                 = 0x038C140B,
      GPIO_234_ESC_GPO13              = 0x038C140F,
      
      GPIO_235_GPIO235                = 0x038C1600,
      GPIO_235_EPWM9_B                = 0x038C1601,
      GPIO_235_SPIB_CLK               = 0x038C1605,
      GPIO_235_MCANA_RX               = 0x038C1606,
      GPIO_235_SENT1                  = 0x038C160A,
      GPIO_235_SD1_C1                 = 0x038C160B,
      GPIO_235_ESC_GPO14              = 0x038C160F,
      
      GPIO_176_AIO176                 = 0x02900000,
      GPIO_176_SD4_C2                 = 0x0290000B,
      
      GPIO_177_AIO177                 = 0x02900200,
      GPIO_177_SD4_D2                 = 0x0290020B,
      
      GPIO_178_AIO178                 = 0x02900400,
      GPIO_178_SD4_C3                 = 0x0290040B,
      
      GPIO_179_AIO179                 = 0x02900600,
      GPIO_179_SD4_D3                 = 0x0290060B,
      
      GPIO_180_AIO180                 = 0x02900800,
      GPIO_180_SD1_C2                 = 0x0290080B,
      
      GPIO_181_AIO181                 = 0x02900A00,
      GPIO_181_SD1_D2                 = 0x02900A0B,
      
      GPIO_182_AIO182                 = 0x02900C00,
      GPIO_182_SD3_C1                 = 0x02900C0B,
      
      GPIO_183_AIO183                 = 0x02900E00,
      GPIO_183_SD3_D1                 = 0x02900E0B,
      
      GPIO_184_AIO184                 = 0x02901000,
      GPIO_184_SD3_C2                 = 0x0290100B,
      
      GPIO_185_AIO185                 = 0x02901200,
      GPIO_185_SD3_D2                 = 0x0290120B,
      
      GPIO_236_GPIO236                = 0x038C1800,
      GPIO_236_EPWM12_B               = 0x038C1801,
      GPIO_236_EPWM8_A                = 0x038C1802,
      GPIO_236_LINA_RX                = 0x038C1806,
      GPIO_236_OUTPUTXBAR6            = 0x038C1809,
      GPIO_236_SD4_C2                 = 0x038C180B,
      GPIO_236_ESC_I2C_SDA            = 0x038C180D,
      GPIO_236_ADCC_EXTMUXSEL0        = 0x038C180E,
      
      GPIO_237_GPIO237                = 0x038C1A00,
      GPIO_237_EPWM14_A               = 0x038C1A01,
      GPIO_237_EPWM8_B                = 0x038C1A02,
      GPIO_237_EPWM17_B               = 0x038C1A03,
      GPIO_237_LINA_TX                = 0x038C1A06,
      GPIO_237_I2CA_SDA               = 0x038C1A07,
      GPIO_237_OUTPUTXBAR7            = 0x038C1A09,
      GPIO_237_SD4_D3                 = 0x038C1A0B,
      GPIO_237_ESC_I2C_SCL            = 0x038C1A0D,
      GPIO_237_ADCC_EXTMUXSEL1        = 0x038C1A0E,
      
      GPIO_238_GPIO238                = 0x038C1C00,
      GPIO_238_EPWM15_B               = 0x038C1C01,
      GPIO_238_OUTPUTXBAR6            = 0x038C1C09,
      GPIO_238_SD1_D3                 = 0x038C1C0A,
      GPIO_238_SD2_C3                 = 0x038C1C0B,
      GPIO_238_ESC_SYNC0              = 0x038C1C0D,
      GPIO_238_ADCC_EXTMUXSEL2        = 0x038C1C0E,
      GPIO_238_ESC_GPO15              = 0x038C1C0F,
      
      GPIO_239_GPIO239                = 0x038C1E00,
      GPIO_239_EPWM16_B               = 0x038C1E01,
      GPIO_239_LINB_TX                = 0x038C1E06,
      GPIO_239_I2CA_SCL               = 0x038C1E07,
      GPIO_239_OUTPUTXBAR8            = 0x038C1E09,
      GPIO_239_SD2_C4                 = 0x038C1E0B,
      GPIO_239_ESC_SYNC1              = 0x038C1E0D,
      GPIO_239_ADCC_EXTMUXSEL3        = 0x038C1E0E,
      GPIO_239_ESC_GPO16              = 0x038C1E0F,
      
      GPIO_186_AIO186                 = 0x02901400,
      GPIO_186_SD1_C1                 = 0x0290140B,
      
      GPIO_187_AIO187                 = 0x02901600,
      GPIO_187_SD1_D1                 = 0x0290160B,
      
      GPIO_188_AIO188                 = 0x02901800,
      GPIO_188_SD1_C2                 = 0x0290180B,
      
      GPIO_189_AIO189                 = 0x02901A00,
      GPIO_189_SD1_D2                 = 0x02901A0B,
      
      GPIO_190_AIO190                 = 0x02901C00,
      GPIO_190_SD1_C3                 = 0x02901C0B,
      
      GPIO_191_AIO191                 = 0x02901E00,
      GPIO_191_SD1_D3                 = 0x02901E0B,
      
      GPIO_192_AIO192                 = 0x030C0000,
      GPIO_192_SD1_C3                 = 0x030C000B,
      
      GPIO_193_AIO193                 = 0x030C0200,
      GPIO_193_SD1_D3                 = 0x030C020B,
      
      GPIO_194_AIO194                 = 0x030C0400,
      GPIO_194_SD1_C4                 = 0x030C040B,
      
      GPIO_195_AIO195                 = 0x030C0600,
      GPIO_195_SD1_D4                 = 0x030C060B,
      
      GPIO_240_GPIO240                = 0x03900000,
      GPIO_240_EPWM14_B               = 0x03900001,
      GPIO_240_SPID_PICO              = 0x03900005,
      GPIO_240_SD4_C3                 = 0x0390000B,
      GPIO_240_ESC_LED_RUN            = 0x0390000D,
      GPIO_240_ADCD_EXTMUXSEL0        = 0x0390000E,
      
      GPIO_241_GPIO241                = 0x03900200,
      GPIO_241_EPWM8_A                = 0x03900201,
      GPIO_241_SPID_CLK               = 0x03900205,
      GPIO_241_SD4_D4                 = 0x0390020B,
      GPIO_241_ESC_LED_ERR            = 0x0390020D,
      GPIO_241_ADCD_EXTMUXSEL1        = 0x0390020E,
      GPIO_241_ESC_GPO17              = 0x0390020F,
      
      GPIO_242_GPIO242                = 0x03900400,
      GPIO_242_SD1_D4                 = 0x03900406,
      GPIO_242_I2CA_SDA               = 0x03900407,
      GPIO_242_OUTPUTXBAR9            = 0x03900409,
      GPIO_242_SENT1                  = 0x0390040A,
      GPIO_242_SD2_D2                 = 0x0390040B,
      GPIO_242_ESC_LED_STATE_RUN      = 0x0390040D,
      GPIO_242_ADCD_EXTMUXSEL2        = 0x0390040E,
      GPIO_242_ESC_GPO18              = 0x0390040F,
      
      GPIO_243_GPIO243                = 0x03900600,
      GPIO_243_EPWM8_B                = 0x03900601,
      GPIO_243_SENT2                  = 0x0390060A,
      GPIO_243_SD2_D4                 = 0x0390060B,
      GPIO_243_ESC_LED_LINK0_ACTIVE   = 0x0390060D,
      GPIO_243_ADCD_EXTMUXSEL3        = 0x0390060E,
      GPIO_243_ESC_GPO19              = 0x0390060F,
      
      GPIO_244_GPIO244                = 0x03900800,
      GPIO_244_SPIC_PTE               = 0x03900805,
      GPIO_244_SENT5                  = 0x0390080A,
      GPIO_244_SD4_C4                 = 0x0390080B,
      GPIO_244_ESC_LED_LINK1_ACTIVE   = 0x0390080D,
      
      GPIO_245_GPIO245                = 0x03900A00,
      GPIO_245_SPIC_POCI              = 0x03900A05,
      GPIO_245_SENT6                  = 0x03900A0A,
      GPIO_245_SD3_C1                 = 0x03900A0B,
      GPIO_245_ESC_PHY_RESETN         = 0x03900A0D,
      
      GPIO_196_AIO196                 = 0x030C0800,
      GPIO_196_SD4_C4                 = 0x030C080B,
      
      GPIO_197_AIO197                 = 0x030C0A00,
      GPIO_197_SD4_D4                 = 0x030C0A0B,
      
      GPIO_198_AIO198                 = 0x030C0C00,
      GPIO_198_SD1_C4                 = 0x030C0C0B,
      
      GPIO_199_AIO199                 = 0x030C0E00,
      GPIO_199_SD1_D4                 = 0x030C0E0B,
      
      GPIO_200_AIO200                 = 0x030C1000,
      GPIO_200_SD2_C1                 = 0x030C100B,
      
      GPIO_201_AIO201                 = 0x030C1200,
      GPIO_201_SD2_D1                 = 0x030C120B,
      
      GPIO_202_AIO202                 = 0x030C1400,
      GPIO_202_SD2_C1                 = 0x030C140B,
      
      GPIO_203_AIO203                 = 0x030C1600,
      GPIO_203_SD2_D1                 = 0x030C160B,
      
      GPIO_204_AIO204                 = 0x030C1800,
      GPIO_204_SD3_C3                 = 0x030C180B,
      
      GPIO_205_AIO205                 = 0x030C1A00,
      GPIO_205_SD3_D3                 = 0x030C1A0B,
      
      GPIO_246_GPIO246                = 0x03900C00,
      GPIO_246_EPWM16_A               = 0x03900C01,
      GPIO_246_SPID_PTE               = 0x03900C05,
      GPIO_246_MCANC_RX               = 0x03900C06,
      GPIO_246_OUTPUTXBAR7            = 0x03900C09,
      GPIO_246_SD1_D1                 = 0x03900C0B,
      GPIO_246_ADCE_EXTMUXSEL0        = 0x03900C0E,
      GPIO_246_ESC_GPO20              = 0x03900C0F,
      
      GPIO_247_GPIO247                = 0x03900E00,
      GPIO_247_EPWM15_A               = 0x03900E01,
      GPIO_247_ERRORSTS               = 0x03900E02,
      GPIO_247_SPID_POCI              = 0x03900E05,
      GPIO_247_MCANC_RX               = 0x03900E06,
      GPIO_247_LINA_TX                = 0x03900E07,
      GPIO_247_OUTPUTXBAR5            = 0x03900E09,
      GPIO_247_SD2_D3                 = 0x03900E0B,
      GPIO_247_ADCE_EXTMUXSEL1        = 0x03900E0E,
      GPIO_247_ESC_GPO21              = 0x03900E0F,
      
      GPIO_248_GPIO248                = 0x03901000,
      GPIO_248_EMIF1_SDCKE            = 0x03901002,
      GPIO_248_SPIC_PICO              = 0x03901005,
      GPIO_248_SENT3                  = 0x0390100A,
      GPIO_248_SD1_C2                 = 0x0390100B,
      GPIO_248_ESC_LED_RUN            = 0x0390100D,
      GPIO_248_ADCE_EXTMUXSEL2        = 0x0390100E,
      GPIO_248_ESC_GPO22              = 0x0390100F,
      
      GPIO_249_GPIO249                = 0x03901200,
      GPIO_249_SPIC_CLK               = 0x03901205,
      GPIO_249_SENT4                  = 0x0390120A,
      GPIO_249_SD1_D2                 = 0x0390120B,
      GPIO_249_ESC_PHY0_LINKSTATUS    = 0x0390120D,
      GPIO_249_ADCE_EXTMUXSEL3        = 0x0390120E,
      GPIO_249_ESC_GPO23              = 0x0390120F,
      
      GPIO_206_AIO206                 = 0x030C1C00,
      GPIO_206_SD3_C4                 = 0x030C1C0B,
      
      GPIO_207_AIO207                 = 0x030C1E00,
      GPIO_207_SD3_D4                 = 0x030C1E0B,
      
      GPIO_208_AIO208                 = 0x03100000,
      GPIO_208_SD2_C2                 = 0x0310000B,
      
      GPIO_209_AIO209                 = 0x03100200,
      GPIO_209_SD2_D2                 = 0x0310020B,
      
      GPIO_210_AIO210                 = 0x03100400,
      GPIO_210_SD2_C3                 = 0x0310040B,
      
      GPIO_211_AIO211                 = 0x03100600,
      GPIO_211_SD2_D3                 = 0x0310060B,
      
      GPIO_212_AIO212                 = 0x03100800,
      GPIO_212_SD2_C4                 = 0x0310080B,
      
      GPIO_213_AIO213                 = 0x03100A00,
      GPIO_213_SD2_D4                 = 0x03100A0B,
    }
    return pin_map[pin]
end

return P
